/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.oracle;

import com.metamatrix.connector.jdbc.extension.FunctionModifier;
import com.metamatrix.connector.jdbc.extension.impl.BasicFunctionModifier;
import com.metamatrix.connector.jdbc.extension.impl.DropFunctionModifier;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IScalarSubquery;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.metadata.runtime.Element;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.List;

public class OracleConvertModifier
extends BasicFunctionModifier
implements FunctionModifier {
    private static DropFunctionModifier DROP_MODIFIER = new DropFunctionModifier();
    private ILanguageFactory langFactory;
    private RuntimeMetadata metadata;
    private ConnectorLogger logger;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public OracleConvertModifier(ILanguageFactory langFactory, RuntimeMetadata metadata, ConnectorLogger logger) {
        this.langFactory = langFactory;
        this.metadata = metadata;
        this.logger = logger;
    }

    public List translate(IFunction function) {
        return null;
    }

    public IExpression modify(IFunction function) {
        IExpression[] args = function.getParameters();
        IExpression modified = null;
        if (args[0] != null && args[0] instanceof ILiteral && ((ILiteral)args[0]).getValue() == null && args[1] != null && args[1] instanceof ILiteral) {
            modified = this.convertNull(function);
            return modified;
        }
        if (args[1] != null && args[1] instanceof ILiteral) {
            String target = ((String)((ILiteral)args[1]).getValue()).toLowerCase();
            modified = target.equals("string") ? this.convertToString(function) : (target.equals("short") ? this.convertToShort(function) : (target.equals("integer") ? this.convertToInteger(function) : (target.equals("long") ? this.convertToLong(function) : (target.equals("biginteger") ? this.convertToBigInteger(function) : (target.equals("float") ? this.convertToFloat(function) : (target.equals("double") ? this.convertToDouble(function) : (target.equals("bigdecimal") ? this.convertToBigDecimal(function) : (target.equals("date") ? this.convertToDate(function) : (target.equals("time") ? this.convertToTime(function) : (target.equals("timestamp") ? this.convertToTimestamp(function) : (target.equals("char") ? this.convertToChar(function) : (target.equals("boolean") ? this.convertToBoolean(function) : (target.equals("byte") ? this.convertToByte(function) : DROP_MODIFIER.modify(function))))))))))))));
            return modified;
        }
        return DROP_MODIFIER.modify(function);
    }

    private IExpression convertNull(IFunction function) {
        IExpression convert = null;
        IExpression[] args = function.getParameters();
        String typeName = null;
        Class functionClass = null;
        String target = ((String)((ILiteral)args[1]).getValue()).toLowerCase();
        if (target.equals("string")) {
            convert = DROP_MODIFIER.modify(function);
        } else if (target.equals("short")) {
            typeName = "Number";
            functionClass = class$java$lang$Integer == null ? (class$java$lang$Integer = OracleConvertModifier.class$("java.lang.Integer")) : class$java$lang$Integer;
        } else if (target.equals("integer")) {
            typeName = "Number";
            functionClass = class$java$lang$Integer == null ? (class$java$lang$Integer = OracleConvertModifier.class$("java.lang.Integer")) : class$java$lang$Integer;
        } else if (target.equals("long")) {
            typeName = "Number";
            functionClass = class$java$lang$Integer == null ? (class$java$lang$Integer = OracleConvertModifier.class$("java.lang.Integer")) : class$java$lang$Integer;
        } else if (target.equals("biginteger")) {
            typeName = "Number";
            functionClass = class$java$lang$Integer == null ? (class$java$lang$Integer = OracleConvertModifier.class$("java.lang.Integer")) : class$java$lang$Integer;
        } else if (target.equals("float")) {
            typeName = "float";
            functionClass = class$java$lang$Float == null ? (class$java$lang$Float = OracleConvertModifier.class$("java.lang.Float")) : class$java$lang$Float;
        } else if (target.equals("double")) {
            typeName = "Number";
            functionClass = class$java$lang$Integer == null ? (class$java$lang$Integer = OracleConvertModifier.class$("java.lang.Integer")) : class$java$lang$Integer;
        } else if (target.equals("bigdecimal")) {
            typeName = "float";
            functionClass = class$java$lang$Float == null ? (class$java$lang$Float = OracleConvertModifier.class$("java.lang.Float")) : class$java$lang$Float;
        } else if (target.equals("date")) {
            typeName = "date";
            functionClass = class$java$sql$Date == null ? (class$java$sql$Date = OracleConvertModifier.class$("java.sql.Date")) : class$java$sql$Date;
        } else if (target.equals("time")) {
            typeName = "date";
            functionClass = class$java$sql$Time == null ? (class$java$sql$Time = OracleConvertModifier.class$("java.sql.Time")) : class$java$sql$Time;
        } else if (target.equals("timestamp")) {
            typeName = "date";
            functionClass = class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = OracleConvertModifier.class$("java.sql.Timestamp")) : class$java$sql$Timestamp;
        } else if (target.equals("char")) {
            convert = DROP_MODIFIER.modify(function);
        } else if (target.equals("boolean")) {
            typeName = "Number";
            functionClass = class$java$lang$Integer == null ? (class$java$lang$Integer = OracleConvertModifier.class$("java.lang.Integer")) : class$java$lang$Integer;
        } else if (target.equals("byte")) {
            typeName = "Number";
            functionClass = class$java$lang$Integer == null ? (class$java$lang$Integer = OracleConvertModifier.class$("java.lang.Integer")) : class$java$lang$Integer;
        } else {
            convert = DROP_MODIFIER.modify(function);
        }
        if (convert == null) {
            convert = this.langFactory.createFunction("cast", new IExpression[]{args[0], this.langFactory.createLiteral((Object)typeName, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String)}, functionClass);
        }
        return convert;
    }

    private IExpression convertToDate(IFunction function) {
        IExpression convert = null;
        IExpression[] args = function.getParameters();
        Class srcType = args[0].getType();
        int srcCode = this.getSrcCode(srcType);
        switch (srcCode) {
            case 0: {
                String format = "YYYY-MM-DD";
                convert = this.dateTypeHelper("to_date", new IExpression[]{args[0], this.langFactory.createLiteral((Object)format, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String)}, class$java$sql$Date == null ? (class$java$sql$Date = OracleConvertModifier.class$("java.sql.Date")) : class$java$sql$Date);
                break;
            }
            case 13: {
                convert = this.dateTypeHelper("trunc", new IExpression[]{args[0]}, class$java$sql$Date == null ? (class$java$sql$Date = OracleConvertModifier.class$("java.sql.Date")) : class$java$sql$Date);
                break;
            }
            default: {
                convert = DROP_MODIFIER.modify(function);
            }
        }
        return convert;
    }

    private IExpression convertToTime(IFunction function) {
        IExpression convert = null;
        IExpression[] args = function.getParameters();
        Class srcType = args[0].getType();
        String format = "YYYY-MM-DD HH24:MI:SS";
        int srcCode = this.getSrcCode(srcType);
        switch (srcCode) {
            case 0: {
                IFunction inner0 = this.langFactory.createFunction("to_char", new IExpression[]{args[0], this.langFactory.createLiteral((Object)"HH24:MI:SS", class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String)}, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String);
                IFunction prependedPart0 = this.langFactory.createFunction("||", new IExpression[]{this.langFactory.createLiteral((Object)"1970-01-01 ", class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String), inner0}, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String);
                convert = this.langFactory.createFunction("to_date", new IExpression[]{prependedPart0, this.langFactory.createLiteral((Object)format, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String)}, class$java$sql$Time == null ? (class$java$sql$Time = OracleConvertModifier.class$("java.sql.Time")) : class$java$sql$Time);
                break;
            }
            case 13: {
                IFunction inner = this.langFactory.createFunction("to_char", new IExpression[]{args[0], this.langFactory.createLiteral((Object)"FXYYYY-MM-DD HH24:MI:SS", class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String)}, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String);
                IFunction intermediate = this.langFactory.createFunction("substr", new IExpression[]{inner, this.langFactory.createLiteral((Object)new Integer(12), class$java$lang$Integer == null ? (class$java$lang$Integer = OracleConvertModifier.class$("java.lang.Integer")) : class$java$lang$Integer)}, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String);
                IFunction prependedPart = this.langFactory.createFunction("||", new IExpression[]{this.langFactory.createLiteral((Object)"1970-01-01 ", class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String), intermediate}, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String);
                convert = this.langFactory.createFunction("to_date", new IExpression[]{prependedPart, this.langFactory.createLiteral((Object)format, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String)}, class$java$sql$Time == null ? (class$java$sql$Time = OracleConvertModifier.class$("java.sql.Time")) : class$java$sql$Time);
                break;
            }
            default: {
                convert = DROP_MODIFIER.modify(function);
            }
        }
        return convert;
    }

    private IExpression convertToTimestamp(IFunction function) {
        IExpression convert = null;
        IExpression[] args = function.getParameters();
        Class srcType = args[0].getType();
        int srcCode = this.getSrcCode(srcType);
        String format = "YYYY-MM-DD HH24:MI:SS";
        switch (srcCode) {
            case 0: {
                format = "YYYY-MM-DD HH24:MI:SS.FF";
                convert = this.dateTypeHelper("to_timestamp", new IExpression[]{args[0], this.langFactory.createLiteral((Object)format, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String)}, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = OracleConvertModifier.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
                break;
            }
            case 11: 
            case 12: {
                IFunction inner = this.langFactory.createFunction("to_char", new IExpression[]{args[0], this.langFactory.createLiteral((Object)format, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String)}, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String);
                convert = this.langFactory.createFunction("to_timestamp", new IExpression[]{inner, this.langFactory.createLiteral((Object)format, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String)}, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = OracleConvertModifier.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
                break;
            }
            default: {
                convert = DROP_MODIFIER.modify(function);
            }
        }
        return convert;
    }

    private IExpression convertToChar(IFunction function) {
        return DROP_MODIFIER.modify(function);
    }

    /*
     * Unable to fully structure code
     */
    private IExpression convertToString(IFunction function) {
        convert = null;
        args = function.getParameters();
        format = null;
        dateTypeFound = false;
        srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 2: {
                convert = this.langFactory.createFunction("decode", new IExpression[]{args[0], this.langFactory.createLiteral((Object)new Integer(0), OracleConvertModifier.class$java$lang$Integer == null ? (OracleConvertModifier.class$java$lang$Integer = OracleConvertModifier.class$("java.lang.Integer")) : OracleConvertModifier.class$java$lang$Integer), this.langFactory.createLiteral((Object)"false", OracleConvertModifier.class$java$lang$String == null ? (OracleConvertModifier.class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : OracleConvertModifier.class$java$lang$String), this.langFactory.createLiteral((Object)new Integer(1), OracleConvertModifier.class$java$lang$Integer == null ? (OracleConvertModifier.class$java$lang$Integer = OracleConvertModifier.class$("java.lang.Integer")) : OracleConvertModifier.class$java$lang$Integer), this.langFactory.createLiteral((Object)"true", OracleConvertModifier.class$java$lang$String == null ? (OracleConvertModifier.class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : OracleConvertModifier.class$java$lang$String)}, OracleConvertModifier.class$java$lang$String == null ? (OracleConvertModifier.class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : OracleConvertModifier.class$java$lang$String);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                convert = this.createStringFunction(args[0]);
                break;
            }
            case 11: {
                format = "YYYY-MM-DD";
                convert = this.createStringFunction(args[0], format);
                break;
            }
            case 12: {
                format = "HH24:MI:SS";
                convert = this.createStringFunction(args[0], format);
                break;
            }
            case 13: {
                if (!(args[0] instanceof IElement)) ** GOTO lbl36
                element = (IElement)args[0];
                id = element.getMetadataID();
                rmd = this.metadata;
                try {
                    elemMetadata = (Element)rmd.getObject(id);
                    nativeType = elemMetadata.getNativeType();
                    if (nativeType != null && nativeType.equalsIgnoreCase("DATE")) {
                        dateTypeFound = true;
                    }
                    ** GOTO lbl56
                }
                catch (ConnectorException e) {
                    this.logger.logError(e.getMessage());
                }
                ** GOTO lbl56
lbl36:
                // 1 sources

                if (args[0] instanceof IScalarSubquery) {
                    scalar = (IScalarSubquery)args[0];
                    symList = scalar.getQuery().getSelect().getSelectSymbols();
                    iter = symList.iterator();
                    while (iter.hasNext()) {
                        symObj = (ISelectSymbol)iter.next();
                        expObj = symObj.getExpression();
                        if (!(expObj instanceof IElement)) continue;
                        element = (IElement)expObj;
                        id = element.getMetadataID();
                        rmd = this.metadata;
                        try {
                            elemMetadata = (Element)rmd.getObject(id);
                            nativeType = elemMetadata.getNativeType();
                            if (nativeType == null || !nativeType.equalsIgnoreCase("DATE")) continue;
                            dateTypeFound = true;
                        }
                        catch (ConnectorException e) {
                            this.logger.logError(e.getMessage());
                        }
                    }
                }
lbl56:
                // 6 sources

                format = dateTypeFound != false ? "YYYY-MM-DD HH24:MI:SS" : "YYYY-MM-DD HH24:MI:SS.FF";
                convert = this.createStringFunction(args[0], format);
                break;
            }
            default: {
                convert = OracleConvertModifier.DROP_MODIFIER.modify(function);
            }
        }
        return convert;
    }

    private IExpression convertToBoolean(IFunction function) {
        IFunction convert = null;
        int srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 0: {
                convert = this.booleanHelper(function);
                break;
            }
            default: {
                convert = DROP_MODIFIER.modify(function);
            }
        }
        return convert;
    }

    private IExpression convertToByte(IFunction function) {
        IExpression convert = null;
        int srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 0: {
                convert = this.stringSrcHelper(function);
                break;
            }
            default: {
                convert = DROP_MODIFIER.modify(function);
            }
        }
        return convert;
    }

    private IExpression convertToShort(IFunction function) {
        IExpression convert = null;
        int srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 0: {
                convert = this.stringSrcHelper(function);
                break;
            }
            default: {
                convert = DROP_MODIFIER.modify(function);
            }
        }
        return convert;
    }

    private IExpression convertToInteger(IFunction function) {
        IExpression convert = null;
        int srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 0: {
                convert = this.stringSrcHelper(function);
                break;
            }
            default: {
                convert = DROP_MODIFIER.modify(function);
            }
        }
        return convert;
    }

    private IExpression convertToLong(IFunction function) {
        IExpression convert = null;
        int srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 0: {
                convert = this.stringSrcHelper(function);
                break;
            }
            default: {
                convert = DROP_MODIFIER.modify(function);
            }
        }
        return convert;
    }

    private IExpression convertToBigInteger(IFunction function) {
        IExpression convert = null;
        int srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 0: {
                convert = this.stringSrcHelper(function);
                break;
            }
            default: {
                convert = DROP_MODIFIER.modify(function);
            }
        }
        return convert;
    }

    private IExpression convertToFloat(IFunction function) {
        IExpression convert = null;
        int srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 0: {
                convert = this.stringSrcHelper(function);
                break;
            }
            default: {
                convert = DROP_MODIFIER.modify(function);
            }
        }
        return convert;
    }

    private IExpression convertToDouble(IFunction function) {
        IExpression convert = null;
        int srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 0: {
                convert = this.stringSrcHelper(function);
                break;
            }
            default: {
                convert = DROP_MODIFIER.modify(function);
            }
        }
        return convert;
    }

    private IExpression convertToBigDecimal(IFunction function) {
        IExpression convert = null;
        int srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 0: {
                convert = this.stringSrcHelper(function);
                break;
            }
            default: {
                convert = DROP_MODIFIER.modify(function);
            }
        }
        return convert;
    }

    private IFunction dateTypeHelper(String functionName, IExpression[] args, Class target) {
        IFunction convert = this.langFactory.createFunction(functionName, args, target);
        return convert;
    }

    private IFunction booleanHelper(IFunction function) {
        IExpression[] args = function.getParameters();
        IExpression[] modified = new IExpression[]{args[0], this.langFactory.createLiteral((Object)"true", class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String), this.langFactory.createLiteral((Object)new Byte(1), class$java$lang$Byte == null ? (class$java$lang$Byte = OracleConvertModifier.class$("java.lang.Byte")) : class$java$lang$Byte), this.langFactory.createLiteral((Object)"false", class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String), this.langFactory.createLiteral((Object)new Byte(0), class$java$lang$Byte == null ? (class$java$lang$Byte = OracleConvertModifier.class$("java.lang.Byte")) : class$java$lang$Byte)};
        return this.langFactory.createFunction("decode", modified, class$java$lang$Boolean == null ? (class$java$lang$Boolean = OracleConvertModifier.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    private IExpression stringSrcHelper(IFunction function) {
        IExpression convert = null;
        IExpression[] args = function.getParameters();
        String functionName = "to_number";
        int targetCode = this.getTargetCode(function.getType());
        switch (targetCode) {
            case 3: {
                convert = this.createFunction(functionName, args[0], class$java$lang$Byte == null ? (class$java$lang$Byte = OracleConvertModifier.class$("java.lang.Byte")) : class$java$lang$Byte);
                break;
            }
            case 4: {
                convert = this.createFunction(functionName, args[0], class$java$lang$Short == null ? (class$java$lang$Short = OracleConvertModifier.class$("java.lang.Short")) : class$java$lang$Short);
                break;
            }
            case 5: {
                convert = this.createFunction(functionName, args[0], class$java$lang$Integer == null ? (class$java$lang$Integer = OracleConvertModifier.class$("java.lang.Integer")) : class$java$lang$Integer);
                break;
            }
            case 6: {
                convert = this.createFunction(functionName, args[0], class$java$lang$Long == null ? (class$java$lang$Long = OracleConvertModifier.class$("java.lang.Long")) : class$java$lang$Long);
                break;
            }
            case 7: {
                convert = this.createFunction(functionName, args[0], class$java$math$BigInteger == null ? (class$java$math$BigInteger = OracleConvertModifier.class$("java.math.BigInteger")) : class$java$math$BigInteger);
                break;
            }
            case 8: {
                convert = this.createFunction(functionName, args[0], class$java$lang$Float == null ? (class$java$lang$Float = OracleConvertModifier.class$("java.lang.Float")) : class$java$lang$Float);
                break;
            }
            case 9: {
                convert = this.createFunction(functionName, args[0], class$java$lang$Double == null ? (class$java$lang$Double = OracleConvertModifier.class$("java.lang.Double")) : class$java$lang$Double);
                break;
            }
            case 10: {
                convert = this.createFunction(functionName, args[0], class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = OracleConvertModifier.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
                break;
            }
            default: {
                convert = DROP_MODIFIER.modify(function);
            }
        }
        return convert;
    }

    private IFunction createFunction(String functionName, IExpression args0, Class targetClass) {
        IFunction created = this.langFactory.createFunction(functionName, new IExpression[]{args0}, targetClass);
        return created;
    }

    private IFunction createStringFunction(IExpression args0, String format) {
        IFunction created = this.langFactory.createFunction("to_char", new IExpression[]{args0, this.langFactory.createLiteral((Object)format, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String)}, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String);
        return created;
    }

    private IFunction createStringFunction(IExpression args) {
        IFunction created = this.langFactory.createFunction("to_char", new IExpression[]{args}, class$java$lang$String == null ? (class$java$lang$String = OracleConvertModifier.class$("java.lang.String")) : class$java$lang$String);
        return created;
    }

    private int getSrcCode(IFunction function) {
        IExpression[] args = function.getParameters();
        Class srcType = args[0].getType();
        return (Integer)typeMap.get(srcType);
    }

    private int getSrcCode(Class source) {
        return (Integer)typeMap.get(source);
    }

    private int getTargetCode(Class target) {
        return (Integer)typeMap.get(target);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

