/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc;

import com.ddtek.jdbc.extensions.ExtEmbeddedConnection;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.jdbcx.base.BaseDataSource;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.StringCharacterIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;

public class JDBCUtil {
    public static final String DRIVER = "com.metamatrix.common.util.JDBCUtil.Driver";
    public static final String PROTOCOL = "com.metamatrix.common.util.JDBCUtil.Protocol";
    public static final String DATABASE = "com.metamatrix.common.util.JDBCUtil.Database";
    public static final String USERNAME = "com.metamatrix.common.util.JDBCUtil.User";
    public static final String PASSWORD = "com.metamatrix.common.util.JDBCUtil.Password";
    private static final String JDBC_PREFIX = "jdbc:";
    private static final String DRIVER_PWD_PROP_NAME = "password";
    private static final String DRIVER_USER_PROP_NAME = "user";
    private static final String XADRIVER_PORT_NUMBER = "portNumber";
    private static final String XADRIVER_SERVER_NAME = "serverName";
    private static final String XADRIVER_DATABASE_NAME = "databaseName";
    private static final String OEM_ID = "mm";
    static /* synthetic */ Class class$java$lang$String;

    public static Connection decryptAndCreateJDBCConnection(Properties env) throws MetaMatrixException, SQLException {
        Properties jdbcEnv;
        try {
            jdbcEnv = CryptoUtil.propertyDecrypt((String)PASSWORD, (Properties)env);
        }
        catch (CryptoException e) {
            throw new MetaMatrixException((Throwable)e, "ERR.003.030.0175", CommonPlugin.Util.getString("ERR.003.030.0175"));
        }
        return JDBCUtil.createJDBCConnection(jdbcEnv);
    }

    public static Connection createJDBCConnection(Properties env) throws MetaMatrixException, SQLException {
        Connection connection = null;
        String driverClassName = env.getProperty(DRIVER);
        String protocol = env.getProperty(PROTOCOL);
        String database = env.getProperty(DATABASE);
        String username = env.getProperty(USERNAME);
        String password = env.getProperty(PASSWORD, "");
        if (driverClassName == null || driverClassName.trim().length() == 0) {
            throw new MetaMatrixException("ERR.003.030.0176", CommonPlugin.Util.getString("ERR.003.030.0176"));
        }
        if (database == null || database.trim().length() == 0) {
            throw new MetaMatrixException("ERR.003.030.0178", CommonPlugin.Util.getString("ERR.003.030.0178"));
        }
        String url = null;
        if (database.startsWith(JDBC_PREFIX) && (protocol == null || protocol.trim().length() == 0)) {
            url = database;
        } else {
            if (protocol == null || protocol.trim().length() == 0) {
                throw new MetaMatrixException("ERR.003.030.0177", CommonPlugin.Util.getString("ERR.003.030.0177"));
            }
            url = JDBCUtil.getDatabaseURL(env);
        }
        Properties props = new Properties();
        if (username != null && username.trim().length() > 0) {
            props.setProperty(DRIVER_USER_PROP_NAME, username.trim());
            props.setProperty(DRIVER_PWD_PROP_NAME, password.trim());
        }
        try {
            Driver driver = null;
            try {
                driver = (Driver)Class.forName(driverClassName).newInstance();
            }
            catch (Exception e) {
                throw new MetaMatrixException((Throwable)e, "ERR.003.030.0179", CommonPlugin.Util.getString("ERR.003.030.0179", (Object)driverClassName));
            }
            if (!driver.acceptsURL(url)) {
                throw new MetaMatrixException("ERR.003.030.0180", CommonPlugin.Util.getString("ERR.003.030.0180", (Object)driverClassName, (Object)url));
            }
            connection = driver.connect(url, props);
            if (connection instanceof ExtEmbeddedConnection) {
                ((ExtEmbeddedConnection)connection).unlock(OEM_ID);
            }
        }
        catch (Exception e) {
            throw new MetaMatrixException((Throwable)e, "ERR.003.030.0181", CommonPlugin.Util.getString("ERR.003.030.0181", (Object)url));
        }
        return connection;
    }

    public static Connection createJDBCXAConnection(Properties env) throws MetaMatrixException, SQLException {
        Connection connection = null;
        String driverClassName = env.getProperty(DRIVER);
        String protocol = env.getProperty(PROTOCOL);
        String database = env.getProperty(DATABASE);
        String username = env.getProperty(USERNAME);
        String password = env.getProperty(PASSWORD, "");
        if (driverClassName == null || driverClassName.trim().length() == 0) {
            throw new MetaMatrixException("ERR.003.030.0176", CommonPlugin.Util.getString("ERR.003.030.0176"));
        }
        if (database == null || database.trim().length() == 0) {
            throw new MetaMatrixException("ERR.003.030.0178", CommonPlugin.Util.getString("ERR.003.030.0178"));
        }
        String dbUrl = null;
        if (database.startsWith(JDBC_PREFIX) && (protocol == null || protocol.trim().length() == 0)) {
            dbUrl = database;
        } else {
            if (protocol == null || protocol.trim().length() == 0) {
                throw new MetaMatrixException("ERR.003.030.0177", CommonPlugin.Util.getString("ERR.003.030.0177"));
            }
            dbUrl = JDBCUtil.getDatabaseURL(env);
        }
        Properties props = new Properties();
        if (username != null && username.trim().length() > 0) {
            props.setProperty(DRIVER_USER_PROP_NAME, username.trim());
            props.setProperty(DRIVER_PWD_PROP_NAME, password.trim());
        }
        Object dsClass = null;
        try {
            dsClass = Class.forName(driverClassName).newInstance();
        }
        catch (Exception e) {
            throw new MetaMatrixException((Throwable)e, "Unable to load the JDBC driver class " + driverClassName);
        }
        if (dsClass instanceof BaseDataSource) {
            BaseDataSource baseDS = dsClass;
            JDBCUtil.parseURL(dbUrl, props);
            JDBCUtil.setDSProperties(props, (DataSource)baseDS);
            try {
                connection = baseDS.getConnection();
            }
            catch (Exception e) {
                throw new MetaMatrixException((Throwable)e, "Error getting connection");
            }
        } else {
            throw new MetaMatrixException("Driver class is not of type BaseDataSource");
        }
        return connection;
    }

    public static String getDatabaseURL(Properties env) {
        return JDBC_PREFIX + env.getProperty(PROTOCOL) + ":" + env.getProperty(DATABASE);
    }

    public static String getDatabaseURL(String protocol, String database) {
        return JDBC_PREFIX + protocol + ":" + database;
    }

    private static void parseURL(String url, Properties connectionProps) {
        List urlParts = StringUtil.split((String)url, (String)";");
        List protoHost = StringUtil.split((String)((String)urlParts.get(0)), (String)"//");
        List hostPort = StringUtil.split((String)((String)protoHost.get(1)), (String)":");
        connectionProps.setProperty(XADRIVER_SERVER_NAME, (String)hostPort.get(0));
        connectionProps.setProperty(XADRIVER_PORT_NUMBER, (String)hostPort.get(1));
        for (int i = 1; i < urlParts.size(); ++i) {
            String nameVal = (String)urlParts.get(i);
            List aProp = StringUtil.split((String)nameVal, (String)"=");
            if (aProp.size() <= 1) continue;
            String propName = (String)aProp.get(0);
            if (propName.equalsIgnoreCase(XADRIVER_DATABASE_NAME)) {
                connectionProps.setProperty(XADRIVER_DATABASE_NAME, (String)aProp.get(1));
                continue;
            }
            connectionProps.setProperty(propName.toLowerCase(), (String)aProp.get(1));
        }
    }

    private static void setDSProperties(Properties props, DataSource dataSource) throws MetaMatrixException {
        Properties connProps = JDBCUtil.lowerCaseAllPropNames(props);
        Method[] methods = dataSource.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String propertyName;
            String propertyValue;
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1 || (propertyValue = (String)connProps.get((propertyName = methodName.substring(3)).toLowerCase())) == null) continue;
            Class<?> argType = method.getParameterTypes()[0];
            Object[] params = new Object[1];
            if (argType == Integer.TYPE) {
                params[0] = Integer.decode(propertyValue);
            } else if (argType == Boolean.TYPE) {
                params[0] = Boolean.valueOf(propertyValue);
            } else if (argType == (class$java$lang$String == null ? JDBCUtil.class$("java.lang.String") : class$java$lang$String)) {
                params[0] = propertyValue;
            }
            try {
                method.invoke((Object)dataSource, params);
                continue;
            }
            catch (Throwable e) {
                Object[] msgParams = new Object[]{propertyName, propertyValue};
                String msg = CommonPlugin.Util.getString("ERR.003.030.0184", msgParams);
                throw new MetaMatrixException("ERR.003.030.0184", msg);
            }
        }
    }

    private static Properties lowerCaseAllPropNames(Properties connectionProps) {
        Properties lcProps = new Properties();
        Iterator<Object> itr = connectionProps.keySet().iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            Object propValue = connectionProps.get(name);
            if (!(propValue instanceof String)) continue;
            lcProps.setProperty(name.toLowerCase(), (String)propValue);
        }
        return lcProps;
    }

    public static void addAsLiteral(StringBuffer sb, Object value) {
        if (value == null) {
            sb.append("NULL");
        } else if (value instanceof Number) {
            JDBCUtil.addAsLiteral(sb, (Number)value);
        } else if (value instanceof Boolean) {
            JDBCUtil.addAsLiteral(sb, (Boolean)value);
        } else if (value instanceof Timestamp) {
            JDBCUtil.addAsLiteral(sb, (Timestamp)value);
        } else if (value instanceof Time) {
            JDBCUtil.addAsLiteral(sb, (Time)value);
        } else if (value instanceof Date) {
            JDBCUtil.addAsLiteral(sb, (Date)value);
        } else {
            JDBCUtil.addAsLiteral(sb, value.toString());
        }
    }

    public static void addAsLiteral(StringBuffer sb, String value) {
        if (value == null) {
            sb.append("NULL");
        } else {
            sb.append('\'');
            StringCharacterIterator iter = new StringCharacterIterator(value);
            char c = iter.first();
            while (c != '\uffff') {
                if (c == '\'') {
                    sb.append('\'');
                }
                sb.append(c);
                c = iter.next();
            }
            sb.append('\'');
        }
    }

    public static void addAsLiteral(StringBuffer sb, String value, int maxColumnLength) {
        if (maxColumnLength < 0 || value == null) {
            sb.append("NULL");
        } else {
            sb.append('\'');
            String text = value;
            if (maxColumnLength != 0 && text.length() > maxColumnLength) {
                text = text.substring(0, maxColumnLength);
            }
            StringCharacterIterator iter = new StringCharacterIterator(text);
            char c = iter.first();
            while (c != '\uffff') {
                if (c == '\'') {
                    sb.append('\'');
                }
                sb.append(c);
                c = iter.next();
            }
            sb.append('\'');
        }
    }

    public static void addAsLiteral(StringBuffer sb, Number number) {
        if (number == null) {
            sb.append("NULL");
        } else {
            sb.append(number.toString());
        }
    }

    public static void addAsLiteral(StringBuffer sb, Boolean value) {
        if (value == null) {
            sb.append("NULL");
        } else {
            JDBCUtil.addAsLiteral(sb, (boolean)value);
        }
    }

    public static void addAsLiteral(StringBuffer sb, Time value) {
        if (value == null) {
            sb.append("NULL");
        } else {
            sb.append("{");
            sb.append("t ");
            sb.append("'");
            sb.append(value.toString());
            sb.append("'");
            sb.append("}");
        }
    }

    public static void addAsLiteral(StringBuffer sb, Timestamp value) {
        if (value == null) {
            sb.append("NULL");
        } else {
            sb.append("{");
            sb.append("ts ");
            sb.append("'");
            sb.append(value.toString());
            sb.append("'");
            sb.append("}");
        }
    }

    public static void addAsLiteral(StringBuffer sb, Date value) {
        if (value == null) {
            sb.append("NULL");
        } else {
            sb.append("{");
            sb.append("d ");
            sb.append("'");
            sb.append(value.toString());
            sb.append("'");
            sb.append("}");
        }
    }

    public static void addAsLiteral(StringBuffer sb, boolean value) {
        sb.append('\'');
        sb.append(value ? (char)'1' : '0');
        sb.append('\'');
    }

    public static void addAsLikeLiteral(StringBuffer sb, String value, char escapeCharacter) {
        JDBCUtil.addAsLiteral(sb, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        Properties env = new Properties();
        env.setProperty(DRIVER, "weblogic.jdbc.mssqlserver4.Driver");
        env.setProperty(PROTOCOL, "weblogic:mssqlserver4");
        env.setProperty(DATABASE, "Metadata@slnt1dv02");
        env.setProperty(USERNAME, "metadatauser");
        env.setProperty(PASSWORD, "metadatauser");
        Connection connection = null;
        System.out.print("Attempting to connect to database \"" + JDBCUtil.getDatabaseURL(env) + "\" ...");
        connection = JDBCUtil.createJDBCConnection(env);
        System.out.print(" completed\n");
        Object var5_3 = null;
        if (connection == null) return;
        try {
            System.out.print("Closing connection to database ...");
            connection.close();
            System.out.print(" completed\n");
            return;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return;
        {
            catch (Exception e) {
                e.printStackTrace();
                Object var5_4 = null;
                if (connection == null) return;
                try {
                    System.out.print("Closing connection to database ...");
                    connection.close();
                    System.out.print(" completed\n");
                    return;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (connection == null) throw throwable;
            try {
                System.out.print("Closing connection to database ...");
                connection.close();
                System.out.print(" completed\n");
                throw throwable;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

