/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.diagram.ui.util;

import com.metamatrix.modeler.diagram.ui.DiagramUiConstants;
import com.metamatrix.modeler.diagram.ui.DiagramUiPlugin;
import com.metamatrix.modeler.diagram.ui.editor.DiagramEditor;
import com.metamatrix.modeler.diagram.ui.editor.DiagramViewer;
import com.metamatrix.modeler.diagram.ui.model.DiagramModelNode;
import com.metamatrix.modeler.diagram.ui.part.DiagramEditPart;
import com.metamatrix.modeler.diagram.ui.util.SaveDiagramHelper;
import com.metamatrix.modeler.ui.IDiagramTypeEditPart;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SaveDiagramHelper
implements DiagramUiConstants {
    private static final String FILE_DIALOG_TITLE = "SaveDiagramDialog.title";
    private static final long MAX_SAVEABLE_DIAGRAM_SIZE = 81000000L;
    private static final int COLOR_DEPTH = 16;

    public void saveDiagramToFile(DiagramEditor editor) {
        if (editor != null) {
            ImageLoader imageLoader = null;
            DiagramViewer viewer = editor.getDiagramViewer();
            List lstEditParts = viewer.getSelectedEditParts();
            imageLoader = lstEditParts.size() > 0 && this.selectionIsValid(lstEditParts) ? SaveDiagramHelper.createImageLoaderForSelection(editor, lstEditParts) : this.createImageLoaderForFullDiagram(editor);
            if (imageLoader == null) {
                return;
            }
            System.gc();
            this.saveThisImageFile(imageLoader);
        }
    }

    private static boolean checkDiagramSize(Rectangle rect) {
        long lRectangleSize = rect.width * rect.height;
        if (lRectangleSize > 81000000L) {
            String sMessage = DiagramUiConstants.Util.getString("SaveDiagramWarningDialog1.message", 81000000L) + DiagramUiConstants.Util.getString("SaveDiagramWarningDialog2.message", lRectangleSize);
            MessageDialog.openWarning((Shell)SaveDiagramHelper.getShell(), (String)DiagramUiConstants.Util.getString("SaveDiagramWarningDialog.title"), (String)sMessage);
            return false;
        }
        return true;
    }

    protected static Shell getShell() {
        return DiagramUiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }

    private boolean selectionIsValid(List lstEditParts) {
        Object oEditPart;
        return lstEditParts.size() != 1 || !((oEditPart = lstEditParts.iterator().next()) instanceof IDiagramTypeEditPart);
    }

    private void saveThisImageFile(ImageLoader imageLoader) {
        String[] aryDisplayExtensions = new String[]{"*.jpg", "*.bmp"};
        String[] aryExactExtensions = new String[]{".jpg", ".bmp"};
        int[] aryConstants = new int[]{4, 0};
        Shell shell = DiagramUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dlg = new FileDialog(shell, 8196);
        dlg.setText(DiagramUiConstants.Util.getString(FILE_DIALOG_TITLE));
        dlg.setFilterExtensions(aryDisplayExtensions);
        String file = dlg.open();
        if (file != null) {
            String finalFileName = file;
            int iSelectedExtension = -1;
            for (int i = 0; i < aryExactExtensions.length; ++i) {
                if (!file.endsWith(aryExactExtensions[i])) continue;
                iSelectedExtension = i;
                break;
            }
            int iExtensionType = 4;
            if (iSelectedExtension != -1) {
                iExtensionType = aryConstants[iSelectedExtension];
            }
            String sFileName = finalFileName;
            int iSelectedExtensionType = iExtensionType;
            ImageLoader finalImageLoader = imageLoader;
            String sProgressMessage = DiagramUiConstants.Util.getString("SaveDiagramDialog.progressMessage");
            if (finalImageLoader != null) {
                1 op = new /* Unavailable Anonymous Inner Class!! */;
                try {
                    new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(false, true, (IRunnableWithProgress)op);
                }
                catch (InterruptedException e) {
                }
                catch (InvocationTargetException e) {
                    DiagramUiConstants.Util.log(e.getTargetException());
                }
                catch (Exception e) {
                    DiagramUiConstants.Util.log((Object)e.getMessage());
                }
            }
        }
    }

    public static Image createImageForSelection(DiagramEditor editor, List lstEditParts) {
        Rectangle rectSelection = SaveDiagramHelper.createRectangleForSelectedEditParts(lstEditParts);
        Image image = SaveDiagramHelper.createImageForSelection(editor, rectSelection);
        return image;
    }

    public static ImageLoader createImageLoaderForSelection(DiagramEditor editor, List lstEditParts) {
        Rectangle rectSelection = SaveDiagramHelper.createRectangleForSelectedEditParts(lstEditParts);
        Image image = SaveDiagramHelper.createImageForSelection(editor, rectSelection);
        return SaveDiagramHelper.createImageLoader(rectSelection, image);
    }

    public static Image createImageForSelection(DiagramEditor editor, Rectangle rectSelection) {
        Image image = null;
        DiagramViewer viewer = editor.getDiagramViewer();
        LayerManager lm = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure f = lm.getLayer((Object)"Printable Layers");
        Rectangle rectFullDiagram = f.getBounds();
        Display display = Display.getDefault();
        Image startingImage = null;
        ImageData scaledIData = null;
        System.gc();
        int iStartDiagramWidth = rectSelection.x + rectSelection.width;
        int iStartDiagramHeight = rectSelection.y + rectSelection.height;
        Rectangle rectSmallestRect = new Rectangle(0, 0, iStartDiagramWidth, iStartDiagramHeight);
        boolean bContinue = SaveDiagramHelper.checkDiagramSize(rectSmallestRect);
        if (!bContinue) {
            return image;
        }
        try {
            startingImage = new Image((Device)display, 10, 10);
            ImageData imageData = new ImageData(10, 10, 16, new PaletteData(255, 65280, 0xFF0000));
            scaledIData = imageData.scaledTo(iStartDiagramWidth, iStartDiagramHeight);
            startingImage = new Image((Device)display, scaledIData);
        }
        catch (Exception e) {
            DiagramUiConstants.Util.log((Object)e.getMessage());
        }
        GC gcStarting = new GC((Drawable)startingImage);
        SWTGraphics graphics = new SWTGraphics(gcStarting);
        f.paint((Graphics)graphics);
        gcStarting.setClipping(rectFullDiagram.x, rectFullDiagram.y, rectFullDiagram.width, rectFullDiagram.height);
        gcStarting.copyArea(rectSelection.x, rectSelection.y, rectSelection.width, rectSelection.height, 0, 0);
        Image finalImage = new Image((Device)display, rectSelection.width, rectSelection.height);
        GC gcFinal = new GC((Drawable)finalImage);
        gcFinal.drawImage(startingImage, 0, 0, rectSelection.width, rectSelection.height, 0, 0, rectSelection.width, rectSelection.height);
        gcStarting.dispose();
        gcFinal.dispose();
        graphics.dispose();
        startingImage.dispose();
        return finalImage;
    }

    public static ImageLoader createImageLoader(Rectangle rect, Image image) {
        ImageLoader imageLoader = null;
        imageLoader = new ImageLoader();
        imageLoader.logicalScreenWidth = rect.width;
        imageLoader.logicalScreenHeight = rect.height;
        imageLoader.data = new ImageData[]{image.getImageData()};
        return imageLoader;
    }

    public static Rectangle createRectangleForSelectedEditParts(List lstEditParts) {
        int iSmallestX = -1;
        int iLargestXPlusWidth = 0;
        int iSmallestY = -1;
        int iLargestYPlusHeight = 0;
        int iX = 0;
        int iWidth = 0;
        int iXPlusWidth = 0;
        int iY = 0;
        int iHeight = 0;
        int iYPlusHeight = 0;
        Iterator it = lstEditParts.iterator();
        while (it.hasNext()) {
            EditPart ep = (EditPart)it.next();
            if (!(ep instanceof DiagramEditPart)) continue;
            DiagramEditPart dep = (DiagramEditPart)ep;
            DiagramModelNode dmNode = (DiagramModelNode)dep.getModel();
            iX = dmNode.getX();
            iWidth = dmNode.getWidth();
            iXPlusWidth = iX + iWidth;
            iY = dmNode.getY();
            iHeight = dmNode.getHeight();
            iYPlusHeight = iY + iHeight;
            if (iSmallestX == -1 || iX < iSmallestX) {
                iSmallestX = iX;
            }
            if (iXPlusWidth > iLargestXPlusWidth) {
                iLargestXPlusWidth = iXPlusWidth;
            }
            if (iSmallestY == -1 || iY < iSmallestY) {
                iSmallestY = iY;
            }
            if (iYPlusHeight <= iLargestYPlusHeight) continue;
            iLargestYPlusHeight = iYPlusHeight;
        }
        int iFullWidth = iLargestXPlusWidth - iSmallestX;
        int iFullHeight = iLargestYPlusHeight - iSmallestY;
        Rectangle rect = new Rectangle(iSmallestX, iSmallestY, iFullWidth, iFullHeight);
        return rect;
    }

    private ImageLoader createImageLoaderForFullDiagram(DiagramEditor editor) {
        ImageLoader imageLoader = null;
        Image finalImage = null;
        DiagramViewer viewer = editor.getDiagramViewer();
        LayerManager lm = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure f = lm.getLayer((Object)"Printable Layers");
        Rectangle rectFullDiagram = f.getBounds();
        if (!SaveDiagramHelper.checkDiagramSize(rectFullDiagram)) {
            return imageLoader;
        }
        finalImage = SaveDiagramHelper.getImage(rectFullDiagram);
        GC graphicContext = new GC((Drawable)finalImage);
        SWTGraphics graphics = new SWTGraphics(graphicContext);
        f.paint((Graphics)graphics);
        imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{finalImage.getImageData()};
        imageLoader.logicalScreenHeight = rectFullDiagram.height;
        imageLoader.logicalScreenWidth = rectFullDiagram.width;
        graphicContext.dispose();
        graphics.dispose();
        finalImage.dispose();
        return imageLoader;
    }

    public static Image getImage(Rectangle rectFullDiagram) {
        Image image = null;
        boolean bContinue = SaveDiagramHelper.checkDiagramSize(rectFullDiagram);
        if (!bContinue) {
            return image;
        }
        Display display = Display.getDefault();
        System.gc();
        ImageData imageData = new ImageData(10, 10, 16, new PaletteData(255, 65280, 0xFF0000));
        ImageData scaledIData = imageData.scaledTo(rectFullDiagram.width, rectFullDiagram.height);
        image = new Image((Device)display, scaledIData);
        return image;
    }
}

