/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.validator;

import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.visitor.AggregateSymbolCollectorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import com.metamatrix.query.validator.AbstractValidationVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AggregateValidationVisitor
extends AbstractValidationVisitor {
    private boolean validateBelow = true;
    private Set groupSymbols;

    public AggregateValidationVisitor(List groupSymbols) {
        if (groupSymbols != null) {
            this.groupSymbols = new HashSet();
            Iterator i = groupSymbols.iterator();
            while (i.hasNext()) {
                Expression symbol = (Expression)i.next();
                if (symbol instanceof ExpressionSymbol) {
                    this.groupSymbols.add(((ExpressionSymbol)symbol).getExpression());
                    continue;
                }
                this.groupSymbols.add(symbol);
            }
        }
    }

    public void visit(AggregateSymbol obj) {
        String aggregateFunction;
        Collection nestedAggs;
        Expression aggExp = obj.getExpression();
        if (aggExp != null && (nestedAggs = AggregateSymbolCollectorVisitor.getAggregates((LanguageObject)aggExp, (boolean)true)).size() > 0) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0039", (Object)nestedAggs), nestedAggs);
        }
        if (((aggregateFunction = obj.getAggregateFunction()).equals("SUM") || aggregateFunction.equals("AVG")) && obj.getType() == null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0041", new Object[]{aggregateFunction, SQLStringVisitor.getSQLString((LanguageObject)obj)}), (LanguageObject)obj);
        }
        this.validateBelow = false;
    }

    public void visit(ElementSymbol obj) {
        this.validateSymbol((Expression)obj);
    }

    public void visit(ExpressionSymbol obj) {
        this.validateSymbol((Expression)obj);
    }

    public void visit(CaseExpression obj) {
        this.validateSymbol((Expression)obj);
    }

    public void visit(SearchedCaseExpression obj) {
        this.validateSymbol((Expression)obj);
    }

    public void visit(Function obj) {
        this.validateSymbol((Expression)obj);
    }

    private void validateSymbol(Expression symbol) {
        if (ElementCollectorVisitor.getElements((LanguageObject)symbol, (boolean)false).isEmpty()) {
            this.validateBelow = false;
            return;
        }
        if (this.groupSymbols == null) {
            if (symbol instanceof ElementSymbol) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0037", (Object)symbol), (LanguageObject)symbol);
            }
        } else if (!this.groupSymbols.contains(symbol)) {
            if (symbol instanceof ElementSymbol) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0038", (Object)symbol), (LanguageObject)symbol);
            }
        } else {
            this.validateBelow = false;
        }
    }

    public static void validate(LanguageObject obj, final AggregateValidationVisitor visitor) {
        PreOrderNavigator nav = new PreOrderNavigator((LanguageVisitor)visitor){
            private boolean validateBelow;

            protected void visitNode(LanguageObject obj) {
                if (this.validateBelow) {
                    super.visitNode(obj);
                }
            }

            protected void preVisitVisitor(LanguageObject obj) {
                super.preVisitVisitor(obj);
                this.validateBelow = visitor.validateBelow;
            }

            protected void postVisitVisitor(LanguageObject obj) {
                this.validateBelow = true;
            }
        };
        obj.acceptVisitor((LanguageVisitor)nav);
    }
}

