/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.relational.impl.custom;

import com.metamatrix.metamodels.relational.BaseTable;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.PrimaryKey;
import com.metamatrix.metamodels.relational.RelationalEntity;
import com.metamatrix.metamodels.relational.RelationalFactory;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.relational.util.RelationalTypeMapping;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.data.Request;
import com.metamatrix.modeler.jdbc.data.Results;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.jdbc.metadata.JdbcTable;
import com.metamatrix.modeler.jdbc.metadata.impl.GetAccessForeignKeysRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.GetIndexesRequest;
import com.metamatrix.modeler.jdbc.relational.ModelerJdbcRelationalConstants;
import com.metamatrix.modeler.jdbc.relational.impl.Context;
import com.metamatrix.modeler.jdbc.relational.impl.RelationalModelProcessorImpl;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;

public class ExcelModelProcessor
extends RelationalModelProcessorImpl {
    public ExcelModelProcessor() {
    }

    public ExcelModelProcessor(RelationalFactory factory) {
        super(factory);
    }

    public ExcelModelProcessor(RelationalFactory factory, RelationalTypeMapping mapping) {
        super(factory, mapping);
    }

    protected String computeNameInSource(RelationalEntity object, String name, JdbcNode node, Context context, boolean forced) {
        if (object instanceof Table && node instanceof JdbcTable && "Excel_Sheet".equals(((JdbcTable)node).getRemarks())) {
            return "[" + node.getName() + "$]";
        }
        return super.computeNameInSource(object, name, node, context, forced);
    }

    protected void createPrimaryKey(JdbcTable tableNode, Table table, Context context, List problems) throws JdbcException {
        if (!(table instanceof BaseTable)) {
            return;
        }
        boolean includeUniqueIndexes = context.getJdbcImportSettings().isIncludeUniqueIndexes();
        boolean includeForeignKeys = context.getJdbcImportSettings().isIncludeForeignKeys();
        if (!includeUniqueIndexes && !includeForeignKeys) {
            return;
        }
        try {
            Column column;
            Request request = tableNode.getRequest(GetIndexesRequest.NAME, false);
            Results results = request.getResults();
            Object[] rows = results.getRows();
            int numRows = results.getRowCount();
            if (numRows == 0) {
                return;
            }
            Map columnsByName = this.createColumnMapKeyedByNames(table);
            boolean hasPrimaryKey = false;
            String pkName = null;
            Column[] columns = new Column[numRows];
            for (int i = 0; i < numRows; ++i) {
                Object row = rows[i];
                pkName = results.getString(row, 5);
                if (pkName == null || !pkName.equalsIgnoreCase("PrimaryKey")) continue;
                String columnName = results.getString(row, 8);
                column = (Column)columnsByName.get(columnName = tableNode.getUnqualifiedName(columnName));
                if (column != null) {
                    short seqIndex = results.getShort(row, 7);
                    columns[seqIndex - 1] = column;
                }
                hasPrimaryKey = true;
            }
            if (!hasPrimaryKey) {
                return;
            }
            PrimaryKey primaryKey = super.getFactory().createPrimaryKey();
            primaryKey.setTable((BaseTable)table);
            if (pkName != null) {
                this.setNameAndNameInSource((RelationalEntity)primaryKey, pkName, (JdbcNode)tableNode, context);
            }
            EList keyColumns = primaryKey.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                column = columns[i];
                if (column == null) continue;
                keyColumns.add(column);
            }
        }
        catch (JdbcException e) {
            String msg = com.metamatrix.modeler.internal.jdbc.relational.ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Error_while_obtaining_primary_key_info") + e.getLocalizedMessage();
            Status status = new Status(4, ModelerJdbcRelationalConstants.PLUGIN_ID, 0, msg, (Throwable)e);
            problems.add(status);
        }
    }

    protected Request getForeignKeyRequest(JdbcTable tableNode, String name, boolean includeMetadata) throws JdbcException {
        return tableNode.getRequest(GetAccessForeignKeysRequest.NAME, false);
    }

    protected boolean checkExportedForeignKeysIfNoImportedForeignKeysFound() {
        return false;
    }
}

