/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.soap;

import com.metamatrix.connector.xml.http.DefaultTrustDeserializer;
import com.metamatrix.connector.xml.soap.Messages;
import com.metamatrix.connector.xml.soap.SOAPConnectorState;
import com.metamatrix.connector.xml.soap.SOAPDocBuilder;
import com.metamatrix.data.exception.ConnectorException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class DefaultSoapTrustDeserializer
extends DefaultTrustDeserializer {
    protected void updateCredentials(HttpClient client, HttpMethod method, String user, String password) throws ConnectorException {
        SOAPConnectorState state = (SOAPConnectorState)this.m_state;
        if (state.useHttpBasicAuth()) {
            super.updateCredentials(client, method, user, password);
        }
        if (state.isUseBasicAuth() || state.isUseWSSec()) {
            try {
                InputStream docStream = ((InputStreamRequestEntity)((PostMethod)method).getRequestEntity()).getContent();
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(docStream);
                Element soapEnvelope = doc.getRootElement();
                Element header = soapEnvelope.getChild("Header", SOAPDocBuilder.soapNSObj);
                if (header == null) {
                    header = new Element("Header", SOAPDocBuilder.soapNSObj);
                    soapEnvelope.addContent((Content)header);
                }
                if (state.isUseBasicAuth()) {
                    SOAPDocBuilder.addSoapBasicAuth(header, user, password);
                } else {
                    SOAPDocBuilder.addWSSecurityUserToken(header, user, password);
                }
                XMLOutputter out = new XMLOutputter();
                String updatedDoc = out.outputString(doc).trim();
                ((PostMethod)method).setRequestEntity((RequestEntity)new StringRequestEntity(updatedDoc));
            }
            catch (Exception e) {
                throw new ConnectorException((Throwable)e);
            }
        } else if (!state.useHttpBasicAuth()) {
            throw new ConnectorException(Messages.getString((String)"SOAPExecutor.bad.security.configuration"));
        }
    }
}

