/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.query.processor.relational.DependentSourceState;
import com.metamatrix.query.processor.relational.DependentValueSource;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.processor.relational.SortUtility;
import com.metamatrix.query.sql.lang.CollectionValueIterator;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.util.ValueIterator;
import com.metamatrix.query.sql.util.ValueIteratorSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DependentCriteriaProcessor {
    private static final int INITIAL = 1;
    private static final int SORT = 2;
    private static final int SET_PROCESSING = 3;
    private int maxSetSize;
    private RelationalNode dependentNode;
    private Criteria dependentCrit;
    private int phase = 1;
    private List sources;
    private LinkedHashMap dependentState;
    private LinkedList restartIndexes;
    private int currentIterator;
    private boolean hasNextCommand;

    public DependentCriteriaProcessor(int maxSetSize, RelationalNode dependentNode, Criteria dependentCriteria) {
        this.maxSetSize = maxSetSize;
        this.dependentNode = dependentNode;
        this.dependentCrit = dependentCriteria;
    }

    public void close() throws MetaMatrixComponentException {
        if (this.dependentState != null) {
            for (int i = 0; i < this.sources.size(); ++i) {
                DependentSourceState dss = (DependentSourceState)this.dependentState.get(this.sources.get(i));
                dss.close();
            }
        }
    }

    public void reset() {
        this.dependentState = null;
        this.phase = 1;
    }

    public Criteria prepareCriteria() throws MetaMatrixComponentException {
        if (this.phase == 1) {
            this.initializeDependentState();
            this.phase = 2;
        }
        if (this.phase == 2) {
            this.sortDependentSources();
            this.phase = 3;
        }
        if (!this.dependentState.isEmpty()) {
            this.replaceDependentValueIterators();
        }
        Criteria result = (Criteria)this.dependentCrit.clone();
        return result;
    }

    public void consumedCriteria() {
        int restartIndex;
        if (this.restartIndexes.isEmpty()) {
            return;
        }
        for (int i = restartIndex = ((Integer)this.restartIndexes.removeLast()).intValue(); i < this.sources.size(); ++i) {
            DependentSourceState dss = (DependentSourceState)this.dependentState.get(this.sources.get(i));
            for (int j = 0; j < dss.getDepedentSetStates().size(); ++j) {
                DependentSourceState.SetState state = (DependentSourceState.SetState)dss.getDepedentSetStates().get(j);
                state.replacement.clear();
            }
        }
        this.currentIterator = restartIndex;
    }

    private void initializeDependentState() throws MetaMatrixComponentException {
        List<DependentSourceState.SetState> sets;
        this.hasNextCommand = false;
        this.dependentState = new LinkedHashMap();
        this.currentIterator = 0;
        this.restartIndexes = new LinkedList();
        List queryCriteria = Criteria.separateCriteriaByAnd((Criteria)this.dependentCrit);
        Iterator<Object> i = queryCriteria.iterator();
        while (i.hasNext()) {
            Criteria criteria = (Criteria)i.next();
            Object source = null;
            if (criteria instanceof SetCriteria) {
                SetCriteria setCriteria = (SetCriteria)criteria;
                if (setCriteria.getNumberOfValues() <= this.maxSetSize) continue;
                source = new Object();
            } else {
                if (!(criteria instanceof DependentSetCriteria)) continue;
                source = ((DependentSetCriteria)criteria).getValueIteratorSource();
            }
            sets = (LinkedList<Criteria>)this.dependentState.get(source);
            if (sets == null) {
                sets = new LinkedList<Criteria>();
                this.dependentState.put(source, sets);
            }
            sets.add((DependentSourceState.SetState)criteria);
        }
        this.sources = new ArrayList(this.dependentState.keySet());
        i = this.dependentState.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            if (entry.getKey() instanceof DependentValueSource) {
                DependentValueSource dvs = (DependentValueSource)entry.getKey();
                sets = (List)entry.getValue();
                ArrayList<Expression> symbols = new ArrayList<Expression>(sets.size());
                for (int j = 0; j < sets.size(); ++j) {
                    DependentSetCriteria crit = (DependentSetCriteria)sets.get(j);
                    DependentSourceState.SetState state = new DependentSourceState.SetState();
                    state.valueExpression = crit.getValueExpression();
                    symbols.add(state.valueExpression);
                    sets.set(j, state);
                    crit.setValueIteratorSource((ValueIteratorSource)new SimpleValueIteratorSource(state.replacement));
                }
                TupleState dss = new TupleState(symbols, (TupleSource)dvs.getTupleSource(), dvs.getTupleSourceID());
                entry.setValue(dss);
                dss.setDependentSetStates(sets);
                continue;
            }
            List sets2 = (List)entry.getValue();
            SetCriteria crit = (SetCriteria)sets2.get(0);
            FixedState dss = new FixedState(crit);
            DependentSourceState.SetState state = new DependentSourceState.SetState();
            state.valueExpression = crit.getExpression();
            sets2.set(0, state);
            crit.setValues(state.replacement);
            entry.setValue(dss);
            dss.setDependentSetStates(sets2);
        }
    }

    private void sortDependentSources() throws BlockedException, MetaMatrixComponentException {
        DependentSourceState dss;
        int i;
        for (i = 0; i < this.sources.size(); ++i) {
            dss = (DependentSourceState)this.dependentState.get(this.sources.get(i));
            dss.sort();
        }
        for (i = 0; i < this.sources.size(); ++i) {
            dss = (DependentSourceState)this.dependentState.get(this.sources.get(i));
            dss.connectValueSource();
            for (int j = 0; j < dss.getDepedentSetStates().size(); ++j) {
                DependentSourceState.SetState setState = (DependentSourceState.SetState)dss.getDepedentSetStates().get(j);
                setState.valueIterator = dss.getValueIterator(setState);
            }
        }
    }

    private void replaceDependentValueIterators() throws MetaMatrixComponentException {
        while (this.currentIterator < this.sources.size()) {
            DependentSourceState dss = (DependentSourceState)this.dependentState.get(this.sources.get(this.currentIterator));
            boolean done = false;
            while (!done) {
                DependentSourceState.SetState state;
                int i;
                boolean isNull = false;
                boolean lessThanMax = true;
                for (i = 0; i < dss.getDepedentSetStates().size(); ++i) {
                    state = (DependentSourceState.SetState)dss.getDepedentSetStates().get(i);
                    if (state.nextValue == null && !state.isNull) {
                        if (state.valueIterator.hasNext()) {
                            state.nextValue = state.valueIterator.next();
                            state.isNull = state.nextValue == null;
                        } else {
                            state.valueIterator.reset();
                            done = true;
                            continue;
                        }
                    }
                    isNull |= state.isNull;
                    lessThanMax &= state.replacement.size() < this.maxSetSize;
                }
                if (done) {
                    if (this.restartIndexes.isEmpty() || (Integer)this.restartIndexes.getLast() != this.currentIterator) break;
                    this.restartIndexes.removeLast();
                    break;
                }
                if (lessThanMax || isNull) {
                    for (i = 0; i < dss.getDepedentSetStates().size(); ++i) {
                        state = (DependentSourceState.SetState)dss.getDepedentSetStates().get(i);
                        if (!isNull) {
                            state.replacement.add(state.nextValue);
                        }
                        state.nextValue = null;
                        state.isNull = false;
                    }
                    continue;
                }
                this.restartIndexes.add(new Integer(this.currentIterator));
                done = true;
            }
            ++this.currentIterator;
        }
        this.hasNextCommand = !this.restartIndexes.isEmpty();
    }

    protected boolean hasNextCommand() {
        return this.hasNextCommand;
    }

    private static final class SimpleValueIteratorSource
    implements ValueIteratorSource {
        private Collection values;

        public SimpleValueIteratorSource(Collection values) {
            this.values = values;
        }

        public ValueIterator getValueIterator(Expression valueExpression) {
            return new CollectionValueIterator(this.values);
        }

        public boolean isReady() {
            return true;
        }
    }

    private static final class FixedState
    implements DependentSourceState {
        private List dependentSetStates;
        private Collection values;

        public FixedState(SetCriteria crit) {
            this.values = new ArrayList(crit.getValues());
        }

        public void sort() throws BlockedException, MetaMatrixComponentException {
        }

        public void close() throws MetaMatrixComponentException {
        }

        public ValueIterator getValueIterator(DependentSourceState.SetState setState) {
            return new CollectionValueIterator(this.values);
        }

        public void connectValueSource() throws MetaMatrixComponentException {
        }

        public List getDepedentSetStates() {
            return this.dependentSetStates;
        }

        public void setDependentSetStates(List states) {
            this.dependentSetStates = states;
        }
    }

    class TupleState
    implements DependentSourceState {
        private SortUtility sortUtility;
        private TupleSourceID outputID;
        private List dependentSetStates;
        private DependentValueSource valueSource = new DependentValueSource();

        public TupleState(List sortSymbols, TupleSource ts, TupleSourceID tsID) throws MetaMatrixComponentException {
            ArrayList<Boolean> sortDirection = new ArrayList<Boolean>(sortSymbols.size());
            for (int i = 0; i < sortSymbols.size(); ++i) {
                sortDirection.add(OrderBy.ASC);
            }
            this.sortUtility = new SortUtility(tsID, ts.getSchema(), sortSymbols, sortDirection, true, DependentCriteriaProcessor.this.dependentNode.getBufferManager(), DependentCriteriaProcessor.this.dependentNode.getConnectionID());
        }

        public void sort() throws BlockedException, MetaMatrixComponentException {
            if (this.outputID == null) {
                this.outputID = this.sortUtility.sort();
            }
        }

        public void close() throws MetaMatrixComponentException {
            if (this.outputID != null) {
                try {
                    DependentCriteriaProcessor.this.dependentNode.getBufferManager().removeTupleSource(this.outputID);
                }
                catch (TupleSourceNotFoundException e) {
                    throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
                }
                this.outputID = null;
            }
        }

        public ValueIterator getValueIterator(DependentSourceState.SetState setState) {
            return this.valueSource.getValueIterator(setState.valueExpression);
        }

        public void connectValueSource() throws MetaMatrixComponentException {
            try {
                this.valueSource.setTupleSource(DependentCriteriaProcessor.this.dependentNode.getBufferManager().getTupleSource(this.outputID), this.outputID);
            }
            catch (TupleSourceNotFoundException err) {
                throw new MetaMatrixComponentException((Throwable)err);
            }
        }

        public List getDepedentSetStates() {
            return this.dependentSetStates;
        }

        public void setDependentSetStates(List states) {
            this.dependentSetStates = states;
        }
    }
}

