/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.eval.LookupEvaluator;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.relational.JoinStrategy;
import com.metamatrix.query.processor.relational.NestedLoopJoinStrategy;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.processor.relational.SourceState;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseJoinStrategy
implements JoinStrategy {
    public static final String HASH_JOIN_STRATEGY = "HASH JOIN";
    public static final String MERGE_JOIN_STRATEGY = "MERGE JOIN";
    public static final String NESTED_LOOP_JOIN_STRATEGY = "NESTED LOOP JOIN";
    public static final short STATE_JOIN_COMPLETE = 0;
    public static final short STATE_INITIALIZE = 1;
    protected short state = 1;
    static final short LEFT_SOURCE = 0;
    static final short RIGHT_SOURCE = 1;
    static final short ALL_SOURCES = 2;
    protected ProcessorDataManager dataManager;
    protected CommandContext context;
    protected BufferManager bufferManager;
    protected List rightOuterVals = null;
    protected List leftOuterVals = null;
    protected SourceState leftSource;
    protected SourceState rightSource;
    protected boolean isDependentJoin;
    protected JoinType joinType;
    private int numOutCols;
    protected boolean blockedOnAdvanceBatch = false;
    protected Criteria joinCriteria;
    protected Map combinedElementMap;

    public abstract List execute() throws MetaMatrixComponentException, MetaMatrixProcessingException;

    public void createSourceState(RelationalNode[] children, List leftExpressions, List rightExpressions, short source) {
        if (source == 2 || source == 0) {
            this.leftSource = new SourceState(children[0], this.createLookupMap(children[0].getElements()), leftExpressions);
        }
        if (source == 2 || source == 1) {
            this.rightSource = new SourceState(children[1], this.createLookupMap(children[1].getElements()), rightExpressions);
        }
    }

    public void initialize(ProcessorDataManager dataManager, CommandContext context, BufferManager bufferManager, JoinType joinType, boolean isDependentJoin) throws MetaMatrixComponentException {
        int i;
        this.dataManager = dataManager;
        this.context = context;
        this.bufferManager = bufferManager;
        this.isDependentJoin = isDependentJoin;
        this.joinType = joinType;
        this.numOutCols = this.leftSource.elements.size() + this.rightSource.elements.size();
        if (this.joinType.isOuter()) {
            this.rightOuterVals = new ArrayList(this.rightSource.elementMap.size());
            for (i = 0; i < this.rightSource.elementMap.size(); ++i) {
                this.rightOuterVals.add(null);
            }
        }
        if (this.joinType.equals((Object)JoinType.JOIN_FULL_OUTER)) {
            this.leftOuterVals = new ArrayList(this.leftSource.elementMap.size());
            for (i = 0; i < this.leftSource.elementMap.size(); ++i) {
                this.leftOuterVals.add(null);
            }
        }
    }

    public void reset() {
        this.close();
        this.state = 1;
        this.rightOuterVals = null;
        this.leftOuterVals = null;
        this.leftSource = null;
        this.rightSource = null;
        this.blockedOnAdvanceBatch = false;
    }

    public abstract Object clone();

    public short getState() {
        return this.state;
    }

    protected List[] readTupleAndProbe(SourceState source) throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        List nextTuple = null;
        List nextProbe = null;
        if (source.readState == 0) {
            nextTuple = this.nextTuple(source);
        }
        if (source.readState == 2) {
            nextTuple = source.blockedTuple;
            source.readState = 1;
            source.blockedTuple = null;
        }
        if (!(this instanceof NestedLoopJoinStrategy) && source.readState == 1 && nextTuple != null) {
            try {
                nextProbe = this.createProbe(nextTuple, source.expressions, source.elementMap);
            }
            catch (BlockedException e) {
                source.readState = (short)2;
                source.blockedTuple = nextTuple;
                throw e;
            }
        }
        if (source.readState != 3) {
            source.readState = 0;
        }
        return new List[]{nextTuple, nextProbe};
    }

    protected List nextTuple(SourceState source) throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        ++source.index;
        if (source.readFromTupleSource) {
            if (source.index <= source.tupleSourceRowCount) {
                source.readState = 1;
                return source.tupleSource.nextTuple();
            }
            source.readState = (short)3;
            return null;
        }
        if (source.batch == null || source.index > source.batch.getEndRow()) {
            if (source.batch != null && source.batch.getTerminationFlag()) {
                source.readState = (short)3;
            } else {
                try {
                    this.advanceBatch(source);
                    this.blockedOnAdvanceBatch = false;
                }
                catch (BlockedException e) {
                    --source.index;
                    this.blockedOnAdvanceBatch = true;
                    throw e;
                }
            }
        }
        if (source.batch != null && source.batch.getRowCount() > 0 && source.index <= source.batch.getEndRow()) {
            source.readState = 1;
            return source.batch.getTuple(source.index);
        }
        return null;
    }

    protected void advanceBatch(SourceState source) throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        block1: {
            do {
                source.batch = source.sourceNode.nextBatch();
                if (source.batch.getRowCount() > 0) break block1;
            } while (!source.batch.getTerminationFlag());
            source.readState = (short)3;
        }
    }

    protected List createProbe(List tuple, List expressions, Map elementMap) throws BlockedException, MetaMatrixComponentException {
        int numExpr = expressions.size();
        ArrayList<Object> newProbe = new ArrayList<Object>(numExpr);
        for (int i = 0; i < numExpr; ++i) {
            Expression expr = (Expression)expressions.get(i);
            try {
                Object val = ExpressionEvaluator.evaluate(expr, elementMap, tuple, (LookupEvaluator)this.dataManager, this.context);
                newProbe.add(val);
                continue;
            }
            catch (ExpressionEvaluationException e) {
                throw new MetaMatrixComponentException((Throwable)e);
            }
        }
        return newProbe;
    }

    protected List outputTuple(List leftTuple, List rightTuple) throws MetaMatrixComponentException {
        ArrayList combinedRow = new ArrayList(this.numOutCols);
        combinedRow.addAll(leftTuple);
        combinedRow.addAll(rightTuple);
        return combinedRow;
    }

    protected void loadDataIntoBuffer(SourceState source) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        block1: {
            if (source.readState == 3) break block1;
            do {
                this.advanceBatch(source);
                if (source.batch.getRowCount() <= 0) continue;
                this.bufferManager.addTupleBatch(source.tupleSourceID, source.batch);
            } while (!source.batch.getTerminationFlag());
            source.readState = (short)3;
            this.bufferManager.setStatus(source.tupleSourceID, 2);
        }
    }

    protected void setTupleSourceForRead(SourceState source) throws MetaMatrixComponentException {
        try {
            source.tupleSource = this.bufferManager.getTupleSource(source.tupleSourceID);
            source.tupleSourceRowCount = this.bufferManager.getRowCount(source.tupleSourceID);
        }
        catch (TupleSourceNotFoundException e) {
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
        source.index = 0;
        source.readFromTupleSource = true;
        source.readState = 0;
    }

    protected Map createLookupMap(List elements) {
        HashMap lookupMap = new HashMap();
        for (int i = 0; i < elements.size(); ++i) {
            Object element = elements.get(i);
            lookupMap.put(element, new Integer(i));
        }
        return lookupMap;
    }

    public void close() {
        if (this.bufferManager == null) {
            return;
        }
        try {
            if (this.leftSource != null && this.leftSource.tupleSourceID != null) {
                this.bufferManager.removeTupleSource(this.leftSource.tupleSourceID);
            }
            if (this.rightSource != null && this.rightSource.tupleSourceID != null) {
                this.bufferManager.removeTupleSource(this.rightSource.tupleSourceID);
            }
        }
        catch (MetaMatrixComponentException mce) {
        }
        catch (TupleSourceNotFoundException tupleSourceNotFoundException) {
            // empty catch block
        }
    }

    public void setCriteria(Criteria joinCriteria) {
        this.joinCriteria = joinCriteria;
    }
}

