/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BP1201
extends AssertionProcess
implements WSITag {
    private final BaseMessageValidator validator;

    public BP1201(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document doc;
        if (this.validator.isOneWayResponse(entryContext) || (doc = entryContext.getMessageEntryDocument()) == null) {
            this.result = "notApplicable";
        } else {
            Element root = doc.getDocumentElement();
            String ns = root.getNamespaceURI();
            String local = root.getLocalName();
            if (!ELEM_SOAP_ENVELOPE.getNamespaceURI().equals(ns)) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail("Root element has namespace: " + ns, entryContext);
            } else if (!ELEM_SOAP_ENVELOPE.getLocalPart().equals(local)) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail("Root element has local name: " + local, entryContext);
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

