/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.eval;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.CriteriaEvaluationException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.types.Sequencable;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.eval.LookupEvaluator;
import com.metamatrix.query.sql.lang.AbstractSetCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.ExistsCriteria;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.NotCriteria;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.util.ValueIterator;
import com.metamatrix.query.util.CommandContext;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CriteriaEvaluator {
    private static final char[] REGEX_RESERVED = new char[]{'$', '(', ')', '*', '.', '?', '[', '\\', ']', '^', '{', '|', '}'};
    private static final MatchCriteria.PatternTranslator LIKE_TO_REGEX = new MatchCriteria.PatternTranslator(".*", ".", REGEX_RESERVED, '\\');

    private CriteriaEvaluator() {
    }

    public static boolean evaluate(Criteria criteria, Map elements, List tuple) throws CriteriaEvaluationException, BlockedException, MetaMatrixComponentException {
        return CriteriaEvaluator.evaluate(criteria, elements, tuple, null, null);
    }

    public static Boolean evaluateTVL(Criteria criteria, Map elements, List tuple) throws CriteriaEvaluationException, BlockedException, MetaMatrixComponentException {
        return CriteriaEvaluator.evaluateTVL(criteria, elements, tuple, null, null);
    }

    public static boolean evaluate(Criteria criteria, Map elements, List tuple, LookupEvaluator dataMgr, CommandContext context) throws CriteriaEvaluationException, BlockedException, MetaMatrixComponentException {
        return Boolean.TRUE.equals(CriteriaEvaluator.evaluateTVL(criteria, elements, tuple, dataMgr, context));
    }

    public static Boolean evaluateTVL(Criteria criteria, Map elements, List tuple, LookupEvaluator dataMgr, CommandContext context) throws CriteriaEvaluationException, BlockedException, MetaMatrixComponentException {
        if (criteria instanceof CompoundCriteria) {
            return CriteriaEvaluator.evaluate((CompoundCriteria)criteria, elements, tuple, dataMgr, context);
        }
        if (criteria instanceof NotCriteria) {
            return CriteriaEvaluator.evaluate((NotCriteria)criteria, elements, tuple, dataMgr, context);
        }
        if (criteria instanceof CompareCriteria) {
            return CriteriaEvaluator.evaluate((CompareCriteria)criteria, elements, tuple, dataMgr, context);
        }
        if (criteria instanceof MatchCriteria) {
            return CriteriaEvaluator.evaluate((MatchCriteria)criteria, elements, tuple, dataMgr, context);
        }
        if (criteria instanceof AbstractSetCriteria) {
            return CriteriaEvaluator.evaluate((AbstractSetCriteria)criteria, elements, tuple, dataMgr, context);
        }
        if (criteria instanceof IsNullCriteria) {
            return CriteriaEvaluator.evaluate((IsNullCriteria)criteria, elements, tuple, dataMgr, context);
        }
        if (criteria instanceof SubqueryCompareCriteria) {
            return CriteriaEvaluator.evaluate((SubqueryCompareCriteria)criteria, elements, tuple, dataMgr, context);
        }
        if (criteria instanceof ExistsCriteria) {
            return CriteriaEvaluator.evaluate((ExistsCriteria)criteria, elements, tuple, dataMgr, context);
        }
        throw new CriteriaEvaluationException("ERR.015.006.0010", QueryPlugin.Util.getString("ERR.015.006.0010", (Object)criteria));
    }

    public static Boolean evaluate(CompoundCriteria criteria, Map elements, List tuple, LookupEvaluator dataMgr, CommandContext context) throws CriteriaEvaluationException, BlockedException, MetaMatrixComponentException {
        List subCrits = criteria.getCriteria();
        Iterator subCritIter = subCrits.iterator();
        if (criteria.getOperator() == 0) {
            Boolean result = Boolean.TRUE;
            while (subCritIter.hasNext()) {
                Criteria subCrit = (Criteria)subCritIter.next();
                Boolean value = CriteriaEvaluator.evaluateTVL(subCrit, elements, tuple, dataMgr, context);
                if (value == null) {
                    result = null;
                    continue;
                }
                if (value.booleanValue()) continue;
                return Boolean.FALSE;
            }
            return result;
        }
        Boolean result = Boolean.FALSE;
        while (subCritIter.hasNext()) {
            Criteria subCrit = (Criteria)subCritIter.next();
            Boolean value = CriteriaEvaluator.evaluateTVL(subCrit, elements, tuple, dataMgr, context);
            if (value == null) {
                result = null;
                continue;
            }
            if (!value.booleanValue()) continue;
            return Boolean.TRUE;
        }
        return result;
    }

    public static Boolean evaluate(NotCriteria criteria, Map elements, List tuple, LookupEvaluator dataMgr, CommandContext context) throws CriteriaEvaluationException, BlockedException, MetaMatrixComponentException {
        Criteria subCrit = criteria.getCriteria();
        Boolean result = CriteriaEvaluator.evaluateTVL(subCrit, elements, tuple, dataMgr, context);
        if (result == null) {
            return null;
        }
        if (result.booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean evaluate(CompareCriteria criteria, Map elements, List tuple, LookupEvaluator dataMgr, CommandContext context) throws CriteriaEvaluationException, BlockedException, MetaMatrixComponentException {
        Object leftValue = null;
        try {
            leftValue = ExpressionEvaluator.evaluate(criteria.getLeftExpression(), elements, tuple, dataMgr, context);
        }
        catch (ExpressionEvaluationException e) {
            throw new CriteriaEvaluationException((Throwable)e, "ERR.015.006.0011", QueryPlugin.Util.getString("ERR.015.006.0011", new Object[]{"left", criteria}));
        }
        if (leftValue == null) {
            return null;
        }
        Object rightValue = null;
        try {
            rightValue = ExpressionEvaluator.evaluate(criteria.getRightExpression(), elements, tuple, dataMgr, context);
        }
        catch (ExpressionEvaluationException e) {
            throw new CriteriaEvaluationException((Throwable)e, "ERR.015.006.0011", QueryPlugin.Util.getString("ERR.015.006.0011", new Object[]{"right", criteria}));
        }
        if (rightValue == null) {
            return null;
        }
        switch (criteria.getOperator()) {
            case 1: {
                return leftValue.equals(rightValue);
            }
            case 2: {
                return !leftValue.equals(rightValue);
            }
            case 3: {
                return CriteriaEvaluator.compareValues(leftValue, rightValue) < 0;
            }
            case 5: {
                return CriteriaEvaluator.compareValues(leftValue, rightValue) <= 0;
            }
            case 4: {
                return CriteriaEvaluator.compareValues(leftValue, rightValue) > 0;
            }
            case 6: {
                return CriteriaEvaluator.compareValues(leftValue, rightValue) >= 0;
            }
        }
        throw new CriteriaEvaluationException("ERR.015.006.0012", QueryPlugin.Util.getString("ERR.015.006.0012", criteria.getOperator()));
    }

    private static final int compareValues(Object leftValue, Object rightValue) {
        if (leftValue instanceof Comparable && rightValue instanceof Comparable) {
            return ((Comparable)leftValue).compareTo(rightValue);
        }
        return leftValue.toString().compareTo(rightValue.toString());
    }

    public static Boolean evaluate(MatchCriteria criteria, Map elements, List tuple, LookupEvaluator dataMgr, CommandContext context) throws CriteriaEvaluationException, BlockedException, MetaMatrixComponentException {
        boolean result = false;
        Object value = null;
        try {
            value = ExpressionEvaluator.evaluate(criteria.getLeftExpression(), elements, tuple, dataMgr, context);
        }
        catch (ExpressionEvaluationException e) {
            throw new CriteriaEvaluationException((Throwable)e, "ERR.015.006.0011", QueryPlugin.Util.getString("ERR.015.006.0011", new Object[]{"left", criteria}));
        }
        if (value == null) {
            return null;
        }
        CharSequence leftValue = null;
        if (value instanceof CharSequence) {
            leftValue = (CharSequence)value;
        } else {
            try {
                leftValue = ((Sequencable)value).getCharSequence();
            }
            catch (SQLException err) {
                throw new CriteriaEvaluationException((Throwable)err, err.getMessage());
            }
        }
        String rightValue = null;
        try {
            rightValue = (String)ExpressionEvaluator.evaluate(criteria.getRightExpression(), elements, tuple, dataMgr, context);
        }
        catch (ExpressionEvaluationException e) {
            throw new CriteriaEvaluationException((Throwable)e, "ERR.015.006.0011", QueryPlugin.Util.getString("ERR.015.006.0011", new Object[]{"right", criteria}));
        }
        if (rightValue == null) {
            return null;
        }
        result = CriteriaEvaluator.match(rightValue, criteria.getEscapeChar(), leftValue);
        return result ^ criteria.isNegated();
    }

    private static boolean match(String pattern, char escape, CharSequence search) throws CriteriaEvaluationException, MetaMatrixComponentException {
        StringBuffer rePattern = LIKE_TO_REGEX.translate(pattern, escape);
        rePattern.insert(0, '^');
        rePattern.append('$');
        try {
            Pattern patternRegex = Pattern.compile(rePattern.toString(), 32);
            Matcher matcher = patternRegex.matcher(search);
            return matcher.matches();
        }
        catch (PatternSyntaxException e) {
            throw new CriteriaEvaluationException((Throwable)e, "ERR.015.006.0014", QueryPlugin.Util.getString("ERR.015.006.0014", new Object[]{pattern, e.getMessage()}));
        }
    }

    public static Boolean evaluate(AbstractSetCriteria criteria, Map elements, List tuple, LookupEvaluator dataMgr, CommandContext context) throws CriteriaEvaluationException, BlockedException, MetaMatrixComponentException {
        Object leftValue = null;
        try {
            leftValue = ExpressionEvaluator.evaluate(criteria.getExpression(), elements, tuple, dataMgr, context);
        }
        catch (ExpressionEvaluationException e) {
            throw new CriteriaEvaluationException((Throwable)e, "ERR.015.006.0015", QueryPlugin.Util.getString("ERR.015.006.0015", (Object)criteria));
        }
        if (leftValue == null) {
            return null;
        }
        Boolean result = Boolean.FALSE;
        ValueIterator valueIter = criteria.getValueIterator();
        while (valueIter.hasNext()) {
            Object possibleValue = valueIter.next();
            Object value = null;
            if (possibleValue instanceof Expression) {
                try {
                    value = ExpressionEvaluator.evaluate((Expression)possibleValue, elements, tuple, dataMgr, context);
                }
                catch (ExpressionEvaluationException e) {
                    throw new CriteriaEvaluationException((Throwable)e, "ERR.015.006.0015", QueryPlugin.Util.getString("ERR.015.006.0015", possibleValue));
                }
            } else {
                value = possibleValue;
            }
            if (value != null) {
                if (!leftValue.equals(value)) continue;
                return !criteria.isNegated();
            }
            result = null;
        }
        if (result == null) {
            return null;
        }
        return criteria.isNegated();
    }

    public static boolean evaluate(IsNullCriteria criteria, Map elements, List tuple, LookupEvaluator dataMgr, CommandContext context) throws CriteriaEvaluationException, BlockedException, MetaMatrixComponentException {
        Object value = null;
        try {
            value = ExpressionEvaluator.evaluate(criteria.getExpression(), elements, tuple, dataMgr, context);
        }
        catch (ExpressionEvaluationException e) {
            throw new CriteriaEvaluationException((Throwable)e, "ERR.015.006.0015", QueryPlugin.Util.getString("ERR.015.006.0015", (Object)criteria));
        }
        return value == null ^ criteria.isNegated();
    }

    public static Boolean evaluate(SubqueryCompareCriteria criteria, Map elements, List tuple, LookupEvaluator dataMgr, CommandContext context) throws CriteriaEvaluationException, BlockedException, MetaMatrixComponentException {
        Object leftValue = null;
        try {
            leftValue = ExpressionEvaluator.evaluate(criteria.getLeftExpression(), elements, tuple, dataMgr, context);
        }
        catch (ExpressionEvaluationException e) {
            throw new CriteriaEvaluationException((Throwable)e, "ERR.015.006.0015", QueryPlugin.Util.getString("ERR.015.006.0015", (Object)criteria));
        }
        if (leftValue == null) {
            return null;
        }
        Boolean result = Boolean.FALSE;
        if (criteria.getPredicateQuantifier() == 4) {
            result = Boolean.TRUE;
        }
        ValueIterator valueIter = criteria.getValueIterator();
        block20: while (valueIter.hasNext()) {
            Object value = valueIter.next();
            if (value != null) {
                switch (criteria.getOperator()) {
                    case 1: {
                        result = leftValue.equals(value);
                        break;
                    }
                    case 2: {
                        result = !leftValue.equals(value);
                        break;
                    }
                    case 3: {
                        result = CriteriaEvaluator.compareValues(leftValue, value) < 0;
                        break;
                    }
                    case 5: {
                        result = CriteriaEvaluator.compareValues(leftValue, value) <= 0;
                        break;
                    }
                    case 4: {
                        result = CriteriaEvaluator.compareValues(leftValue, value) > 0;
                        break;
                    }
                    case 6: {
                        result = CriteriaEvaluator.compareValues(leftValue, value) >= 0;
                        break;
                    }
                    default: {
                        throw new CriteriaEvaluationException("ERR.015.006.0012", QueryPlugin.Util.getString("ERR.015.006.0012", criteria.getOperator()));
                    }
                }
                switch (criteria.getPredicateQuantifier()) {
                    case 4: {
                        if (!Boolean.FALSE.equals(result)) continue block20;
                        return Boolean.FALSE;
                    }
                    case 2: {
                        if (!Boolean.TRUE.equals(result)) continue block20;
                        return Boolean.TRUE;
                    }
                    case 1: {
                        if (valueIter.hasNext()) {
                            throw new CriteriaEvaluationException("ERR.015.006.0056", QueryPlugin.Util.getString("ERR.015.006.0056", (Object)criteria));
                        }
                        return result;
                    }
                }
                throw new CriteriaEvaluationException("ERR.015.006.0057", QueryPlugin.Util.getString("ERR.015.006.0057", criteria.getPredicateQuantifier()));
            }
            switch (criteria.getPredicateQuantifier()) {
                case 4: {
                    return null;
                }
                case 2: {
                    result = null;
                    continue block20;
                }
                case 1: {
                    if (valueIter.hasNext()) {
                        throw new CriteriaEvaluationException("ERR.015.006.0056", QueryPlugin.Util.getString("ERR.015.006.0056", (Object)criteria));
                    }
                    return null;
                }
            }
            throw new CriteriaEvaluationException("ERR.015.006.0057", QueryPlugin.Util.getString("ERR.015.006.0057", criteria.getPredicateQuantifier()));
        }
        return result;
    }

    public static boolean evaluate(ExistsCriteria criteria, Map elements, List tuple, LookupEvaluator dataMgr, CommandContext context) throws CriteriaEvaluationException, BlockedException, MetaMatrixComponentException {
        ValueIterator valueIter = criteria.getValueIterator();
        return valueIter.hasNext();
    }

    public static MatchCriteria.PatternTranslator getLikeToRegexTranslator() {
        return LIKE_TO_REGEX;
    }
}

