/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.ui.wizards;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.core.validation.rules.StringNameValidator;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import com.metamatrix.modeler.internal.ui.explorer.ModelExplorerResourceNavigator;
import com.metamatrix.modeler.ui.UiConstants;
import com.metamatrix.ui.internal.product.ProductCustomizerMgr;
import com.metamatrix.ui.internal.util.UiUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewModelProjectWizard
extends BasicNewProjectResourceWizard
implements UiConstants {
    private static final String[] MODEL_NATURES = new String[]{"com.metamatrix.modeler.core.modelNature"};

    public void addPages() {
        super.addPages();
        IWizardPage mainPage = super.getPage("basicNewProjectPage");
        mainPage.setTitle(UiConstants.Util.getString("NewModelProjectWizard.title"));
        mainPage.setDescription(UiConstants.Util.getString("NewModelProjectWizard.description"));
        this.setWindowTitle(UiConstants.Util.getString("NewModelProjectWizard.title"));
    }

    public boolean performFinish() {
        IWizardPage mainPage = super.getPage("basicNewProjectPage");
        if (mainPage instanceof WizardNewProjectCreationPage) {
            String projName = ((WizardNewProjectCreationPage)mainPage).getProjectName();
            ValidationResultImpl result = new ValidationResultImpl((Object)projName);
            this.checkInvalidChars((ValidationResult)result, projName, UiConstants.NamingAttributes.INVALID_PROJECT_CHARS);
            if (result.hasProblems()) {
                String eMsg = UiConstants.Util.getString("NewModelProjectWizard.namingError.msg") + '\n' + result.getProblems()[0].getMessage();
                String eTitle = UiConstants.Util.getString("NewModelProjectWizard.namingError.title");
                MessageDialog.openWarning((Shell)this.getShell(), (String)eTitle, (String)eMsg);
                return false;
            }
        }
        super.performFinish();
        IProject project = this.getNewProject();
        if (project == null) {
            return false;
        }
        try {
            String productName;
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(MODEL_NATURES);
            if (ProductCustomizerMgr.getInstance() != null && !StringUtil.isEmpty((String)(productName = ProductCustomizerMgr.getInstance().getProductName()))) {
                desc.setComment(productName + ", version " + "5.5");
            }
            project.setDescription(desc, null);
            project.close(null);
            project.open(null);
            this.refreshModelExplorerResourceNavigatorTree();
            return true;
        }
        catch (CoreException err) {
            UiConstants.Util.log(4, (Throwable)err, err.getMessage());
            return false;
        }
    }

    private void refreshModelExplorerResourceNavigatorTree() {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                try {
                    ModelExplorerResourceNavigator view = (ModelExplorerResourceNavigator)UiUtil.getWorkbenchPage().showView("com.metamatrix.modeler.ui.explorer.view");
                    view.getTreeViewer().refresh(true);
                }
                catch (PartInitException err) {
                    UiConstants.Util.log(4, (Throwable)err, err.getMessage());
                }
            }
        });
    }

    private void checkInvalidChars(ValidationResult result, String stringToValidate, char[] invalidChars) {
        ArgCheck.isNotNull((Object)stringToValidate);
        ArgCheck.isNotNull((Object)result);
        StringNameValidator validator = new StringNameValidator(invalidChars);
        String reasonInvalid = validator.checkInvalidCharacters(stringToValidate);
        if (reasonInvalid != null) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, reasonInvalid);
            result.addProblem((ValidationProblem)problem);
        }
    }
}

