/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.metadata;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.mapping.relational.QueryNode;
import com.metamatrix.query.mapping.xml.MappingNode;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.StoredProcedureInfo;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.metadata.TempMetadataStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TempMetadataAdapter
implements QueryMetadataInterface {
    private static final String SEPARATOR = ".";
    private static final TempMetadataID TEMP_MODEL = new TempMetadataID("__TEMP__", Collections.EMPTY_LIST);
    private TempMetadataStore tempStore;
    private QueryMetadataInterface metadata;
    private Map materializationTables;
    private Map queryNodes;

    public TempMetadataAdapter(QueryMetadataInterface metadata, TempMetadataStore tempStore) {
        this.metadata = metadata;
        this.tempStore = tempStore;
    }

    public TempMetadataAdapter(QueryMetadataInterface metadata, TempMetadataStore tempStore, Map materializationTables, Map queryNodes) {
        this.metadata = metadata;
        this.tempStore = tempStore;
        this.materializationTables = materializationTables;
        this.queryNodes = queryNodes;
    }

    public TempMetadataStore getMetadataStore() {
        return this.tempStore;
    }

    public QueryMetadataInterface getMetadata() {
        return this.metadata;
    }

    public Object getElementID(String elementName) throws MetaMatrixComponentException, QueryMetadataException {
        Object tempID = null;
        try {
            tempID = this.metadata.getElementID(elementName);
        }
        catch (QueryMetadataException e) {
            // empty catch block
        }
        if (tempID == null) {
            tempID = this.tempStore.getTempElementID(elementName);
        }
        if (tempID != null) {
            return tempID;
        }
        Object[] params = new Object[]{elementName};
        String msg = QueryPlugin.Util.getString("TempMetadataAdapter.Element_____{0}_____not_found._1", params);
        throw new QueryMetadataException(msg);
    }

    public Object getGroupID(String groupName) throws MetaMatrixComponentException, QueryMetadataException {
        Object tempID = null;
        try {
            tempID = this.metadata.getGroupID(groupName);
        }
        catch (QueryMetadataException e) {
            // empty catch block
        }
        if (tempID == null) {
            tempID = this.tempStore.getTempGroupID(groupName);
        }
        if (tempID != null) {
            return tempID;
        }
        Object[] params = new Object[]{groupName};
        String msg = QueryPlugin.Util.getString("TempMetadataAdapter.Group_____{0}_____not_found._1", params);
        throw new QueryMetadataException(msg);
    }

    public Object getModelID(Object groupOrElementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupOrElementID instanceof TempMetadataID) {
            return TEMP_MODEL;
        }
        return this.metadata.getModelID(groupOrElementID);
    }

    public String getFullName(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        if (metadataID instanceof TempMetadataID) {
            return ((TempMetadataID)metadataID).getID();
        }
        return this.metadata.getFullName(metadataID);
    }

    public List getElementIDsInGroupID(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return new ArrayList(((TempMetadataID)groupID).getElements());
        }
        return this.metadata.getElementIDsInGroupID(groupID);
    }

    public Object getGroupIDForElementID(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            String elementName = ((TempMetadataID)elementID).getID();
            String groupName = elementName.substring(0, elementName.lastIndexOf(SEPARATOR));
            return this.tempStore.getTempGroupID(groupName);
        }
        return this.metadata.getGroupIDForElementID(elementID);
    }

    public StoredProcedureInfo getStoredProcedureInfoForProcedure(String fullyQualifiedProcedureName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getStoredProcedureInfoForProcedure(fullyQualifiedProcedureName);
    }

    public String getElementType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            TempMetadataID tempID = (TempMetadataID)elementID;
            if (tempID.getType() != null) {
                return DataTypeManager.getDataTypeName((Class)tempID.getType());
            }
            TempMetadataID storedTempID = this.tempStore.getTempElementID(tempID.getID());
            return DataTypeManager.getDataTypeName((Class)storedTempID.getType());
        }
        return this.metadata.getElementType(elementID);
    }

    public Object getDefaultValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            return null;
        }
        return this.metadata.getDefaultValue(elementID);
    }

    public Object getMaximumValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return null;
        }
        return this.metadata.getMaximumValue(elementID);
    }

    public Object getMinimumValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return null;
        }
        return this.metadata.getMinimumValue(elementID);
    }

    public int getDistinctValues(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            return -1;
        }
        return this.metadata.getDistinctValues(elementID);
    }

    public int getNullValues(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return -1;
        }
        return this.metadata.getNullValues(elementID);
    }

    public QueryNode getVirtualPlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (this.queryNodes != null && this.queryNodes.containsKey(groupID)) {
            return (QueryNode)this.queryNodes.get(groupID);
        }
        if (groupID instanceof TempMetadataID && !(this.metadata instanceof TempMetadataAdapter)) {
            return null;
        }
        return this.metadata.getVirtualPlan(groupID);
    }

    public String getInsertPlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getInsertPlan(groupID);
    }

    public String getUpdatePlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getUpdatePlan(groupID);
    }

    public String getDeletePlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getDeletePlan(groupID);
    }

    public boolean isVirtualGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return ((TempMetadataID)groupID).isVirtual();
        }
        return this.metadata.isVirtualGroup(groupID);
    }

    public boolean hasMaterialization(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (this.materializationTables != null && this.materializationTables.containsKey(groupID)) {
            return true;
        }
        if (groupID instanceof TempMetadataID) {
            return false;
        }
        return this.metadata.hasMaterialization(groupID);
    }

    public Object getMaterialization(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (this.materializationTables != null && this.materializationTables.containsKey(groupID)) {
            return this.materializationTables.get(groupID);
        }
        if (groupID instanceof TempMetadataID) {
            return null;
        }
        return this.metadata.getMaterialization(groupID);
    }

    public Object getMaterializationStage(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return null;
        }
        return this.metadata.getMaterializationStage(groupID);
    }

    public boolean isVirtualModel(Object modelID) throws MetaMatrixComponentException, QueryMetadataException {
        if (modelID.equals(TEMP_MODEL)) {
            return true;
        }
        return this.metadata.isVirtualModel(modelID);
    }

    public boolean modelSupports(Object modelID, int supportConstant) throws MetaMatrixComponentException, QueryMetadataException {
        if (modelID instanceof TempMetadataID) {
            switch (supportConstant) {
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return true;
                }
            }
            return false;
        }
        return this.metadata.modelSupports(modelID, supportConstant);
    }

    public boolean elementSupports(Object elementID, int supportConstant) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            TempMetadataID id = (TempMetadataID)elementID;
            switch (supportConstant) {
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 0: {
                    return true;
                }
            }
            elementID = id.getOriginalMetadataID();
            if (elementID == null || id.isTempTable()) {
                switch (supportConstant) {
                    case 4: {
                        return true;
                    }
                    case 5: {
                        return true;
                    }
                    case 11: {
                        return true;
                    }
                }
                return false;
            }
        }
        return this.metadata.elementSupports(elementID, supportConstant);
    }

    public int getMaxSetSize(Object modelID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getMaxSetSize(modelID);
    }

    public String getFullElementName(String fullGroupName, String shortElementName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getFullElementName(fullGroupName, shortElementName);
    }

    public String getShortElementName(String fullElementName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getShortElementName(fullElementName);
    }

    public String getGroupName(String fullElementName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getGroupName(fullElementName);
    }

    public Collection getGroupsForPartialName(String partialGroupName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getGroupsForPartialName(partialGroupName);
    }

    public Collection getIndexesInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return Collections.EMPTY_LIST;
        }
        return this.metadata.getIndexesInGroup(groupID);
    }

    public Collection getUniqueKeysInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return Collections.EMPTY_LIST;
        }
        return this.metadata.getUniqueKeysInGroup(groupID);
    }

    public Collection getForeignKeysInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return Collections.EMPTY_LIST;
        }
        return this.metadata.getForeignKeysInGroup(groupID);
    }

    public Object getPrimaryKeyIDForForeignKeyID(Object foreignKeyID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getPrimaryKeyIDForForeignKeyID(foreignKeyID);
    }

    public List getElementIDsInIndex(Object index) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getElementIDsInIndex(index);
    }

    public List getElementIDsInKey(Object keyID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getElementIDsInKey(keyID);
    }

    public boolean groupSupports(Object groupID, int groupConstant) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return true;
        }
        return this.metadata.groupSupports(groupID, groupConstant);
    }

    public MappingNode getMappingNode(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getMappingNode(groupID);
    }

    public boolean isXMLGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return false;
        }
        return this.metadata.isXMLGroup(groupID);
    }

    public String getVirtualDatabaseName() throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getVirtualDatabaseName();
    }

    public Collection getAccessPatternsInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            TempMetadataID id = (TempMetadataID)groupID;
            return id.getAccessPatterns();
        }
        return this.metadata.getAccessPatternsInGroup(groupID);
    }

    public List getElementIDsInAccessPattern(Object accessPattern) throws MetaMatrixComponentException, QueryMetadataException {
        if (accessPattern instanceof TempMetadataID) {
            TempMetadataID id = (TempMetadataID)accessPattern;
            if (id.getElements() != null) {
                return id.getElements();
            }
            return Collections.EMPTY_LIST;
        }
        return this.metadata.getElementIDsInAccessPattern(accessPattern);
    }

    public Collection getXMLTempGroups(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return Collections.EMPTY_SET;
        }
        return this.metadata.getXMLTempGroups(groupID);
    }

    public int getCardinality(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return ((TempMetadataID)groupID).getCardinality();
        }
        return this.metadata.getCardinality(groupID);
    }

    public List getXMLSchemas(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return Collections.EMPTY_LIST;
        }
        return this.metadata.getXMLSchemas(groupID);
    }

    public String getNameInSource(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getNameInSource(metadataID);
    }

    public Properties getExtensionProperties(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        if (metadataID instanceof TempMetadataID) {
            return null;
        }
        return this.metadata.getExtensionProperties(metadataID);
    }

    public int getElementLength(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            TempMetadataID id = (TempMetadataID)elementID;
            Object origElementID = id.getOriginalMetadataID();
            if (origElementID == null) {
                String type = this.getElementType(elementID);
                if (type.equals("string")) {
                    return 255;
                }
                return 10;
            }
            elementID = origElementID;
        }
        return this.metadata.getElementLength(elementID);
    }

    public int getPosition(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            String elementName = ((TempMetadataID)elementID).getID();
            String groupName = elementName.substring(0, elementName.lastIndexOf(SEPARATOR));
            TempMetadataID groupID = this.tempStore.getTempGroupID(groupName);
            List elements = groupID.getElements();
            return elements.indexOf(elementID);
        }
        return this.metadata.getPosition(elementID);
    }

    public int getPrecision(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return 0;
        }
        return this.metadata.getPrecision(elementID);
    }

    public int getRadix(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return 0;
        }
        return this.metadata.getRadix(elementID);
    }

    public int getScale(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return 0;
        }
        return this.metadata.getScale(elementID);
    }

    public String getNativeType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return "";
        }
        return this.metadata.getNativeType(elementID);
    }

    public boolean isProcedureInputElement(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            return false;
        }
        return this.metadata.isProcedureInputElement(elementID);
    }

    public byte[] getBinaryVDBResource(String resourcePath) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getBinaryVDBResource(resourcePath);
    }

    public String getCharacterVDBResource(String resourcePath) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getCharacterVDBResource(resourcePath);
    }

    public String[] getVDBResourcePaths() throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getVDBResourcePaths();
    }

    public String getModeledType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return null;
        }
        return this.metadata.getModeledType(elementID);
    }

    public String getModeledBaseType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return null;
        }
        return this.metadata.getModeledBaseType(elementID);
    }

    public String getModeledPrimitiveType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return null;
        }
        return this.metadata.getModeledPrimitiveType(elementID);
    }

    public boolean isTemporaryTable(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return ((TempMetadataID)groupID).isTempTable();
        }
        return false;
    }
}

