/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.query.CriteriaEvaluationException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.query.eval.CriteriaEvaluator;
import com.metamatrix.query.eval.LookupEvaluator;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.relational.BaseJoinStrategy;
import com.metamatrix.query.processor.relational.MergeDependentTupleStore;
import com.metamatrix.query.processor.relational.MergeTupleStore;
import com.metamatrix.query.processor.relational.TupleStore;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.util.CommandContext;
import com.metamatrix.query.util.TypeRetrievalUtil;
import java.util.ArrayList;
import java.util.List;

public class MergeJoinStrategy
extends BaseJoinStrategy {
    private TupleStore tupleStore;
    private boolean init = false;
    private boolean needLeft = true;
    private List leftPeek;
    private List leftPeekProbe;
    private boolean leftPeekMatch = false;
    private boolean firstTupleStore = true;
    private boolean leftMatch = false;
    private boolean needRight = true;
    private static final short STATE_SETUP_DEPJOIN = 2;
    private static final short STATE_MATCH = 3;
    private static final short STATE_OUTPUT_MATCHES = 4;

    public short getState() {
        return super.getState();
    }

    public void setBatchSize(int batchSize) {
        if (this.tupleStore instanceof MergeTupleStore) {
            ((MergeTupleStore)this.tupleStore).setBatchSize(batchSize);
        }
    }

    public void initialize(ProcessorDataManager dataManager, CommandContext context, BufferManager bufferManager, JoinType joinType, boolean isDependentJoin) throws MetaMatrixComponentException {
        super.initialize(dataManager, context, bufferManager, joinType, isDependentJoin);
        if (this.isDependentJoin) {
            List leftSchema = this.leftSource.elements;
            this.leftSource.tupleSourceID = this.bufferManager.createTupleSource(leftSchema, TypeRetrievalUtil.getTypeNames((List)leftSchema), this.context.getConnectionID(), 1);
            this.tupleStore = new MergeDependentTupleStore(this.leftSource);
            this.state = (short)2;
        } else {
            this.tupleStore = new MergeTupleStore(this.leftSource.elements, bufferManager, context);
            this.state = (short)3;
        }
    }

    public void reset() {
        super.reset();
        this.init = false;
        this.needLeft = true;
        this.leftPeek = null;
        this.leftPeekProbe = null;
        this.leftPeekMatch = false;
        this.firstTupleStore = true;
        this.leftMatch = false;
        this.needRight = true;
        if (this.tupleStore != null) {
            this.tupleStore.reset();
        }
        this.state = this.isDependentJoin ? (short)2 : (short)3;
    }

    public List execute() throws MetaMatrixComponentException, MetaMatrixProcessingException {
        if (this.state == 2) {
            this.loadDataIntoBuffer(this.leftSource);
            this.rightSource.sourceNode.open();
            this.setTupleSourceForRead(this.leftSource);
            this.state = (short)3;
        }
        if (this.state == 3) {
            this.advanceTuples();
            if (this.shouldTerminate()) {
                this.state = 0;
                return null;
            }
            if (this.rightSource.probe == null) {
                if (!this.leftMatch && this.joinType.isOuter()) {
                    this.state = (short)4;
                } else {
                    this.needLeft = true;
                }
            } else {
                int compare = this.compareProbes(this.leftSource.probe, this.rightSource.probe);
                if (compare == 0) {
                    this.state = (short)4;
                    this.leftMatch = true;
                } else if (compare < 0) {
                    this.needRight = true;
                } else if (!this.leftMatch && this.joinType.isOuter()) {
                    this.state = (short)4;
                } else {
                    this.needLeft = true;
                }
            }
        }
        if (this.state == 4) {
            List outputTuple = null;
            if (!this.tupleStore.isEmpty()) {
                outputTuple = this.getStoredTuple();
            } else {
                outputTuple = this.leftSource.tuple;
                if (this.leftMatch) {
                    this.needRight = true;
                } else if (this.joinType.isOuter()) {
                    this.needLeft = true;
                }
                this.state = (short)3;
            }
            if (outputTuple == null) {
                this.tupleStore.refresh();
                if (this.leftMatch) {
                    this.needRight = true;
                } else if (this.joinType.isOuter()) {
                    this.needLeft = true;
                }
                this.state = (short)3;
            } else {
                if (this.leftMatch && this.evaluateCriteria(outputTuple, this.rightSource.tuple)) {
                    return this.outputTuple(outputTuple, this.rightSource.tuple);
                }
                if (this.joinType.isOuter()) {
                    return this.outputTuple(outputTuple, this.rightOuterVals);
                }
            }
        }
        return null;
    }

    private boolean evaluateCriteria(List tuple1, List tuple2) throws MetaMatrixComponentException {
        try {
            if (this.combinedElementMap != null && !CriteriaEvaluator.evaluate(this.joinCriteria, this.combinedElementMap, this.outputTuple(tuple1, tuple2), (LookupEvaluator)this.dataManager, this.context)) {
                return false;
            }
        }
        catch (CriteriaEvaluationException e) {
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
        return true;
    }

    public Object clone() {
        return new MergeJoinStrategy();
    }

    void advanceLeft() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        List[] newStuff = null;
        if (!this.init) {
            newStuff = this.readTupleAndProbe(this.leftSource);
            this.leftSource.tuple = newStuff[0];
            this.leftSource.probe = newStuff[1];
            this.init = true;
        } else if (!this.blockedOnAdvanceBatch) {
            if (!this.tupleStore.isEmpty()) {
                this.tupleStore.close();
                this.firstTupleStore = true;
            }
            this.leftSource.tuple = this.leftPeek;
            this.leftSource.probe = this.leftPeekProbe;
        }
        while (true) {
            newStuff = this.readTupleAndProbe(this.leftSource);
            this.leftPeek = newStuff[0];
            this.leftPeekProbe = newStuff[1];
            this.leftPeekMatch = this.leftSource.probe != null && this.leftPeekProbe != null ? this.compareProbes(this.leftSource.probe, this.leftPeekProbe) == 0 : false;
            if (!this.leftPeekMatch) break;
            if (this.firstTupleStore) {
                this.storeTuple(this.leftSource.tuple);
                this.firstTupleStore = false;
            }
            this.leftSource.tuple = this.leftPeek;
            this.leftSource.probe = this.leftPeekProbe;
            this.storeTuple(this.leftSource.tuple);
        }
        this.tupleStore.saveCurrentTupleIndex();
        this.leftMatch = false;
    }

    void advanceRight() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        List[] newStuff = this.readTupleAndProbe(this.rightSource);
        this.rightSource.tuple = newStuff[0];
        this.rightSource.probe = newStuff[1];
    }

    private void advanceTuples() throws MetaMatrixComponentException, MetaMatrixProcessingException {
        if (this.needLeft) {
            this.advanceLeft();
            this.needLeft = false;
        }
        if (this.needRight) {
            this.advanceRight();
            this.needRight = false;
        }
    }

    int compareProbes(List leftProbe, List rightProbe) throws MetaMatrixComponentException {
        int probeSize = leftProbe.size();
        for (int i = 0; i < probeSize; ++i) {
            Object leftValue = leftProbe.get(i);
            Object rightValue = rightProbe.get(i);
            if (rightValue == null) {
                return -1;
            }
            if (leftValue == null) {
                return 1;
            }
            int c = 0;
            c = leftValue instanceof Comparable && rightValue instanceof Comparable ? ((Comparable)rightValue).compareTo(leftValue) : rightValue.toString().compareTo(leftValue.toString());
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private boolean shouldTerminate() {
        if (this.leftSource.tuple == null) {
            return true;
        }
        return this.rightSource.tuple == null && this.tupleStore.isEmpty() && !this.joinType.equals((Object)JoinType.JOIN_LEFT_OUTER);
    }

    void storeTuple(List tuple) throws MetaMatrixComponentException {
        this.tupleStore.storeTuple(tuple);
    }

    private List getStoredTuple() throws MetaMatrixComponentException {
        return this.tupleStore.getStoredTuple();
    }

    public String toString() {
        return "MERGE JOIN";
    }

    public void setCriteria(Criteria joinCriteria) {
        super.setCriteria(joinCriteria);
        if (this.joinCriteria != null) {
            ArrayList combinedElements = new ArrayList(this.leftSource.elements);
            combinedElements.addAll(this.rightSource.elements);
            this.combinedElementMap = this.createLookupMap(combinedElements);
        }
    }
}

