/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.transformation.util;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.transformation.InputSet;
import com.metamatrix.metamodels.transformation.SqlAlias;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metadata.runtime.ColumnRecord;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import com.metamatrix.modeler.core.metadata.runtime.ProcedureParameterRecord;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnSetAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.internal.core.metadata.runtime.ColumnRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.TableRecordImpl;
import com.metamatrix.modeler.internal.transformation.util.SqlAspectHelper;
import com.metamatrix.modeler.internal.transformation.util.SqlConstants;
import com.metamatrix.modeler.internal.transformation.util.SqlConverter;
import com.metamatrix.modeler.internal.transformation.util.SqlMappingRootCache;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.modeler.transformation.aspects.sql.InputParameterSqlAspect;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadataFactory;
import com.metamatrix.modeler.transformation.validation.SqlTransformationResult;
import com.metamatrix.modeler.transformation.validation.TransformationValidator;
import com.metamatrix.query.function.FunctionDescriptor;
import com.metamatrix.query.function.FunctionLibrary;
import com.metamatrix.query.function.FunctionLibraryManager;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.StoredProcedureInfo;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.proc.CommandStatement;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.proc.Statement;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.AllSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.MultipleElementSymbol;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.CommandCollectorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.sql.visitor.SubqueryFromClauseCollectorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class TransformationSqlHelper
implements SqlConstants {
    private static final TransformationSqlHelper INSTANCE = new TransformationSqlHelper();
    private static final String NEW_CONVERSION_NAME = "conversion";
    static /* synthetic */ Class class$java$lang$String;

    public static TransformationSqlHelper getInstance() {
        return INSTANCE;
    }

    public static boolean canAddGroupToSelectSql(EObject transMappingRoot) {
        boolean canUpdate = false;
        if (TransformationHelper.isValidQuery((Object)transMappingRoot) || TransformationHelper.isValidSetQuery((Object)transMappingRoot) || TransformationHelper.isSelectFromString((Object)transMappingRoot) || TransformationHelper.isInitialSelect((Object)transMappingRoot) || TransformationHelper.isEmptySelect((Object)transMappingRoot)) {
            canUpdate = true;
        }
        return canUpdate;
    }

    public static boolean canRemoveGroupFromSelectSql(EObject transMappingRoot) {
        boolean canUpdate = false;
        if (TransformationHelper.isValidQuery((Object)transMappingRoot) || TransformationHelper.isInitialSelect((Object)transMappingRoot) || TransformationHelper.isEmptySelect((Object)transMappingRoot)) {
            canUpdate = true;
        }
        return canUpdate;
    }

    public static void updateAllSqlOnSqlAliasGroupAdded(EObject transMappingRoot, EObject sqlAliasGroup, boolean addElemsToSelect, Object source) {
        TransformationSqlHelper.updateSelectSqlOnSqlAliasGroupAdded(transMappingRoot, sqlAliasGroup, addElemsToSelect, source);
    }

    public static void updateAllSqlOnSqlAliasGroupsAdded(EObject transMappingRoot, List sqlAliasGroups, boolean addElemsToSelect, Object source) {
        TransformationSqlHelper.updateSelectSqlOnSqlAliasGroupsAdded(transMappingRoot, sqlAliasGroups, addElemsToSelect, source);
    }

    public static void updateAllSqlOnSqlAliasGroupRemoved(EObject transMappingRoot, EObject sqlAliasGroup, boolean removeElemsFromSelect, Object source) {
        TransformationSqlHelper.updateSelectSqlOnSqlAliasGroupRemoved(transMappingRoot, sqlAliasGroup, removeElemsFromSelect, source);
    }

    public static void updateAllSqlOnSqlAliasGroupsRemoved(EObject transMappingRoot, List sqlAliasGroups, boolean removeElemsFromSelect, Object source) {
        TransformationSqlHelper.updateSelectSqlOnSqlAliasGroupsRemoved(transMappingRoot, sqlAliasGroups, removeElemsFromSelect, source);
    }

    public static void updateAllSqlOnElementsRemoved(EObject transMappingRoot, List elementEObjs, Object source) {
        TransformationSqlHelper.updateSqlOnElementsRemoved(transMappingRoot, elementEObjs, source);
    }

    public static void updateSelectSqlOnSqlAliasGroupAdded(EObject transMappingRoot, EObject sqlAliasGroup, boolean addElemsToSelect, Object source) {
        if (SqlAspectHelper.isTable((EObject)sqlAliasGroup) && (TransformationHelper.isParsableQuery((Object)transMappingRoot) || TransformationHelper.isInitialSelect((Object)transMappingRoot)) && sqlAliasGroup != null) {
            ArrayList<EObject> groups = new ArrayList<EObject>(1);
            groups.add(sqlAliasGroup);
            TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, false);
            TransformationSqlHelper.addSqlAliasGroupsToSelectStatement(transMappingRoot, groups, addElemsToSelect, source, validator);
        }
    }

    public static void updateSelectSqlOnSqlAliasGroupsAdded(EObject transMappingRoot, List sqlAliasGroups, boolean addElemsToSelect, Object source) {
        if (TransformationHelper.isParsableQuery((Object)transMappingRoot) || TransformationHelper.isInitialSelect((Object)transMappingRoot) || TransformationHelper.isEmptySelect((Object)transMappingRoot) || TransformationHelper.isSelectFromString((Object)transMappingRoot)) {
            TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, false);
            TransformationSqlHelper.addSqlAliasGroupsToSelectStatement(transMappingRoot, sqlAliasGroups, addElemsToSelect, source, validator);
        }
    }

    public static void updateSelectSqlOnSqlAliasGroupRemoved(EObject transMappingRoot, EObject sqlAliasGroup, boolean removeElemsFromSelect, Object source) {
        if (SqlAspectHelper.isTable((EObject)sqlAliasGroup)) {
            if (source == null) {
                source = TransformationSqlHelper.getInstance();
            }
            if ((TransformationHelper.isParsableQuery((Object)transMappingRoot) || TransformationHelper.isInitialSelect((Object)transMappingRoot)) && sqlAliasGroup != null) {
                ArrayList<EObject> groups = new ArrayList<EObject>(1);
                groups.add(sqlAliasGroup);
                TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, false);
                TransformationSqlHelper.removeSqlAliasGroupsFromSelectStatement(transMappingRoot, groups, removeElemsFromSelect, source, validator);
            }
        }
    }

    public static void updateSelectSqlOnSqlAliasGroupsRemoved(EObject transMappingRoot, List sqlAliasGroups, boolean removeElemsFromSelect, Object source) {
        if (TransformationHelper.isParsableQuery((Object)transMappingRoot)) {
            if (source == null) {
                source = TransformationSqlHelper.getInstance();
            }
            TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, false);
            TransformationSqlHelper.removeSqlAliasGroupsFromSelectStatement(transMappingRoot, sqlAliasGroups, removeElemsFromSelect, source, validator);
        }
    }

    public static void updateSqlOnElementsRemoved(EObject transMappingRoot, List elementEObjs, Object source) {
        if (TransformationHelper.isParsableQuery((Object)transMappingRoot)) {
            if (source == null) {
                source = TransformationSqlHelper.getInstance();
            }
            TransformationSqlHelper.removeElementsFromStatement(transMappingRoot, elementEObjs, source);
        }
    }

    public static void updateUnionSelectOnGroupsAdded(EObject transMappingRoot, List sourceGroups, boolean useAll, Object txnSource) {
        if (TransformationHelper.isParsableQuery((Object)transMappingRoot) || TransformationHelper.isParsableSetQuery((Object)transMappingRoot) || TransformationHelper.isInitialSelect((Object)transMappingRoot) || TransformationHelper.isEmptySelect((Object)transMappingRoot)) {
            Command command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
            if (command != null) {
                if (command instanceof QueryCommand) {
                    SetQuery newQuery = TransformationSqlHelper.createSetQueryAddUnionSources((QueryCommand)command, sourceGroups, useAll);
                    TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)newQuery.toString(), (boolean)false, (Object)txnSource);
                }
            } else {
                SetQuery newQuery = TransformationSqlHelper.createSetQueryAddUnionSources((QueryCommand)new SetQuery(0), sourceGroups, useAll);
                TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)newQuery.toString(), (boolean)false, (Object)txnSource);
            }
        }
    }

    public static void updateUnionSelectAddGroupsToSegment(EObject transMappingRoot, List sourceGroups, int nSegmentIndex, Object txnSource) {
        Command command;
        if (TransformationHelper.isParsableSetQuery((Object)transMappingRoot) && (command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot)) != null && command instanceof SetQuery) {
            SetQuery newSetQuery = (SetQuery)command.clone();
            List queries = ((SetQuery)command).getQueries();
            QueryCommand queryCommand = (QueryCommand)queries.get(nSegmentIndex);
            if (queryCommand instanceof Query) {
                Query query = (Query)queryCommand;
                Query newQuery = TransformationSqlHelper.createQueryAddGroupsToFrom(query, sourceGroups);
                newSetQuery.removeAllQueries();
                for (int i = 0; i < queries.size(); ++i) {
                    if (i == nSegmentIndex) {
                        newSetQuery.addQuery((QueryCommand)newQuery);
                        continue;
                    }
                    newSetQuery.addQuery((QueryCommand)queries.get(i));
                }
                TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)newSetQuery.toString(), (boolean)false, (Object)txnSource);
            }
        }
    }

    private static void addSqlAliasGroupsToSelectStatement(EObject transMappingRoot, List sqlAliasGroups, boolean addElemsToSelect, Object txnSource, TransformationValidator validator) {
        if (transMappingRoot == null || sqlAliasGroups == null) {
            return;
        }
        if (txnSource == null) {
            txnSource = TransformationSqlHelper.getInstance();
        }
        boolean isValid = SqlMappingRootCache.isSelectValid((Object)transMappingRoot);
        Command command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
        if (isValid && command instanceof Query) {
            Query query = (Query)command;
            Query newQuery = TransformationSqlHelper.createQueryAddSqlAliasGroups(query, sqlAliasGroups, addElemsToSelect, 0, validator);
            TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)newQuery.toString(), (boolean)false, (Object)txnSource);
        } else if (TransformationHelper.isInitialSelect((Object)transMappingRoot) || TransformationHelper.isEmptySelect((Object)transMappingRoot)) {
            EObject targetGrp = TransformationHelper.getTransformationLinkTarget((EObject)transMappingRoot);
            if (!TransformationHelper.isSqlProcedure((Object)targetGrp)) {
                Query qry = TransformationSqlHelper.createDefaultQuery(null);
                qry = TransformationSqlHelper.createQueryAddSqlAliasGroups(qry, sqlAliasGroups, addElemsToSelect, 0, validator);
                TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)qry.toString(), (boolean)false, (Object)txnSource);
            } else if (sqlAliasGroups.size() == 1) {
                SqlAlias sqlAlias = (SqlAlias)sqlAliasGroups.get(0);
                EObject aliasedEObject = sqlAlias.getAliasedObject();
                if (TransformationHelper.isSqlProcedure((Object)aliasedEObject)) {
                    StoredProcedure proc = TransformationSqlHelper.createStoredProc((EObject)sqlAlias);
                    if (proc != null) {
                        CreateUpdateProcedureCommand cCommand = TransformationSqlHelper.createVirtualProcCommmandForCommand((Command)proc);
                        TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)cCommand.toString(), (boolean)false, (Object)txnSource);
                    }
                } else {
                    Query qry = TransformationSqlHelper.createDefaultQuery(null);
                    qry = TransformationSqlHelper.createQueryAddSqlAliasGroups(qry, sqlAliasGroups, addElemsToSelect, 0, validator);
                    CreateUpdateProcedureCommand cCommand = TransformationSqlHelper.createVirtualProcCommmandForCommand((Command)qry);
                    TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)cCommand.toString(), (boolean)false, (Object)txnSource);
                }
            } else {
                Query qry = TransformationSqlHelper.createDefaultQuery(null);
                qry = TransformationSqlHelper.createQueryAddSqlAliasGroups(qry, sqlAliasGroups, addElemsToSelect, 0, validator);
                CreateUpdateProcedureCommand cCommand = TransformationSqlHelper.createVirtualProcCommmandForCommand((Command)qry);
                TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)cCommand.toString(), (boolean)false, (Object)txnSource);
            }
        } else if (TransformationHelper.isSelectFromString((Object)transMappingRoot)) {
            StringBuffer sb = new StringBuffer(TransformationHelper.getSelectSqlString((Object)transMappingRoot));
            sb.append(" ");
            List clausesToAdd = TransformationSqlHelper.createFromClauses(sqlAliasGroups);
            Iterator iter = clausesToAdd.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)sb.toString(), (boolean)false, (Object)txnSource);
        }
    }

    public static CreateUpdateProcedureCommand createVirtualProcCommmandForCommand(Command command) {
        CommandStatement cmdStmt;
        Block block = new Block();
        if (command.getType() == 6) {
            if (command.getProjectedSymbols().size() > 0) {
                SubqueryFromClause subquery = new SubqueryFromClause("PROC", command);
                From from = new From();
                from.addClause((FromClause)subquery);
                Select select = new Select();
                select.addSymbol((SelectSymbol)new AllSymbol());
                Query query = new Query(select, from, null, null, null);
                query.setIsEmbedded(true);
                block.addStatement((Statement)new CommandStatement((Command)query));
            } else {
                cmdStmt = new CommandStatement(command);
                block.addStatement((Statement)cmdStmt);
                Select select = new Select();
                select.addSymbol((SelectSymbol)new AliasSymbol("RESULT", (SingleElementSymbol)new ExpressionSymbol("RESULT", (Expression)new Constant((Object)Boolean.TRUE))));
                Query query = new Query(select, null, null, null, null);
                query.setIsEmbedded(true);
                block.addStatement((Statement)new CommandStatement((Command)query));
            }
        } else {
            cmdStmt = new CommandStatement(command);
            block.addStatement((Statement)cmdStmt);
        }
        CreateUpdateProcedureCommand cCommand = new CreateUpdateProcedureCommand(block);
        cCommand.setUpdateProcedure(false);
        return cCommand;
    }

    private static Query createQueryAddSqlAliasGroupElemsToSelect(Query resolvedQuery, List addedSqlAliasGroups) {
        Query result = null;
        if (!TransformationSqlHelper.isSelectStar(resolvedQuery.getSelect())) {
            result = (Query)resolvedQuery.clone();
            Select select = resolvedQuery.getSelect();
            List currentSelectSymbols = select.getSymbols();
            List newElementSymbols = TransformationSqlHelper.createElemSymbols(addedSqlAliasGroups);
            ArrayList selectSymbols = new ArrayList();
            selectSymbols.addAll(currentSelectSymbols);
            selectSymbols.addAll(newElementSymbols);
            List newSelectSymbols = TransformationSqlHelper.renameConflictingSymbols(selectSymbols);
            if (newSelectSymbols.size() == 0) {
                newSelectSymbols.add(new AllSymbol());
                select.setSymbols(newSelectSymbols);
            } else {
                select.setSymbols(newSelectSymbols);
            }
            result.setSelect(select);
        }
        return result;
    }

    private static Query createQueryAddSqlAliasGroupsToFrom(Query resolvedQuery, List sqlAliasGroups) {
        Query result = null;
        if (resolvedQuery != null && sqlAliasGroups != null) {
            result = (Query)resolvedQuery.clone();
            From from = resolvedQuery.getFrom();
            From newFrom = from != null ? (From)from.clone() : new From();
            ArrayList currentGroupSymbols = new ArrayList();
            GroupCollectorVisitor.getGroupsIgnoreInlineViews((LanguageObject)resolvedQuery, currentGroupSymbols);
            List clausesToAdd = TransformationSqlHelper.createFromClauses(sqlAliasGroups);
            Iterator iter = clausesToAdd.iterator();
            while (iter.hasNext()) {
                FromClause nextFromClause = (FromClause)iter.next();
                if (TransformationSqlHelper.fromClauseExistsInFrom(newFrom, nextFromClause)) continue;
                newFrom.addClause(nextFromClause);
            }
            result.setFrom(newFrom);
        }
        return result;
    }

    private static Query createQueryAddGroupsToFrom(Query query, List grpEObjs) {
        Query result = null;
        if (query != null && grpEObjs != null) {
            result = (Query)query.clone();
            From from = query.getFrom();
            From newFrom = from != null ? (From)from.clone() : new From();
            for (int i = 0; i < grpEObjs.size(); ++i) {
                EObject grpEObj = (EObject)grpEObjs.get(i);
                FromClause fClause = TransformationSqlHelper.createFromClause(grpEObj);
                newFrom.addClause(fClause);
            }
            result.setFrom(newFrom);
        }
        return result;
    }

    private static Query createQueryAddSqlAliasGroups(Query resolvedQuery, List sqlAliasGroups, boolean addGroupElemsToSelect, int cmdType, TransformationValidator validator) {
        Query result = null;
        if (resolvedQuery != null && sqlAliasGroups != null) {
            SqlTransformationResult resolverResult;
            result = TransformationSqlHelper.createQueryAddSqlAliasGroupsToFrom(resolvedQuery, sqlAliasGroups);
            SqlTransformationResult parserResult = TransformationValidator.parseSQL((String)result.toString());
            Query resultQuery = (Query)parserResult.getCommand();
            boolean isResolvable = false;
            boolean isValid = false;
            if (resultQuery != null && (isResolvable = (resolverResult = validator.resolveCommand((Command)resultQuery, cmdType)).isResolvable())) {
                SqlTransformationResult validationResult = validator.validateCommand((Command)resultQuery);
                isValid = validationResult.isValidatable();
            }
            if (isValid) {
                Select select = resultQuery.getSelect();
                result = TransformationSqlHelper.isSelectStar(select) ? TransformationSqlHelper.createQueryFixNameConflicts(resultQuery) : (addGroupElemsToSelect ? TransformationSqlHelper.createQueryAddSqlAliasGroupElemsToSelect(resultQuery, sqlAliasGroups) : resultQuery);
            }
        }
        return result;
    }

    private static SetQuery createSetQueryAddUnionSources(QueryCommand queryCommand, List unionSourceGrps, boolean useAll) {
        SetQuery result = null;
        if (queryCommand != null) {
            if (queryCommand instanceof Query) {
                result = new SetQuery(0);
                result.addQuery((QueryCommand)((Query)queryCommand.clone()));
            } else if (queryCommand instanceof SetQuery) {
                result = (SetQuery)queryCommand.clone();
            }
            Iterator iter = unionSourceGrps.iterator();
            while (iter.hasNext()) {
                EObject sourceGroup = (EObject)iter.next();
                Query qry = TransformationSqlHelper.createDefaultQuery(sourceGroup);
                result.addQuery((QueryCommand)qry, useAll);
            }
        }
        return result;
    }

    private static void removeSqlAliasGroupsFromSelectStatement(EObject transMappingRoot, List sqlAliasGroups, boolean removeElemsFromSelect, Object txnSource, TransformationValidator validator) {
        if (transMappingRoot == null || sqlAliasGroups == null) {
            return;
        }
        if (txnSource == null) {
            txnSource = TransformationSqlHelper.getInstance();
        }
        boolean isValid = SqlMappingRootCache.isSelectValid((Object)transMappingRoot);
        Command command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
        if (isValid && command instanceof Query) {
            Query query = (Query)command;
            Query newQuery = TransformationSqlHelper.createQueryRemoveSqlAliasGroups(query, sqlAliasGroups, removeElemsFromSelect, 0, validator);
            TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)newQuery.toString(), (boolean)false, (Object)txnSource);
        } else {
            TransformationSqlHelper.rebuildQueryRemovingSqlAliasGroups(transMappingRoot, sqlAliasGroups);
        }
    }

    private static void removeElementsFromStatement(EObject transMappingRoot, List elementEObjs, Object txnSource) {
        Query query;
        Query newQuery;
        if (transMappingRoot == null || elementEObjs == null) {
            return;
        }
        if (txnSource == null) {
            txnSource = TransformationSqlHelper.getInstance();
        }
        boolean isValid = SqlMappingRootCache.isSelectValid((Object)transMappingRoot);
        Command command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
        if (isValid && command instanceof Query && (newQuery = TransformationSqlHelper.createQueryRemoveElems(query = (Query)command, elementEObjs)) != null) {
            TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)newQuery.toString(), (boolean)false, (Object)txnSource);
        }
    }

    private static void rebuildQueryRemovingSqlAliasGroups(EObject transMappingRoot, List sqlAliasGroups) {
        if (transMappingRoot == null || sqlAliasGroups == null) {
            return;
        }
    }

    private static Query createQueryRemoveSqlAliasGroupElemsFromSelect(Query resolvedQuery, List removeSqlAliasGroups) {
        Query result = null;
        if (TransformationSqlHelper.hasSqlAliasGroupAttributes(resolvedQuery, removeSqlAliasGroups)) {
            result = (Query)resolvedQuery.clone();
            List aliasGroupSymbols = TransformationSqlHelper.createGroupSymbols(removeSqlAliasGroups);
            Select select = resolvedQuery.getSelect();
            List currentSelectSymbols = select.getSymbols();
            ArrayList<Object> newSelectSymbols = new ArrayList<Object>(currentSelectSymbols.size());
            Iterator iter = currentSelectSymbols.iterator();
            while (iter.hasNext()) {
                SelectSymbol selectSymbol = (SelectSymbol)iter.next();
                Collection symbolGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)selectSymbol);
                Iterator symbolGroupIter = symbolGroups.iterator();
                boolean removeSymbol = false;
                while (symbolGroupIter.hasNext()) {
                    GroupSymbol symbGroup = (GroupSymbol)symbolGroupIter.next();
                    Iterator removeGroupIter = aliasGroupSymbols.iterator();
                    while (removeGroupIter.hasNext()) {
                        GroupSymbol removeGroupSymbol = (GroupSymbol)removeGroupIter.next();
                        if (!symbGroup.equals((Object)removeGroupSymbol)) continue;
                        removeSymbol = true;
                        break;
                    }
                    if (!removeSymbol) continue;
                    break;
                }
                if (removeSymbol) continue;
                newSelectSymbols.add(selectSymbol);
            }
            if (newSelectSymbols.size() == 0) {
                newSelectSymbols.add(new AllSymbol());
                select.setSymbols(newSelectSymbols);
            } else {
                select.setSymbols(newSelectSymbols);
            }
            result.setSelect(select);
        }
        return result;
    }

    protected static Query createQueryRemoveElems(Query resolvedQuery, List removeElements) {
        Query result = resolvedQuery;
        ArrayList<String> removeNames = new ArrayList<String>(removeElements.size());
        Iterator iter = removeElements.iterator();
        while (iter.hasNext()) {
            Object remElem = iter.next();
            if (!(remElem instanceof EObject) || !SqlAspectHelper.isColumn((EObject)((EObject)remElem))) continue;
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)((EObject)remElem));
            removeNames.add(columnAspect.getName((EObject)remElem));
        }
        if (TransformationSqlHelper.hasSqlElemSymbols(resolvedQuery, removeElements)) {
            result = (Query)resolvedQuery.clone();
            Select select = resolvedQuery.getSelect();
            List currentSelectSymbols = resolvedQuery.getProjectedSymbols();
            List newSelectSymbols = TransformationSqlHelper.removeSymbols(currentSelectSymbols, removeNames);
            select.setSymbols(newSelectSymbols);
            result.setSelect(select);
        }
        if (result.getGroupBy() != null) {
            GroupBy groupBy = result.getGroupBy();
            List currentGroupBySymbols = groupBy.getSymbols();
            List newGroupBySymbols = TransformationSqlHelper.removeSymbols(currentGroupBySymbols, removeNames);
            groupBy.replaceSymbols((Collection)newGroupBySymbols);
            if (groupBy.getCount() == 0) {
                result.setGroupBy(null);
            } else {
                result.setGroupBy(groupBy);
            }
        }
        if (result.getOrderBy() != null) {
            OrderBy orderBy = result.getOrderBy();
            Iterator iter2 = orderBy.getVariables().iterator();
            while (iter2.hasNext()) {
                SingleElementSymbol seSymbol;
                String name;
                Object next = iter2.next();
                if (!(next instanceof SingleElementSymbol) || !removeNames.contains(name = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol = (SingleElementSymbol)next, false))) continue;
                iter2.remove();
            }
            if (orderBy.getVariableCount() == 0) {
                result.setOrderBy(null);
            } else {
                result.setOrderBy(orderBy);
            }
        }
        return result;
    }

    private static List removeSymbols(List currentSymbols, List symbolNamesToRemove) {
        if (currentSymbols == null || symbolNamesToRemove == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<SingleElementSymbol> result = new ArrayList<SingleElementSymbol>(currentSymbols.size());
        Iterator iter = currentSymbols.iterator();
        while (iter.hasNext()) {
            SingleElementSymbol seSymbol;
            String symName;
            Object next = iter.next();
            if (!(next instanceof SingleElementSymbol) || symbolNamesToRemove.contains(symName = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol = (SingleElementSymbol)next, false))) continue;
            result.add(seSymbol);
        }
        return result;
    }

    private static Query createQueryRemoveSqlAliasGroupsFromFrom(Query resolvedQuery, List removedSqlAliasGrps) {
        Query result = null;
        if (resolvedQuery != null) {
            result = (Query)resolvedQuery.clone();
            From from = resolvedQuery.getFrom();
            List currentFromClauses = from.getClauses();
            ArrayList<FromClause> newFromClauses = new ArrayList<FromClause>(currentFromClauses.size());
            Iterator iter = currentFromClauses.iterator();
            while (iter.hasNext()) {
                FromClause fromClause = (FromClause)iter.next();
                boolean removeIt = false;
                Iterator removeSqlAliasGrpIter = removedSqlAliasGrps.iterator();
                while (removeSqlAliasGrpIter.hasNext()) {
                    EObject removeGroupEObj = (EObject)removeSqlAliasGrpIter.next();
                    if (fromClause instanceof UnaryFromClause) {
                        GroupSymbol gSymbol = ((UnaryFromClause)fromClause).getGroup();
                        GroupSymbol removeGroupSymbol = TransformationSqlHelper.createGroupSymbol(removeGroupEObj);
                        if (gSymbol == null || !gSymbol.equals((Object)removeGroupSymbol)) continue;
                        removeIt = true;
                        break;
                    }
                    if (!(fromClause instanceof SubqueryFromClause)) continue;
                    SubqueryFromClause sqf = (SubqueryFromClause)fromClause;
                    if (!(removeGroupEObj instanceof SqlAlias) || !TransformationSqlHelper.isMatch(sqf, (SqlAlias)removeGroupEObj)) continue;
                    removeIt = true;
                    break;
                }
                if (removeIt) continue;
                newFromClauses.add(fromClause);
            }
            from.setClauses(newFromClauses);
            result.setFrom(from);
        }
        return result;
    }

    public static boolean fromClauseExistsInFrom(From theFrom, FromClause theFromClause) {
        boolean exists = false;
        GroupSymbol theGroupSymbol = null;
        if (theFromClause != null) {
            if (theFromClause instanceof UnaryFromClause) {
                theGroupSymbol = ((UnaryFromClause)theFromClause).getGroup();
            } else if (theFromClause instanceof SubqueryFromClause) {
                theGroupSymbol = ((SubqueryFromClause)theFromClause).getGroupSymbol();
            }
        }
        if (theFrom != null && theGroupSymbol != null) {
            List currentFromClauses = theFrom.getClauses();
            Iterator iter = currentFromClauses.iterator();
            while (iter.hasNext()) {
                FromClause nextFromClause = (FromClause)iter.next();
                GroupSymbol nextGroupSymbol = null;
                if (nextFromClause instanceof UnaryFromClause) {
                    nextGroupSymbol = ((UnaryFromClause)nextFromClause).getGroup();
                } else if (nextFromClause instanceof SubqueryFromClause) {
                    nextGroupSymbol = ((SubqueryFromClause)nextFromClause).getGroupSymbol();
                }
                if (!theGroupSymbol.equals((Object)nextGroupSymbol)) continue;
                exists = true;
                break;
            }
        }
        return exists;
    }

    public static boolean isMatch(SubqueryFromClause subqueryFrom, SqlAlias sqlAlias) {
        boolean isMatch = false;
        if (subqueryFrom != null && sqlAlias != null) {
            Command fromClauseQuery = subqueryFrom.getCommand();
            String fromClauseName = subqueryFrom.getName();
            if (fromClauseQuery instanceof StoredProcedure) {
                StoredProcedure fromClauseProc = (StoredProcedure)fromClauseQuery;
                String fromClauseProcName = fromClauseProc.getProcedureCallableName();
                String sqlAliasName = sqlAlias.getAlias();
                EObject sqlAliasEObj = sqlAlias.getAliasedObject();
                if (fromClauseName != null && fromClauseName.equalsIgnoreCase(sqlAliasName) && TransformationHelper.isSqlProcedure((Object)sqlAliasEObj)) {
                    StoredProcedureInfo procInfo = TransformationSqlHelper.getProcInfo(TransformationHelper.getSqlEObjectFullName((EObject)sqlAliasEObj), sqlAliasEObj);
                    String sqlAliasProcName = procInfo.getProcedureCallableName();
                    if (fromClauseProcName != null && fromClauseProcName.equalsIgnoreCase(sqlAliasProcName)) {
                        isMatch = true;
                    }
                }
            }
        }
        return isMatch;
    }

    public static boolean isMatch(StoredProcedure storedProc, SqlAlias sqlAlias) {
        boolean isMatch = false;
        if (storedProc != null && sqlAlias != null) {
            StoredProcedureInfo procInfo;
            String sqlAliasProcName;
            String procName = storedProc.getProcedureCallableName();
            String sqlAliasName = sqlAlias.getAlias();
            EObject sqlAliasEObj = sqlAlias.getAliasedObject();
            if (procName != null && procName.equalsIgnoreCase(sqlAliasName) && TransformationHelper.isSqlProcedure((Object)sqlAliasEObj) && procName.equalsIgnoreCase(sqlAliasProcName = (procInfo = TransformationSqlHelper.getProcInfo(TransformationHelper.getSqlEObjectFullName((EObject)sqlAliasEObj), sqlAliasEObj)).getProcedureCallableName())) {
                isMatch = true;
            }
        }
        return isMatch;
    }

    private static Query createQueryRemoveSqlAliasGroups(Query resolvedQuery, List sqlAliasGroups, boolean removeGroupElemsFromSelect, int cmdType, TransformationValidator validator) {
        Query result = null;
        if (resolvedQuery != null && sqlAliasGroups != null) {
            if (!TransformationSqlHelper.isSelectStar(resolvedQuery.getSelect()) && TransformationSqlHelper.hasSqlAliasGroupAttributes(resolvedQuery, sqlAliasGroups)) {
                result = removeGroupElemsFromSelect ? TransformationSqlHelper.createQueryRemoveSqlAliasGroupElemsFromSelect(resolvedQuery, sqlAliasGroups) : resolvedQuery;
            }
            Query resultQuery = null;
            boolean isValid = false;
            if (result != null) {
                SqlTransformationResult resolverResult;
                SqlTransformationResult parserResult = TransformationValidator.parseSQL((String)result.toString());
                resultQuery = (Query)parserResult.getCommand();
                boolean isResolvable = false;
                if (result != null && (isResolvable = (resolverResult = validator.resolveCommand((Command)resultQuery, cmdType)).isResolvable())) {
                    SqlTransformationResult validationResult = validator.validateCommand((Command)resultQuery);
                    isValid = validationResult.isValidatable();
                }
            } else {
                resultQuery = resolvedQuery;
                isValid = true;
            }
            if (isValid) {
                result = TransformationSqlHelper.createQueryRemoveSqlAliasGroupsFromFrom(resolvedQuery, sqlAliasGroups);
            }
        }
        return result;
    }

    public static Query createQueryFixNameConflicts(Query resolvedQuery) {
        Query modifiedQuery = null;
        if (resolvedQuery != null) {
            modifiedQuery = (Query)resolvedQuery.clone();
            if (TransformationSqlHelper.hasProjectedSymbolNameConflict((Command)resolvedQuery)) {
                List currentSymbols = resolvedQuery.getSelect().getSymbols();
                List newSymbols = TransformationSqlHelper.renameConflictingSymbols(currentSymbols);
                Select newSelect = new Select(newSymbols);
                modifiedQuery.setSelect(newSelect);
            }
        }
        return modifiedQuery;
    }

    public static Query createDefaultQuery(EObject source) {
        FromClause clause;
        Select newSelect = new Select();
        newSelect.addSymbol((SelectSymbol)new AllSymbol());
        From newFrom = new From();
        if (source != null && (clause = TransformationSqlHelper.createFromClause(source)) != null) {
            newFrom.addClause(clause);
        }
        Query query = new Query();
        query.setSelect(newSelect);
        query.setFrom(newFrom);
        return query;
    }

    public static boolean hasProjectedSymbolNameConflict(Command command) {
        boolean hasConflict = false;
        if (command != null) {
            ArrayList<String> attrNames = new ArrayList<String>();
            List symbols = command.getProjectedSymbols();
            Iterator symbolIter = symbols.iterator();
            while (symbolIter.hasNext()) {
                SingleElementSymbol seSymbol = (SingleElementSymbol)symbolIter.next();
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol, false);
                String uniqueName = TransformationSqlHelper.getUniqueName(name, attrNames);
                if (!uniqueName.equals(name)) {
                    hasConflict = true;
                    break;
                }
                attrNames.add(uniqueName);
            }
        }
        return hasConflict;
    }

    public static List getProjectedSymbolNames(Command command) {
        if (command == null) {
            return Collections.EMPTY_LIST;
        }
        List projectedSymbols = command.getProjectedSymbols();
        ArrayList<String> symbolNames = null;
        if (projectedSymbols == null || projectedSymbols.isEmpty()) {
            symbolNames = Collections.EMPTY_LIST;
        } else {
            symbolNames = new ArrayList<String>(projectedSymbols.size());
            Iterator symbolIter = projectedSymbols.iterator();
            while (symbolIter.hasNext()) {
                SingleElementSymbol symbol = (SingleElementSymbol)symbolIter.next();
                String shortName = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                if (shortName == null) continue;
                symbolNames.add(shortName);
            }
        }
        return symbolNames;
    }

    public static String getSingleElementSymbolShortName(SingleElementSymbol symbol, boolean showExpression) {
        String symbolName = "";
        if (symbol != null) {
            if (symbol instanceof ExpressionSymbol) {
                Expression expr = ((ExpressionSymbol)symbol).getExpression();
                if (expr instanceof Function) {
                    Function func = (Function)expr;
                    if (func.isImplicit()) {
                        Collection elementSymbols = ElementCollectorVisitor.getElements((LanguageObject)func, (boolean)true);
                        if (elementSymbols.size() == 1) {
                            ElementSymbol element = (ElementSymbol)elementSymbols.iterator().next();
                            symbolName = element.getShortName();
                        } else {
                            symbolName = showExpression ? symbol.toString() : symbol.getShortName();
                        }
                    } else {
                        symbolName = showExpression ? symbol.toString() : symbol.getShortName();
                    }
                } else {
                    symbolName = showExpression ? symbol.toString() : symbol.getShortName();
                }
            } else {
                symbolName = symbol.getShortName();
            }
        }
        return symbolName;
    }

    public static List getProjectedSymbolUniqueNames(Command command) {
        ArrayList<String> uniqueNames = new ArrayList<String>();
        List selectNames = TransformationSqlHelper.getProjectedSymbolNames(command);
        Iterator iter = selectNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!uniqueNames.contains(name)) {
                uniqueNames.add(name);
                continue;
            }
            String uniqueName = TransformationSqlHelper.getUniqueName(name, uniqueNames);
            uniqueNames.add(uniqueName);
        }
        return uniqueNames;
    }

    public static List getProjectedSymbolAndProcInputUniqueNames(Command command) {
        List uniqueNames = TransformationSqlHelper.getProjectedSymbolUniqueNames(command);
        List paramNames = TransformationSqlHelper.getProcedureInputParamNames(command);
        uniqueNames.addAll(paramNames);
        return uniqueNames;
    }

    public static List getProcedureInputParamNames(Command command) {
        List params = TransformationSqlHelper.getProcedureInputParams(command);
        ArrayList<String> result = new ArrayList<String>(params.size());
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            SPParameter param = (SPParameter)iter.next();
            String paramName = null;
            if (param.getExpression() == null) {
                paramName = param.getName() != null ? param.getName() : "?";
            } else {
                Expression exp = param.getExpression();
                if (exp instanceof ElementSymbol) {
                    paramName = ((ElementSymbol)exp).getShortName();
                }
            }
            if (paramName == null || TransformationSqlHelper.containsIgnoreCase(result, paramName)) continue;
            result.add(paramName);
        }
        return result;
    }

    private static boolean containsIgnoreCase(List strList, String str) {
        boolean contains = false;
        Iterator iter = strList.iterator();
        while (iter.hasNext()) {
            String listStr = (String)iter.next();
            if (listStr == null || !listStr.equalsIgnoreCase(str)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static List getProcedureInputParams(Command command) {
        if (command == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<SPParameter> inputParams = new ArrayList<SPParameter>();
        if (command instanceof StoredProcedure) {
            List procInParams = ((StoredProcedure)command).getInputParameters();
            inputParams.addAll(procInParams);
        }
        List commands = CommandCollectorVisitor.getCommands((LanguageObject)command);
        Iterator iter = commands.iterator();
        while (iter.hasNext()) {
            Command currentCommand = (Command)iter.next();
            if (!(currentCommand instanceof StoredProcedure)) continue;
            List params = ((StoredProcedure)currentCommand).getInputParameters();
            Iterator pIter = params.iterator();
            while (pIter.hasNext()) {
                SPParameter parm = (SPParameter)pIter.next();
                if (TransformationSqlHelper.spParamListContains(inputParams, parm)) continue;
                inputParams.add(parm);
            }
        }
        return inputParams;
    }

    private static boolean spParamListContains(List spParams, SPParameter newParam) {
        boolean containsParam = false;
        if (spParams != null) {
            Iterator iter = spParams.iterator();
            while (iter.hasNext()) {
                SPParameter param = (SPParameter)iter.next();
                if (!param.equals((Object)newParam)) continue;
                Object id1 = param.getMetadataID();
                Object id2 = newParam.getMetadataID();
                if (id1 == null || !id1.equals(id2)) continue;
                containsParam = true;
            }
        }
        return containsParam;
    }

    public static Map getProcInputParamEObjects(StoredProcedure storedProc) {
        HashMap<String, EObject> symbolEObjMap = new HashMap<String, EObject>();
        if (storedProc != null) {
            List inputParams = storedProc.getInputParameters();
            Iterator iter = inputParams.iterator();
            while (iter.hasNext()) {
                SPParameter param = (SPParameter)iter.next();
                ElementSymbol symbol = param.getParameterSymbol();
                String name = symbol.getShortName();
                EObject eObj = TransformationSqlHelper.getElementSymbolEObject(symbol);
                if (eObj == null) continue;
                symbolEObjMap.put(name, eObj);
            }
        }
        return symbolEObjMap;
    }

    public static String getUniqueName(String name, Collection collection) {
        if (collection == null) {
            collection = Collections.EMPTY_SET;
        }
        String result = name;
        int incr = 1;
        boolean nameIsInCollection = false;
        block0: do {
            nameIsInCollection = false;
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                if (!result.equalsIgnoreCase((String)i.next())) continue;
                nameIsInCollection = true;
                result = name + "_" + incr;
                ++incr;
                continue block0;
            }
        } while (nameIsInCollection);
        return result;
    }

    public static Map getProjectedSymbolUniqueTypes(Command command) {
        if (command != null) {
            HashMap<String, Object> symbolTypeMap = new HashMap<String, Object>();
            List symbols = command.getProjectedSymbols();
            Iterator symbolIter = symbols.iterator();
            while (symbolIter.hasNext()) {
                SingleElementSymbol symbol = (SingleElementSymbol)symbolIter.next();
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                Object typeObj = TransformationSqlHelper.getElementSymbolType(symbol);
                Set currentNames = symbolTypeMap.size() != 0 ? symbolTypeMap.keySet() : Collections.EMPTY_SET;
                String uniqueName = TransformationSqlHelper.getUniqueName(name, currentNames);
                symbolTypeMap.put(uniqueName, typeObj);
            }
            return symbolTypeMap;
        }
        return Collections.EMPTY_MAP;
    }

    public static Map getProjectedSymbolAndProcInputUniqueTypes(Command command) {
        if (command != null) {
            Map symbolTypeMap = TransformationSqlHelper.getProjectedSymbolUniqueTypes(command);
            List inputParams = TransformationSqlHelper.getProcedureInputParams(command);
            Iterator iter = inputParams.iterator();
            while (iter.hasNext()) {
                SPParameter param = (SPParameter)iter.next();
                ElementSymbol symbol = param.getParameterSymbol();
                String name = symbol.getShortName();
                Object eObj = TransformationSqlHelper.getElementSymbolType((SingleElementSymbol)symbol);
                symbolTypeMap.put(name, eObj);
            }
            return symbolTypeMap;
        }
        return Collections.EMPTY_MAP;
    }

    public static Map getProjectedSymbolEObjects(Command command) {
        HashMap<String, EObject> symbolEObjMap = new HashMap<String, EObject>();
        if (command != null) {
            List symbols = command.getProjectedSymbols();
            Iterator symbolIter = symbols.iterator();
            while (symbolIter.hasNext()) {
                SingleElementSymbol symbol = (SingleElementSymbol)symbolIter.next();
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                EObject eObj = null;
                if (symbol instanceof ElementSymbol) {
                    eObj = TransformationSqlHelper.getElementSymbolEObject((ElementSymbol)symbol);
                }
                Set currentNames = symbolEObjMap.size() != 0 ? symbolEObjMap.keySet() : Collections.EMPTY_SET;
                String uniqueName = TransformationSqlHelper.getUniqueName(name, currentNames);
                if (eObj == null) continue;
                symbolEObjMap.put(uniqueName, eObj);
            }
        }
        return symbolEObjMap;
    }

    public static Map getProjectedSymbolAndProcInputEObjects(Command command) {
        Map projectedSymbolEObjMap = TransformationSqlHelper.getProjectedSymbolEObjects(command);
        if (command != null) {
            List inputParams = TransformationSqlHelper.getProcedureInputParams(command);
            Iterator iter = inputParams.iterator();
            while (iter.hasNext()) {
                SPParameter param = (SPParameter)iter.next();
                ElementSymbol symbol = param.getParameterSymbol();
                String name = symbol.getShortName();
                EObject eObj = TransformationSqlHelper.getElementSymbolEObject(symbol);
                if (eObj == null) continue;
                projectedSymbolEObjMap.put(name, eObj);
            }
        }
        return projectedSymbolEObjMap;
    }

    public static Map getProjectedSymbolLengths(Command command, boolean hasXMLDocSource) {
        HashMap symbolLengthMap = new HashMap();
        if (command != null) {
            List symbols = command.getProjectedSymbols();
            Iterator symbolIter = symbols.iterator();
            while (symbolIter.hasNext()) {
                SingleElementSymbol symbol = (SingleElementSymbol)symbolIter.next();
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                Object typeObj = TransformationSqlHelper.getElementSymbolType(symbol);
                boolean xmlDocSourceCase = hasXMLDocSource && command instanceof CreateUpdateProcedureCommand;
                Set currentNames = symbolLengthMap.size() != 0 ? symbolLengthMap.keySet() : Collections.EMPTY_SET;
                String uniqueName = TransformationSqlHelper.getUniqueName(name, currentNames);
                TransformationSqlHelper.updateTypeLengthMap(symbolLengthMap, uniqueName, typeObj, symbol, xmlDocSourceCase);
            }
        }
        return symbolLengthMap;
    }

    public static Map getProjectedSymbolAndProcInputLengths(Command command, boolean hasXMLDocSource) {
        Map symbolLengthMap = TransformationSqlHelper.getProjectedSymbolLengths(command, hasXMLDocSource);
        if (command != null) {
            List inputParams = TransformationSqlHelper.getProcedureInputParams(command);
            Iterator paramIter = inputParams.iterator();
            while (paramIter.hasNext()) {
                SPParameter param = (SPParameter)paramIter.next();
                ElementSymbol symbol = param.getParameterSymbol();
                String name = symbol.getShortName();
                Object typeObj = TransformationSqlHelper.getElementSymbolType((SingleElementSymbol)symbol);
                boolean xmlDocSourceCase = hasXMLDocSource && command instanceof CreateUpdateProcedureCommand;
                TransformationSqlHelper.updateTypeLengthMap(symbolLengthMap, name, typeObj, (SingleElementSymbol)symbol, xmlDocSourceCase);
            }
        }
        return symbolLengthMap;
    }

    private static void updateTypeLengthMap(Map theMap, String name, Object typeObj, SingleElementSymbol symbol, boolean xmlDocSourceCase) {
        if (typeObj != null && typeObj instanceof XSDSimpleTypeDefinition) {
            String dtName = ((XSDSimpleTypeDefinition)typeObj).getName();
            if (("string".equals(dtName) || "char".equals(dtName)) && ModelerCore.getWorkspaceDatatypeManager().isBuiltInDatatype((EObject)((XSDSimpleTypeDefinition)typeObj))) {
                int length = TransformationSqlHelper.getElementSymbolLength(symbol);
                theMap.put(name, new Integer(length));
            } else {
                theMap.put(name, new Integer(-1));
            }
        } else if (typeObj != null) {
            if (typeObj instanceof Class) {
                if (xmlDocSourceCase) {
                    theMap.put(name, new Integer(Integer.MAX_VALUE));
                } else {
                    String className = ((Class)typeObj).getName();
                    if (className.equalsIgnoreCase("java.lang.String")) {
                        int stringLength = TransformationSqlHelper.getSymbolLength(symbol);
                        if (stringLength > 0) {
                            theMap.put(name, new Integer(stringLength));
                        } else {
                            theMap.put(name, new Integer(ModelerCore.getTransformationPreferences().getDefaultStringLength()));
                        }
                    } else if (className.equalsIgnoreCase("java.lang.Character")) {
                        theMap.put(name, new Integer(1));
                    } else {
                        theMap.put(name, new Integer(-1));
                    }
                }
            }
        } else {
            theMap.put(name, new Integer(-1));
        }
    }

    private static Function isStringFunction(SingleElementSymbol symbol) {
        ExpressionSymbol expressionSymbol = null;
        Function function = null;
        if (symbol instanceof AliasSymbol && ((AliasSymbol)symbol).getSymbol() instanceof ExpressionSymbol) {
            expressionSymbol = (ExpressionSymbol)((AliasSymbol)symbol).getSymbol();
        } else if (symbol instanceof ExpressionSymbol) {
            expressionSymbol = (ExpressionSymbol)symbol;
        }
        if (expressionSymbol != null && expressionSymbol.getExpression() instanceof Function) {
            function = (Function)expressionSymbol.getExpression();
            if (function.getName().equalsIgnoreCase("CONCAT") || function.getName().equalsIgnoreCase("||")) {
                return function;
            }
            if (TransformationSqlHelper.isDecodeOrSubString(function)) {
                return function;
            }
            return null;
        }
        return function;
    }

    private static boolean isDecodeOrSubString(Function function) {
        return function.getName().equalsIgnoreCase("decodestring") || function.getName().equalsIgnoreCase("substring");
    }

    private static int concatSymbolLength(Expression exprObject) {
        Expression[] args = null;
        ElementSymbol elSymbol = null;
        int stringLength = 0;
        if (exprObject instanceof Function) {
            Function myFunc = (Function)exprObject;
            if (TransformationSqlHelper.isDecodeOrSubString(myFunc)) {
                return stringLength += TransformationSqlHelper.getMaxStringLength(myFunc);
            }
            if (myFunc.getName().equalsIgnoreCase("chr")) {
                return ++stringLength;
            }
            args = myFunc.getArgs();
            for (int i = 0; i < args.length; ++i) {
                Expression symbol = args[i];
                if (symbol instanceof Function) {
                    stringLength += TransformationSqlHelper.concatSymbolLength(symbol);
                }
                if (symbol instanceof ElementSymbol && (elSymbol = (ElementSymbol)symbol) != null) {
                    Object mID = elSymbol.getMetadataID();
                    if (mID != null && mID instanceof ColumnRecord) {
                        int length = ((ColumnRecord)mID).getLength();
                        stringLength += length;
                    } else if (mID != null && mID instanceof ProcedureParameterRecord) {
                        int length = ((ProcedureParameterRecord)mID).getLength();
                        stringLength += length;
                    } else {
                        stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength();
                    }
                }
                if (!(symbol instanceof Constant)) continue;
                Constant constant = (Constant)args[i];
                Object value = constant.getValue();
                if (value != null && value instanceof String) {
                    stringLength += ((String)value).length();
                    continue;
                }
                stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength();
            }
        } else if (exprObject instanceof ElementSymbol) {
            elSymbol = (ElementSymbol)exprObject;
            if (elSymbol != null) {
                Object mID = elSymbol.getMetadataID();
                if (mID != null && mID instanceof ColumnRecord) {
                    int length = ((ColumnRecord)mID).getLength();
                    stringLength += length;
                } else if (mID != null && mID instanceof ProcedureParameterRecord) {
                    int length = ((ProcedureParameterRecord)mID).getLength();
                    stringLength += length;
                } else {
                    stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength();
                }
            }
        } else if (exprObject instanceof Constant) {
            Constant constant = (Constant)exprObject;
            Object value = constant.getValue();
            stringLength = value != null && value instanceof String ? (stringLength += ((String)value).length()) : (stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength());
        }
        return stringLength += 0;
    }

    public static int getSymbolLength(SingleElementSymbol symbol) {
        int stringLength = 0;
        Function function = null;
        function = TransformationSqlHelper.isStringFunction(symbol);
        if (function != null) {
            if (!TransformationSqlHelper.isDecodeOrSubString(function)) {
                Expression[] args = function.getArgs();
                ElementSymbol elSymbol = null;
                for (int i = 0; i < args.length; ++i) {
                    Constant constant;
                    Expression exprSymbol = args[i];
                    if (exprSymbol instanceof Function) {
                        stringLength += TransformationSqlHelper.concatSymbolLength(exprSymbol);
                    }
                    if (exprSymbol instanceof ElementSymbol && (elSymbol = (ElementSymbol)exprSymbol) != null) {
                        stringLength += TransformationSqlHelper.concatSymbolLength((Expression)elSymbol);
                    }
                    if (!(exprSymbol instanceof Constant) || (constant = (Constant)exprSymbol) == null) continue;
                    stringLength += TransformationSqlHelper.concatSymbolLength((Expression)constant);
                }
            } else if (TransformationSqlHelper.isDecodeOrSubString(function)) {
                stringLength += TransformationSqlHelper.getMaxStringLength(function);
            }
        } else {
            stringLength += 0;
        }
        return stringLength;
    }

    private static int getMaxStringLength(Function function) {
        Expression[] args = function.getArgs();
        Expression exprSymbol = args[0];
        if (function.getName().equalsIgnoreCase("decodestring")) {
            return TransformationSqlHelper.getDecodeLength(function);
        }
        return TransformationSqlHelper.concatSymbolLength(exprSymbol);
    }

    private static int getDecodeLength(Function function) {
        Constant constSym;
        Object constObj;
        ElementSymbol elmSymbol;
        Expression[] args = function.getArgs();
        Expression exprSymbol = null;
        int maxLength = 0;
        exprSymbol = args[0];
        if (exprSymbol instanceof ElementSymbol && (elmSymbol = (ElementSymbol)exprSymbol) != null) {
            int length;
            Object mID = elmSymbol.getMetadataID();
            maxLength = mID != null && mID instanceof ColumnRecord ? (length = ((ColumnRecord)mID).getLength()) : (mID != null && mID instanceof ProcedureParameterRecord ? (length = ((ProcedureParameterRecord)mID).getLength()) : ModelerCore.getTransformationPreferences().getDefaultStringLength());
        }
        if ((exprSymbol = args[1]) instanceof Constant && (constObj = (constSym = (Constant)exprSymbol).getValue()) != null && constObj instanceof String) {
            String decodes = (String)constObj;
            String delimiter = ",";
            if (args.length == 3 && (constObj = (constSym = (Constant)(exprSymbol = args[2])).getValue()) != null && constObj instanceof String) {
                delimiter = (String)constObj;
            }
            StringTokenizer strTok = new StringTokenizer(decodes, delimiter);
            while (strTok.hasMoreTokens()) {
                String word = strTok.nextToken().trim();
                if (word.length() <= maxLength) continue;
                maxLength = word.length();
            }
        }
        return maxLength;
    }

    public static List getProjectedSymbolTypes(Command command) {
        ArrayList<Object> selectTypes = new ArrayList<Object>();
        if (command != null) {
            List symbols = command.getProjectedSymbols();
            Iterator iter = symbols.iterator();
            while (iter.hasNext()) {
                SingleElementSymbol symbol = (SingleElementSymbol)iter.next();
                selectTypes.add(TransformationSqlHelper.getElementSymbolType(symbol));
            }
        }
        return selectTypes;
    }

    public static Map getRenamedSymbolsMap(List symbols) {
        HashMap<String, SingleElementSymbol> renameMap = new HashMap<String, SingleElementSymbol>();
        ArrayList<Object> seSymbols = new ArrayList<Object>();
        Iterator symbolIter = symbols.iterator();
        while (symbolIter.hasNext()) {
            SelectSymbol sSymbol = (SelectSymbol)symbolIter.next();
            if (sSymbol instanceof MultipleElementSymbol) {
                List meSymbols = ((MultipleElementSymbol)sSymbol).getElementSymbols();
                if (meSymbols == null) continue;
                Iterator meIter = meSymbols.iterator();
                while (meIter.hasNext()) {
                    ElementSymbol eSymbol = (ElementSymbol)meIter.next();
                    if (eSymbol == null) continue;
                    seSymbols.add(eSymbol);
                }
                continue;
            }
            if (!(sSymbol instanceof SingleElementSymbol)) continue;
            seSymbols.add(sSymbol);
        }
        ArrayList<String> elementNames = new ArrayList<String>();
        symbolIter = seSymbols.iterator();
        while (symbolIter.hasNext()) {
            String name;
            SingleElementSymbol seSymbol = (SingleElementSymbol)symbolIter.next();
            String uniqueName = name = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol, false);
            SingleElementSymbol underlyingSymbol = seSymbol;
            if (seSymbol instanceof AliasSymbol) {
                underlyingSymbol = ((AliasSymbol)seSymbol).getSymbol();
            }
            if (underlyingSymbol instanceof ElementSymbol) {
                ElementSymbol eSymbol = (ElementSymbol)underlyingSymbol;
                uniqueName = TransformationSqlHelper.getUniqueName(name, elementNames);
                Object idObj = eSymbol.getMetadataID();
                if (idObj != null && idObj instanceof MetadataRecord) {
                    elementNames.add(uniqueName);
                }
            } else if (underlyingSymbol instanceof ExpressionSymbol) {
                uniqueName = TransformationSqlHelper.getUniqueName(name, elementNames);
                elementNames.add(uniqueName);
            }
            if (uniqueName.equals(name)) continue;
            renameMap.put(uniqueName, seSymbol);
        }
        return renameMap;
    }

    private static List createFromClauses(List sqlAliases) {
        ArrayList<Object> result = new ArrayList<Object>(sqlAliases.size());
        Iterator iter = sqlAliases.iterator();
        while (iter.hasNext()) {
            SubqueryFromClause clause;
            SqlAlias sqlAlias = (SqlAlias)iter.next();
            EObject aliasedEObject = sqlAlias.getAliasedObject();
            if (TransformationHelper.isSqlTable((Object)aliasedEObject)) {
                GroupSymbol gSymbol = TransformationSqlHelper.createGroupSymbol((EObject)sqlAlias);
                result.add(new UnaryFromClause(gSymbol));
                continue;
            }
            if (!TransformationHelper.isSqlProcedure((Object)aliasedEObject) || (clause = TransformationSqlHelper.createSubqueryFromClause((EObject)sqlAlias)) == null) continue;
            result.add(clause);
        }
        return result;
    }

    private static FromClause createFromClause(EObject eObject) {
        ArgCheck.isNotNull((Object)eObject);
        EObject theEObj = eObject;
        if (eObject instanceof SqlAlias) {
            theEObj = ((SqlAlias)eObject).getAliasedObject();
        }
        UnaryFromClause fromClause = null;
        if (TransformationHelper.isSqlTable((Object)theEObj)) {
            fromClause = new UnaryFromClause(TransformationSqlHelper.createGroupSymbol(eObject));
        } else if (TransformationHelper.isSqlProcedure((Object)theEObj)) {
            fromClause = TransformationSqlHelper.createSubqueryFromClause(eObject);
        }
        return fromClause;
    }

    private static List createGroupSymbols(List groupEObjs) {
        ArrayList<GroupSymbol> result = new ArrayList<GroupSymbol>(groupEObjs.size());
        Iterator iter = groupEObjs.iterator();
        while (iter.hasNext()) {
            EObject eObj = (EObject)iter.next();
            GroupSymbol gSymbol = TransformationSqlHelper.createGroupSymbol(eObj);
            if (gSymbol == null) continue;
            result.add(gSymbol);
        }
        return result;
    }

    private static SubqueryFromClause createSubqueryFromClause(EObject eObj) {
        StoredProcedure storedProc;
        ArgCheck.isNotNull((Object)eObj);
        SubqueryFromClause subqueryFromClause = null;
        String aliasName = null;
        if (eObj instanceof SqlAlias) {
            SqlAlias sqlAlias = (SqlAlias)eObj;
            aliasName = sqlAlias.getAlias();
            eObj = sqlAlias.getAliasedObject();
        }
        if ((storedProc = TransformationSqlHelper.createStoredProc(eObj)) != null) {
            subqueryFromClause = aliasName != null ? new SubqueryFromClause(aliasName, (Command)storedProc) : new SubqueryFromClause("Proc", (Command)storedProc);
        }
        return subqueryFromClause;
    }

    public static StoredProcedure createStoredProc(EObject eObj) {
        ArgCheck.isNotNull((Object)eObj);
        StoredProcedure storedProc = null;
        if (eObj instanceof SqlAlias) {
            SqlAlias sqlAlias = (SqlAlias)eObj;
            eObj = sqlAlias.getAliasedObject();
        }
        if (TransformationHelper.isSqlProcedure((Object)eObj)) {
            SqlColumnSetAspect rsAspect;
            List rsCols;
            SqlProcedureAspect procedureAspect = (SqlProcedureAspect)AspectManager.getSqlAspect((EObject)eObj);
            String procFullName = procedureAspect.getFullName(eObj);
            storedProc = new StoredProcedure();
            storedProc.setProcedureName(procFullName);
            List procParams = procedureAspect.getParameters(eObj);
            List spParams = TransformationSqlHelper.createSPParams(procParams);
            Iterator iter = spParams.iterator();
            while (iter.hasNext()) {
                storedProc.setParameter((SPParameter)iter.next());
            }
            EObject results = (EObject)procedureAspect.getResult(eObj);
            if (SqlAspectHelper.isProcedureResultSet((EObject)results) && (rsCols = (rsAspect = (SqlColumnSetAspect)SqlAspectHelper.getSqlAspect((EObject)results)).getColumns(results)).size() > 0) {
                SPParameter param = new SPParameter(spParams.size(), 5, "RESULT");
                param.addResultSetColumn("RESULT", class$java$lang$String == null ? (class$java$lang$String = TransformationSqlHelper.class$("java.lang.String")) : class$java$lang$String, (Object)"RESULT");
                storedProc.setParameter(param);
            }
        }
        return storedProc;
    }

    public static GroupSymbol createGroupSymbol(EObject groupEObj) {
        GroupSymbol gSymbol = null;
        String aliasName = null;
        if (groupEObj instanceof SqlAlias) {
            SqlAlias sqlAlias = (SqlAlias)groupEObj;
            aliasName = sqlAlias.getAlias();
            groupEObj = sqlAlias.getAliasedObject();
        }
        if (SqlAspectHelper.isTable((EObject)groupEObj)) {
            SqlTableAspect tableAspect = (SqlTableAspect)AspectManager.getSqlAspect((EObject)groupEObj);
            boolean hasResource = groupEObj.eResource() != null;
            String tableFullName = tableAspect.getName(groupEObj);
            if (hasResource) {
                tableFullName = tableAspect.getFullName(groupEObj);
            }
            String tableShortName = tableAspect.getName(groupEObj);
            Object groupID = null;
            if (hasResource) {
                groupID = TransformationSqlHelper.getGroupID(tableFullName, groupEObj);
            }
            gSymbol = aliasName != null && !aliasName.equalsIgnoreCase(tableShortName) ? new GroupSymbol(aliasName, tableFullName) : new GroupSymbol(tableFullName);
            if (groupID != null) {
                gSymbol.setMetadataID(groupID);
            }
        } else if (groupEObj instanceof InputSet) {
            String inputSetFullName = "InputSet";
            String inputSetShortName = "InputSet";
            gSymbol = aliasName != null && !aliasName.equalsIgnoreCase(inputSetShortName) ? new GroupSymbol(aliasName, inputSetFullName) : new GroupSymbol(inputSetFullName);
        }
        return gSymbol;
    }

    private static Object getElementID(String elementFullName, EObject elmntObj) {
        ColumnRecordImpl elemID = null;
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)elmntObj);
        elemID = new ColumnRecordImpl(sqlAspect, elmntObj);
        return elemID;
    }

    private static Object getGroupID(String groupFullName, EObject grpObj) {
        TableRecordImpl groupID = null;
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)grpObj);
        groupID = new TableRecordImpl(sqlAspect, grpObj);
        return groupID;
    }

    private static StoredProcedureInfo getProcInfo(String procFullName, EObject procObj) {
        StoredProcedureInfo procInfo = null;
        try {
            QueryMetadataInterface resolver = TransformationMetadataFactory.getInstance().getModelerMetadata(procObj);
            procInfo = resolver.getStoredProcedureInfoForProcedure(procFullName);
        }
        catch (QueryMetadataException e) {
            String message = TransformationPlugin.Util.getString("TransformationSqlHelper.groupIDNotFoundError", (Object)procFullName);
            TransformationPlugin.Util.log(2, (Throwable)e, message);
        }
        catch (MetaMatrixComponentException e) {
            String message = TransformationPlugin.Util.getString("TransformationSqlHelper.groupIDNotFoundError", (Object)procFullName);
            TransformationPlugin.Util.log(2, (Throwable)e, message);
        }
        return procInfo;
    }

    private static List createElemSymbols(List sqlAliasGroups) {
        ArrayList result = new ArrayList();
        Iterator iter = sqlAliasGroups.iterator();
        while (iter.hasNext()) {
            SqlAlias groupSqlAlias = (SqlAlias)iter.next();
            result.addAll(TransformationSqlHelper.createElemSymbols(groupSqlAlias));
        }
        return result;
    }

    private static List createElemSymbols(SqlAlias groupSqlAlias) {
        ArrayList<SingleElementSymbol> result = new ArrayList<SingleElementSymbol>();
        GroupSymbol groupSymbol = TransformationSqlHelper.createGroupSymbol((EObject)groupSqlAlias);
        EObject groupEObj = groupSqlAlias.getAliasedObject();
        if (SqlAspectHelper.isTable((EObject)groupEObj)) {
            SqlTableAspect tableAspect = (SqlTableAspect)AspectManager.getSqlAspect((EObject)groupEObj);
            List columns = tableAspect.getColumns(groupEObj);
            Iterator columnIter = columns.iterator();
            SingleElementSymbol seSymbol = null;
            while (columnIter.hasNext()) {
                EObject columnEObj = (EObject)columnIter.next();
                seSymbol = TransformationSqlHelper.createElemSymbol(columnEObj, groupSymbol);
                result.add(seSymbol);
            }
        }
        return result;
    }

    public static SingleElementSymbol createElemSymbol(EObject elemEObj, GroupSymbol parentGroupSymbol) {
        InputParameterSqlAspect aspect;
        ElementSymbol seSymbol = null;
        boolean isUUIDGroup = false;
        String tableName = parentGroupSymbol.getName();
        if (tableName == null) {
            tableName = "";
        } else if (SqlConverter.isStringifiedUUID((String)tableName)) {
            isUUIDGroup = true;
        }
        String columnAliasName = null;
        if (elemEObj instanceof SqlAlias) {
            SqlAlias columnAlias = (SqlAlias)elemEObj;
            columnAliasName = columnAlias.getAlias();
            elemEObj = columnAlias.getAliasedObject();
        }
        if (TransformationHelper.isSqlInputParameter((Object)elemEObj)) {
            aspect = (InputParameterSqlAspect)AspectManager.getSqlAspect((EObject)elemEObj);
            String fullName = null;
            fullName = isUUIDGroup ? TransformationHelper.getSqlEObjectUUID((EObject)elemEObj) : tableName + "." + aspect.getName(elemEObj);
            ElementSymbol element = new ElementSymbol(fullName);
            element.setGroupSymbol(parentGroupSymbol);
            if (aspect != null) {
                String rtType = aspect.getRuntimeType(elemEObj);
                if (rtType != null) {
                    Class clazz = DataTypeManager.getDataTypeClass((String)rtType);
                    element.setMetadataID((Object)new TempMetadataID(fullName.toUpperCase(), clazz));
                    element.setType(clazz);
                } else {
                    element.setMetadataID((Object)new TempMetadataID(fullName.toUpperCase(), DataTypeManager.DefaultDataClasses.NULL));
                    element.setType(DataTypeManager.DefaultDataClasses.NULL);
                }
            } else {
                element.setMetadataID((Object)new TempMetadataID(fullName.toUpperCase(), DataTypeManager.DefaultDataClasses.NULL));
                element.setType(DataTypeManager.DefaultDataClasses.NULL);
            }
            seSymbol = element;
        } else if (SqlAspectHelper.isColumn((EObject)elemEObj)) {
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)elemEObj);
            String colShortName = columnAspect.getName(elemEObj);
            String colUUID = TransformationHelper.getSqlEObjectUUID((EObject)elemEObj);
            Object elemID = TransformationSqlHelper.getElementID(colUUID, elemEObj);
            if (columnAliasName != null) {
                ElementSymbol elemSymbol = null;
                elemSymbol = isUUIDGroup ? new ElementSymbol(colUUID) : new ElementSymbol(tableName + "." + colShortName);
                elemSymbol.setGroupSymbol(parentGroupSymbol);
                if (elemID != null) {
                    elemSymbol.setMetadataID(elemID);
                }
                seSymbol = new AliasSymbol(columnAliasName, (SingleElementSymbol)elemSymbol);
            } else {
                ElementSymbol elemSymbol = null;
                elemSymbol = isUUIDGroup ? new ElementSymbol(colUUID) : new ElementSymbol(tableName + "." + colShortName);
                elemSymbol.setGroupSymbol(parentGroupSymbol);
                if (elemID != null) {
                    elemSymbol.setMetadataID(elemID);
                }
                seSymbol = elemSymbol;
            }
        } else if (TransformationHelper.isSqlProcedureParameter((Object)elemEObj)) {
            aspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)elemEObj);
            String paramName = null;
            paramName = isUUIDGroup ? TransformationHelper.getSqlEObjectUUID((EObject)elemEObj) : TransformationHelper.getSqlEObjectFullName((EObject)elemEObj);
            ElementSymbol element = new ElementSymbol(paramName);
            element.setGroupSymbol(parentGroupSymbol);
            if (aspect != null) {
                String rtType = aspect.getRuntimeType(elemEObj);
                if (rtType != null) {
                    Class clazz = DataTypeManager.getDataTypeClass((String)rtType);
                    element.setMetadataID((Object)new TempMetadataID(paramName.toUpperCase(), clazz));
                    element.setType(clazz);
                } else {
                    element.setMetadataID((Object)new TempMetadataID(paramName.toUpperCase(), DataTypeManager.DefaultDataClasses.NULL));
                    element.setType(DataTypeManager.DefaultDataClasses.NULL);
                }
            } else {
                element.setMetadataID((Object)new TempMetadataID(paramName.toUpperCase(), DataTypeManager.DefaultDataClasses.NULL));
                element.setType(DataTypeManager.DefaultDataClasses.NULL);
            }
            seSymbol = element;
        }
        return seSymbol;
    }

    public static List renameConflictingSymbols(List seSymbols) {
        ArrayList<Object> newSymbols = new ArrayList<Object>();
        Map renamedSymbolsMap = TransformationSqlHelper.getRenamedSymbolsMap(seSymbols);
        if (renamedSymbolsMap.size() != 0) {
            HashMap workingRenSymMap = new HashMap(renamedSymbolsMap);
            for (int i = 0; i < seSymbols.size(); ++i) {
                SelectSymbol currentSelectSymbol = (SelectSymbol)seSymbols.get(i);
                if (currentSelectSymbol instanceof MultipleElementSymbol) {
                    boolean shouldExpand = TransformationSqlHelper.shouldExpand((MultipleElementSymbol)currentSelectSymbol, workingRenSymMap);
                    if (shouldExpand) {
                        List multiElemSymbols = ((MultipleElementSymbol)currentSelectSymbol).getElementSymbols();
                        Iterator iter = multiElemSymbols.iterator();
                        while (iter.hasNext()) {
                            SingleElementSymbol renamedSymbol = TransformationSqlHelper.renameSymbolUsingMap((SingleElementSymbol)iter.next(), workingRenSymMap);
                            newSymbols.add(renamedSymbol);
                        }
                        continue;
                    }
                    newSymbols.add(currentSelectSymbol);
                    continue;
                }
                if (!(currentSelectSymbol instanceof SingleElementSymbol)) continue;
                SingleElementSymbol renamedSymbol = TransformationSqlHelper.renameSymbolUsingMap((SingleElementSymbol)currentSelectSymbol, workingRenSymMap);
                newSymbols.add(renamedSymbol);
            }
        } else {
            newSymbols.addAll(seSymbols);
        }
        return newSymbols;
    }

    private static boolean shouldExpand(MultipleElementSymbol multiElemSymbol, Map renamedSymbolsMap) {
        boolean shouldExpand = false;
        List multiElemSymbols = multiElemSymbol.getElementSymbols();
        Collection renamedSymbols = renamedSymbolsMap.values();
        Iterator iter = renamedSymbols.iterator();
        while (iter.hasNext()) {
            if (!multiElemSymbols.contains(iter.next())) continue;
            shouldExpand = true;
            break;
        }
        return shouldExpand;
    }

    private static SingleElementSymbol renameSymbolUsingMap(SingleElementSymbol seSymbol, Map renamedSymbolsMap) {
        SingleElementSymbol resultSymbol = seSymbol;
        if (seSymbol != null) {
            Iterator renamedIter = renamedSymbolsMap.keySet().iterator();
            while (renamedIter.hasNext()) {
                String newName = (String)renamedIter.next();
                SingleElementSymbol renamedSymbol = (SingleElementSymbol)renamedSymbolsMap.get(newName);
                if (!renamedSymbol.equals((Object)seSymbol)) continue;
                if (seSymbol instanceof AliasSymbol) {
                    seSymbol.setName(newName);
                    resultSymbol = seSymbol;
                } else {
                    resultSymbol = new AliasSymbol(newName, seSymbol);
                }
                renamedSymbolsMap.remove(newName);
                break;
            }
        }
        return resultSymbol;
    }

    private static List createSPParams(List procParams) {
        ArrayList<SPParameter> spparams = new ArrayList<SPParameter>(procParams.size());
        int index = 0;
        block6: for (int i = 0; i < procParams.size(); ++i) {
            EObject paramObject = (EObject)procParams.get(i);
            SqlAspect sqlAspect = SqlAspectHelper.getSqlAspect((EObject)paramObject);
            if (!(sqlAspect instanceof SqlProcedureParameterAspect)) continue;
            SqlProcedureParameterAspect paramAspect = (SqlProcedureParameterAspect)sqlAspect;
            int direction = paramAspect.getType(paramObject);
            String name = paramAspect.getName(paramObject);
            switch (direction) {
                case 0: {
                    SPParameter spparam1 = new SPParameter(index, (Expression)new ElementSymbol(name));
                    spparam1.setName(name);
                    spparam1.setParameterType(1);
                    spparams.add(spparam1);
                    ++index;
                    continue block6;
                }
                case 2: {
                    SPParameter spparam2 = new SPParameter(index, (Expression)new ElementSymbol(name));
                    spparam2.setName(name);
                    spparam2.setParameterType(3);
                    spparams.add(spparam2);
                    ++index;
                    continue block6;
                }
                case 1: {
                    SPParameter spparam3 = new SPParameter(index, (Expression)new ElementSymbol(name));
                    spparam3.setName(name);
                    spparam3.setParameterType(2);
                    spparams.add(spparam3);
                    ++index;
                    continue block6;
                }
                case 3: {
                    SPParameter spparam4 = new SPParameter(index, (Expression)new ElementSymbol(name));
                    spparam4.setName(name);
                    spparam4.setParameterType(4);
                    spparams.add(spparam4);
                    ++index;
                }
            }
        }
        return spparams;
    }

    public static String getGroupSymbolShortName(GroupSymbol gSymbol) {
        String shortName = null;
        if (gSymbol != null) {
            String symbolDefn = gSymbol.getDefinition();
            String symbolName = gSymbol.getName();
            if (symbolDefn != null) {
                shortName = symbolName;
            } else {
                EObject eObj = TransformationSqlHelper.getGroupSymbolEObject(gSymbol);
                shortName = TransformationHelper.getSqlEObjectName((EObject)eObj);
            }
        }
        return shortName;
    }

    public static Collection getGroupSymbols(Command command) {
        Collection allGrps = GroupCollectorVisitor.getGroupsIgnoreInlineViews((LanguageObject)command, (boolean)false);
        ArrayList<GroupSymbol> result = new ArrayList<GroupSymbol>(allGrps.size());
        Iterator iter = allGrps.iterator();
        while (iter.hasNext()) {
            GroupSymbol gSymbol = (GroupSymbol)iter.next();
            if (TransformationSqlHelper.containsGroupSymbol(result, gSymbol)) continue;
            result.add(gSymbol);
        }
        return result;
    }

    private static boolean containsGroupSymbol(Collection symbols, GroupSymbol gSymbol) {
        boolean result = false;
        String gSymbName = gSymbol.getCanonicalName();
        String gSymbDefn = gSymbol.getDefinition();
        Iterator iter = symbols.iterator();
        while (iter.hasNext()) {
            GroupSymbol listSymbol = (GroupSymbol)iter.next();
            String lSymbName = listSymbol.getCanonicalName();
            String lSymbDefn = listSymbol.getDefinition();
            if (lSymbDefn == null && gSymbDefn == null) {
                if (!lSymbName.equals(gSymbName)) continue;
                result = true;
                break;
            }
            if (lSymbDefn == null || gSymbDefn == null || !lSymbDefn.equalsIgnoreCase(gSymbDefn) || !lSymbName.equals(gSymbName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static int getReferenceCount(Object transMappingRoot, int type) {
        Command command = TransformationHelper.getCommand((Object)transMappingRoot, (int)type);
        int refCount = 0;
        if (command != null) {
            ArrayList refs = new ArrayList();
            ReferenceCollectorVisitor.getReferences((LanguageObject)command, refs);
            refCount = refs.size();
        }
        return refCount;
    }

    public static EObject getElementSymbolEObject(ElementSymbol symbol) {
        Object elemObj;
        EObject result = null;
        if (symbol != null && (elemObj = symbol.getMetadataID()) != null) {
            if (elemObj instanceof MetadataRecord) {
                result = ((MetadataRecord)elemObj).getEObject();
            } else if (TransformationHelper.isSqlColumn((Object)elemObj)) {
                result = (EObject)elemObj;
            }
        }
        return result;
    }

    public static EObject getElementSymbolEObject(ElementSymbol symbol, Command command) {
        Object elemObj;
        EObject result = null;
        if (symbol != null && (elemObj = symbol.getMetadataID()) != null) {
            if (elemObj instanceof MetadataRecord) {
                result = ((MetadataRecord)elemObj).getEObject();
            } else if (elemObj instanceof TempMetadataID) {
                String elemSymbolName = symbol.getShortName();
                GroupSymbol elemGrpSymbol = symbol.getGroupSymbol();
                List subQryFromClauses = SubqueryFromClauseCollectorVisitor.getClauses((LanguageObject)command);
                Iterator sqFromIter = subQryFromClauses.iterator();
                block0: while (sqFromIter.hasNext()) {
                    Command sqCommand;
                    SubqueryFromClause clause = (SubqueryFromClause)sqFromIter.next();
                    GroupSymbol sqGrpSymbol = clause.getGroupSymbol();
                    if (sqGrpSymbol == null || elemGrpSymbol == null || !sqGrpSymbol.getName().equals(elemGrpSymbol.getName()) || !((sqCommand = clause.getCommand()) instanceof StoredProcedure)) continue;
                    List resultSetParams = TransformationHelper.getProcedureResultSetParameters((StoredProcedure)((StoredProcedure)sqCommand));
                    Iterator paramIter = resultSetParams.iterator();
                    while (paramIter.hasNext()) {
                        SqlColumnAspect sqlColAspect;
                        String colName;
                        Object param = paramIter.next();
                        if (!TransformationHelper.isSqlColumn(param) || (colName = (sqlColAspect = (SqlColumnAspect)SqlAspectHelper.getSqlAspect((EObject)((EObject)param))).getName((EObject)param)) == null || !colName.equalsIgnoreCase(elemSymbolName)) continue;
                        result = (EObject)param;
                        continue block0;
                    }
                }
            }
        }
        return result;
    }

    public static Object getElementSymbolType(SingleElementSymbol symbol) {
        Class datatype = null;
        if (symbol instanceof AliasSymbol) {
            symbol = ((AliasSymbol)symbol).getSymbol();
        }
        if (symbol instanceof ElementSymbol) {
            ElementSymbol eSymbol = (ElementSymbol)symbol;
            Object idObj = eSymbol.getMetadataID();
            if (idObj instanceof MetadataRecord) {
                EObject recordEObj = ((MetadataRecord)idObj).getEObject();
                if (recordEObj != null && TransformationHelper.isSqlColumn((Object)recordEObj)) {
                    SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)recordEObj);
                    datatype = columnAspect.getDatatype(recordEObj);
                }
            } else if (idObj instanceof TempMetadataID) {
                datatype = ((TempMetadataID)idObj).getType();
            } else if (idObj == null) {
                datatype = eSymbol.getType();
            }
        } else if (symbol instanceof ExpressionSymbol) {
            ExpressionSymbol exSymbol = (ExpressionSymbol)symbol;
            datatype = exSymbol.getType();
        }
        return datatype;
    }

    public static int getElementSymbolLength(SingleElementSymbol symbol) {
        ElementSymbol eSymbol;
        EObject eObj;
        int length = -1;
        if (symbol instanceof AliasSymbol) {
            symbol = ((AliasSymbol)symbol).getSymbol();
        }
        if (symbol instanceof ElementSymbol && (eObj = TransformationSqlHelper.getElementSymbolEObject(eSymbol = (ElementSymbol)symbol)) != null) {
            length = TransformationHelper.getSqlColumnLength((EObject)eObj);
        }
        return length;
    }

    public static List getElementSymbolEObjects(Collection elemSymbols, Command command) {
        ArrayList<EObject> result = Collections.EMPTY_LIST;
        if (elemSymbols != null) {
            result = new ArrayList<EObject>(elemSymbols.size());
            Iterator iter = elemSymbols.iterator();
            while (iter.hasNext()) {
                ElementSymbol eSymbol = (ElementSymbol)iter.next();
                EObject elemEObj = TransformationSqlHelper.getElementSymbolEObject(eSymbol, command);
                if (elemEObj == null) continue;
                result.add(elemEObj);
            }
        }
        return result;
    }

    public static EObject getGroupSymbolEObject(GroupSymbol symbol) {
        Object groupObj;
        EObject result = null;
        if (symbol != null && (groupObj = symbol.getMetadataID()) != null) {
            if (groupObj instanceof MetadataRecord) {
                result = ((MetadataRecord)groupObj).getEObject();
            } else if (TransformationHelper.isSqlProcedureResultSet((Object)groupObj)) {
                result = (EObject)groupObj;
            }
        }
        return result;
    }

    public static List getGroupSymbolEObjects(Collection groupSymbols) {
        ArrayList<EObject> result = Collections.EMPTY_LIST;
        if (groupSymbols != null) {
            result = new ArrayList<EObject>(groupSymbols.size());
            Iterator iter = groupSymbols.iterator();
            while (iter.hasNext()) {
                GroupSymbol gSymbol = (GroupSymbol)iter.next();
                EObject grpEObj = TransformationSqlHelper.getGroupSymbolEObject(gSymbol);
                if (grpEObj == null) continue;
                result.add(grpEObj);
            }
        }
        return result;
    }

    public static EObject getStoredProcedureEObject(StoredProcedure storedProc) {
        Object procID;
        EObject result = null;
        if (storedProc != null && (procID = storedProc.getProcedureID()) != null && procID instanceof MetadataRecord) {
            result = ((MetadataRecord)procID).getEObject();
        }
        return result;
    }

    public static boolean hasSqlAliasGroupAttributes(Query query, List sqlAliasGroups) {
        boolean result = false;
        List aliasGroupSymbols = TransformationSqlHelper.createGroupSymbols(sqlAliasGroups);
        if (!TransformationSqlHelper.isSelectStar(query.getSelect())) {
            Collection selectElements = ElementCollectorVisitor.getElements((LanguageObject)query.getSelect(), (boolean)true);
            Iterator iter = selectElements.iterator();
            while (iter.hasNext()) {
                ElementSymbol selectElem = (ElementSymbol)iter.next();
                Collection symbolGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)selectElem);
                Iterator symbolGroupIter = symbolGroups.iterator();
                while (symbolGroupIter.hasNext()) {
                    GroupSymbol groupSymbol = (GroupSymbol)symbolGroupIter.next();
                    if (!aliasGroupSymbols.contains(groupSymbol)) continue;
                    result = true;
                    break;
                }
                if (!result) continue;
                break;
            }
        }
        return result;
    }

    public static boolean hasSqlElemSymbols(Query query, List elemEObjs) {
        boolean result = false;
        List projSymbolNames = TransformationSqlHelper.getProjectedSymbolNames((Command)query);
        Iterator iter = elemEObjs.iterator();
        while (iter.hasNext()) {
            SqlColumnAspect columnAspect;
            Object elem = iter.next();
            if (!(elem instanceof EObject) || !SqlAspectHelper.isColumn((EObject)((EObject)elem)) || !projSymbolNames.contains((columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)((EObject)elem))).getName((EObject)elem))) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isSelectStar(Select select) {
        SelectSymbol singleSelectSymbol;
        boolean result = false;
        List currentSelectSymbols = select.getSymbols();
        if (currentSelectSymbols.size() == 1 && (singleSelectSymbol = (SelectSymbol)currentSelectSymbols.get(0)) instanceof AllSymbol) {
            result = true;
        }
        return result;
    }

    public static ExpressionSymbol convert(ExpressionSymbol exprSymbol, String newTypeName) {
        ExpressionSymbol newExpressionSymbol = (ExpressionSymbol)exprSymbol.clone();
        Expression expr = exprSymbol.getExpression();
        Class originalTypeClass = expr.getType();
        String originalTypeName = DataTypeManager.getDataTypeName((Class)originalTypeClass);
        if (!originalTypeName.equalsIgnoreCase(newTypeName)) {
            if (TransformationSqlHelper.isConvertFunction(exprSymbol)) {
                Expression convExpr = TransformationSqlHelper.getConvertedExpr(exprSymbol);
                Class convExprTypeClass = convExpr.getType();
                String convExprTypeName = DataTypeManager.getDataTypeName((Class)convExprTypeClass);
                boolean isExplicit = DataTypeManager.isExplicitConversion((String)convExprTypeName, (String)newTypeName);
                boolean isImplicit = DataTypeManager.isImplicitConversion((String)convExprTypeName, (String)newTypeName);
                if (isExplicit || isImplicit) {
                    Function func = TransformationSqlHelper.getConversion(convExprTypeName, newTypeName, convExpr);
                    newExpressionSymbol.setExpression((Expression)func);
                } else {
                    Function convertFunction = TransformationSqlHelper.getConversion(originalTypeName, newTypeName, expr);
                    newExpressionSymbol.setExpression((Expression)convertFunction);
                }
            } else {
                Function convertFunction = TransformationSqlHelper.getConversion(originalTypeName, newTypeName, expr);
                newExpressionSymbol.setExpression((Expression)convertFunction);
            }
        }
        return newExpressionSymbol;
    }

    public static AliasSymbol convert(ElementSymbol elementSymbol, String newTypeName, String aliasName) {
        Class originalTypeClass = elementSymbol.getType();
        String originalTypeName = DataTypeManager.getDataTypeName((Class)originalTypeClass);
        Function convertFunction = TransformationSqlHelper.getConversion(originalTypeName, newTypeName, (Expression)elementSymbol);
        ExpressionSymbol exprSymbol = new ExpressionSymbol(NEW_CONVERSION_NAME, (Expression)convertFunction);
        AliasSymbol newSymbol = null;
        newSymbol = aliasName != null ? new AliasSymbol(aliasName, (SingleElementSymbol)exprSymbol) : new AliasSymbol(elementSymbol.getShortName(), (SingleElementSymbol)exprSymbol);
        return newSymbol;
    }

    public static Function getConversion(String originalTypeName, String newTypeName, Expression expression) {
        Class originalType = DataTypeManager.getDataTypeClass((String)originalTypeName);
        FunctionLibrary library = FunctionLibraryManager.getFunctionLibrary();
        FunctionDescriptor fd = library.findFunction("convert", new Class[]{originalType, DataTypeManager.DefaultDataClasses.STRING});
        Function conversion = new Function(fd.getName(), new Expression[]{expression, new Constant((Object)newTypeName)});
        conversion.setType(DataTypeManager.getDataTypeClass((String)newTypeName));
        conversion.setFunctionDescriptor(fd);
        return conversion;
    }

    public static boolean isConvertFunction(ExpressionSymbol exprSymbol) {
        String fName;
        Expression expr = exprSymbol.getExpression();
        return expr instanceof Function && (fName = ((Function)expr).getName()).equalsIgnoreCase("CONVERT");
    }

    public static Expression getConvertedExpr(ExpressionSymbol exprSymbol) {
        if (TransformationSqlHelper.isConvertFunction(exprSymbol)) {
            Expression expr = exprSymbol.getExpression();
            Expression fExp = ((Function)expr).getArg(0);
            return fExp;
        }
        return null;
    }

    public static AliasSymbol convertElementSymbol(ElementSymbol symbol, String targetTypeStr, String aliasName) {
        return TransformationSqlHelper.convert(symbol, targetTypeStr, aliasName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExpressionSymbol convertExpressionSymbol(ExpressionSymbol symbol, String targetTypeStr) {
        AliasSymbol aSymbol;
        SingleElementSymbol aseSymbol;
        if (!TransformationSqlHelper.isConvertFunction(symbol)) return TransformationSqlHelper.convert(symbol, targetTypeStr);
        Expression cExpr = TransformationSqlHelper.getConvertedExpr(symbol);
        if (!(cExpr instanceof SingleElementSymbol)) return null;
        SingleElementSymbol seSymbol = (SingleElementSymbol)cExpr;
        String seSymbolTypeStr = DataTypeManager.getDataTypeName((Class)seSymbol.getType());
        boolean isExplicitConv = DataTypeManager.isExplicitConversion((String)seSymbolTypeStr, (String)targetTypeStr);
        boolean isImplicitConv = DataTypeManager.isImplicitConversion((String)seSymbolTypeStr, (String)targetTypeStr);
        if (!isImplicitConv && !isExplicitConv) return TransformationSqlHelper.convert(symbol, targetTypeStr);
        if (seSymbol instanceof ExpressionSymbol) {
            return TransformationSqlHelper.convertExpressionSymbol((ExpressionSymbol)seSymbol, targetTypeStr);
        }
        if (!(seSymbol instanceof ElementSymbol) || !((aseSymbol = (aSymbol = TransformationSqlHelper.convertElementSymbol((ElementSymbol)seSymbol, targetTypeStr, null)).getSymbol()) instanceof ExpressionSymbol)) return null;
        return (ExpressionSymbol)aseSymbol;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

