/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.diagram.ui.editor;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.diagram.Diagram;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.transaction.SourcedNotification;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.diagram.ui.DiagramUiConstants;
import com.metamatrix.modeler.diagram.ui.DiagramUiPlugin;
import com.metamatrix.modeler.diagram.ui.IDiagramType;
import com.metamatrix.modeler.diagram.ui.NotationChangeListener;
import com.metamatrix.modeler.diagram.ui.actions.AutoLayout;
import com.metamatrix.modeler.diagram.ui.actions.DiagramFontManager;
import com.metamatrix.modeler.diagram.ui.actions.NotationChoiceRadioActionGroup;
import com.metamatrix.modeler.diagram.ui.actions.ScaledFont;
import com.metamatrix.modeler.diagram.ui.dummy.DummyDiagramNode;
import com.metamatrix.modeler.diagram.ui.dummy.DummyDiagramPartFactory;
import com.metamatrix.modeler.diagram.ui.editor.CustomScalableFreeformRootEditPart;
import com.metamatrix.modeler.diagram.ui.editor.DiagramController;
import com.metamatrix.modeler.diagram.ui.editor.DiagramDecoratorHandler;
import com.metamatrix.modeler.diagram.ui.editor.DiagramDropTargetAdapter;
import com.metamatrix.modeler.diagram.ui.editor.DiagramEditorInput;
import com.metamatrix.modeler.diagram.ui.editor.DiagramEditorSelectionProvider;
import com.metamatrix.modeler.diagram.ui.editor.DiagramToolBarManager;
import com.metamatrix.modeler.diagram.ui.editor.DiagramViewForm;
import com.metamatrix.modeler.diagram.ui.editor.DiagramViewer;
import com.metamatrix.modeler.diagram.ui.editor.IDiagramActionAdapter;
import com.metamatrix.modeler.diagram.ui.editor.IDiagramSelectionHandler;
import com.metamatrix.modeler.diagram.ui.editor.ZoomableEditor;
import com.metamatrix.modeler.diagram.ui.model.DiagramModelFactory;
import com.metamatrix.modeler.diagram.ui.model.DiagramModelNode;
import com.metamatrix.modeler.diagram.ui.outline.DiagramOverview;
import com.metamatrix.modeler.diagram.ui.part.DiagramEditPart;
import com.metamatrix.modeler.diagram.ui.part.DiagramEditPartFactory;
import com.metamatrix.modeler.diagram.ui.util.DiagramEntityManager;
import com.metamatrix.modeler.diagram.ui.util.DiagramUiUtilities;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.diagram.ui.editor.DiagramActionContributor;
import com.metamatrix.modeler.internal.ui.editors.DefaultModelEditorNavigationLocation;
import com.metamatrix.modeler.internal.ui.editors.ModelEditor;
import com.metamatrix.modeler.internal.ui.util.DiagramProxy;
import com.metamatrix.modeler.internal.ui.viewsupport.MarkerUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelObjectUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.ui.UiConstants;
import com.metamatrix.modeler.ui.editors.AbstractModelEditorPageActionBarContributor;
import com.metamatrix.modeler.ui.editors.IInitializationCompleteListener;
import com.metamatrix.modeler.ui.editors.IInitializationCompleteNotifier;
import com.metamatrix.modeler.ui.editors.IInlineRenameable;
import com.metamatrix.modeler.ui.editors.INavigationSupported;
import com.metamatrix.modeler.ui.editors.ModelEditorManager;
import com.metamatrix.modeler.ui.editors.ModelEditorPage;
import com.metamatrix.modeler.ui.editors.ModelEditorPageOutline;
import com.metamatrix.modeler.ui.editors.NavigableEditor;
import com.metamatrix.modeler.ui.editors.NavigationMarker;
import com.metamatrix.modeler.ui.event.ModelResourceEvent;
import com.metamatrix.ui.actions.AbstractActionService;
import com.metamatrix.ui.internal.eventsupport.SelectionUtilities;
import com.metamatrix.ui.internal.util.UiUtil;
import com.metamatrix.ui.internal.viewsupport.UiBusyIndicator;
import com.metamatrix.ui.print.Printable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IGotoMarker;

public class DiagramEditor
extends GraphicalEditor
implements ModelEditorPage,
AutoLayout,
ZoomableEditor,
INotifyChangedListener,
ISelectionChangedListener,
NotationChangeListener,
ILabelProviderListener,
IPartListener,
IInitializationCompleteNotifier,
INavigationLocationProvider,
INavigationSupported,
IGotoMarker,
IInlineRenameable,
DiagramUiConstants,
UiConstants {
    private static final String THIS_CLASS = "DiagramEditor";
    private boolean initializeModelPackage = true;
    private DiagramModelNode currentModel = null;
    private DiagramModelFactory diagramModelFactory = null;
    protected DiagramViewer viewer = null;
    private KeyHandler sharedKeyHandler;
    private IDiagramSelectionHandler selectionHandler;
    private String sNotationId;
    private Image titleImage;
    private String title;
    private String tooltip;
    private DiagramEditorInput diagramInput;
    private DiagramActionContributor dacDiagramActionContributor;
    private IDiagramActionAdapter currentActionAdapter;
    private MenuManager mmNotationActionGroup;
    private ScaledFont scaledFontManager;
    private DiagramViewForm diagramViewForm;
    private ToolBar toolBar;
    private DiagramToolBarManager toolBarManager;
    private DiagramController diagramController;
    private DiagramEditorSelectionProvider selectionProvider;
    private DiagramDecoratorHandler decoratorHandler;
    private DiagramOverview overview;
    private NavigableEditor neNavigableEditor;
    private IMarker mMostRecentlyCreatedMarker;
    private boolean bOkToCreateMarkers = true;
    private IResourceChangeListener markerListener;
    private ModelEditor meParentEditor;
    private ModelResource currentModelResource;
    private IPath currentModelPath;
    private EObject revealableEObject;
    private double zoomFactor = 1.0;
    private static HashMap hmapModelTreeStates;
    private Collection completionListeners;
    private Map adapterMap = new HashMap();
    static /* synthetic */ Class class$org$eclipse$gef$editparts$ZoomManager;
    static /* synthetic */ Class class$com$metamatrix$modeler$diagram$ui$actions$ScaledFont;
    static /* synthetic */ Class class$com$metamatrix$modeler$diagram$ui$actions$AutoLayout;
    static /* synthetic */ Class class$com$metamatrix$modeler$diagram$ui$editor$IDiagramActionAdapter;
    static /* synthetic */ Class class$com$metamatrix$ui$print$IPrintable;

    public DiagramEditor() {
        DiagramUiUtilities.setLoggingLevel((int)-1);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.sNotationId = DiagramUiPlugin.getDiagramNotationManager().getCurrentExtensionId();
        this.viewer = new DiagramViewer(this);
        this.titleImage = DiagramUiPlugin.getDefault().getImage("icons/full/cview16/Diagram.gif");
    }

    public void init(IEditorSite iSite, IEditorInput iInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iSite);
        this.setInput(iInput);
        this.neNavigableEditor = new NavigableEditor((IEditorPart)this);
        this.markerListener = new /* Unavailable Anonymous Inner Class!! */;
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.markerListener);
        ((AbstractActionService)DiagramUiPlugin.getDefault().getActionService(iSite.getPage())).addPartListener((IPartListener)this);
    }

    protected void initializeGraphicalViewer() {
        this.initializeDiagram();
    }

    protected void initializeDiagram() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            Display.getCurrent().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.setCurrentModel((DiagramModelNode)new DummyDiagramNode());
            this.getGraphicalViewer().setContents((Object)this.getCurrentModel());
        }
    }

    public DiagramModelNode getCurrentModel() {
        return this.currentModel;
    }

    protected void setCurrentModel(DiagramModelNode newDiagramModelNode) {
        this.currentModel = newDiagramModelNode;
    }

    public Diagram getDiagram() {
        if (this.diagramInput != null) {
            return this.diagramInput.getDiagram();
        }
        return null;
    }

    public HashMap getTreeStatesMap() {
        if (hmapModelTreeStates == null) {
            hmapModelTreeStates = new HashMap();
        }
        return hmapModelTreeStates;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor iMonitor) {
    }

    public void doSaveAs() {
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return this.neNavigableEditor.createEmptyNavigationLocation();
    }

    public INavigationLocation createNavigationLocation() {
        String pathFromModelToTarget;
        EObject target;
        INavigationLocation newLocation = this.neNavigableEditor.createNavigationLocation();
        if (newLocation instanceof DefaultModelEditorNavigationLocation && this.getDiagram() != null && (target = this.getDiagram().getTarget()) != null && !(target instanceof ModelAnnotation) && (pathFromModelToTarget = ModelerCore.getModelEditor().getModelRelativePathIncludingModel(target).toString()) != null) {
            ((DefaultModelEditorNavigationLocation)newLocation).setText(pathFromModelToTarget);
        }
        return newLocation;
    }

    public IMarker createMarker() {
        NavigationMarker nmMarker = new NavigationMarker();
        try {
            nmMarker.setAttribute("markerType", (Object)"navigation");
            nmMarker.setAttribute("currentInput", (Object)this.getDiagram());
            if (UiConstants.Util.isDebugEnabled("navigation")) {
                UiConstants.Util.print("navigation", "DiagramEditor.createMarker();  curr diagram saved: " + this.getDiagram());
                UiConstants.Util.print("navigation", "DiagramEditor.createMarker();  Nav History Count: " + this.neNavigableEditor.getNavHistoryCount());
            }
            this.updateSelectionsInMarker((IMarker)nmMarker);
            this.mMostRecentlyCreatedMarker = nmMarker;
        }
        catch (CoreException ce) {
            String message = ((Object)((Object)this)).getClass().getName() + ":  createMarker() error  ";
            DiagramUiConstants.Util.log(4, (Throwable)ce, message);
        }
        return nmMarker;
    }

    private void updateSelectionsInMarker(IMarker mMostRecentlyCreatedMarker) {
        if (mMostRecentlyCreatedMarker != null) {
            try {
                if (this.getSelectionHandler() != null) {
                    List lstEObjects = this.getSelectionHandler().getSelectedEObjects();
                    mMostRecentlyCreatedMarker.setAttribute("currentSelection", (Object)lstEObjects);
                }
            }
            catch (CoreException ce) {
                String message = ((Object)((Object)this)).getClass().getName() + ":  updateSelectionsInMarker() error  ";
                DiagramUiConstants.Util.log(4, (Throwable)ce, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotoMarker(IMarker iMarker) {
        Diagram someDiagram;
        EObject targetEObject;
        if (UiConstants.Util.isDebugEnabled("navigation")) {
            UiConstants.Util.print("navigation", "DiagramEditor.gotoMarker();  iMarker: " + iMarker);
        }
        String sMarkerType = iMarker.getAttribute("markerType", "unknown");
        try {
            block22: {
                try {
                    if (!sMarkerType.equals("navigation")) break block22;
                    this.bOkToCreateMarkers = false;
                    Object oInput = MarkerUtilities.getMarkerAttribute((IMarker)iMarker, (String)"currentInput");
                    if (UiConstants.Util.isDebugEnabled("navigation")) {
                        UiConstants.Util.print("navigation", "DiagramEditor.gotoMarker();  iMarker.getAttributes(): " + iMarker.getAttributes().keySet().toString());
                        UiConstants.Util.print("navigation", "DiagramEditor.gotoMarker();  Input: " + oInput);
                    }
                    if (oInput == null || !this.canOpenContext(oInput)) break block22;
                    this.openContext(oInput);
                    List lstSelection = (List)MarkerUtilities.getMarkerAttribute((IMarker)iMarker, (String)"currentSelection");
                    if (lstSelection != null) {
                        Iterator it = lstSelection.iterator();
                        while (it.hasNext()) {
                            EObject eoTemp = (EObject)it.next();
                            this.getSelectionHandler().select(eoTemp);
                        }
                    }
                    this.getParent().displayModelEditorPage((ModelEditorPage)this);
                }
                catch (CoreException ce) {
                    this.bOkToCreateMarkers = true;
                    String message = ((Object)((Object)this)).getClass().getName() + ":  gotoMarker() error  ";
                    DiagramUiConstants.Util.log(4, (Throwable)ce, message);
                    Object var8_9 = null;
                    this.bOkToCreateMarkers = true;
                    if (sMarkerType.equals("navigation")) {
                        return;
                    }
                }
            }
            Object var8_8 = null;
            this.bOkToCreateMarkers = true;
            if (sMarkerType.equals("navigation")) {
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.bOkToCreateMarkers = true;
            if (sMarkerType.equals("navigation")) {
                return;
            }
            throw throwable;
        }
        if ((targetEObject = ModelObjectUtilities.getMarkedEObject((IMarker)iMarker)) != null && (someDiagram = DiagramUiPlugin.getDiagramTypeManager().getDiagramForGoToMarkerEObject(targetEObject, true)) != null) {
            if (this.getDiagram() == null || !someDiagram.equals(this.getDiagram())) {
                if (this.canOpenContext(someDiagram)) {
                    this.openContext(someDiagram);
                    if (this.getDiagramController() != null) {
                        this.getDiagramController().selectionChanged((IWorkbenchPart)this.getParent(), (ISelection)new StructuredSelection((Object)targetEObject));
                    } else if (this.getSelectionHandler() != null) {
                        this.getSelectionHandler().select(targetEObject);
                    }
                }
            } else if (this.getDiagram() != null && someDiagram.equals(this.getDiagram())) {
                if (this.getDiagramController() != null) {
                    this.getDiagramController().selectionChanged((IWorkbenchPart)this.getParent(), (ISelection)new StructuredSelection((Object)targetEObject));
                } else if (this.getSelectionHandler() != null) {
                    this.getSelectionHandler().select(targetEObject);
                }
            }
        }
    }

    public boolean isDirty() {
        return false;
    }

    protected void setInitialPartFactory() {
        this.viewer.setEditPartFactory((EditPartFactory)new DummyDiagramPartFactory());
    }

    public DiagramDecoratorHandler getDecoratorHandler() {
        if (this.decoratorHandler == null) {
            this.decoratorHandler = new DiagramDecoratorHandler(this);
        }
        return this.decoratorHandler;
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.viewer = (DiagramViewer)this.getGraphicalViewer();
        this.resetRootEditPart();
        this.setInitialPartFactory();
        ((FigureCanvas)this.viewer.getControl()).setScrollBarVisibility(FigureCanvas.ALWAYS);
        this.selectionProvider = new DiagramEditorSelectionProvider(this.viewer);
        this.viewer.addDropTargetListener((TransferDropTargetListener)new DiagramDropTargetAdapter((EditPartViewer)this.viewer));
        this.getControl().addMouseTrackListener((MouseTrackListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected ScaledFont getFontManager() {
        if (this.scaledFontManager == null) {
            this.scaledFontManager = new DiagramFontManager(this.viewer);
        }
        return this.scaledFontManager;
    }

    public Object getAdapter(Class type) {
        if (type == (class$org$eclipse$gef$editparts$ZoomManager == null ? (class$org$eclipse$gef$editparts$ZoomManager = DiagramEditor.class$("org.eclipse.gef.editparts.ZoomManager")) : class$org$eclipse$gef$editparts$ZoomManager)) {
            ZoomManager zm = ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
            zm.setZoomLevels(DiagramUiConstants.Zoom.zoomValues);
            zm.setZoom(this.zoomFactor);
            return zm;
        }
        if (type == (class$com$metamatrix$modeler$diagram$ui$actions$ScaledFont == null ? (class$com$metamatrix$modeler$diagram$ui$actions$ScaledFont = DiagramEditor.class$("com.metamatrix.modeler.diagram.ui.actions.ScaledFont")) : class$com$metamatrix$modeler$diagram$ui$actions$ScaledFont)) {
            return this.getFontManager();
        }
        if (type == (class$com$metamatrix$modeler$diagram$ui$actions$AutoLayout == null ? (class$com$metamatrix$modeler$diagram$ui$actions$AutoLayout = DiagramEditor.class$("com.metamatrix.modeler.diagram.ui.actions.AutoLayout")) : class$com$metamatrix$modeler$diagram$ui$actions$AutoLayout)) {
            return this;
        }
        if (type == (class$com$metamatrix$modeler$diagram$ui$editor$IDiagramActionAdapter == null ? (class$com$metamatrix$modeler$diagram$ui$editor$IDiagramActionAdapter = DiagramEditor.class$("com.metamatrix.modeler.diagram.ui.editor.IDiagramActionAdapter")) : class$com$metamatrix$modeler$diagram$ui$editor$IDiagramActionAdapter) && this.getDiagramActionAdapter() != null) {
            return this.getDiagramActionAdapter();
        }
        if (type == (class$com$metamatrix$ui$print$IPrintable == null ? (class$com$metamatrix$ui$print$IPrintable = DiagramEditor.class$("com.metamatrix.ui.print.IPrintable")) : class$com$metamatrix$ui$print$IPrintable) && this.getGraphicalViewer() != null) {
            return new Printable((Object)this.getGraphicalViewer());
        }
        return super.getAdapter(type);
    }

    private void saveZoom() {
        ZoomManager zm = ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        this.zoomFactor = zm.getZoom();
    }

    public void resetZoom() {
        ZoomManager zm = ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        zm.setZoom(this.zoomFactor);
    }

    public IDiagramActionAdapter getDiagramActionAdapter() {
        return this.currentActionAdapter;
    }

    private void setDiagramActionAdapter(Diagram newDiagram) {
        if (newDiagram != null && (this.currentActionAdapter == null || this.isNewDiagram(newDiagram))) {
            String type;
            IDiagramActionAdapter newAdapter;
            if (this.currentActionAdapter != null) {
                this.currentActionAdapter.pageDeactivated();
            }
            if ((newAdapter = (IDiagramActionAdapter)this.adapterMap.get(type = newDiagram.getType())) == null && (newAdapter = DiagramUiPlugin.getDiagramTypeManager().getDiagram(type).getActionAdapter((ModelEditorPage)this)) != null) {
                this.adapterMap.put(type, newAdapter);
            }
            if (newAdapter != null) {
                newAdapter.setDiagramEditor((ModelEditorPage)this);
            }
            this.currentActionAdapter = newAdapter;
        }
    }

    private boolean isNewDiagram(Diagram newDiagram) {
        if (newDiagram == null && this.getDiagram() == null) {
            return false;
        }
        return this.getDiagram() == null || newDiagram == null || !newDiagram.getType().equals(this.getDiagram().getType());
    }

    protected void createGraphicalViewer(Composite parent) {
        this.viewer.createControl((Composite)this.diagramViewForm.getSashForm());
        this.setGraphicalViewer((GraphicalViewer)this.viewer);
        this.configureGraphicalViewer();
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.viewer);
        this.initializeGraphicalViewer();
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    protected void createSelectionHandler(Diagram diagram, DiagramViewer theViewer) {
        this.selectionHandler = DiagramUiPlugin.getDiagramTypeManager().getDiagram(diagram.getType()).getSelectionHandler(theViewer);
    }

    protected IDiagramSelectionHandler getSelectionHandler() {
        return this.selectionHandler;
    }

    private void resetRootEditPart() {
        RootEditPart root = this.viewer.getRootEditPart();
        if (root != null && this.dacDiagramActionContributor != null) {
            this.dacDiagramActionContributor.tellZoomWrappersToClose();
        }
        if (root != null) {
            if (!(root instanceof ScalableFreeformRootEditPart)) {
                root = new CustomScalableFreeformRootEditPart();
                this.viewer.setRootEditPart(root);
            } else {
                root.setContents(null);
            }
            ConnectionLayer cLayer = (ConnectionLayer)((ScalableFreeformRootEditPart)root).getLayer((Object)"Connection Layer");
            if (!cLayer.getChildren().isEmpty()) {
                cLayer.removeAll();
            }
        } else {
            root.setContents(null);
        }
    }

    private void clearCurrentDiagram() {
        if (this.getCurrentModel() != null) {
            this.setCurrentModel(null);
            this.diagramInput = null;
        }
        if (!this.getDiagramViewer().getSelectedEditParts().isEmpty()) {
            this.getDiagramViewer().deselectAll();
        }
        this.resetRootEditPart();
    }

    protected void createModel(Diagram diagram, IProgressMonitor monitor) {
        if (this.getModelFactory() != null) {
            this.diagramInput = new DiagramEditorInput(diagram);
            this.setCurrentModel(this.getModelFactory().createModel((Object)diagram, this.getNotationId(), monitor));
            DiagramEditPartFactory newEditPartFactory = DiagramUiPlugin.getDiagramTypeManager().getDiagram(diagram.getType()).getEditPartFactory();
            newEditPartFactory.setNotationId(this.getNotationId());
            this.createSelectionHandler(diagram, this.viewer);
            newEditPartFactory.setSelectionHandler(this.getSelectionHandler());
            this.viewer.setEditPartFactory((EditPartFactory)newEditPartFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setDiagram(Diagram diagram, IProgressMonitor monitor) {
        block22: {
            block20: {
                if (DiagramUiConstants.Util.isDebugEnabled("diagramEditor") && diagram != null && diagram.getType() != null) {
                    DiagramUiConstants.Util.print("diagramEditor", "DiagramEditor.setDiagram() diagramType = " + diagram.getType());
                }
                boolean requiredStart = false;
                boolean succeeded = false;
                try {
                    try {
                        requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Display Diagram", (Object)((Object)this));
                        this.saveZoom();
                        this.clearCurrentDiagram();
                        if (diagram != null) {
                            DiagramEntityManager.addDiagram((Diagram)diagram);
                            this.currentModelResource = ModelUtilities.getModelResourceForModelObject((EObject)diagram.getTarget());
                            this.currentModelPath = ((IFileEditorInput)this.getEditorInput()).getFile().getFullPath();
                            this.setNotationId(DiagramUiUtilities.getDiagramNotation((Diagram)diagram));
                            DiagramModelFactory modelFactory = DiagramUiPlugin.getDiagramTypeManager().getDiagram(diagram.getType()).getModelFactory();
                            this.setModelFactory(modelFactory);
                            this.createModel(diagram, monitor);
                            if (this.getCurrentModel() != null) {
                                if (monitor != null) {
                                    monitor.subTask("Setting Viewer Contents");
                                    monitor.worked(20);
                                }
                                this.getGraphicalViewer().setContents((Object)this.getCurrentModel());
                                if (monitor != null) {
                                    monitor.subTask("Performing Layout");
                                    monitor.worked(10);
                                }
                                if (this.getGraphicalViewer().getContents() instanceof DiagramEditPart) {
                                    DiagramEditPart diagramEP = (DiagramEditPart)this.getGraphicalViewer().getContents();
                                    diagramEP.layout(true);
                                    this.resetZoom();
                                    diagramEP.constructionCompleted(true);
                                }
                                if (monitor != null) {
                                    monitor.worked(10);
                                }
                                this.viewer.printContents();
                            }
                        } else if (this.currentModelResource != null && this.currentModelResource.exists() && this.currentModelResource.isOpen()) {
                            this.openContext(this.currentModelResource);
                        } else {
                            this.setModelFactory(null);
                            this.selectionHandler = null;
                            this.diagramInput = null;
                            if (this.currentActionAdapter != null) {
                                this.currentActionAdapter.disposeOfActions();
                            }
                            this.currentActionAdapter = null;
                            this.removeDiagramController();
                            this.clearDiagramToolbar();
                            this.setInitialPartFactory();
                            this.setCurrentModel((DiagramModelNode)new DummyDiagramNode());
                            this.getGraphicalViewer().setContents((Object)this.getCurrentModel());
                        }
                        succeeded = true;
                    }
                    catch (Exception ex) {
                        DiagramUiConstants.Util.log(4, (Throwable)ex, ex.getClass().getName() + ":" + THIS_CLASS + ".setDiagram()");
                        Object var8_9 = null;
                        if (!requiredStart) return;
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                        if (this.overview == null) return;
                        this.overview.resetContents();
                        return;
                    }
                    Object var8_8 = null;
                    if (!requiredStart) return;
                    if (!succeeded) break block20;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (!requiredStart) throw throwable;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                    if (this.overview == null) throw throwable;
                    this.overview.resetContents();
                    throw throwable;
                }
                ModelerCore.commitTxn();
                break block22;
            }
            ModelerCore.rollbackTxn();
        }
        if (this.overview == null) return;
        this.overview.resetContents();
    }

    private void clearDiagramToolbar() {
        this.getToolBarManager().removeAll();
        this.getToolBarManager().update(true);
        this.diagramViewForm.redraw();
    }

    public DiagramViewForm getDiagramViewForm() {
        return this.diagramViewForm;
    }

    private void setDiagramToolBar() {
        if (this.toolBarManager != null && this.toolBar != null) {
            if (this.getDiagramActionAdapter() != null) {
                this.getDiagramActionAdapter().contributeToDiagramToolBar();
                this.getDiagramActionAdapter().enableDiagramToolbarActions();
            }
            this.getToolBarManager().update(true);
        }
        if (!this.diagramViewForm.isDisposed() && this.diagramViewForm.isVisible()) {
            this.diagramViewForm.redraw();
        }
    }

    public boolean canOpenContext(Object input) {
        return DiagramUiPlugin.getDiagramTypeManager().canOpenContext(input);
    }

    public void initializeEditorPage() {
    }

    public void openContext(Object input) {
        this.openContext(input, false);
    }

    public void openContext(Object input, boolean forceRefresh) {
        Diagram previousDiagram = this.getDiagram();
        if (input instanceof Diagram) {
            this.autoSelect();
        }
        if (DiagramUiConstants.Util.isDebugEnabled("modelerTimer")) {
            DiagramUiConstants.Util.start("DiagramEditor.openContext()", "modelerTimer");
        }
        this.initializeModelPackage = false;
        if (input == null) {
            this.setDiagram(null, null);
            this.titleImage = null;
            this.title = null;
            this.tooltip = null;
            this.firePropertyChange(1);
            this.getDecoratorHandler().clear();
        } else {
            Diagram inputDiagram = null;
            boolean contextIsDiagram = false;
            if (input instanceof Diagram && !(input instanceof DiagramProxy)) {
                contextIsDiagram = true;
                inputDiagram = (Diagram)input;
            } else {
                inputDiagram = DiagramUiPlugin.getDiagramTypeManager().getDiagramForContext(input);
            }
            if (inputDiagram != null && !DiagramUiPlugin.getDiagramTypeManager().getDiagram(inputDiagram.getType()).isDiagramTooLarge(inputDiagram)) {
                final Diagram newDiagram = inputDiagram;
                if (!forceRefresh && previousDiagram != null && inputDiagram.equals(previousDiagram)) {
                    if (this.meParentEditor != null) {
                        this.meParentEditor.setIgnoreInternalFocus(true);
                    }
                    return;
                }
                this.setDiagramActionAdapter(newDiagram);
                boolean requiresProgress = false;
                if (newDiagram != null) {
                    requiresProgress = DiagramUiPlugin.getDiagramTypeManager().getDiagram(newDiagram.getType()).isDiagramLarge(newDiagram);
                }
                if (requiresProgress) {
                    this.setDiagramWithProgress(newDiagram);
                } else {
                    UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                        public void run() {
                            DiagramEditor.this.setDiagram(newDiagram, null);
                        }
                    });
                }
                this.updateDiagramController();
                this.setDiagramToolBar();
                if (!this.diagramViewForm.isDisposed()) {
                    this.diagramViewForm.getSashForm().update();
                    this.diagramViewForm.update();
                    this.diagramViewForm.layout(false);
                    this.diagramViewForm.setInitialSashFormWeights();
                }
                this.updateEditorTab(newDiagram);
                EObject initialSelection = DiagramUiPlugin.getDiagramTypeManager().getDiagram(newDiagram.getType()).getInitialSelection(input);
                if (initialSelection != null) {
                    this.getDiagramViewer().getSelectionHandler().select(initialSelection);
                } else if (!contextIsDiagram && input instanceof EObject) {
                    this.getDiagramViewer().getSelectionHandler().select((EObject)input);
                }
                this.revealableEObject = DiagramUiPlugin.getDiagramTypeManager().getDiagram(newDiagram.getType()).getRevealedEObject(newDiagram, input);
                if (this.bOkToCreateMarkers) {
                    UiUtil.getWorkbenchPage().getNavigationHistory().markLocation((IEditorPart)this);
                }
            }
            this.getDecoratorHandler().reset();
        }
        if (DiagramUiConstants.Util.isDebugEnabled("modelerTimer")) {
            DiagramUiConstants.Util.stop("DiagramEditor.openContext()", "modelerTimer");
        }
        this.updateReadOnlyState();
        this.notifyInitializationComplete();
    }

    public void openComplete() {
        if (this.revealableEObject != null) {
            EObject revealedObject = this.revealableEObject;
            this.getDiagramViewer().reveal(revealedObject);
            this.revealableEObject = null;
        }
    }

    public void setTitleText(String newTitle) {
        this.title = newTitle;
    }

    private boolean setDiagramWithProgress(Diagram newDiagram) {
        boolean success = false;
        final Diagram theDiagram = newDiagram;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                monitor.beginTask("Constructing Diagram", 100);
                DiagramEditor.this.setDiagram(theDiagram, monitor);
            }
        };
        try {
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getControl().getShell());
            dlg.run(false, true, op);
            if (dlg.getProgressMonitor().isCanceled()) {
                return true;
            }
            success = true;
        }
        catch (InterruptedException ignored) {
            success = true;
        }
        catch (Exception err) {
            success = false;
        }
        return success;
    }

    private void updateDiagramController() {
        boolean useExistingController = false;
        if (this.diagramController != null) {
            Class controllerClass = DiagramUiPlugin.getDiagramTypeManager().getDiagram(this.getDiagram().getType()).getDiagramControllerClass();
            if (controllerClass != null && this.diagramController.getClass().equals(controllerClass)) {
                useExistingController = this.diagramController.maintainControl(this.getDiagram());
            }
            if (!useExistingController) {
                this.diagramController.deactivate();
                this.selectionProvider.removeDiagramController(this.diagramController);
                Control diagramControl = this.diagramViewForm.getControllerControl();
                if (diagramControl != null) {
                    diagramControl.dispose();
                }
                this.diagramViewForm.getSashForm().update();
                this.diagramViewForm.getSashForm().pack(true);
                this.diagramViewForm.update();
                this.diagramViewForm.layout(false);
                this.diagramController = null;
            }
        }
        if (useExistingController) {
            this.diagramController.rewireDiagram(this.getDiagram());
        } else {
            DiagramController newDiagramController = this.getDiagramController(this.getDiagram());
            if (newDiagramController != null) {
                this.diagramController = newDiagramController;
                this.diagramController.wireDiagram(this.getDiagram());
                this.selectionProvider.setDiagramController(this.diagramController);
                if (this.diagramController instanceof ControlListener) {
                    this.getControl().addControlListener((ControlListener)this.diagramController);
                }
            }
        }
    }

    private DiagramController getDiagramController(Diagram diagram) {
        IDiagramType dt;
        if (diagram != null && diagram.getType() != null && (dt = DiagramUiPlugin.getDiagramTypeManager().getDiagram(diagram.getType())) != null) {
            return dt.getDiagramController(this);
        }
        return null;
    }

    private void removeDiagramController() {
        if (this.diagramController != null) {
            if (this.diagramController instanceof ControlListener && this.getControl() != null) {
                this.getControl().removeControlListener((ControlListener)this.diagramController);
            }
            this.diagramController.deactivate();
            this.selectionProvider.removeDiagramController(this.diagramController);
            Control diagramControl = this.diagramViewForm.getControllerControl();
            if (diagramControl != null) {
                diagramControl.dispose();
            }
            this.diagramViewForm.getSashForm().update();
            this.diagramViewForm.getSashForm().pack(true);
            this.diagramViewForm.update();
            this.diagramViewForm.layout(false);
            this.diagramController = null;
        }
    }

    public ISelectionProvider getModelObjectSelectionProvider() {
        return this.selectionProvider;
    }

    public ISelectionChangedListener getModelObjectSelectionChangedListener() {
        return this;
    }

    public void selectionChanged(SelectionChangedEvent sce) {
        ISelection selection = sce.getSelection();
        if (selection instanceof IStructuredSelection) {
            if (SelectionUtilities.isSingleSelection((ISelection)selection)) {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof EObject) {
                    if (this.getSelectionHandler() != null) {
                        this.getSelectionHandler().select((EObject)obj);
                    }
                    if (this.getDiagramController() != null) {
                        this.getDiagramController().selectionChanged((IWorkbenchPart)this.getParent(), selection);
                    }
                    if (obj instanceof Diagram && this.meParentEditor != null && this.meParentEditor.getActiveEditor() == this) {
                        this.meParentEditor.setIgnoreInternalFocus(true);
                    }
                }
            } else if (this.getSelectionHandler() != null) {
                this.getSelectionHandler().select(selection);
            }
            this.updateSelectionsInMarker(this.mMostRecentlyCreatedMarker);
        }
    }

    public AbstractModelEditorPageActionBarContributor getActionBarContributor() {
        if (this.dacDiagramActionContributor == null) {
            this.dacDiagramActionContributor = new DiagramActionContributor((ModelEditorPage)this);
        }
        return this.dacDiagramActionContributor;
    }

    public void setNotationId(String sNotationId) {
        if (!this.sNotationId.equals(sNotationId)) {
            this.sNotationId = sNotationId;
            DiagramUiUtilities.setDiagramNotation((String)sNotationId, (Diagram)this.getDiagram());
            this.setDiagramWithProgress(this.diagramInput.getDiagram());
        }
    }

    public String getNotationId() {
        return this.sNotationId;
    }

    public void setLabelProvider(ILabelProvider provider) {
        DiagramUiPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator().addListener((ILabelProviderListener)this);
        DiagramUiPlugin.getDiagramNotationManager().setLabelProvider(provider);
    }

    public ILabelProvider getLabelProvider() {
        return DiagramUiPlugin.getDiagramNotationManager().getLabelProvider();
    }

    public INotifyChangedListener getNotifyChangedListener() {
        return this;
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public DiagramViewForm getPrimaryControl() {
        return this.diagramViewForm;
    }

    public void notifyChanged(Notification notification) {
        if (DiagramUiConstants.Util.isDebugEnabled("diagramEditor")) {
            DiagramUiConstants.Util.start("DiagramEditor.notifyChanged()", "metricsTimingNotifications");
        }
        boolean diagramStillValid = true;
        if (DiagramUiConstants.Util.isDebugEnabled("debugNotifications")) {
            DiagramUiConstants.Util.print("debugNotifications", " DiagramEditor.notifyChanged(): START PROCESSING NOTIFICATION ------------------------------");
            if (notification instanceof SourcedNotification) {
                Object source = ((SourcedNotification)notification).getSource();
                DiagramUiConstants.Util.print("debugNotifications", " DiagramEditor.notifyChanged(): got a notifyChanged( ) Source = " + source);
            } else {
                DiagramUiConstants.Util.print("debugNotifications", " DiagramEditor.notifyChanged(): got a notifyChanged( ) " + notification);
            }
        }
        if (this.getModelFactory() != null && this.getCurrentModel() != null) {
            diagramStillValid = this.getModelFactory().notifyModel(notification, this.getCurrentModel(), this.diagramInput.getDiagram().getType());
        }
        if (diagramStillValid) {
            try {
                if (this.getDiagramActionAdapter() != null) {
                    this.getDiagramActionAdapter().handleNotification(notification);
                }
                if (this.diagramController != null) {
                    this.diagramController.handleNotification(notification);
                }
                if (DiagramUiConstants.Util.isDebugEnabled("debugNotifications")) {
                    DiagramUiConstants.Util.print("debugNotifications", " DiagramEditor.notifyChanged(): END PROCESSING NOTIFICATION --------------------------------\n\n");
                }
            }
            catch (Exception ex) {
                DiagramUiConstants.Util.log(4, (Throwable)ex, ex.getClass().getName());
            }
            if (this.getDiagram() != null) {
                this.updateEditorTab(this.getDiagram());
                if (this.getModelFactory().shouldRefreshDiagram(notification, this.getCurrentModel(), this.diagramInput.getDiagram().getType())) {
                    this.refreshDiagramSafe();
                }
            }
        } else if (this.meParentEditor != null && this.meParentEditor.getModelFile() != null && this.meParentEditor.getModelFile().getRawLocation().toFile().exists()) {
            this.openContext(null);
        }
        if (DiagramUiConstants.Util.isDebugEnabled("diagramEditor")) {
            DiagramUiConstants.Util.stop("DiagramEditor.notifyChanged()", "metricsTimingNotifications");
        }
    }

    private void updateEditorTab(Diagram someDiagram) {
        ILabelProvider labelProvider = DiagramUiPlugin.getDiagramNotationManager().getLabelProvider();
        if (labelProvider != null) {
            this.titleImage = labelProvider.getImage((Object)someDiagram);
            this.setTitleText(labelProvider.getText((Object)someDiagram));
            this.tooltip = labelProvider.getText((Object)someDiagram);
        }
        if (this.meParentEditor != null) {
            this.meParentEditor.refreshEditorTabs();
        }
    }

    public MenuManager getNotationActionGroup() {
        if (this.mmNotationActionGroup == null) {
            this.mmNotationActionGroup = DiagramUiPlugin.getDiagramNotationManager().getNotationActionGroup((NotationChangeListener)this, this.getNotationId());
        } else {
            ((NotationChoiceRadioActionGroup)this.mmNotationActionGroup).updateNotationActions(this.getNotationId());
        }
        return this.mmNotationActionGroup;
    }

    public String getTitle() {
        if (this.title == null) {
            return super.getTitle();
        }
        return this.title;
    }

    public Image getTitleImage() {
        return this.titleImage;
    }

    public String getTitleToolTip() {
        if (this.tooltip == null) {
            return super.getTitleToolTip();
        }
        return this.tooltip;
    }

    public ModelEditorPageOutline getOutlineContribution() {
        if (this.overview == null) {
            this.overview = new DiagramOverview(this.getGraphicalViewer(), this.getSelectionSynchronizer(), (Object)this.getCurrentModel());
        }
        return this.overview;
    }

    public void setParent(ModelEditor meParentEditor) {
        this.meParentEditor = meParentEditor;
    }

    public ModelEditor getParent() {
        return this.meParentEditor;
    }

    public boolean canDisplay(IEditorInput input) {
        boolean result = false;
        ModelResource mr = null;
        if (input instanceof EObject) {
            mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)input));
        } else if (input instanceof ModelResource) {
            mr = (ModelResource)input;
        } else if (input instanceof IFileEditorInput) {
            IFileEditorInput ifei = (IFileEditorInput)input;
            IFile modelFile = ifei.getFile();
            if (ModelUtil.isXsdFile((IResource)modelFile)) {
                result = false;
            } else {
                try {
                    mr = ModelUtilities.getModelResource((IFile)modelFile, (boolean)true);
                }
                catch (ModelWorkspaceException e) {
                    String message = ((Object)((Object)this)).getClass().getName() + ":  canDisplay() error finding model resource for file = " + modelFile;
                    DiagramUiConstants.Util.log(4, (Throwable)e, message);
                }
            }
        }
        if (mr != null) {
            result = ModelUtilities.supportsDiagrams((ModelResource)mr);
        }
        return result;
    }

    public void autoLayout() {
        if (this.getCurrentModel() != null && this.getGraphicalViewer().getContents() instanceof DiagramEditPart) {
            DiagramEditPart diagram = (DiagramEditPart)this.getGraphicalViewer().getContents();
            diagram.setUnderConstruction(true);
            diagram.layout();
            diagram.constructionCompleted(true);
            if (this.getDiagramController() != null) {
                this.getDiagramController().updateForAutoLayout();
            }
        }
    }

    public boolean canAutoLayout() {
        return true;
    }

    public void doRefreshDiagram() {
        this.refreshDiagramSafe();
        this.autoLayout();
    }

    public DiagramEditor getDiagramEditor() {
        return this;
    }

    public DiagramViewer getDiagramViewer() {
        return this.viewer;
    }

    public DiagramController getDiagramController() {
        return this.diagramController;
    }

    public DiagramModelFactory getModelFactory() {
        return this.diagramModelFactory;
    }

    public void setModelFactory(DiagramModelFactory factory) {
        this.diagramModelFactory = factory;
    }

    public void createPartControl(Composite parent) {
        this.diagramViewForm = new DiagramViewForm(parent, 2048);
        this.toolBar = new ToolBar((Composite)this.diagramViewForm, 0x800040);
        this.diagramViewForm.setToolBar((Control)this.toolBar);
        this.toolBarManager = new DiagramToolBarManager(this.toolBar);
        super.createPartControl((Composite)this.diagramViewForm);
        this.toolBarManager.update(true);
    }

    public ToolBarManager getToolBarManager() {
        return this.toolBarManager;
    }

    public void dispose() {
        if (!this.adapterMap.isEmpty()) {
            Iterator itr = this.adapterMap.values().iterator();
            while (itr.hasNext()) {
                ((IDiagramActionAdapter)itr.next()).disposeOfActions();
            }
        }
        DiagramUiPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator().removeListener((ILabelProviderListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.markerListener);
        ((AbstractActionService)DiagramUiPlugin.getDefault().getActionService(this.getEditorSite().getPage())).removePartListener((IPartListener)this);
        if (this.toolBarManager != null) {
            this.toolBarManager.dispose();
            this.toolBarManager = null;
        }
        if (this.currentActionAdapter != null) {
            this.currentActionAdapter = null;
        }
        if (this.dacDiagramActionContributor != null) {
            this.dacDiagramActionContributor.dispose();
            this.dacDiagramActionContributor = null;
        }
    }

    public void preDispose() {
    }

    public void updateDiagramPreferences() {
        DiagramEditPart rootEditPart;
        ((DiagramFontManager)this.getFontManager()).setFontFromPreferences();
        if (this.getDiagramViewer().getContents() != null && this.getDiagramViewer().getContents() instanceof DiagramEditPart && (rootEditPart = (DiagramEditPart)this.getDiagramViewer().getContents()) != null) {
            rootEditPart.updateForPreferences();
        }
        this.getDiagramViewer().updateForPrintPreferences();
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        boolean modelChanged = false;
        Object[] elements = event.getElements();
        if (elements != null && elements.length > 1) {
            for (int i = 0; i < elements.length; ++i) {
                Object nextElement = elements[i];
                if (nextElement instanceof EObject) {
                    if (ModelUtilities.areModelResourcesSame((EObject)((EObject)nextElement), (EObject)this.getDiagram())) {
                        modelChanged = true;
                    }
                } else if (nextElement instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)nextElement))) {
                    ModelResource modelResource = null;
                    try {
                        modelResource = ModelUtilities.getModelResource((IFile)((IFile)nextElement), (boolean)false);
                    }
                    catch (ModelWorkspaceException e) {
                        DiagramUiConstants.Util.log(4, (Throwable)e, "DiagramEditor.labelProviderChanged()  ERROR finding ModelResource");
                    }
                    if (modelResource != null && modelResource.equals(modelResource)) {
                        modelChanged = true;
                    }
                }
                if (modelChanged) break;
            }
        }
        if (this.getModelFactory() != null && this.getCurrentModel() != null && modelChanged) {
            this.getDecoratorHandler().handleLabelProviderChanged();
        }
    }

    public void setFocus() {
        this.refreshFont();
        super.setFocus();
        if (this.meParentEditor != null) {
            this.meParentEditor.setIgnoreInternalFocus(true);
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    private void refreshFont() {
        DiagramEditPart diagramEP;
        EditPart editPart = this.getDiagramViewer().getContents();
        if (editPart != null && editPart instanceof DiagramEditPart && (diagramEP = (DiagramEditPart)editPart).getCurrentDiagramFont() != null && diagramEP.getCurrentDiagramFont().isDisposed()) {
            diagramEP.refreshFont(true);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.refreshFont();
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void updateReadOnlyState(boolean isReadOnly) {
        if (this.getCurrentModel() != null && this.getCurrentModel().isReadOnly() != isReadOnly) {
            this.getCurrentModel().setReadOnly(isReadOnly);
            Iterator iter = this.getCurrentModel().getChildren().iterator();
            Object nextObj = null;
            while (iter.hasNext()) {
                nextObj = iter.next();
                if (!(nextObj instanceof DiagramModelNode)) continue;
                ((DiagramModelNode)nextObj).setReadOnly(isReadOnly);
            }
        }
    }

    private void updateReadOnlyState() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            boolean readOnly = ((IFileEditorInput)this.getEditorInput()).getFile().isReadOnly();
            this.updateReadOnlyState(readOnly);
        }
    }

    public double getCurrentZoomFactor() {
        return this.zoomFactor;
    }

    public void handleZoomChanged() {
        this.saveZoom();
        if (this.getDiagramViewer().getContents() != null && this.getDiagramViewer().getContents() instanceof DiagramEditPart) {
            DiagramEditPart rootEditPart = (DiagramEditPart)this.getDiagramViewer().getContents();
            if (rootEditPart != null) {
                rootEditPart.handleZoomChanged();
            }
            if (this.diagramController != null) {
                this.diagramController.handleZoomChanged();
            }
            this.getDiagramViewer().updateForPrintPreferences();
        }
    }

    public void processEvent(EventObject obj) {
        IDiagramType idt;
        ModelResourceEvent event = (ModelResourceEvent)obj;
        int eventType = event.getType();
        if (eventType == 2 || eventType == 3) {
            return;
        }
        boolean stillValid = this.checkValidity(((Object)((Object)this)).getClass().getName() + ".processEvent()");
        final Diagram currentDiagram = this.getDiagram();
        if (eventType == 6) {
            IDiagramType idt2;
            ModelResource evResource = event.getModelResource();
            boolean isSameResource = this.isCurrentResource(evResource);
            final IResource res = event.getResource();
            if (isSameResource) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        EObject realDiagram = ModelObjectUtilities.getRealEObject((EObject)currentDiagram);
                        ModelEditorManager.open((EObject)realDiagram, (boolean)true);
                        if (res instanceof IFile) {
                            IFile file = (IFile)res;
                            ModelEditorManager.activate((IFile)file, (boolean)true);
                        }
                    }
                });
            } else if (currentDiagram != null && (idt2 = DiagramUiPlugin.getDiagramTypeManager().getDiagram(currentDiagram.getType())).dependsOnResource(this.currentModel, evResource.getResource())) {
                this.refreshDiagramSafe();
            }
        } else if (stillValid && eventType == 4) {
            this.updateReadOnlyState();
        } else if (!(stillValid && eventType == 7 || !stillValid || eventType != 8 && eventType != 9 || currentDiagram == null || !(idt = DiagramUiPlugin.getDiagramTypeManager().getDiagram(currentDiagram.getType())).dependsOnResource(this.currentModel, event.getResource()))) {
            this.refreshDiagramSafe();
        }
    }

    private void refreshDiagramSafe() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!DiagramUiPlugin.getDefault().getWorkbench().isClosing() && DiagramEditor.this.getDiagramViewer().isValidViewer() && DiagramEditor.this.getCurrentModel() != null && DiagramEditor.this.getCurrentModel().getModelObject() != null && (DiagramUiPlugin.getDiagramTypeManager().isTransientDiagram(DiagramEditor.this.getDiagram()) || DiagramEditor.this.getCurrentModel().getModelObject().eResource() != null)) {
                    DiagramEditor.this.openContext(DiagramEditor.this.getCurrentModel().getModelObject(), true);
                }
            }
        });
    }

    public boolean checkValidity(String callPrefix) {
        if (this.getDiagram() == null) {
            return false;
        }
        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)this.getDiagram());
        return mr != null;
    }

    private boolean isCurrentResource(ModelResource modelResource) {
        IPath newPath;
        if (modelResource == null) {
            Assertion.isNotNull((Object)modelResource, (String)DiagramUiConstants.Util.getString("DiagramEditor.isCurrentResourceNullCheck"));
        }
        if (this.currentModelResource != null && modelResource == this.currentModelResource) {
            return true;
        }
        ModelResource editorMR = ModelUtilities.getModelResourceForModelObject((EObject)this.getDiagram());
        return editorMR != null ? modelResource == editorMR : this.currentModelPath != null && this.currentModelPath.equals(newPath = modelResource.getPath());
    }

    public ModelResource getCurrentModelResource() {
        return this.currentModelResource;
    }

    public void addListener(IInitializationCompleteListener theListener) {
        if (this.completionListeners == null) {
            this.completionListeners = new ArrayList();
        }
        this.completionListeners.add(theListener);
    }

    public void notifyInitializationComplete() {
        if (this.completionListeners != null && !this.completionListeners.isEmpty()) {
            Iterator iter = this.completionListeners.iterator();
            while (iter.hasNext()) {
                ((IInitializationCompleteListener)iter.next()).processInitializationComplete();
            }
        }
    }

    public void removeListener(IInitializationCompleteListener theListener) {
        if (this.completionListeners != null && !this.completionListeners.isEmpty()) {
            this.completionListeners.remove(theListener);
        }
    }

    public IInlineRenameable getInlineRenameable(EObject theObj) {
        return this;
    }

    public void renameInline(final EObject theObj, IInlineRenameable renameable) {
        if (renameable == this) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    DiagramEditor.this.getSelectionHandler().renameInline(theObj);
                }
            });
        }
    }

    public boolean isSelectedFirst(IEditorInput input) {
        return false;
    }

    private void autoSelect() {
        ModelEditorManager.autoSelectEditor((ModelEditor)this.meParentEditor, (ModelEditorPage)this);
    }

    static /* synthetic */ void access$000(DiagramEditor x0) {
        x0.refreshDiagramSafe();
    }

    static /* synthetic */ void access$100(DiagramEditor x0) {
        x0.updateReadOnlyState();
    }

    static /* synthetic */ boolean access$300(DiagramEditor x0) {
        return x0.initializeModelPackage;
    }

    static /* synthetic */ boolean access$402(DiagramEditor x0, boolean x1) {
        x0.bOkToCreateMarkers = x1;
        return x0.bOkToCreateMarkers;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

