/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.mapping.relational.QueryNode;
import com.metamatrix.query.mapping.xml.MappingNode;
import com.metamatrix.query.mapping.xml.MappingNodeConstants;
import com.metamatrix.query.mapping.xml.MappingNodeLogger;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.optimizer.CommandPlanner;
import com.metamatrix.query.optimizer.CommandTreeNode;
import com.metamatrix.query.optimizer.QueryOptimizer;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.xml.ContextReplacerVisitor;
import com.metamatrix.query.optimizer.xml.CriteriaContextInfo;
import com.metamatrix.query.optimizer.xml.Frame;
import com.metamatrix.query.optimizer.xml.QueryUtil;
import com.metamatrix.query.optimizer.xml.RelatePlanner;
import com.metamatrix.query.optimizer.xml.RelateWrapperFunctionVisitor;
import com.metamatrix.query.optimizer.xml.Relationship;
import com.metamatrix.query.optimizer.xml.XMLNodeMappingVisitor;
import com.metamatrix.query.optimizer.xml.XMLPlannerEnvironment;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.relational.RelationalPlan;
import com.metamatrix.query.processor.xml.AbortProcessingInstruction;
import com.metamatrix.query.processor.xml.AddCommentInstruction;
import com.metamatrix.query.processor.xml.AddNodeInstruction;
import com.metamatrix.query.processor.xml.CacheResultsInstruction;
import com.metamatrix.query.processor.xml.CloseResultSetInstruction;
import com.metamatrix.query.processor.xml.CriteriaCondition;
import com.metamatrix.query.processor.xml.DefaultCondition;
import com.metamatrix.query.processor.xml.DeregisterResultSetInstruction;
import com.metamatrix.query.processor.xml.EndDocumentInstruction;
import com.metamatrix.query.processor.xml.ExecSqlInstruction;
import com.metamatrix.query.processor.xml.IfInstruction;
import com.metamatrix.query.processor.xml.InitializeDocumentInstruction;
import com.metamatrix.query.processor.xml.MoveCursorInstruction;
import com.metamatrix.query.processor.xml.MoveDocInstruction;
import com.metamatrix.query.processor.xml.NodeDescriptor;
import com.metamatrix.query.processor.xml.ProcessorEnvironment;
import com.metamatrix.query.processor.xml.ProcessorInstruction;
import com.metamatrix.query.processor.xml.Program;
import com.metamatrix.query.processor.xml.ProgramUtil;
import com.metamatrix.query.processor.xml.QueryProcessorEnvironment;
import com.metamatrix.query.processor.xml.RecurseProgramCondition;
import com.metamatrix.query.processor.xml.RegisterResultSetInstruction;
import com.metamatrix.query.processor.xml.WhileInstruction;
import com.metamatrix.query.processor.xml.XMLPlan;
import com.metamatrix.query.resolver.util.BindVariableVisitor;
import com.metamatrix.query.resolver.util.ResolveElementsVisitor;
import com.metamatrix.query.resolver.util.ResolveGroupsVisitor;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.PredicateCriteria;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.AllInGroupSymbol;
import com.metamatrix.query.sql.symbol.AllSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.ExpressionMappingVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.sql.visitor.PredicateCollectorVisitor;
import com.metamatrix.query.sql.visitor.ReferenceBindingReplacerVisitor;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import com.metamatrix.query.validator.PredicateFormValidatorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class XMLPlanner
implements CommandPlanner {
    static final String DELIMITER = ".";
    private static final String STAGING_TABLE_SUBQUERY_GROUP_NAME = "X";

    public void generateCanonical(CommandTreeNode rootNode, QueryMetadataInterface metadata, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, MetaMatrixComponentException {
    }

    public ProcessorPlan optimize(CommandTreeNode node, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        String xmlFormResults;
        XMLPlannerEnvironment env = new XMLPlannerEnvironment();
        if (node.getParent() != null && node.getParent().getCommandType() == 5 && (xmlFormResults = (String)node.getParent().getProperty(XMLPlannerEnvironment.XML_FORM_RESULTS_PROPERTY)) != null) {
            env.xmlFormResults = xmlFormResults;
        }
        return XMLPlanner.preparePlan(node.getCommand(), metadata, analysisRecord, env, idGenerator, capFinder, context);
    }

    public static XMLPlan preparePlan(Command command, QueryMetadataInterface metadata, IDGenerator idGenerator, CapabilitiesFinder capFinder, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        return XMLPlanner.preparePlan(command, metadata, idGenerator, capFinder, new AnalysisRecord(false, false, true), context);
    }

    public static XMLPlan preparePlan(Command command, QueryMetadataInterface metadata, IDGenerator idGenerator, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        return XMLPlanner.preparePlan(command, metadata, analysisRecord, new XMLPlannerEnvironment(), idGenerator, capFinder, context);
    }

    static XMLPlan preparePlan(Command command, QueryMetadataInterface metadata, AnalysisRecord analysisRecord, XMLPlannerEnvironment planEnv, IDGenerator idGenerator, CapabilitiesFinder capFinder, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Query xmlQuery = (Query)command;
        boolean debug = analysisRecord.recordDebug();
        if (debug) {
            analysisRecord.println("\n####################################################");
            analysisRecord.println("XML COMMAND: " + xmlQuery);
        }
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)xmlQuery, (boolean)true);
        GroupSymbol group = (GroupSymbol)groups.iterator().next();
        MappingNode node = metadata.getMappingNode(group.getMetadataID());
        planEnv.rootNode = node = new MappingNode(node);
        planEnv.documentGroup = group;
        planEnv.xmlCommand = (Query)command;
        planEnv.analysisRecord = analysisRecord;
        planEnv.capFinder = capFinder;
        planEnv.metadata = metadata;
        planEnv.idGenerator = idGenerator;
        planEnv.context = context;
        LogManager.logTrace("XML_QUERY_PLANNER", new Object[]{"Mapping document tree", new MappingNodeLogger(node)});
        if (debug) {
            analysisRecord.println("\n####################################################");
            analysisRecord.println("MAPPING DOCUMENT:\n" + MappingNode.toStringNodeTree((MappingNode)node));
        }
        OrderBy orderBy = xmlQuery.getOrderBy();
        OrderBy modified = null;
        Map orderByWithRS = null;
        if (orderBy != null) {
            modified = XMLPlanner.getFullyNamedOrderBy(orderBy, metadata);
            planEnv.orderByWithRS = orderByWithRS = XMLPlanner.getOrderByRS(modified, planEnv);
        }
        RelatePlanner.modifyForRelate((Query)xmlQuery, (XMLPlannerEnvironment)planEnv);
        Criteria crit = xmlQuery.getCriteria();
        Map rsCrits = XMLPlanner.sortUserCriteria(crit, planEnv);
        RelatePlanner.addCritsForRelate((Map)rsCrits, (XMLPlannerEnvironment)planEnv);
        XMLPlanner.prePlan(rsCrits, orderByWithRS, planEnv);
        Program results = new Program();
        boolean isRoot = true;
        planEnv.processorEnvironment = new QueryProcessorEnvironment();
        planEnv.rootNode.setProperty(MappingNodeConstants.Properties.CARDINALITY_MIN_BOUND, (Object)new Integer(1));
        planEnv.rootNode.setProperty(MappingNodeConstants.Properties.CARDINALITY_MAX_BOUND, (Object)new Integer(1));
        XMLPlanner.planNode(results, planEnv.rootNode, isRoot, planEnv);
        ProcessorEnvironment env = planEnv.prepareEnvironment();
        env.pushProgram(results);
        XMLPlan plan = new XMLPlan(env);
        plan.setRelationalPlans((Collection)planEnv.getRelationalPlans());
        if (debug) {
            analysisRecord.println("");
            analysisRecord.println(plan.toString());
            analysisRecord.println("####################################################");
        }
        return plan;
    }

    private static void prePlan(Map rsCrits, Map rsOrderBy, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        XMLPlanner.moveNamespaceDeclarations(planEnv.rootNode);
        Select select = planEnv.xmlCommand.getSelect();
        SelectSymbol firstSymbol = select.getSymbol(0);
        if (!(firstSymbol instanceof AllSymbol)) {
            XMLPlanner.preMarkExcluded(select, planEnv);
        }
        XMLPlanner.removeExcluded(planEnv.rootNode, planEnv);
        XMLPlanner.prePlanQueries(planEnv.rootNode, rsCrits, rsOrderBy, planEnv);
        XMLPlanner.prePlanHandleChoiceOrRecursionCriteria(planEnv.rootNode, planEnv);
        XMLPlanner.prePlanResultSets(planEnv.rootNode, planEnv);
        if (XMLPlanner.existNillableNodes(planEnv.rootNode)) {
            Properties namespaces = (Properties)planEnv.rootNode.getProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS);
            if (namespaces == null) {
                namespaces = new Properties();
            }
            namespaces.setProperty(MappingNodeConstants.INSTANCES_NAMESPACE_PREFIX, MappingNodeConstants.INSTANCES_NAMESPACE);
            planEnv.rootNode.setProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS, (Object)namespaces);
        }
        XMLPlanner.prePlanHandleRecursive(planEnv.rootNode, planEnv);
        XMLPlanner.prePlanTempGroupOptimization(planEnv.rootNode, planEnv);
        XMLPlanner.prePlanReorderAttributesAndComments(planEnv.rootNode);
    }

    static void prePlanReorderAttributesAndComments(MappingNode node) {
        MappingNode attr = MappingNode.findFirstNodeWithPropertyString((Integer)MappingNodeConstants.Properties.NODE_TYPE, (String)"attribute", (MappingNode)node, (int)4);
        if (attr != null) {
            MappingNode parent = attr.getParent();
            int index = -1;
            List children = parent.getChildren();
            Iterator childrenIter = children.iterator();
            ArrayList<MappingNode> temp = new ArrayList<MappingNode>(children.size());
            ArrayList<MappingNode> elements = new ArrayList<MappingNode>(children.size());
            int i = 0;
            while (childrenIter.hasNext()) {
                MappingNode child = (MappingNode)childrenIter.next();
                Object nodeType = child.getProperty(MappingNodeConstants.Properties.NODE_TYPE);
                if (index >= 0) {
                    if ("element".equals(nodeType)) {
                        elements.add(child);
                    } else {
                        temp.add(child);
                        childrenIter.remove();
                    }
                } else if ("element".equals(nodeType)) {
                    elements.add(child);
                    index = i;
                }
                ++i;
            }
            if (temp.size() > 0) {
                children.addAll(index, temp);
            }
            Iterator j = elements.iterator();
            while (j.hasNext()) {
                MappingNode element = (MappingNode)j.next();
                XMLPlanner.prePlanReorderAttributesAndComments(element);
            }
        }
    }

    private static void prePlanHandleChoiceOrRecursionCriteria(MappingNode node, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        String criteriaString = (String)node.getProperty(MappingNodeConstants.Properties.CRITERIA);
        if (criteriaString == null || criteriaString.trim().length() == 0) {
            criteriaString = (String)node.getProperty(MappingNodeConstants.Properties.RECURSION_CRITERIA);
        }
        if (criteriaString != null && criteriaString.trim().length() > 0) {
            Criteria criteria = QueryUtil.parseCriteria(criteriaString, planEnv);
            Collection elements = ElementCollectorVisitor.getElements((LanguageObject)criteria, (boolean)true);
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                ElementSymbol element = (ElementSymbol)i.next();
                planEnv.mappingClassAttributesNeeded.add(element.getName().toUpperCase());
            }
        }
        Iterator children = node.getChildren().iterator();
        while (children.hasNext()) {
            MappingNode child = (MappingNode)children.next();
            XMLPlanner.prePlanHandleChoiceOrRecursionCriteria(child, planEnv);
        }
    }

    static void moveNamespaceDeclarations(MappingNode node) {
        MappingNode child;
        Iterator children = node.getChildren().iterator();
        while (children.hasNext()) {
            child = (MappingNode)children.next();
            if (!child.getProperty(MappingNodeConstants.Properties.NODE_TYPE).equals("attribute") || !"xmlns".equals(child.getProperty(MappingNodeConstants.Properties.NAMESPACE_PREFIX)) && !"xmlns".equals(child.getProperty(MappingNodeConstants.Properties.NAME))) continue;
            children.remove();
            XMLPlanner.addNamespaceDeclarationProperty(node, child);
        }
        children = node.getChildren().iterator();
        while (children.hasNext()) {
            child = (MappingNode)children.next();
            XMLPlanner.moveNamespaceDeclarations(child);
        }
    }

    private static void addNamespaceDeclarationProperty(MappingNode root, MappingNode attr) {
        String prefix;
        Properties namespaceDeclarations = (Properties)root.getProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS);
        if (namespaceDeclarations == null) {
            namespaceDeclarations = new Properties();
            root.setProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS, (Object)namespaceDeclarations);
        }
        if ((prefix = (String)attr.getProperty(MappingNodeConstants.Properties.NAME)).equals("xmlns")) {
            prefix = "";
        }
        String uri = (String)attr.getProperty(MappingNodeConstants.Properties.FIXED_VALUE);
        namespaceDeclarations.setProperty(prefix, uri);
    }

    private static void preMarkExcluded(Select select, XMLPlannerEnvironment planEnv) throws QueryMetadataException, QueryPlannerException {
        List symbols = select.getSymbols();
        List modified = null;
        try {
            modified = XMLPlanner.getFullyResolvedSelect(symbols, planEnv);
        }
        catch (Exception ex) {
            throw new QueryPlannerException(QueryExecPlugin.Util.getString("ERR.015.004.0066"));
        }
        for (int i = 0; i < modified.size(); ++i) {
            SelectSymbol symbol = (SelectSymbol)modified.get(i);
            boolean outputInSource = true;
            boolean outputInTarget = true;
            Function function = RelatePlanner.getRelateSourceOrRelateTargetFunction((SelectSymbol)symbol);
            if (function != null) {
                if (function.getName().equalsIgnoreCase("relatesource")) {
                    outputInTarget = false;
                    symbol = (ElementSymbol)function.getArg(0);
                } else {
                    outputInSource = false;
                    symbol = (ElementSymbol)function.getArg(0);
                }
            }
            String symbolName = symbol.getName();
            if (symbol instanceof AllInGroupSymbol) {
                int index = symbolName.indexOf("*");
                String elementPart = symbolName.substring(0, index - 1);
                XMLPlanner.prepareMark(elementPart, planEnv, false);
                String qualifiedElemName = XMLPlanner.getQualifiedName(elementPart, planEnv);
                MappingNode stopNode = MappingNode.findNode((MappingNode)planEnv.rootNode, (List)XMLPlanner.getNameParts(qualifiedElemName));
                XMLPlanner.markTree(stopNode, MappingNodeConstants.Properties.IS_INCLUDED);
                RelatePlanner.markSelfEntityTree((MappingNode)stopNode, (String)qualifiedElemName, (XMLPlannerEnvironment)planEnv);
                continue;
            }
            boolean isSelfEntityRelationship = RelatePlanner.validateRelateSourceAndTargetUse((String)symbolName, (XMLPlannerEnvironment)planEnv, (boolean)outputInTarget, (boolean)outputInSource);
            if (outputInSource || outputInTarget && !isSelfEntityRelationship) {
                XMLPlanner.prepareMark(symbolName, planEnv, true);
            }
            if (!isSelfEntityRelationship || !outputInTarget) continue;
            RelatePlanner.markSelfEntityNode((String)symbolName, (XMLPlannerEnvironment)planEnv);
        }
        XMLPlanner.markTree(planEnv.rootNode, MappingNodeConstants.Properties.IS_EXCLUDED);
    }

    private static void prepareMark(String elementName, XMLPlannerEnvironment planEnv, boolean isNotAllinGroupSymbol) throws QueryMetadataException, QueryPlannerException {
        MappingNode elementNode = null;
        String qualifiedElemName = null;
        elementNode = MappingNode.findFirstNodeWithPropertyString((Integer)MappingNodeConstants.Properties.NAME, (String)elementName, (MappingNode)planEnv.rootNode, (int)3);
        qualifiedElemName = elementNode != null ? elementNode.getQualifiedName() : XMLPlanner.getQualifiedName(elementName, planEnv);
        MappingNode destNode = MappingNode.findNode((MappingNode)planEnv.rootNode, (List)XMLPlanner.getNameParts(qualifiedElemName));
        XMLPlanner.markIncluded(destNode);
    }

    static void markIncluded(MappingNode srcNode) {
        for (MappingNode parentNode = srcNode; parentNode != null; parentNode = parentNode.getParent()) {
            parentNode.setProperty(MappingNodeConstants.Properties.IS_INCLUDED, (Object)Boolean.TRUE);
            List attributes = parentNode.getChildren();
            Iterator i = attributes.iterator();
            while (i.hasNext()) {
                MappingNode child = (MappingNode)i.next();
                Boolean include = (Boolean)child.getProperty(MappingNodeConstants.Properties.ALWAYS_INCLUDE);
                if (include == null || !include.booleanValue()) continue;
                child.setProperty(MappingNodeConstants.Properties.IS_INCLUDED, (Object)Boolean.TRUE);
            }
        }
    }

    private static void removeExcluded(MappingNode node, XMLPlannerEnvironment planEnv) {
        String recursionRootMappingClass = (String)node.getProperty(MappingNodeConstants.Properties.RECURSION_ROOT_MAPPING_CLASS);
        if (recursionRootMappingClass == null) {
            List children;
            String elementName = (String)node.getProperty(MappingNodeConstants.Properties.ELEMENT_NAME);
            if (elementName != null) {
                planEnv.mappingClassAttributesNeeded.add(elementName.toUpperCase());
            }
            if ((children = node.getChildren()) != null) {
                MappingNode child;
                Iterator childIter;
                if (!XMLPlanner.isChoiceNode(node)) {
                    childIter = children.iterator();
                    while (childIter.hasNext()) {
                        child = (MappingNode)childIter.next();
                        if (!((Boolean)child.getProperty(MappingNodeConstants.Properties.IS_EXCLUDED)).booleanValue()) continue;
                        childIter.remove();
                    }
                }
                childIter = children.iterator();
                while (childIter.hasNext()) {
                    child = (MappingNode)childIter.next();
                    XMLPlanner.removeExcluded(child, planEnv);
                }
            }
        }
    }

    private static void prePlanQueries(MappingNode node, Map rsCrits, Map rsOrderBy, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        String upper;
        String rsName = null;
        Iterator i = ((Collection)node.getProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES)).iterator();
        while (i.hasNext()) {
            rsName = (String)i.next();
            upper = rsName.toUpperCase();
            boolean IS_TEMP_GROUP = true;
            if (planEnv.getQuery(upper) != null) continue;
            Query query = XMLPlanner.constructResultSetQuery(rsName, IS_TEMP_GROUP, rsCrits, null, planEnv);
            planEnv.setQuery(upper, (Command)query);
            XMLPlanner.buildReferencesMap(planEnv, (Command)query, rsName, null);
        }
        rsName = (String)node.getProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
        if (rsName != null) {
            upper = rsName.toUpperCase();
            OrderBy orderby = null;
            if (rsOrderBy != null) {
                orderby = (OrderBy)rsOrderBy.get(upper);
            }
            boolean IS_TEMP_GROUP = false;
            if (planEnv.getQuery(upper) == null) {
                Query query = XMLPlanner.constructResultSetQuery(rsName, IS_TEMP_GROUP, rsCrits, orderby, planEnv);
                planEnv.setQuery(upper, (Command)query);
                String RECURSION_ROOT_MAPPING_CLASS = (String)node.getProperty(MappingNodeConstants.Properties.RECURSION_ROOT_MAPPING_CLASS);
                XMLPlanner.buildReferencesMap(planEnv, (Command)query, rsName, RECURSION_ROOT_MAPPING_CLASS);
            }
        }
        Iterator children = node.getChildren().iterator();
        while (children.hasNext()) {
            MappingNode child = (MappingNode)children.next();
            XMLPlanner.prePlanQueries(child, rsCrits, rsOrderBy, planEnv);
        }
    }

    private static void prePlanResultSets(MappingNode node, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        ProcessorPlan queryPlan;
        boolean IS_TEMP_GROUP;
        String upper;
        Iterator children = node.getChildren().iterator();
        while (children.hasNext()) {
            MappingNode child = (MappingNode)children.next();
            XMLPlanner.prePlanResultSets(child, planEnv);
        }
        String rsName = null;
        Iterator i = ((Collection)node.getProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES)).iterator();
        while (i.hasNext()) {
            rsName = (String)i.next();
            upper = rsName.toUpperCase();
            IS_TEMP_GROUP = true;
            if (planEnv.getRelationalPlan(upper) != null) continue;
            Query query = (Query)planEnv.getQuery(upper);
            String RECURSION_ROOT_MAPPING_CLASS = null;
            queryPlan = XMLPlanner.planResultSet(rsName, query, IS_TEMP_GROUP, RECURSION_ROOT_MAPPING_CLASS, planEnv);
            planEnv.setRelationalPlan(upper, queryPlan);
        }
        rsName = (String)node.getProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
        if (rsName != null) {
            upper = rsName.toUpperCase();
            IS_TEMP_GROUP = false;
            String RECURSION_ROOT_MAPPING_CLASS = (String)node.getProperty(MappingNodeConstants.Properties.RECURSION_ROOT_MAPPING_CLASS);
            if (planEnv.getRelationalPlan(upper) == null) {
                Query query = (Query)planEnv.getQuery(upper);
                queryPlan = XMLPlanner.planResultSet(rsName, query, false, RECURSION_ROOT_MAPPING_CLASS, planEnv);
                planEnv.setRelationalPlan(upper, queryPlan);
            }
        }
    }

    static void prePlanTempGroupOptimization(MappingNode root, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        boolean doOptimization = true;
        if (!doOptimization) {
            return;
        }
        boolean INITIAL_DEPTH = false;
        boolean INITIAL_FRAME_NUMBER = false;
        XMLPlanner.tempGroupRecursiveOptimization(root, root, planEnv, 0, 0);
        if (planEnv.analysisRecord.recordDebug()) {
            planEnv.analysisRecord.println("\n####################################################");
            planEnv.analysisRecord.println("MAPPING DOCUMENT after temp tables locations optimization:\n" + MappingNode.toStringNodeTree((MappingNode)root));
        }
    }

    private static void tempGroupRecursiveOptimization(MappingNode root, MappingNode node, XMLPlannerEnvironment planEnv, int depth, int frameNumber) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        boolean IS_MAPPING_CLASS;
        Collection tempNameProp = (Collection)node.getProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES);
        Iterator tempGroupNames = tempNameProp.iterator();
        while (tempGroupNames.hasNext()) {
            String tempGroupName = (String)tempGroupNames.next();
            IS_MAPPING_CLASS = false;
            Frame tempGroupFrame = new Frame(node, depth, frameNumber, false);
            Frame possibleNewFrame = new Frame(root, 0, 0, false);
            boolean hasAlternateQuery = planEnv.getAlternateMappingClassQuery(tempGroupName) != null;
            Command query = null;
            query = hasAlternateQuery ? planEnv.getQuery(tempGroupName) : QueryUtil.parseQuery(XMLPlanner.getQueryNode(tempGroupName, planEnv.metadata), planEnv);
            boolean REMOVE_DUPLICATES = true;
            Iterator groupsSelectedFrom = GroupCollectorVisitor.getGroups((LanguageObject)query, (boolean)true).iterator();
            while (groupsSelectedFrom.hasNext()) {
                GroupSymbol groupSymbol = (GroupSymbol)groupsSelectedFrom.next();
                possibleNewFrame = Frame.getDeepest((Frame)possibleNewFrame, (Frame)planEnv.getFrameData(groupSymbol.getName().toUpperCase()));
            }
            if (!hasAlternateQuery) {
                QueryNode queryNode = XMLPlanner.getQueryNode(tempGroupName, planEnv.metadata);
                List bindings = queryNode.getBindings();
                Iterator groupsBoundTo = XMLPlanner.getGroupsBoundTo(bindings, planEnv).iterator();
                while (groupsBoundTo.hasNext()) {
                    GroupSymbol groupSymbol = (GroupSymbol)groupsBoundTo.next();
                    possibleNewFrame = Frame.getDeepest((Frame)possibleNewFrame, (Frame)planEnv.getFrameData(groupSymbol.getName().toUpperCase()));
                }
            }
            if (tempGroupFrame.isLowerFrameThan(possibleNewFrame)) {
                LogManager.logTrace("XML_QUERY_PLANNER", new Object[]{"Optimizing location of temp table", tempGroupName});
                tempGroupNames.remove();
                XMLPlanner.moveTempGroup(tempGroupName, tempGroupFrame, possibleNewFrame);
            }
            planEnv.setFrameData(tempGroupName.toUpperCase(), tempGroupFrame);
        }
        node.setProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES, (Object)tempNameProp);
        String mappingClassName = (String)node.getProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
        if (mappingClassName != null) {
            IS_MAPPING_CLASS = true;
            Frame frame = new Frame(node, depth, ++frameNumber, true);
            planEnv.setFrameData(mappingClassName.toUpperCase(), frame);
        }
        Iterator children = node.getChildren().iterator();
        ++depth;
        while (children.hasNext()) {
            MappingNode child = (MappingNode)children.next();
            XMLPlanner.tempGroupRecursiveOptimization(root, child, planEnv, depth, frameNumber);
        }
    }

    static QueryNode getQueryNode(String groupName, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        QueryNode queryNode = null;
        try {
            GroupSymbol gs = new GroupSymbol(groupName);
            ResolveGroupsVisitor.resolveGroups((LanguageObject)gs, (QueryMetadataInterface)metadata);
            queryNode = XMLPlanner.getQueryNode(gs, metadata);
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)e, "ERR.015.004.0029", QueryExecPlugin.Util.getString("ERR.015.004.0029", (Object)groupName));
        }
        return queryNode;
    }

    static QueryNode getQueryNode(GroupSymbol group, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        return metadata.getVirtualPlan(group.getMetadataID());
    }

    private static Collection getGroupsBoundTo(List bindingsCollection, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        HashSet<GroupSymbol> groups = null;
        if (bindingsCollection != null) {
            groups = new HashSet<GroupSymbol>();
            Iterator bindings = bindingsCollection.iterator();
            while (bindings.hasNext()) {
                String stringBinding = (String)bindings.next();
                ElementSymbol binding = QueryUtil.resolveBinding(stringBinding, planEnv);
                groups.add(binding.getGroupSymbol());
            }
        } else {
            groups = Collections.EMPTY_SET;
        }
        return groups;
    }

    private static void moveTempGroup(String tempGroupName, Frame tempGroupFrame, Frame possibleNewFrame) {
        ArrayList<String> names;
        MappingNode targetNode = possibleNewFrame.mappingNode;
        if (possibleNewFrame.isMappingClass) {
            MappingNode temp = tempGroupFrame.mappingNode;
            while (temp.getParent() != targetNode) {
                temp = temp.getParent();
                Assertion.isNotNull((Object)temp);
            }
            targetNode = temp;
        }
        if ((names = (ArrayList<String>)targetNode.getNodeProperties().get(MappingNodeConstants.Properties.TEMP_GROUP_NAMES)) == null) {
            names = new ArrayList<String>();
        }
        names.add(tempGroupName);
        targetNode.setProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES, names);
        tempGroupFrame.depth = possibleNewFrame.depth;
        tempGroupFrame.frameNumber = possibleNewFrame.frameNumber;
        tempGroupFrame.mappingNode = targetNode;
    }

    private static void prePlanHandleRecursive(MappingNode node, XMLPlannerEnvironment planEnv) throws QueryMetadataException, MetaMatrixComponentException {
        Iterator children = node.getChildren().iterator();
        while (children.hasNext()) {
            MappingNode child = (MappingNode)children.next();
            XMLPlanner.prePlanHandleRecursive(child, planEnv);
        }
        if (((Boolean)node.getProperty(MappingNodeConstants.Properties.IS_RECURSIVE)).booleanValue()) {
            MappingNode recursiveRootNode;
            String recursiveRootMappingClass = (String)node.getProperty(MappingNodeConstants.Properties.RECURSION_ROOT_MAPPING_CLASS);
            for (recursiveRootNode = node.getParent(); recursiveRootNode != null; recursiveRootNode = recursiveRootNode.getParent()) {
                Object mappingClassName = recursiveRootNode.getProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
                if (!recursiveRootMappingClass.equals(mappingClassName)) continue;
                recursiveRootNode.setProperty(MappingNodeConstants.Properties.IS_RECURSIVE_ROOT, (Object)Boolean.TRUE);
                break;
            }
            if (recursiveRootNode == null) {
                Assertion.isNotNull((Object)recursiveRootNode, (String)QueryExecPlugin.Util.getString("ERR.015.004.0061", (Object)node));
            }
        }
    }

    private static boolean existNillableNodes(MappingNode node) {
        Boolean isNillable = (Boolean)node.getProperty(MappingNodeConstants.Properties.IS_NILLABLE);
        if (isNillable != null && isNillable.booleanValue()) {
            return true;
        }
        Iterator children = node.getChildren().iterator();
        while (children.hasNext()) {
            MappingNode child = (MappingNode)children.next();
            if (!XMLPlanner.existNillableNodes(child)) continue;
            return true;
        }
        return false;
    }

    private static void processDocumentHeader(MappingNode root, Program program) {
        String encoding = (String)root.getProperty(MappingNodeConstants.Properties.DOCUMENT_ENCODING);
        Boolean isFormatted = (Boolean)root.getProperty(MappingNodeConstants.Properties.FORMATTED_DOCUMENT);
        InitializeDocumentInstruction header = new InitializeDocumentInstruction(encoding, isFormatted.booleanValue());
        program.addInstruction((ProcessorInstruction)header);
    }

    static void planNode(Program currentProgram, MappingNode node, boolean isRootNode, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Collection stagingTables = (Collection)node.getProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES);
        Iterator stagingTablesIterator = stagingTables.iterator();
        while (stagingTablesIterator.hasNext()) {
            String stagingTableName = (String)stagingTablesIterator.next();
            String stagingTableKey = stagingTableName.toUpperCase();
            QueryProcessorEnvironment env = planEnv.processorEnvironment;
            ProcessorPlan resultSetObj = planEnv.getRelationalPlan(stagingTableKey);
            List references = null;
            List replacementExpressions = null;
            env.registerResultSet(stagingTableKey, (Object)resultSetObj, references, replacementExpressions);
            boolean IS_STAGING_TABLE = true;
            boolean sourceInMemory = planEnv.isSelectingFromInMemoryOnly(stagingTableKey);
            ExecSqlInstruction sqlInst = new ExecSqlInstruction(stagingTableName, true, sourceInMemory);
            currentProgram.addInstruction((ProcessorInstruction)sqlInst);
        }
        WhileInstruction whileInst = null;
        String rsName = (String)node.getProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
        if (rsName != null) {
            String rsKey = rsName.toUpperCase();
            boolean NOT_TEMP_GROUP = false;
            boolean isRecursive = (Boolean)node.getProperty(MappingNodeConstants.Properties.IS_RECURSIVE);
            if (isRecursive) {
                String recursionRootMappingClass = (String)node.getProperty(MappingNodeConstants.Properties.RECURSION_ROOT_MAPPING_CLASS);
                String recursionRootMappingKey = recursionRootMappingClass.toUpperCase();
                boolean SOURCE_IN_MEMORY = planEnv.isSelectingFromInMemoryOnly(recursionRootMappingKey);
                ProcessorPlan resultSetObj = planEnv.getRelationalPlan(rsKey);
                List references = planEnv.getBoundReferences(recursionRootMappingKey);
                ArrayList<ElementSymbol> replacementExpressions = null;
                if (references != null) {
                    LogManager.logTrace("XML_QUERY_PLANNER", new Object[]{"Found bound references list", references, "for result set", recursionRootMappingKey});
                    replacementExpressions = new ArrayList<ElementSymbol>(references.size());
                    Iterator refs = references.iterator();
                    while (refs.hasNext()) {
                        Reference ref = (Reference)refs.next();
                        ElementSymbol elementSymbol = (ElementSymbol)ref.getExpression();
                        String newElemName = rsName + DELIMITER + elementSymbol.getShortName();
                        ElementSymbol newElementSymbol = new ElementSymbol(newElemName);
                        newElementSymbol.setType(elementSymbol.getType());
                        replacementExpressions.add(newElementSymbol);
                    }
                }
                RegisterResultSetInstruction regInst = new RegisterResultSetInstruction(recursionRootMappingKey, (Object)resultSetObj, references, replacementExpressions);
                currentProgram.addInstruction((ProcessorInstruction)regInst);
                currentProgram.addInstruction((ProcessorInstruction)new CacheResultsInstruction(true));
                ExecSqlInstruction sqlInst = new ExecSqlInstruction(recursionRootMappingClass, false, SOURCE_IN_MEMORY);
                currentProgram.addInstruction((ProcessorInstruction)sqlInst);
                MoveCursorInstruction moveCursor = new MoveCursorInstruction(recursionRootMappingClass);
                currentProgram.addInstruction((ProcessorInstruction)moveCursor);
                whileInst = new WhileInstruction(recursionRootMappingKey);
                currentProgram.addInstruction((ProcessorInstruction)whileInst);
                currentProgram.addInstruction((ProcessorInstruction)new CacheResultsInstruction(false));
                currentProgram.addInstruction((ProcessorInstruction)new DeregisterResultSetInstruction(recursionRootMappingKey));
            } else {
                boolean SOURCE_IN_MEMORY = planEnv.isSelectingFromInMemoryOnly(rsKey);
                ExecSqlInstruction sqlInst = new ExecSqlInstruction(rsName, false, SOURCE_IN_MEMORY);
                currentProgram.addInstruction((ProcessorInstruction)sqlInst);
                MoveCursorInstruction moveCursor = new MoveCursorInstruction(rsName);
                currentProgram.addInstruction((ProcessorInstruction)moveCursor);
                whileInst = new WhileInstruction(rsKey);
                currentProgram.addInstruction((ProcessorInstruction)whileInst);
                QueryProcessorEnvironment env = planEnv.processorEnvironment;
                ProcessorPlan resultSetObj = planEnv.getRelationalPlan(rsKey);
                List references = planEnv.getBoundReferences(rsKey);
                ArrayList<Expression> replacementExpressions = null;
                if (references != null) {
                    LogManager.logTrace("XML_QUERY_PLANNER", new Object[]{"Found bound references list", references, "for result set", rsKey});
                    replacementExpressions = new ArrayList<Expression>(references.size());
                    Iterator refs = references.iterator();
                    while (refs.hasNext()) {
                        Reference ref = (Reference)refs.next();
                        Expression refExpr = ref.getExpression();
                        if (planEnv.relationships != null && !planEnv.relationships.isEmpty()) {
                            Relationship relationship = (Relationship)planEnv.relationships.iterator().next();
                            refExpr = XMLPlanner.getAlternateExpressionForRelate(refExpr, relationship, planEnv);
                        }
                        replacementExpressions.add(refExpr);
                    }
                }
                env.registerResultSet(rsKey, (Object)resultSetObj, references, replacementExpressions);
            }
            Program childProgram = new Program();
            whileInst.setBlockProgram(childProgram);
            if (isRootNode) {
                XMLPlanner.processDocumentHeader(node, childProgram);
            }
        } else if (isRootNode) {
            XMLPlanner.processDocumentHeader(node, currentProgram);
        }
        String name = (String)node.getProperty(MappingNodeConstants.Properties.NAME);
        String nodeType = (String)node.getProperty(MappingNodeConstants.Properties.NODE_TYPE);
        if (name != null || nodeType.equals("comment")) {
            if (rsName == null) {
                XMLPlanner.addTag(currentProgram, name, node, planEnv);
            } else {
                XMLPlanner.addTag(whileInst.getBlockProgram(), name, node, planEnv);
            }
        }
        if (rsName == null) {
            XMLPlanner.processChildren(currentProgram, node, planEnv);
            if (isRootNode) {
                currentProgram.addInstruction((ProcessorInstruction)new EndDocumentInstruction());
            }
        } else {
            String rsKey = rsName.toUpperCase();
            boolean beginRecursiveBlock = (Boolean)node.getProperty(MappingNodeConstants.Properties.IS_RECURSIVE_ROOT);
            boolean isRecursive = (Boolean)node.getProperty(MappingNodeConstants.Properties.IS_RECURSIVE);
            String recursionRootMappingClass = (String)node.getProperty(MappingNodeConstants.Properties.RECURSION_ROOT_MAPPING_CLASS);
            Program program = whileInst.getBlockProgram();
            if (beginRecursiveBlock) {
                Program recursiveProgram;
                program = recursiveProgram = new Program();
                planEnv.setRecursiveProgram(rsKey, recursiveProgram);
            } else if (isRecursive) {
                String recursionRootKey = recursionRootMappingClass.toUpperCase();
                Program recursiveProgram = planEnv.getRecursiveProgram(recursionRootKey);
                IfInstruction ifInst = new IfInstruction();
                whileInst.getBlockProgram().addInstruction((ProcessorInstruction)ifInst);
                RecurseProgramCondition recurseCondition = XMLPlanner.getRecurseCondition(recursiveProgram, planEnv, node);
                ifInst.addCondition(recurseCondition);
            }
            XMLPlanner.processChildren(program, node, planEnv);
            if (isRootNode) {
                program.addInstruction((ProcessorInstruction)new EndDocumentInstruction());
            }
            if (beginRecursiveBlock) {
                if (whileInst.getBlockProgram() == program) {
                    String msg = QueryExecPlugin.Util.getString("ERR.015.004.0002", new Object[]{ProgramUtil.programToString((Program)program)});
                    LogManager.logError("XML_QUERY_PLANNER", msg);
                    throw new MetaMatrixComponentException(msg);
                }
                whileInst.getBlockProgram().addInstructions(program);
                ProcessorInstruction firstInst = program.getInstructionAt(0);
                if (firstInst instanceof AddNodeInstruction) {
                    program.removeInstructionAt(0);
                }
            }
            if (isRecursive) {
                whileInst.getBlockProgram().addInstruction((ProcessorInstruction)new MoveCursorInstruction(recursionRootMappingClass));
            } else {
                whileInst.getBlockProgram().addInstruction((ProcessorInstruction)new MoveCursorInstruction(rsName));
            }
        }
        stagingTablesIterator = stagingTables.iterator();
        while (stagingTablesIterator.hasNext()) {
            String tempGroupName = (String)stagingTablesIterator.next();
            CloseResultSetInstruction closeInst = new CloseResultSetInstruction(tempGroupName);
            currentProgram.addInstruction((ProcessorInstruction)closeInst);
        }
    }

    private static Expression getAlternateExpressionForRelate(Expression refExpr, Relationship relationship, XMLPlannerEnvironment planEnv) {
        ElementSymbol element = (ElementSymbol)refExpr;
        Expression replacement = XMLPlanner.getAlternateExpressionForRelateMappingClass(element, relationship.sourceState.resultSet, planEnv);
        if (replacement == element && (replacement = XMLPlanner.getAlternateExpressionForRelateMappingClass(element, relationship.targetState.resultSet, planEnv)) == element) {
            replacement = XMLPlanner.getAlternateExpressionForRelateMappingClass(element, relationship.mappingState.resultSet, planEnv);
        }
        return replacement;
    }

    private static Expression getAlternateExpressionForRelateMappingClass(ElementSymbol element, String rsName, XMLPlannerEnvironment planEnv) {
        if (element.getGroupSymbol().getName().equalsIgnoreCase(rsName)) {
            Command command = planEnv.getAlternateMappingClassQuery(rsName);
            Iterator i = command.getProjectedSymbols().iterator();
            while (i.hasNext()) {
                SingleElementSymbol projSymbol = (SingleElementSymbol)i.next();
                if (!projSymbol.getShortName().equalsIgnoreCase(element.getShortName())) continue;
                return projSymbol;
            }
        }
        return element;
    }

    private static void processChildren(Program program, MappingNode node, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        List children = node.getChildren();
        if (children != null && !children.isEmpty()) {
            String name = (String)node.getProperty(MappingNodeConstants.Properties.NAME);
            if (name != null) {
                program.addInstruction((ProcessorInstruction)new MoveDocInstruction(1));
            }
            if (XMLPlanner.isChoiceNode(node)) {
                XMLPlanner.planChoiceNode(program, node, planEnv);
            } else {
                Iterator i = children.iterator();
                while (i.hasNext()) {
                    MappingNode child = (MappingNode)i.next();
                    boolean isRoot = false;
                    XMLPlanner.planNode(program, child, isRoot, planEnv);
                }
            }
            if (name != null) {
                program.addInstruction((ProcessorInstruction)new MoveDocInstruction(0));
            }
        }
    }

    static Map sortUserCriteria(Criteria criteria, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        if (criteria == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, CriteriaContextInfo> criteriaMap = new HashMap<String, CriteriaContextInfo>();
        HashMap<String, Criteria> resultSetCriteria = new HashMap<String, Criteria>();
        Iterator conjunctIter = Criteria.separateCriteriaByAnd((Criteria)criteria).iterator();
        while (conjunctIter.hasNext()) {
            Criteria conjunct = (Criteria)conjunctIter.next();
            short wrapperMode = RelateWrapperFunctionVisitor.removeWrappers((Criteria)conjunct);
            if (XMLPlanner.handleRowLimitFunction(conjunct, criteria, planEnv)) continue;
            String rootTempGroupName = XMLPlanner.validateConjunct(conjunct, planEnv.metadata);
            if (rootTempGroupName != null) {
                String rootTempGroupKey = rootTempGroupName.toUpperCase();
                Criteria existingStagingTableCriteria = (Criteria)resultSetCriteria.get(rootTempGroupKey);
                if (existingStagingTableCriteria == null) {
                    resultSetCriteria.put(rootTempGroupKey, conjunct);
                    continue;
                }
                Criteria compoundCrit = Criteria.combineCriteria((Criteria)existingStagingTableCriteria, (Criteria)conjunct);
                resultSetCriteria.put(rootTempGroupKey, compoundCrit);
                continue;
            }
            Iterator predicates = PredicateCollectorVisitor.getPredicates((LanguageObject)conjunct).iterator();
            String contextResultSet = null;
            String critResultSet = null;
            boolean explicitContext = false;
            while (predicates.hasNext()) {
                PredicateCriteria predicate = (PredicateCriteria)predicates.next();
                String[] resultSets = XMLPlanner.validatePredicateAndGetResultSets(predicate, planEnv.rootNode, planEnv);
                if (contextResultSet == null) {
                    contextResultSet = resultSets[0];
                }
                if (critResultSet == null) {
                    critResultSet = resultSets[1];
                    boolean bl = explicitContext = resultSets[2] != null;
                }
                if (!contextResultSet.equalsIgnoreCase(resultSets[0])) {
                    throw new QueryPlannerException("ERR.015.004.0033", QueryExecPlugin.Util.getString("ERR.015.004.0033", new Object[]{conjunct, contextResultSet, resultSets[0]}));
                }
                if (!critResultSet.equalsIgnoreCase(resultSets[1])) {
                    throw new QueryPlannerException("ERR.015.004.0034", QueryExecPlugin.Util.getString("ERR.015.004.0034", new Object[]{conjunct, critResultSet, resultSets[1]}));
                }
                if (!planEnv.hasRelationships() || explicitContext == (resultSets[2] != null)) continue;
                throw new QueryPlannerException(QueryExecPlugin.Util.getString("XMLPlanner.explicit_context", (Object)conjunct));
            }
            Criteria convertedCrit = XMLPlanner.convertCriteria(conjunct, planEnv.rootNode, planEnv.metadata);
            CriteriaContextInfo info = (CriteriaContextInfo)criteriaMap.get(contextResultSet);
            if (info == null) {
                info = new CriteriaContextInfo();
                criteriaMap.put(contextResultSet, info);
            }
            info.addCriteria(convertedCrit, explicitContext, wrapperMode);
            info.addCritRS(critResultSet);
        }
        XMLPlanner.applyUserCriteriaToContext(criteriaMap, resultSetCriteria, planEnv);
        return resultSetCriteria;
    }

    private static void applyUserCriteriaToContext(Map criteriaMap, Map resultSetCriteria, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        RelatePlanner.processUserCritForRelate((Map)criteriaMap, (XMLPlannerEnvironment)planEnv);
        Iterator keys = criteriaMap.keySet().iterator();
        while (keys.hasNext()) {
            String contextResultSet = (String)keys.next();
            CriteriaContextInfo info = (CriteriaContextInfo)criteriaMap.get(contextResultSet);
            Criteria rsCrit = info.getCriteria(new int[]{3, 4, 5, 0, 1, 2});
            resultSetCriteria.put(contextResultSet, XMLPlanner.sortUserContextCriteria(info.critRSNames, contextResultSet, rsCrit, planEnv));
        }
    }

    static boolean handleRowLimitFunction(Criteria conjunct, Criteria wholeCrit, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Function rowLimitFunction = null;
        Constant rowLimitConstant = null;
        boolean exceptionOnRowLimit = false;
        if (conjunct instanceof CompareCriteria) {
            Function function;
            CompareCriteria crit = (CompareCriteria)conjunct;
            if (crit.getLeftExpression() instanceof Function) {
                function = (Function)crit.getLeftExpression();
                if (function.getName().equalsIgnoreCase("rowlimit")) {
                    rowLimitFunction = function;
                    rowLimitConstant = (Constant)crit.getRightExpression();
                } else if (function.getName().equalsIgnoreCase("rowlimitexception")) {
                    rowLimitFunction = function;
                    rowLimitConstant = (Constant)crit.getRightExpression();
                    exceptionOnRowLimit = true;
                }
            }
            if (rowLimitFunction == null && crit.getRightExpression() instanceof Function) {
                function = (Function)crit.getRightExpression();
                if (function.getName().equalsIgnoreCase("rowlimit")) {
                    rowLimitFunction = function;
                    rowLimitConstant = (Constant)crit.getLeftExpression();
                } else if (function.getName().equalsIgnoreCase("rowlimitexception")) {
                    rowLimitFunction = function;
                    rowLimitConstant = (Constant)crit.getLeftExpression();
                    exceptionOnRowLimit = true;
                }
            }
        }
        if (rowLimitFunction != null) {
            Integer rowLimit = (Integer)rowLimitConstant.getValue();
            String fullyQualifiedNodeName = XMLPlanner.getFullyQualifiedName((ElementSymbol)rowLimitFunction.getArg(0), planEnv);
            MappingNode node = MappingNode.findNode((MappingNode)planEnv.rootNode, (List)XMLPlanner.getNameParts(fullyQualifiedNodeName));
            String critResultKey = XMLPlanner.getClosestResultSet(node, fullyQualifiedNodeName, true);
            if (critResultKey == null) {
                String msg = QueryExecPlugin.Util.getString("XMLPlanner.The_rowlimit_parameter_{0}_is_not_in_the_scope_of_any_mapping_class", (Object)fullyQualifiedNodeName);
                throw new QueryPlannerException(msg);
            }
            Integer existingLimit = planEnv.getRowLimit(critResultKey);
            if (existingLimit != null && !existingLimit.equals(rowLimit)) {
                String msg = QueryExecPlugin.Util.getString("XMLPlanner.Criteria_{0}_contains_conflicting_row_limits", (Object)wholeCrit);
                throw new QueryPlannerException(msg);
            }
            planEnv.setRowLimit(critResultKey, rowLimit, exceptionOnRowLimit);
            return true;
        }
        return false;
    }

    static String getFullyQualifiedName(ElementSymbol elementSymbol, XMLPlannerEnvironment planEnv) throws QueryMetadataException, MetaMatrixComponentException {
        String fullyQualifiedNodeName = planEnv.metadata.getFullName(elementSymbol.getMetadataID());
        fullyQualifiedNodeName = XMLPlanner.getQualifiedName(fullyQualifiedNodeName, planEnv);
        return fullyQualifiedNodeName;
    }

    static List getNameParts(String fullyQualifiedNodeName) {
        return StringUtil.split((String)fullyQualifiedNodeName, (String)DELIMITER);
    }

    static String getClosestResultSet(MappingNode node, String fullyQualifiedNodeName, boolean searchUp) throws QueryPlannerException {
        MappingNode parentResultSetNode;
        int direction = 2;
        if (!searchUp) {
            direction = 3;
        }
        if ((parentResultSetNode = MappingNode.findFirstNodeWithPropertyString((Integer)MappingNodeConstants.Properties.RESULT_SET_NAME, null, (MappingNode)node, (int)direction)) == null) {
            return null;
        }
        String rs = (String)parentResultSetNode.getProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
        if (rs != null) {
            rs = rs.toUpperCase();
        }
        return rs;
    }

    static String validateConjunct(Criteria conjunct, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)conjunct, (boolean)false);
        Iterator elemIter = elements.iterator();
        if (!elemIter.hasNext()) {
            return null;
        }
        ElementSymbol element = (ElementSymbol)elemIter.next();
        boolean isTempConjunct = XMLPlanner.isTempElement(element, metadata);
        if (elements.size() < 2) {
            if (isTempConjunct) {
                return XMLPlanner.getResultSet(element, metadata);
            }
            return null;
        }
        while (elemIter.hasNext()) {
            element = (ElementSymbol)elemIter.next();
            boolean hasTempElement = XMLPlanner.isTempElement(element, metadata);
            if (isTempConjunct == hasTempElement) continue;
            throw new QueryPlannerException("ERR.015.004.0035", QueryExecPlugin.Util.getString("ERR.015.004.0035", (Object)conjunct));
        }
        if (isTempConjunct) {
            return XMLPlanner.getResultSet(element, metadata);
        }
        return null;
    }

    static boolean isTempElement(ElementSymbol element, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        GroupSymbol group = element.getGroupSymbol();
        return !metadata.isXMLGroup(group.getMetadataID());
    }

    static String[] validatePredicateAndGetResultSets(PredicateCriteria predicate, MappingNode rootNode, XMLPlannerEnvironment planEnv) throws QueryPlannerException, MetaMatrixComponentException, QueryMetadataException {
        Collection invalidPredicates = PredicateFormValidatorVisitor.getInvalidPredicates((LanguageObject)predicate);
        if (invalidPredicates.size() > 0) {
            throw new QueryPlannerException(PredicateFormValidatorVisitor.getInvalidPredicateMessage((Collection)invalidPredicates));
        }
        String contextResultSet = null;
        Collection contextFunctions = ContextReplacerVisitor.replaceContextFunctions((LanguageObject)predicate);
        if (contextFunctions.size() > 1) {
            throw new QueryPlannerException("ERR.015.004.0068", QueryExecPlugin.Util.getString("ERR.015.004.0068", (Object)predicate));
        }
        Collection nestedContextFunctions = ContextReplacerVisitor.replaceContextFunctions((LanguageObject)predicate);
        if (nestedContextFunctions.size() > 0) {
            throw new QueryPlannerException("ERR.015.004.0069", QueryExecPlugin.Util.getString("ERR.015.004.0069"));
        }
        Iterator functions = contextFunctions.iterator();
        if (functions.hasNext()) {
            Function contextFunction = (Function)functions.next();
            Expression firstArg = contextFunction.getArg(0);
            if (!(firstArg instanceof ElementSymbol)) {
                throw new QueryPlannerException("ERR.015.004.0036", QueryExecPlugin.Util.getString("ERR.015.004.0036", new Object[]{firstArg, firstArg.getClass()}));
            }
            ElementSymbol targetContext = (ElementSymbol)firstArg;
            String fullElementName = planEnv.metadata.getFullName(targetContext.getMetadataID());
            String fullGroupName = planEnv.metadata.getFullName(targetContext.getGroupSymbol().getMetadataID());
            int indexElementPathBegins = fullGroupName.length() + 1;
            String fullElementPath = fullElementName.substring(indexElementPathBegins);
            fullElementPath = fullElementPath.substring(0, fullElementPath.lastIndexOf(DELIMITER) + 1);
            MappingNode contextNode = XMLPlanner.findContextMappingNode(fullElementPath = fullElementPath + targetContext.getShortName(), rootNode);
            if (contextNode == null) {
                throw new QueryPlannerException("ERR.015.004.0037", QueryExecPlugin.Util.getString("ERR.015.004.0037", (Object)targetContext));
            }
            contextResultSet = XMLPlanner.findContextResultSet(contextNode);
        }
        Criteria convertedCrit = XMLPlanner.convertCriteria((Criteria)predicate, rootNode, planEnv.metadata);
        String critResultSet = XMLPlanner.getResultSet((Criteria)predicate, convertedCrit, planEnv);
        String explicitContext = contextResultSet;
        if (contextResultSet == null) {
            contextResultSet = XMLPlanner.findImpliedContextResultSet(critResultSet, rootNode, planEnv);
        } else {
            XMLPlanner.validateResultSetsScope(contextResultSet, critResultSet, rootNode);
        }
        return new String[]{contextResultSet.toUpperCase(), critResultSet.toUpperCase(), explicitContext};
    }

    static void validateResultSetsScope(String contextResultSet, String critResultSet, MappingNode rootNode) throws QueryPlannerException {
        MappingNode critNode = MappingNode.findFirstNodeWithPropertyString((Integer)MappingNodeConstants.Properties.RESULT_SET_NAME, (String)critResultSet, (MappingNode)rootNode, (int)3);
        Assertion.isNotNull((Object)critNode);
        MappingNode contextNode = MappingNode.findFirstNodeWithPropertyString((Integer)MappingNodeConstants.Properties.RESULT_SET_NAME, (String)contextResultSet, (MappingNode)critNode, (int)2);
        if (contextNode == null) {
            throw new QueryPlannerException("ERR.015.004.0038", QueryExecPlugin.Util.getString("ERR.015.004.0038", new Object[]{critResultSet, contextResultSet}));
        }
    }

    static String findImpliedContextResultSet(String critResultSet, MappingNode rootNode, XMLPlannerEnvironment planEnv) throws QueryMetadataException, MetaMatrixComponentException, QueryPlannerException {
        String contextResultSet = critResultSet;
        if (XMLPlanner.isRelationshipResultSet(contextResultSet, planEnv)) {
            return contextResultSet;
        }
        MappingNode critResultSetNode = MappingNode.findFirstNodeWithPropertyString((Integer)MappingNodeConstants.Properties.RESULT_SET_NAME, (String)critResultSet, (MappingNode)rootNode, (int)3);
        HashSet bindingGroups = new HashSet();
        XMLPlanner.addBindingGroupsToSet(contextResultSet, bindingGroups, planEnv);
        MappingNode ancestorSourceNode = critResultSetNode;
        while (!bindingGroups.isEmpty()) {
            ancestorSourceNode = MappingNode.findFirstNodeWithPropertyString((Integer)MappingNodeConstants.Properties.RESULT_SET_NAME, null, (MappingNode)ancestorSourceNode.getParent(), (int)2);
            Assertion.isNotNull((Object)ancestorSourceNode);
            contextResultSet = (String)ancestorSourceNode.getProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
            if (XMLPlanner.isRelationshipResultSet(contextResultSet, planEnv)) {
                return contextResultSet;
            }
            bindingGroups.remove(contextResultSet);
            XMLPlanner.addBindingGroupsToSet(contextResultSet, bindingGroups, planEnv);
        }
        return contextResultSet;
    }

    private static boolean isRelationshipResultSet(String resultSetName, XMLPlannerEnvironment planEnv) {
        if (planEnv.relationships != null) {
            Iterator i = planEnv.relationships.iterator();
            while (i.hasNext()) {
                Relationship relationship = (Relationship)i.next();
                if (!relationship.mappingState.resultSet.equalsIgnoreCase(resultSetName) && !relationship.sourceState.resultSet.equalsIgnoreCase(resultSetName) && !relationship.targetState.resultSet.equalsIgnoreCase(resultSetName)) continue;
                return true;
            }
        }
        return false;
    }

    private static void addBindingGroupsToSet(String mappingClassResultSet, HashSet bindingGroups, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        QueryNode queryNode = XMLPlanner.getQueryNode(mappingClassResultSet, planEnv.metadata);
        List bindings = queryNode.getBindings();
        if (bindings != null) {
            Iterator iter = bindings.iterator();
            while (iter.hasNext()) {
                String binding = (String)iter.next();
                ElementSymbol bindingSymbol = QueryUtil.resolveBinding(binding, planEnv);
                bindingGroups.add(bindingSymbol.getGroupSymbol().getName());
            }
        }
    }

    static String findContextResultSet(MappingNode targetContextNode) throws QueryPlannerException {
        if (targetContextNode == null) {
            throw new QueryPlannerException("ERR.015.004.0067", QueryExecPlugin.Util.getString("ERR.015.004.0067"));
        }
        MappingNode sourceNode = targetContextNode;
        String contextResultSet = (String)targetContextNode.getProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
        while (contextResultSet == null) {
            if ((sourceNode = sourceNode.getParent()) == null) {
                String nodeName = (String)targetContextNode.getProperty(MappingNodeConstants.Properties.NAME);
                throw new QueryPlannerException("ERR.015.004.0042", QueryExecPlugin.Util.getString("ERR.015.004.0042", (Object)nodeName));
            }
            contextResultSet = (String)sourceNode.getProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
        }
        return contextResultSet;
    }

    static MappingNode findContextMappingNode(String context, MappingNode rootNode) {
        boolean isFullName = false;
        if (context.lastIndexOf(DELIMITER) >= 0) {
            isFullName = true;
        }
        return XMLPlanner.findContextMappingNode(context, isFullName, rootNode);
    }

    private static MappingNode findContextMappingNode(String context, boolean isFullName, MappingNode rootNode) {
        String nodeName;
        if (isFullName ? context.equalsIgnoreCase(rootNode.getQualifiedName()) : (nodeName = (String)rootNode.getProperty(MappingNodeConstants.Properties.NAME)) != null && nodeName.equalsIgnoreCase(context)) {
            return rootNode;
        }
        List children = rootNode.getChildren();
        if (children != null && children.size() > 0) {
            MappingNode match = null;
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                MappingNode child = (MappingNode)childIter.next();
                match = XMLPlanner.findContextMappingNode(context, isFullName, child);
                if (match == null) continue;
                return match;
            }
        }
        return null;
    }

    static Criteria sortUserContextCriteria(Collection criteriaResultSetNames, String contextResultSet, Criteria temp, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        if (criteriaResultSetNames.size() == 1 && criteriaResultSetNames.contains(contextResultSet)) {
            return temp;
        }
        HashMap symbolMap = new HashMap();
        try {
            XMLPlanner.prepareSymbolMap(symbolMap, (LanguageObject)temp, planEnv, contextResultSet);
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)e, "ERR.015.004.0043", QueryExecPlugin.Util.getString("ERR.015.004.0043", (Object)temp));
        }
        ExpressionMappingVisitor visitor = new ExpressionMappingVisitor(symbolMap);
        PreOrderNavigator.doVisit((LanguageObject)temp, (LanguageVisitor)visitor);
        Iterator i = criteriaResultSetNames.iterator();
        HashSet<String> seenResultSets = new HashSet<String>();
        block4: while (i.hasNext()) {
            String resultSet = ((String)i.next()).toUpperCase();
            if (seenResultSets.contains(resultSet)) continue;
            seenResultSets.add(resultSet);
            MappingNode currentNode = MappingNode.findFirstNodeWithPropertyString((Integer)MappingNodeConstants.Properties.RESULT_SET_NAME, (String)resultSet, (MappingNode)planEnv.rootNode, (int)3);
            LogManager.logTrace("XML_QUERY_PLANNER", new Object[]{"'context' usage; current rs mapping node ", currentNode});
            while (!resultSet.equalsIgnoreCase(contextResultSet)) {
                LogManager.logTrace("XML_QUERY_PLANNER", new Object[]{"'context' usage; building temp criteria loop, result Set", resultSet, "context result set", contextResultSet});
                try {
                    temp = XMLPlanner.addCriteriaToTemp(temp, resultSet, planEnv, contextResultSet);
                }
                catch (QueryResolverException e) {
                    throw new QueryPlannerException((Throwable)e, "ERR.015.004.0044", QueryExecPlugin.Util.getString("ERR.015.004.0044", (Object)e.getMessage()));
                }
                LogManager.logTrace("XML_QUERY_PLANNER", new Object[]{"'context' usage; temp Criteria ", temp});
                currentNode = MappingNode.findFirstNodeWithPropertyString((Integer)MappingNodeConstants.Properties.RESULT_SET_NAME, null, (MappingNode)currentNode.getParent(), (int)2);
                if (currentNode == null) {
                    throw new QueryPlannerException("ERR.015.004.0045", QueryExecPlugin.Util.getString("ERR.015.004.0045"));
                }
                LogManager.logTrace("XML_QUERY_PLANNER", new Object[]{"'context' usage; next rs mapping node ", currentNode});
                resultSet = ((String)currentNode.getProperty(MappingNodeConstants.Properties.RESULT_SET_NAME)).toUpperCase();
                if (seenResultSets.contains(resultSet)) continue block4;
                seenResultSets.add(resultSet);
            }
        }
        LogManager.logTrace("XML_QUERY_PLANNER", new Object[]{"'context' usage: mapping result set ", contextResultSet, " to ", temp});
        return temp;
    }

    private static Criteria addCriteriaToTemp(Criteria temp, String resultSet, XMLPlannerEnvironment planEnv, String contextResultSet) throws QueryResolverException, QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Criteria crit = null;
        Query query = (Query)planEnv.getAlternateMappingClassQuery(resultSet);
        if (query != null) {
            List crits = CompoundCriteria.separateCriteriaByAnd((Criteria)query.getCriteria());
            Iterator iter = crits.iterator();
            while (iter.hasNext()) {
                Criteria conjunct = (Criteria)iter.next();
                List refs = ReferenceCollectorVisitor.getReferences((LanguageObject)conjunct);
                if (refs.size() <= 0) continue;
                conjunct = (Criteria)conjunct.clone();
                HashMap<Reference, Expression> refMap = new HashMap<Reference, Expression>();
                Iterator refIter = refs.iterator();
                while (refIter.hasNext()) {
                    Reference ref = (Reference)refIter.next();
                    refMap.put(ref, ref.getExpression());
                }
                ExpressionMappingVisitor.mapExpressions((LanguageObject)conjunct, refMap);
                crit = CompoundCriteria.combineCriteria((Criteria)crit, (Criteria)conjunct);
            }
        } else {
            QueryNode planNode = XMLPlanner.getQueryNode(resultSet, planEnv.metadata);
            query = (Query)QueryUtil.parseQuery(planNode, planEnv);
            crit = query.getCriteria();
            query.setCriteria(null);
            QueryUtil.resolveQuery((Command)query, planEnv);
            Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)query, (boolean)false);
            if (planNode.getBindings() != null) {
                groups.addAll(XMLPlanner.handleBindings(crit, planNode, planEnv, contextResultSet));
            }
            QueryUtil.resolveCriteria(crit, groups, planEnv);
        }
        return Criteria.combineCriteria((Criteria)temp, (Criteria)crit);
    }

    private static Collection handleBindings(Criteria crit, QueryNode planNode, XMLPlannerEnvironment planEnv, String contextResultSet) throws QueryResolverException, QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        HashMap symbolMap = new HashMap();
        ArrayList<GroupSymbol> groups = new ArrayList<GroupSymbol>();
        List bindingsCol = planNode.getBindings();
        Iterator bindings = bindingsCol.iterator();
        ArrayList<ElementSymbol> parsedBindings = new ArrayList<ElementSymbol>(bindingsCol.size());
        while (bindings.hasNext()) {
            ElementSymbol binding = QueryUtil.resolveBinding((String)bindings.next(), planEnv);
            groups.addAll(XMLPlanner.prepareSymbolMap(symbolMap, (LanguageObject)binding, planEnv, contextResultSet));
            groups.add(binding.getGroupSymbol());
            parsedBindings.add(binding);
        }
        ReferenceBindingReplacerVisitor.replaceReferences((LanguageObject)crit, parsedBindings);
        ExpressionMappingVisitor visitor = new ExpressionMappingVisitor(symbolMap);
        PreOrderNavigator.doVisit((LanguageObject)crit, (LanguageVisitor)visitor);
        return groups;
    }

    static Collection prepareSymbolMap(Map symbolMap, LanguageObject langObj, XMLPlannerEnvironment planEnv, String contextResultSet) throws QueryResolverException, QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        ResolveElementsVisitor.resolveElements((LanguageObject)langObj, (QueryMetadataInterface)planEnv.metadata);
        Iterator elements = ElementCollectorVisitor.getElements((LanguageObject)langObj, (boolean)false).iterator();
        ArrayList groups = new ArrayList();
        while (elements.hasNext()) {
            ElementSymbol element = (ElementSymbol)elements.next();
            GroupSymbol groupSymbol = element.getGroupSymbol();
            if (groupSymbol.getName().equalsIgnoreCase(contextResultSet)) continue;
            Query query = (Query)planEnv.getAlternateMappingClassQuery(groupSymbol.getCanonicalName());
            if (query == null) {
                QueryNode queryNode = XMLPlanner.getQueryNode(groupSymbol, planEnv.metadata);
                query = (Query)QueryUtil.parseQuery(queryNode, planEnv);
                query.setCriteria(null);
                QueryUtil.resolveQuery((Command)query, planEnv);
            }
            Iterator i = query.getProjectedSymbols().iterator();
            while (i.hasNext()) {
                SingleElementSymbol symbol = (SingleElementSymbol)i.next();
                if (!symbol.getShortName().equalsIgnoreCase(element.getShortName())) continue;
                if (symbol instanceof AliasSymbol) {
                    symbol = ((AliasSymbol)symbol).getSymbol();
                }
                if (symbol instanceof ExpressionSymbol) {
                    Expression exp = ((ExpressionSymbol)symbol).getExpression();
                    symbolMap.put(element, exp);
                } else {
                    symbolMap.put(element, symbol);
                }
                groups.addAll(GroupsUsedByElementsVisitor.getGroups((LanguageObject)symbol));
            }
        }
        return groups;
    }

    static Criteria convertCriteria(Criteria simpleCrit, MappingNode rootNode, QueryMetadataInterface metadata) throws QueryPlannerException {
        Criteria copyCrit = (Criteria)simpleCrit.clone();
        XMLNodeMappingVisitor mappingVisitor = new XMLNodeMappingVisitor(rootNode, metadata);
        PreOrderNavigator.doVisit((LanguageObject)copyCrit, (LanguageVisitor)mappingVisitor);
        List unmappedSymbols = mappingVisitor.getUnmappedSymbols();
        if (unmappedSymbols != null && unmappedSymbols.size() > 0) {
            throw new QueryPlannerException("ERR.015.004.0046", QueryExecPlugin.Util.getString("ERR.015.004.0046", new Object[]{unmappedSymbols, simpleCrit}));
        }
        return copyCrit;
    }

    private static String getResultSet(Criteria simpleCrit, Criteria convertedCrit, XMLPlannerEnvironment planEnv) throws QueryPlannerException, MetaMatrixComponentException, QueryMetadataException {
        String resultSet = null;
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)convertedCrit, (boolean)true);
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            ElementSymbol element = (ElementSymbol)iter.next();
            String groupName = XMLPlanner.getResultSet(element, planEnv.getGlobalMetadata());
            if (resultSet == null) {
                resultSet = groupName;
                continue;
            }
            if (resultSet.equalsIgnoreCase(groupName)) continue;
            throw new QueryPlannerException("ERR.015.004.0047", QueryExecPlugin.Util.getString("ERR.015.004.0047", (Object)simpleCrit));
        }
        if (resultSet == null) {
            throw new QueryPlannerException("ERR.015.004.0048", QueryExecPlugin.Util.getString("ERR.015.004.0048", (Object)simpleCrit));
        }
        return resultSet;
    }

    private static String getResultSet(ElementSymbol element, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException {
        if (element.getGroupSymbol() != null) {
            return metadata.getFullName(element.getGroupSymbol().getMetadataID());
        }
        String elementName = element.getName();
        int index = elementName.lastIndexOf(DELIMITER);
        return elementName.substring(0, index);
    }

    static Query constructResultSetQuery(String rsName, boolean isTempGroup, Map rsCrits, OrderBy orderBy, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        GroupSymbol symbol;
        Command alternateCommand;
        String rsKey = rsName.toUpperCase();
        Command underlyingQuery = alternateCommand = planEnv.getAlternateMappingClassQuery(rsKey);
        GroupSymbol groupSymbol = null;
        Query rsQuery = null;
        String subquery_group_name = null;
        if (isTempGroup) {
            groupSymbol = new GroupSymbol(rsName);
            planEnv.stagingTableGroupSymbols.add(groupSymbol);
            if (alternateCommand == null) {
                QueryNode node = XMLPlanner.getQueryNode(rsName, planEnv.metadata);
                Command command = QueryUtil.parseQuery(node, planEnv);
                List bindings = node.getBindings();
                if (bindings != null) {
                    try {
                        BindVariableVisitor.bindReferences((LanguageObject)command, (List)bindings, (QueryMetadataInterface)planEnv.metadata, (Map)planEnv.getBoundReferenceMap());
                    }
                    catch (QueryResolverException e) {
                        throw new QueryPlannerException((Throwable)e, "ERR.015.004.0051", QueryExecPlugin.Util.getString("ERR.015.004.0051", new Object[]{rsName, e.getMessage()}));
                    }
                }
                underlyingQuery = command;
                Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)true);
                int i = 0;
                subquery_group_name = STAGING_TABLE_SUBQUERY_GROUP_NAME;
                symbol = new GroupSymbol(subquery_group_name);
                while (groups.contains(symbol)) {
                    subquery_group_name = STAGING_TABLE_SUBQUERY_GROUP_NAME + i;
                    ++i;
                    symbol = new GroupSymbol(subquery_group_name);
                }
                rsQuery = XMLPlanner.wrapQuery((FromClause)new SubqueryFromClause(subquery_group_name, command));
            } else {
                rsQuery = (Query)alternateCommand;
                XMLPlanner.adjustFromClauseIfNecessary(rsQuery, rsQuery.getCriteria());
            }
        } else if (alternateCommand != null) {
            rsQuery = (Query)alternateCommand;
        } else {
            groupSymbol = new GroupSymbol(rsName);
            rsQuery = XMLPlanner.wrapQuery((FromClause)new UnaryFromClause(groupSymbol));
            underlyingQuery = rsQuery;
            rsQuery.setOrderBy(orderBy);
        }
        HashMap queryMetadata = new HashMap();
        queryMetadata.putAll(planEnv.globalTempMetadata);
        if (rsQuery.getTemporaryMetadata() != null) {
            queryMetadata.putAll(rsQuery.getTemporaryMetadata());
        }
        rsQuery.setTemporaryMetadata(queryMetadata);
        Criteria crit = (Criteria)rsCrits.get(rsKey);
        if (crit != null) {
            if (isTempGroup) {
                HashMap<GroupSymbol, ElementSymbol> symbolMap = new HashMap<GroupSymbol, ElementSymbol>();
                if (subquery_group_name != null) {
                    Collection elements = ElementCollectorVisitor.getElements((LanguageObject)crit, (boolean)true);
                    Iterator i = elements.iterator();
                    while (i.hasNext()) {
                        symbol = (ElementSymbol)i.next();
                        ElementSymbol mappedSymbol = new ElementSymbol(subquery_group_name + DELIMITER + symbol.getShortName());
                        symbolMap.put(symbol, mappedSymbol);
                    }
                } else {
                    try {
                        String BOGUS_CONTEXT_RESULT_SET = null;
                        XMLPlanner.prepareSymbolMap(symbolMap, (LanguageObject)crit, planEnv, BOGUS_CONTEXT_RESULT_SET);
                    }
                    catch (QueryResolverException e) {
                        throw new QueryPlannerException((Throwable)e, "ERR.015.004.0053", QueryExecPlugin.Util.getString("ERR.015.004.0053", new Object[]{rsName, crit}));
                    }
                }
                ExpressionMappingVisitor visitor = new ExpressionMappingVisitor(symbolMap);
                PreOrderNavigator.doVisit((LanguageObject)crit, (LanguageVisitor)visitor);
            } else {
                XMLPlanner.adjustFromClauseIfNecessary(rsQuery, crit);
            }
            rsQuery.setCriteria(Criteria.combineCriteria((Criteria)crit, (Criteria)rsQuery.getCriteria()));
        }
        rsQuery.getSubCommands().clear();
        QueryUtil.resolveQuery((Command)rsQuery, planEnv);
        QueryUtil.rewriteQuery((Command)rsQuery, planEnv);
        XMLPlanner.setInMemoryFlag(rsKey, underlyingQuery, planEnv);
        return rsQuery;
    }

    private static Query wrapQuery(FromClause fromClause) {
        Select select = new Select();
        select.addSymbol((SelectSymbol)new AllSymbol());
        Query query = new Query();
        query.setSelect(select);
        From from = new From();
        from.addClause(fromClause);
        query.setFrom(from);
        return query;
    }

    private static void setInMemoryFlag(String rsKey, Command tempQuery, XMLPlannerEnvironment planEnv) throws QueryPlannerException {
        boolean inMemoryOnly = true;
        Collection groups = GroupCollectorVisitor.getGroupsIgnoreInlineViews((LanguageObject)tempQuery, (boolean)true);
        Iterator groupsIter = groups.iterator();
        while (groupsIter.hasNext()) {
            GroupSymbol fromGroup = (GroupSymbol)groupsIter.next();
            if (planEnv.stagingTableGroupSymbols.contains(fromGroup)) continue;
            inMemoryOnly = false;
            break;
        }
        if (!inMemoryOnly) {
            boolean foundPhysical = false;
            Iterator iter = groups.iterator();
            while (iter.hasNext()) {
                GroupSymbol group = (GroupSymbol)iter.next();
                QueryMetadataInterface metadata = planEnv.getGlobalMetadata();
                try {
                    if (metadata.isVirtualGroup(group.getMetadataID())) continue;
                    foundPhysical = true;
                    break;
                }
                catch (Exception e) {
                }
            }
            if (!foundPhysical) {
                inMemoryOnly = true;
            }
        }
        if (inMemoryOnly) {
            planEnv.setSelectingFromInMemoryOnly(rsKey);
        }
    }

    static ProcessorPlan planResultSet(String rsName, Query query, boolean isTempGroup, String recursionRootMappingClass, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        GroupSymbol groupSymbol = null;
        if (isTempGroup) {
            groupSymbol = new GroupSymbol(rsName);
        } else {
            Iterator groups = query.getFrom().getGroups().iterator();
            while (groups.hasNext()) {
                GroupSymbol aGroupSymbol = (GroupSymbol)groups.next();
                if (!aGroupSymbol.getName().equalsIgnoreCase(rsName)) continue;
                groupSymbol = aGroupSymbol;
                break;
            }
            if (groupSymbol != null) {
                Select select = query.getSelect();
                select.clearSymbols();
                List elements = null;
                try {
                    QueryMetadataInterface metadata = planEnv.metadata;
                    if (query.getTemporaryMetadata() != null) {
                        TempMetadataStore store = new TempMetadataStore(query.getTemporaryMetadata());
                        metadata = new TempMetadataAdapter(planEnv.metadata, store);
                    }
                    elements = ResolverUtil.resolveElementsInGroup(groupSymbol, metadata);
                }
                catch (QueryResolverException e) {
                    throw new QueryPlannerException((Throwable)e, e.getMessage());
                }
                Iterator i = elements.iterator();
                while (i.hasNext()) {
                    ElementSymbol element = (ElementSymbol)i.next();
                    if (!planEnv.mappingClassAttributesNeeded.contains(element.getName().toUpperCase())) continue;
                    select.addSymbol((SelectSymbol)element);
                }
            }
        }
        ProcessorPlan plan = null;
        plan = QueryOptimizer.optimizePlan((Command)query, (QueryMetadataInterface)planEnv.metadata, (IDGenerator)planEnv.idGenerator, (CapabilitiesFinder)planEnv.capFinder, (AnalysisRecord)planEnv.analysisRecord, (CommandContext)planEnv.context);
        if (isTempGroup) {
            RelationalPlan relationalPlan = (RelationalPlan)plan;
            ArrayList<ElementSymbol> tempColumns = new ArrayList<ElementSymbol>();
            List projectedColumns = query.getProjectedSymbols();
            Iterator projIter = projectedColumns.iterator();
            while (projIter.hasNext()) {
                SingleElementSymbol symbol = (SingleElementSymbol)projIter.next();
                String shortName = symbol.getShortName();
                String fullName = rsName + DELIMITER + shortName;
                ElementSymbol element = new ElementSymbol(fullName);
                element.setGroupSymbol(groupSymbol);
                element.setType(symbol.getType());
                tempColumns.add(element);
            }
            relationalPlan.setOutputElements(tempColumns);
        }
        return plan;
    }

    private static void buildReferencesMap(XMLPlannerEnvironment planEnv, Command query, String rsName, String recursionRootMappingClass) {
        Iterator refs = ReferenceCollectorVisitor.getReferences((LanguageObject)query).iterator();
        while (refs.hasNext()) {
            Reference ref = (Reference)refs.next();
            Expression expr = ref.getExpression();
            if (!(expr instanceof ElementSymbol)) continue;
            ElementSymbol elem = (ElementSymbol)expr;
            String groupName = elem.getGroupSymbol().getName();
            String groupKey = groupName.toUpperCase();
            ArrayList<Reference> boundList = planEnv.getBoundReferences(groupKey);
            if (boundList == null) {
                boundList = new ArrayList<Reference>();
                planEnv.setBoundReferences(groupKey, boundList);
            }
            boundList.add(ref);
            planEnv.mappingClassAttributesNeeded.add(elem.getName().toUpperCase());
            if (recursionRootMappingClass == null) continue;
            recursionRootMappingClass = recursionRootMappingClass.toUpperCase();
            String recursiveMappingClass = rsName.toUpperCase();
            Iterator i = planEnv.mappingClassAttributesNeeded.iterator();
            ArrayList<String> temp = new ArrayList<String>();
            while (i.hasNext()) {
                String mappingColumn = (String)i.next();
                if (!mappingColumn.startsWith(recursionRootMappingClass)) continue;
                int shortNameIndex = mappingColumn.lastIndexOf(DELIMITER);
                String columnShortName = mappingColumn.substring(shortNameIndex);
                String newColumn = recursiveMappingClass + columnShortName;
                temp.add(newColumn);
            }
            planEnv.mappingClassAttributesNeeded.addAll(temp);
        }
        Iterator commandsIter = query.getSubCommands().iterator();
        while (commandsIter.hasNext()) {
            Command command = (Command)commandsIter.next();
            XMLPlanner.buildReferencesMap(planEnv, command, rsName, recursionRootMappingClass);
        }
    }

    static void adjustFromClauseIfNecessary(Query query, Criteria crit) {
        boolean REMOVE_DUPLICATES = true;
        Collection queryGroups = GroupCollectorVisitor.getGroups((LanguageObject)query, (boolean)true);
        HashSet critGroups = new HashSet();
        GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit, critGroups);
        if (critGroups.size() > 0 && critGroups.iterator().next() == null) {
            return;
        }
        if (!queryGroups.containsAll(critGroups)) {
            LogManager.logTrace("XML_QUERY_PLANNER", "adjusting From clause for 'context' usage: Query " + query + ", Criteria " + crit);
            critGroups.removeAll(queryGroups);
            Select select = query.getSelect();
            select.setDistinct(true);
            From from = query.getFrom();
            from.addGroups(critGroups);
            LogManager.logTrace("XML_QUERY_PLANNER", "finished adjusting From clause for 'context' usage: Query " + query + ", Criteria " + crit);
        }
    }

    private static Map getOrderByRS(OrderBy orderBy, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        HashMap<String, OrderBy> orderByWithRS = new HashMap<String, OrderBy>();
        MappingNode rootNode = planEnv.rootNode;
        List elements = orderBy.getVariables();
        List types = orderBy.getTypes();
        for (int i = 0; i < elements.size(); ++i) {
            OrderBy mappedOrderBy = null;
            List<ElementSymbol> mappedElems = null;
            List mappedTypes = null;
            ElementSymbol elemSymbol = (ElementSymbol)elements.get(i);
            String elementName = elemSymbol.getName();
            MappingNode elementNode = null;
            String rsName = null;
            String qualifiedName = XMLPlanner.getQualifiedName(elementName, planEnv);
            elementNode = MappingNode.findNode((MappingNode)rootNode, (List)XMLPlanner.getNameParts(qualifiedName.toUpperCase()));
            String mappedName = (String)elementNode.getProperty(MappingNodeConstants.Properties.ELEMENT_NAME);
            if (mappedName == null) {
                Object[] params = new Object[]{elementNode, orderBy};
                String msg = QueryExecPlugin.Util.getString("XMLPlanner.The_XML_document_element_{0}_is_not_mapped_to_data_and_cannot_be_used_in_the_ORDER_BY_clause__{1}_1", params);
                throw new QueryPlannerException(msg);
            }
            rsName = XMLPlanner.findContextResultSet(elementNode);
            planEnv.mappingClassAttributesNeeded.add(mappedName.toUpperCase());
            if (orderByWithRS.containsKey(rsName.toUpperCase())) {
                OrderBy currMappedOrderBy = (OrderBy)orderByWithRS.get(rsName.toUpperCase());
                mappedElems = currMappedOrderBy.getVariables();
                mappedTypes = currMappedOrderBy.getTypes();
            } else {
                mappedElems = new ArrayList();
                mappedTypes = new ArrayList();
            }
            mappedElems.add(new ElementSymbol(mappedName));
            mappedTypes.add(types.get(i));
            mappedOrderBy = new OrderBy(mappedElems, mappedTypes);
            orderByWithRS.put(rsName.toUpperCase(), mappedOrderBy);
        }
        return orderByWithRS;
    }

    static void markTree(MappingNode node, Integer property) {
        List children = node.getChildren();
        if (children != null) {
            MappingNode child;
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                child = (MappingNode)childIter.next();
                if (((Boolean)child.getProperty(MappingNodeConstants.Properties.IS_INCLUDED)).booleanValue() || ((Boolean)child.getProperty(MappingNodeConstants.Properties.IS_EXCLUDED)).booleanValue()) continue;
                child.setProperty(property, (Object)Boolean.TRUE);
            }
            childIter = children.iterator();
            while (childIter.hasNext()) {
                child = (MappingNode)childIter.next();
                XMLPlanner.markTree(child, property);
            }
        }
    }

    static String getQualifiedName(String element, XMLPlannerEnvironment planEnv) {
        String group = planEnv.documentGroup.getName();
        return element.substring(group.length() + 1);
    }

    private static void addTag(Program program, String name, MappingNode node, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        String nodeType = (String)node.getProperty(MappingNodeConstants.Properties.NODE_TYPE);
        Object tagInst = null;
        if (nodeType.equals("comment")) {
            String commentText = (String)node.getProperty(MappingNodeConstants.Properties.COMMENT_TEXT);
            tagInst = new AddCommentInstruction(commentText);
            program.addInstruction((ProcessorInstruction)tagInst);
        } else {
            String symbolName;
            String textNormalizationMode;
            boolean isElement = nodeType.equals("element");
            if (!isElement) {
                Assertion.isEqual((Object)nodeType, (Object)"attribute");
            }
            if ((textNormalizationMode = (String)node.getProperty(MappingNodeConstants.Properties.NORMALIZE_TEXT)) == null) {
                textNormalizationMode = "preserve";
            }
            String namespacePrefix = (String)node.getProperty(MappingNodeConstants.Properties.NAMESPACE_PREFIX);
            String defaultValue = (String)node.getProperty(MappingNodeConstants.Properties.DEFAULT_VALUE);
            String fixedValue = (String)node.getProperty(MappingNodeConstants.Properties.FIXED_VALUE);
            Properties namespaceDeclarations = (Properties)node.getProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS);
            boolean isNillable = (Boolean)node.getProperty(MappingNodeConstants.Properties.IS_NILLABLE);
            boolean isOptional = false;
            int minOccurs = (Integer)node.getProperty(MappingNodeConstants.Properties.CARDINALITY_MIN_BOUND);
            if (isElement && minOccurs == 0 && !isNillable) {
                isOptional = true;
            }
            if ((symbolName = (String)node.getProperty(MappingNodeConstants.Properties.ELEMENT_NAME)) != null) {
                ElementSymbol symbol = XMLPlanner.resolveElementSymbol(symbolName, planEnv.getGlobalMetadata());
                GroupSymbol group = symbol.getGroupSymbol();
                String resultSetName = group.getName().toUpperCase();
                int position = -1;
                Command rsQuery = planEnv.getQuery(resultSetName);
                List rsProjSymbols = rsQuery.getProjectedSymbols();
                for (int i = 0; i < rsProjSymbols.size(); ++i) {
                    SingleElementSymbol projSymbol = (SingleElementSymbol)rsProjSymbols.get(i);
                    if (!projSymbol.getShortName().equalsIgnoreCase(symbol.getShortName())) continue;
                    position = i;
                    break;
                }
                Class runtimeType = symbol.getType();
                String docBuiltInType = (String)node.getProperty(MappingNodeConstants.Properties.BUILT_IN_TYPE);
                if (docBuiltInType == "") {
                    docBuiltInType = null;
                }
                NodeDescriptor descriptor = XMLPlanner.createNodeDescriptor(name, namespacePrefix, isElement, defaultValue, namespaceDeclarations, null, isOptional, node, textNormalizationMode, runtimeType, docBuiltInType);
                tagInst = new AddNodeInstruction(descriptor, resultSetName, position);
            } else {
                if (!isElement && Boolean.TRUE.equals(node.getProperty(MappingNodeConstants.Properties.IS_OPTIONAL))) {
                    isOptional = true;
                }
                NodeDescriptor descriptor = XMLPlanner.createNodeDescriptor(name, namespacePrefix, isElement, fixedValue, namespaceDeclarations, null, isOptional, node, textNormalizationMode);
                tagInst = new AddNodeInstruction(descriptor);
            }
            program.addInstruction((ProcessorInstruction)tagInst);
            if (isNillable) {
                NodeDescriptor nillDescriptor = XMLPlanner.createNodeDescriptor("nil", MappingNodeConstants.INSTANCES_NAMESPACE_PREFIX, false, "true", null, namespaceDeclarations, false, node, "preserve");
                ((AddNodeInstruction)((Object)tagInst)).setNillableDescriptor(nillDescriptor);
            }
        }
    }

    private static ElementSymbol resolveElementSymbol(String elementName, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Object elementID = metadata.getElementID(elementName);
        ElementSymbol symbol = new ElementSymbol(elementName);
        symbol.setMetadataID(elementID);
        Object groupID = metadata.getGroupIDForElementID(elementID);
        String groupName = metadata.getFullName(groupID);
        GroupSymbol groupSymbol = new GroupSymbol(groupName);
        groupSymbol.setMetadataID(groupID);
        symbol.setGroupSymbol(groupSymbol);
        symbol.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(symbol.getMetadataID())));
        return symbol;
    }

    private static boolean isChoiceNode(MappingNode node) {
        Boolean exceptionOnDefault = (Boolean)node.getProperty(MappingNodeConstants.Properties.EXCEPTION_ON_DEFAULT);
        if (exceptionOnDefault.booleanValue()) {
            return true;
        }
        Iterator i = node.getChildren().iterator();
        while (i.hasNext()) {
            MappingNode child = (MappingNode)i.next();
            if (child.getProperty(MappingNodeConstants.Properties.CRITERIA) != null) {
                return true;
            }
            if (!((Boolean)child.getProperty(MappingNodeConstants.Properties.IS_DEFAULT_CHOICE)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static void planChoiceNode(Program program, MappingNode node, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        IfInstruction ifInst = new IfInstruction();
        if (((Boolean)node.getProperty(MappingNodeConstants.Properties.EXCEPTION_ON_DEFAULT)).booleanValue()) {
            Program subProgram = new Program();
            subProgram.addInstruction((ProcessorInstruction)new AbortProcessingInstruction());
            DefaultCondition defCondition = new DefaultCondition(subProgram);
            ifInst.setDefaultCondition(defCondition);
        }
        Iterator i = node.getChildren().iterator();
        while (i.hasNext()) {
            MappingNode child = (MappingNode)i.next();
            Boolean isDefault = (Boolean)child.getProperty(MappingNodeConstants.Properties.IS_DEFAULT_CHOICE);
            String criteriaString = (String)child.getProperty(MappingNodeConstants.Properties.CRITERIA);
            boolean isRoot = false;
            if (criteriaString == null && !isDefault.booleanValue()) continue;
            Program subProgram = new Program();
            Boolean isExcluded = (Boolean)child.getProperty(MappingNodeConstants.Properties.IS_EXCLUDED);
            if (criteriaString != null) {
                Criteria criteria = QueryUtil.resolveCriteria(criteriaString, planEnv);
                Collection criteriaGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)criteria);
                List rsNames = XMLPlanner.getResultSetNames(criteriaGroups);
                CriteriaCondition condition = new CriteriaCondition(criteria, rsNames, subProgram);
                ifInst.addCondition(condition);
            }
            if (isDefault.booleanValue()) {
                DefaultCondition defCondition = new DefaultCondition(subProgram);
                ifInst.setDefaultCondition(defCondition);
            }
            if (Boolean.TRUE.equals(isExcluded)) continue;
            XMLPlanner.planNode(subProgram, child, isRoot, planEnv);
        }
        program.addInstruction((ProcessorInstruction)ifInst);
    }

    private static RecurseProgramCondition getRecurseCondition(Program subProgram, XMLPlannerEnvironment planEnv, MappingNode node) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        String criteriaString = (String)node.getProperty(MappingNodeConstants.Properties.RECURSION_CRITERIA);
        Integer recursionLimit = (Integer)node.getProperty(MappingNodeConstants.Properties.RECURSION_LIMIT);
        Boolean exceptionOnLimit = (Boolean)node.getProperty(MappingNodeConstants.Properties.EXCEPTION_ON_RECURSION_LIMIT);
        RecurseProgramCondition condition = null;
        if (criteriaString == null || criteriaString.trim().length() == 0) {
            condition = recursionLimit == null ? new RecurseProgramCondition(subProgram, Collections.EMPTY_LIST, null) : new RecurseProgramCondition(subProgram, Collections.EMPTY_LIST, null, recursionLimit, exceptionOnLimit);
        } else {
            Criteria criteria = null;
            criteria = QueryUtil.resolveCriteria(criteriaString, planEnv);
            Collection groups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)criteria);
            List rsNames = XMLPlanner.getResultSetNames(groups);
            condition = recursionLimit == null ? new RecurseProgramCondition(subProgram, rsNames, criteria) : new RecurseProgramCondition(subProgram, rsNames, criteria, recursionLimit, exceptionOnLimit);
        }
        return condition;
    }

    private static OrderBy getFullyNamedOrderBy(OrderBy orderBy, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        ArrayList<ElementSymbol> fullNameElemList = new ArrayList<ElementSymbol>();
        List types = orderBy.getTypes();
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)orderBy, (boolean)false);
        Iterator elemIter = elements.iterator();
        while (elemIter.hasNext()) {
            ElementSymbol elemSymbol = (ElementSymbol)elemIter.next();
            String fullElemName = metadata.getFullName(elemSymbol.getMetadataID());
            ElementSymbol elem = new ElementSymbol(fullElemName);
            fullNameElemList.add(elem);
        }
        return new OrderBy(fullNameElemList, types);
    }

    private static List getFullyResolvedSelect(List originalSymbols, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        QueryMetadataInterface metadata = planEnv.getGlobalMetadata();
        ArrayList<Object> fullyResolvedSymbols = new ArrayList<Object>();
        for (int i = 0; i < originalSymbols.size(); ++i) {
            SelectSymbol currentSymbol = (SelectSymbol)originalSymbols.get(i);
            String fullElemName = null;
            Function function = null;
            if (currentSymbol instanceof AllInGroupSymbol) {
                String symbolName = currentSymbol.getName();
                int index = symbolName.indexOf("*");
                String elementPart = symbolName.substring(0, index - 1);
                GroupSymbol group = planEnv.documentGroup;
                List elementIDs = metadata.getElementIDsInGroupID(metadata.getGroupID(group.getName()));
                Iterator it = elementIDs.iterator();
                Object elementID = null;
                while (it.hasNext()) {
                    elementID = it.next();
                    String elementIDName = metadata.getFullName(elementID);
                    if (!elementIDName.toUpperCase().endsWith(elementPart.toUpperCase())) continue;
                    fullElemName = elementIDName;
                    break;
                }
                if (fullElemName == null) {
                    throw new QueryMetadataException("ERR.015.004.0064", QueryExecPlugin.Util.getString("ERR.015.004.0064", new Object[]{elementPart}));
                }
                AllInGroupSymbol modifiedSymbol = new AllInGroupSymbol(fullElemName + ".*");
                fullyResolvedSymbols.add(modifiedSymbol);
                continue;
            }
            if (currentSymbol instanceof ElementSymbol) {
                fullyResolvedSymbols.add(XMLPlanner.getFullyResolvedElementSymbol((ElementSymbol)currentSymbol, metadata));
                continue;
            }
            function = RelatePlanner.getRelateSourceOrRelateTargetFunction((SelectSymbol)currentSymbol);
            if (function == null) continue;
            ElementSymbol element = (ElementSymbol)function.getArg(0);
            function.getArgs()[0] = XMLPlanner.getFullyResolvedElementSymbol(element, metadata);
            fullyResolvedSymbols.add(currentSymbol);
        }
        return fullyResolvedSymbols;
    }

    private static ElementSymbol getFullyResolvedElementSymbol(ElementSymbol element, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        String fullElemName = metadata.getFullName(element.getMetadataID());
        ElementSymbol modifiedSymbol = new ElementSymbol(fullElemName);
        return modifiedSymbol;
    }

    private static List getResultSetNames(Collection groups) {
        ArrayList<String> names = new ArrayList<String>(groups.size());
        Iterator iter = groups.iterator();
        while (iter.hasNext()) {
            names.add(((GroupSymbol)iter.next()).getName().toUpperCase());
        }
        return names;
    }

    public static NodeDescriptor createNodeDescriptor(String name, String namespacePrefix, boolean isElement, String defaultValue, Properties namespaceDeclarations, Properties parentNamespaceDeclarations, boolean isOptional, MappingNode node, String textNormalizationMode) throws MetaMatrixComponentException {
        return XMLPlanner.createNodeDescriptor(name, namespacePrefix, isElement, defaultValue, namespaceDeclarations, parentNamespaceDeclarations, isOptional, node, textNormalizationMode, null, null);
    }

    public static NodeDescriptor createNodeDescriptor(String name, String namespacePrefix, boolean isElement, String defaultValue, Properties namespaceDeclarations, Properties parentNamespaceDeclarations, boolean isOptional, MappingNode node, String textNormalizationMode, Class runtimeType, String docBuiltInType) throws MetaMatrixComponentException {
        String uri = null;
        if (namespacePrefix == null) {
            namespacePrefix = "";
        } else {
            if (namespaceDeclarations != null) {
                uri = namespaceDeclarations.getProperty(namespacePrefix);
            }
            if (parentNamespaceDeclarations != null) {
                uri = parentNamespaceDeclarations.getProperty(namespacePrefix);
            }
            if (uri == null) {
                MappingNode parent;
                while ((parent = node.getParent()) != null && ((parentNamespaceDeclarations = (Properties)parent.getProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS)) == null || (uri = parentNamespaceDeclarations.getProperty(namespacePrefix)) == null)) {
                    node = parent;
                }
            }
        }
        if (uri == null) {
            if (namespacePrefix.equals("")) {
                uri = "";
            } else if (namespacePrefix.equals(MappingNodeConstants.INSTANCES_NAMESPACE_PREFIX)) {
                uri = MappingNodeConstants.INSTANCES_NAMESPACE;
            } else {
                String msg = QueryExecPlugin.Util.getString("XMLPlanner.no_uri", new Object[]{namespacePrefix, name});
                throw new MetaMatrixComponentException(msg);
            }
        }
        NodeDescriptor descriptor = new NodeDescriptor(name, XMLPlanner.getQName(name, namespacePrefix), namespacePrefix, uri, namespaceDeclarations, defaultValue, isOptional, isElement, textNormalizationMode, runtimeType, docBuiltInType);
        return descriptor;
    }

    private static String getQName(String name, String prefix) {
        if (prefix != null && prefix.length() > 0) {
            name = prefix + ":" + name;
        }
        return name;
    }
}

