/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.sql.symbol.Expression;
import java.util.List;
import java.util.Map;

public class OffsetNode
extends RelationalNode {
    private final Expression offsetExpr;
    private int offset;
    private int rowCounter;
    private int tuplesProduced = 0;

    public OffsetNode(int nodeID, Expression offset) {
        super(nodeID);
        this.offsetExpr = offset;
    }

    protected TupleBatch nextBatchDirect() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        TupleBatch batch = null;
        int rowsToSkip = 0;
        if (this.rowCounter < this.offset) {
            do {
                int totalCount;
                if ((totalCount = this.rowCounter + (batch = this.getChildren()[0].nextBatch()).getRowCount()) < this.offset) {
                    this.rowCounter = totalCount;
                    rowsToSkip = batch.getRowCount();
                    continue;
                }
                if (totalCount == this.offset) {
                    this.rowCounter = this.offset;
                    if (!batch.getTerminationFlag()) {
                        rowsToSkip = 0;
                        batch = this.getChildren()[0].nextBatch();
                        continue;
                    }
                    rowsToSkip = batch.getRowCount();
                    continue;
                }
                this.rowCounter = this.offset;
                int rowsToKeep = totalCount - this.offset;
                rowsToSkip = batch.getRowCount() - rowsToKeep;
            } while (this.rowCounter < this.offset && !batch.getTerminationFlag());
        } else {
            batch = this.getChildren()[0].nextBatch();
        }
        List[] tuples = null;
        if (rowsToSkip > 0) {
            List[] originalTuples = batch.getAllTuples();
            tuples = new List[batch.getRowCount() - rowsToSkip];
            System.arraycopy(originalTuples, rowsToSkip, tuples, 0, tuples.length);
        } else {
            tuples = batch.getAllTuples();
        }
        TupleBatch newBatch = new TupleBatch(this.tuplesProduced + 1, tuples);
        newBatch.setTerminationFlag(batch.getTerminationFlag());
        this.tuplesProduced += newBatch.getRowCount();
        return newBatch;
    }

    public void open() throws MetaMatrixComponentException {
        super.open();
        try {
            Integer offsetVal = (Integer)ExpressionEvaluator.evaluate(this.offsetExpr, null, null);
            this.offset = offsetVal;
        }
        catch (ExpressionEvaluationException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public void reset() {
        super.reset();
        this.offset = 0;
        this.rowCounter = 0;
        this.tuplesProduced = 0;
    }

    protected void getNodeString(StringBuffer buf) {
        super.getNodeString(buf);
        buf.append(this.offsetExpr);
    }

    public Map getDescriptionProperties() {
        Map props = super.getDescriptionProperties();
        props.put("type", "Offset");
        props.put("rowOffset", this.offsetExpr.toString());
        return props;
    }

    public Object clone() {
        OffsetNode newNode = new OffsetNode(this.getID(), (Expression)this.offsetExpr.clone());
        this.copy(this, newNode);
        newNode.rowCounter = this.rowCounter;
        newNode.tuplesProduced = this.tuplesProduced;
        return newNode;
    }
}

