/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.transformation.util;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.metamodels.relational.AccessPattern;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.RelationalPackage;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.relational.aspects.sql.ColumnAspect;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.SqlAlias;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.metamodels.transformation.StagingTable;
import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnSetAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.transformation.util.AttributeMappingHelper;
import com.metamatrix.modeler.internal.transformation.util.RuntimeTypeConverter;
import com.metamatrix.modeler.internal.transformation.util.SqlAspectHelper;
import com.metamatrix.modeler.internal.transformation.util.SqlConstants;
import com.metamatrix.modeler.internal.transformation.util.SqlMappingRootCache;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationSqlHelper;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadataFactory;
import com.metamatrix.modeler.transformation.validation.TransformationValidator;
import com.metamatrix.query.function.FunctionDescriptor;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.resolver.util.QueryValidationResult;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.CommandCollectorVisitor;
import com.metamatrix.query.sql.visitor.FunctionCollectorVisitor;
import com.metamatrix.query.sql.visitor.SubqueryFromClauseCollectorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class TransformationMappingHelper
implements SqlConstants {
    private static final TransformationMappingHelper INSTANCE = new TransformationMappingHelper();
    private static final boolean NOT_SIGNIFICANT = false;
    private static final boolean IS_UNDOABLE = true;
    public static final int TRANSFORMATION_CHANGED = 10;
    public static final int TRANSFORMATION_UNCHANGED = 20;
    private static final IStatus TRANSFORMATION_OK_CHANGED = new Status(0, "com.metamatrix.modeler.transformation", 10, "internal: transformation parsed successfully, changes were applied", null);
    private static final IStatus TRANSFORMATION_OK_UNCHANGED = new Status(0, "com.metamatrix.modeler.transformation", 20, "internal: transformation parsed successfully, no changes applied", null);
    private static final IStatus TRANSFORMATION_ISSUE = new Status(2, "com.metamatrix.modeler.transformation", 20, "internal: transformation has warnings, no changes applied", null);
    static /* synthetic */ Class class$com$metamatrix$common$types$NullType;
    static /* synthetic */ Class class$java$lang$String;

    public static TransformationMappingHelper getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reconcileMappingsOnSqlChange(EObject transMappingRoot, Object source) {
        if (TransformationHelper.isSqlTransformationMappingRoot((Object)transMappingRoot)) {
            boolean isValid;
            if (source == null) {
                source = TransformationMappingHelper.getInstance();
            }
            if ((isValid = SqlMappingRootCache.isSelectValid((Object)transMappingRoot)) || TransformationHelper.isInitialSelect((Object)transMappingRoot) || TransformationHelper.isEmptySelect((Object)transMappingRoot)) {
                boolean isLocked = TransformationHelper.isTargetGroupLocked((Object)transMappingRoot);
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Update Atribute Mappings", (Object)source);
                boolean succeeded = false;
                try {
                    TransformationMappingHelper.reconcileSources(transMappingRoot, source);
                    if (!isLocked) {
                        TransformationMappingHelper.reconcileTargetAttributes(transMappingRoot, source);
                    }
                    AttributeMappingHelper.updateAttributeMappings((Object)transMappingRoot, (Object)source);
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
                if (requiredStart) {
                    SqlMappingRootCache.invalidateSelectStatus((Object)transMappingRoot, (boolean)true, (Object)source);
                }
            }
        }
    }

    public static boolean[] compareQueryTargetAndSQLOutput(EObject transMappingRoot, int type) {
        EObject targetGroup;
        boolean sizesMatch = false;
        boolean namesMatch = false;
        boolean typesMatch = false;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot((Object)transMappingRoot) && (targetGroup = TransformationHelper.getTransformationTarget((Object)transMappingRoot)) != null) {
            List attributes = TransformationHelper.getTransformationTargetAttributes((EObject)transMappingRoot);
            TransformationMappingHelper.removeNonSelectableColumnAttributes(attributes);
            com.metamatrix.query.sql.lang.Command command = TransformationHelper.getCommand((Object)transMappingRoot, (int)type);
            List sqlNames = TransformationSqlHelper.getProjectedSymbolNames((com.metamatrix.query.sql.lang.Command)command);
            if (sqlNames.size() == 0 && type == 0) {
                sizesMatch = false;
            } else if (sqlNames.size() == attributes.size()) {
                sizesMatch = true;
            }
            if (sizesMatch) {
                List attributeNames = TransformationMappingHelper.getAttributeNames(attributes);
                namesMatch = TransformationMappingHelper.allStringsMatch(sqlNames, attributeNames);
                if (TransformationHelper.isValid((Object)transMappingRoot, (int)type)) {
                    List sqlSyms = command.getProjectedSymbols();
                    typesMatch = TransformationMappingHelper.allTypesMatch(sqlSyms, attributes);
                }
            }
        }
        boolean[] result = new boolean[]{sizesMatch, namesMatch, typesMatch};
        return result;
    }

    public static void removeNonSelectableColumnAttributes(List attributes) {
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            if (!TransformationHelper.isNonSelectableSqlColumn(iter.next())) continue;
            iter.remove();
        }
    }

    public static void removeSelectableColumnAttributes(List attributes) {
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            if (TransformationHelper.isNonSelectableSqlColumn(iter.next())) continue;
            iter.remove();
        }
    }

    public static void removeNonParameterColumnAttributes(List attributes) {
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            ColumnAspect aspect;
            EObject input = (EObject)iter.next();
            SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)input);
            if (!(sqlAspect instanceof ColumnAspect) || (aspect = (ColumnAspect)sqlAspect).isTranformationInputParameter(input)) continue;
            iter.remove();
        }
    }

    public static boolean targetAndCommandReconcile(EObject transMappingRoot, com.metamatrix.query.sql.lang.Command command, boolean nameMatchReqd) {
        EObject targetGroup;
        boolean sizesMatch = false;
        boolean namesMatch = false;
        boolean typesMatch = false;
        boolean areReconciled = false;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot((Object)transMappingRoot) && (targetGroup = TransformationHelper.getTransformationTarget((Object)transMappingRoot)) != null) {
            List attributes = TransformationHelper.getTransformationTargetAttributesNotInAccessPattern((EObject)transMappingRoot);
            List sqlNames = TransformationSqlHelper.getProjectedSymbolNames((com.metamatrix.query.sql.lang.Command)command);
            if (sqlNames.size() == attributes.size()) {
                sizesMatch = true;
            }
            if (sizesMatch) {
                List attributeNames = TransformationMappingHelper.getTargetAttributeNamesNotInAccessPattern(transMappingRoot);
                namesMatch = TransformationMappingHelper.allStringsMatch(sqlNames, attributeNames);
                if (TransformationMappingHelper.commandValid(transMappingRoot, command)) {
                    List sqlSyms = command.getProjectedSymbols();
                    typesMatch = TransformationMappingHelper.allTypesMatch(sqlSyms, attributes);
                }
            }
        }
        if (nameMatchReqd && sizesMatch && namesMatch && typesMatch) {
            areReconciled = true;
        } else if (!nameMatchReqd && sizesMatch && typesMatch) {
            areReconciled = true;
        }
        return areReconciled;
    }

    private static boolean typesMatch(SingleElementSymbol seSymbol, EObject attribute) {
        Class symType;
        boolean typesMatch = false;
        if (seSymbol != null && attribute != null && (symType = seSymbol.getType()) != null && symType != DataTypeManager.DefaultDataClasses.NULL && RuntimeTypeConverter.isExplicitMatch((Object)seSymbol, (Object)attribute)) {
            typesMatch = true;
        }
        return typesMatch;
    }

    private static boolean allTypesMatch(List symbolList, List attributeList) {
        if (symbolList != null && attributeList != null && symbolList.size() == attributeList.size()) {
            for (int i = 0; i < symbolList.size(); ++i) {
                EObject attr;
                SingleElementSymbol seSymbol = (SingleElementSymbol)symbolList.get(i);
                if (TransformationMappingHelper.typesMatch(seSymbol, attr = (EObject)attributeList.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean allStringsMatch(List list1, List list2) {
        if (list1 != null && list2 != null && list1.size() == list2.size()) {
            for (int i = 0; i < list1.size(); ++i) {
                String str2;
                String str1 = (String)list1.get(i);
                if (str1.equalsIgnoreCase(str2 = (String)list2.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean commandValid(EObject transMappingRoot, com.metamatrix.query.sql.lang.Command command) {
        TransformationValidator validator;
        QueryValidationResult result;
        boolean isValid = false;
        if (!command.isResolved() && (result = (validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot)).validateSql(command.toString(), 0, false, false)).isValidatable()) {
            isValid = true;
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reconcileSources(EObject transMappingRoot, Object source) {
        boolean isValid;
        boolean success = false;
        if (source == null) {
            source = TransformationMappingHelper.getInstance();
        }
        if ((isValid = SqlMappingRootCache.isSelectValid((Object)transMappingRoot)) && !TransformationMappingHelper.isReadOnly(transMappingRoot)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Reconcile Sources", (Object)source);
            boolean succeeded = false;
            try {
                String symbolName;
                EObject symbolEObj;
                GroupSymbol gSymbol;
                TransformationHelper.reconcileInputsAndAliases((EObject)transMappingRoot);
                ArrayList<com.metamatrix.query.sql.lang.Command> allCommands = new ArrayList<com.metamatrix.query.sql.lang.Command>();
                com.metamatrix.query.sql.lang.Command selectCommand = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
                allCommands.add(selectCommand);
                EObject target = TransformationHelper.getTransformationTarget((Object)transMappingRoot);
                if (TransformationHelper.tableSupportsUpdate((EObject)target)) {
                    if (TransformationHelper.isInsertAllowed((Object)transMappingRoot) && SqlMappingRootCache.isInsertValid((Object)transMappingRoot)) {
                        allCommands.add(SqlMappingRootCache.getInsertCommand((Object)transMappingRoot));
                    }
                    if (TransformationHelper.isUpdateAllowed((Object)transMappingRoot) && SqlMappingRootCache.isUpdateValid((Object)transMappingRoot)) {
                        allCommands.add(SqlMappingRootCache.getUpdateCommand((Object)transMappingRoot));
                    }
                    if (TransformationHelper.isDeleteAllowed((Object)transMappingRoot) && SqlMappingRootCache.isDeleteValid((Object)transMappingRoot)) {
                        allCommands.add(SqlMappingRootCache.getDeleteCommand((Object)transMappingRoot));
                    }
                }
                List symbolsToAdd = TransformationMappingHelper.getGroupSymbolsNotInMapping(transMappingRoot, allCommands);
                QueryMetadataInterface metadata = TransformationMetadataFactory.getInstance().getModelerMetadata(transMappingRoot, false);
                List lookupSymbolsToAdd = TransformationMappingHelper.getLookupGroupSymbolsNotInMapping(transMappingRoot, allCommands, metadata);
                List subqueryFromClausesToAdd = TransformationMappingHelper.getSubqueryFromClausesNotInMapping(transMappingRoot, allCommands);
                List storedProcsToAdd = TransformationMappingHelper.getStoredProcsNotInMapping(transMappingRoot, allCommands);
                List allAliases = TransformationHelper.getAllSqlAliases((Object)transMappingRoot);
                List aliasesInCommand = TransformationMappingHelper.getSqlAliasesInCommand(transMappingRoot, allCommands);
                ArrayList aliasesToRemove = new ArrayList(allAliases.size());
                aliasesToRemove.addAll(allAliases);
                aliasesToRemove.removeAll(aliasesInCommand);
                Iterator iter = aliasesToRemove.iterator();
                while (iter.hasNext()) {
                    SqlAlias sqlAlias = (SqlAlias)iter.next();
                    EObject sqlEObj = sqlAlias.getAliasedObject();
                    String sqlAliasName = sqlAlias.getAlias();
                    TransformationHelper.removeSourceAlias((Object)transMappingRoot, (EObject)sqlEObj, (String)sqlAliasName, (boolean)true, (Object)source);
                }
                iter = symbolsToAdd.iterator();
                while (iter.hasNext()) {
                    gSymbol = (GroupSymbol)iter.next();
                    symbolEObj = TransformationSqlHelper.getGroupSymbolEObject((GroupSymbol)gSymbol);
                    symbolName = TransformationSqlHelper.getGroupSymbolShortName((GroupSymbol)gSymbol);
                    if (symbolEObj == null) continue;
                    TransformationHelper.addSqlAlias((Object)transMappingRoot, (EObject)symbolEObj, (String)symbolName, (boolean)true, (Object)source);
                }
                iter = lookupSymbolsToAdd.iterator();
                while (iter.hasNext()) {
                    gSymbol = (GroupSymbol)iter.next();
                    symbolEObj = TransformationSqlHelper.getGroupSymbolEObject((GroupSymbol)gSymbol);
                    symbolName = TransformationSqlHelper.getGroupSymbolShortName((GroupSymbol)gSymbol);
                    if (symbolEObj == null) continue;
                    TransformationHelper.addSqlAlias((Object)transMappingRoot, (EObject)symbolEObj, (String)symbolName, (boolean)true, (Object)source);
                }
                iter = subqueryFromClausesToAdd.iterator();
                while (iter.hasNext()) {
                    SubqueryFromClause subqueryFrom = (SubqueryFromClause)iter.next();
                    com.metamatrix.query.sql.lang.Command subCommand = subqueryFrom.getCommand();
                    if (!(subCommand instanceof StoredProcedure)) continue;
                    StoredProcedure storedProc = (StoredProcedure)subCommand;
                    EObject procEObj = TransformationSqlHelper.getStoredProcedureEObject((StoredProcedure)storedProc);
                    String procName = subqueryFrom.getName();
                    if (procEObj == null) continue;
                    TransformationHelper.addSqlAlias((Object)transMappingRoot, (EObject)procEObj, (String)procName, (boolean)true, (Object)source);
                }
                iter = storedProcsToAdd.iterator();
                while (iter.hasNext()) {
                    StoredProcedure storedProc = (StoredProcedure)iter.next();
                    EObject procEObj = TransformationSqlHelper.getStoredProcedureEObject((StoredProcedure)storedProc);
                    String procName = storedProc.getProcedureCallableName();
                    if (procEObj == null) continue;
                    TransformationHelper.addSqlAlias((Object)transMappingRoot, (EObject)procEObj, (String)procName, (boolean)true, (Object)source);
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        if (TransformationHelper.isInitialSelect((Object)transMappingRoot) || TransformationHelper.isEmptySelect((Object)transMappingRoot)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Reconcile Sources", (Object)source);
            boolean succeeded = false;
            try {
                TransformationHelper.removeAllSourcesAndAliases((Object)transMappingRoot, (boolean)true, (Object)source);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return success;
    }

    public static List getLookupGroupSymbolsNotInMapping(EObject transMappingRoot, List commands, QueryMetadataInterface metadata) {
        ArrayList symbolList = new ArrayList();
        Iterator commandIter = commands.iterator();
        while (commandIter.hasNext()) {
            com.metamatrix.query.sql.lang.Command command = (com.metamatrix.query.sql.lang.Command)commandIter.next();
            TransformationMappingHelper.addLookupGroupSymbolsNotInMapping(transMappingRoot, command, symbolList, metadata);
        }
        return symbolList;
    }

    public static void addLookupGroupSymbolsNotInMapping(EObject transMappingRoot, com.metamatrix.query.sql.lang.Command command, List symbolList, QueryMetadataInterface metadata) {
        Collection functions = FunctionCollectorVisitor.getFunctions((LanguageObject)command, (boolean)true);
        List sqlGroupSymbols = TransformationMappingHelper.getLookupGroupSymbols(functions, metadata);
        List mappingAliases = TransformationHelper.getAllSqlAliases((Object)transMappingRoot);
        Iterator iter = sqlGroupSymbols.iterator();
        while (iter.hasNext()) {
            GroupSymbol gSymbol = (GroupSymbol)iter.next();
            if (TransformationMappingHelper.groupSymbolInAliasList(gSymbol, mappingAliases) || gSymbol.getMetadataID() instanceof TempMetadataID) continue;
            symbolList.add(gSymbol);
        }
    }

    public static List getLookupGroupSymbols(Collection functions, QueryMetadataInterface metadata) {
        ArrayList<GroupSymbol> groupSymbols = new ArrayList<GroupSymbol>();
        Iterator iter = functions.iterator();
        while (iter.hasNext()) {
            String message;
            Expression[] args;
            Function function = (Function)iter.next();
            FunctionDescriptor fd = function.getFunctionDescriptor();
            if (fd == null || !fd.getName().equalsIgnoreCase("lookup") || !((args = function.getArgs())[0] instanceof Constant)) continue;
            String groupName = (String)((Constant)args[0]).getValue();
            try {
                Object metadataID = metadata.getGroupID(groupName);
                GroupSymbol symbol = new GroupSymbol(groupName);
                symbol.setMetadataID(metadataID);
                if (groupSymbols.contains(symbol)) continue;
                groupSymbols.add(symbol);
            }
            catch (QueryMetadataException e) {
                message = TransformationPlugin.Util.getString("TransformationSqlHelper.groupIDNotFoundError", (Object)groupName);
                TransformationPlugin.Util.log(2, (Throwable)e, message);
            }
            catch (MetaMatrixComponentException e) {
                message = TransformationPlugin.Util.getString("TransformationSqlHelper.groupIDNotFoundError", (Object)groupName);
                TransformationPlugin.Util.log(2, (Throwable)e, message);
            }
        }
        return groupSymbols;
    }

    private static List getGroupSymbolsNotInMapping(EObject transMappingRoot, List commands) {
        ArrayList symbolList = new ArrayList();
        Iterator commandIter = commands.iterator();
        while (commandIter.hasNext()) {
            com.metamatrix.query.sql.lang.Command command = (com.metamatrix.query.sql.lang.Command)commandIter.next();
            TransformationMappingHelper.addGroupSymbolsNotInMapping(transMappingRoot, command, symbolList);
        }
        return symbolList;
    }

    private static void addGroupSymbolsNotInMapping(EObject transMappingRoot, com.metamatrix.query.sql.lang.Command command, List symbolList) {
        Collection sqlGroupSymbols = TransformationSqlHelper.getGroupSymbols((com.metamatrix.query.sql.lang.Command)command);
        List mappingAliases = TransformationHelper.getAllSqlAliases((Object)transMappingRoot);
        Iterator iter = sqlGroupSymbols.iterator();
        while (iter.hasNext()) {
            GroupSymbol gSymbol = (GroupSymbol)iter.next();
            if (TransformationMappingHelper.groupSymbolInAliasList(gSymbol, mappingAliases) || gSymbol.getMetadataID() instanceof TempMetadataID) continue;
            symbolList.add(gSymbol);
        }
    }

    private static List getSubqueryFromClausesNotInMapping(EObject transMappingRoot, List commands) {
        ArrayList resultList = new ArrayList();
        Iterator commandIter = commands.iterator();
        while (commandIter.hasNext()) {
            com.metamatrix.query.sql.lang.Command command = (com.metamatrix.query.sql.lang.Command)commandIter.next();
            TransformationMappingHelper.addSubqueryFromClausesNotInMapping(transMappingRoot, command, resultList);
        }
        return resultList;
    }

    private static void addSubqueryFromClausesNotInMapping(EObject transMappingRoot, com.metamatrix.query.sql.lang.Command command, List resultList) {
        List subqueryFromClauses = SubqueryFromClauseCollectorVisitor.getClauses((LanguageObject)command);
        List mappingAliases = TransformationHelper.getAllSqlAliases((Object)transMappingRoot);
        Iterator iter = subqueryFromClauses.iterator();
        while (iter.hasNext()) {
            SubqueryFromClause subqueryFrom = (SubqueryFromClause)iter.next();
            if (TransformationMappingHelper.subqueryFromClauseInAliasList(subqueryFrom, mappingAliases)) continue;
            resultList.add(subqueryFrom);
        }
    }

    private static List getStoredProcsNotInMapping(EObject transMappingRoot, List commands) {
        ArrayList resultList = new ArrayList();
        Iterator commandIter = commands.iterator();
        while (commandIter.hasNext()) {
            com.metamatrix.query.sql.lang.Command command = (com.metamatrix.query.sql.lang.Command)commandIter.next();
            TransformationMappingHelper.addStoredProcsNotInMapping(transMappingRoot, command, resultList);
        }
        return resultList;
    }

    private static void addStoredProcsNotInMapping(EObject transMappingRoot, com.metamatrix.query.sql.lang.Command command, List resultList) {
        ArrayList<com.metamatrix.query.sql.lang.Command> allCommands = new ArrayList<com.metamatrix.query.sql.lang.Command>();
        allCommands.add(command);
        allCommands.addAll(CommandCollectorVisitor.getCommands((LanguageObject)command));
        Iterator iter = allCommands.iterator();
        while (iter.hasNext()) {
            List mappingAliases;
            StoredProcedure storedProc;
            com.metamatrix.query.sql.lang.Command cmd = (com.metamatrix.query.sql.lang.Command)iter.next();
            if (!(cmd instanceof StoredProcedure) || TransformationMappingHelper.storedProcInAliasList(storedProc = (StoredProcedure)cmd, mappingAliases = TransformationHelper.getAllSqlAliases((Object)transMappingRoot))) continue;
            resultList.add(storedProc);
        }
    }

    public static boolean groupSymbolInAliasList(GroupSymbol gSymbol, List sqlAliases) {
        boolean inSqlList = false;
        EObject groupEObj = TransformationSqlHelper.getGroupSymbolEObject((GroupSymbol)gSymbol);
        String groupName = TransformationSqlHelper.getGroupSymbolShortName((GroupSymbol)gSymbol);
        if (groupEObj != null && groupName != null) {
            Iterator iter = sqlAliases.iterator();
            while (iter.hasNext()) {
                SqlAlias sqlAlias = (SqlAlias)iter.next();
                EObject aEObj = sqlAlias.getAliasedObject();
                String aName = sqlAlias.getAlias();
                if (aEObj == null || aName == null || !aEObj.equals(groupEObj) || !aName.equalsIgnoreCase(groupName)) continue;
                inSqlList = true;
                break;
            }
        }
        return inSqlList;
    }

    private static boolean subqueryFromClauseInAliasList(SubqueryFromClause subqueryFrom, List sqlAliases) {
        boolean inSqlList = false;
        Iterator iter = sqlAliases.iterator();
        while (iter.hasNext()) {
            SqlAlias sqlAlias = (SqlAlias)iter.next();
            if (!TransformationSqlHelper.isMatch((SubqueryFromClause)subqueryFrom, (SqlAlias)sqlAlias)) continue;
            inSqlList = true;
            break;
        }
        return inSqlList;
    }

    private static boolean storedProcInAliasList(StoredProcedure storedProc, List sqlAliases) {
        boolean inSqlList = false;
        Iterator iter = sqlAliases.iterator();
        while (iter.hasNext()) {
            SqlAlias sqlAlias = (SqlAlias)iter.next();
            if (!TransformationSqlHelper.isMatch((StoredProcedure)storedProc, (SqlAlias)sqlAlias)) continue;
            inSqlList = true;
            break;
        }
        return inSqlList;
    }

    public static List getSqlAliasesInCommand(EObject transMappingRoot, List commands) {
        ArrayList aliasList = new ArrayList();
        Iterator commandIter = commands.iterator();
        while (commandIter.hasNext()) {
            com.metamatrix.query.sql.lang.Command command = (com.metamatrix.query.sql.lang.Command)commandIter.next();
            TransformationMappingHelper.addSqlAliasesInCommand(transMappingRoot, command, aliasList);
        }
        return aliasList;
    }

    private static void addSqlAliasesInCommand(EObject transMappingRoot, com.metamatrix.query.sql.lang.Command command, List aliasList) {
        ArrayList<com.metamatrix.query.sql.lang.Command> allCommands = new ArrayList<com.metamatrix.query.sql.lang.Command>();
        allCommands.add(command);
        allCommands.addAll(CommandCollectorVisitor.getCommands((LanguageObject)command));
        Iterator cIter = allCommands.iterator();
        while (cIter.hasNext()) {
            com.metamatrix.query.sql.lang.Command cmd = (com.metamatrix.query.sql.lang.Command)cIter.next();
            Collection sqlGroupSymbols = TransformationSqlHelper.getGroupSymbols((com.metamatrix.query.sql.lang.Command)cmd);
            TransformationMappingHelper.removeTempIDGroupSymbols(sqlGroupSymbols);
            List subqueryFromClauses = SubqueryFromClauseCollectorVisitor.getClauses((LanguageObject)cmd);
            StoredProcedure storedProc = null;
            if (cmd instanceof StoredProcedure) {
                storedProc = (StoredProcedure)cmd;
            }
            List mappingAliases = TransformationHelper.getAllSqlAliases((Object)transMappingRoot);
            Iterator iter = mappingAliases.iterator();
            while (iter.hasNext()) {
                SqlAlias sqlAlias = (SqlAlias)iter.next();
                if (!TransformationMappingHelper.sqlAliasInGroupSymbolList(sqlAlias, sqlGroupSymbols) && !TransformationMappingHelper.sqlAliasInSubqueryFromList(sqlAlias, subqueryFromClauses) && !TransformationSqlHelper.isMatch((StoredProcedure)storedProc, (SqlAlias)sqlAlias) || aliasList.contains(sqlAlias)) continue;
                aliasList.add(sqlAlias);
            }
        }
    }

    private static void removeTempIDGroupSymbols(Collection groupSymbols) {
        Iterator iter = groupSymbols.iterator();
        while (iter.hasNext()) {
            GroupSymbol gSymbol = (GroupSymbol)iter.next();
            if (!(gSymbol.getMetadataID() instanceof TempMetadataID)) continue;
            iter.remove();
        }
    }

    public static boolean sqlAliasInGroupSymbolList(SqlAlias sqlAlias, Collection groupSymbols) {
        boolean inGroupSymbolList = false;
        EObject aliasEObj = sqlAlias.getAliasedObject();
        String aliasName = sqlAlias.getAlias();
        Iterator iter = groupSymbols.iterator();
        while (iter.hasNext()) {
            GroupSymbol gSymbol = (GroupSymbol)iter.next();
            EObject groupEObj = TransformationSqlHelper.getGroupSymbolEObject((GroupSymbol)gSymbol);
            String groupName = TransformationSqlHelper.getGroupSymbolShortName((GroupSymbol)gSymbol);
            if (groupEObj == null || groupName == null || !groupEObj.equals(aliasEObj) || !groupName.equalsIgnoreCase(aliasName)) continue;
            inGroupSymbolList = true;
            break;
        }
        return inGroupSymbolList;
    }

    public static boolean sqlAliasInSubqueryFromList(SqlAlias sqlAlias, Collection subqueryFromClauses) {
        boolean inSubqueryFromList = false;
        Iterator iter = subqueryFromClauses.iterator();
        while (iter.hasNext()) {
            SubqueryFromClause subqueryFrom = (SubqueryFromClause)iter.next();
            if (!TransformationSqlHelper.isMatch((SubqueryFromClause)subqueryFrom, (SqlAlias)sqlAlias)) continue;
            inSubqueryFromList = true;
            break;
        }
        return inSubqueryFromList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IStatus reconcileTargetAttributes(EObject transMappingRoot, boolean reconcileMappingClassTarget, Object txnSource) {
        boolean success = false;
        boolean changed = false;
        if (!TransformationHelper.isTargetGroupLocked((Object)transMappingRoot)) {
            EObject targetGroup;
            if (txnSource == null) {
                txnSource = TransformationMappingHelper.getInstance();
            }
            if ((targetGroup = TransformationHelper.getTransformationTarget((Object)transMappingRoot)) instanceof MappingClass && !(targetGroup instanceof StagingTable) && !reconcileMappingClassTarget) {
                return TRANSFORMATION_ISSUE;
            }
            boolean hasXMLDocSource = false;
            List sources = TransformationHelper.getTransformationSources((Object)transMappingRoot);
            if (sources.size() == 1 && sources.get(0) instanceof XmlDocument) {
                hasXMLDocSource = true;
            }
            boolean isValid = SqlMappingRootCache.isSelectValid((Object)transMappingRoot);
            com.metamatrix.query.sql.lang.Command validCommand = null;
            if (isValid) {
                validCommand = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
            }
            if (targetGroup != null && validCommand != null) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Reconcile Target Attributes", (Object)txnSource);
                boolean succeeded = false;
                try {
                    List currentTargetAttrNames = TransformationMappingHelper.getTargetAttributeNames(transMappingRoot);
                    List projectedSymbolNames = null;
                    EObject linkTarget = TransformationHelper.getTransformationLinkTarget((EObject)transMappingRoot);
                    projectedSymbolNames = TransformationHelper.isSqlVirtualProcedure((Object)linkTarget) ? TransformationSqlHelper.getProjectedSymbolUniqueNames((com.metamatrix.query.sql.lang.Command)validCommand) : TransformationSqlHelper.getProjectedSymbolAndProcInputUniqueNames((com.metamatrix.query.sql.lang.Command)validCommand);
                    int nCurrentTargetAttrs = currentTargetAttrNames.size();
                    int nProjectedSymbols = projectedSymbolNames.size();
                    if (nProjectedSymbols < nCurrentTargetAttrs) {
                        TransformationMappingHelper.resetSelectSqlOnNameConflict(validCommand, transMappingRoot, true, txnSource);
                        IStatus iStatus = TRANSFORMATION_ISSUE;
                        return iStatus;
                    }
                    List matchedNames = TransformationMappingHelper.getMatchedNames(currentTargetAttrNames, projectedSymbolNames);
                    List unmatchedVirtualNames = TransformationMappingHelper.removeNames(currentTargetAttrNames, matchedNames);
                    if (unmatchedVirtualNames.size() != 0) {
                        TransformationMappingHelper.resetSelectSqlOnNameConflict(validCommand, transMappingRoot, true, txnSource);
                        IStatus iStatus = TRANSFORMATION_ISSUE;
                        return iStatus;
                    }
                    List extraSymbolNames = TransformationMappingHelper.removeNames(projectedSymbolNames, matchedNames);
                    Map eObjectMap = TransformationSqlHelper.getProjectedSymbolAndProcInputEObjects((com.metamatrix.query.sql.lang.Command)validCommand);
                    if (extraSymbolNames.size() != 0) {
                        TransformationMappingHelper.addTargetAttributes(extraSymbolNames, eObjectMap, targetGroup, txnSource);
                        changed = true;
                    }
                    TransformationMappingHelper.resetSelectSqlOnNameConflict(validCommand, transMappingRoot, true, txnSource);
                    changed = TransformationMappingHelper.orderGroupAttributes(targetGroup, projectedSymbolNames) || changed;
                    Map symbolTypeMap = TransformationSqlHelper.getProjectedSymbolAndProcInputUniqueTypes((com.metamatrix.query.sql.lang.Command)validCommand);
                    boolean bl = changed = TransformationMappingHelper.setGroupAttributeTypes(targetGroup, symbolTypeMap) || changed;
                    if (!(targetGroup instanceof MappingClass)) {
                        Map symbolLengthMap = TransformationSqlHelper.getProjectedSymbolAndProcInputLengths((com.metamatrix.query.sql.lang.Command)validCommand, (boolean)hasXMLDocSource);
                        changed = TransformationMappingHelper.setGroupAttributeLengths(targetGroup, symbolLengthMap) || changed;
                    }
                    changed = AttributeMappingHelper.updateAttributeMappings((Object)transMappingRoot, (Object)txnSource) || changed;
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
                if (changed && requiredStart) {
                    SqlMappingRootCache.invalidateSelectStatus((Object)transMappingRoot, (boolean)true, (Object)txnSource);
                }
                success = true;
            }
        }
        IStatus rv = success ? (changed ? TRANSFORMATION_OK_CHANGED : TRANSFORMATION_OK_UNCHANGED) : TRANSFORMATION_ISSUE;
        return rv;
    }

    public static IStatus reconcileTargetAttributes(EObject transMappingRoot, Object txnSource) {
        return TransformationMappingHelper.reconcileTargetAttributes(transMappingRoot, false, txnSource);
    }

    public static void addTargetAttrsForProcedureInputParams(EObject transMappingRoot, EObject targetGroup, List sources, Object txnSource) {
        ArrayList procSources = new ArrayList(sources.size());
        ArrayList procInputParams = new ArrayList();
        ArrayList procInOutParams = new ArrayList();
        ArrayList procOutputParams = new ArrayList();
        ArrayList procResultCols = new ArrayList();
        Iterator sIter = sources.iterator();
        while (sIter.hasNext()) {
            Object source = sIter.next();
            if (!TransformationHelper.isSqlProcedure(source)) continue;
            procSources.add(source);
            procInputParams.addAll(TransformationHelper.getInAndInoutParameters((EObject)((EObject)source)));
            procInOutParams.addAll(TransformationHelper.getInoutParameters((EObject)((EObject)source)));
            procOutputParams.addAll(TransformationHelper.getOutAndReturnParameters((EObject)((EObject)source)));
            SqlProcedureAspect procedureAspect = (SqlProcedureAspect)AspectManager.getSqlAspect((EObject)((EObject)source));
            Object resultSet = procedureAspect.getResult((EObject)source);
            if (!SqlAspectHelper.isProcedureResultSet((EObject)((EObject)resultSet))) continue;
            SqlColumnSetAspect rsAspect = (SqlColumnSetAspect)SqlAspectHelper.getSqlAspect((EObject)((EObject)resultSet));
            List rsCols = rsAspect.getColumns((EObject)resultSet);
            procResultCols.addAll(rsCols);
        }
        if (!procSources.isEmpty() && TransformationHelper.isVirtualSqlTable((Object)targetGroup)) {
            ArrayList<String> colsToCreate = new ArrayList<String>();
            HashMap<String, EObject> typeMap = new HashMap<String, EObject>();
            HashMap<String, Integer> lengthMap = new HashMap<String, Integer>();
            List allCols = TransformationHelper.getTargetAttributes((EObject)targetGroup);
            Iterator ipIter = procInputParams.iterator();
            while (ipIter.hasNext()) {
                Object ip = ipIter.next();
                if (!TransformationHelper.isSqlProcedureParameter(ip)) continue;
                SqlProcedureParameterAspect aspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)((EObject)ip));
                String paramName = aspect.getName((EObject)ip);
                EObject paramType = aspect.getDatatype((EObject)ip);
                int paramLength = aspect.getLength((EObject)ip);
                if (TransformationMappingHelper.containsName(allCols, paramName)) continue;
                colsToCreate.add(paramName);
                typeMap.put(paramName, paramType);
                lengthMap.put(paramName, new Integer(paramLength));
            }
            Iterator ipIter2 = procInOutParams.iterator();
            while (ipIter2.hasNext()) {
                Object ip = ipIter2.next();
                if (!TransformationHelper.isSqlProcedureParameter(ip)) continue;
                SqlProcedureParameterAspect aspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)((EObject)ip));
                String paramName = aspect.getName((EObject)ip);
                EObject paramType = aspect.getDatatype((EObject)ip);
                int paramLength = aspect.getLength((EObject)ip);
                if (TransformationMappingHelper.containsName(allCols, paramName)) continue;
                colsToCreate.add(paramName);
                typeMap.put(paramName, paramType);
                lengthMap.put(paramName, new Integer(paramLength));
            }
            Iterator opIter = procOutputParams.iterator();
            while (opIter.hasNext()) {
                Object ip = opIter.next();
                if (!TransformationHelper.isSqlProcedureParameter(ip)) continue;
                SqlProcedureParameterAspect aspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)((EObject)ip));
                String paramName = aspect.getName((EObject)ip);
                EObject paramType = aspect.getDatatype((EObject)ip);
                int paramLength = aspect.getLength((EObject)ip);
                if (TransformationMappingHelper.containsName(allCols, paramName)) continue;
                colsToCreate.add(paramName);
                typeMap.put(paramName, paramType);
                lengthMap.put(paramName, new Integer(paramLength));
            }
            Iterator rsIter = procResultCols.iterator();
            while (rsIter.hasNext()) {
                Object col = rsIter.next();
                if (!TransformationHelper.isSqlColumn(col)) continue;
                SqlColumnAspect colAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)((EObject)col));
                String colName = colAspect.getName((EObject)col);
                EObject colType = colAspect.getDatatype((EObject)col);
                int colLength = colAspect.getLength((EObject)col);
                if (TransformationMappingHelper.containsName(allCols, colName)) continue;
                colsToCreate.add(colName);
                typeMap.put(colName, colType);
                lengthMap.put(colName, new Integer(colLength));
            }
            if (!colsToCreate.isEmpty()) {
                TransformationMappingHelper.addTargetAttributes(targetGroup, colsToCreate, txnSource);
                TransformationMappingHelper.setGroupAttributeTypes(targetGroup, typeMap);
                TransformationMappingHelper.setGroupAttributeLengths(targetGroup, lengthMap);
            }
            List colsNotInAP = TransformationHelper.getTransformationTargetAttributesNotInAccessPattern((EObject)transMappingRoot);
            ArrayList<EObject> colsToAddToAP = new ArrayList<EObject>(colsNotInAP.size());
            ipIter = procInputParams.iterator();
            boolean isMappingClass = targetGroup instanceof MappingClass;
            while (!isMappingClass && ipIter.hasNext()) {
                SqlProcedureParameterAspect aspect;
                String paramName;
                EObject attrObj;
                Object ip = ipIter.next();
                if (!TransformationHelper.isSqlProcedureParameter(ip) || (attrObj = TransformationMappingHelper.getListAttrByName(colsNotInAP, paramName = (aspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)((EObject)ip))).getName((EObject)ip))) == null) continue;
                if (attrObj instanceof Column) {
                    ((Column)attrObj).setSelectable(false);
                }
                colsToAddToAP.add(attrObj);
            }
            if (!colsToAddToAP.isEmpty()) {
                SqlTableAspect tableAspect = (SqlTableAspect)SqlAspectHelper.getSqlAspect((EObject)targetGroup);
                Collection accessPatterns = tableAspect.getAccessPatterns(targetGroup);
                AccessPattern accessPattern = null;
                com.metamatrix.query.sql.lang.Command selectCommand = TransformationHelper.getCommand((Object)transMappingRoot, (int)0);
                List inParamNames = TransformationSqlHelper.getProcedureInputParamNames((com.metamatrix.query.sql.lang.Command)selectCommand);
                Iterator apIter = accessPatterns.iterator();
                boolean useExistingAP = false;
                while (apIter.hasNext()) {
                    accessPattern = (AccessPattern)apIter.next();
                    EList aPatternCols = accessPattern.getColumns();
                    Iterator apColIter = aPatternCols.iterator();
                    boolean goodAP = true;
                    while (apColIter.hasNext()) {
                        Column col = (Column)apColIter.next();
                        String apColName = col.getName();
                        if (apColName == null || inParamNames.contains(apColName)) continue;
                        goodAP = false;
                        break;
                    }
                    if (!goodAP) continue;
                    useExistingAP = true;
                    break;
                }
                if (!useExistingAP || accessPattern == null) {
                    accessPattern = RelationalPackage.eINSTANCE.getRelationalFactory().createAccessPattern();
                    accessPattern.setName("AccessPattern");
                    if (targetGroup instanceof Table) {
                        accessPattern.setTable((Table)targetGroup);
                    }
                }
                try {
                    ModelerCore.getModelEditor().addValue((Object)accessPattern, colsToAddToAP, accessPattern.getColumns(), 0);
                }
                catch (ModelerCoreException e) {
                    TransformationPlugin.Util.log((Throwable)e);
                }
                SqlMappingRootCache.invalidateSelectStatus((Object)transMappingRoot, (boolean)false, (Object)txnSource);
            }
        }
    }

    public static boolean hasProcedure(List objList) {
        boolean hasProcedure = false;
        Iterator iter = objList.iterator();
        while (iter.hasNext()) {
            Object source = iter.next();
            if (!TransformationHelper.isSqlProcedure(source)) continue;
            hasProcedure = true;
            break;
        }
        return hasProcedure;
    }

    public static List getTargetAttributeNames(EObject transMappingRoot) {
        List attributes = TransformationHelper.getTransformationTargetAttributes((EObject)transMappingRoot);
        return TransformationMappingHelper.getAttributeNames(attributes);
    }

    public static List getTargetAttributeNamesNotInAccessPattern(EObject transMappingRoot) {
        List attributes = TransformationHelper.getTransformationTargetAttributes((EObject)transMappingRoot);
        List apAttributes = TransformationHelper.getTransformationTargetAttributesInAccessPattern((EObject)transMappingRoot);
        attributes.removeAll(apAttributes);
        return TransformationMappingHelper.getAttributeNames(attributes);
    }

    public static List getAttributeNames(List attributes) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            EObject attr = (EObject)iter.next();
            if (!SqlAspectHelper.isColumn((EObject)attr)) continue;
            if (SqlAspectHelper.isXmlDocument((EObject)attr)) {
                attributeNames.add("xml");
                continue;
            }
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)attr);
            attributeNames.add(columnAspect.getName(attr));
        }
        return attributeNames;
    }

    private static List getMatchedNames(List list1, List list2) {
        ArrayList<String> newList = new ArrayList<String>();
        Iterator list1Iter = list1.iterator();
        block0: while (list1Iter.hasNext()) {
            String list1Str = (String)list1Iter.next();
            if (list1Str == null) continue;
            Iterator list2Iter = list2.iterator();
            while (list2Iter.hasNext()) {
                String list2Str = (String)list2Iter.next();
                if (!list1Str.equalsIgnoreCase(list2Str)) continue;
                newList.add(list1Str);
                continue block0;
            }
        }
        return newList;
    }

    private static List removeNames(List list, List removeList) {
        ArrayList newList = new ArrayList(list);
        Iterator removeIter = removeList.iterator();
        block0: while (removeIter.hasNext()) {
            String removeStr = (String)removeIter.next();
            Iterator newListIter = newList.iterator();
            while (newListIter.hasNext()) {
                String listName = (String)newListIter.next();
                if (listName == null || !listName.equalsIgnoreCase(removeStr)) continue;
                newListIter.remove();
                continue block0;
            }
        }
        return newList;
    }

    public static void resetSelectSqlOnNameConflict(com.metamatrix.query.sql.lang.Command command, EObject transMappingRoot, boolean isSignificant, Object source) {
        Query newQuery;
        if (command != null && command instanceof Query && TransformationSqlHelper.hasProjectedSymbolNameConflict((com.metamatrix.query.sql.lang.Command)command) && (newQuery = TransformationSqlHelper.createQueryFixNameConflicts((Query)((Query)command))) != null) {
            TransformationHelper.setSelectSqlString((Object)transMappingRoot, (String)newQuery.toString(), (boolean)isSignificant, (Object)source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTargetAttributes(EObject targetEObject, List attributeNames, Object source) {
        if (targetEObject != null && attributeNames != null && !attributeNames.isEmpty()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Add Target Attributes", (Object)source);
            boolean succeeded = false;
            try {
                String attrName = null;
                Iterator iter = attributeNames.iterator();
                while (iter.hasNext()) {
                    attrName = (String)iter.next();
                    Command paramToCreate = TransformationMappingHelper.getSqlColumnDescriptor(targetEObject);
                    if (paramToCreate == null) continue;
                    try {
                        EObject newEObject = ModelerCore.getModelEditor().createNewChildFromCommand(targetEObject, paramToCreate);
                        ModelerCore.getModelEditor().rename(newEObject, attrName);
                    }
                    catch (ModelerCoreException theException) {
                        String message = TransformationPlugin.Util.getString("TransformationMappingHelper.errorCreatingAttribute", (Object)attrName);
                        TransformationPlugin.Util.log(4, (Throwable)theException, message);
                    }
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private static Command getSqlColumnDescriptor(EObject targetEObject) {
        EObject eObj;
        Command colDescriptor = null;
        Collection descriptors = null;
        try {
            descriptors = ModelerCore.getModelEditor().getNewChildCommands(targetEObject);
        }
        catch (ModelerCoreException e) {
            String message = TransformationPlugin.Util.getString("TransformationMappingHelper.getChildDescriptorError", (Object)targetEObject.toString());
            TransformationPlugin.Util.log(4, (Throwable)e, message);
            return null;
        }
        Iterator iter = descriptors.iterator();
        while (iter.hasNext() && !SqlAspectHelper.isColumn((EObject)(eObj = (EObject)(colDescriptor = (Command)iter.next()).getResult().iterator().next()))) {
        }
        return colDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTargetAttributes(List attributeNames, Map sourceEObjectMap, EObject targetEObject, Object txnSource) {
        if (targetEObject != null && attributeNames != null && !attributeNames.isEmpty()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Add Target Attributes", (Object)txnSource);
            boolean succeeded = false;
            try {
                String attrName = null;
                Iterator iter = attributeNames.iterator();
                while (iter.hasNext()) {
                    attrName = (String)iter.next();
                    Command paramToCreate = TransformationMappingHelper.getSqlColumnDescriptor(targetEObject);
                    EObject srcEObj = (EObject)sourceEObjectMap.get(attrName);
                    try {
                        EObject newEObject = ModelerCore.getModelEditor().createNewChildFromCommand(targetEObject, paramToCreate);
                        ModelerCore.getModelEditor().rename(newEObject, attrName);
                        TransformationHelper.transferSqlColumnProperties((EObject)newEObject, (EObject)srcEObj, (Object)txnSource);
                    }
                    catch (ModelerCoreException e) {
                        String message = TransformationPlugin.Util.getString("TransformationMappingHelper.createNewAttrError", (Object)targetEObject.toString());
                        TransformationPlugin.Util.log(4, (Throwable)e, message);
                    }
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTargetAttributes(Object mappingRoot, List attributes, boolean isSignificant, Object source) {
        boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)"Add Target Attributes", (Object)source);
        boolean succeeded = false;
        try {
            SqlTransformationMappingRoot transMappingRoot = null;
            if (TransformationHelper.isSqlTransformationMappingRoot((Object)mappingRoot)) {
                transMappingRoot = (SqlTransformationMappingRoot)mappingRoot;
            }
            EObject virtualTarget = TransformationHelper.getTransformationTarget(transMappingRoot);
            ArrayList<EObject> deleteList = new ArrayList<EObject>();
            if (SqlAspectHelper.isTable((EObject)virtualTarget) || SqlAspectHelper.isColumnSet((EObject)virtualTarget)) {
                List columns = null;
                if (SqlAspectHelper.isTable((EObject)virtualTarget)) {
                    SqlTableAspect tableAspect = (SqlTableAspect)AspectManager.getSqlAspect((EObject)virtualTarget);
                    columns = tableAspect.getColumns(virtualTarget);
                } else if (SqlAspectHelper.isColumnSet((EObject)virtualTarget)) {
                    SqlColumnSetAspect columnSetAspect = (SqlColumnSetAspect)AspectManager.getSqlAspect((EObject)virtualTarget);
                    columns = columnSetAspect.getColumns(virtualTarget);
                }
                Iterator colIter = columns.iterator();
                while (colIter.hasNext()) {
                    SqlColumnAspect columnAspect;
                    EObject attr = (EObject)colIter.next();
                    if (!SqlAspectHelper.isColumn((EObject)attr) || !TransformationMappingHelper.containsName(attributes, (columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)attr)).getName(attr))) continue;
                    deleteList.add(attr);
                }
            }
            if (deleteList.size() > 0) {
                try {
                    ModelerCore.getModelEditor().delete(deleteList);
                }
                catch (ModelerCoreException e) {
                    String message = TransformationPlugin.Util.getString("TransformationMappingHelper.errorDeletingAttributes");
                    TransformationPlugin.Util.log(4, (Throwable)e, message);
                }
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private static boolean containsName(List attributes, String name) {
        boolean contains = false;
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            SqlColumnAspect columnAspect;
            String objName;
            EObject eObj = (EObject)iter.next();
            if (!SqlAspectHelper.isColumn((EObject)eObj) || !(objName = (columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)eObj)).getName(eObj)).equalsIgnoreCase(name)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static EObject getListAttrByName(List attributes, String name) {
        EObject result = null;
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            SqlColumnAspect columnAspect;
            String objName;
            EObject eObj = (EObject)iter.next();
            if (!SqlAspectHelper.isColumn((EObject)eObj) || !(objName = (columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)eObj)).getName(eObj)).equalsIgnoreCase(name)) continue;
            result = eObj;
            break;
        }
        return result;
    }

    public static boolean hasTypeConflict(Object attribute, Object symbol) {
        return !RuntimeTypeConverter.isExplicitMatch((Object)attribute, (Object)symbol);
    }

    public static boolean orderGroupAttributes(EObject transMappingRoot, boolean requiresValidSelect, com.metamatrix.query.sql.lang.Command modifiedCommand) {
        if (!TransformationHelper.isTargetGroupLocked((Object)transMappingRoot)) {
            boolean isValid = true;
            if (requiresValidSelect) {
                isValid = SqlMappingRootCache.isSelectValid((Object)transMappingRoot);
            }
            com.metamatrix.query.sql.lang.Command validCommand = null;
            if (isValid) {
                validCommand = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
                EObject targetGroup = TransformationHelper.getTransformationTarget((Object)transMappingRoot);
                List projectedSymbolNames = null;
                projectedSymbolNames = modifiedCommand != null && validCommand instanceof SetQuery ? TransformationSqlHelper.getProjectedSymbolUniqueNames((com.metamatrix.query.sql.lang.Command)modifiedCommand) : TransformationSqlHelper.getProjectedSymbolUniqueNames((com.metamatrix.query.sql.lang.Command)validCommand);
                return TransformationMappingHelper.orderGroupAttributes(targetGroup, projectedSymbolNames);
            }
        }
        return false;
    }

    private static boolean orderGroupAttributes(EObject groupEObject, List attrNames) {
        List columnIndices = TransformationMappingHelper.getColumnIndices(groupEObject);
        boolean attributeMoved = false;
        if (columnIndices.size() == attrNames.size()) {
            for (int i = 0; i < attrNames.size(); ++i) {
                String name = (String)attrNames.get(i);
                boolean wasMoved = TransformationMappingHelper.moveAttribute(groupEObject, name, (Integer)columnIndices.get(i));
                if (!wasMoved) continue;
                attributeMoved = wasMoved;
            }
        }
        return attributeMoved;
    }

    private static boolean setGroupAttributeTypes(EObject groupEObject, Map attrTypeMap) {
        boolean changed = false;
        EList children = groupEObject.eContents();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            EObject dtype;
            String colName;
            EObject child = (EObject)iter.next();
            if (!TransformationHelper.isSqlColumn((Object)child) || !attrTypeMap.containsKey(colName = TransformationHelper.getSqlEObjectName((EObject)child)) || (dtype = TransformationHelper.getSqlColumnDatatype((EObject)child)) != null) continue;
            TransformationMappingHelper.setAttributeType(child, attrTypeMap.get(colName));
            changed = true;
        }
        return changed;
    }

    public static boolean setGroupAttributeLengths(EObject groupEObject, Map attrLengthMap) {
        boolean changed = false;
        if (attrLengthMap != null && !attrLengthMap.isEmpty()) {
            EList children = groupEObject.eContents();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                SqlColumnAspect columnAspect;
                String targetColName;
                EObject child = (EObject)iter.next();
                if (!TransformationHelper.isSqlColumn((Object)child) || !attrLengthMap.containsKey(targetColName = TransformationHelper.getSqlEObjectName((EObject)child))) continue;
                int currentLength = TransformationHelper.getSqlColumnLength((EObject)child);
                int length = (Integer)attrLengthMap.get(targetColName);
                if (currentLength > 0 || length == -1 || !(columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)child)).canSetLength()) continue;
                TransformationMappingHelper.setAttributeLength(child, length);
                changed = true;
            }
        }
        return changed;
    }

    private static List getColumnIndices(EObject groupEObject) {
        ArrayList<Integer> columnIndices = new ArrayList<Integer>();
        EList children = groupEObject.eContents();
        for (int i = 0; i < children.size(); ++i) {
            if (!TransformationHelper.isSqlColumn(children.get(i))) continue;
            columnIndices.add(new Integer(i));
        }
        return columnIndices;
    }

    private static boolean moveAttribute(EObject groupEObject, String attrName, int newIndex) {
        EList children = groupEObject.eContents();
        boolean moved = false;
        Iterator iter = children.iterator();
        int index = 0;
        while (iter.hasNext()) {
            String currentAttrName;
            EObject eObj = (EObject)iter.next();
            if (TransformationHelper.isSqlColumn((Object)eObj) && (currentAttrName = TransformationHelper.getSqlEObjectName((EObject)eObj)).equalsIgnoreCase(attrName) && newIndex != index) {
                try {
                    ModelerCore.getModelEditor().move((Object)groupEObject, eObj, newIndex);
                    moved = true;
                }
                catch (ModelerCoreException err) {
                    String message = TransformationPlugin.Util.getString("TransformationMappingHelper.moveTargetAttrError", (Object)groupEObject.toString());
                    TransformationPlugin.Util.log(4, (Throwable)err, message);
                }
                break;
            }
            ++index;
        }
        return moved;
    }

    private static void setAttributeType(EObject attrEObject, Object typeObj) {
        if (TransformationHelper.isSqlColumn((Object)attrEObject)) {
            EObject newDatatype = TransformationMappingHelper.getDatatype(typeObj);
            EObject currentDatatype = TransformationHelper.getSqlColumnDatatype((EObject)attrEObject);
            if (newDatatype == null && currentDatatype != null || newDatatype != null && !newDatatype.equals(currentDatatype)) {
                TransformationHelper.setSqlColumnDatatype((EObject)attrEObject, (EObject)newDatatype, (Object)TransformationMappingHelper.getInstance());
            }
        }
    }

    private static void setAttributeLength(EObject attrEObject, int newLength) {
        int currentLength;
        if (TransformationHelper.isSqlColumn((Object)attrEObject) && newLength != (currentLength = TransformationHelper.getSqlColumnLength((EObject)attrEObject))) {
            TransformationHelper.setSqlColumnLength((EObject)attrEObject, (int)newLength, (Object)TransformationMappingHelper.getInstance());
        }
    }

    private static EObject getDatatype(Object typeObj) {
        EObject datatype = null;
        if (typeObj != null) {
            if (typeObj instanceof EObject) {
                EObject eObject = (EObject)typeObj;
                DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true);
                if (dtMgr.isSimpleDatatype(eObject)) {
                    datatype = (EObject)typeObj;
                }
            } else if (typeObj instanceof Class) {
                if (typeObj == (class$com$metamatrix$common$types$NullType == null ? (class$com$metamatrix$common$types$NullType = TransformationMappingHelper.class$("com.metamatrix.common.types.NullType")) : class$com$metamatrix$common$types$NullType)) {
                    typeObj = class$java$lang$String == null ? (class$java$lang$String = TransformationMappingHelper.class$("java.lang.String")) : class$java$lang$String;
                }
                String runtimeTypeName = DataTypeManager.getDataTypeName((Class)((Class)typeObj));
                datatype = TransformationMappingHelper.getDefaultDatatypeForRuntimeTypeName(runtimeTypeName);
            }
        }
        return datatype;
    }

    public static EObject getDefaultDatatypeForRuntimeTypeName(String runtimeTypeName) {
        DatatypeManager dtMgr;
        EObject datatype = null;
        EObject typeEObj = null;
        try {
            typeEObj = ModelerCore.getWorkspaceDatatypeManager().getDefaultDatatypeForRuntimeTypeName(runtimeTypeName);
        }
        catch (ModelerCoreException e) {
            String message = TransformationPlugin.Util.getString("TransformationMappingHelper.errorFindingDefaultType", (Object)runtimeTypeName);
            TransformationPlugin.Util.log(4, (Throwable)e, message);
        }
        if (typeEObj != null && (dtMgr = ModelerCore.getDatatypeManager((EObject)typeEObj, (boolean)true)).isSimpleDatatype(typeEObj)) {
            return typeEObj;
        }
        return datatype;
    }

    private static boolean isReadOnly(EObject theEObject) {
        ModelResource modelResource;
        boolean result = true;
        if (theEObject != null && (modelResource = ModelerCore.getModelEditor().findModelResource(theEObject)) != null) {
            result = ModelUtil.isIResourceReadOnly((IResource)modelResource.getResource());
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

