/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.xml;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.processor.xml.NodeDescriptor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class Element {
    static final String DEFAULT_ATTRIBUTE_TYPE = "CDATA";
    static final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();
    private NodeDescriptor descriptor;
    private AttributesImpl attributes;
    private String content;
    private String comment;
    private boolean isOptional;
    private final boolean wasOptional;
    private boolean elementStarted;
    private boolean elementEnded;
    private Element parent;
    private List children = new LinkedList();
    private NodeDescriptor nillableDescriptor;
    private TransformerHandler handler;

    Element(NodeDescriptor descripter, TransformerHandler handler) {
        this.descriptor = descripter;
        this.handler = handler;
        this.isOptional = descripter.isOptional();
        this.wasOptional = descripter.isOptional();
    }

    void setAttribute(NodeDescriptor descriptor, String value) {
        if (this.elementStarted) {
            Assertion.failed((String)"Attributes must not be added to Element after Element is started.");
        }
        if (this.attributes == null) {
            this.attributes = new AttributesImpl();
        }
        this.attributes.addAttribute(descriptor.getNamespaceURI(), descriptor.getName(), descriptor.getQName(), DEFAULT_ATTRIBUTE_TYPE, value);
    }

    void setParent(Element parent) {
        this.parent = parent;
    }

    Element getParent() {
        return this.parent;
    }

    void startElement() throws SAXException {
        if (this.elementStarted) {
            return;
        }
        Properties namespaceURIs = this.descriptor.getNamespaceURIs();
        if (namespaceURIs != null) {
            Iterator<Map.Entry<Object, Object>> iter = namespaceURIs.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Object, Object> namespaceURI = iter.next();
                String prefix = (String)namespaceURI.getKey();
                String uri = (String)namespaceURI.getValue();
                if (this.parent != null && uri.equals(this.parent.getNamespaceURI(prefix)) || uri.length() <= 0) continue;
                this.handler.startPrefixMapping(prefix, uri);
            }
        }
        if (this.attributes == null) {
            this.attributes = EMPTY_ATTRIBUTES;
        }
        this.handler.startElement(this.descriptor.getNamespaceURI(), this.descriptor.getName(), this.descriptor.getQName(), this.attributes);
        if (this.comment != null) {
            this.handler.comment(this.comment.toCharArray(), 0, this.comment.length());
        }
        if (this.content != null) {
            this.handler.characters(this.content.toCharArray(), 0, this.content.length());
        }
        this.attributes = null;
        this.content = null;
        this.isOptional = false;
        this.elementStarted = true;
    }

    void setContent(String content) {
        this.content = content;
    }

    void endElement() throws SAXException {
        if (this.elementEnded) {
            return;
        }
        this.handler.endElement(this.descriptor.getNamespaceURI(), this.descriptor.getName(), this.descriptor.getQName());
        Properties namespaceURIs = this.descriptor.getNamespaceURIs();
        if (namespaceURIs != null) {
            Iterator<Map.Entry<Object, Object>> iter = namespaceURIs.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Object, Object> namespaceURI = iter.next();
                String prefix = (String)namespaceURI.getKey();
                String uri = (String)namespaceURI.getValue();
                if (this.parent != null && uri.equals(this.parent.getNamespaceURI(prefix))) continue;
                this.handler.endPrefixMapping(prefix);
            }
        }
        this.elementEnded = true;
    }

    void setComment(String comment) {
        if (this.elementStarted) {
            Assertion.failed((String)"Comment must not be added to Element after Element is started.");
        }
        this.comment = comment;
    }

    String getNamespaceURI(String namespacePrefix) {
        String uri;
        Properties namespaceURIs = this.descriptor.getNamespaceURIs();
        if (namespaceURIs != null && (uri = (String)namespaceURIs.get(namespacePrefix)) != null) {
            return uri;
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(namespacePrefix);
        }
        return null;
    }

    boolean hadOptionalParent() {
        if (this.parent != null) {
            if (this.parent.wasOptional()) {
                return true;
            }
            return this.parent.hadOptionalParent();
        }
        return false;
    }

    boolean isOptional() {
        return this.isOptional;
    }

    void setOptional(boolean b) {
        this.isOptional = b;
    }

    public String toString() {
        return this.descriptor.getQName();
    }

    boolean isChildOf(Element elementToRemove) {
        boolean isChild = false;
        for (Element parentObj = this.parent; parentObj != null; parentObj = parentObj.getParent()) {
            if (parentObj != elementToRemove) continue;
            isChild = true;
            break;
        }
        return isChild;
    }

    public NodeDescriptor getNillableDescriptor() {
        return this.nillableDescriptor;
    }

    public void setNillableDescriptor(NodeDescriptor nillableDescriptor) {
        this.nillableDescriptor = nillableDescriptor;
    }

    public boolean isElementStarted() {
        return this.elementStarted;
    }

    public List getChildren() {
        return this.children;
    }

    public void addChild(Element child) {
        this.children.add(child);
    }

    public boolean wasOptional() {
        return this.wasOptional;
    }
}

