/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.http;

import com.metamatrix.connector.xml.DocumentProducer;
import com.metamatrix.connector.xml.SAXFilterProvider;
import com.metamatrix.connector.xml.XMLConnection;
import com.metamatrix.connector.xml.XMLConnectorState;
import com.metamatrix.connector.xml.XMLExecution;
import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.DocumentBuilder;
import com.metamatrix.connector.xml.base.DocumentInfo;
import com.metamatrix.connector.xml.base.ExecutionInfo;
import com.metamatrix.connector.xml.base.RequestGenerator;
import com.metamatrix.connector.xml.base.RequestResponseDocumentProducer;
import com.metamatrix.connector.xml.base.Response;
import com.metamatrix.connector.xml.base.XMLConnectionImpl;
import com.metamatrix.connector.xml.base.XMLDocument;
import com.metamatrix.connector.xml.cache.DocumentCache;
import com.metamatrix.connector.xml.http.HTTPConnectorState;
import com.metamatrix.connector.xml.http.HTTPRequestor;
import com.metamatrix.connector.xml.http.HTTPTrustDeserializer;
import com.metamatrix.connector.xml.http.HttpInfo;
import com.metamatrix.connector.xml.http.Messages;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jdom.Document;

public class HTTPExecutor
extends RequestResponseDocumentProducer {
    private ConnectorLogger m_logger = this.getLogger();
    protected HTTPRequestor m_requestor;
    protected HttpMethod request;
    private HTTPConnectorState h_state;
    private boolean m_allowHttp500;
    public static final String PARM_INPUT_XPATH_TABLE_PROPERTY_NAME = "XPathRootForInput";
    public static final String PARM_INPUT_NAMESPACE_TABLE_PROPERTY_NAME = "NamespaceForDocument";

    public HTTPExecutor(XMLConnectorState state, XMLExecution execution) throws ConnectorException {
        super(state, execution);
        this.h_state = (HTTPConnectorState)state;
        this.m_requestor = new HTTPRequestor(this.m_logger, this.h_state.getAccessMethod());
        this.setAllowHttp500(false);
        try {
            String uri = this.buildRawUriString();
            this.m_requestor.validateURL(uri);
        }
        catch (IOException ioe) {
            throw new ConnectorException((Throwable)ioe);
        }
        this.m_logger.logDetail("XML Connector Framework: http url was validated. URL appears to be valid");
    }

    public void releaseDocumentStream(int i) throws ConnectorException {
        if (this.request != null) {
            this.request.releaseConnection();
            this.request = null;
        }
    }

    public int getDocumentCount() throws ConnectorException {
        return 1;
    }

    public String getCacheKey(int i) throws ConnectorException {
        if (this.request == null) {
            String message = Messages.getString((String)"HttpExecutor.cannot.create.cachekey");
            throw new ConnectorException(message);
        }
        String userName = this.getExecution().getConnection().getUser();
        String session = this.getExecution().getConnection().getQueryId();
        StringBuffer cacheKey = new StringBuffer();
        cacheKey.append("|");
        cacheKey.append(userName);
        cacheKey.append("|");
        cacheKey.append(session);
        cacheKey.append("|");
        cacheKey.append(this.buildUriString());
        cacheKey.append("|");
        if (this.request instanceof PostMethod) {
            NameValuePair[] pairs = ((PostMethod)this.request).getParameters();
            if (pairs == null || pairs.length == 0) {
                if (((PostMethod)this.request).getRequestEntity() != null) {
                    String requestBodyAsString = ((StringRequestEntity)((PostMethod)this.request).getRequestEntity()).getContent();
                    cacheKey.append(requestBodyAsString);
                }
            } else {
                cacheKey.append(this.generatePairString(pairs));
            }
        } else {
            cacheKey.append(this.request.getQueryString());
        }
        return cacheKey.toString();
    }

    public InputStream getDocumentStream(int i) throws ConnectorException {
        HttpClient client = ((HTTPConnectorState)this.getState()).getClient();
        XMLConnection conn = this.getExecution().getConnection();
        try {
            HTTPTrustDeserializer ser = (HTTPTrustDeserializer)conn.getTrustedPayloadHandler();
            ser.modifyRequest(client, this.request);
        }
        catch (ClassCastException cce) {
            throw new ConnectorException(Messages.getString((String)"HTTPExecutor.class.not.instance.of.HTTPTrustDeserializer"));
        }
        catch (Exception e) {
            ConnectorException ce = new ConnectorException(Messages.getString((String)"HTTPExecutor.unable.to.create.trust.deserializer"));
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
        this.modifyRequest(client, this.request);
        InputStream responseBody = this.m_requestor.fetchXMLDocument(client, this.request, this.getAllowHttp500());
        return responseBody;
    }

    public Response getXMLResponse() throws ConnectorException {
        this.createRequests();
        DocumentCache cache = this.getExecution().getCache();
        CriteriaDesc criterion = this.getExecutionInfo().getResponseIDCriterion();
        if (null != criterion) {
            String responseid = (String)criterion.getValues().get(0);
            return new Response(responseid, (DocumentProducer)this, cache, this.h_state.isCacheEnabled(), this.h_state.isErrorOnRecreateDoc());
        }
        int documentCount = this.getDocumentCount();
        String[] cacheKeys = new String[documentCount];
        XMLDocument[] docs = new XMLDocument[documentCount];
        for (int i = 0; i < documentCount; ++i) {
            String cacheKey = this.getCacheKey(i);
            XMLDocument doc = DocumentCache.cacheLookup((DocumentCache)cache, (String)cacheKey, (boolean)this.h_state.isCacheEnabled());
            if (doc == null) {
                String documentDistinguishingId = "";
                if (documentCount > 1) {
                    documentDistinguishingId = new Integer(i).toString();
                }
                SAXFilterProvider provider = null;
                provider = this.h_state.getSAXFilterProvider();
                InputStream responseBody = this.getDocumentStream(i);
                DocumentInfo info = this.xmlExtractor.createDocumentFromStream(responseBody, documentDistinguishingId, provider);
                Document domDoc = info.m_domDoc;
                doc = new XMLDocument((Object)domDoc, info.m_externalFiles);
                if (this.getState().isCacheEnabled()) {
                    cache.addToCache(cacheKey, (Object)doc, info.m_memoryCacheSize);
                }
            }
            docs[i] = doc;
            cacheKeys[i] = cacheKey;
        }
        return new Response(docs, cacheKeys, (DocumentProducer)this, cache, this.h_state.isCacheEnabled(), this.h_state.isErrorOnRecreateDoc());
    }

    private void createRequests() throws ConnectorException {
        if (HTTPExecutor.checkIfRequestIsNeeded((ExecutionInfo)this.getExecutionInfo())) {
            String uriString = this.buildUriString();
            this.setRequests(this.getExecutionInfo().getParameters(), uriString);
        }
    }

    protected void setStdRequestHeaders(HttpMethod method) {
        String contentTypeHeader = "Content-Type";
        String cType = "text/xml; charset=utf-8";
        String userAgentHeader = "User-Agent";
        String uAgent = "MetaMatrix Server";
        Header contentType = new Header("Content-Type", "text/xml; charset=utf-8");
        method.addRequestHeader(contentType);
        Header userAgent = new Header("User-Agent", "MetaMatrix Server");
        method.addRequestHeader(userAgent);
    }

    protected void modifyRequest(HttpClient client, HttpMethod method) throws ConnectorException {
    }

    public boolean cannotProjectParameter(CriteriaDesc parmCriteria) {
        return parmCriteria.getNumberOfValues() > 1 && parmCriteria.isUnlimited() && ((HTTPConnectorState)this.getState()).getParameterMethod() != "Name/Value";
    }

    protected Document buildInputXMLDocument(List parameters, String inputParmsXPath) throws ConnectorException {
        String namespacePrefixes = this.getExecutionInfo().getOtherProperties().getProperty("NamespacePrefixes");
        DocumentBuilder builder = new DocumentBuilder();
        return builder.buildDocument(parameters, inputParmsXPath, namespacePrefixes);
    }

    protected NameValuePair[] createNameValuePairs(List paramPairs) throws ConnectorException {
        NameValuePair[] pairs = new NameValuePair[paramPairs.size()];
        for (int i = 0; i < pairs.length; ++i) {
            NameValuePair pair;
            CriteriaDesc cd = (CriteriaDesc)paramPairs.get(i);
            String name = cd.getInputXpath() == null || cd.getInputXpath().length() == 0 ? cd.getColumnName() : cd.getInputXpath();
            pairs[i] = pair = new NameValuePair(name, cd.getCurrentIndexValue());
        }
        return pairs;
    }

    protected void setRequests(List params, String uriString) throws ConnectorException {
        String xmlDoc = null;
        HTTPConnectorState state = (HTTPConnectorState)this.getState();
        if (state.getParameterMethod() == "None" || params.size() == 0) {
            this.m_logger.logTrace("XML Connector Framework: no parameters for request");
        }
        ArrayList requestPerms = RequestGenerator.getRequestPerms((List)params);
        for (int i = 0; i < requestPerms.size(); ++i) {
            NameValuePair[] pairs = null;
            HttpMethod method = this.m_requestor.generateMethod(uriString);
            this.setStdRequestHeaders(method);
            CriteriaDesc[] queryParameters = (CriteriaDesc[])requestPerms.get(i);
            List<CriteriaDesc> newList = Arrays.asList(queryParameters);
            ArrayList<CriteriaDesc> queryList = new ArrayList<CriteriaDesc>(newList);
            if (state.getParameterMethod() == "XMLRequest") {
                xmlDoc = this.createXMLRequestDocString(queryList);
            }
            if (xmlDoc != null && state.getXmlParameterName() != null) {
                pairs = new NameValuePair[]{new NameValuePair(state.getXmlParameterName(), xmlDoc)};
            }
            if (pairs != null) {
                this.attemptConditionalLog("XML Connector Framework: request parameters -\n " + this.generatePairString(pairs));
            }
            if (xmlDoc == null && pairs == null) {
                pairs = this.createNameValuePairs(queryList);
            }
            if (method instanceof PostMethod) {
                PostMethod post = (PostMethod)method;
                if (pairs == null) {
                    if (state.getXmlParameterName() != null) {
                        StringBuffer requestEntity = new StringBuffer();
                        requestEntity.append(post.getQueryString());
                        requestEntity.append('?');
                        requestEntity.append(state.getXmlParameterName());
                        requestEntity.append('=');
                        requestEntity.append(xmlDoc);
                        post.setRequestEntity((RequestEntity)new StringRequestEntity(requestEntity.toString()));
                        post.setQueryString(requestEntity.toString());
                    } else {
                        post.setRequestEntity((RequestEntity)new StringRequestEntity(xmlDoc));
                    }
                    this.attemptConditionalLog("XML Connector Framework: request body set to: " + xmlDoc);
                } else {
                    this.addPostValues(pairs, post);
                    this.attemptConditionalLog("XML Connector Framework: request parameters -\n " + this.generatePairString(pairs));
                }
            } else {
                if (pairs == null) {
                    throw new ConnectorException(Messages.getString((String)"HTTPExecutor.parameter.name.required.for.get"));
                }
                this.addGetValues(pairs, method);
                this.attemptConditionalLog("XML Connector Framework: request paramters -\n " + this.generatePairString(pairs));
            }
            this.request = method;
            this.m_logger.logInfo("XML Connector Framework: request created");
        }
    }

    protected void addGetValues(NameValuePair[] pairs, HttpMethod method) throws ConnectorException {
        method.setQueryString(pairs);
    }

    protected void addPostValues(NameValuePair[] pairs, PostMethod method) throws ConnectorException {
        method.addParameters(pairs);
    }

    protected Document createXMLRequestDoc(List parameterPairs) throws ConnectorException {
        Properties props = this.getExecutionInfo().getOtherProperties();
        String inputParmsXPath = props.getProperty(PARM_INPUT_XPATH_TABLE_PROPERTY_NAME);
        Document inputXMLDoc = this.buildInputXMLDocument(parameterPairs, inputParmsXPath);
        return inputXMLDoc;
    }

    protected String createXMLRequestDocString(List parameterPairs) throws ConnectorException {
        Document inputXMLDoc = this.createXMLRequestDoc(parameterPairs);
        String xmlStr = HTTPRequestor.outputStringFromDoc((Document)inputXMLDoc);
        return xmlStr;
    }

    private String buildUriString() {
        String uriString = "<" + this.buildRawUriString() + ">";
        this.m_logger.logDetail("XML Connector Framework: using url " + uriString);
        return uriString;
    }

    private String buildRawUriString() {
        String location = this.getExecutionInfo().getLocation();
        if (location != null) {
            try {
                new URL(location);
                return location;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (location == null) {
            String tableServletCallPathProp = "ServletCallPathforURL";
            location = this.getExecutionInfo().getOtherProperties().getProperty("ServletCallPathforURL");
        }
        String retval = ((HTTPConnectorState)this.getState()).getUri();
        if (location != null && location.trim().length() > 0) {
            retval = retval + "/" + location;
        }
        return retval;
    }

    private String generatePairString(NameValuePair[] pairs) {
        StringBuffer pairString = new StringBuffer();
        for (int j = 0; j < pairs.length; ++j) {
            if (j > 0) {
                pairString.append("&");
            }
            pairString.append(pairs[j].getName());
            pairString.append("=");
            pairString.append(pairs[j].getValue());
        }
        return pairString.toString();
    }

    protected NameValuePair[] generatePairs(String pairString) {
        int numPairs = 1;
        String dummy = pairString;
        while (dummy.indexOf(38) >= 0) {
            ++numPairs;
            dummy = dummy.substring(dummy.indexOf(38));
        }
        NameValuePair[] pairs = new NameValuePair[numPairs];
        dummy = pairString;
        int ctr = 0;
        if (numPairs > 1) {
            String value;
            String name;
            while (dummy.indexOf(38) >= 0) {
                name = dummy.substring(0, dummy.indexOf(61));
                value = dummy.substring(dummy.indexOf(61), dummy.indexOf(38));
                pairs[ctr] = new NameValuePair(name, value);
                ++ctr;
            }
            name = dummy.substring(0, dummy.indexOf(61));
            value = dummy.substring(dummy.indexOf(61), dummy.indexOf(38));
            pairs[ctr] = new NameValuePair(name, value);
        }
        return pairs;
    }

    public Serializable getRequestObject(int i) throws ConnectorException {
        HttpMethod method = this.request;
        HttpInfo newInfo = new HttpInfo();
        newInfo.m_distinguishingId = i;
        try {
            newInfo.m_uri = method.getURI().getEscapedURI();
        }
        catch (URIException urie) {
            ConnectorException ce = new ConnectorException(Messages.getString((String)"HTTPExecutor.unable.to.recreate.uri"));
            ce.setStackTrace(urie.getStackTrace());
            throw ce;
        }
        if (method instanceof GetMethod) {
            newInfo.m_request = method.getQueryString();
            newInfo.m_method = "GET";
            newInfo.m_paramMethod = null;
        } else {
            newInfo.m_method = "POST";
            NameValuePair[] pairs = ((PostMethod)method).getParameters();
            if (pairs == null) {
                newInfo.m_paramMethod = "ResponseBody";
                newInfo.m_request = ((StringRequestEntity)((PostMethod)method).getRequestEntity()).getContent();
                if (newInfo.m_request == null) {
                    ConnectorException ce = new ConnectorException(Messages.getString((String)"HTTPExecutor.unable.to.recreate.request"));
                    throw ce;
                }
            } else {
                newInfo.m_paramMethod = "NameValuePairs";
                newInfo.m_request = this.generatePairString(pairs);
            }
        }
        return newInfo;
    }

    public XMLDocument recreateDocument(Serializable requestObject) throws ConnectorException {
        HttpInfo info = (HttpInfo)requestObject;
        XMLDocument doc = null;
        HTTPConnectorState state = (HTTPConnectorState)this.getState();
        String accMethod = state.getAccessMethod();
        HTTPRequestor req = new HTTPRequestor(this.m_logger, accMethod);
        HttpMethod method = req.generateMethod(info.m_uri);
        this.setStdRequestHeaders(method);
        if (method instanceof GetMethod) {
            method.setQueryString(info.m_request);
        } else if (info.m_paramMethod == "NameValuePairs") {
            NameValuePair[] pairs = this.generatePairs(info.m_request);
            ((PostMethod)method).addParameters(pairs);
        } else {
            ((PostMethod)method).setRequestEntity((RequestEntity)new StringRequestEntity(info.m_request));
        }
        HttpClient client = ((HTTPConnectorState)this.getState()).getClient();
        XMLConnectionImpl conn = (XMLConnectionImpl)this.getExecution().getConnection();
        try {
            HTTPTrustDeserializer trust = (HTTPTrustDeserializer)conn.getTrustedPayloadHandler();
            trust.modifyRequest(client, method);
        }
        catch (ClassCastException cce) {
            throw new ConnectorException(Messages.getString((String)"HTTPExecutor.class.not.instance.of.HTTPTrustDeserializer"));
        }
        catch (Exception e) {
            ConnectorException ce = new ConnectorException(Messages.getString((String)"HTTPExecutor.unable.to.create.trust.deserializer"));
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
        this.modifyRequest(client, method);
        InputStream responseBody = this.m_requestor.fetchXMLDocument(client, method, this.getAllowHttp500());
        SAXFilterProvider provider = this.getState().getSAXFilterProvider();
        DocumentInfo docInfo = this.getExtractor().createDocumentFromStream(responseBody, Integer.toString(info.m_distinguishingId), provider);
        doc = new XMLDocument();
        doc.setContextRoot((Object)docInfo.m_domDoc);
        doc.setExternalFiles(docInfo.m_externalFiles);
        return doc;
    }

    protected void attemptConditionalLog(String message) {
        if (this.getState().isLogRequestResponse()) {
            this.m_logger.logInfo(message);
        }
    }

    public void setAllowHttp500(boolean allowHttp500) {
        this.m_allowHttp500 = allowHttp500;
    }

    public boolean getAllowHttp500() {
        return this.m_allowHttp500;
    }
}

