/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process.validator;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.process.multisource.MultiSourceElement;
import com.metamatrix.dqp.service.AuthorizationService;
import com.metamatrix.query.c.c;
import com.metamatrix.query.f.c.k;
import com.metamatrix.query.m.e;
import com.metamatrix.query.o.h.d;
import com.metamatrix.query.o.i.a;
import com.metamatrix.query.o.i.f;
import com.metamatrix.query.o.j.af;
import com.metamatrix.query.o.j.ag;
import com.metamatrix.query.o.j.aj;
import com.metamatrix.query.o.j.g;
import com.metamatrix.query.o.j.i;
import com.metamatrix.query.o.j.l;
import com.metamatrix.query.o.j.n;
import com.metamatrix.query.o.j.x;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AuthorizationValidationVisitor
extends c {
    public static final String GET_UPDATED_CHARACTER_VDB_RESOURCE = "System.getUpdatedCharacterVDBResource";
    private static Set globallyAccessibleProcedures = new HashSet();
    private String connectionID;
    private AuthorizationService authInterface;

    public AuthorizationValidationVisitor(String connectionID, AuthorizationService authInterface) {
        this.connectionID = connectionID;
        this.authInterface = authInterface;
    }

    public void visit(i obj) {
        this.validateEntitlements(obj);
    }

    public void visit(af obj) {
        this.validateEntitlements(obj);
    }

    public void visit(ag obj) {
        this.validateEntitlements(obj);
    }

    public void visit(g obj) {
        this.validateEntitlements(obj);
    }

    public void visit(x obj) {
        this.validateEntitlements(obj);
    }

    protected void validateEntitlements(af obj) {
        this.validateEntitlements(obj.iz(), 1, 1);
    }

    protected void validateEntitlements(g obj) {
        if (obj.hi() != null) {
            this.validateEntitlements(com.metamatrix.query.o.h.k.fb(obj.hi(), true), 0, 2);
        }
        HashSet changeVars = new HashSet();
        Iterator iter = obj.hd().iterator();
        while (iter.hasNext()) {
            aj crit = (aj)iter.next();
            com.metamatrix.query.o.h.k.e9((com.metamatrix.query.o.d)crit, changeVars);
        }
        this.validateEntitlements(changeVars, 2, 2);
    }

    protected void validateEntitlements(i obj) {
        if (obj.hn() != null) {
            this.validateEntitlements(com.metamatrix.query.o.h.k.fb(obj.hn(), true), 0, 3);
        }
        HashSet<f> deleteVars = new HashSet<f>();
        deleteVars.add(obj.hk());
        this.validateEntitlements(deleteVars, 3, 3);
    }

    protected void validateEntitlements(ag obj) {
        n intoObj = obj.jw();
        if (intoObj != null) {
            f intoGroup = intoObj.j4();
            List intoElements = null;
            try {
                intoElements = k.o((f)intoGroup, (e)this.getMetadata());
            }
            catch (QueryMetadataException err) {
                this.handleException((MetaMatrixException)((Object)err), (com.metamatrix.query.o.d)intoGroup);
            }
            catch (QueryResolverException err) {
                this.handleException((MetaMatrixException)((Object)err), (com.metamatrix.query.o.d)intoGroup);
            }
            catch (MetaMatrixComponentException err) {
                this.handleException((MetaMatrixException)((Object)err), (com.metamatrix.query.o.d)intoGroup);
            }
            this.validateEntitlements(intoElements, 1, 1);
        }
        Collection entitledObjects = d.ek((com.metamatrix.query.o.d)obj, true);
        if (!this.isXMLCommand((l)obj)) {
            entitledObjects.addAll(com.metamatrix.query.o.h.k.fb((com.metamatrix.query.o.d)obj, true));
        }
        ArrayList remove = null;
        Iterator iter = entitledObjects.iterator();
        while (iter.hasNext()) {
            Object symbol = iter.next();
            if (symbol instanceof a) {
                if (!(((a)symbol).bf() instanceof com.metamatrix.query.m.d)) continue;
                if (remove == null) {
                    remove = new ArrayList();
                }
                remove.add(symbol);
                continue;
            }
            if (!(((f)symbol).aq() instanceof com.metamatrix.query.m.d)) continue;
            if (remove == null) {
                remove = new ArrayList();
            }
            remove.add(symbol);
        }
        if (remove != null) {
            entitledObjects.removeAll(remove);
        }
        if (entitledObjects.size() == 0) {
            return;
        }
        this.validateEntitlements(entitledObjects, 0, 0);
    }

    public static void addGloballyAccessibleProcedure(String name) {
        globallyAccessibleProcedures.add(name);
    }

    public static void removeGloballyAccessibleProcedure(String name) {
        globallyAccessibleProcedures.remove(name);
    }

    protected void validateEntitlements(x obj) {
        if (globallyAccessibleProcedures.contains(obj.h7())) {
            return;
        }
        ArrayList<f> symbols = new ArrayList<f>(1);
        symbols.add(obj.h4());
        this.validateEntitlements(symbols, 0, 4);
    }

    private String getActionLabel(int actionCode) {
        switch (actionCode) {
            case 0: {
                return "Read";
            }
            case 1: {
                return "Create";
            }
            case 2: {
                return "Update";
            }
            case 3: {
                return "Delete";
            }
        }
        return "UNKNOWN";
    }

    protected void validateEntitlements(Collection symbols, int actionCode, int auditContext) {
        HashMap nameToSymbolMap = new HashMap();
        Iterator symbolIter = symbols.iterator();
        while (symbolIter.hasNext()) {
            Object symbol = symbolIter.next();
            try {
                String fullName = null;
                if (symbol instanceof a) {
                    Object metadataID = ((a)symbol).bf();
                    if (metadataID instanceof MultiSourceElement) continue;
                    fullName = this.getMetadata().getFullName(metadataID);
                } else if (symbol instanceof f) {
                    fullName = this.getMetadata().getFullName(((f)symbol).aq());
                }
                nameToSymbolMap.put(fullName, symbol);
            }
            catch (QueryMetadataException e2) {
                this.handleException((MetaMatrixException)((Object)e2));
            }
            catch (MetaMatrixComponentException e3) {
                this.handleException((MetaMatrixException)((Object)e3));
            }
        }
        if (symbols.size() > 0) {
            try {
                Collection inaccessibleResources = this.authInterface.getInaccessibleResources(this.connectionID, actionCode, nameToSymbolMap.keySet(), auditContext);
                if (inaccessibleResources.size() > 0) {
                    ArrayList inaccessibleSymbols = new ArrayList(inaccessibleResources.size());
                    Iterator nameIter = inaccessibleResources.iterator();
                    while (nameIter.hasNext()) {
                        String name = (String)nameIter.next();
                        inaccessibleSymbols.add(nameToSymbolMap.get(name));
                    }
                    this.handleValidationError(DQPPlugin.Util.getString("ERR.018.005.0095", new Object[]{this.connectionID, this.getActionLabel(actionCode)}), inaccessibleSymbols);
                }
            }
            catch (MetaMatrixComponentException e4) {
                this.handleException((MetaMatrixException)((Object)e4));
            }
        }
    }

    static {
        globallyAccessibleProcedures.add(GET_UPDATED_CHARACTER_VDB_RESOURCE);
    }
}

