/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.http;

import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class HTTPRequestor {
    private ConnectorLogger m_logger;
    private String m_accessMethod;
    public static final int HttpRetryCount = 3;
    public static final boolean HttpEnableRetry = true;

    public HTTPRequestor(ConnectorLogger logger, String accessMethod) {
        this.m_logger = logger;
        this.m_accessMethod = accessMethod;
    }

    private InputStream executeMethod(HttpClient client, HttpMethod method) throws ConnectorException {
        InputStream responseBody = null;
        try {
            DefaultHttpMethodRetryHandler handler = new DefaultHttpMethodRetryHandler(3, true);
            client.executeMethod(method);
            responseBody = method.getResponseBodyAsStream();
            if (responseBody == null) {
                int code = method.getStatusCode();
                int httpGood = 200;
                if (code != 200) {
                    this.m_logger.logError("Http Error: " + code + " - " + method.getStatusText());
                    throw new ConnectorException("Bad Http response:" + code + " - " + method.getStatusText());
                }
            }
        }
        catch (HttpException he) {
            String excStr = "XML Connector Framework: Http error connecting";
            this.m_logger.logError(excStr, (Throwable)he);
            he.printStackTrace();
            throw new ConnectorException(excStr);
        }
        catch (IOException ioe) {
            String excStr = "XML Connector Framework: Unable to connect";
            this.m_logger.logError(excStr, (Throwable)ioe);
            ioe.printStackTrace();
            throw new ConnectorException(excStr);
        }
        return responseBody;
    }

    public HttpMethod generateMethod(String uriString) {
        GetMethod method = null;
        if (this.m_accessMethod.equals("GET")) {
            method = new GetMethod(uriString);
            method.setFollowRedirects(true);
        } else {
            method = new PostMethod(uriString);
            method.setFollowRedirects(false);
        }
        method.getParams().makeLenient();
        return method;
    }

    public InputStream fetchXMLDocument(HttpClient client, HttpMethod method) throws ConnectorException {
        InputStream responseBody = null;
        responseBody = this.executeMethod(client, method);
        if (responseBody == null) {
            String excStr = "XML Connector Framework: No response was received  '" + client.getHostConfiguration().getHost() + ":" + client.getHostConfiguration().getPort();
            this.m_logger.logError(excStr);
            throw new ConnectorException(excStr);
        }
        this.m_logger.logDetail("XML Connector Framework: Http method executed.");
        byte[] emptyDocument = "<emptyDoc/>".getBytes();
        if (responseBody == null) {
            this.m_logger.logDetail("XML Connector Framework: response was empty.");
            responseBody = new ByteArrayInputStream(emptyDocument);
        }
        return responseBody;
    }

    public void validateURL(String uri) throws IOException {
        URL url = new URL(uri);
        URLConnection conn = url.openConnection();
        conn.connect();
    }

    protected static String outputStringFromDoc(Document doc) {
        XMLOutputter out = new XMLOutputter();
        return out.outputString(doc).trim();
    }
}

