/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.commons.LoggingConnector;
import com.metamatrix.connector.commons.cache.DocumentCache;
import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.connector.xml.base.XMLConnection;
import com.metamatrix.connector.xml.base.XMLConnectorState;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import java.util.Properties;

public class XMLConnector
extends LoggingConnector {
    private XMLConnectorState m_state;
    private DocumentCache m_documentCache;
    private DocumentCache m_statementCache;

    public void initialize(ConnectorEnvironment env) throws ConnectorException {
        try {
            super.initialize(env);
            this.getLogger().logInfo("XML Connector Framework: connector has been initialized");
            this.getLogger().logTrace("XML Connector Framework: connector init properties: " + this.getEnvironment().getProperties());
            this.m_state = this.createState(env.getProperties());
            this.m_state.checkLicense();
            this.m_documentCache = new DocumentCache(this.m_state.getMaxMemoryCacheSizeByte(), this.m_state.getMaxFileCacheSizeByte(), this.m_state.getCacheLocation(), this.m_state.getCacheTimeoutMillis(), this.getLogger(), env.getConnectorName(), true);
            this.m_statementCache = new DocumentCache(0x3FFFFFFF, 0, this.m_state.getCacheLocation(), 0x3FFFFFFF, this.getLogger(), env.getConnectorName() + "_STMT", false);
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public void start() throws ConnectorException {
        try {
            this.getLogger().logInfo("XML Connector Framework: connector has been started");
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public void stop() {
        ConnectorLogger logger;
        if (this.m_documentCache != null) {
            this.m_documentCache.shutdownCleaner();
        }
        if ((logger = this.getLogger()) != null) {
            this.getLogger().logInfo("XML Connector Framework: connector has been stopped");
        }
    }

    public Connection getConnection(SecurityContext context) throws ConnectorException {
        try {
            if (this.m_state == null) {
                throw new ConnectorException(Messages.getString("XMLConnector.state.not.set"));
            }
            return new XMLConnection(this, context, this.getEnvironment());
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private XMLConnectorState createState(Properties props) throws ConnectorException {
        String stateClassName = props.getProperty("ConnectorStateClass");
        XMLConnectorState state = null;
        try {
            state = (XMLConnectorState)Class.forName(stateClassName).newInstance();
            state.setState(props);
        }
        catch (Exception e) {
            ConnectorException ce = new ConnectorException(Messages.getString("XMLConnector.could.not.create.state") + stateClassName);
            ce.initCause((Throwable)e);
            throw ce;
        }
        return state;
    }

    protected final XMLConnectorState getState() {
        return this.m_state;
    }

    public final ConnectorLogger getLogger() {
        return super.getLogger();
    }

    public DocumentCache getCache() {
        return this.m_documentCache;
    }

    public DocumentCache getStatementCache() {
        return this.m_statementCache;
    }
}

