/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.metadata.runtime.Element;

public abstract class ParameterDescriptor {
    private String m_xPath;
    private boolean m_param;
    private boolean m_responseId;
    private boolean m_location;
    private String m_columnName;
    private int m_columnNumber;
    private Element m_element;
    public static final String PARM_INPUT_COLUMN_PROPERTY_NAME = "IsInputParameter";
    public static final String ROLE_COLUMN_PROPERTY_NAME = "Role";
    public static final String ROLE_COLUMN_PROPERTY_NAME_RESPONSE_IN = "Response In";
    public static final String ROLE_COLUMN_PROPERTY_NAME_RESPONSE_OUT = "Response Out";
    public static final String ROLE_COLUMN_PROPERTY_NAME_LOCATION = "Location";
    public static final String ROLE_COLUMN_PROPERTY_NAME_DATA = "Data";

    public ParameterDescriptor(Element element) throws ConnectorException {
        this.setElement(element);
        this.setIsParameter(ParameterDescriptor.testForParam(this.m_element));
        this.testRole();
        this.setColumnName(this.getElement().getMetadataID().getName().trim());
        String nis = this.getElement().getNameInSource();
        if (nis != null) {
            nis = nis.trim();
        }
        this.setXPath(nis);
    }

    protected ParameterDescriptor() {
        this.setIsParameter(false);
        this.setIsResponseId(false);
        this.setIsLocation(false);
        this.setColumnName(null);
        this.setXPath(null);
    }

    public final void setXPath(String xPath) {
        this.m_xPath = xPath;
    }

    public String getXPath() {
        return this.m_xPath;
    }

    public final void setIsParameter(boolean param) {
        this.m_param = param;
    }

    public final void setIsResponseId(boolean responseId) {
        this.m_responseId = responseId;
    }

    public final void setIsLocation(boolean location) {
        this.m_location = location;
    }

    public final boolean isParameter() {
        return this.m_param;
    }

    public final boolean isResponseId() {
        return this.m_responseId;
    }

    public final boolean isLocation() {
        return this.m_location;
    }

    public final void setColumnName(String columnName) {
        this.m_columnName = columnName;
    }

    public final String getColumnName() {
        return this.m_columnName;
    }

    public final void setColumnNumber(int columnNumber) {
        this.m_columnNumber = columnNumber;
    }

    public final int getColumnNumber() {
        return this.m_columnNumber;
    }

    protected void setElement(Element elem) {
        this.m_element = elem;
    }

    protected Element getElement() {
        return this.m_element;
    }

    protected static boolean testForParam(Element element) throws ConnectorException {
        boolean param = false;
        param = Boolean.valueOf(element.getProperties().getProperty(PARM_INPUT_COLUMN_PROPERTY_NAME));
        return param;
    }

    public String getRole() throws ConnectorException {
        return this.m_element.getProperties().getProperty(ROLE_COLUMN_PROPERTY_NAME);
    }

    protected void testRole() throws ConnectorException {
        String role = this.getRole();
        if (role == null) {
            this.setIsResponseId(false);
            this.setIsLocation(false);
        } else if (role.equalsIgnoreCase(ROLE_COLUMN_PROPERTY_NAME_RESPONSE_IN)) {
            this.setIsResponseId(true);
            this.setIsLocation(false);
        } else if (role.equalsIgnoreCase(ROLE_COLUMN_PROPERTY_NAME_RESPONSE_OUT)) {
            this.setIsResponseId(true);
            this.setIsLocation(false);
        } else if (role.equalsIgnoreCase(ROLE_COLUMN_PROPERTY_NAME_LOCATION)) {
            this.setIsResponseId(false);
            this.setIsLocation(true);
        } else {
            this.setIsResponseId(false);
            this.setIsLocation(false);
        }
    }
}

