/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.base.FileBackedValueReference;
import com.metamatrix.connector.xml.base.FileLifeManager;
import com.metamatrix.connector.xml.base.LargeOrSmallString;
import com.metamatrix.connector.xml.base.XMLDocument;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

class LargeTextExtractingXmlFilter
extends XMLFilterImpl {
    private Collection files = new ArrayList();
    int maxInMemoryStringSize;
    private File m_cacheFolder;
    ConnectorLogger logger;
    int totalChars = 0;
    List bufferedChars = null;
    Writer writer = null;
    private static final String magicPrefix = "{c0b03165-e8a8-11d9-9485-00e08161165f}+{F930BF8D-407F-4D37-B661-AEEFE717B01A}+";

    LargeTextExtractingXmlFilter(int maxInMemoryStringSize, File cacheFolder, ConnectorLogger logger) {
        this.maxInMemoryStringSize = maxInMemoryStringSize;
        this.logger = logger;
        this.m_cacheFolder = cacheFolder;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.string(ch, start, length, false);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.string(ch, start, length, true);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.element();
        super.startElement(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.element();
        super.endElement(namespaceURI, localName, qName);
    }

    protected void string(char[] ch, int start, int length, boolean ignorableWhitespace) throws SAXException {
        try {
            if (this.writer == null && this.totalChars + length > this.maxInMemoryStringSize) {
                File file = File.createTempFile("xmlclob", ".txt", this.m_cacheFolder);
                file.deleteOnExit();
                FileLifeManager fileLifeManager = new FileLifeManager(file, this.logger);
                this.files.add(fileLifeManager);
                String fileReference = LargeTextExtractingXmlFilter.getXmlStringForFile(file);
                super.characters(fileReference.toCharArray(), 0, fileReference.length());
                FileOutputStream stream = new FileOutputStream(file);
                this.writer = new OutputStreamWriter((OutputStream)stream, FileBackedValueReference.getEncoding());
                if (this.bufferedChars != null) {
                    Iterator iter = this.bufferedChars.iterator();
                    while (iter.hasNext()) {
                        Characters characters = (Characters)iter.next();
                        this.writer.write(characters.ch);
                    }
                    this.bufferedChars = null;
                }
            }
            if (this.writer == null) {
                if (this.bufferedChars == null) {
                    this.bufferedChars = new ArrayList();
                }
                this.bufferedChars.add(new Characters(ch, start, length, false));
            } else {
                this.writer.write(ch, start, length);
            }
            this.totalChars += length;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    protected void element() throws SAXException {
        try {
            if (this.bufferedChars != null) {
                Iterator iter = this.bufferedChars.iterator();
                while (iter.hasNext()) {
                    Characters characters = (Characters)iter.next();
                    if (characters.ignorableWhitespace) {
                        super.ignorableWhitespace(characters.ch, 0, characters.ch.length);
                        continue;
                    }
                    super.characters(characters.ch, 0, characters.ch.length);
                }
                this.bufferedChars = null;
            } else if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            this.totalChars = 0;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public static String getXmlStringForFile(File file) {
        String filename = file.getAbsolutePath();
        String retval = magicPrefix + filename + "." + file.length();
        return retval;
    }

    public static LargeOrSmallString stringOrValueReference(String str, XMLDocument doc) throws ConnectorException {
        if (str == null) {
            return null;
        }
        if (!str.startsWith(magicPrefix)) {
            return LargeOrSmallString.createSmallString(str);
        }
        String filenamePlusLength = str.substring(magicPrefix.length());
        int lastDot = str.lastIndexOf(46);
        if (lastDot == -1) {
            return LargeOrSmallString.createSmallString(str);
        }
        long size = Long.valueOf(str.substring(lastDot + 1));
        String filename = str.substring(magicPrefix.length(), lastDot);
        FileLifeManager[] files = doc.getExternalFiles();
        FileLifeManager fileLifeManager = null;
        for (int iFile = 0; iFile < files.length; ++iFile) {
            try {
                if (!files[iFile].doesMatch(filename)) continue;
                fileLifeManager = files[iFile];
                break;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (fileLifeManager == null) {
            return LargeOrSmallString.createSmallString(str);
        }
        try {
            FileBackedValueReference valueReference = new FileBackedValueReference(fileLifeManager);
            LargeOrSmallString retval = LargeOrSmallString.createLargeString(valueReference);
            return retval;
        }
        catch (IOException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    FileLifeManager[] getFiles() {
        FileLifeManager[] retval = new FileLifeManager[this.files.size()];
        this.files.toArray(retval);
        return retval;
    }

    private static class Characters {
        char[] ch;
        boolean ignorableWhitespace;

        Characters(char[] ch, int start, int length, boolean ignorableWhitespace) {
            this.ch = new char[length];
            System.arraycopy(ch, start, this.ch, 0, length);
            this.ignorableWhitespace = ignorableWhitespace;
        }
    }
}

