/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.relationship.ui.wizards;

import com.metamatrix.metamodels.relationship.RelationshipType;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.relationship.ui.textimport.RelationshipTextImportModelSelectorDialog;
import com.metamatrix.modeler.internal.relationship.ui.textimport.RelationshipsLocationSelectionValidator;
import com.metamatrix.modeler.internal.relationship.ui.util.SqlDependencyRelationshipHelper;
import com.metamatrix.modeler.internal.relationship.ui.wizards.RelationshipObjectProcessor;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelObjectUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelWorkspaceDialog;
import com.metamatrix.modeler.relationship.ui.UiConstants;
import com.metamatrix.modeler.relationship.ui.UiPlugin;
import com.metamatrix.modeler.relationship.ui.editor.AbstractRelationshipTypeFilter;
import com.metamatrix.modeler.relationship.ui.properties.RelationshipPropertyEditorFactory;
import com.metamatrix.modeler.ui.editors.ModelEditorManager;
import com.metamatrix.ui.internal.eventsupport.SelectionUtilities;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.viewsupport.ClosedProjectFilter;
import com.metamatrix.ui.internal.widget.IListPanelController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.progress.IProgressConstants;

public class GenerateSqlRelationshipsMainPage
extends WizardDataTransferPage
implements Listener,
UiConstants,
IListPanelController {
    private Text modelFolderNameField;
    private Button modelFolderBrowseButton;
    private Text txtRelationshipType;
    private Button relTypeBrowseButton;
    protected Button autoGenerateNamesCheckbox;
    protected Button includeTableToTableCheckBox;
    protected Button includeColumnToColumnCheckbox;
    private ListViewer listViewer;
    private Group columnRadioGroup;
    private Button radioGenerateAllRels;
    private Button radioGenerateTargetDescendentRels;
    private Combo nLevelsCombo;
    private IProject targetProject;
    private ModelResource targetResource;
    private Object targetLocation;
    private Object selection;
    private Collection relationshipDataRows = Collections.EMPTY_LIST;
    private RelationshipObjectProcessor relationshipObjectProcessor = new RelationshipObjectProcessor();
    private SqlDependencyRelationshipHelper dependencyHelper;
    private boolean initializing = false;
    private static final String BROWSE_SHORTHAND = GenerateSqlRelationshipsMainPage.getString("browse_1");
    private static final String CHANGE_SHORTHAND = GenerateSqlRelationshipsMainPage.getString("change");
    private static final String DEFAULT_REL_TYPE = "Transformation";
    private static final String DELIM = "/";
    private static final String I18N_PREFIX = "GenerateSqlRelationshipsMainPage";
    private static final String SEPARATOR = ".";
    private static final String FINISH_MESSAGE = GenerateSqlRelationshipsMainPage.getString("finishMessage");
    private static final String PAGE_TITLE = GenerateSqlRelationshipsMainPage.getString("pageTitle");
    private static final String SELECT_TYPE_TEXT = GenerateSqlRelationshipsMainPage.getString("selectType");
    private static final String COLUMN_OPTIONS_TEXT = GenerateSqlRelationshipsMainPage.getString("columnOptionsGroup.text");
    private static final String GEN_ALL_COL_RELS_TEXT = GenerateSqlRelationshipsMainPage.getString("generateAllColRels.text");
    private static final String GEN_DECENDENT_COL_RELS_TEXT = GenerateSqlRelationshipsMainPage.getString("generateDecendentColRels.text");
    private static final String NLEVELS_LABEL_TEXT = GenerateSqlRelationshipsMainPage.getString("nLevelsLabel.text");

    private static String getString(String id) {
        return UiConstants.Util.getString("GenerateSqlRelationshipsMainPage." + id);
    }

    protected GenerateSqlRelationshipsMainPage(String title, IStructuredSelection selection) {
        super(title);
        this.setTitle(title);
    }

    public GenerateSqlRelationshipsMainPage(IStructuredSelection selection) {
        this(PAGE_TITLE, selection);
    }

    public GenerateSqlRelationshipsMainPage() {
        this(null);
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    public void handleEvent(Event event) {
        if (!this.initializing) {
            boolean validate = false;
            if (event.widget == this.modelFolderBrowseButton) {
                this.handleModelFolderBrowseButtonPressed();
            }
            if (event.widget == this.relTypeBrowseButton) {
                this.handleBrowseTypeButtonPressed();
            }
            if (event.widget == this.modelFolderBrowseButton || event.widget == this.relTypeBrowseButton || event.widget == this.autoGenerateNamesCheckbox || event.widget == this.includeTableToTableCheckBox || event.widget == this.includeColumnToColumnCheckbox || event.widget == this.radioGenerateAllRels || event.widget == this.nLevelsCombo) {
                if (event.widget == this.includeColumnToColumnCheckbox) {
                    this.updateColumnControlsEnablement();
                }
                this.updateHelperFromControls();
                this.loadViewer();
                validate = true;
            }
            if (validate) {
                this.setCompletionStatus();
            }
            this.updateWidgetEnablements();
        }
    }

    private void updateHelperFromControls() {
        String relLocation = this.modelFolderNameField.getText();
        String relType = this.txtRelationshipType.getText();
        boolean autoGen = this.autoGenerateNamesCheckbox.getSelection();
        boolean genTableRelsCheckbox = this.includeTableToTableCheckBox.getSelection();
        boolean genColRelsCheckbox = this.includeColumnToColumnCheckbox.getSelection();
        boolean genAllColRels = this.radioGenerateAllRels.getSelection();
        int nLevels = this.nLevelsCombo.getSelectionIndex() + 1;
        this.dependencyHelper.setOptions(relLocation, relType, genTableRelsCheckbox, genColRelsCheckbox, genAllColRels, autoGen, nLevels);
    }

    private void updateColumnControlsEnablement() {
        boolean genColsCB = this.includeColumnToColumnCheckbox.getSelection();
        if (genColsCB) {
            this.columnRadioGroup.setEnabled(true);
            this.radioGenerateAllRels.setEnabled(true);
            this.radioGenerateTargetDescendentRels.setEnabled(true);
        } else {
            this.columnRadioGroup.setEnabled(false);
            this.radioGenerateAllRels.setEnabled(false);
            this.radioGenerateTargetDescendentRels.setEnabled(false);
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createDestinationGroup(composite);
        this.createWorkspaceListGroup(composite);
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.initDependencyHelper();
        this.initControlValues();
        this.setControl((Control)composite);
        this.setCompletionStatus();
    }

    private void initControlValues() {
        String locStr = this.dependencyHelper.getLocationString();
        this.modelFolderNameField.setText(locStr);
        String relType = this.dependencyHelper.getRelationshipType();
        this.txtRelationshipType.setText(relType);
        boolean autoGenNames = this.dependencyHelper.getAutoGenNames();
        this.autoGenerateNamesCheckbox.setSelection(autoGenNames);
        this.autoGenerateNamesCheckbox.addListener(13, (Listener)this);
        boolean createTableRels = this.dependencyHelper.getCreateTableRelationshipsOption();
        this.includeTableToTableCheckBox.setSelection(createTableRels);
        this.includeTableToTableCheckBox.addListener(13, (Listener)this);
        boolean createColRels = this.dependencyHelper.getCreateColumnRelationshipsOption();
        this.includeColumnToColumnCheckbox.setSelection(createColRels);
        this.includeColumnToColumnCheckbox.addListener(13, (Listener)this);
        boolean createAllColRels = this.dependencyHelper.getCreateAllColumnRelationshipsOption();
        this.radioGenerateAllRels.setSelection(createAllColRels);
        this.radioGenerateAllRels.addListener(13, (Listener)this);
        this.updateColumnControlsEnablement();
        int maxLevels = this.dependencyHelper.getMaxLevels();
        int nLevels = this.dependencyHelper.getNLevels();
        String[] items = new String[maxLevels];
        for (int i = 0; i < maxLevels; ++i) {
            items[i] = i == maxLevels - 1 ? "All" : Integer.toString(i + 1);
        }
        this.nLevelsCombo.setItems(items);
        if (nLevels == -1) {
            this.nLevelsCombo.select(maxLevels - 1);
        } else {
            this.nLevelsCombo.select(nLevels - 1);
        }
        this.nLevelsCombo.addListener(13, (Listener)this);
    }

    private void createWorkspaceListGroup(Composite parent) {
        Label messageLabel = new Label(parent, 0);
        messageLabel.setText(GenerateSqlRelationshipsMainPage.getString("modelListMessage"));
        messageLabel.setFont(parent.getFont());
        this.listViewer = new ListViewer(parent);
        GridData data = new GridData(1808);
        this.listViewer.getControl().setLayoutData((Object)data);
    }

    protected void createDestinationGroup(Composite parent) {
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        containerGroup.setFont(parent.getFont());
        Label resourcesLabel = new Label(containerGroup, 0);
        resourcesLabel.setText(GenerateSqlRelationshipsMainPage.getString("targetLocation"));
        resourcesLabel.setFont(parent.getFont());
        this.modelFolderNameField = new Text(containerGroup, 2052);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.modelFolderNameField.setLayoutData((Object)data);
        this.modelFolderNameField.setFont(parent.getFont());
        this.modelFolderNameField.setEditable(false);
        this.modelFolderBrowseButton = new Button(containerGroup, 8);
        this.modelFolderBrowseButton.setText(BROWSE_SHORTHAND);
        this.modelFolderBrowseButton.setLayoutData((Object)new GridData(256));
        this.modelFolderBrowseButton.addListener(13, (Listener)this);
        this.modelFolderBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.modelFolderBrowseButton);
        Label typeSelectionLabel = new Label(containerGroup, 0);
        typeSelectionLabel.setText(SELECT_TYPE_TEXT);
        typeSelectionLabel.setFont(parent.getFont());
        this.txtRelationshipType = WidgetFactory.createTextField((Composite)containerGroup, (int)768, (String)DEFAULT_REL_TYPE);
        this.txtRelationshipType.setText(DEFAULT_REL_TYPE);
        this.txtRelationshipType.setEditable(false);
        this.relTypeBrowseButton = new Button(containerGroup, 8);
        this.relTypeBrowseButton.setText(CHANGE_SHORTHAND);
        this.relTypeBrowseButton.setLayoutData((Object)new GridData(256));
        this.relTypeBrowseButton.addListener(13, (Listener)this);
        this.relTypeBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.relTypeBrowseButton);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.autoGenerateNamesCheckbox = new Button((Composite)optionsGroup, 32);
        this.autoGenerateNamesCheckbox.setSelection(true);
        this.autoGenerateNamesCheckbox.setFont(optionsGroup.getFont());
        this.autoGenerateNamesCheckbox.setText(GenerateSqlRelationshipsMainPage.getString("autoRenameRelationships"));
        this.includeTableToTableCheckBox = new Button((Composite)optionsGroup, 32);
        this.includeTableToTableCheckBox.setSelection(true);
        this.includeTableToTableCheckBox.setFont(optionsGroup.getFont());
        this.includeTableToTableCheckBox.setText(GenerateSqlRelationshipsMainPage.getString("createTableRelationships"));
        this.includeColumnToColumnCheckbox = new Button((Composite)optionsGroup, 32);
        this.includeColumnToColumnCheckbox.setSelection(true);
        this.includeColumnToColumnCheckbox.setFont(optionsGroup.getFont());
        this.includeColumnToColumnCheckbox.setText(GenerateSqlRelationshipsMainPage.getString("createColumnRelationships"));
        this.columnRadioGroup = new Group((Composite)optionsGroup, 0);
        this.columnRadioGroup.setText(COLUMN_OPTIONS_TEXT);
        GridData gdRadioGroup = new GridData(768);
        this.columnRadioGroup.setLayoutData((Object)gdRadioGroup);
        this.columnRadioGroup.setLayout((Layout)new GridLayout());
        this.radioGenerateAllRels = WidgetFactory.createRadioButton((Composite)this.columnRadioGroup, (String)GEN_ALL_COL_RELS_TEXT, (boolean)true);
        this.radioGenerateTargetDescendentRels = WidgetFactory.createRadioButton((Composite)this.columnRadioGroup, (String)GEN_DECENDENT_COL_RELS_TEXT);
        Composite levelsComp = new Composite((Composite)optionsGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        levelsComp.setLayout((Layout)layout);
        levelsComp.setLayoutData((Object)new GridData(768));
        WidgetFactory.createLabel((Composite)levelsComp, (String)NLEVELS_LABEL_TEXT, (int)32);
        this.nLevelsCombo = WidgetFactory.createCombo((Composite)levelsComp, (int)8, (int)32, new ArrayList());
    }

    protected void handleModelFolderBrowseButtonPressed() {
        Object[] oSelectedObjects;
        RelationshipTextImportModelSelectorDialog mwdDialog = new RelationshipTextImportModelSelectorDialog(UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell());
        mwdDialog.setValidator((ISelectionStatusValidator)new RelationshipsLocationSelectionValidator());
        mwdDialog.setAllowMultiple(false);
        mwdDialog.open();
        if (mwdDialog.getReturnCode() == 0 && (oSelectedObjects = mwdDialog.getResult()).length > 0) {
            this.setRelationshipLocation(oSelectedObjects[0]);
        }
    }

    private void handleBrowseTypeButtonPressed() {
        Object[] oSelectedObjects;
        RelationshipType relType = null;
        SelectionDialog sdDialog = RelationshipPropertyEditorFactory.createRelationshipTypeSelector((Shell)UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell(), relType);
        ((ModelWorkspaceDialog)sdDialog).addFilter((ViewerFilter)new ClosedProjectFilter());
        ((ModelWorkspaceDialog)sdDialog).addFilter((ViewerFilter)new AbstractRelationshipTypeFilter());
        sdDialog.open();
        if (sdDialog.getReturnCode() == 0 && (oSelectedObjects = sdDialog.getResult()).length > 0) {
            RelationshipType rt = (RelationshipType)oSelectedObjects[0];
            this.txtRelationshipType.setText(rt.getName());
        }
    }

    private void setRelationshipLocation(Object oLocation) {
        String locationStr = null;
        if (oLocation instanceof IFile) {
            try {
                this.targetProject = ((IFile)oLocation).getProject();
                this.targetResource = ModelUtilities.getModelResource((IFile)((IFile)oLocation), (boolean)false);
                this.targetLocation = this.targetResource;
            }
            catch (ModelWorkspaceException err) {
                // empty catch block
            }
            locationStr = this.getModelPathStr(this.targetProject, this.targetResource);
            this.modelFolderNameField.setText(locationStr);
        } else if (oLocation instanceof EObject) {
            EObject eObj = (EObject)oLocation;
            this.targetLocation = eObj;
            this.targetResource = ModelUtilities.getModelResourceForModelObject((EObject)eObj);
            try {
                this.targetProject = this.targetResource.getUnderlyingResource().getProject();
            }
            catch (ModelWorkspaceException e) {
                e.printStackTrace();
            }
            locationStr = this.getModelPathStr(this.targetProject, this.targetResource) + DELIM + ModelObjectUtilities.getRelativePath((EObject)eObj);
            this.modelFolderNameField.setText(locationStr);
        } else if (oLocation instanceof ModelResource) {
            this.targetResource = (ModelResource)oLocation;
            this.targetLocation = this.targetResource;
            try {
                this.targetProject = this.targetResource.getUnderlyingResource().getProject();
            }
            catch (ModelWorkspaceException e) {
                e.printStackTrace();
            }
            locationStr = this.getModelPathStr(this.targetProject, this.targetResource);
            this.modelFolderNameField.setText(locationStr);
        }
    }

    private String getModelPathStr(IProject targetProj, ModelResource modelResrc) {
        IPath modelPath = modelResrc.getPath();
        modelPath = modelPath.removeFirstSegments(1);
        String relativePath = modelPath.toString();
        String resultPath = this.targetProject.getName() + DELIM + relativePath;
        return resultPath;
    }

    private void initDependencyHelper() {
        Collection targets = new ArrayList();
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)this.selection;
            if (sel.size() == 1) {
                Object firstObj = sel.getFirstElement();
                if (firstObj != null && TransformationHelper.isVirtualSqlTable((Object)firstObj)) {
                    targets.add(firstObj);
                } else if (firstObj instanceof Collection) {
                    targets = (Collection)firstObj;
                }
            } else {
                targets = SelectionUtilities.getSelectedEObjects((ISelection)((ISelection)this.selection));
            }
            this.dependencyHelper = new SqlDependencyRelationshipHelper(targets);
        }
    }

    private void loadViewer() {
        this.clearListViewer();
        if (this.dependencyHelper != null) {
            this.relationshipDataRows = this.dependencyHelper.getRelationshipRows();
            if (!this.relationshipDataRows.isEmpty()) {
                this.loadListViewer(this.relationshipDataRows);
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void setMessage(String newMessage) {
        super.setMessage(newMessage);
    }

    private boolean setCompletionStatus() {
        if (this.validateDestination()) {
            if (this.relationshipDataRows.size() > 0) {
                this.setMessage(FINISH_MESSAGE, 0);
                this.setPageComplete(true);
                return true;
            }
            this.setMessage(GenerateSqlRelationshipsMainPage.getString("noRelationshipsToCreateMessage"), 3);
        }
        this.setPageComplete(false);
        return false;
    }

    private boolean validateDestination() {
        if (this.targetResource == null) {
            this.setMessage(GenerateSqlRelationshipsMainPage.getString("noValidLocationSelectedMessage"), 3);
            return false;
        }
        return true;
    }

    public boolean finish() {
        this.saveWidgetValues();
        if (!this.relationshipDataRows.isEmpty() && this.targetResource != null && this.targetLocation != null) {
            this.generateWithJob(this.targetResource, this.targetLocation, this.relationshipDataRows);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean execute(ModelResource resource, Object location, Collection tableRows, IProgressMonitor monitor) {
        boolean succeeded;
        block6: {
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)GenerateSqlRelationshipsMainPage.getString("undoTitle"), (Object)((Object)this));
            succeeded = false;
            try {
                this.relationshipObjectProcessor.generateObjsFromRowObjs(resource, location, tableRows);
                this.relationshipObjectProcessor.organizeImports(resource);
                succeeded = true;
                Object var8_7 = null;
                if (!requiredStart) break block6;
                if (succeeded && !monitor.isCanceled()) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (!requiredStart) throw throwable;
                if (succeeded && !monitor.isCanceled()) {
                    ModelerCore.commitTxn();
                    throw throwable;
                }
                ModelerCore.rollbackTxn();
                throw throwable;
            }
        }
        ModelEditorManager.activate((ModelResource)this.targetResource, (boolean)true);
        ArrayList otherModifiedResources = new ArrayList(this.relationshipObjectProcessor.getOtherModifiedResources());
        Iterator iter = otherModifiedResources.iterator();
        while (iter.hasNext()) {
            ModelEditorManager.activate((ModelResource)((ModelResource)iter.next()), (boolean)true);
        }
        return succeeded;
    }

    private boolean generateWithJob(final ModelResource resource, final Object location, final Collection tableRows) {
        final String message = GenerateSqlRelationshipsMainPage.getString("progressTitle");
        Job job = new Job(message){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                block6: {
                    monitor.beginTask(message, tableRows.size());
                    if (!monitor.isCanceled()) {
                        GenerateSqlRelationshipsMainPage.this.relationshipObjectProcessor.setProgressMonitor(monitor);
                        GenerateSqlRelationshipsMainPage.this.execute(resource, location, tableRows, monitor);
                    }
                    monitor.done();
                    if (!monitor.isCanceled()) break block6;
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                try {
                    Status status = new Status(0, "com.metamatrix.modeler.relationship.ui", 0, "Finished creating relationships", null);
                    return status;
                }
                catch (Exception e) {
                    UiConstants.Util.log((Throwable)e);
                    Status status = new Status(4, "com.metamatrix.modeler.relationship.ui", 4, GenerateSqlRelationshipsMainPage.getString("createError"), (Throwable)e);
                    return status;
                }
            }
        };
        job.setSystem(false);
        job.setUser(true);
        job.setProperty(IProgressConstants.KEEP_PROPERTY, (Object)Boolean.TRUE);
        job.schedule();
        return true;
    }

    public void clearListViewer() {
        this.listViewer.getList().removeAll();
    }

    public void loadListViewer(Collection rows) {
        Iterator iter = rows.iterator();
        while (iter.hasNext()) {
            this.listViewer.add(iter.next());
        }
    }

    public Object[] addButtonSelected() {
        return null;
    }

    public void downButtonSelected(IStructuredSelection selection) {
    }

    public Object editButtonSelected(IStructuredSelection selection) {
        return null;
    }

    public void itemsSelected(IStructuredSelection selection) {
    }

    public Object[] removeButtonSelected(IStructuredSelection selection) {
        return null;
    }

    public void upButtonSelected(IStructuredSelection selection) {
    }

    public void setSelection(Object selection) {
        this.selection = selection;
    }
}

