/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.text;

import com.metamatrix.connector.text.TextConnection;
import com.metamatrix.connector.text.TextPlugin;
import com.metamatrix.connector.text.TextUtil;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.Connector;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.license.LicenseChecker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class TextConnector
implements Connector {
    private ConnectorLogger logger;
    private ConnectorEnvironment env;
    private boolean start = false;
    private int srcFiles = 0;
    private int srcFileErrs = 0;
    Map metadataProps = new HashMap();

    public void initialize(ConnectorEnvironment environment) throws ConnectorException {
        this.logger = environment.getLogger();
        this.env = environment;
        boolean licensed = LicenseChecker.hasValidProductLicense((String)"Connector/Text", (String)"5.0", (boolean)false);
        if (!licensed) {
            String msg = TextPlugin.Util.getString("TextConnector.No_license_found_for_{0}", new Object[]{"Connector/Text"});
            ConnectorException e = new ConnectorException(msg);
            this.logger.logError(msg, (Throwable)e);
            throw e;
        }
        this.initMetaDataProps(this.env);
        TextConnection test = new TextConnection(this.env, this.metadataProps);
        test.release();
        this.logger = environment.getLogger();
        this.logger.logInfo("Text Connector is intialized.");
    }

    public void stop() {
        if (!this.start) {
            return;
        }
        this.start = false;
        this.logger.logInfo("Text Connector is stoped.");
    }

    public void start() {
        this.start = true;
        this.logger.logInfo("Text Connector is started.");
    }

    public Connection getConnection(SecurityContext context) throws ConnectorException {
        return new TextConnection(this.env, this.metadataProps);
    }

    private void initMetaDataProps(ConnectorEnvironment env) throws ConnectorException {
        block3: {
            Properties connectorProps = env.getProperties();
            this.metadataProps.put("CONNECTOR_PROPERTIES", connectorProps);
            String descriptor = connectorProps.getProperty("DescriptorFile");
            boolean partialStartupAllowed = this.getPartialStartupAllowedValue(connectorProps);
            this.reinitFileCounts();
            try {
                this.readDescriptor(descriptor, partialStartupAllowed);
                this.reinitFileCounts();
            }
            catch (ConnectorException ce) {
                if (!partialStartupAllowed) {
                    this.reinitFileCounts();
                    throw ce;
                }
                if (this.srcFileErrs != this.srcFiles) break block3;
                this.reinitFileCounts();
                throw ce;
            }
        }
    }

    private boolean getPartialStartupAllowedValue(Properties connectorProps) {
        String partialAllowedStr = connectorProps.getProperty("PartialStartupAllowed", "true");
        return Boolean.valueOf(partialAllowedStr);
    }

    private void reinitFileCounts() {
        this.srcFiles = 0;
        this.srcFileErrs = 0;
    }

    private void readDescriptor(String descriptorFile, boolean startPartial) throws ConnectorException {
        if (descriptorFile == null || descriptorFile.trim().length() == 0) {
            throw new ConnectorException(TextPlugin.Util.getString("TextConnection.Descriptor_file_name_is_not_specified._2"));
        }
        ConnectorException connExcep = null;
        BufferedReader br = null;
        try {
            br = this.getReader(descriptorFile);
            this.logger.logInfo("Reading descriptor file: " + descriptorFile);
            String line = null;
            while ((line = br.readLine()) != null) {
                block16: {
                    if (line.length() != 0) {
                        try {
                            this.getMetadata(line);
                        }
                        catch (ConnectorException e) {
                            if (!startPartial) {
                                throw e;
                            }
                            if (connExcep != null) break block16;
                            connExcep = e;
                        }
                    }
                }
                if (line != null) continue;
            }
            if (connExcep != null) {
                throw connExcep;
            }
        }
        catch (IOException e) {
            this.logger.logError(TextPlugin.Util.getString("TextConnection.Error_while_reading_text_file__{0}_1", new Object[]{e.getMessage()}), (Throwable)e);
            throw new ConnectorException((Throwable)e, TextPlugin.Util.getString("TextConnection.Error_trying_to_establish_connection_5"));
        }
        finally {
            try {
                br.close();
            }
            catch (Exception ee) {}
            br = null;
        }
        this.logger.logDetail("Successfully read metadata information from the descriptor file " + descriptorFile);
    }

    private void getMetadata(String propStr) throws ConnectorException {
        try {
            int index = 0;
            int eqIndex = propStr.indexOf("=", index);
            String propString = propStr.substring(index, eqIndex);
            if (!propString.equals(" ")) {
                propString = propString.trim();
            }
            int lastIndex = propString.lastIndexOf(46);
            String groupName = propString.substring(0, lastIndex).toUpperCase();
            String propertyName = propString.substring(lastIndex + 1).toUpperCase();
            Properties props = (Properties)this.metadataProps.get(groupName);
            if (props == null) {
                props = new Properties();
            }
            index = eqIndex + 1;
            String propertyValue = propStr.substring(index).trim();
            if (propertyName.equals("LOCATION")) {
                ++this.srcFiles;
                if (propertyValue == null || propertyValue.trim().length() == 0) {
                    ++this.srcFileErrs;
                    throw new ConnectorException(TextPlugin.Util.getString("TextConnection.Text_file_name_is_not_specified_for_the_group___{0}_2", new Object[]{groupName}));
                }
                this.checkFile(propertyValue, props, groupName);
            } else if (propertyName.equals("SKIPHEADERLINES")) {
                try {
                    Integer.parseInt(propertyValue);
                }
                catch (NumberFormatException e) {
                    throw new ConnectorException((Throwable)e, TextPlugin.Util.getString("TextConnection.The_value_for_the_property_should_be_an_integer._{0}_3", new Object[]{e.getMessage()}));
                }
            } else if (propertyName.equals("HEADERLINE")) {
                try {
                    Integer.parseInt(propertyValue);
                }
                catch (NumberFormatException e) {
                    throw new ConnectorException((Throwable)e, TextPlugin.Util.getString("TextConnection.The_value_for_the_property_should_be_an_integer._{0}_3", new Object[]{e.getMessage()}));
                }
            } else if (!propertyName.equals("DELIMITER") && !propertyName.equals("QUALIFIER")) {
                throw new ConnectorException(TextPlugin.Util.getString("TextConnection.The_property_{0}_for_the_group_{1}_is_invalid._4", new Object[]{propertyName, groupName}));
            }
            if (propertyValue != null && propertyValue.equals("\\t")) {
                propertyValue = "\t";
            }
            if (propertyValue != null && !propertyValue.equals("")) {
                props.put(propertyName, propertyValue);
                this.metadataProps.put(groupName, props);
            }
        }
        catch (Exception e) {
            this.logger.logError(TextPlugin.Util.getString("TextConnection.Error_parsing_property_string_{0}_5", new Object[]{propStr}), (Throwable)e);
            throw new ConnectorException(TextPlugin.Util.getString("TextConnection.Error_parsing_property_string_{0}__{1}_6", new Object[]{propStr, e.getMessage()}));
        }
    }

    private void checkFile(String fileName, Properties props, String groupName) throws ConnectorException {
        File datafile = new File(fileName);
        File[] files = TextUtil.getFiles(fileName);
        if (files == null && TextUtil.usesWildCard(fileName)) {
            ++this.srcFileErrs;
            throw new ConnectorException(TextPlugin.Util.getString("TextConnection.fileDoesNotExistForGroup", new Object[]{fileName, groupName}));
        }
        if (files != null && files.length > 0) {
            props.setProperty("FILE", fileName);
        } else if (datafile.isFile()) {
            if (!datafile.exists()) {
                ++this.srcFileErrs;
                throw new ConnectorException(TextPlugin.Util.getString("TextConnection.fileDoesNotExistForGroup", new Object[]{fileName, groupName}));
            }
            if (!datafile.canRead()) {
                ++this.srcFileErrs;
                throw new ConnectorException(TextPlugin.Util.getString("TextConnection.Data_file_{0}_found_but_does_not_have_Read_permissions_8", new Object[]{fileName}));
            }
            props.setProperty("FILE", fileName);
        } else {
            try {
                URL url = new URL(fileName);
                URLConnection conn = url.openConnection();
                conn.connect();
                props.setProperty("URL", fileName);
            }
            catch (IOException e) {
                ++this.srcFileErrs;
                throw new ConnectorException((Throwable)e, TextPlugin.Util.getString("TextConnection.fileDoesNotExistForGroup", new Object[]{fileName, groupName}));
            }
        }
    }

    private BufferedReader getReader(String fileLocation) throws ConnectorException {
        BufferedReader br = null;
        File descfile = new File(fileLocation);
        if (descfile.isFile()) {
            if (!descfile.exists()) {
                throw new ConnectorException(TextPlugin.Util.getString("TextConnection.Descriptor_file_does_not_exist_at_this_location__{0}_9", new Object[]{fileLocation}));
            }
            if (!descfile.canRead()) {
                throw new ConnectorException(TextPlugin.Util.getString("TextConnection.Descriptor_file_{0}_found_but_does_not_have_Read_permissions_10", new Object[]{fileLocation}));
            }
            try {
                br = new BufferedReader(new FileReader(descfile));
            }
            catch (FileNotFoundException fe) {
                throw new ConnectorException((Throwable)fe, TextPlugin.Util.getString("TextConnection.Couldn__t_find_the_file_of_name_{0}_11", new Object[]{descfile}));
            }
        }
        try {
            URL url = new URL(fileLocation);
            URLConnection conn = url.openConnection();
            conn.connect();
            InputStreamReader inSR = new InputStreamReader(conn.getInputStream());
            br = new BufferedReader(inSR);
        }
        catch (IOException e) {
            throw new ConnectorException((Throwable)e, TextPlugin.Util.getString("TextConnection.Descriptor_file_does_not_exist_at_this_location__{0}_12", new Object[]{fileLocation}));
        }
        return br;
    }
}

