/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.function;

import com.metamatrix.api.exception.query.FunctionExecutionException;
import com.metamatrix.api.exception.query.InvalidFunctionException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.function.FunctionDescriptor;
import com.metamatrix.query.function.FunctionDescriptorImpl;
import com.metamatrix.query.function.FunctionForm;
import com.metamatrix.query.function.FunctionMetadataSource;
import com.metamatrix.query.function.FunctionTree;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class FunctionLibrary {
    public static final String CONVERT = "convert";
    public static final String CAST = "cast";
    public static final String LOOKUP = "lookup";
    public static final String USER = "user";
    public static final String ENV = "env";
    public static final String XPATHVALUE = "xpathvalue";
    public static final String CONTEXT = "context";
    public static final String RELATE = "relate";
    public static final String RELATESOURCE = "relatesource";
    public static final String RELATETARGET = "relatetarget";
    public static final String ROWLIMIT = "rowlimit";
    public static final String ROWLIMITEXCEPTION = "rowlimitexception";
    public static final String DECODESTRING = "decodestring";
    public static final String DECODEINTEGER = "decodeinteger";
    public static final String COMMAND_PAYLOAD = "commandpayload";
    public static final String CONCAT = "CONCAT";
    public static final String CONCAT_OPERATOR = "||";
    public static final String SUBSTRING = "substring";
    private FunctionTree systemFunctions = new FunctionTree(Collections.EMPTY_LIST);
    private FunctionTree userFunctions = new FunctionTree(Collections.EMPTY_LIST);

    FunctionLibrary() {
    }

    public List getFunctionCategories() {
        HashSet categories = new HashSet();
        categories.addAll(this.systemFunctions.getCategories());
        categories.addAll(this.userFunctions.getCategories());
        ArrayList categoryList = new ArrayList(categories);
        Collections.sort(categoryList);
        return categoryList;
    }

    public List getFunctionForms(String category) {
        ArrayList forms = new ArrayList();
        forms.addAll(this.systemFunctions.getFunctionForms(category));
        forms.addAll(this.userFunctions.getFunctionForms(category));
        Collections.sort(forms);
        return forms;
    }

    public FunctionForm findFunctionForm(String name, int numArgs) {
        FunctionForm form = this.systemFunctions.findFunctionForm(name, numArgs);
        if (form == null) {
            form = this.userFunctions.findFunctionForm(name, numArgs);
        }
        return form;
    }

    void setSystemFunctions(FunctionMetadataSource source) {
        this.systemFunctions = new FunctionTree(source);
    }

    void replaceReloadableFunctions(Collection sources) {
        FunctionTree reloadedFunctions;
        this.userFunctions = reloadedFunctions = new FunctionTree(sources);
    }

    public FunctionDescriptor findFunction(String name, Class[] types) {
        FunctionDescriptor descriptor = this.systemFunctions.getFunction(name, types);
        if (descriptor == null) {
            descriptor = this.userFunctions.getFunction(name, types);
        }
        return descriptor;
    }

    public Collection findPartialFunction(String name, Class[] types) {
        Collection matches = this.systemFunctions.getPartialFunction(name, types);
        if (matches.size() == 0) {
            matches = this.userFunctions.getPartialFunction(name, types);
        }
        return matches;
    }

    public FunctionDescriptor[] determineNecessaryConversions(String name, Class[] types) {
        if (types.length == 0) {
            return new FunctionDescriptor[0];
        }
        FunctionDescriptor exactMatch = this.findFunction(name, types);
        if (exactMatch != null) {
            return new FunctionDescriptor[types.length];
        }
        FunctionDescriptor[] results = new FunctionDescriptor[types.length];
        if (types.length == 1) {
            String incomingTypeName = DataTypeManager.getDataTypeName((Class)types[0]);
            List conversions = DataTypeManager.getImplicitConversions((String)incomingTypeName);
            if (conversions == null || conversions.size() == 0) {
                return results;
            }
            Class[] typesCopy = new Class[1];
            Iterator iter = conversions.iterator();
            while (iter.hasNext()) {
                String otherType = (String)iter.next();
                typesCopy[0] = DataTypeManager.getDataTypeClass((String)otherType);
                if (this.findFunction(name, typesCopy) == null) continue;
                results[0] = this.findTypedConversionFunction(types[0], typesCopy[0]);
                return results;
            }
            return null;
        }
        if (types.length == 2) {
            String firstTypeName = DataTypeManager.getDataTypeName((Class)types[0]);
            String secondTypeName = DataTypeManager.getDataTypeName((Class)types[1]);
            List firstConversions = DataTypeManager.getImplicitConversions((String)firstTypeName);
            if (secondTypeName != null && firstConversions != null && firstConversions.contains(secondTypeName) && this.findFunction(name, new Class[]{types[1], types[1]}) != null) {
                results[0] = this.findTypedConversionFunction(types[0], types[1]);
                return results;
            }
            List secondConversions = DataTypeManager.getImplicitConversions((String)secondTypeName);
            if (firstTypeName != null && secondConversions != null && secondConversions.contains(firstTypeName) && this.findFunction(name, new Class[]{types[0], types[0]}) != null) {
                results[1] = this.findTypedConversionFunction(types[1], types[0]);
                return results;
            }
        }
        ArrayList conversions = new ArrayList(types.length);
        for (int i = 0; i < types.length; ++i) {
            ArrayList<String> impConv = new ArrayList<String>();
            List dtList = DataTypeManager.getImplicitConversions((String)DataTypeManager.getDataTypeName((Class)types[i]));
            if (dtList != null) {
                impConv.addAll(dtList);
            }
            impConv.add(DataTypeManager.getDataTypeName((Class)types[i]));
            conversions.add(impConv);
        }
        List permutations = this.getPermutations(conversions);
        int bestCost = types.length;
        Class[] bestSignature = null;
        Iterator permIter = permutations.iterator();
        while (permIter.hasNext()) {
            List permutation = (List)permIter.next();
            Class[] signature = new Class[types.length];
            Iterator typeIter = permutation.iterator();
            int i = 0;
            while (typeIter.hasNext()) {
                String dataType = (String)typeIter.next();
                signature[i] = DataTypeManager.getDataTypeClass((String)dataType);
                ++i;
            }
            if (this.findFunction(name, signature) == null) continue;
            int cost = 0;
            for (int j = 0; j < types.length; ++j) {
                if (types[j] == signature[j]) continue;
                ++cost;
            }
            if (cost == 1) {
                bestSignature = signature;
                break;
            }
            if (cost > bestCost) continue;
            bestCost = cost;
            bestSignature = signature;
        }
        if (bestSignature == null) {
            return null;
        }
        for (int i = 0; i < bestSignature.length; ++i) {
            if (types[i] == bestSignature[i]) continue;
            results[i] = this.findTypedConversionFunction(types[i], (Class)bestSignature[i]);
        }
        return results;
    }

    public FunctionDescriptor findTypedConversionFunction(Class sourceType, Class targetType) {
        FunctionDescriptorImpl fd = (FunctionDescriptorImpl)this.findFunction(CONVERT, new Class[]{sourceType, DataTypeManager.DefaultDataClasses.STRING});
        if (fd != null) {
            FunctionDescriptorImpl copy = new FunctionDescriptorImpl(fd.getName(), 0, fd.getTypes(), targetType, fd.getInvocationMethod(), fd.requiresContext(), fd.isNullDependent());
            return copy;
        }
        return fd;
    }

    private List getPermutations(List choiceLists) {
        if (choiceLists.size() == 0) {
            return new ArrayList(choiceLists);
        }
        if (choiceLists.size() == 1) {
            List choices = (List)choiceLists.get(0);
            ArrayList permutations = new ArrayList(choices.size());
            Iterator choicesIter = choices.iterator();
            while (choicesIter.hasNext()) {
                ArrayList newPerm = new ArrayList(1);
                newPerm.add(choicesIter.next());
                permutations.add(newPerm);
            }
            return permutations;
        }
        List smallList = choiceLists.subList(0, choiceLists.size() - 1);
        List smallPerms = this.getPermutations(smallList);
        ArrayList permutations = new ArrayList();
        Iterator smallPermIter = smallPerms.iterator();
        while (smallPermIter.hasNext()) {
            List smallPerm = (List)smallPermIter.next();
            Iterator lastIter = ((List)choiceLists.get(choiceLists.size() - 1)).iterator();
            while (lastIter.hasNext()) {
                ArrayList newPerm = new ArrayList(smallPerm);
                newPerm.add(lastIter.next());
                permutations.add(newPerm);
            }
        }
        return permutations;
    }

    public Object invokeFunction(FunctionDescriptor fd, Object[] values) throws InvalidFunctionException, FunctionExecutionException {
        if (fd == null) {
            throw new InvalidFunctionException("ERR.015.001.0001", QueryPlugin.Util.getString("ERR.015.001.0001", (Object)fd));
        }
        Method method = ((FunctionDescriptorImpl)fd).getInvocationMethod();
        if (method == null) {
            FunctionDescriptorImpl localDescriptor = (FunctionDescriptorImpl)this.findFunction(fd.getName(), fd.getTypes());
            if (localDescriptor == null) {
                throw new InvalidFunctionException("ERR.015.001.0001", QueryPlugin.Util.getString("ERR.015.001.0001", (Object)fd));
            }
            method = localDescriptor.getInvocationMethod();
            if (method == null) {
                throw new FunctionExecutionException("ERR.015.001.0002", QueryPlugin.Util.getString("ERR.015.001.0002", (Object)localDescriptor.getName()));
            }
        }
        try {
            return method.invoke(null, values);
        }
        catch (InvocationTargetException e) {
            throw new FunctionExecutionException(e.getTargetException(), "ERR.015.001.0003", QueryPlugin.Util.getString("ERR.015.001.0003", (Object)fd.getName()));
        }
        catch (IllegalAccessException e) {
            throw new FunctionExecutionException((Throwable)e, "ERR.015.001.0004", QueryPlugin.Util.getString("ERR.015.001.0004", (Object)method.toString()));
        }
    }

    public FunctionDescriptor copyFunctionChangeReturnType(FunctionDescriptor fd, Class returnType) {
        if (fd != null) {
            FunctionDescriptorImpl fdImpl = (FunctionDescriptorImpl)fd;
            FunctionDescriptorImpl copy = new FunctionDescriptorImpl(fd.getName(), fd.getPushdown(), fd.getTypes(), returnType, fdImpl.getInvocationMethod(), fd.requiresContext(), fd.isNullDependent());
            return copy;
        }
        return fd;
    }
}

