/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.webservice.ui.editor;

import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.util.ArrayUtil;
import com.metamatrix.metamodels.diagram.Diagram;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.metamodels.webservice.Interface;
import com.metamatrix.metamodels.webservice.Operation;
import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.ui.editors.MultiPageModelEditor;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.internal.webservice.ui.IInternalUiConstants;
import com.metamatrix.modeler.transformation.ui.UiPlugin;
import com.metamatrix.modeler.transformation.ui.actions.TransformationSourceManager;
import com.metamatrix.modeler.transformation.ui.editors.SqlPanelDropTargetListener;
import com.metamatrix.modeler.transformation.ui.editors.TransformationObjectEditorPage;
import com.metamatrix.modeler.ui.editors.ModelEditorPage;
import com.metamatrix.modeler.ui.editors.ModelObjectEditorPage;
import com.metamatrix.modeler.webservice.ui.WebServiceUiPlugin;
import com.metamatrix.modeler.webservice.ui.editor.InputVariableSection;
import com.metamatrix.modeler.webservice.ui.editor.OperationEditorNotifyChangedListener;
import com.metamatrix.modeler.webservice.ui.editor.OperationEditorPage;
import com.metamatrix.modeler.webservice.ui.editor.VariableEditorDialog;
import com.metamatrix.modeler.webservice.ui.util.WebServiceUiUtil;
import com.metamatrix.query.internal.ui.sqleditor.component.AssignmentStatementDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.BlockDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.DeclareStatementDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.DisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.QueryDisplayComponent;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.proc.DeclareStatement;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.ui.sqleditor.SqlEditorPanel;
import com.metamatrix.ui.internal.util.UiUtil;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.util.WidgetUtil;
import com.metamatrix.ui.internal.viewsupport.UiBusyIndicator;
import com.metamatrix.ui.tree.AbstractTreeContentProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class OperationObjectEditorPage
extends TransformationObjectEditorPage
implements ArrayUtil.Constants,
IInternalUiConstants,
IInternalUiConstants.Images,
StringUtil.Constants {
    private static final String I18N_PFX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$webservice$ui$editor$OperationObjectEditorPage == null ? (class$com$metamatrix$modeler$webservice$ui$editor$OperationObjectEditorPage = OperationObjectEditorPage.class$("com.metamatrix.modeler.webservice.ui.editor.OperationObjectEditorPage")) : class$com$metamatrix$modeler$webservice$ui$editor$OperationObjectEditorPage));
    public static final String NAME = IInternalUiConstants.UTIL.getString(I18N_PFX + "name");
    private static final String OPS_TITLE = IInternalUiConstants.UTIL.getString(I18N_PFX + "operationsTitle");
    private static final String PROC_DESC = IInternalUiConstants.UTIL.getString(I18N_PFX + "procedureDescription");
    private static final String PROC_TITLE = IInternalUiConstants.UTIL.getString(I18N_PFX + "procedureTitle");
    private static final String VARS_DESC = IInternalUiConstants.UTIL.getString(I18N_PFX + "variablesDescription");
    private static final String DROP_CONFIRM_TITLE = IInternalUiConstants.UTIL.getString(I18N_PFX + "dropConfirmTitle");
    private static final String DROP_CONFIRM_MSG = IInternalUiConstants.UTIL.getString(I18N_PFX + "dropConfirmMsg");
    private static final String EDIT = IInternalUiConstants.UTIL.getString(I18N_PFX + "edit");
    private static final String EDIT_LABEL = "<html><p>" + IInternalUiConstants.UTIL.getString(I18N_PFX + "editLabel", (Object)("<a>" + EDIT + "</a>")) + "</p></html>";
    private static final int DFLT_LEFT_H_WGT = 250;
    private static final int DFLT_RIGHT_H_WGT = 750;
    private static final int DFLT_TOP_V_WGT = 250;
    private static final int DFLT_BOTTOM_V_WGT = 750;
    private static final String LEFT_H_WGT_PREF = I18N_PFX + "leftHorizontalWeight";
    private static final String RIGHT_H_WGT_PREF = I18N_PFX + "rightHorizontalWeight";
    private static final String TOP_V_WGT_PREF = I18N_PFX + "leftVerticalWeight";
    private static final String BOTTOM_V_WGT_PREF = I18N_PFX + "rightVerticalWeight";
    private TreeViewer opViewer;
    private InputVariableSection varSection;
    private Map declarationsToAssignments;
    private Operation selectedOp;
    private FormText editLink;
    private Resource resrc;
    private OperationEditorPage opEditorPage;
    private SashForm hSplitter;
    private SashForm vSplitter;
    private Section sqlPanelSection;
    private Section treeSection;
    private SqlEditorPanel sqlEditorPanel;
    private boolean allowsExternalEdits = false;
    static /* synthetic */ Class class$com$metamatrix$modeler$webservice$ui$editor$OperationObjectEditorPage;

    protected boolean allowsMultipleTabs() {
        return false;
    }

    public boolean canClose() {
        return false;
    }

    public boolean canEdit(Object object, IEditorPart editor) {
        return editor instanceof OperationEditorPage;
    }

    protected IAction contributeReconcileAction() {
        return null;
    }

    protected SqlPanelDropTargetListener createDropTargetListener(SqlEditorPanel sqlPanel, SqlTransformationMappingRoot transformation) {
        return new MySqlPanelDropTargetListener(sqlPanel, transformation, (Object)this);
    }

    private void createEditActionControl(Composite parent) {
        FormToolkit toolkit = WebServiceUiPlugin.getDefault().getFormToolkit(parent.getDisplay());
        this.editLink = WidgetFactory.createFormText((Composite)parent, (FormToolkit)toolkit, (String)EDIT_LABEL, (IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                OperationObjectEditorPage.this.editVariables();
            }
        });
        WidgetUtil.disableFormText((FormText)this.editLink);
    }

    protected SqlEditorPanel createSelectEditorForNoUpdate(Composite parent) {
        FillLayout fillLayout = new FillLayout();
        parent.setLayout((Layout)fillLayout);
        Display display = parent.getDisplay();
        FormToolkit toolkit = WebServiceUiPlugin.getDefault().getFormToolkit(display);
        Composite form = toolkit.createForm(parent).getBody();
        form.setLayout((Layout)fillLayout);
        this.hSplitter = new SashForm(form, 256);
        this.treeSection = toolkit.createSection((Composite)this.hSplitter, 256);
        this.treeSection.setText(OPS_TITLE);
        toolkit.paintBordersFor((Composite)this.treeSection);
        this.opViewer = new TreeViewer((Composite)this.treeSection, 768);
        this.treeSection.setClient((Control)this.opViewer.getTree());
        this.opViewer.setContentProvider((IContentProvider)new AbstractTreeContentProvider(){

            public Object[] getChildren(Object parent) {
                return parent instanceof Interface ? ((Interface)parent).getOperations().toArray() : ArrayUtil.Constants.EMPTY_ARRAY;
            }

            public Object[] getElements(Object inputElement) {
                ArrayList interfaces = new ArrayList();
                Iterator iter = ((List)inputElement).iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof Interface)) continue;
                    interfaces.add(obj);
                }
                return interfaces.toArray();
            }

            public Object getParent(Object element) {
                return element instanceof Operation ? ((Operation)element).getInterface() : null;
            }
        });
        this.opViewer.setLabelProvider((IBaseLabelProvider)ModelUtilities.getEMFLabelProvider());
        this.opEditorPage.getSelectionHandler().initialize(this.opViewer);
        super.setNoUpdatesAllowed(true);
        ((OperationEditorNotifyChangedListener)this.opEditorPage.getNotifyChangedListener()).initialize((Viewer)this.opViewer, this.opEditorPage.getEditorResource());
        this.opViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this, event){
                    private final /* synthetic */ SelectionChangedEvent val$event;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$event = val$event;
                    }

                    public void run() {
                        OperationObjectEditorPage.access$200(3.access$100(this.this$1), this.val$event);
                    }
                });
            }

            static /* synthetic */ OperationObjectEditorPage access$100(3 x0) {
                return x0.OperationObjectEditorPage.this;
            }
        });
        this.vSplitter = new SashForm((Composite)this.hSplitter, 512);
        this.declarationsToAssignments = new TreeMap(new Comparator(){

            public int compare(Object object1, Object object2) {
                if (object1 == null) {
                    return -1;
                }
                if (object2 == null) {
                    return 1;
                }
                return ((DeclareStatement)object1).getVariable().getShortName().compareTo(((DeclareStatement)object2).getVariable().getShortName());
            }
        });
        this.varSection = new InputVariableSection((Composite)this.vSplitter, VARS_DESC, this){

            protected void createActionControls(Composite parent) {
                OperationObjectEditorPage.this.createEditActionControl(parent);
            }
        };
        this.varSection.create();
        this.sqlPanelSection = toolkit.createSection((Composite)this.vSplitter, 384);
        this.sqlPanelSection.setText(PROC_TITLE);
        this.sqlPanelSection.setDescription(PROC_DESC);
        this.sqlEditorPanel = super.createSelectEditorForNoUpdate((Composite)this.sqlPanelSection);
        this.sqlEditorPanel.getTextViewer().getTextWidget().setEnabled(false);
        this.sqlPanelSection.setClient((Control)this.sqlEditorPanel);
        this.sqlEditorPanel.getQueryDisplayComponent().addPropertyListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                OperationObjectEditorPage.this.displayNodeUpdated(((QueryDisplayComponent)event.getSource()).getDisplayNode());
            }
        });
        IPreferenceStore store = WebServiceUiPlugin.getDefault().getPreferenceStore();
        int leftHWgt = store.getInt(LEFT_H_WGT_PREF);
        int rightHWgt = store.getInt(RIGHT_H_WGT_PREF);
        this.hSplitter.setWeights(new int[]{leftHWgt == 0 ? 250 : leftHWgt, rightHWgt == 0 ? 750 : rightHWgt});
        int topVWgt = store.getInt(TOP_V_WGT_PREF);
        int bottomVWgt = store.getInt(BOTTOM_V_WGT_PREF);
        this.vSplitter.setWeights(new int[]{topVWgt == 0 ? 250 : topVWgt, bottomVWgt == 0 ? 750 : bottomVWgt});
        this.sqlPanelSection.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                OperationObjectEditorPage.this.updateWeightPreferences();
            }
        });
        return this.sqlEditorPanel;
    }

    private void setSectionEnabled(Object section, boolean enable) {
        if (section == this.varSection) {
            this.varSection.setEnabled(enable);
        } else if (section == this.sqlPanelSection) {
            if (enable) {
                Color fgdColor = Display.getDefault().getSystemColor(21);
                this.sqlPanelSection.setEnabled(true);
                this.sqlPanelSection.setForeground(fgdColor);
                this.getTextWidget().setEnabled(true);
                this.getTextWidget().setEditable(true);
                this.getTextWidget().setForeground(fgdColor);
                this.editLink.setEnabled(true);
                WidgetUtil.enableFormText((FormText)this.editLink);
                this.editLink.setForeground(fgdColor);
            } else {
                Color fgdColor = Display.getDefault().getSystemColor(18);
                this.sqlPanelSection.setEnabled(false);
                this.sqlPanelSection.setForeground(fgdColor);
                this.getTextWidget().setEnabled(false);
                this.getTextWidget().setEditable(false);
                this.getTextWidget().setForeground(fgdColor);
                this.editLink.setForeground(fgdColor);
                this.editLink.setBackground(Display.getDefault().getSystemColor(1));
                WidgetUtil.disableFormText((FormText)this.editLink);
                this.showMessageArea(false);
            }
        }
    }

    protected List customizeActionList(List initialActionList) {
        initialActionList.remove("ExpandSelect");
        initialActionList.remove("ToggleOptimizer");
        initialActionList.remove("LaunchCriteriaBuilder");
        initialActionList.remove("LaunchExpressionBuilder");
        return initialActionList;
    }

    public boolean deactivate() {
        UiUtil.savePreferences((IPreferenceStore)WebServiceUiPlugin.getDefault().getPreferenceStore());
        return super.deactivate();
    }

    private void displayNodeUpdated(DisplayNode root) {
        root.setVisible(false, false);
        Iterator childIter = root.getChildren().iterator();
        while (childIter.hasNext()) {
            DisplayNode node = (DisplayNode)childIter.next();
            if (!(node instanceof BlockDisplayNode)) continue;
            this.declarationsToAssignments.clear();
            node.setVisible(false, false);
            HashMap<ElementSymbol, DeclareStatement> declarations = new HashMap<ElementSymbol, DeclareStatement>();
            Iterator blockIter = node.getChildren().iterator();
            while (blockIter.hasNext()) {
                AssignmentStatement assignment;
                Object declaration;
                DeclareStatement declaration2;
                node = (DisplayNode)blockIter.next();
                if (node instanceof DeclareStatementDisplayNode && (declaration2 = (DeclareStatement)node.getLanguageObject()).getVariable().getName().startsWith("VARIABLES.IN_")) {
                    declarations.put(declaration2.getVariable(), declaration2);
                    node.setVisible(false, true);
                }
                if (!(node instanceof AssignmentStatementDisplayNode) && !(node instanceof DeclareStatementDisplayNode) || (declaration = declarations.get((assignment = (AssignmentStatement)node.getLanguageObject()).getVariable())) == null) continue;
                this.declarationsToAssignments.put(declaration, assignment);
                node.setVisible(false, true);
            }
            this.varSection.refresh();
            break;
        }
    }

    public void edit(Object object) {
        super.edit(object);
        if (object != null) {
            Resource resrc = ((EObject)object).eResource();
            if (resrc == null && object instanceof Diagram) {
                resrc = ((Diagram)object).getTarget().eResource();
            }
            if (this.resrc == resrc) {
                this.selectOperation(this.getCurrentMappingRoot());
            } else {
                this.resrc = resrc;
                this.updateOperations();
            }
        }
    }

    private void editVariables() {
        if (this.editLink.getHyperlinkSettings().getHyperlinkUnderlineMode() == 1) {
            return;
        }
        new VariableEditorDialog(this.getControl().getShell(), this.varSection.getSelection(), this).open();
    }

    public BlockDisplayNode findBlock() {
        return this.findBlock(this.getCurrentSqlEditor().getQueryDisplayComponent().getDisplayNode());
    }

    private BlockDisplayNode findBlock(DisplayNode node) {
        if (node instanceof BlockDisplayNode) {
            return (BlockDisplayNode)node;
        }
        Iterator iter = node.getChildren().iterator();
        while (iter.hasNext()) {
            node = this.findBlock((DisplayNode)iter.next());
            if (node == null) continue;
            return (BlockDisplayNode)node;
        }
        return null;
    }

    public Map getDeclarationsToAssignments() {
        return this.declarationsToAssignments;
    }

    public Object getEditableObject(Object object) {
        Object obj = super.getEditableObject(object);
        if (obj == null && (obj = WebServiceUiUtil.getOperation(object)) != null) {
            obj = TransformationHelper.getTransformationMappingRoot((EObject)((Operation)obj));
        }
        return obj;
    }

    protected List getSeparatorLocations() {
        ArrayList<Integer> separatorLocs = new ArrayList<Integer>(6);
        separatorLocs.add(new Integer(1));
        separatorLocs.add(new Integer(3));
        separatorLocs.add(new Integer(4));
        separatorLocs.add(new Integer(6));
        return separatorLocs;
    }

    public String getTransformationName() {
        return NAME;
    }

    public void initialize(MultiPageModelEditor editor) {
        Iterator iter = editor.getObjectEditors().iterator();
        while (iter.hasNext()) {
            ModelObjectEditorPage objEditor = (ModelObjectEditorPage)iter.next();
            if (objEditor == this) continue;
            objEditor.setOverride((ModelObjectEditorPage)this);
        }
        iter = editor.getAllEditors().iterator();
        while (iter.hasNext()) {
            ModelEditorPage editorPg = (ModelEditorPage)iter.next();
            if (!(editorPg instanceof OperationEditorPage)) continue;
            this.opEditorPage = (OperationEditorPage)editorPg;
            this.opEditorPage.addWorkspaceSelectionListener(new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    OperationObjectEditorPage.this.workspaceSelectionChanged(selection);
                }
            });
        }
    }

    public boolean isResourceValid() {
        return true;
    }

    private void operationSelected(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object obj = selection.getFirstElement();
        if (obj instanceof Operation) {
            Operation op = (Operation)obj;
            if (op == this.selectedOp) {
                return;
            }
            ModelResource resrc = ModelUtilities.getModelResourceForModelObject((EObject)op);
            try {
                List transformations = resrc.getModelTransformations().getTransformations((EObject)op);
                if (!transformations.isEmpty()) {
                    WebServiceUiUtil.initializeProcedure(op, (Object)this, false);
                    this.setSectionEnabled(this.varSection, true);
                    this.setSectionEnabled(this.sqlPanelSection, true);
                    if (this.selectedOp != null) {
                        boolean dirty = this.isDirty();
                        this.doSave(false);
                        super.edit(transformations.get(0));
                        if (dirty && !this.isDirty()) {
                            this.setDirty(dirty);
                        }
                    } else {
                        super.edit(transformations.get(0));
                    }
                    this.selectedOp = op;
                    return;
                }
            }
            catch (ModelWorkspaceException err) {
                IInternalUiConstants.UTIL.log((Throwable)err);
            }
        } else {
            if (this.selectedOp != null) {
                this.doSave(false);
            }
            this.selectedOp = null;
            this.declarationsToAssignments.clear();
            this.varSection.refresh();
            super.edit(null);
            this.setSectionEnabled(this.varSection, false);
            this.setSectionEnabled(this.sqlPanelSection, false);
        }
    }

    public void refreshVariables() {
        this.varSection.refresh();
    }

    private void selectOperation(Object object) {
        Operation op = WebServiceUiUtil.getOperation(object);
        if (op != null && op.eResource() == this.resrc) {
            this.opViewer.setSelection((ISelection)new StructuredSelection((Object)op), true);
        }
    }

    private void updateOperations() {
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            public void run() {
                OperationObjectEditorPage.this.updateOperationsInSwtThread();
            }
        }, (boolean)true);
    }

    private void updateOperationsInSwtThread() {
        if (!this.opViewer.getTree().isDisposed()) {
            this.opViewer.setInput((Object)this.resrc.getContents());
            this.opViewer.expandAll();
            if (this.getCurrentMappingRoot() != null) {
                this.selectOperation(this.getCurrentMappingRoot());
            }
        }
    }

    private void updateWeightPreferences() {
        IPreferenceStore store = WebServiceUiPlugin.getDefault().getPreferenceStore();
        int[] wgts = this.hSplitter.getWeights();
        UiUtil.updateIntegerPreference((String)LEFT_H_WGT_PREF, (int)wgts[0], (int)250, (IPreferenceStore)store);
        UiUtil.updateIntegerPreference((String)RIGHT_H_WGT_PREF, (int)wgts[1], (int)750, (IPreferenceStore)store);
        wgts = this.vSplitter.getWeights();
        UiUtil.updateIntegerPreference((String)TOP_V_WGT_PREF, (int)wgts[0], (int)250, (IPreferenceStore)store);
        UiUtil.updateIntegerPreference((String)BOTTOM_V_WGT_PREF, (int)wgts[1], (int)750, (IPreferenceStore)store);
    }

    private void workspaceSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.selectOperation(((IStructuredSelection)selection).getFirstElement());
        }
    }

    private boolean confirmSourceReset() {
        boolean resetSource = false;
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        boolean disableCallbacks = prefStore.getBoolean("transformation.ui.preference.disableCallbacks");
        if (!disableCallbacks) {
            resetSource = MessageDialog.openQuestion(null, (String)DROP_CONFIRM_TITLE, (String)DROP_CONFIRM_MSG);
        }
        return resetSource;
    }

    public boolean allowsExternalEdits() {
        return this.allowsExternalEdits;
    }

    public void setAllowsExternalEdits(boolean theAllowExternalEdits) {
        this.allowsExternalEdits = theAllowExternalEdits;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$200(OperationObjectEditorPage x0, SelectionChangedEvent x1) {
        x0.operationSelected(x1);
    }

    static /* synthetic */ Operation access$900(OperationObjectEditorPage x0) {
        return x0.selectedOp;
    }

    public class MySqlPanelDropTargetListener
    extends SqlPanelDropTargetListener {
        SqlEditorPanel sqlPanel;

        public MySqlPanelDropTargetListener(SqlEditorPanel theSqlPanel, SqlTransformationMappingRoot theTransformation, Object theTxnSource) {
            super(theSqlPanel, theTransformation, theTxnSource);
            this.sqlPanel = theSqlPanel;
        }

        protected Point getXYPanelOffset() {
            Point newPt = new Point(3, -8);
            newPt.y += this.sqlPanel.getLocation().y;
            return newPt;
        }

        public boolean isEnabled(DropTargetEvent event) {
            return this.dragSourceIsDocument(event);
        }

        protected boolean isInsertOK(DropTargetEvent event) {
            return this.dragSourceIsDocument(event);
        }

        public void drop(DropTargetEvent event) {
            event.detail = 1;
            DropTargetEvent dtEvent = event;
            if (this.dragSourceIsDocument(event)) {
                UiBusyIndicator.showWhile(null, (Runnable)new Runnable(this, dtEvent){
                    private final /* synthetic */ DropTargetEvent val$dtEvent;
                    private final /* synthetic */ MySqlPanelDropTargetListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$dtEvent = val$dtEvent;
                    }

                    public void run() {
                        this.this$1.executeDropInFrom(this.this$1.getEventEObjects(this.val$dtEvent));
                        MySqlPanelDropTargetListener.access$800(this.this$1).edit(OperationObjectEditorPage.access$900(MySqlPanelDropTargetListener.access$800(this.this$1)));
                    }
                });
            }
        }

        private boolean dragSourceIsDocument(DropTargetEvent event) {
            boolean result = false;
            List eObjList = this.getEventEObjects(event);
            if (!eObjList.isEmpty() && eObjList.size() == 1) {
                result = eObjList.get(0) instanceof XmlDocument;
            }
            return result;
        }

        public void executeDropInFrom(List dropList) {
            if (dropList.size() != 1) {
                return;
            }
            SqlTransformationMappingRoot transformation = this.getTransformation();
            boolean canAdd = false;
            if (transformation != null) {
                canAdd = TransformationSourceManager.canAdd((EObject)transformation, (List)dropList, (Object)((Object)this));
            }
            if (canAdd) {
                XmlDocument document = null;
                if (!dropList.isEmpty() && dropList.size() == 1 && dropList.get(0) instanceof XmlDocument) {
                    document = (XmlDocument)dropList.get(0);
                }
                if (document != null) {
                    if (this.sqlIsEmpty()) {
                        WebServiceUiUtil.addXmlDocumentAsSource(transformation, document, (Object)this);
                    } else {
                        boolean shouldResetSource = OperationObjectEditorPage.this.confirmSourceReset();
                        if (shouldResetSource) {
                            WebServiceUiUtil.setXmlDocumentAsSource(transformation, document, (Object)this);
                        }
                    }
                }
            } else {
                TransformationSourceManager.warnUserAboutInvalidSources((List)dropList);
            }
        }

        public boolean sqlIsEmpty() {
            DisplayNode firstVisibleNode = this.sqlPanel.getQueryDisplayComponent().getFirstVisibleNode();
            return firstVisibleNode == null;
        }

        static /* synthetic */ OperationObjectEditorPage access$800(MySqlPanelDropTargetListener x0) {
            return x0.OperationObjectEditorPage.this;
        }
    }
}

