/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.aspects.validation.rules;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.DirectionKind;
import com.metamatrix.metamodels.relational.Procedure;
import com.metamatrix.metamodels.relational.ProcedureParameter;
import com.metamatrix.metamodels.relational.ProcedureResult;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TreeMappingRoot;
import com.metamatrix.metamodels.transformation.impl.MappingClassImpl;
import com.metamatrix.metamodels.transformation.impl.MappingClassSetImpl;
import com.metamatrix.metamodels.webservice.Operation;
import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.metamodels.xml.XmlRoot;
import com.metamatrix.metamodels.xml.impl.XmlDocumentImpl;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import com.metamatrix.modeler.core.metadata.runtime.TableRecord;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.validation.ObjectValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import com.metamatrix.modeler.internal.transformation.util.AttributeMappingHelper;
import com.metamatrix.modeler.internal.transformation.util.SqlAspectHelper;
import com.metamatrix.modeler.internal.transformation.util.SqlConverter;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.modeler.transformation.aspects.validation.rules.MappingClassTransformationValidationHelper;
import com.metamatrix.modeler.transformation.aspects.validation.rules.ProcedureParameterValidationHelper;
import com.metamatrix.modeler.transformation.aspects.validation.rules.ProjectSymbolsValidationHelper;
import com.metamatrix.modeler.transformation.validation.SqlTransformationResult;
import com.metamatrix.modeler.transformation.validation.TransformationValidationResult;
import com.metamatrix.modeler.transformation.validation.TransformationValidator;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.navigator.DeepPreOrderNavigator;
import com.metamatrix.query.sql.navigator.DeepSpParameterPreOrderNavigator;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.proc.HasCriteria;
import com.metamatrix.query.sql.proc.TranslateCriteria;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.CommandCollectorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.FunctionCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.PredicateCollectorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;

public class SqlTransformationMappingRootValidationRule
implements ObjectValidationRule {
    static /* synthetic */ Class class$com$metamatrix$metamodels$transformation$SqlTransformationMappingRoot;

    public void validate(EObject eObject, ValidationContext context) {
        ArgCheck.isInstanceOf((Class)(class$com$metamatrix$metamodels$transformation$SqlTransformationMappingRoot == null ? (class$com$metamatrix$metamodels$transformation$SqlTransformationMappingRoot = SqlTransformationMappingRootValidationRule.class$("com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot")) : class$com$metamatrix$metamodels$transformation$SqlTransformationMappingRoot), (Object)eObject);
        SqlTransformationMappingRoot transRoot = (SqlTransformationMappingRoot)eObject;
        ValidationResultImpl validationResult = new ValidationResultImpl((Object)transRoot, (Object)transRoot.getTarget());
        this.validateMapping(transRoot, (ValidationResult)validationResult);
        this.validateSourcesAndTargets(transRoot, (ValidationResult)validationResult);
        this.validMappingInputDependencies(transRoot, (ValidationResult)validationResult);
        this.validateUpdatability(transRoot, (ValidationResult)validationResult);
        TransformationValidator validator = new TransformationValidator(transRoot, context, true, true);
        this.validateSqlTransformation(transRoot, (ValidationResult)validationResult, validator, context);
        this.validateInputDocumentForWebService(transRoot, (ValidationResult)validationResult);
        context.addResult((ValidationResult)validationResult);
    }

    private void validateInputDocumentForWebService(SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        if (validationResult.isFatalObject((Object)transRoot)) {
            return;
        }
        EObject target = transRoot.getTarget();
        if (!(target instanceof Operation)) {
            return;
        }
        EList sources = transRoot.getInputs();
        Iterator iter = sources.iterator();
        while (iter.hasNext()) {
            EObject source = (EObject)iter.next();
            if (!(source instanceof XmlDocument)) continue;
            XmlDocument xmlDoc = (XmlDocument)source;
            XmlRoot rootElement = xmlDoc.getRoot();
            ModelContents mdlContents = ((EmfResource)source.eResource()).getModelContents();
            Iterator contentIter = mdlContents.getTransformations(source).iterator();
            if (!contentIter.hasNext()) {
                return;
            }
            while (contentIter.hasNext()) {
                MappingRoot mappingRoot = (MappingRoot)contentIter.next();
                if (mappingRoot == null || !(mappingRoot instanceof TreeMappingRoot)) continue;
                Iterator outputRootElementsIter = mappingRoot.getOutputs().iterator();
                while (outputRootElementsIter.hasNext()) {
                    if (!rootElement.equals(outputRootElementsIter.next())) continue;
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.xml_doc_mapped_at_root_for_web_service"));
                    validationResult.addProblem((ValidationProblem)problem);
                    return;
                }
            }
        }
    }

    public void validateSourcesAndTargets(SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        EObject target = transRoot.getTarget();
        Assertion.isNotNull((Object)target);
        Container container = ModelerCore.getContainer((EObject)transRoot);
        if (container == null) {
            return;
        }
        if (target.eIsProxy() && (target = EcoreUtil.resolve((EObject)target, (ResourceSet)container)).eIsProxy()) {
            return;
        }
        SqlAspect targetSqlAspect = SqlAspectHelper.getSqlAspect((EObject)target);
        if (targetSqlAspect == null || !(targetSqlAspect instanceof SqlTableAspect) && !(targetSqlAspect instanceof SqlProcedureAspect)) {
            ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.no_valid_target"));
            validationResult.addProblem((ValidationProblem)typeProblem);
            return;
        }
        EList sources = transRoot.getInputs();
        Iterator iter = sources.iterator();
        while (iter.hasNext()) {
            EObject source = (EObject)iter.next();
            if (source.eIsProxy() && (source = EcoreUtil.resolve((EObject)source, (ResourceSet)container)).eIsProxy()) {
                return;
            }
            SqlAspect sourceSqlAspect = SqlAspectHelper.getSqlAspect((EObject)source);
            if (sourceSqlAspect == null || !(sourceSqlAspect instanceof SqlTableAspect) && !(sourceSqlAspect instanceof SqlProcedureAspect)) {
                ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.no_valid_source"));
                validationResult.addProblem((ValidationProblem)typeProblem);
                return;
            }
            boolean isValidSource = true;
            if (targetSqlAspect instanceof SqlTableAspect) {
                isValidSource = ((SqlTableAspect)targetSqlAspect).canAcceptTransformationSource(target, source);
            } else if (targetSqlAspect instanceof SqlProcedureAspect) {
                isValidSource = ((SqlProcedureAspect)targetSqlAspect).canAcceptTransformationSource(target, source);
            }
            if (!isValidSource) {
                String targetName = targetSqlAspect.getName(target);
                String sourceName = sourceSqlAspect.getName(source);
                ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.invalid_source_for_target", (Object)sourceName, (Object)targetName));
                validationResult.addProblem((ValidationProblem)typeProblem);
                return;
            }
            boolean isValidTarget = true;
            if (sourceSqlAspect instanceof SqlTableAspect) {
                isValidTarget = ((SqlTableAspect)sourceSqlAspect).canBeTransformationSource(source, target);
            } else if (sourceSqlAspect instanceof SqlProcedureAspect) {
                isValidTarget = ((SqlProcedureAspect)sourceSqlAspect).canBeTransformationSource(source, target);
            }
            if (isValidTarget) continue;
            String targetName = targetSqlAspect.getName(target);
            String sourceName = sourceSqlAspect.getName(source);
            ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.invalid_target_for_source", (Object)targetName, (Object)sourceName));
            validationResult.addProblem((ValidationProblem)typeProblem);
            return;
        }
    }

    private void validMappingInputDependencies(SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        if (validationResult.isFatalObject((Object)transRoot)) {
            return;
        }
        Collection inputs = this.getMappingInputs(transRoot, true);
        EObject target = transRoot.getTarget();
        Iterator iter = inputs.iterator();
        while (iter.hasNext()) {
            EObject source = (EObject)iter.next();
            if (source == null || source != target) continue;
            Object[] params = new Object[]{ModelerCore.getModelEditor().getModelRelativePathIncludingModel(source)};
            String msg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.A_circular_dependency_exists_between_this_tranformation_and_the_source_group_0_1", params);
            ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, msg);
            validationResult.addProblem((ValidationProblem)typeProblem);
        }
    }

    private void validateMapping(SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        if (validationResult.isFatalObject((Object)transRoot)) {
            return;
        }
        EList outputs = transRoot.getOutputs();
        if (outputs.size() < 1) {
            String modelName = ModelerCore.getModelEditor().getModelName((EObject)transRoot).toString();
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.Sql_transformation_in_the_model_{0},_has_no_target_tables/groups._1", (Object)modelName));
            validationResult.addProblem((ValidationProblem)problem);
        } else if (outputs.size() > 1) {
            String modelName = ModelerCore.getModelEditor().getModelName((EObject)transRoot).toString();
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.Sql_transformation_in_the_model_{0},_cannot_not_have_multiple_target_tables/groups._2", (Object)modelName));
            validationResult.addProblem((ValidationProblem)problem);
        } else {
            EObject output = (EObject)outputs.iterator().next();
            Iterator inputIter = transRoot.getInputs().iterator();
            while (inputIter.hasNext()) {
                if (output != inputIter.next()) continue;
                String msg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_virtual_group_{0}_cannot_be_involved_as_an_input_to_the_transformation_defining_it._1", (Object)TransformationHelper.getSqlEObjectName(output));
                ValidationProblemImpl failureProblem = new ValidationProblemImpl(0, 4, msg);
                validationResult.addProblem((ValidationProblem)failureProblem);
            }
        }
    }

    private void validateUpdateProcedures(TransformationValidationResult transformResult, SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        Command deleteCommand;
        Command updateCommand;
        Command insertCommand;
        if (validationResult.isFatalObject((Object)transRoot)) {
            return;
        }
        EObject target = transRoot.getTarget();
        if (!(target instanceof Table) || !((Table)target).isSupportsUpdate()) {
            return;
        }
        if (transformResult.hasInsertResult() && (insertCommand = transformResult.getInsertResult().getCommand()) != null) {
            this.validateSubCommands(insertCommand, 2, transRoot, validationResult);
        }
        if (transformResult.hasUpdateResult() && (updateCommand = transformResult.getUpdateResult().getCommand()) != null) {
            this.validateSubCommands(updateCommand, 3, transRoot, validationResult);
        }
        if (transformResult.hasDeleteResult() && (deleteCommand = transformResult.getDeleteResult().getCommand()) != null) {
            this.validateSubCommands(deleteCommand, 4, transRoot, validationResult);
        }
    }

    private void validateSubCommands(Command command, int subCmdType, SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        ValidationProblemImpl typeProblem = null;
        int superType = command.getType();
        boolean foundDesiredSubCmd = false;
        List commands = CommandCollectorVisitor.getCommands((LanguageObject)command);
        EObject target = transRoot.getTarget();
        Iterator cmdIter = commands.iterator();
        while (cmdIter.hasNext()) {
            Command subCommand = (Command)cmdIter.next();
            int currentCmdType = subCommand.getType();
            if (currentCmdType == subCmdType) {
                foundDesiredSubCmd = true;
            }
            switch (currentCmdType) {
                case 1: {
                    if (!(subCommand instanceof Query)) break;
                    this.validateQuery((Query)subCommand, transRoot, validationResult);
                    break;
                }
                case 2: {
                    if (superType != 7) break;
                    if (this.containsTarget(subCommand, target)) {
                        typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_insert_procedure_for_the_virtualGroup_{0},_is_trying_to_execute_an_insert_against_itself._1", (Object)TransformationHelper.getSqlEObjectName(target)));
                        break;
                    }
                    if (!this.hasTranslateCriteria(subCommand)) break;
                    typeProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.Translate/Has_Criteria_on_an_insert_procedure_would_always_evaluate_to_false._3"));
                    break;
                }
                case 3: {
                    if (superType != 7 || !this.containsTarget(subCommand, target)) break;
                    typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_update_procedure_for_the_virtualGroup_{0},_is_trying_to_execute_an_update_against_itself._2", (Object)TransformationHelper.getSqlEObjectName(target)));
                    break;
                }
                case 4: {
                    if (superType != 7 || !this.containsTarget(subCommand, target)) break;
                    typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_delete_procedure_for_the_virtualGroup_{0},_is_trying_to_execute_an_delete_against_itself._3", (Object)TransformationHelper.getSqlEObjectName(target)));
                    break;
                }
            }
            validationResult.addProblem(typeProblem);
            if (typeProblem != null && typeProblem.getSeverity() == 4) {
                return;
            }
            this.validateSubCommands(subCommand, 0, transRoot, validationResult);
        }
        if (subCmdType != 0 && !foundDesiredSubCmd) {
            switch (subCmdType) {
                case 2: {
                    typeProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_insert_procedure_for_the_virtualGroup_{0}_does____not_execute_an_insert._1", (Object)TransformationHelper.getSqlEObjectName(target)));
                    break;
                }
                case 3: {
                    typeProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_update_procedure_for_the_virtualGroup_{0}_does____not_execute_an_update._2", (Object)TransformationHelper.getSqlEObjectName(target)));
                    break;
                }
                case 4: {
                    typeProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_delete_procedure_for_the_virtualGroup_{0}_does____not_execute_an_delete._3", (Object)TransformationHelper.getSqlEObjectName(target)));
                    break;
                }
            }
            validationResult.addProblem(typeProblem);
        }
    }

    private boolean containsTarget(Command command, EObject target) {
        String targetName = TransformationHelper.getSqlEObjectFullName(target);
        String targetUUID = TransformationHelper.getSqlEObjectUUID(target);
        Iterator grpIter = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)true).iterator();
        while (grpIter.hasNext()) {
            GroupSymbol group = (GroupSymbol)grpIter.next();
            if (!group.getName().equalsIgnoreCase(targetUUID) && !group.getName().equalsIgnoreCase(targetName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasTranslateCriteria(Command command) {
        Iterator predIter = PredicateCollectorVisitor.getPredicates((LanguageObject)command).iterator();
        while (predIter.hasNext()) {
            Object criteria = predIter.next();
            if (!(criteria instanceof TranslateCriteria) && !(criteria instanceof HasCriteria)) continue;
            return true;
        }
        return false;
    }

    private void validateVirtualProcedures(Command command, SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        int cmdType;
        ValidationProblemImpl typeProblem;
        if (validationResult.isFatalObject((Object)transRoot)) {
            return;
        }
        EObject target = transRoot.getTarget();
        if (!(target instanceof Procedure)) {
            return;
        }
        Procedure procTrgt = (Procedure)target;
        ProcedureResult procResult = procTrgt.getResult();
        if (procResult == null) {
            ValidationProblemImpl typeProblem2 = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.Virtual_stored_procedures_should_always_return_a_resultSet._1"));
            validationResult.addProblem((ValidationProblem)typeProblem2);
            return;
        }
        Collection elements = this.getElementsIncludeParameters((LanguageObject)command);
        HashSet<String> upperSymbolNames = new HashSet<String>(elements.size());
        Iterator elmntIter = elements.iterator();
        while (elmntIter.hasNext()) {
            ElementSymbol symbol = (ElementSymbol)elmntIter.next();
            String symbolUpperName = AttributeMappingHelper.getSymbolFullName((SingleElementSymbol)symbol).toUpperCase();
            upperSymbolNames.add(symbolUpperName);
        }
        EList parameters = procTrgt.getParameters();
        boolean paramUsed = parameters.isEmpty();
        Iterator paramIter = parameters.iterator();
        while (paramIter.hasNext()) {
            String paramUpperName;
            String paramName;
            SqlAspect sqlAspect;
            ProcedureParameter param = (ProcedureParameter)paramIter.next();
            DirectionKind direction = param.getDirection();
            if (direction.getValue() != 0) {
                typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.A_virtual_stored_procedure_can_only_define_IN_parameters._2"));
                validationResult.addProblem((ValidationProblem)typeProblem);
                return;
            }
            if (paramUsed || (sqlAspect = AspectManager.getSqlAspect((EObject)param)) == null || (paramName = sqlAspect.getFullName((EObject)param)) == null || !upperSymbolNames.contains(paramUpperName = paramName.toUpperCase())) continue;
            paramUsed = true;
        }
        if (!paramUsed) {
            ValidationProblemImpl typeProblem3 = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.Sql_Transform_defining_the_virtual_procedure_{0}_does_not_use_any_of_the_parameters_defined_on_the_procedure._1", (Object)procTrgt.getName()));
            validationResult.addProblem((ValidationProblem)typeProblem3);
        }
        if ((cmdType = command.getType()) == 7 && ((CreateUpdateProcedureCommand)command).isUpdateProcedure()) {
            ValidationProblemImpl typeProblem4 = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.Virtual_stored_procedures_transformation_definition_cannot_be_an_updateProcedure._3"));
            validationResult.addProblem((ValidationProblem)typeProblem4);
            return;
        }
        if (cmdType == 2 || cmdType == 3 || cmdType == 4) {
            EList columns = procResult.getColumns();
            String typeName = null;
            if (columns.size() == 1) {
                Column column = (Column)columns.iterator().next();
                EObject columnType = column.getType();
                if (columnType == null) {
                    return;
                }
                DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)column, (boolean)true);
                typeName = dtMgr.getName(columnType);
            }
            if (typeName == null || !typeName.equals("int")) {
                typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.Virtual_stored_procedures_defined_by_an_Insert,_Update_or_Delete_statement_must_define_return_a_resultSet_with_one_column_of_type_int._4"));
                validationResult.addProblem((ValidationProblem)typeProblem);
            }
        }
    }

    private Collection getElementsIncludeParameters(LanguageObject obj) {
        if (obj == null) {
            return Collections.EMPTY_LIST;
        }
        HashSet elements = new HashSet();
        ElementCollectorVisitor visitor = new ElementCollectorVisitor(elements);
        DeepSpParameterPreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        return elements;
    }

    private void validateUpdatability(SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        if (validationResult.isFatalObject((Object)transRoot)) {
            return;
        }
        EList inputs = transRoot.getInputs();
        EList outputs = transRoot.getOutputs();
        if (outputs.isEmpty() || inputs.isEmpty()) {
            return;
        }
        EObject targetObj = (EObject)outputs.iterator().next();
        if (SqlAspectHelper.isUpdatableGroup((EObject)targetObj)) {
            boolean updatable = false;
            Iterator inIter = inputs.iterator();
            while (inIter.hasNext()) {
                EObject sourceObj = (EObject)inIter.next();
                if (!SqlAspectHelper.isUpdatableGroup((EObject)sourceObj)) continue;
                updatable = true;
                break;
            }
            if (!updatable) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_transformation_defining_an_updatable_virtual_group_should_be_include_atleast_one_updatable_source_group._1", (Object)TransformationHelper.getSqlEObjectName(targetObj)));
                validationResult.addProblem((ValidationProblem)problem);
            }
        }
    }

    private void validateSqlTransformation(SqlTransformationMappingRoot transRoot, ValidationResult validationResult, TransformationValidator validator, ValidationContext context) {
        SqlTransformationResult selectResult;
        if (validationResult.isFatalObject((Object)transRoot)) {
            return;
        }
        TransformationValidationResult transformResult = validator.validateTransformation();
        EObject target = transRoot.getTarget();
        String targetPath = TransformationHelper.getSqlEObjectPath(target);
        if (!transformResult.isValid()) {
            List transformStatuses;
            Collection deleteStatuses;
            SqlTransformationResult deleteResult;
            Collection updateStatuses;
            SqlTransformationResult updateResult;
            Collection insertStatuses;
            SqlTransformationResult insertResult;
            Collection selectStatuses;
            Collection statuses = null;
            SqlTransformationResult selectResult2 = transformResult.getSelectResult();
            if (selectResult2 != null && !selectResult2.isValidatable() && (selectStatuses = selectResult2.getStatusList()) != null) {
                if (statuses == null) {
                    statuses = selectStatuses;
                } else {
                    statuses.addAll(selectStatuses);
                }
            }
            if ((insertResult = transformResult.getInsertResult()) != null && !insertResult.isValidatable() && (insertStatuses = insertResult.getStatusList()) != null) {
                if (statuses == null) {
                    statuses = insertStatuses;
                } else {
                    statuses.addAll(insertStatuses);
                }
            }
            if ((updateResult = transformResult.getUpdateResult()) != null && !updateResult.isValidatable() && (updateStatuses = updateResult.getStatusList()) != null) {
                if (statuses == null) {
                    statuses = updateStatuses;
                } else {
                    statuses.addAll(updateStatuses);
                }
            }
            if ((deleteResult = transformResult.getDeleteResult()) != null && !deleteResult.isValidatable() && (deleteStatuses = deleteResult.getStatusList()) != null) {
                if (statuses == null) {
                    statuses = deleteStatuses;
                } else {
                    statuses.addAll(deleteStatuses);
                }
            }
            if ((transformStatuses = transformResult.getStatusList()) != null) {
                if (statuses == null) {
                    statuses = transformStatuses;
                } else {
                    statuses.addAll(transformStatuses);
                }
            }
            if (statuses != null) {
                Iterator statusIter = statuses.iterator();
                while (statusIter.hasNext()) {
                    ValidationProblemImpl failureProblem = new ValidationProblemImpl((IStatus)statusIter.next());
                    validationResult.addProblem((ValidationProblem)failureProblem);
                }
            }
            return;
        }
        if (SqlAspectHelper.isUpdatableGroup((EObject)target)) {
            if (transformResult.isInsertAllowed() && !transformResult.hasInsertResult() || transformResult.isUpdateAllowed() && !transformResult.hasUpdateResult() || transformResult.isDeleteAllowed() && !transformResult.hasDeleteResult()) {
                String msg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_transformation_on_the_updatable_virtual_group_{0},_allows_Insert/Update/Delete_but_does_not_define_the_necessary_transformation._1", (Object)targetPath);
                ValidationProblemImpl failureProblem = new ValidationProblemImpl(0, 4, msg);
                validationResult.addProblem((ValidationProblem)failureProblem);
                return;
            }
            this.validateUpdateProcedures(transformResult, transRoot, validationResult);
        }
        if ((selectResult = transformResult.getSelectResult()) != null) {
            int pref;
            Command command = selectResult.getCommand();
            if (command != null) {
                if (command instanceof Query) {
                    this.validateQuery((Query)command, transRoot, validationResult);
                }
                this.validateSubCommands(command, 0, transRoot, validationResult);
            }
            if (!validationResult.isFatalObject((Object)transRoot)) {
                ProjectSymbolsValidationHelper projRule = new ProjectSymbolsValidationHelper();
                projRule.validateProjectedSymbols(command, transRoot, validationResult);
                this.validateVirtualProcedures(command, transRoot, validationResult);
                MappingClassTransformationValidationHelper rule = new MappingClassTransformationValidationHelper();
                rule.validate(command, transRoot, validationResult);
                ProcedureParameterValidationHelper procParamRule = new ProcedureParameterValidationHelper();
                procParamRule.validateProcedureParameters(command, transRoot, validationResult);
            }
            if ((pref = context.getPreferenceStatus("corePreferences.stringFunctionsAreOneBased", 2)) != 0) {
                HashSet functions = new HashSet();
                FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(functions);
                DeepPreOrderNavigator.doVisit((LanguageObject)command, (LanguageVisitor)visitor);
                Iterator iter = functions.iterator();
                while (iter.hasNext()) {
                    Function function = (Function)iter.next();
                    String functionName = function.getName().toUpperCase();
                    if (!"SUBSTRING".equals(functionName) && !"LOCATE".equals(functionName) && !"INSERT".equals(functionName)) continue;
                    ValidationProblemImpl stringFunctionWarning = new ValidationProblemImpl(0, pref, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.STRING_BASED_FUNCTION_ONE_BASED"));
                    stringFunctionWarning.setHasPreference(context.hasPreferences());
                    validationResult.addProblem((ValidationProblem)stringFunctionWarning);
                    break;
                }
            }
        }
    }

    private void validateQuery(Query query, SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        Collection predicates = PredicateCollectorVisitor.getPredicates((LanguageObject)query);
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)query, (boolean)true);
        if (predicates.isEmpty() && groups.size() > 1) {
            ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.6", (Object)this.getNamesForGroupSymbols(groups)));
            validationResult.addProblem((ValidationProblem)warningProblem);
            this.appendDocumentLocation(transRoot, validationResult);
        } else if (groups.size() > 1) {
            ArrayList allJoins = new ArrayList();
            Iterator predicateIter = predicates.iterator();
            while (predicateIter.hasNext()) {
                Class rightDataType;
                Class leftDataType;
                String descriptorName;
                Object predicate = predicateIter.next();
                if (!(predicate instanceof CompareCriteria)) continue;
                CompareCriteria compare = (CompareCriteria)predicate;
                HashSet<GroupSymbol> groupsInJoin = new HashSet<GroupSymbol>();
                Iterator elementIter = ElementCollectorVisitor.getElements((LanguageObject)compare, (boolean)true).iterator();
                while (elementIter.hasNext()) {
                    ElementSymbol element = (ElementSymbol)elementIter.next();
                    GroupSymbol group = element.getGroupSymbol();
                    if (group == null && element.isExternalReference()) {
                        String elementFullName = element.getName();
                        int grpIndex = elementFullName.indexOf(element.getShortName());
                        String groupName = elementFullName.substring(0, grpIndex - 1);
                        group = new GroupSymbol(groupName);
                    }
                    if (group == null) continue;
                    groupsInJoin.add(group);
                }
                if (groupsInJoin.size() > 1) {
                    allJoins.add(groupsInJoin);
                }
                if (compare.getOperator() != 1) continue;
                Expression leftExpression = compare.getLeftExpression();
                Expression rightExpression = compare.getRightExpression();
                if (leftExpression instanceof Function) {
                    Function leftFunction = (Function)leftExpression;
                    descriptorName = leftFunction.getFunctionDescriptor().getName();
                    if (leftFunction.isImplicit() && descriptorName != null && (descriptorName.equals("convert") || descriptorName.equals("cast"))) {
                        leftExpression = leftFunction.getArg(0);
                    }
                }
                if (rightExpression instanceof Function) {
                    Function rightFunction = (Function)rightExpression;
                    descriptorName = rightFunction.getFunctionDescriptor().getName();
                    if (rightFunction.isImplicit() && descriptorName != null && (descriptorName.equals("convert") || descriptorName.equals("cast"))) {
                        rightExpression = rightFunction.getArg(0);
                    }
                }
                if (!(leftExpression instanceof ElementSymbol) || !(rightExpression instanceof ElementSymbol) || (leftDataType = leftExpression.getType()).equals(rightDataType = rightExpression.getType())) continue;
                String critStr = SqlConverter.convertToString((String)compare.toString(), (EObject)transRoot, (int)0, (boolean)true);
                Object[] params = new Object[]{critStr, DataTypeManager.getDataTypeName((Class)leftDataType), DataTypeManager.getDataTypeName((Class)rightDataType)};
                ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.Join_type_mismatch_in_crit", params));
                validationResult.addProblem((ValidationProblem)warningProblem);
                this.appendDocumentLocation(transRoot, validationResult);
            }
            HashSet groupsJoined = new HashSet();
            if (allJoins.size() == 1) {
                groupsJoined.addAll((Collection)allJoins.get(0));
            } else {
                for (int i = 0; i < allJoins.size(); ++i) {
                    Collection join1 = (Collection)allJoins.get(i);
                    block3: for (int j = i + 1; j < allJoins.size(); ++j) {
                        Collection join2 = (Collection)allJoins.get(j);
                        Iterator grpIter = join2.iterator();
                        while (grpIter.hasNext()) {
                            GroupSymbol joinGrp = (GroupSymbol)grpIter.next();
                            if (!join1.contains(joinGrp)) continue;
                            groupsJoined.addAll(join1);
                            groupsJoined.addAll(join2);
                            continue block3;
                        }
                    }
                }
            }
            if (!groupsJoined.containsAll(groups)) {
                groups.removeAll(groupsJoined);
                ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.6", (Object)this.getNamesForGroupSymbols(groups)));
                validationResult.addProblem((ValidationProblem)warningProblem);
                this.appendDocumentLocation(transRoot, validationResult);
            }
        }
        this.validateOption((Command)query, transRoot, validationResult);
    }

    private void appendDocumentLocation(SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        String docName = this.getDocumentName(transRoot);
        if (docName != null) {
            validationResult.setLocationPath(docName + "/" + validationResult.getLocationPath());
        }
    }

    private String getDocumentName(SqlTransformationMappingRoot transRoot) {
        String docName = null;
        try {
            EObject xmlDocumentImpl;
            EObject mappingClassSetImpl;
            EObject mappingClassImpl = transRoot.getTarget();
            if (mappingClassImpl instanceof MappingClassImpl && (mappingClassSetImpl = ((MappingClassImpl)mappingClassImpl).eContainer()) instanceof MappingClassSetImpl && (xmlDocumentImpl = ((MappingClassSetImpl)mappingClassSetImpl).getTarget()) instanceof XmlDocumentImpl) {
                docName = ((XmlDocumentImpl)xmlDocumentImpl).getName();
            }
        }
        catch (Exception ex) {
            TransformationPlugin.Util.log(2, (Throwable)ex, ex.getMessage());
        }
        return docName;
    }

    private Collection getNamesForGroupSymbols(Collection groups) {
        HashSet<String> groupNames = new HashSet<String>(groups.size());
        Iterator iter = groups.iterator();
        while (iter.hasNext()) {
            GroupSymbol grpSyb = (GroupSymbol)iter.next();
            Object metadataID = grpSyb.getMetadataID();
            if (metadataID != null && metadataID instanceof MetadataRecord) {
                groupNames.add(((MetadataRecord)metadataID).getFullName());
                continue;
            }
            groupNames.add(grpSyb.getName());
        }
        return groupNames;
    }

    private void validateOption(Command command, SqlTransformationMappingRoot root, ValidationResult result) {
        Option option = command.getOption();
        if (option == null) {
            return;
        }
        this.validateDepOptionGroups(option.getDependentGroups(), root, result);
        this.validateDepOptionGroups(option.getNotDependentGroups(), root, result);
        this.validateOptionNoCacheGrps(command, root, result);
    }

    private void validateDepOptionGroups(Collection groupNames, SqlTransformationMappingRoot root, ValidationResult result) {
        if (groupNames == null || groupNames.isEmpty()) {
            return;
        }
        Iterator iter = groupNames.iterator();
        while (iter.hasNext()) {
            String groupName = (String)iter.next();
            if (groupName.indexOf(46) >= 0) continue;
            ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.0", (Object)groupName));
            result.addProblem((ValidationProblem)warningProblem);
        }
    }

    private void validateOptionNoCacheGrps(Command command, SqlTransformationMappingRoot root, ValidationResult result) {
        Option option = command.getOption();
        if (option == null || !option.isNoCache()) {
            return;
        }
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)true);
        List noCacheGroups = option.getNoCacheGroups();
        boolean hasMaterializedGroups = false;
        if (noCacheGroups != null) {
            Iterator iter = noCacheGroups.iterator();
            while (iter.hasNext()) {
                String groupName = (String)iter.next();
                boolean foundMaterializedMatch = false;
                LinkedList<String> shortNamesMatched = new LinkedList<String>();
                LinkedList<String> partialNamesMatched = new LinkedList<String>();
                LinkedList<String> aliasNamesMatched = new LinkedList<String>();
                Iterator grpIter = groups.iterator();
                while (grpIter.hasNext()) {
                    GroupSymbol grpSymbol = (GroupSymbol)grpIter.next();
                    Object metadataID = grpSymbol.getMetadataID();
                    if (metadataID == null || !(metadataID instanceof TableRecord)) continue;
                    TableRecord record = (TableRecord)metadataID;
                    String tableFullName = record.getFullName();
                    String tableShortName = record.getName();
                    String aliasName = grpSymbol.getDefinition() != null ? grpSymbol.getName() : null;
                    boolean isMaterialized = record.isMaterialized();
                    if (isMaterialized) {
                        hasMaterializedGroups = true;
                    }
                    if (isMaterialized && groupName.equalsIgnoreCase(tableFullName)) {
                        foundMaterializedMatch = true;
                        break;
                    }
                    if (groupName.equalsIgnoreCase(tableShortName)) {
                        if (!shortNamesMatched.contains(groupName.toUpperCase())) {
                            shortNamesMatched.add(groupName.toUpperCase());
                            if (!isMaterialized) continue;
                            foundMaterializedMatch = true;
                            continue;
                        }
                        ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.7", (Object)groupName));
                        result.addProblem((ValidationProblem)warningProblem);
                        return;
                    }
                    if (aliasName != null && groupName.equalsIgnoreCase(aliasName)) {
                        if (!aliasNamesMatched.contains(groupName.toUpperCase())) {
                            aliasNamesMatched.add(groupName.toUpperCase());
                            if (!isMaterialized) continue;
                            foundMaterializedMatch = true;
                            continue;
                        }
                        ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.8", (Object)groupName));
                        result.addProblem((ValidationProblem)warningProblem);
                        return;
                    }
                    if (!StringUtil.endsWithIgnoreCase((String)tableFullName, (String)groupName)) continue;
                    if (!partialNamesMatched.contains(tableFullName.toUpperCase())) {
                        partialNamesMatched.add(tableFullName.toUpperCase());
                        if (!isMaterialized) continue;
                        foundMaterializedMatch = true;
                        continue;
                    }
                    ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.11", (Object)groupName));
                    result.addProblem((ValidationProblem)warningProblem);
                    return;
                }
                if (foundMaterializedMatch) continue;
                ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.9", (Object)groupName));
                result.addProblem((ValidationProblem)warningProblem);
                return;
            }
        }
        if (!hasMaterializedGroups && (noCacheGroups == null || noCacheGroups.isEmpty())) {
            ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.10"));
            result.addProblem((ValidationProblem)warningProblem);
            return;
        }
    }

    private Collection getMappingInputs(SqlTransformationMappingRoot root, boolean recursive) {
        if (root != null) {
            HashSet result = new HashSet();
            HashSet visitedMappings = new HashSet();
            this.addInputsToCollection((Mapping)root, result, visitedMappings, recursive);
            return result;
        }
        return Collections.EMPTY_SET;
    }

    private void addInputsToCollection(Mapping mapping, Collection result, Collection visitedMappings, boolean recursive) {
        if (mapping != null) {
            if (visitedMappings.contains(mapping)) {
                return;
            }
            visitedMappings.add(mapping);
            result.addAll(mapping.getInputs());
            if (!recursive) {
                return;
            }
            Iterator iter = mapping.getInputs().iterator();
            while (iter.hasNext()) {
                EmfResource emfResource;
                ModelAnnotation model;
                EObject input = (EObject)iter.next();
                Container container = ModelerCore.getContainer((EObject)mapping);
                Resource resource = ModelerCore.getModelEditor().findResource(container, input);
                if (!(resource instanceof EmfResource) || (model = (emfResource = (EmfResource)resource).getModelAnnotation()) == null || model.getModelType() != ModelType.VIRTUAL_LITERAL) continue;
                ModelContents contents = emfResource.getModelContents();
                List xforms = contents.getTransformations(input);
                Iterator iterator = xforms.iterator();
                while (iterator.hasNext()) {
                    TransformationMappingRoot mappingRoot = (TransformationMappingRoot)iterator.next();
                    this.addInputsToCollection((Mapping)mappingRoot, result, visitedMappings, recursive);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

