/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.language;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.data.language.IAggregate;
import com.metamatrix.data.language.IBatchedUpdates;
import com.metamatrix.data.language.ICaseExpression;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.ICompoundCriteria;
import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IDelete;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExistsCriteria;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFrom;
import com.metamatrix.data.language.IFromItem;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.IGroup;
import com.metamatrix.data.language.IGroupBy;
import com.metamatrix.data.language.IInCriteria;
import com.metamatrix.data.language.IInsert;
import com.metamatrix.data.language.IIsNullCriteria;
import com.metamatrix.data.language.IJoin;
import com.metamatrix.data.language.ILikeCriteria;
import com.metamatrix.data.language.ILimit;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.INotCriteria;
import com.metamatrix.data.language.IOrderBy;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISearchedCaseExpression;
import com.metamatrix.data.language.ISelect;
import com.metamatrix.data.language.ISubqueryCompareCriteria;
import com.metamatrix.data.language.ISubqueryInCriteria;
import com.metamatrix.data.language.IUnion;
import com.metamatrix.data.language.IUpdate;
import com.metamatrix.data.metadata.runtime.MetadataID;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.datamgr.language.AggregateImpl;
import com.metamatrix.dqp.internal.datamgr.language.BatchedUpdatesImpl;
import com.metamatrix.dqp.internal.datamgr.language.BulkInsertImpl;
import com.metamatrix.dqp.internal.datamgr.language.CaseExpressionImpl;
import com.metamatrix.dqp.internal.datamgr.language.CompareCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.CompoundCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.DeleteImpl;
import com.metamatrix.dqp.internal.datamgr.language.ElementImpl;
import com.metamatrix.dqp.internal.datamgr.language.ExistsCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.FromImpl;
import com.metamatrix.dqp.internal.datamgr.language.FunctionImpl;
import com.metamatrix.dqp.internal.datamgr.language.GroupByImpl;
import com.metamatrix.dqp.internal.datamgr.language.GroupImpl;
import com.metamatrix.dqp.internal.datamgr.language.InCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.InlineViewImpl;
import com.metamatrix.dqp.internal.datamgr.language.InsertImpl;
import com.metamatrix.dqp.internal.datamgr.language.IsNullCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.JoinImpl;
import com.metamatrix.dqp.internal.datamgr.language.LikeCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.LimitImpl;
import com.metamatrix.dqp.internal.datamgr.language.LiteralImpl;
import com.metamatrix.dqp.internal.datamgr.language.NotCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.OrderByImpl;
import com.metamatrix.dqp.internal.datamgr.language.OrderByItemImpl;
import com.metamatrix.dqp.internal.datamgr.language.ParameterImpl;
import com.metamatrix.dqp.internal.datamgr.language.ProcedureImpl;
import com.metamatrix.dqp.internal.datamgr.language.QueryImpl;
import com.metamatrix.dqp.internal.datamgr.language.ScalarSubqueryImpl;
import com.metamatrix.dqp.internal.datamgr.language.SearchedCaseExpressionImpl;
import com.metamatrix.dqp.internal.datamgr.language.SelectImpl;
import com.metamatrix.dqp.internal.datamgr.language.SelectSymbolImpl;
import com.metamatrix.dqp.internal.datamgr.language.SubqueryCompareCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.SubqueryInCriteriaImpl;
import com.metamatrix.dqp.internal.datamgr.language.UnionImpl;
import com.metamatrix.dqp.internal.datamgr.language.UpdateImpl;
import com.metamatrix.dqp.internal.datamgr.metadata.MetadataFactory;
import com.metamatrix.dqp.internal.datamgr.metadata.ProcedureIDImpl;
import com.metamatrix.query.o.i.a;
import com.metamatrix.query.o.i.c;
import com.metamatrix.query.o.i.d;
import com.metamatrix.query.o.i.e;
import com.metamatrix.query.o.i.f;
import com.metamatrix.query.o.i.n;
import com.metamatrix.query.o.i.o;
import com.metamatrix.query.o.j.ab;
import com.metamatrix.query.o.j.ac;
import com.metamatrix.query.o.j.af;
import com.metamatrix.query.o.j.ag;
import com.metamatrix.query.o.j.ai;
import com.metamatrix.query.o.j.aj;
import com.metamatrix.query.o.j.al;
import com.metamatrix.query.o.j.am;
import com.metamatrix.query.o.j.an;
import com.metamatrix.query.o.j.ao;
import com.metamatrix.query.o.j.ap;
import com.metamatrix.query.o.j.aq;
import com.metamatrix.query.o.j.ar;
import com.metamatrix.query.o.j.as;
import com.metamatrix.query.o.j.b;
import com.metamatrix.query.o.j.g;
import com.metamatrix.query.o.j.h;
import com.metamatrix.query.o.j.i;
import com.metamatrix.query.o.j.j;
import com.metamatrix.query.o.j.k;
import com.metamatrix.query.o.j.l;
import com.metamatrix.query.o.j.m;
import com.metamatrix.query.o.j.p;
import com.metamatrix.query.o.j.q;
import com.metamatrix.query.o.j.r;
import com.metamatrix.query.o.j.s;
import com.metamatrix.query.o.j.v;
import com.metamatrix.query.o.j.w;
import com.metamatrix.query.o.j.x;
import com.metamatrix.query.o.j.y;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LanguageBridgeFactory {
    private MetadataFactory metadataFactory = null;

    public LanguageBridgeFactory(com.metamatrix.query.m.e metadata) {
        if (metadata != null) {
            this.metadataFactory = new MetadataFactory(metadata);
        }
    }

    public ICommand translate(l command) throws MetaMatrixComponentException {
        if (command == null) {
            return null;
        }
        if (command instanceof ag) {
            return this.translate((ag)command);
        }
        if (command instanceof r) {
            return this.translate((r)command);
        }
        if (command instanceof af) {
            return this.translate((af)command);
        }
        if (command instanceof g) {
            return this.translate((g)command);
        }
        if (command instanceof i) {
            return this.translate((i)command);
        }
        if (command instanceof x) {
            return this.translate((x)command);
        }
        if (command instanceof v) {
            return this.translate((v)command);
        }
        return null;
    }

    IQuery translate(ar command) throws MetaMatrixComponentException {
        if (command instanceof ag) {
            return this.translate((ag)command);
        }
        if (command instanceof r) {
            return this.translate((r)command);
        }
        return null;
    }

    IUnion translate(r union) throws MetaMatrixComponentException {
        UnionImpl unionOut = null;
        Iterator queryIter = union.jk().iterator();
        Iterator allIter = union.ji().iterator();
        while (queryIter.hasNext()) {
            ar queryCommand = (ar)queryIter.next();
            boolean useAll = (Boolean)allIter.next();
            if (unionOut == null) {
                if (queryCommand instanceof r) {
                    throw new MetaMatrixComponentException(DQPPlugin.Util.getString("LanguageBridgeFactory.cant_translate_union"));
                }
                ag query = (ag)queryCommand;
                unionOut = new UnionImpl(this.translate(query.js()), this.translate(query.jy()), this.translate(query.jz()), this.translate(query.jp()), this.translate(query.jr()), this.translate(query.i8()));
                continue;
            }
            unionOut.addUnionQuery(this.translate(queryCommand), useAll);
        }
        if (union.i8() != null) {
            unionOut.setUnionOrderBy(this.translate(union.i8()));
        }
        return unionOut;
    }

    IQuery translate(ag query) throws MetaMatrixComponentException {
        QueryImpl q2 = new QueryImpl(this.translate(query.js()), this.translate(query.jy()), this.translate(query.jz()), this.translate(query.jp()), this.translate(query.jr()), this.translate(query.i8()));
        q2.setLimit(this.translate(query.ja()));
        return q2;
    }

    ISelect translate(s select) throws MetaMatrixComponentException {
        List symbols = select.ky();
        ArrayList<SelectSymbolImpl> translatedSymbols = new ArrayList<SelectSymbolImpl>(symbols.size());
        Iterator i2 = symbols.iterator();
        while (i2.hasNext()) {
            com.metamatrix.query.o.i.j symbol = (com.metamatrix.query.o.i.j)i2.next();
            boolean isAlias = false;
            String alias = symbol.ak();
            if (symbol instanceof d) {
                symbol = ((d)symbol).a4();
                isAlias = true;
            }
            IElement iExp = null;
            if (symbol instanceof a) {
                iExp = this.translate((a)symbol);
            } else if (symbol instanceof com.metamatrix.query.o.i.l) {
                iExp = this.translate((com.metamatrix.query.o.i.l)symbol);
            } else if (symbol instanceof n) {
                iExp = this.translate(((n)symbol).a6());
            }
            SelectSymbolImpl selectSymbol = new SelectSymbolImpl(symbol.ak(), (IExpression)iExp);
            if (isAlias) {
                selectSymbol.setOutputName(alias);
                selectSymbol.setAlias(true);
            }
            translatedSymbols.add(selectSymbol);
        }
        return new SelectImpl(translatedSymbols, select.ks());
    }

    IFrom translate(j from) throws MetaMatrixComponentException {
        List clauses = from.fy();
        ArrayList<IFromItem> items = new ArrayList<IFromItem>();
        Iterator i2 = clauses.iterator();
        while (i2.hasNext()) {
            items.add(this.translate((al)i2.next()));
        }
        return new FromImpl(items);
    }

    IFromItem translate(al clause) throws MetaMatrixComponentException {
        if (clause == null) {
            return null;
        }
        if (clause instanceof as) {
            return this.translate((as)clause);
        }
        if (clause instanceof b) {
            return this.translate((b)clause);
        }
        if (clause instanceof p) {
            return this.translate((p)clause);
        }
        return null;
    }

    IJoin translate(as join) throws MetaMatrixComponentException {
        List crits = join.c2();
        ArrayList<ICriteria> criteria = new ArrayList<ICriteria>();
        Iterator i2 = crits.iterator();
        while (i2.hasNext()) {
            criteria.add(this.translate((ap)i2.next()));
        }
        int joinType = 0;
        if (join.cy().equals(com.metamatrix.query.o.j.a.dl)) {
            joinType = 0;
        } else if (join.cy().equals(com.metamatrix.query.o.j.a.di)) {
            joinType = 2;
        } else if (join.cy().equals(com.metamatrix.query.o.j.a.dg)) {
            joinType = 3;
        } else if (join.cy().equals(com.metamatrix.query.o.j.a.dk)) {
            joinType = 4;
        } else if (join.cy().equals(com.metamatrix.query.o.j.a.dj)) {
            joinType = 1;
        }
        return new JoinImpl(this.translate(join.c0()), this.translate(join.c3()), joinType, criteria);
    }

    IFromItem translate(b clause) throws MetaMatrixComponentException {
        return new InlineViewImpl(this.translate((ar)clause.n()), clause.c6());
    }

    IGroup translate(p clause) throws MetaMatrixComponentException {
        return this.translate(clause.cu());
    }

    ICriteria translate(ap criteria) throws MetaMatrixComponentException {
        if (criteria == null) {
            return null;
        }
        if (criteria instanceof aj) {
            return this.translate((aj)criteria);
        }
        if (criteria instanceof ab) {
            return this.translate((ab)criteria);
        }
        if (criteria instanceof q) {
            return this.translate((q)criteria);
        }
        if (criteria instanceof w) {
            return this.translate((w)criteria);
        }
        if (criteria instanceof ai) {
            return this.translate((ai)criteria);
        }
        if (criteria instanceof y) {
            return this.translate((y)criteria);
        }
        if (criteria instanceof ac) {
            return this.translate((ac)criteria);
        }
        if (criteria instanceof k) {
            return this.translate((k)criteria);
        }
        if (criteria instanceof an) {
            return this.translate((an)criteria);
        }
        return null;
    }

    ICompareCriteria translate(aj criteria) throws MetaMatrixComponentException {
        int operator = 0;
        switch (criteria.eu()) {
            case 1: {
                operator = 0;
                break;
            }
            case 2: {
                operator = 1;
                break;
            }
            case 3: {
                operator = 2;
                break;
            }
            case 5: {
                operator = 3;
                break;
            }
            case 4: {
                operator = 4;
                break;
            }
            case 6: {
                operator = 5;
            }
        }
        return new CompareCriteriaImpl(this.translate(criteria.ew()), this.translate(criteria.e3()), operator);
    }

    ICompoundCriteria translate(ab criteria) throws MetaMatrixComponentException {
        List nestedCriteria = criteria.df();
        ArrayList<ICriteria> translatedCriteria = new ArrayList<ICriteria>();
        Iterator i2 = nestedCriteria.iterator();
        while (i2.hasNext()) {
            translatedCriteria.add(this.translate((ap)i2.next()));
        }
        int operator = 0;
        operator = criteria.di() == 0 ? 0 : 1;
        return new CompoundCriteriaImpl(translatedCriteria, operator);
    }

    IExistsCriteria translate(q criteria) throws MetaMatrixComponentException {
        return new ExistsCriteriaImpl(this.translate((ag)criteria.n()));
    }

    IIsNullCriteria translate(w criteria) throws MetaMatrixComponentException {
        return new IsNullCriteriaImpl(this.translate(criteria.d5()), criteria.d6());
    }

    ILikeCriteria translate(ai criteria) throws MetaMatrixComponentException {
        Character escapeChar = null;
        if (criteria.et() != '\u0000') {
            escapeChar = new Character(criteria.et());
        }
        return new LikeCriteriaImpl(this.translate(criteria.ep()), this.translate(criteria.eq()), escapeChar, criteria.el());
    }

    IInCriteria translate(ac criteria) throws MetaMatrixComponentException {
        List expressions = criteria.ej();
        ArrayList<IExpression> translatedExpressions = new ArrayList<IExpression>();
        Iterator i2 = expressions.iterator();
        while (i2.hasNext()) {
            translatedExpressions.add(this.translate((com.metamatrix.query.o.i.s)i2.next()));
        }
        return new InCriteriaImpl(this.translate(criteria.d9()), translatedExpressions, criteria.ea());
    }

    ISubqueryCompareCriteria translate(k criteria) throws MetaMatrixComponentException {
        int quantifier = 0;
        switch (criteria.e6()) {
            case 4: {
                quantifier = 1;
                break;
            }
            case 3: {
                quantifier = 0;
                break;
            }
            case 2: {
                quantifier = 0;
            }
        }
        int operator = 0;
        switch (criteria.eu()) {
            case 1: {
                operator = 1;
                break;
            }
            case 2: {
                operator = 2;
                break;
            }
            case 3: {
                operator = 3;
                break;
            }
            case 5: {
                operator = 4;
                break;
            }
            case 4: {
                operator = 5;
                break;
            }
            case 6: {
                operator = 6;
            }
        }
        return new SubqueryCompareCriteriaImpl(this.translate(criteria.ew()), operator, quantifier, this.translate((ag)criteria.n()));
    }

    ISubqueryInCriteria translate(an criteria) throws MetaMatrixComponentException {
        return new SubqueryInCriteriaImpl(this.translate(criteria.d9()), criteria.ea(), this.translate((ag)criteria.n()));
    }

    INotCriteria translate(y criteria) throws MetaMatrixComponentException {
        return new NotCriteriaImpl(this.translate(criteria.db()));
    }

    IGroupBy translate(am groupBy) throws MetaMatrixComponentException {
        if (groupBy == null) {
            return null;
        }
        List items = groupBy.k1();
        ArrayList<IExpression> translatedItems = new ArrayList<IExpression>();
        Iterator i2 = items.iterator();
        while (i2.hasNext()) {
            translatedItems.add(this.translate((com.metamatrix.query.o.i.s)i2.next()));
        }
        return new GroupByImpl(translatedItems);
    }

    IOrderBy translate(h orderBy) throws MetaMatrixComponentException {
        if (orderBy == null) {
            return null;
        }
        List items = orderBy.fn();
        List types = orderBy.fu();
        ArrayList<OrderByItemImpl> translatedItems = new ArrayList<OrderByItemImpl>();
        for (int i2 = 0; i2 < items.size(); ++i2) {
            com.metamatrix.query.o.i.j symbol = (com.metamatrix.query.o.i.j)items.get(i2);
            boolean direction = (Boolean)types.get(i2) != h.dm;
            OrderByItemImpl orderByItem = null;
            if (symbol instanceof a) {
                IElement innerElement = this.translate((a)symbol);
                orderByItem = new OrderByItemImpl(symbol.ak(), direction, innerElement);
            } else {
                orderByItem = new OrderByItemImpl(symbol.ak(), direction, null);
            }
            translatedItems.add(orderByItem);
        }
        return new OrderByImpl(translatedItems);
    }

    IExpression translate(com.metamatrix.query.o.i.s expr) throws MetaMatrixComponentException {
        if (expr == null) {
            return null;
        }
        if (expr instanceof com.metamatrix.query.o.i.h) {
            return this.translate((com.metamatrix.query.o.i.h)expr);
        }
        if (expr instanceof c) {
            return this.translate((c)expr);
        }
        if (expr instanceof e) {
            return this.translate((e)expr);
        }
        if (expr instanceof com.metamatrix.query.o.i.g) {
            return this.translate((com.metamatrix.query.o.i.g)expr);
        }
        if (expr instanceof o) {
            return this.translate((o)expr);
        }
        if (expr instanceof com.metamatrix.query.o.i.p) {
            return this.translate((com.metamatrix.query.o.i.p)expr);
        }
        if (expr instanceof com.metamatrix.query.o.i.j) {
            return this.translate((com.metamatrix.query.o.i.j)expr);
        }
        return null;
    }

    ICaseExpression translate(com.metamatrix.query.o.i.h expr) throws MetaMatrixComponentException {
        ArrayList<IExpression> whens = new ArrayList<IExpression>();
        ArrayList<IExpression> thens = new ArrayList<IExpression>();
        for (int i2 = 0; i2 < expr.cd(); ++i2) {
            whens.add(this.translate(expr.cl(i2)));
            thens.add(this.translate(expr.cc(i2)));
        }
        return new CaseExpressionImpl(this.translate(expr.cn()), whens, thens, this.translate(expr.cj()), expr.ag());
    }

    ILiteral translate(c constant) {
        return new LiteralImpl(constant.bp(), constant.ag());
    }

    IFunction translate(e function) throws MetaMatrixComponentException {
        com.metamatrix.query.o.i.s[] args = function.bz();
        IExpression[] params = null;
        if (args != null) {
            params = new IExpression[args.length];
            for (int i2 = 0; i2 < args.length; ++i2) {
                params[i2] = this.translate(args[i2]);
            }
        }
        return new FunctionImpl(function.bx(), params, function.ag());
    }

    IExpression translate(com.metamatrix.query.o.i.g ref) throws MetaMatrixComponentException {
        return this.translate(ref.b9());
    }

    ISearchedCaseExpression translate(com.metamatrix.query.o.i.p expr) throws MetaMatrixComponentException {
        ArrayList<ICriteria> whens = new ArrayList<ICriteria>();
        ArrayList<IExpression> thens = new ArrayList<IExpression>();
        for (int i2 = 0; i2 < expr.cd(); ++i2) {
            whens.add(this.translate(expr.co(i2)));
            thens.add(this.translate(expr.cc(i2)));
        }
        return new SearchedCaseExpressionImpl(whens, thens, this.translate(expr.cj()), expr.ag());
    }

    IExpression translate(o ss) throws MetaMatrixComponentException {
        return new ScalarSubqueryImpl(this.translate((ag)ss.n()));
    }

    IExpression translate(com.metamatrix.query.o.i.j symbol) throws MetaMatrixComponentException {
        if (symbol == null) {
            return null;
        }
        if (symbol instanceof d) {
            return this.translate((d)symbol);
        }
        if (symbol instanceof a) {
            return this.translate((a)symbol);
        }
        if (symbol instanceof com.metamatrix.query.o.i.l) {
            return this.translate((com.metamatrix.query.o.i.l)symbol);
        }
        if (symbol instanceof n) {
            return this.translate((n)symbol);
        }
        return null;
    }

    IExpression translate(d symbol) throws MetaMatrixComponentException {
        return this.translate(symbol.a4());
    }

    IElement translate(a symbol) throws MetaMatrixComponentException {
        ElementImpl element = null;
        element = new ElementImpl(this.translate(symbol.bc()), symbol.ak(), null, symbol.ag());
        if (element.getGroup().getMetadataID() == null) {
            return element;
        }
        Object mid = symbol.bf();
        if (!(mid instanceof com.metamatrix.query.m.d)) {
            try {
                element.setMetadataID(this.metadataFactory.createMetadataID(mid, 0));
            }
            catch (QueryMetadataException e2) {
                LogManager.logWarning("CONNECTOR", (Throwable)e2, DQPPlugin.Util.getString("LanguageBridgeFactory.Unable_to_set_the_metadata_ID_for_element_{0}._10", (Object)symbol.ak()));
                throw new MetaMatrixComponentException((Throwable)e2);
            }
        }
        return element;
    }

    IAggregate translate(com.metamatrix.query.o.i.l symbol) throws MetaMatrixComponentException {
        return new AggregateImpl(symbol.a8(), symbol.a9(), this.translate(symbol.a6()), symbol.ag());
    }

    IExpression translate(n symbol) throws MetaMatrixComponentException {
        return this.translate(symbol.a6());
    }

    IInsert translate(af insert) throws MetaMatrixComponentException {
        List elements = insert.iz();
        ArrayList<IElement> translatedElements = new ArrayList<IElement>();
        Iterator i2 = elements.iterator();
        while (i2.hasNext()) {
            translatedElements.add(this.translate((a)i2.next()));
        }
        if (insert instanceof aq) {
            aq bulkInsert = (aq)insert;
            BulkInsertImpl translatedBulkInsert = new BulkInsertImpl(this.translate(insert.ix()), translatedElements);
            List rows = bulkInsert.i7();
            translatedBulkInsert.setRows(rows);
            return translatedBulkInsert;
        }
        List values = insert.iy();
        ArrayList<IExpression> translatedValues = new ArrayList<IExpression>();
        Iterator i3 = values.iterator();
        while (i3.hasNext()) {
            translatedValues.add(this.translate((com.metamatrix.query.o.i.s)i3.next()));
        }
        return new InsertImpl(this.translate(insert.ix()), translatedElements, translatedValues);
    }

    IUpdate translate(g update) throws MetaMatrixComponentException {
        List changes = update.hd();
        ArrayList<ICompareCriteria> translatedChanges = new ArrayList<ICompareCriteria>();
        Iterator i2 = changes.iterator();
        while (i2.hasNext()) {
            translatedChanges.add(this.translate((aj)i2.next()));
        }
        return new UpdateImpl(this.translate(update.he()), translatedChanges, this.translate(update.hi()));
    }

    IDelete translate(i delete) throws MetaMatrixComponentException {
        return new DeleteImpl(this.translate(delete.hk()), this.translate(delete.hn()));
    }

    IProcedure translate(x sp) throws MetaMatrixComponentException {
        ProcedureIDImpl metadataID = null;
        if (sp.iq() != null) {
            try {
                metadataID = (ProcedureIDImpl)this.metadataFactory.createProcedureID(sp.iq());
            }
            catch (Exception e2) {
                LogManager.logWarning("CONNECTOR", (Throwable)e2, DQPPlugin.Util.getString("LanguageBridgeFactory.Unable_to_set_the_metadata_ID_for_element_{0}._10", (Object)sp.h7()));
                throw new MetaMatrixComponentException((Throwable)e2);
            }
        }
        List parameters = sp.in();
        ArrayList<IParameter> translatedParameters = new ArrayList<IParameter>();
        Iterator i2 = parameters.iterator();
        while (i2.hasNext()) {
            translatedParameters.add(this.translate((ao)i2.next(), metadataID));
        }
        return new ProcedureImpl(sp.h7(), translatedParameters, (MetadataID)metadataID);
    }

    IParameter translate(ao param, ProcedureIDImpl procID) throws MetaMatrixComponentException {
        int direction = 0;
        switch (param.u()) {
            case 1: {
                direction = 0;
                break;
            }
            case 3: {
                direction = 2;
                break;
            }
            case 2: {
                direction = 1;
                break;
            }
            case 5: {
                direction = 4;
                break;
            }
            case 4: {
                direction = 3;
            }
        }
        try {
            MetadataID metadataID = null;
            if (direction == 4) {
                metadataID = this.metadataFactory.createResultSetID(procID, param.j(), param.e());
                return new ParameterImpl(param.h(), direction, param.f(), param.d(), metadataID);
            }
            metadataID = this.metadataFactory.createParameterID(procID, param.j());
            return new ParameterImpl(param.h(), direction, param.f(), param.d(), metadataID);
        }
        catch (QueryMetadataException e2) {
            throw new MetaMatrixComponentException((Throwable)e2);
        }
    }

    IGroup translate(f symbol) throws MetaMatrixComponentException {
        GroupImpl group = new GroupImpl(symbol.ak(), symbol.ar(), null);
        if (symbol.aq() instanceof com.metamatrix.query.m.d) {
            return group;
        }
        try {
            group.setMetadataID(this.metadataFactory.createMetadataID(symbol.aq(), 1));
        }
        catch (Exception e2) {
            LogManager.logWarning("CONNECTOR", (Throwable)e2, DQPPlugin.Util.getString("LanguageBridgeFactory.Unable_to_set_the_metadata_ID_for_group_{0}._11", (Object)symbol.ak()));
            throw new MetaMatrixComponentException((Throwable)e2);
        }
        return group;
    }

    IBatchedUpdates translate(v command) throws MetaMatrixComponentException {
        List updates = command.h2();
        ArrayList<ICommand> translatedUpdates = new ArrayList<ICommand>(updates.size());
        Iterator i2 = updates.iterator();
        while (i2.hasNext()) {
            translatedUpdates.add(this.translate((l)i2.next()));
        }
        return new BatchedUpdatesImpl(translatedUpdates);
    }

    ILimit translate(m limit) throws MetaMatrixComponentException {
        if (limit == null) {
            return null;
        }
        int rowOffset = 0;
        if (limit.j0() != null) {
            ILiteral c1 = (ILiteral)this.translate(limit.j0());
            rowOffset = (Integer)c1.getValue();
        }
        ILiteral c2 = (ILiteral)this.translate(limit.j1());
        int rowLimit = (Integer)c2.getValue();
        return new LimitImpl(rowOffset, rowLimit);
    }
}

