/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.dqp.ui.actions;

import com.metamatrix.admin.api.embedded.EmbeddedAdmin;
import com.metamatrix.admin.api.embedded.EmbeddedLogger;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.core.log.FileLogWriter;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.jdbc.api.Connection;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.modeler.dqp.DqpPlugin;
import com.metamatrix.modeler.dqp.execution.VdbExecutionFileManager;
import com.metamatrix.modeler.dqp.execution.VdbExecutionValidator;
import com.metamatrix.modeler.dqp.internal.config.VdbDefnHelper;
import com.metamatrix.modeler.dqp.internal.execution.VdbExecutionFileManagerImpl;
import com.metamatrix.modeler.dqp.ui.DqpUiConstants;
import com.metamatrix.modeler.ui.UiPlugin;
import com.metamatrix.vdb.edit.VdbContextEditor;
import com.metamatrix.vdb.edit.VdbEditingContext;
import com.metamatrix.vdb.internal.edit.InternalVdbEditingContext;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import net.sourceforge.sqlexplorer.AliasModel;
import net.sourceforge.sqlexplorer.DriverModel;
import net.sourceforge.sqlexplorer.IdentifierFactory;
import net.sourceforge.sqlexplorer.LoggingProgress;
import net.sourceforge.sqlexplorer.RetrievingTableDataProgress;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.views.DBView;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class VdbExecutor
implements DqpUiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$internal$dqp$ui$actions$VdbExecutor == null ? (class$com$metamatrix$modeler$internal$dqp$ui$actions$VdbExecutor = VdbExecutor.class$("com.metamatrix.modeler.internal.dqp.ui.actions.VdbExecutor")) : class$com$metamatrix$modeler$internal$dqp$ui$actions$VdbExecutor));
    private static final String URL1 = "jdbc:metamatrix:";
    private static final String URL2 = ";version=";
    private static final String URL3 = ";XMLFormat=Tree";
    private static final String URL_QUERY_PLAN = ";sqlOptions=SHOWPLAN";
    private static final String URL4 = ";EmbeddedContext=Designer";
    private static final String URL5 = ";txnAutoWrap=OFF";
    private static final String DQP_DRIVER_CLASS = "com.metamatrix.jdbc.EmbeddedDriver";
    private static final String DQP_DRIVER_NAME = "MetaBase Modeler DQP Driver";
    private static final String DQP_SAMPLE_URL = "jdbc:metamatrix:<vdbName>@<propertiesFile>;version=<vdbVersion>";
    public static final int LICENSE_PROBLEM_CODE = 30160037;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("-HH.mm.ss MMM dd");
    private static final IStatus SUCCESS = new Status(0, DqpUiConstants.PLUGIN_ID, 0, VdbExecutor.getString("executionSuccess"), null);
    private File vdbFile;
    private InternalVdbEditingContext context;
    private VdbContextEditor contextEditor;
    private VdbExecutionFileManager manager;
    private File vdbExecutionDirectory;
    private VdbExecutionValidator validator;
    private SQLConnection sqlConnection;
    private long timestamp;
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$dqp$ui$actions$VdbExecutor;

    private static String getString(String theId) {
        return DqpUiConstants.UTIL.getStringOrKey(I18N_PREFIX + theId);
    }

    public VdbExecutor(VdbEditingContext context, VdbExecutionValidator validator) {
        ArgCheck.isNotNull((Object)context);
        Assertion.assertTrue((boolean)(context instanceof InternalVdbEditingContext));
        ArgCheck.isNotNull((Object)validator);
        this.context = (InternalVdbEditingContext)context;
        this.contextEditor = null;
        this.vdbFile = this.context.getPathToVdb().toFile();
        this.validator = validator;
        this.init();
    }

    public VdbExecutor(VdbContextEditor context, VdbExecutionValidator validator) {
        ArgCheck.isNotNull((Object)context);
        ArgCheck.isNotNull((Object)validator);
        this.context = null;
        this.contextEditor = context;
        this.vdbFile = this.contextEditor.getVdbFile();
        this.validator = validator;
        this.init();
    }

    private void init() {
        try {
            if (this.context != null && !this.context.isOpen()) {
                this.context.setLoadModelsOnOpen(false);
                this.context.open();
            }
            if (this.contextEditor != null && !this.contextEditor.isOpen()) {
                this.contextEditor.open((IProgressMonitor)new NullProgressMonitor());
            }
            this.timestamp = this.getVdbTimestamp();
        }
        catch (Exception e) {
            DqpUiConstants.UTIL.log(4, (Throwable)e, DqpUiConstants.UTIL.getString(I18N_PREFIX + "error_vdb_context_loading", (Object)this.vdbFile));
        }
    }

    public IStatus canExecute() {
        IStatus status = null;
        if (this.context != null) {
            status = this.validator.validateVdb((VdbEditingContext)this.context);
        } else if (this.contextEditor != null) {
            status = this.validator.validateVdb(this.contextEditor);
        }
        return status;
    }

    public IStatus checkVdbModelState(VDBDefn defn) {
        IStatus status = null;
        if (this.context != null) {
            status = this.validator.validateVdbModels(this.context.getVirtualDatabase(), defn);
        } else if (this.contextEditor != null) {
            status = this.validator.validateVdbModels(this.contextEditor.getVirtualDatabase(), defn);
        }
        return status;
    }

    public VdbExecutionFileManager getExecutionFileManager() {
        if (this.manager == null) {
            if (this.context != null) {
                this.manager = new VdbExecutionFileManagerImpl((VdbEditingContext)this.context);
            } else if (this.contextEditor != null) {
                this.manager = new VdbExecutionFileManagerImpl(this.contextEditor);
            }
        }
        return this.manager;
    }

    private void setUpVdbForExecution(String logFileName) {
        VdbExecutionFileManager manager = this.getExecutionFileManager();
        this.vdbExecutionDirectory = manager.getUpdatedVdbExecutionFolder(logFileName);
    }

    private ISQLAlias getSqlAlias(String theName) {
        SQLExplorerPlugin sqlPlugin = SQLExplorerPlugin.getDefault();
        AliasModel aliasModel = sqlPlugin.getAliasModel();
        Object[] aliasArray = aliasModel.getElements();
        for (int i = 0; i < aliasArray.length; ++i) {
            ISQLAlias aliasElement = (ISQLAlias)aliasArray[i];
            if (!theName.equals(aliasElement.getName())) continue;
            return aliasElement;
        }
        return null;
    }

    String getDqpDriverUrl(String theVdbName, String theVersion, String thePath, Properties executionProps) {
        String txnAutoWrap = executionProps.getProperty("txnAutoWrap");
        boolean txnAutoWrapOFF = txnAutoWrap == null ? false : txnAutoWrap.equalsIgnoreCase("OFF");
        String path = thePath.replace('\\', '/');
        StringBuffer sb = new StringBuffer().append(URL1).append(theVdbName).append('@').append(path).append(URL2).append(theVersion).append(URL3);
        if (SQLExplorerPlugin.getDefault() != null && SQLExplorerPlugin.getDefault().shouldShowQueryPlan()) {
            sb.append(URL_QUERY_PLAN);
        }
        sb.append(URL4);
        if (txnAutoWrapOFF) {
            sb.append(URL5);
        }
        return sb.toString();
    }

    public IStatus execute(IProgressMonitor theMonitor) {
        return this.execute(theMonitor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus execute(IProgressMonitor theMonitor, boolean initConnOnly) {
        IStatus result = SUCCESS;
        SQLExplorerPlugin sqlPlugin = SQLExplorerPlugin.getDefault();
        VdbDefnHelper helper = null;
        if (this.context != null) {
            helper = DqpPlugin.getInstance().getVdbDefnHelper(this.context);
        } else if (this.contextEditor != null) {
            helper = DqpPlugin.getInstance().getVdbDefnHelper(this.contextEditor);
        }
        VDBDefn defn = helper.getVdbDefn();
        if (!LicenseChecker.hasValidProductLicense((String)"Sources", (String)"5.0", (int)defn.getConnectorBindings().size())) {
            return new Status(4, DqpUiConstants.PLUGIN_ID, 30160037, VdbExecutor.getString("sourceLimitExceeded"), null);
        }
        String vdbName = defn.getName();
        String vdbVersion = defn.getVersion();
        if (StringUtil.isEmpty((String)vdbVersion)) {
            vdbVersion = "1";
        }
        String timestamp = dateFormat.format(new Date());
        String logFileName = vdbName + ".vdb" + timestamp + ".log";
        String logFileName1 = vdbName + ".vdb" + timestamp + "_1.log";
        this.setUpVdbForExecution(logFileName);
        Properties executionProps = null;
        if (this.context != null) {
            executionProps = this.context.getExecutionProperties();
        } else if (this.contextEditor != null) {
            executionProps = this.contextEditor.getExecutionProperties();
        }
        File propertiesFile = this.getExecutionFileManager().getExecutionPropertiesFile(logFileName);
        String path = propertiesFile.getAbsoluteFile().toString();
        String url = this.getDqpDriverUrl(vdbName, vdbVersion, path, executionProps);
        ISQLDriver driver = null;
        try {
            driver = this.getDqpDriver();
        }
        catch (Exception e) {
            DqpUiConstants.UTIL.log((Throwable)e);
            e.printStackTrace();
            return new Status(4, DqpUiConstants.PLUGIN_ID, 0, VdbExecutor.getString("dqpDriverError"), (Throwable)e);
        }
        String aliasName = null;
        if (this.context != null) {
            aliasName = this.context.getPathToVdb().toOSString();
        } else if (this.contextEditor != null) {
            aliasName = this.contextEditor.getVdbFile().getAbsolutePath();
        }
        Assertion.isNotNull((Object)aliasName);
        ISQLAlias alias = this.getSqlAlias(aliasName);
        boolean closePrevious = false;
        if (alias == null) {
            IdentifierFactory factory = IdentifierFactory.getInstance();
            AliasModel aliasModel = sqlPlugin.getAliasModel();
            alias = aliasModel.createAlias(factory.createIdentifier());
            try {
                alias.setName(aliasName);
                alias.setDriverIdentifier(driver.getIdentifier());
                alias.setUrl(url);
                alias.setUserName("username");
                alias.setConnectAtStartup(false);
                alias.setAutoLogon(false);
                alias.setPassword("password");
                aliasModel.addAlias(alias);
            }
            catch (ValidationException excp) {
                result = new Status(4, DqpUiConstants.PLUGIN_ID, 0, VdbExecutor.getString("sqlAliasValidationError"), (Throwable)excp);
                DqpUiConstants.UTIL.log(result);
                return result;
            }
            catch (DuplicateObjectException excp) {
                result = new Status(4, DqpUiConstants.PLUGIN_ID, 0, VdbExecutor.getString("sqlAliasDuplicateError"), (Throwable)excp);
                excp.printStackTrace();
                DqpUiConstants.UTIL.log(result);
                return result;
            }
        }
        if (!url.equals(alias.getUrl())) {
            closePrevious = true;
            try {
                alias.setUrl(url);
            }
            catch (ValidationException excp) {
                DqpUiConstants.UTIL.log((IStatus)new Status(4, DqpUiConstants.PLUGIN_ID, 0, DqpUiConstants.UTIL.getString(I18N_PREFIX + "sqlAliasUrlError", (Object)url), (Throwable)excp));
            }
        }
        if (!initConnOnly) {
            IWorkbenchPage page = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage();
            if (page == null) {
                result = new Status(4, DqpUiConstants.PLUGIN_ID, 0, VdbExecutor.getString("nullWorkbenchPageMsg"), null);
                DqpUiConstants.UTIL.log(result);
                return result;
            }
            try {
                IWorkbenchPage jdbcPage = PlatformUI.getWorkbench().showPerspective("com.metamatrix.modeler.internal.dqp.ui.jdbc.JdbcClientPluginPerspective", page.getWorkbenchWindow());
                jdbcPage.showView("net.sourceforge.sqlexplorer.plugin.views.ConnectionsView");
            }
            catch (Throwable e) {
                result = new Status(4, DqpUiConstants.PLUGIN_ID, 0, VdbExecutor.getString("perspectiveErrorMsg"), e);
                DqpUiConstants.UTIL.log(result);
                return result;
            }
        }
        DriverModel driverModel = sqlPlugin.getDriverModel();
        SQLDriverManager driverMgr = sqlPlugin.getSQLDriverManager();
        ISQLDriver dv = driverModel.getDriver(alias.getDriverIdentifier());
        this.sqlConnection = null;
        try {
            block34: {
                DBView dbView;
                SessionTreeNode sessionNode;
                block32: {
                    block35: {
                        LoggingProgress lp;
                        block33: {
                            sessionNode = this.findOpenSession(alias);
                            if (sessionNode != null) {
                                if (this.timestamp == this.getVdbTimestamp() && !closePrevious) {
                                    this.sqlConnection = sessionNode.getConnection();
                                } else {
                                    this.timestamp = this.getVdbTimestamp();
                                    sessionNode.close();
                                    sessionNode = null;
                                }
                            }
                            if (this.sqlConnection != null) break block32;
                            this.getExecutionFileManager().resetExecutionPropertiesFile(logFileName);
                            lp = new LoggingProgress(driverMgr, dv, alias, alias.getUserName(), alias.getPassword());
                            ProgressMonitorDialog pg = new ProgressMonitorDialog(null);
                            pg.run(true, true, (IRunnableWithProgress)lp);
                            if (!lp.isOk()) break block33;
                            this.sqlConnection = lp.getConn();
                            this.sqlConnection.setAutoCommit(true);
                            if (initConnOnly) break block34;
                            break block35;
                        }
                        Throwable e = lp.getException();
                        String param = lp.getError() == null ? e.getClass().getName() : lp.getError();
                        String message = DqpUiConstants.UTIL.getString(I18N_PREFIX + "connectionErrorMsg", (Object)param);
                        e.printStackTrace();
                        DqpUiConstants.UTIL.log(result);
                        return new Status(4, DqpUiConstants.PLUGIN_ID, 0, message, null);
                    }
                    RetrievingTableDataProgress rtdp = new RetrievingTableDataProgress(this.sqlConnection, alias, sqlPlugin.stm, alias.getPassword());
                    ProgressMonitorDialog pg2 = new ProgressMonitorDialog(null);
                    pg2.run(true, true, (IRunnableWithProgress)rtdp);
                    break block34;
                }
                if (!initConnOnly && (dbView = (DBView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("net.sourceforge.sqlexplorer.plugin.views.DBView")) != null) {
                    dbView.setInput(sessionNode);
                }
            }
            Connection dqpConnection = (Connection)this.sqlConnection.getConnection();
            EmbeddedAdmin adminApi = (EmbeddedAdmin)dqpConnection.getAdminAPI();
            adminApi.setLogListener((EmbeddedLogger)new VdbExecutionLogger(logFileName1));
            return result;
        }
        catch (Exception e) {
            result = new Status(4, DqpUiConstants.PLUGIN_ID, 0, VdbExecutor.getString("connectionErrorMsg"), (Throwable)e);
            e.printStackTrace();
            DqpUiConstants.UTIL.log(result);
            return result;
        }
    }

    public void closeAllConnections() {
        SQLExplorerPlugin.getDefault().closeAllConnections();
    }

    private SessionTreeNode findOpenSession(ISQLAlias theAlias) {
        return SQLExplorerPlugin.getDefault().stm.findOpenSessionTreeNode(theAlias);
    }

    private ISQLDriver getDqpDriver() throws Exception {
        DriverModel driverModel = SQLExplorerPlugin.getDefault().getDriverModel();
        Object[] drivers = driverModel.getElements();
        for (int i = 0; i < drivers.length; ++i) {
            ISQLDriver driver = (ISQLDriver)drivers[i];
            if (!driver.getDriverClassName().equals(DQP_DRIVER_CLASS)) continue;
            return driver;
        }
        ISQLDriver driver = driverModel.createDriver(IdentifierFactory.getInstance().createIdentifier());
        driver.setDriverClassName(DQP_DRIVER_CLASS);
        driver.setName(DQP_DRIVER_NAME);
        driver.setUrl(DQP_SAMPLE_URL);
        driverModel.addDriver(driver);
        return driver;
    }

    File getvdbExecutionDirectory() {
        return this.vdbExecutionDirectory;
    }

    private long getVdbTimestamp() {
        return this.vdbFile.lastModified();
    }

    public SQLConnection getSqlConnection() {
        return this.sqlConnection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class VdbExecutionLogger
    implements EmbeddedLogger {
        IPath logPath;
        FileLogWriter logWriter;

        VdbExecutionLogger(String logFileName) {
            IPath configPath = DqpPlugin.getInstance().getDqpPluginHelper().getDqpConfigurationPath();
            this.logPath = configPath.append(logFileName);
            this.logWriter = new FileLogWriter(this.logPath.toFile());
        }

        public void log(int logLevel, long timestamp, String componentName, String threadName, String message, Throwable throwable) {
            switch (logLevel) {
                case 1: 
                case 2: {
                    if (throwable == null) {
                        DqpUiConstants.UTIL.log(4, message);
                    } else {
                        DqpUiConstants.UTIL.log(4, throwable, message);
                    }
                    Status status1 = new Status(4, "com.metamatrix.modeler.dqp", 0, message, throwable);
                    this.logWriter.logMessage((IStatus)status1, timestamp, message, threadName);
                    break;
                }
                case 3: {
                    if (throwable == null) {
                        DqpUiConstants.UTIL.log(2, message);
                    } else {
                        DqpUiConstants.UTIL.log(2, throwable, message);
                    }
                    Status status2 = new Status(2, "com.metamatrix.modeler.dqp", 0, message, throwable);
                    this.logWriter.logMessage((IStatus)status2, timestamp, message, threadName);
                    break;
                }
                default: {
                    DqpUiConstants.UTIL.log(1, message);
                    Status status3 = new Status(1, "com.metamatrix.modeler.dqp", 0, message, throwable);
                    this.logWriter.logMessage((IStatus)status3, timestamp, message, threadName);
                }
            }
        }
    }
}

