/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.ui.viewsupport;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.metamodels.core.AnnotationContainer;
import com.metamatrix.metamodels.core.CoreFactory;
import com.metamatrix.metamodels.relational.BaseTable;
import com.metamatrix.metamodels.relational.Catalog;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.RelationalFactory;
import com.metamatrix.metamodels.relational.Schema;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.relational.View;
import com.metamatrix.metamodels.relational.util.RelationalTypeMapping;
import com.metamatrix.metamodels.relational.util.RelationalTypeMappingImpl;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.jdbc.relational.impl.RelationalModelProcessorImpl;
import com.metamatrix.modeler.ui.UiConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class RelationalObjectBuilder
implements UiConstants {
    private static final String SLASH = "/";
    public static final String RELATIONAL_PACKAGE_URI = "http://www.metamatrix.com/metamodels/Relational";
    public static final RelationalFactory factory = RelationalFactory.eINSTANCE;
    public static final String BASE_TABLE_STRING = "TABLE";
    public static final String VIEW_STRING = "VIEW";
    public static final String INDEX_STRING = "INDEX";
    public static final String COLUMN_STRING = "COLUMN";
    public static final String UNIQUE_KEY_STRING = "UNIQUEKEY";
    public static final String PRIMARY_KEY_STRING = "PRIMARYKEY";
    public static final String SCHEMA_STRING = "SCHEMA";
    public static final String CATALOG_STRING = "CATALOG";
    private final Resource resource;
    private final MyRelationalModelProcessor processor;
    public static boolean HEADLESS = false;
    private Object[] datatypesArray = null;

    public RelationalObjectBuilder(Resource resource) {
        ArgCheck.isNotNull((Object)resource);
        this.resource = resource;
        this.processor = !HEADLESS ? new MyRelationalModelProcessor(RelationalFactory.eINSTANCE, RelationalTypeMappingImpl.getInstance()) : null;
    }

    public String getRelationalPackageURI() {
        return RELATIONAL_PACKAGE_URI;
    }

    public EObject createColumn(String name, Object location, String description, XSDSimpleTypeDefinition builtInType, XSDSimpleTypeDefinition actualType) {
        Assertion.isNotNull((Object)name);
        Assertion.isNotNull((Object)location);
        Column col = factory.createColumn();
        col.setName(name);
        int actualLength = 255;
        if (builtInType != null && actualType != null) {
            EList validFacets = actualType.getValidFacets();
            boolean lengthDone = false;
            if (validFacets.contains((Object)"length") && actualType.getLengthFacet() != null) {
                actualLength = actualType.getLengthFacet().getValue();
                lengthDone = true;
            }
            if (!lengthDone && validFacets.contains((Object)"maxLength") && actualType.getMaxLengthFacet() != null) {
                actualLength = actualType.getMaxLengthFacet().getValue();
            }
            if (validFacets.contains((Object)"fractionDigits") && actualType.getFractionDigitsFacet() != null) {
                col.setPrecision(actualType.getFractionDigitsFacet().getValue());
            }
            col.setType((EObject)builtInType);
            col.setLength(actualLength);
        }
        this.createAnnotation((EObject)col, description);
        return col;
    }

    public void createTransformation(EObject baseTable, String selectSql) {
        if (HEADLESS) {
            return;
        }
        TransformationHelper.createTransformation((EObject)baseTable, (String)selectSql);
    }

    public String getTypeName(EObject column) {
        EObject type;
        if (column instanceof Column && (type = ((Column)column).getType()) instanceof XSDSimpleTypeDefinition) {
            return ((XSDSimpleTypeDefinition)type).getName();
        }
        return new String();
    }

    public EObject createBaseTable(String name, Object location, boolean supportsUpdate, String description) {
        Assertion.isNotNull((Object)name);
        Assertion.isNotNull((Object)location);
        BaseTable bt = factory.createBaseTable();
        bt.setName(name);
        bt.setSupportsUpdate(supportsUpdate);
        if (location instanceof Resource) {
            ((Resource)location).getContents().add((Object)bt);
        } else if (location instanceof Schema) {
            ((Schema)location).getTables().add((Object)bt);
        } else if (location instanceof Catalog) {
            ((Catalog)location).getTables().add((Object)bt);
        }
        this.createAnnotation((EObject)bt, description);
        return bt;
    }

    public void addColumns(Object table, Collection columns) {
        if (table instanceof Table) {
            ((Table)table).getColumns().addAll(columns);
        }
    }

    public void createXPathNIS(EObject table, XSDConcreteComponent xsdComp) {
        ArgCheck.isNotNull((Object)xsdComp);
        ArgCheck.isNotNull((Object)table);
        if (!(table instanceof BaseTable)) {
            return;
        }
        XSDElementDeclaration element = null;
        XSDConcreteComponent owner = xsdComp;
        boolean done = false;
        while (!done && owner != null) {
            if (owner instanceof XSDElementDeclaration) {
                element = (XSDElementDeclaration)xsdComp;
                done = true;
                continue;
            }
            owner = owner.eContainer();
        }
        if (element == null) {
            return;
        }
        Stack<XSDConcreteComponent> elements = new Stack<XSDConcreteComponent>();
        for (owner = element; owner != null; owner = owner.eContainer()) {
            if (!(owner instanceof XSDElementDeclaration)) continue;
            elements.push(owner);
        }
        StringBuffer xpath = new StringBuffer();
        while (!elements.isEmpty()) {
            xpath.append(SLASH);
            XSDElementDeclaration next = (XSDElementDeclaration)elements.pop();
            xpath.append(next.getName());
        }
        ((BaseTable)table).setNameInSource(xpath.toString());
    }

    public void createColXPathNIS(EObject col, Stack elementStack) {
        ArgCheck.isNotNull((Object)col);
        ArgCheck.isNotNull((Object)elementStack);
        if (!(col instanceof Column)) {
            return;
        }
        Stack copy = (Stack)elementStack.clone();
        Stack topDownStack = new Stack();
        while (!copy.isEmpty()) {
            topDownStack.push(copy.pop());
        }
        StringBuffer nis = new StringBuffer();
        while (!topDownStack.isEmpty()) {
            nis.append(SLASH);
            XSDElementDeclaration next = (XSDElementDeclaration)topDownStack.pop();
            nis.append(next.getName());
        }
        ((Column)col).setNameInSource(nis.toString());
    }

    public EObject createView(String name, Object location, boolean supportsUpdate, String description) {
        Assertion.isNotNull((Object)name);
        Assertion.isNotNull((Object)location);
        View view = factory.createView();
        view.setName(name);
        view.setSupportsUpdate(supportsUpdate);
        if (location instanceof Resource) {
            ((Resource)location).getContents().add((Object)view);
        } else if (location instanceof Schema) {
            ((Schema)location).getTables().add((Object)view);
        } else if (location instanceof Catalog) {
            ((Catalog)location).getTables().add((Object)view);
        }
        this.createAnnotation((EObject)view, description);
        return view;
    }

    private void createAnnotation(EObject eObject, String description) {
        if (description != null && description.trim().length() > 0) {
            Annotation annotation;
            AnnotationContainer annotations = null;
            Iterator contents = this.resource.getContents().iterator();
            while (contents.hasNext()) {
                Object next = contents.next();
                if (!(next instanceof AnnotationContainer)) continue;
                annotations = (AnnotationContainer)next;
            }
            if (annotations == null) {
                annotations = CoreFactory.eINSTANCE.createAnnotationContainer();
                this.resource.getContents().add((Object)annotations);
            }
            if ((annotation = annotations.findAnnotation(eObject)) == null) {
                annotation = CoreFactory.eINSTANCE.createAnnotation();
                annotations.getAnnotations().add((Object)annotation);
                annotation.setAnnotatedObject(eObject);
            }
            annotation.setDescription(description);
        }
    }

    public EObject getDatatype(String datatype) {
        ArrayList problems;
        EObject dType;
        if (HEADLESS) {
            return null;
        }
        if (this.datatypesArray == null) {
            try {
                this.datatypesArray = ModelerCore.getWorkspaceDatatypeManager().getAllDatatypes();
            }
            catch (ModelerCoreException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        if (this.datatypesArray != null) {
            String dtName = null;
            for (int i = 0; i < this.datatypesArray.length; ++i) {
                dtName = ModelerCore.getWorkspaceDatatypeManager().getName((EObject)this.datatypesArray[i]);
                if (dtName == null || !dtName.equals(datatype)) continue;
                return (EObject)this.datatypesArray[i];
            }
        }
        if ((dType = this.processor.findType(datatype, problems = new ArrayList())) != null) {
            return dType;
        }
        return null;
    }

    class MyRelationalModelProcessor
    extends RelationalModelProcessorImpl {
        private static final String VARCHAR2_TYPE_NAME = "VARCHAR2";
        private static final String NVARCHAR2_TYPE_NAME = "NVARCHAR2";
        private static final String TIMESTAMP_TYPE_NAME = "TIMESTAMP(";
        private static final String NUMBER_TYPE_NAME = "NUMBER";
        private static final String REF_CURSOR = "REF CURSOR";

        public MyRelationalModelProcessor() {
        }

        public MyRelationalModelProcessor(RelationalFactory factory) {
            super(factory);
        }

        public MyRelationalModelProcessor(RelationalFactory factory, RelationalTypeMapping mapping) {
            super(factory, mapping);
            this.setDatatypeManager(ModelerCore.getWorkspaceDatatypeManager());
        }

        protected EObject findType(int jdbcType, String typeName, int length, int precision, int scale, List problems) {
            EObject result = null;
            if (precision != 0 && (NUMBER_TYPE_NAME.equalsIgnoreCase(typeName) || REF_CURSOR.equalsIgnoreCase(typeName))) {
                result = this.findType(precision, scale, problems);
            }
            if (result != null) {
                return result;
            }
            if (typeName.startsWith(TIMESTAMP_TYPE_NAME)) {
                result = this.findBuiltinType("timestamp", problems);
            }
            if (result != null) {
                return result;
            }
            return super.findType(jdbcType, typeName, length, precision, scale, problems);
        }

        protected EObject findType(String jdbcTypeName, List problems) {
            String standardName = jdbcTypeName;
            if (VARCHAR2_TYPE_NAME.equalsIgnoreCase(jdbcTypeName) || NVARCHAR2_TYPE_NAME.equalsIgnoreCase(jdbcTypeName)) {
                standardName = "VARCHAR";
            }
            return super.findType(standardName, problems);
        }

        protected boolean isFixedLength(int type, String typeName) {
            if (NVARCHAR2_TYPE_NAME.equalsIgnoreCase(typeName)) {
                return false;
            }
            return super.isFixedLength(type, typeName);
        }
    }
}

