/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.ui.actions;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationMappingHelper;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelIdentifier;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.transformation.ui.UiConstants;
import com.metamatrix.modeler.transformation.ui.UiPlugin;
import com.metamatrix.modeler.transformation.validation.TransformationValidator;
import com.metamatrix.modeler.ui.actions.SortableSelectionAction;
import com.metamatrix.ui.internal.eventsupport.SelectionUtilities;
import com.metamatrix.ui.internal.widget.ListMessageDialog;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ImportTransformationSqlFromTextAction
extends SortableSelectionAction
implements UiConstants {
    private static final String IMPORT_PROBLEM_KEY = "ImportTransformationSqlFromTextAction.importProb";
    private static final String IMPORT_SQL_DIALOG_TITLE_KEY = "ImportTransformationSqlFromTextAction.importSqlDialog.title";
    private static final String IMPORT_SQL_PROBLEM_DIALOG_TITLE_KEY = "ImportTransformationSqlFromTextAction.importSqlProblemDialog.title";
    private static final String UNUSED_SQL_DIALOG_TITLE_KEY = "ImportTransformationSqlFromTextAction.unusedSqlDialogTitle";
    private static final String UNUSED_SQL_DIALOG_MESSAGE_KEY = "ImportTransformationSqlFromTextAction.unusedSqlDialogMessage";
    private static final String MONITOR_MAIN_TASK_NAME_KEY = "ImportTransformationSqlFromTextAction.monitorMainTaskName";
    private static final String MONITOR_TASK_SETTING_SQL_KEY = "ImportTransformationSqlFromTextAction.monitorTaskSettingSql";
    private static final String MONITOR_TASK_RECONCILING_KEY = "ImportTransformationSqlFromTextAction.monitorTaskReconciling";
    private static final String MONITOR_TASK_VALIDATING_SQL_KEY = "ImportTransformationSqlFromTextAction.monitorTaskValidatingSql";
    private static final String MONITOR_TASK_SAVING_MODEL = UiConstants.Util.getString("ImportTransformationSqlFromTextAction.monitorTaskSavingModel");
    private static final String DELIMETER = "\\|";
    private boolean isTestingMode = false;
    private Collection anyLeftOverRows;

    public boolean isValidSelection(ISelection selection) {
        return this.virtualModelSelected(selection);
    }

    public void run() {
        Object selectedObj;
        ISelection cachedSelection = this.getSelection();
        if (cachedSelection != null && !cachedSelection.isEmpty() && (selectedObj = SelectionUtilities.getSelectedObject((ISelection)cachedSelection)) != null && selectedObj instanceof IFile) {
            ModelResource modelResource = null;
            try {
                String fileName;
                modelResource = ModelUtilities.getModelResource((IFile)((IFile)selectedObj), (boolean)false);
                if (modelResource != null && (fileName = this.askUserForInputFilename()) != null) {
                    this.importSqlFromFile(fileName, modelResource);
                }
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        this.selectionChanged(null, (ISelection)new StructuredSelection());
    }

    public boolean isApplicable(ISelection selection) {
        return this.virtualModelSelected(selection);
    }

    private boolean virtualModelSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                if (nextObj instanceof IFile) {
                    result = ModelIdentifier.isRelationalViewModel((IResource)((IFile)nextObj));
                    continue;
                }
                result = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection getSqlRowsFromFile(String fileString) {
        ArrayList<SqlRow> sqlRows;
        block21: {
            String str;
            ArgCheck.isNotNull((Object)fileString);
            ArgCheck.isNotEmpty((String)fileString);
            sqlRows = new ArrayList<SqlRow>();
            FileReader fileReader = null;
            BufferedReader bufferReader = null;
            fileReader = new FileReader(fileString);
            bufferReader = new BufferedReader(fileReader);
            while ((str = bufferReader.readLine()) != null) {
                SqlRow newRow = this.createSqlRow(str);
                if (newRow == null) continue;
                sqlRows.add(newRow);
            }
            Object var9_9 = null;
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException e2) {
                UiConstants.Util.log(4, (Throwable)e2, UiConstants.Util.getString(IMPORT_PROBLEM_KEY));
            }
            try {
                if (bufferReader != null) {
                    bufferReader.close();
                }
                break block21;
            }
            catch (IOException e2) {
                UiConstants.Util.log(4, (Throwable)e2, UiConstants.Util.getString(IMPORT_PROBLEM_KEY));
            }
            break block21;
            {
                catch (Exception e) {
                    String msg = UiConstants.Util.getString(IMPORT_PROBLEM_KEY);
                    UiConstants.Util.log(4, (Throwable)e, msg);
                    String dialogMessage = msg + "\n" + e.getMessage();
                    if (!this.isTestingMode) {
                        this.displayError(this.getShell(), UiConstants.Util.getString(IMPORT_SQL_PROBLEM_DIALOG_TITLE_KEY), dialogMessage);
                    }
                    Object var9_10 = null;
                    try {
                        if (fileReader != null) {
                            fileReader.close();
                        }
                    }
                    catch (IOException e2) {
                        UiConstants.Util.log(4, (Throwable)e2, UiConstants.Util.getString(IMPORT_PROBLEM_KEY));
                    }
                    try {
                        if (bufferReader != null) {
                            bufferReader.close();
                        }
                        break block21;
                    }
                    catch (IOException e2) {
                        UiConstants.Util.log(4, (Throwable)e2, UiConstants.Util.getString(IMPORT_PROBLEM_KEY));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (IOException e2) {
                    UiConstants.Util.log(4, (Throwable)e2, UiConstants.Util.getString(IMPORT_PROBLEM_KEY));
                }
                try {
                    if (bufferReader != null) {
                        bufferReader.close();
                    }
                }
                catch (IOException e2) {
                    UiConstants.Util.log(4, (Throwable)e2, UiConstants.Util.getString(IMPORT_PROBLEM_KEY));
                }
                throw throwable;
            }
        }
        return sqlRows;
    }

    public Collection importSqlFromFile(String fileString, ModelResource modelResource) {
        Collection unusedSqlRows = Collections.EMPTY_LIST;
        ArgCheck.isNotNull((Object)fileString);
        ArgCheck.isNotNull((Object)modelResource);
        ArgCheck.isNotEmpty((String)fileString);
        Collection sqlRows = this.getSqlRowsFromFile(fileString);
        try {
            if (!sqlRows.isEmpty()) {
                unusedSqlRows = this.processRows(modelResource, sqlRows);
            }
        }
        catch (ModelWorkspaceException theException) {
            UiConstants.Util.log((Throwable)theException);
        }
        return unusedSqlRows;
    }

    private String askUserForInputFilename() {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        dlg.setFilterExtensions(new String[]{"*.txt", "*.*"});
        dlg.setText(UiConstants.Util.getString(IMPORT_SQL_DIALOG_TITLE_KEY));
        return dlg.open();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection processRows(final ModelResource modelResource, final Collection sqlRows) throws ModelWorkspaceException {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                monitor.beginTask(UiConstants.Util.getString(ImportTransformationSqlFromTextAction.MONITOR_MAIN_TASK_NAME_KEY, (Object)modelResource.getItemName()), 10 * sqlRows.size() + 10);
                try {
                    ImportTransformationSqlFromTextAction.this.setTransformationSql(modelResource, sqlRows, monitor);
                }
                catch (ModelWorkspaceException theException) {
                    UiConstants.Util.log((Throwable)theException);
                }
                monitor.subTask(MONITOR_TASK_SAVING_MODEL);
                monitor.worked(5);
                try {
                    ModelUtilities.saveModelResource((ModelResource)modelResource, (IProgressMonitor)monitor, (boolean)false, (Object)this);
                }
                catch (ModelWorkspaceException e) {
                    UiConstants.Util.log((Throwable)e);
                }
                monitor.worked(5);
            }
        };
        try {
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getShell());
            dlg.run(false, true, op);
            if (!dlg.getProgressMonitor().isCanceled()) {
                // empty if block
            }
        }
        catch (InterruptedException ignored) {
        }
        catch (Exception err) {
            // empty catch block
        }
        ArrayList returnedRows = Collections.EMPTY_LIST;
        if (this.anyLeftOverRows != null) {
            returnedRows = new ArrayList(this.anyLeftOverRows);
            this.anyLeftOverRows = null;
        }
        return returnedRows;
    }

    private Shell getShell() {
        return UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private void displayError(final Shell shell, final String dialogTitle, final String message) {
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)shell, (String)dialogTitle, (String)message);
            }
        });
    }

    private void notifyUserOfLeftovers(final List leftOverTables, List leftOverRows) {
        if (!this.isTestingMode && !leftOverTables.isEmpty()) {
            final Shell shell = this.getShell();
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    boolean result = ListMessageDialog.openQuestion((Shell)shell, (String)UiConstants.Util.getString(ImportTransformationSqlFromTextAction.UNUSED_SQL_DIALOG_TITLE_KEY), null, (String)UiConstants.Util.getString(ImportTransformationSqlFromTextAction.UNUSED_SQL_DIALOG_MESSAGE_KEY), (List)leftOverTables, null);
                    if (result) {
                        // empty if block
                    }
                }
            });
        }
    }

    private SqlRow createSqlRow(String rowString) {
        String[] parsedString = rowString.split(DELIMETER);
        return new SqlRow(this.getSqlTypeFromString(parsedString[1]), parsedString[0], parsedString[2]);
    }

    private boolean setTransformationSql(ModelResource modelResource, Collection sqlRows, IProgressMonitor monitor) throws ModelWorkspaceException {
        boolean sqlChanged = false;
        HashSet<String> leftOverTables = new HashSet<String>();
        HashSet<SqlRow> leftOverRows = new HashSet<SqlRow>();
        int iRow = 0;
        String tableName = null;
        Iterator iter = sqlRows.iterator();
        while (iter.hasNext()) {
            SqlRow nextRow = (SqlRow)iter.next();
            EObject existingTable = null;
            Path tablePath = new Path(nextRow.getPath());
            tableName = tablePath.lastSegment();
            existingTable = ModelerCore.getModelEditor().findObjectByPath(modelResource.getEmfResource(), (IPath)tablePath);
            if (existingTable != null) {
                SqlTransformationMappingRoot root = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)existingTable);
                if (root != null) {
                    monitor.subTask(UiConstants.Util.getString(MONITOR_TASK_SETTING_SQL_KEY, (Object)nextRow.getPath()));
                    TransformationValidator validator = new TransformationValidator(root);
                    boolean changed = false;
                    switch (nextRow.getType()) {
                        case 0: {
                            changed = TransformationHelper.setSqlString((Object)root, (String)nextRow.getSql(), (int)0, (boolean)false, (Object)((Object)this));
                            monitor.subTask(UiConstants.Util.getString(MONITOR_TASK_RECONCILING_KEY, (Object)tableName));
                            monitor.worked(3);
                            TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)root, (Object)((Object)this));
                            monitor.subTask(UiConstants.Util.getString(MONITOR_TASK_VALIDATING_SQL_KEY, (Object)tableName));
                            monitor.worked(3);
                            validator.validateSql(nextRow.getSql(), 0, false, true);
                            monitor.worked(4);
                            break;
                        }
                        case 1: {
                            changed = TransformationHelper.setSqlString((Object)root, (String)nextRow.getSql(), (int)1, (boolean)false, (Object)((Object)this));
                            monitor.subTask(UiConstants.Util.getString(MONITOR_TASK_VALIDATING_SQL_KEY, (Object)tableName));
                            monitor.worked(5);
                            validator.validateSql(nextRow.getSql(), 1, false, true);
                            monitor.worked(5);
                            break;
                        }
                        case 2: {
                            changed = TransformationHelper.setSqlString((Object)root, (String)nextRow.getSql(), (int)2, (boolean)false, (Object)((Object)this));
                            monitor.subTask(UiConstants.Util.getString(MONITOR_TASK_VALIDATING_SQL_KEY, (Object)tableName));
                            monitor.worked(5);
                            validator.validateSql(nextRow.getSql(), 2, false, true);
                            monitor.worked(5);
                            break;
                        }
                        case 3: {
                            changed = TransformationHelper.setSqlString((Object)root, (String)nextRow.getSql(), (int)3, (boolean)false, (Object)((Object)this));
                            monitor.worked(5);
                            monitor.subTask(UiConstants.Util.getString(MONITOR_TASK_VALIDATING_SQL_KEY, (Object)tableName));
                            validator.validateSql(nextRow.getSql(), 3, false, true);
                            monitor.worked(5);
                            break;
                        }
                    }
                    if (changed) {
                        sqlChanged = true;
                    }
                }
            } else if (!leftOverTables.contains(nextRow.getPath())) {
                leftOverTables.add(nextRow.getPath());
                leftOverRows.add(nextRow);
            }
            ++iRow;
        }
        if (leftOverRows != null) {
            this.anyLeftOverRows = leftOverRows;
        }
        this.notifyUserOfLeftovers(new ArrayList(leftOverTables), new ArrayList(leftOverRows));
        return sqlChanged;
    }

    private int getSqlTypeFromString(String typeString) {
        if (typeString.equalsIgnoreCase("SELECT")) {
            return 0;
        }
        if (typeString.equalsIgnoreCase("INSERT")) {
            return 1;
        }
        if (typeString.equalsIgnoreCase("UPDATE")) {
            return 2;
        }
        if (typeString.equalsIgnoreCase("DELETE")) {
            return 3;
        }
        return -1;
    }

    public boolean isTestingMode() {
        return this.isTestingMode;
    }

    public void setIsTestingMode(boolean theIsTestingMode) {
        this.isTestingMode = theIsTestingMode;
    }

    class SqlRow {
        private int type;
        private String path;
        private String sql;

        SqlRow(int sqlType, String relativePathAndName, String userSqlString) {
            this.type = sqlType;
            this.path = relativePathAndName;
            this.sql = userSqlString;
        }

        public String getPath() {
            return this.path;
        }

        public String getSql() {
            return this.sql;
        }

        public int getType() {
            return this.type;
        }
    }
}

