/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.internal.builder.execution;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.metamodels.builder.MetamodelBuilderPlugin;
import com.metamatrix.metamodels.builder.ModelBuilder;
import com.metamatrix.metamodels.builder.ModelRecord;
import com.metamatrix.metamodels.builder.execution.MetamodelBuilderConstants;
import com.metamatrix.metamodels.builder.execution.MetamodelBuilderExecutionPlugin;
import com.metamatrix.metamodels.core.CorePackage;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.core.extension.XPackage;
import com.metamatrix.metamodels.internal.builder.execution.util.MetamodelBuilderUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ModelBuilderImpl
implements ModelBuilder,
MetamodelBuilderConstants {
    private final ResourceSet eResourceSet;
    private final MultiStatus status;
    private boolean builderDebugEnabled = false;
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$metamodels$internal$builder$execution$ModelBuilderImpl == null ? (class$com$metamatrix$metamodels$internal$builder$execution$ModelBuilderImpl = ModelBuilderImpl.class$("com.metamatrix.metamodels.internal.builder.execution.ModelBuilderImpl")) : class$com$metamatrix$metamodels$internal$builder$execution$ModelBuilderImpl));
    static /* synthetic */ Class class$com$metamatrix$metamodels$internal$builder$execution$ModelBuilderImpl;

    private static String getString(String id, Object param1, Object param2) {
        return MetamodelBuilderConstants.UTIL.getString(I18N_PREFIX + id, param1, param2);
    }

    public ModelBuilderImpl(MultiStatus status, ResourceSet resourceSet) {
        ArgCheck.isNotNull((Object)resourceSet);
        ArgCheck.isNotNull((Object)status);
        this.eResourceSet = resourceSet;
        this.status = status;
    }

    public Resource create(ModelRecord record) {
        ArgCheck.isNotNull((Object)record);
        this.builderDebugEnabled = MetamodelBuilderPlugin.Util.isDebugEnabled("metamodelBuilder");
        String absoluteModelPath = this.getModelAbsolutePath(record);
        URI uri = URI.createFileURI((String)absoluteModelPath);
        if (this.eResourceSet.getResource(uri, false) != null) {
            return this.eResourceSet.getResource(uri, false);
        }
        Resource eResource = this.eResourceSet.createResource(uri);
        this.initModelResource(eResource, record);
        this.eResourceSet.getResources().add((Object)eResource);
        return eResource;
    }

    public List create(List records) {
        ArgCheck.isNotNull((Object)records);
        ArrayList<Resource> resources = new ArrayList<Resource>(records.size());
        Iterator iter = records.iterator();
        while (iter.hasNext()) {
            Resource resource = this.create((ModelRecord)iter.next());
            if (resource == null) continue;
            resources.add(resource);
        }
        return resources;
    }

    private String getModelAbsolutePath(ModelRecord record) {
        String locationPath = record.getLocationPath();
        String modelName = record.getModelName();
        String absolutePath = locationPath + "\\" + modelName + ".xmi";
        return absolutePath;
    }

    private void initModelResource(Resource modelResource, ModelRecord record) {
        String modelType = record.getModelType();
        String modelSubType = record.getModelSubType();
        String modelNameInSource = record.getModelNameInSource();
        String modelDescription = record.getModelDescription();
        String extensionPackage = record.getExtensionPackage();
        EFactory factory = CorePackage.eINSTANCE.getEFactoryInstance();
        ModelAnnotation annot = (ModelAnnotation)factory.create(CorePackage.eINSTANCE.getModelAnnotation());
        if ("Relational".equalsIgnoreCase(modelType)) {
            annot.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
            if ("Physical".equalsIgnoreCase(modelSubType)) {
                annot.setModelType(ModelType.PHYSICAL_LITERAL);
            } else if ("Virtual".equalsIgnoreCase(modelSubType)) {
                annot.setModelType(ModelType.VIRTUAL_LITERAL);
            }
        } else if ("Relationship".equalsIgnoreCase(modelType)) {
            annot.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relationship");
            annot.setModelType(ModelType.PHYSICAL_LITERAL);
        } else if ("Extension".equalsIgnoreCase(modelType)) {
            annot.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Extension");
            annot.setModelType(ModelType.EXTENSION_LITERAL);
        }
        annot.setNameInSource(modelNameInSource);
        annot.setDescription(modelDescription);
        if (extensionPackage != null) {
            Object xPkg = MetamodelBuilderUtil.findEObjectByPath((ResourceSet)this.eResourceSet, (String)extensionPackage, null, (MultiStatus)this.status);
            if (xPkg != null && xPkg instanceof XPackage) {
                annot.setExtensionPackage((XPackage)xPkg);
            } else {
                String msg = ModelBuilderImpl.getString("noXPkg", extensionPackage, modelResource.getURI().lastSegment());
                MetamodelBuilderUtil.addStatus((MultiStatus)this.status, (int)4, (String)msg);
                if (this.builderDebugEnabled) {
                    MetamodelBuilderExecutionPlugin.Util.log(4, msg);
                }
            }
        }
        modelResource.getContents().add((Object)annot);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

