/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.ui.wizards;

import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.ui.explorer.ModelExplorerLabelProvider;
import com.metamatrix.modeler.internal.ui.wizards.ICheckboxTreeViewerListenerController;
import com.metamatrix.modeler.internal.ui.wizards.IStructuralCopyTreePopulator;
import com.metamatrix.modeler.internal.ui.wizards.IndexAndObject;
import com.metamatrix.modeler.internal.ui.wizards.StructuralCopyException;
import com.metamatrix.modeler.internal.ui.wizards.StructuralCopyTreeContentProvider;
import com.metamatrix.modeler.internal.ui.wizards.StructuralCopyTreeViewerFilter;
import com.metamatrix.ui.internal.widget.InheritanceCheckboxTreeViewer;
import com.metamatrix.ui.tree.TreeSplitter;
import com.metamatrix.ui.tree.TreeViewerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;

public class StructuralCopyModelFeaturePopulator
implements IStructuralCopyTreePopulator {
    private static String VIRTUAL_ROOT = "ROOT";
    protected IFile sourceFile;
    protected ICheckboxTreeViewerListenerController listenerController;
    protected ModelResource targetModelResource;
    protected ModelEditor modelEditor = ModelerCore.getModelEditor();

    public StructuralCopyModelFeaturePopulator(IFile sourceFile, ICheckboxTreeViewerListenerController listenerController) {
        this.sourceFile = sourceFile;
        this.listenerController = listenerController;
    }

    public void populateModelFeaturesTree(InheritanceCheckboxTreeViewer viewer, ModelResource theModel, boolean targetIsVirtual) {
        ViewerFilter[] filters = viewer.getFilters();
        StructuralCopyTreeViewerFilter filter = this.findStructuralCopyFilter(filters);
        if (targetIsVirtual) {
            if (filter == null) {
                viewer.addFilter((ViewerFilter)new StructuralCopyTreeViewerFilter());
            }
        } else if (filter != null) {
            viewer.removeFilter((ViewerFilter)filter);
        }
        StructuralCopyTreeContentProvider contentProvider = StructuralCopyTreeContentProvider.getInstance();
        viewer.setContentProvider((IContentProvider)contentProvider);
        ModelExplorerLabelProvider labelProvider = new ModelExplorerLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.setInput(null);
        viewer.setUseHashlookup(true);
        viewer.setInput((Object)theModel);
    }

    private StructuralCopyTreeViewerFilter findStructuralCopyFilter(ViewerFilter[] filters) {
        for (int i = 0; i < filters.length; ++i) {
            ViewerFilter filter = filters[i];
            if (!(filter instanceof StructuralCopyTreeViewerFilter)) continue;
            return (StructuralCopyTreeViewerFilter)filter;
        }
        return null;
    }

    public void copyModel(ModelResource sourceModelResource, ModelResource targetModelResource, InheritanceCheckboxTreeViewer viewer, Map extraProperties, IProgressMonitor monitor) throws ModelerCoreException, StructuralCopyException {
        EList sourceFirstLevelChildren = sourceModelResource.getEmfResource().getContents();
        Collection sourceFirstLevelChildrenCopies = null;
        sourceFirstLevelChildrenCopies = this.modelEditor.copyAll((Collection)sourceFirstLevelChildren);
        EList targetChildren = targetModelResource.getEmfResource().getContents();
        int numKids = targetChildren.size();
        for (int i = 0; i < numKids; ++i) {
            Object kid = targetChildren.get(i);
            if (!(kid instanceof ModelAnnotation)) continue;
            targetChildren.remove(kid);
            break;
        }
        if (viewer == null) {
            targetModelResource.getEmfResource().getContents().addAll(sourceFirstLevelChildrenCopies);
        } else {
            DefaultMutableTreeNode neededNodesRoot = this.getParedTreeRoot(viewer, sourceModelResource);
            Object targetFirstLevelChildren = targetModelResource.getEmfResource().getContents();
            int numInitialFirstLevelNodes = targetFirstLevelChildren.size();
            targetModelResource.getEmfResource().getContents().addAll(sourceFirstLevelChildrenCopies);
            this.adjustIndexOfFirstLevelChildren(neededNodesRoot, numInitialFirstLevelNodes);
            this.insertInitialFirstLevelChildren(neededNodesRoot, (List)targetFirstLevelChildren, numInitialFirstLevelNodes);
            targetFirstLevelChildren = new ArrayList(targetModelResource.getEObjects());
            this.deleteUnneededNodes(neededNodesRoot, (Collection)targetFirstLevelChildren, numInitialFirstLevelNodes);
        }
    }

    protected void deleteUnneededNodes(DefaultMutableTreeNode structureRoot, Collection modelFirstLevelChildren, int numInitialStructureRootChildren) throws ModelerCoreException {
        Object curNode = VIRTUAL_ROOT;
        DefaultMutableTreeNode curStructureNode = structureRoot;
        int curNodeIndex = 0;
        boolean done = false;
        while (!done) {
            Collection curNodeChildren = this.getChildren(curNode, modelFirstLevelChildren);
            int numCurNodeChildren = curNodeChildren.size();
            DefaultMutableTreeNode[] curStructureNodeChildren = this.getChildrenOfNode(curStructureNode);
            int topIndexToDelete = numCurNodeChildren - 1;
            for (int i = curStructureNodeChildren.length - 1; i >= 0; --i) {
                IndexAndObject io = (IndexAndObject)curStructureNodeChildren[i].getUserObject();
                int index = io.getIndex();
                for (int j = topIndexToDelete; j > index; --j) {
                    this.deleteChildAtIndex(curNode, j, modelFirstLevelChildren);
                }
                topIndexToDelete = index - 1;
            }
            for (int j = topIndexToDelete; j >= 0; --j) {
                if (curStructureNode == structureRoot && j <= numInitialStructureRootChildren - 1) continue;
                this.deleteChildAtIndex(curNode, j, modelFirstLevelChildren);
            }
            if (numCurNodeChildren > 0) {
                Object firstChild;
                curNodeIndex = curStructureNode == structureRoot ? numInitialStructureRootChildren : 0;
                curNode = firstChild = this.getChildAtIndex(curNode, curNodeIndex, modelFirstLevelChildren);
                curStructureNode = (DefaultMutableTreeNode)curStructureNode.getChildAt(curNodeIndex);
                continue;
            }
            boolean nodeFound = false;
            while (!nodeFound && !done) {
                int numChildrenOfParent;
                Object curNodeParent = this.getParent(curNode, modelFirstLevelChildren);
                if (curNodeParent == null) {
                    done = true;
                    continue;
                }
                DefaultMutableTreeNode curStructureNodeParent = (DefaultMutableTreeNode)curStructureNode.getParent();
                curNodeIndex = curStructureNodeParent.getIndex(curStructureNode);
                if (curNodeIndex < (numChildrenOfParent = curStructureNodeParent.getChildCount()) - 1) {
                    curNode = this.getChildAtIndex(curNodeParent, ++curNodeIndex, modelFirstLevelChildren);
                    curStructureNode = (DefaultMutableTreeNode)curStructureNodeParent.getChildAt(curNodeIndex);
                    nodeFound = true;
                    continue;
                }
                curNode = curNodeParent;
                curStructureNode = curStructureNodeParent;
            }
        }
    }

    protected DefaultMutableTreeNode[] getChildrenOfNode(DefaultMutableTreeNode node) {
        int numChildren = node.getChildCount();
        DefaultMutableTreeNode[] children = new DefaultMutableTreeNode[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            children[i] = (DefaultMutableTreeNode)node.getChildAt(i);
        }
        return children;
    }

    protected Object getParent(Object curNode, Collection sourceFirstLevelChildrenCopies) {
        String parent;
        if (curNode == VIRTUAL_ROOT) {
            parent = null;
        } else if (sourceFirstLevelChildrenCopies.contains(curNode)) {
            parent = VIRTUAL_ROOT;
        } else {
            EObject obj = (EObject)curNode;
            parent = obj.eContainer();
        }
        return parent;
    }

    protected Collection getChildren(Object curNode, Collection sourceFirstLevelChildrenCopies) {
        Collection children;
        if (curNode == VIRTUAL_ROOT) {
            children = sourceFirstLevelChildrenCopies;
        } else {
            EObject obj = (EObject)curNode;
            children = obj.eContents();
        }
        return children;
    }

    protected void deleteChildAtIndex(Object parent, int index, Collection sourceFirstLevelChildrenCopies) throws ModelerCoreException {
        Collection children;
        if (parent == VIRTUAL_ROOT) {
            children = sourceFirstLevelChildrenCopies;
        } else {
            EObject obj = (EObject)parent;
            children = obj.eContents();
        }
        Iterator it = children.iterator();
        for (int i = 0; i < index; ++i) {
            it.next();
        }
        Object childToRemove = it.next();
        if (parent == VIRTUAL_ROOT) {
            sourceFirstLevelChildrenCopies.remove(childToRemove);
        }
        this.modelEditor.delete((EObject)childToRemove);
    }

    protected Object getChildAtIndex(Object parent, int index, Collection sourceFirstLevelChildrenCopies) {
        Collection children;
        if (parent == VIRTUAL_ROOT) {
            children = sourceFirstLevelChildrenCopies;
        } else {
            EObject obj = (EObject)parent;
            children = obj.eContents();
        }
        Iterator it = children.iterator();
        for (int i = 0; i < index; ++i) {
            it.next();
        }
        Object child = it.next();
        return child;
    }

    protected DefaultMutableTreeNode getParedTreeRoot(InheritanceCheckboxTreeViewer viewer, ModelResource modelResource) {
        DefaultMutableTreeNode root;
        DefaultMutableTreeNode curNode = root = new DefaultMutableTreeNode(new IndexAndObject(0, modelResource));
        boolean done = false;
        while (!done) {
            IndexAndObject io = (IndexAndObject)curNode.getUserObject();
            Object obj = io.getObject();
            Object[] children = obj instanceof TreeSplitter && !((TreeSplitter)obj).isMaterialized() ? TreeViewerUtil.EMPTY_OBJECT_ARRAY : ((ITreeContentProvider)viewer.getContentProvider()).getChildren(obj);
            int childIndex = this.firstRequiredChildIndex(viewer, 0, children);
            if (childIndex >= 0) {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new IndexAndObject(childIndex, children[childIndex]));
                curNode.add(newNode);
                curNode = newNode;
                continue;
            }
            boolean nextNodeFound = false;
            while (!nextNodeFound && !done) {
                io = (IndexAndObject)curNode.getUserObject();
                Object prevNodeContentObject = io.getObject();
                if ((curNode = (DefaultMutableTreeNode)curNode.getParent()) == null) {
                    done = true;
                    continue;
                }
                io = (IndexAndObject)curNode.getUserObject();
                Object curNodeContentObject = io.getObject();
                children = curNodeContentObject instanceof TreeSplitter && !((TreeSplitter)obj).isMaterialized() ? TreeViewerUtil.EMPTY_OBJECT_ARRAY : ((ITreeContentProvider)viewer.getContentProvider()).getChildren(curNodeContentObject);
                int prevNodeIndex = this.indexOf(prevNodeContentObject, children);
                childIndex = this.firstRequiredChildIndex(viewer, prevNodeIndex + 1, children);
                if (childIndex < 0) continue;
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new IndexAndObject(childIndex, children[childIndex]));
                curNode.add(newNode);
                curNode = newNode;
                nextNodeFound = true;
            }
        }
        return root;
    }

    protected int firstRequiredChildIndex(InheritanceCheckboxTreeViewer viewer, int startingIndex, Object[] children) {
        int firstRequiredIndex = -1;
        int curIndex = startingIndex;
        while (curIndex < children.length && firstRequiredIndex < 0) {
            Object curChild = children[curIndex];
            if (viewer.getChecked(curChild) || TreeViewerUtil.anyDescendantChecked((CheckboxTreeViewer)viewer, (Object)curChild)) {
                firstRequiredIndex = curIndex;
                continue;
            }
            ++curIndex;
        }
        return firstRequiredIndex;
    }

    protected int indexOf(Object obj, Object[] array) {
        int index = 0;
        while (obj != array[index]) {
            ++index;
        }
        return index;
    }

    protected void insertInitialFirstLevelChildren(DefaultMutableTreeNode root, List firstLevelChildren, int numToInsert) {
        for (int i = 0; i < numToInsert; ++i) {
            IndexAndObject io = new IndexAndObject(i, firstLevelChildren.get(i));
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(io);
            root.insert(child, i);
        }
    }

    protected void adjustIndexOfFirstLevelChildren(DefaultMutableTreeNode root, int increment) {
        DefaultMutableTreeNode[] children = this.getChildrenOfNode(root);
        for (int i = 0; i < children.length; ++i) {
            IndexAndObject io = (IndexAndObject)children[i].getUserObject();
            io.setIndex(io.getIndex() + increment);
        }
    }

    protected Object getObjectForTreeNodeUserObject(Object treeNodeUserObject) {
        IndexAndObject io = (IndexAndObject)treeNodeUserObject;
        return io.getObject();
    }
}

