/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.ComponentNotAvailableException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.MemoryNotAvailableException;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageListener;
import com.metamatrix.common.lob.CharValueGlob;
import com.metamatrix.common.lob.ValueGlob;
import com.metamatrix.common.lob.ValueID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.xa.MMTransactionManager;
import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.exception.SourceFailureDetails;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.internal.process.CodeTableCache;
import com.metamatrix.dqp.internal.process.ConnectorRequestInfo;
import com.metamatrix.dqp.internal.process.DataTierManager;
import com.metamatrix.dqp.internal.process.DataTierTupleSource;
import com.metamatrix.dqp.internal.process.QueryTupleSource;
import com.metamatrix.dqp.internal.process.RequestManager;
import com.metamatrix.dqp.internal.process.WorkItem;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.dqp.service.BufferService;
import com.metamatrix.dqp.service.DataService;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.query.e.g;
import com.metamatrix.query.f.b;
import com.metamatrix.query.i.f;
import com.metamatrix.query.m.e;
import com.metamatrix.query.o.d;
import com.metamatrix.query.o.i.a;
import com.metamatrix.query.o.j.ag;
import com.metamatrix.query.o.j.j;
import com.metamatrix.query.o.j.l;
import com.metamatrix.query.o.j.s;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataTierManager
implements com.metamatrix.query.e.d,
MessageListener {
    private RequestManager requestMgr;
    private WorkerPool processPool;
    private DataService dataService;
    private MetadataService metadataService;
    private VDBService vdbService;
    private TransactionService txnService;
    private BufferService bufferService;
    private int maxCodeTableRecords;
    private Map processors = new HashMap();
    private CodeTableCache codeTableCache;
    static final String CONTEXT = "com.metamatrix.dqp";

    public DataTierManager(RequestManager requestMgr, DataService dataService, MetadataService metadataService, VDBService vdbService, TransactionService txnService, BufferService bufferService, WorkerPool processPool, int maxCodeTables, int maxCodeTableRecords) {
        this.requestMgr = requestMgr;
        this.dataService = dataService;
        this.metadataService = metadataService;
        this.vdbService = vdbService;
        this.processPool = processPool;
        this.maxCodeTableRecords = maxCodeTableRecords;
        this.txnService = txnService;
        this.bufferService = bufferService;
        this.codeTableCache = new CodeTableCache(maxCodeTables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProcessor(Object processorID, com.metamatrix.query.e.f processor) {
        Map map = this.processors;
        synchronized (map) {
            this.processors.put(processorID, processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterProcessor(Object processorID) {
        Map map = this.processors;
        synchronized (map) {
            this.processors.remove(processorID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.metamatrix.query.e.f getProcessor(Object processorID) {
        Map map = this.processors;
        synchronized (map) {
            return (com.metamatrix.query.e.f)this.processors.get(processorID);
        }
    }

    public void registerRequest(Object processorID, l command, String modelName, int nodeID, int execCount) throws MetaMatrixComponentException {
        RequestMessage request = this.requestMgr.getRequest((RequestID)processorID);
        if (request != null) {
            AtomicRequestMessage aqr = new AtomicRequestMessage(request);
            aqr.markSubmissionStart();
            aqr.setCommand(command);
            aqr.setNodeID(nodeID);
            aqr.setExecCount(execCount);
            aqr.setModelName(modelName);
            aqr.setCursorType(request.getCursorType());
            aqr.setFetchSize(this.bufferService.getBufferManager().getConnectorBatchSize());
            String binding = modelName;
            if (!modelName.startsWith("mmuuid")) {
                List bindings = this.vdbService.getConnectorBindingNames(request.getVdbName(), request.getVdbVersion(), modelName);
                if (bindings == null || bindings.isEmpty()) {
                    Object[] params = new Object[]{modelName, request.getVdbName(), request.getVdbVersion()};
                    throw new MetaMatrixComponentException(DQPPlugin.Util.getString("DataTierManager.could_not_obtain_connector_binding", params));
                }
                binding = (String)bindings.get(0);
            }
            aqr.setConnectorBindingID(binding);
            this.registerRequest(aqr);
        } else {
            Object[] params = new Object[]{processorID};
            LogManager.logWarning("DQP", DQPPlugin.Util.getString("DataTierManager.Could_not_register_the_request_for_{0}_as_request_has_been_removed_from_QueryService.", params));
        }
    }

    public void registerRequest(AtomicRequestMessage request) throws MetaMatrixComponentException {
        ConnectorID connectorID = request.getConnectorID();
        String connectorBindingID = request.getConnectorBindingID();
        try {
            if (connectorID == null || connectorID.getID() == null) {
                if (connectorBindingID == null) {
                    throw new MetaMatrixComponentException(DQPPlugin.Util.getString("DataTierManager.could_not_obtain_connector_id"));
                }
                connectorID = this.dataService.selectConnector(connectorBindingID);
            }
            if (request.getType() == 1) {
                ConnectorRequestInfo info = new ConnectorRequestInfo(request, connectorID);
                this.requestMgr.addConnectorInfo(request.getRequestID(), info);
            }
            this.dataService.executeRequest(request, connectorID, (MessageListener)this);
        }
        catch (Exception ex) {
            List infos;
            if (connectorBindingID == null && connectorID != null && (infos = this.requestMgr.getAllConnectorInfo(request.getRequestID())) != null) {
                Iterator iter = infos.iterator();
                while (iter.hasNext()) {
                    ConnectorRequestInfo info = (ConnectorRequestInfo)iter.next();
                    if (!connectorID.equals((Object)info.getConnectorID())) continue;
                    connectorBindingID = info.getConnectorBindingID();
                    break;
                }
            }
            String connectorName = null;
            if (connectorBindingID != null) {
                try {
                    connectorName = this.vdbService.getConnectorName(connectorBindingID);
                }
                catch (Throwable t2) {
                    // empty catch block
                }
            }
            String message = DQPPlugin.Util.getString("DataTierManager.cannot_register_request", (Object)connectorName, (Object)connectorID, (Object)ex.getMessage());
            MetaMatrixComponentException exx = new MetaMatrixComponentException((Throwable)ex, message);
            if (request.supportsPartialResults()) {
                this.deliverPartialResults(request, (MetaMatrixException)((Object)exx));
                this.enqueueRequest(request.getRequestID());
            }
            throw exx;
        }
    }

    public void deliverMessage(Message message, String messageKey) {
        Object[] params;
        ResultsMessage response = (ResultsMessage)message;
        RequestID requestID = response.getRequestID();
        RequestMessage request = this.requestMgr.getRequest(requestID);
        if (request == null) {
            if (LogManager.isMessageToBeRecorded("DQP", 5)) {
                LogManager.logDetail("DQP", DQPPlugin.Util.getString("DataTierManager.Could_not_deliver_response_for_{0}_as_request_has_been_removed_from_QueryService.", (Object)requestID));
            }
            return;
        }
        if (request.isTransactional()) {
            TransactionContext requestTxnContxt = request.getTransactionContext();
            TransactionContext responseTxnContxt = response.getTransactionContext();
            if (responseTxnContxt != null && responseTxnContxt.hasResult()) {
                block47: {
                    try {
                        MMTransactionManager txnMgr = this.txnService.getTransactionManager();
                        txnMgr.resumeTransaction(requestTxnContxt, null);
                        txnMgr.addTransactionResult(responseTxnContxt);
                        txnMgr.suspendTransaction(requestTxnContxt);
                    }
                    catch (XATransactionException e2) {
                        params = new Object[]{requestID};
                        LogManager.logError("DQP", (Throwable)e2, DQPPlugin.Util.getString("DataTierManager.Unable_to_add_txn_result_for_request_{0}", params));
                        if (response.getException() == null) {
                            response.setException((Throwable)e2);
                        }
                    }
                    catch (MetaMatrixComponentException e3) {
                        params = new Object[]{requestID};
                        LogManager.logError("DQP", (Throwable)e3, DQPPlugin.Util.getString("DataTierManager.Unable_to_add_txn_result_for_request_{0}", params));
                        if (response.getException() != null) break block47;
                        response.setException((Throwable)e3);
                    }
                }
                response.setTransactionContext(null);
            }
        }
        int nodeID = response.getPlanNodeID();
        boolean requestEnqueued = false;
        if (LogManager.isMessageToBeRecorded("DQP", 6)) {
            LogManager.logTrace("DQP", new Object[]{"DataTierManager - deliver response, requestID =", requestID, ", nodeID =", new Integer(nodeID)});
        }
        if (response.getException() != null) {
            if (this.codeTableCache.isCodeTableResponse(requestID, nodeID)) {
                this.handleCodeTableError(requestID, nodeID, response.getException());
                requestEnqueued = true;
            } else if (!request.supportsPartialResults()) {
                this.notifyProcessorOfError(requestID, response.getException());
            } else {
                ConnectorRequestInfo info = this.requestMgr.getConnectorInfo(requestID, nodeID);
                if (info != null) {
                    this.deliverPartialResults(info.getAtomicRequest(), response.getException());
                } else {
                    params = new Object[]{requestID, new Integer(nodeID)};
                    String msg = DQPPlugin.Util.getString("DataTierManager.Could_not_deliver_partial_results_for_{0}_as_the_atomic_query_request_could_not_be_obtained_for_nodeID_{1}", params);
                    if (this.requestMgr.isRequestCancelled(requestID)) {
                        LogManager.logDetail("DQP", msg);
                    } else {
                        LogManager.logWarning("DQP", msg);
                    }
                }
            }
            this.requestMgr.removeConnectorInfo(requestID, nodeID);
        } else if (!response.isLob()) {
            boolean isLastBatch;
            if (LogManager.isMessageToBeRecorded("DQP", 6)) {
                LogManager.logTrace("DQP", new Object[]{"first=", new Integer(response.getFirstRow()), ", final=", new Integer(response.getFinalRow()), ", isPartial=", response.isPartialResults()});
            }
            boolean bl = isLastBatch = response.getFinalRow() >= 0;
            if (this.codeTableCache.isCodeTableResponse(requestID, nodeID)) {
                boolean codeTableLoadable = this.isCodeTableLoadable(response.getLastRow());
                if (!codeTableLoadable) {
                    this.requestMgr.removeConnectorInfo(requestID, nodeID);
                    Object[] params2 = new Object[]{requestID, new Integer(nodeID)};
                    String msg = DQPPlugin.Util.getString("DataTierManager.Unable_to_load_code_table_for_requestID_{0}_of_and_nodeID_of_{1}_because_result_sizes_exceeds_the_allowed_parameter_-_MaxCodeTableRecords.", params2);
                    LogManager.logError("DQP", msg);
                    MetaMatrixComponentException me = new MetaMatrixComponentException("ERR.018.005.0100", DQPPlugin.Util.getString("ERR.018.005.0100", (Object)requestID, (Object)new Integer(nodeID)));
                    this.handleCodeTableError(requestID, nodeID, (MetaMatrixException)((Object)me));
                    requestEnqueued = true;
                } else {
                    this.codeTableCache.loadTable(requestID, nodeID, response.getResults());
                    if (!isLastBatch) {
                        ConnectorRequestInfo info = this.requestMgr.getConnectorInfo(requestID, nodeID);
                        AtomicRequestMessage aqr = DataTierManager.createMoreRequest(info.getAtomicRequest(), info.getConnectorID());
                        try {
                            this.registerRequest(aqr);
                        }
                        catch (MetaMatrixComponentException e4) {
                            String msg = DQPPlugin.Util.getString("DataTierManager.Failed_to_register_request.");
                            LogManager.logError("DQP", (Throwable)e4, msg);
                            this.requestMgr.removeConnectorInfo(requestID, nodeID);
                            this.handleCodeTableError(requestID, nodeID, (MetaMatrixException)((Object)e4));
                            requestEnqueued = true;
                        }
                    } else {
                        Set requests = this.codeTableCache.markCacheLoaded(requestID, nodeID);
                        this.notifyWaitingCodeTableRequests(requests);
                        requestEnqueued = true;
                    }
                }
            } else if (response.getFirstRow() <= 1) {
                AtomicRequestMessage original;
                QueryTupleSource ts = null;
                ConnectorRequestInfo info = this.requestMgr.getConnectorInfo(requestID, nodeID);
                if (info != null) {
                    original = info.getAtomicRequest();
                    original.setProcessingTimestamp(response.getProcessingTimestamp());
                }
                if (isLastBatch) {
                    ts = new QueryTupleSource(response.getResults(), response.getCommand().gf());
                } else {
                    info = this.requestMgr.getConnectorInfo(requestID, nodeID);
                    if (info != null) {
                        original = info.getAtomicRequest();
                        AtomicRequestMessage aqr = DataTierManager.createMoreRequest(original, info.getConnectorID());
                        DataTierTupleSource dtts = new DataTierTupleSource(original.getCommand().gf(), aqr, this);
                        info.setTupleSource(dtts);
                        ts = dtts;
                        dtts.addBatch(response.getResults(), false);
                    }
                }
                if (ts != null) {
                    this.deliverTupleSourceToProcessor(requestID, nodeID, (TupleSource)ts);
                } else {
                    Object[] params3 = new Object[]{requestID};
                    String msg = DQPPlugin.Util.getString("DataTierManager.Could_not_deliver_response_for_{0}_as_a_matching_atomic_request_could_not_be_found.", params3);
                    if (this.requestMgr.isRequestCancelled(requestID)) {
                        LogManager.logDetail("DQP", msg);
                    } else {
                        LogManager.logWarning("DQP", msg);
                        MetaMatrixComponentException exception = new MetaMatrixComponentException(msg);
                        this.notifyProcessorOfError(requestID, (MetaMatrixException)((Object)exception));
                    }
                }
            } else {
                LogManager.logTrace("DQP", "Delivering more batch=");
                ConnectorRequestInfo info = this.requestMgr.getConnectorInfo(requestID, nodeID);
                if (info != null) {
                    info.getTupleSource().addBatch(response.getResults(), isLastBatch);
                } else {
                    Object[] params4 = new Object[]{requestID};
                    String msg = DQPPlugin.Util.getString("DataTierManager.Could_not_deliver_response_for_{0}_as_a_matching_atomic_request_could_not_be_found.", params4);
                    if (this.requestMgr.isRequestCancelled(requestID)) {
                        LogManager.logDetail("DQP", msg);
                    } else {
                        LogManager.logWarning("DQP", msg);
                        MetaMatrixComponentException exception = new MetaMatrixComponentException(msg);
                        this.notifyProcessorOfError(requestID, (MetaMatrixException)((Object)exception));
                    }
                }
            }
            if (isLastBatch && !DataTierManager.hasLOBColumns(response)) {
                this.requestMgr.removeConnectorInfo(requestID, nodeID);
            }
        }
        if (!requestEnqueued) {
            if (response.isLob()) {
                this.enqueueRequest(requestID, response.getValueID(), response);
            } else {
                this.enqueueRequest(requestID);
            }
        }
    }

    protected static boolean hasLOBColumns(ResultsMessage results) {
        String[] dataTypes = results.getDataTypes();
        if (dataTypes == null) {
            return false;
        }
        int length = dataTypes.length;
        for (int i2 = 0; i2 < length; ++i2) {
            String type = dataTypes[i2];
            if (!"blob".equals(type) && !"clob".equals(type) && !"xml".equals(type)) continue;
            return true;
        }
        return false;
    }

    private void handleCodeTableError(RequestID requestID, int nodeID, MetaMatrixException e2) {
        this.notifyProcessorOfError(requestID, e2);
        Set requests = this.codeTableCache.errorLoadingCache(requestID, nodeID);
        this.notifyWaitingCodeTableRequests(requests);
    }

    private void notifyWaitingCodeTableRequests(Collection requests) {
        if (requests != null) {
            Iterator reqIter = requests.iterator();
            while (reqIter.hasNext()) {
                this.enqueueRequest((RequestID)reqIter.next());
            }
        }
    }

    private void enqueueRequest(RequestID requestID) {
        try {
            this.requestMgr.markHasData(requestID, new WorkItem(requestID));
        }
        catch (QueueSuspendedException queueSuspendedException) {
            // empty catch block
        }
    }

    private void enqueueRequest(RequestID reqID, ValueID valueID, ResultsMessage res) {
        try {
            WorkItem it = new WorkItem(reqID, valueID, res);
            this.processPool.addWork((Object)it);
        }
        catch (QueueSuspendedException e2) {
            // empty catch block
        }
    }

    private void deliverPartialResults(AtomicRequestMessage aqr, MetaMatrixException exception) {
        RequestID requestID = aqr.getRequestID();
        String connectorBindingName = this.vdbService.getConnectorName(aqr.getConnectorBindingID());
        ag query = (ag)aqr.getCommand();
        ArrayList groupSymbols = new ArrayList();
        com.metamatrix.query.o.h.d.ej((d)query, groupSymbols);
        com.metamatrix.query.o.i.f group = (com.metamatrix.query.o.i.f)groupSymbols.get(0);
        SourceFailureDetails sourceFailure = new SourceFailureDetails(group.ak(), connectorBindingName, exception);
        this.requestMgr.addSourceFailureDetails(sourceFailure, requestID);
        List elements = query.gf();
        g source = new g(elements);
        this.deliverTupleSourceToProcessor(requestID, aqr.getNodeID(), (TupleSource)source);
    }

    private static AtomicRequestMessage createMoreRequest(AtomicRequestMessage original, ConnectorID connectorID) {
        AtomicRequestMessage aqr = new AtomicRequestMessage((RequestMessage)original);
        aqr.setCommand(original.getCommand());
        aqr.setConnectorBindingID(original.getConnectorBindingID());
        aqr.setType(2);
        aqr.setConnectorID(connectorID);
        aqr.setNodeID(original.getNodeID());
        aqr.setExecCount(original.getExecCount());
        return aqr;
    }

    private void notifyProcessorOfError(Object requestID, MetaMatrixException e2) {
        com.metamatrix.query.e.f processor = this.getProcessor(requestID);
        if (processor != null) {
            processor.q(e2);
        } else {
            String msg = DQPPlugin.Util.getString("DataTierManager.Could_not_deliver_response_for_{0}_as_the_QueryProcessor_could_not_be_obtained.", requestID);
            if (this.requestMgr.isRequestCancelled(requestID)) {
                LogManager.logDetail("DQP", msg);
            } else {
                LogManager.logWarning("DQP", msg);
            }
        }
    }

    private void deliverTupleSourceToProcessor(Object requestID, int nodeID, TupleSource ts) {
        com.metamatrix.query.e.f processor = this.getProcessor(requestID);
        if (processor != null) {
            if (LogManager.isMessageToBeRecorded("DQP", 6)) {
                LogManager.logTrace("DQP", new Object[]{"Delivering response for ", requestID, "to processor with nodeID =", new Integer(nodeID)});
            }
            processor.j(ts, nodeID);
        } else {
            String msg = DQPPlugin.Util.getString("DataTierManager.Could_not_deliver_response_for_{0}_as_the_QueryProcessor_could_not_be_obtained.", requestID);
            if (this.requestMgr.isRequestCancelled(requestID)) {
                LogManager.logDetail("DQP", msg);
            } else {
                this.requestMgr.removeConnectorInfo(requestID, nodeID);
                LogManager.logWarning("DQP", msg);
            }
        }
    }

    public Object lookupCodeValue(f context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, MetaMatrixComponentException {
        int existsCode = this.codeTableCache.cacheExists(codeTableName, returnElementName, keyElementName, context);
        if (existsCode == 0) {
            return this.codeTableCache.lookupValue(codeTableName, returnElementName, keyElementName, keyValue);
        }
        if (existsCode == 2) {
            this.registerCodeTableRequest(context, codeTableName, returnElementName, keyElementName);
        } else if (existsCode == 3) {
            String msg = DQPPlugin.Util.getString("DataTierManager.Unable_to_load_code_table_because_code_table_entries_exceeds_the_allowed_parameter_-_MaxCodeTables.");
            LogManager.logError("DQP", msg);
            throw new MetaMatrixComponentException("ERR.018.005.0099", DQPPlugin.Util.getString("ERR.018.005.0099"));
        }
        throw BlockedException.INSTANCE;
    }

    private void registerCodeTableRequest(f context, String codeTableName, String returnElementName, String keyElementName) throws MetaMatrixComponentException {
        RequestID requestID = (RequestID)context.getProcessorID();
        RequestMessage request = this.requestMgr.getRequest(requestID);
        ag query = null;
        String modelName = null;
        e metadata = null;
        try {
            metadata = this.metadataService.lookupMetadata(request.getVdbName(), request.getVdbVersion());
            query = new ag();
            s select = new s();
            select.kp((com.metamatrix.query.o.i.b)new a(keyElementName));
            select.kp((com.metamatrix.query.o.i.b)new a(returnElementName));
            query.jv(select);
            j from = new j();
            from.fx(new com.metamatrix.query.o.i.f(codeTableName));
            query.jm(from);
            b.l((l)query, metadata);
            com.metamatrix.query.o.i.f group = (com.metamatrix.query.o.i.f)query.jy().f0().get(0);
            Object modelID = metadata.getModelID(group.aq());
            modelName = metadata.getFullName(modelID);
        }
        catch (QueryMetadataException e2) {
            String msg = DQPPlugin.Util.getString("DataTierManager.Unable_to_get_metadata.");
            LogManager.logError("DQP", (Throwable)e2, msg);
            throw new ComponentNotAvailableException((Throwable)e2, msg);
        }
        catch (QueryResolverException e3) {
            String msg = DQPPlugin.Util.getString("DataTierManager.Unable_to_resolve_query.");
            LogManager.logError("DQP", (Throwable)e3, msg);
            throw new ComponentNotAvailableException((Throwable)e3, msg);
        }
        int codeTableNodeID = this.requestMgr.getCodeTableNodeID(requestID);
        this.codeTableCache.setRequestID(codeTableName, returnElementName, keyElementName, requestID, codeTableNodeID);
        this.registerRequest(context.getProcessorID(), (l)query, modelName, codeTableNodeID, 0);
    }

    private boolean isCodeTableLoadable(int lastRow) {
        return lastRow <= this.maxCodeTableRecords;
    }

    public void clearCodeTables() {
        this.codeTableCache.clearAll();
    }

    private void deliverXMLChunk(Object processorID, com.metamatrix.query.e.j.d id) throws MetaMatrixComponentException {
        BufferManager bufferMgr = this.bufferService.getBufferManager();
        try {
            TupleSourceID tsId = id.a();
            int rowCount = bufferMgr.getFinalRowCount(tsId);
            int currentRow = id.c();
            CharValueGlob glob = null;
            if (currentRow <= rowCount) {
                TupleBatch batch = bufferMgr.pinTupleBatch(tsId, currentRow, currentRow);
                List[] allTuples = batch.getAllTuples();
                if (allTuples != null && allTuples.length > 0) {
                    glob = new CharValueGlob((char[])allTuples[0].get(0), false);
                }
                bufferMgr.unpinTupleBatch(tsId, currentRow, currentRow);
                id.b();
            } else {
                glob = new CharValueGlob(new char[0], true);
            }
            com.metamatrix.query.e.f processor = this.getProcessor(processorID);
            processor.i((ValueID)id, (ValueGlob)glob);
        }
        catch (TupleSourceNotFoundException e2) {
            throw new MetaMatrixComponentException((Throwable)e2);
        }
        catch (MemoryNotAvailableException e3) {
            throw BlockedException.INSTANCE;
        }
    }

    public void registerLobRequest(Object processorID, ValueID id, int chunkSize) throws MetaMatrixComponentException {
        if (!(id instanceof com.metamatrix.query.e.j.d)) {
            ValueChunkConnection connection = new ValueChunkConnection(this, id, processorID);
            AtomicRequestMessage request = DataTierManager.createLobRequest(id, chunkSize, (RequestID)processorID, (ClientConnection)connection);
            ConnectorID connectorID = request.getConnectorID();
            this.dataService.executeRequest(request, connectorID, (MessageListener)connection);
            throw BlockedException.INSTANCE;
        }
        this.deliverXMLChunk(processorID, (com.metamatrix.query.e.j.d)id);
    }

    private static AtomicRequestMessage createLobRequest(ValueID valueId, int size, RequestID reqestId, ClientConnection clientConn) {
        AtomicRequestMessage aqr = new AtomicRequestMessage();
        aqr.setType(4);
        aqr.setNodeID(Integer.parseInt(valueId.getNodeID()));
        aqr.setConnectorID(new ConnectorID(valueId.getConnectorID()));
        aqr.setValueID(valueId);
        aqr.assignToClientConnection(clientConn);
        aqr.setUserParameters(clientConn);
        aqr.setRequestID(reqestId);
        aqr.setStartPosition(valueId.getStartPosition());
        aqr.setChunkSize(size);
        return aqr;
    }

    static /* synthetic */ com.metamatrix.query.e.f access$000(DataTierManager x0, Object x1) {
        return x0.getProcessor(x1);
    }
}

