/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Artifact;
import org.eclipse.uml2.Association;
import org.eclipse.uml2.AssociationClass;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.DataType;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.Operation;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.Parameter;
import org.eclipse.uml2.ParameterDirectionKind;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Signal;
import org.eclipse.uml2.StructuredClassifier;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.internal.operation.UML2Operations;
import org.eclipse.uml2.util.UML2Switch;

public final class TypeOperations
extends UML2Operations {
    public static final String copyright = "Copyright (c) IBM Corporation and others.";

    private TypeOperations() {
    }

    public static boolean conformsTo(Type type, Type other) {
        return false;
    }

    public static Association createAssociation(Type type1, boolean end1IsNavigable, AggregationKind end1Aggregation, String end1Name, int end1LowerBound, int end1UpperBound, Type type2, boolean end2IsNavigable, AggregationKind end2Aggregation, String end2Name, int end2LowerBound, int end2UpperBound) {
        TypeOperations.validateTypeAndBounds(type1, end1LowerBound, end1UpperBound);
        TypeOperations.validateTypeAndBounds(type2, end2LowerBound, end2UpperBound);
        Package package_ = type1.getNearestPackage();
        if (package_ == null) {
            throw new IllegalArgumentException(String.valueOf(type1));
        }
        if (end1IsNavigable && TypeOperations.getOwnedAttributes(type1) == null) {
            throw new IllegalArgumentException(String.valueOf(type1));
        }
        if (end1Aggregation == null) {
            throw new IllegalArgumentException(String.valueOf((Object)end1Aggregation));
        }
        if (end2IsNavigable && TypeOperations.getOwnedAttributes(type2) == null) {
            throw new IllegalArgumentException(String.valueOf(type2));
        }
        if (end2Aggregation == null) {
            throw new IllegalArgumentException(String.valueOf((Object)end2Aggregation));
        }
        Association association = (Association)package_.createOwnedMember(UML2Package.eINSTANCE.getAssociation());
        TypeOperations.createAssociationEnd(association, type1, end1IsNavigable, end1Aggregation, end1Name, end1LowerBound, end1UpperBound, type2);
        TypeOperations.createAssociationEnd(association, type2, end2IsNavigable, end2Aggregation, end2Name, end2LowerBound, end2UpperBound, type1);
        return association;
    }

    protected static Property createAssociationEnd(Association association, Type type, boolean isNavigable, AggregationKind aggregation, String name, int lowerBound, int upperBound, Type otherEndType) {
        Property associationEnd = TypeOperations.createOwnedProperty(isNavigable ? type : association, name, otherEndType, lowerBound, upperBound);
        if (isNavigable) {
            association.getMemberEnds().add((Object)associationEnd);
        }
        associationEnd.setAggregation(aggregation);
        return associationEnd;
    }

    protected static void validateTypeAndBounds(Type type, int lowerBound, int upperBound) {
        if (type == null) {
            throw new IllegalArgumentException(String.valueOf(type));
        }
        if (lowerBound < 0) {
            throw new IllegalArgumentException(String.valueOf(lowerBound));
        }
        if (-1 != upperBound && (upperBound == 0 || lowerBound > upperBound)) {
            throw new IllegalArgumentException(String.valueOf(upperBound));
        }
    }

    protected static Property createOwnedProperty(Type type, String name, Type propertyType, int lowerBound, int upperBound) {
        Property ownedProperty = (Property)new UML2Switch(){

            public Object caseArtifact(Artifact artifact) {
                return artifact.createOwnedAttribute(UML2Package.eINSTANCE.getProperty());
            }

            public Object caseAssociation(Association association) {
                return association.createOwnedEnd(UML2Package.eINSTANCE.getProperty());
            }

            public Object caseAssociationClass(AssociationClass associationClass) {
                return associationClass.createOwnedAttribute(UML2Package.eINSTANCE.getProperty());
            }

            public Object caseDataType(DataType dataType) {
                return dataType.createOwnedAttribute(UML2Package.eINSTANCE.getProperty());
            }

            public Object caseInterface(Interface interface_) {
                return interface_.createOwnedAttribute(UML2Package.eINSTANCE.getProperty());
            }

            public Object caseSignal(Signal signal) {
                return signal.createOwnedAttribute(UML2Package.eINSTANCE.getProperty());
            }

            public Object caseStructuredClassifier(StructuredClassifier structuredClassifier) {
                return structuredClassifier.createOwnedAttribute(UML2Package.eINSTANCE.getProperty());
            }
        }.doSwitch((EObject)type);
        ownedProperty.setName(name);
        ownedProperty.setType(propertyType);
        ownedProperty.setUpperBound(upperBound);
        ownedProperty.setLowerBound(lowerBound);
        return ownedProperty;
    }

    public static Property createOwnedAttribute(Type type, String name, Type attributeType, int lowerBound, int upperBound) {
        if (type == null || TypeOperations.getOwnedAttributes(type) == null) {
            throw new IllegalArgumentException(String.valueOf(type));
        }
        if (TypeOperations.isEmpty(name)) {
            throw new IllegalArgumentException(String.valueOf(name));
        }
        TypeOperations.validateTypeAndBounds(attributeType, lowerBound, upperBound);
        return TypeOperations.createOwnedProperty(type, name, attributeType, lowerBound, upperBound);
    }

    public static Operation createOwnedOperation(Type type, String name, Type returnType, String[] parameterNames, Type[] parameterTypes) {
        if (type == null || TypeOperations.getOwnedOperations(type) == null) {
            throw new IllegalArgumentException(String.valueOf(type));
        }
        if (TypeOperations.isEmpty(name)) {
            throw new IllegalArgumentException(String.valueOf(name));
        }
        if (parameterNames == null ? parameterTypes != null : parameterTypes == null || parameterNames.length != parameterTypes.length) {
            throw new IllegalArgumentException(String.valueOf(parameterTypes));
        }
        Operation ownedOperation = (Operation)new UML2Switch(){

            public Object caseArtifact(Artifact artifact) {
                return artifact.createOwnedOperation();
            }

            public Object caseClass(Class class_) {
                return class_.createOwnedOperation();
            }

            public Object caseDataType(DataType dataType) {
                return dataType.createOwnedOperation();
            }

            public Object caseInterface(Interface interface_) {
                return interface_.createOwnedOperation();
            }
        }.doSwitch((EObject)type);
        ownedOperation.setName(name);
        if (returnType != null) {
            Parameter returnResult = ownedOperation.createReturnResult();
            returnResult.setDirection(ParameterDirectionKind.RETURN_LITERAL);
            returnResult.setType(returnType);
        }
        if (parameterNames != null) {
            int i = 0;
            while (i < parameterNames.length) {
                Parameter ownedParameter = ownedOperation.createOwnedParameter();
                ownedParameter.setName(parameterNames[i]);
                ownedParameter.setType(parameterTypes[i]);
                ++i;
            }
        }
        return ownedOperation;
    }
}

