/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.provider;

import java.util.Iterator;
import java.util.List;
import org.apache.xerces.util.DOMUtil;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.provider.XSDComponentItemProvider;
import org.eclipse.xsd.provider.XSDEditPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDAnnotationItemProvider
extends XSDComponentItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public XSDAnnotationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    public Object getImage(Object object) {
        return XSDEditPlugin.getImage("full/obj16/XSDAnnotation");
    }

    public String getText(Object object) {
        XSDAnnotation xsdAnnotation = (XSDAnnotation)object;
        StringBuffer result = new StringBuffer();
        Iterator userInfos = xsdAnnotation.getUserInformation().iterator();
        while (userInfos.hasNext()) {
            Element userInfo = (Element)userInfos.next();
            String value = DOMUtil.getChildText((Node)userInfo);
            if (value == null) continue;
            result.append(value);
        }
        Iterator appInfos = xsdAnnotation.getApplicationInformation().iterator();
        while (appInfos.hasNext()) {
            Element appInfo = (Element)appInfos.next();
            String value = this.getAppInfoText(appInfo);
            if (value == null) continue;
            result.append(value);
        }
        String text = result.toString();
        if (text.length() > 50) {
            text = String.valueOf(text.substring(0, 50)) + XSDEditPlugin.getString("_UI_DotDotDot_label");
        }
        return text;
    }

    public String getAppInfoText(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        Node child = node.getFirstChild();
        str.append("<Application Information>");
        while (child != null) {
            short type = child.getNodeType();
            if (type == 1) {
                str.append("\n\t<");
                str.append(child.getNodeName());
                str.append(">");
                str.append(DOMUtil.getChildText((Node)child));
                str.append("</");
                str.append(child.getNodeName());
                str.append(">");
            }
            child = child.getNextSibling();
        }
        str.append("\n</Application Information>");
        return str.toString();
    }

    public void notifyChanged(Notification msg) {
        super.notifyChanged(msg);
    }
}

