/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Operation;
import org.eclipse.uml2.Parameter;
import org.eclipse.uml2.RedefinableElement;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Plugin;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class OperationOperations
extends UML2Operations {
    public static final String copyright = "Copyright (c) IBM Corporation and others.";
    static /* synthetic */ Class class$0;

    private OperationOperations() {
    }

    public static boolean validateTypeOfResult(Operation operation, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        EList returnResults = operation.getReturnResults();
        if (!OperationOperations.safeEquals(operation.getType(), 1 == returnResults.size() ? ((Parameter)returnResults.get(0)).getType() : null)) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 20, UML2Plugin.INSTANCE.getString("_UI_Operation_TypeOfResult_diagnostic", OperationOperations.getMessageSubstitutions(context, operation)), new Object[]{operation}));
            }
        }
        return result;
    }

    public static boolean isOrdered(Operation operation) {
        EList returnResults = operation.getReturnResults();
        return 1 == returnResults.size() ? ((Parameter)returnResults.get(0)).isOrdered() : false;
    }

    public static boolean isUnique(Operation operation) {
        EList returnResults = operation.getReturnResults();
        return 1 == returnResults.size() ? ((Parameter)returnResults.get(0)).isUnique() : true;
    }

    public static Classifier type(Operation operation) {
        EList returnResults = operation.getReturnResults();
        return 1 == returnResults.size() ? (Classifier)((Parameter)returnResults.get(0)).getType() : null;
    }

    public static boolean validateOnlyBodyForQuery(Operation operation, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (operation.getBodyCondition() != null && !operation.isQuery()) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 21, UML2Plugin.INSTANCE.getString("_UI_Operation_OnlyBodyForQuery_diagnostic", OperationOperations.getMessageSubstitutions(context, operation)), new Object[]{operation}));
            }
        }
        return result;
    }

    public static int lower(Operation operation) {
        EList returnResults = operation.getReturnResults();
        return 1 == returnResults.size() ? ((Parameter)returnResults.get(0)).lower() : 1;
    }

    public static boolean isConsistentWith(Operation operation, RedefinableElement redefinee) {
        if (redefinee.isRedefinitionContextValid(operation)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.uml2.Operation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isInstance(redefinee)) {
                Operation op = (Operation)redefinee;
                EList formalParameters = operation.getFormalParameters();
                int formalParametersSize = formalParameters.size();
                EList opFormalParameters = op.getFormalParameters();
                EList returnResults = operation.getReturnResults();
                int returnResultsSize = returnResults.size();
                EList opReturnResults = op.getReturnResults();
                if (formalParametersSize == opFormalParameters.size() && returnResultsSize == opReturnResults.size()) {
                    int i = 0;
                    while (i < formalParametersSize) {
                        Type opFormalParameterType = ((Parameter)opFormalParameters.get(i)).getType();
                        Type formalParameterType = ((Parameter)formalParameters.get(i)).getType();
                        if (opFormalParameterType == null ? formalParameterType != null : !opFormalParameterType.conformsTo(formalParameterType)) {
                            return false;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < returnResultsSize) {
                        Type opReturnResultType = ((Parameter)opReturnResults.get(i)).getType();
                        Type returnResultType = ((Parameter)returnResults.get(i)).getType();
                        if (opReturnResultType == null ? returnResultType != null : !opReturnResultType.conformsTo(returnResultType)) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static int upper(Operation operation) {
        EList returnResults = operation.getReturnResults();
        return 1 == returnResults.size() ? ((Parameter)returnResults.get(0)).upper() : 1;
    }
}

