/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.db2.DB2ImplBlob;
import com.metamatrix.jdbc.db2.DB2ImplClob;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDAColumn;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.jdbc.db2.drda.DRDAStatementRequest;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilTransliterator;
import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class DRDAResultSetRequest
extends DRDAStatementRequest {
    private static String footprint = "$Revision:   3.38.1.4  $";
    private boolean lastRowReturned;
    private boolean processedBaseDataForRow;
    public BaseColumns columnDescriptions;
    private int numRowsFetched;
    public boolean isStoredProcedureRS;
    int lastColumnProcessedForCurrentRow;
    int numCols;
    public DRDAByteOrderedDataReader SQLAM6LOBReader;
    DRDAByteOrderedDataReader originalReader;
    private byte[] dateBytes;
    StringBuffer sb;
    int[] intBuffer = null;
    byte[][] byteBuffer = new byte[4][];
    final int[] TheValue;
    final int[] TheNibbleValue;
    int decimalCharIndex;
    int exp;
    char[] decimalChars;
    final char zero = '0';
    final char period = '.';
    final char minus = '-';
    boolean isNegative;
    boolean useScientific;

    public DRDAResultSetRequest(DB2ImplConnection dB2ImplConnection, DRDACommunication dRDACommunication, DRDAByteOrderedDataReader dRDAByteOrderedDataReader, DRDAByteOrderedDataWriter dRDAByteOrderedDataWriter, DRDAPkgNamCsn dRDAPkgNamCsn) {
        super(dB2ImplConnection, dRDACommunication, dRDAByteOrderedDataReader, dRDAByteOrderedDataWriter, dRDAPkgNamCsn);
        this.byteBuffer[0] = new byte[13];
        this.byteBuffer[1] = new byte[9];
        this.byteBuffer[2] = new byte[6];
        this.byteBuffer[3] = new byte[3];
        this.TheValue = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, -1, -1, -1, -1, -1, -1, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, -1, -1, -1, -1, -1, -1, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, -1, -1, -1, -1, -1, -1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, -1, -1, -1, -1, -1, -1, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, -1, -1, -1, -1, -1, -1, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, -1, -1, -1, -1, -1, -1, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, -1, -1, -1, -1, -1, -1, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, -1, -1, -1, -1, -1, -1, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, -1, -1, -1, -1, -1, -1};
        this.TheNibbleValue = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2, 2, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, 3, 3, 3, 3, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4, 4, 4, 4, 4, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, 5, 5, 5, 5, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6, 6, 6, 6, 6, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7, 7, 7, 7, 7, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8, 8, 8, 8, 8, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9, 9, 9, 9, 9, 9};
        this.decimalCharIndex = 0;
        this.exp = 0;
        this.decimalChars = new char[34];
        this.zero = (char)48;
        this.period = (char)46;
        this.minus = (char)45;
        this.isNegative = false;
        this.useScientific = false;
        this.processedBaseDataForRow = false;
        this.decimalChars = new char[34];
        this.numCols = -1;
    }

    private boolean moreRowsToProcess(BaseWarnings baseWarnings) throws UtilException, SQLException {
        if ((long)this.reader.readPosition == this.queryDataEndPosition || this.reader.readPosition == 0) {
            if (!this.reader.atEndOfReply()) {
                this.processReply(baseWarnings);
                this.lastRowReturned = true;
                this.resultType = 1;
                return false;
            }
            if (!this.isCursorOpen) {
                return false;
            }
            this.continueQuery(baseWarnings);
            this.submitRequest();
            this.processReply(baseWarnings);
            if (!this.isCursorOpen) {
                return false;
            }
        }
        return true;
    }

    public void discardRemainingRows() throws SQLException {
        block3: {
            try {
                if (this.reader.readPosition != 0) {
                    this.reader.readAndDiscardBytes((int)this.queryDataEndPosition - this.reader.readPosition);
                }
            }
            catch (UtilException utilException) {
                if (utilException.getReason() == 1001) break block3;
                throw this.comm.exceptions.getException(utilException);
            }
        }
    }

    public boolean processCodePoint(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (n2) {
                case 8469: {
                    byte by = this.reader.readInt8();
                    break;
                }
                case 9243: {
                    if ((short)(n + 4) == -32760) {
                        n = this.reader.readInt32();
                    } else if ((short)(n + 4) == -32764) {
                        n = this.reader.queryDataLength;
                    }
                    this.queryDataLen = n;
                    this.queryDataEndPosition = this.reader.readPosition + n;
                    if (this.processMode != 1) {
                        if (this.processMode != 0) break;
                    }
                    return false;
                }
                default: {
                    return super.processCodePoint(n, n2, baseWarnings);
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
        return true;
    }

    public boolean getNextRow(BaseWarnings baseWarnings) throws SQLException {
        try {
            if (!this.moreRowsToProcess(baseWarnings)) {
                return false;
            }
            this.processedBaseDataForRow = false;
            if (this.numCols == -1) {
                this.numCols = this.columnDescriptions.count(0);
            }
            if (this.numRowsFetched > 0 && this.lastColumnProcessedForCurrentRow < this.numCols) {
                this.getColumnDataForRow(null, this.numCols, 10, this.implConn.warnings);
            }
            if (this.comm.SQLAMLevel >= 7 && this.hasLobCols) {
                int n = 1;
                while (n <= this.numCols) {
                    DRDAColumn dRDAColumn = (DRDAColumn)this.columnDescriptions.get(n);
                    if (this.numRowsFetched > 0 && (dRDAColumn.type == 2005 || dRDAColumn.type == 2004)) {
                        this.getColumnDataForRow(dRDAColumn, n, 20, this.implConn.warnings);
                        if (dRDAColumn.hasExtendedData && !dRDAColumn.readExtendedData) {
                            this.processEXTDTA(dRDAColumn, true);
                        }
                    }
                    ++n;
                }
            }
            if (!this.isCursorOpen || !this.moreData) {
                return false;
            }
            if (!this.moreRowsToProcess(baseWarnings)) {
                return false;
            }
            this.processSQLCA(baseWarnings);
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.hasWarnings && baseWarnings.get().getSQLState().equals("02000")) {
                return false;
            }
            if (!this.isCursorOpen || !this.moreData) {
                this.lastRowReturned = true;
                return false;
            }
            this.ensureBytes(1, baseWarnings);
            if (this.reader.readInt8() == 1) {
                // empty if block
            }
            this.lastColumnProcessedForCurrentRow = 0;
            ++this.numRowsFetched;
            this.lastRowReturned = false;
            return this.isCursorOpen || !this.reader.atEndOfReply();
        }
        catch (UtilException utilException) {
            if (utilException.getReason() != 1001) {
                throw this.comm.exceptions.getException(utilException);
            }
            this.lastRowReturned = true;
            this.resultType = 1;
            return false;
        }
    }

    public BaseData getColumnBaseDataObject(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        DRDAColumn dRDAColumn = (DRDAColumn)this.columnDescriptions.get(n);
        this.getColumnDataForRow(dRDAColumn, n, n2, baseWarnings);
        if (dRDAColumn.hasExtendedData && !dRDAColumn.readExtendedData) {
            if (!this.processedBaseDataForRow) {
                this.getColumnDataForRow(null, this.numCols, n2, baseWarnings);
                this.processedBaseDataForRow = true;
            }
            int n3 = 1;
            while (n3 <= n) {
                DRDAColumn dRDAColumn2 = (DRDAColumn)this.columnDescriptions.get(n3);
                if (dRDAColumn2.hasExtendedData && !dRDAColumn2.readExtendedData) {
                    this.processEXTDTA(dRDAColumn2, false);
                }
                ++n3;
            }
        }
        return dRDAColumn.baseDataObj;
    }

    /*
     * Unable to fully structure code
     */
    private void getColumnDataForRow(DRDAColumn var1_1, int var2_2, int var3_3, BaseWarnings var4_4) throws SQLException {
        try {
            try {
                if (0 < var2_2 && var2_2 <= this.lastColumnProcessedForCurrentRow) {
                    if (var1_1 != null && !var1_1.baseDataObj.isNull) {
                        switch (var1_1.baseDataObj.type) {
                            case 15: {
                                var1_1.baseDataObj.setData(15, var1_1.transliterator.decodeAsAsciiStream(new ByteArrayInputStream(var1_1.longDataBuffer, 0, var1_1.longDataBuffLen)));
                                break;
                            }
                            case 14: {
                                var1_1.baseDataObj.setData(14, new ByteArrayInputStream(var1_1.longDataBuffer, 0, var1_1.longDataBuffLen));
                                break;
                            }
                        }
                    }
                    var22_5 = null;
                    this.reader.readFromByteArray = false;
                    return;
                }
                var5_8 = var2_2 == 0 ? this.numCols : var2_2;
                var6_10 = this.lastColumnProcessedForCurrentRow + 1;
                while (var6_10 <= var5_8) {
                    block142: {
                        block141: {
                            var7_11 = null;
                            var7_11 = var6_10 == var2_2 && var1_1 != null ? var1_1 : (DRDAColumn)this.columnDescriptions.get(var6_10);
                            var8_12 = false;
                            if (var7_11.isNullable == 1) {
                                if (this.reader.length - this.reader.readPosition <= 1) {
                                    this.ensureBytes(1, var4_4);
                                }
                                var8_12 = this.reader.readUnsignedInt8() != 0;
                            }
                            if (var8_12) break block141;
                            block10 : switch (var7_11.type) {
                                case 2004: {
                                    if (var7_11.fdocaType == 25 || var7_11.fdocaType == 24) {
                                        var9_13 = new byte[4];
                                        this.reader.readBytes(var9_13, 0, 4);
                                        var10_29 = new DB2ImplBlob(var9_13, this.implConn);
                                        var7_11.baseDataObj.setData(19, var10_29);
                                        break;
                                    }
                                    if (this.comm.SQLAMLevel < 7 && !this.comm.allowsLobStreamingAtSQLAM6 || this.comm.SQLAMLevel >= 7 && !this.comm.allowsLobStreamingAtSQLAM7) {
                                        var9_14 = new Long(this.reader.readInt32());
                                        var7_11.baseDataObj.setData(5, var9_14);
                                        break;
                                    }
                                    var7_11.lobLength = this.reader.readInt32();
                                    var7_11.hasExtendedData = true;
                                    var7_11.readExtendedData = false;
                                    break;
                                }
                                case 1: {
                                    if (this.reader.length - this.reader.readPosition <= var7_11.fdocaLen) {
                                        this.ensureBytes(var7_11.fdocaLen, var4_4);
                                    }
                                    var7_11.baseDataObj.setData(10, this.reader.readEncodedString(var7_11.fdocaLen, var7_11.transliterator));
                                    break;
                                }
                                case 12: {
                                    if (this.reader.length - this.reader.readPosition <= 2) {
                                        this.ensureBytes(2, var4_4);
                                    }
                                    var9_15 = this.reader.readInt16();
                                    if (var7_11.isDoubleByteColumn) {
                                        var9_15 *= 2;
                                    }
                                    this.reader.readFromByteArray = false;
                                    if (this.reader.length - this.reader.readPosition <= var9_15) {
                                        this.ensureBytes(var9_15, var4_4);
                                    }
                                    var7_11.baseDataObj.setData(10, this.reader.readEncodedString(var9_15, var7_11.transliterator));
                                    break;
                                }
                                case -1: {
                                    if (this.reader.length - this.reader.readPosition <= 2) {
                                        this.ensureBytes(2, var4_4);
                                    }
                                    var9_16 = this.reader.readInt16();
                                    if (var7_11.isDoubleByteColumn) {
                                        var9_16 *= 2;
                                    }
                                    this.reader.readFromByteArray = false;
                                    if (this.reader.length - this.reader.readPosition <= var9_16) {
                                        this.ensureBytes(var9_16, var4_4);
                                    }
                                    if (var7_11.longDataBuffer == null) {
                                        var7_11.setLongDataBuffer();
                                    }
                                    this.reader.readBytes(var7_11.longDataBuffer, 0, var9_16);
                                    var7_11.longDataBuffLen = var9_16;
                                    if (var3_3 == 15) {
                                        var7_11.baseDataObj.setData(15, var7_11.transliterator.decodeAsAsciiStream(new ByteArrayInputStream(var7_11.longDataBuffer, 0, var9_16)));
                                        break;
                                    }
                                    var10_30 = this.reader.transliterator;
                                    this.reader.transliterator = var7_11.transliterator;
                                    var7_11.baseDataObj.setData(18, var7_11.transliterator.decodeAsReader(new ByteArrayInputStream(var7_11.longDataBuffer, 0, var9_16)));
                                    this.reader.transliterator = var10_30;
                                    break;
                                }
                                case 2005: {
                                    if (this.comm.enableFullSizeLobs) {
                                        if (var7_11.fdocaType == 27 || var7_11.fdocaType == 26) {
                                            var9_17 = new byte[4];
                                            this.reader.readBytes(var9_17, 0, 4);
                                            var10_31 = null;
                                            try {
                                                var10_31 = new DB2ImplClob(var9_17, this.implConn, var7_11.transliterator);
                                            }
                                            catch (Exception var11_39) {
                                                ++this.lastColumnProcessedForCurrentRow;
                                            }
                                            var7_11.baseDataObj.setData(20, var10_31);
                                            break;
                                        }
                                        if (this.comm.SQLAMLevel < 7 && !this.comm.allowsLobStreamingAtSQLAM6 || this.comm.SQLAMLevel >= 7 && !this.comm.allowsLobStreamingAtSQLAM7) {
                                            var9_18 = new Long(this.reader.readInt32());
                                            var7_11.baseDataObj.setData(5, var9_18);
                                            break;
                                        }
                                        var7_11.lobLength = this.reader.readInt32();
                                        var7_11.hasExtendedData = true;
                                        var7_11.readExtendedData = false;
                                        break;
                                    }
                                    if (this.reader.length - this.reader.readPosition <= 2) {
                                        this.ensureBytes(2, var4_4);
                                    }
                                    if (this.reader.length - this.reader.readPosition <= (var9_19 = this.reader.readInt16())) {
                                        this.ensureBytes(var9_19, var4_4);
                                    }
                                    this.reader.readBytes(var7_11.longDataBuffer, 0, var9_19);
                                    var10_32 = this.reader.transliterator;
                                    this.reader.transliterator = var7_11.transliterator;
                                    var7_11.implClobObj = new DB2ImplClob(var7_11.transliterator.decodeAsReader(new ByteArrayInputStream(var7_11.longDataBuffer, 0, var9_19)), this.comm.implConn);
                                    this.reader.transliterator = var10_32;
                                    var7_11.baseDataObj.setData(20, var7_11.implClobObj);
                                    break;
                                }
                                case -5: {
                                    if (this.reader.length - this.reader.readPosition <= 8) {
                                        this.ensureBytes(8, var4_4);
                                    }
                                    if (!this.comm.isServerBigEndianOS) {
                                        this.reader.interpretAsBigEndian = false;
                                    }
                                    var7_11.baseDataObj.setLong(this.reader.readInt64());
                                    break;
                                }
                                case 5: {
                                    if (this.reader.length - this.reader.readPosition <= 2) {
                                        this.ensureBytes(2, var4_4);
                                    }
                                    if (!this.comm.isServerBigEndianOS) {
                                        this.reader.interpretAsBigEndian = false;
                                    }
                                    var7_11.baseDataObj.setShort(this.reader.readInt16());
                                    break;
                                }
                                case 4: {
                                    if (this.reader.length - this.reader.readPosition <= 4) {
                                        this.ensureBytes(4, var4_4);
                                    }
                                    if (!this.comm.isServerBigEndianOS) {
                                        this.reader.interpretAsBigEndian = false;
                                    }
                                    var7_11.baseDataObj.setInteger(this.reader.readInt32());
                                    break;
                                }
                                case 6: 
                                case 8: {
                                    if (this.reader.length - this.reader.readPosition <= 8) {
                                        this.ensureBytes(8, var4_4);
                                    }
                                    if (!this.comm.isServerBigEndianOS) {
                                        this.reader.interpretAsBigEndian = false;
                                    }
                                    if (this.comm.serverOS == 3) {
                                        var9_20 = this.drdaUtil.ibm2IeeeDoubleFloat(this.reader.readInt64());
                                        var7_11.baseDataObj.setDouble(Double.longBitsToDouble(var9_20));
                                    } else {
                                        var7_11.baseDataObj.setDouble(this.reader.readIEEE64BitDouble());
                                    }
                                    if (this.comm.serverOS != 3) break;
                                    var7_11.isKey = false;
                                    this.columnDescriptions.resetCount();
                                    break;
                                }
                                case 7: {
                                    if (this.reader.length - this.reader.readPosition <= 4) {
                                        this.ensureBytes(4, var4_4);
                                    }
                                    if (!this.comm.isServerBigEndianOS) {
                                        this.reader.interpretAsBigEndian = false;
                                    }
                                    if (this.comm.serverOS == 3) {
                                        var9_21 = this.drdaUtil.ibm2IeeeSingleFloat(this.reader.readInt32());
                                        var7_11.baseDataObj.setFloat(Float.intBitsToFloat(var9_21));
                                        break;
                                    }
                                    var7_11.baseDataObj.setFloat(this.reader.readIEEE32BitFloat());
                                    break;
                                }
                                case 3: {
                                    var9_22 = var7_11.fdocaLen;
                                    var10_33 = var7_11.scale;
                                    if (this.reader.length - this.reader.readPosition <= var9_22) {
                                        this.ensureBytes(var9_22, var4_4);
                                    }
                                    var11_40 = new byte[var9_22];
                                    if (!this.comm.isServerBigEndianOS) {
                                        this.reader.interpretAsBigEndian = false;
                                    }
                                    this.reader.readBytes(var11_40, 0, var9_22);
                                    switch (var3_3) {
                                        case 10: {
                                            this.decimalCharIndex = 0;
                                            this.isNegative = false;
                                            this.useScientific = false;
                                            if ((var11_40[var9_22 - 1] & 15) == 13) {
                                                this.decimalChars[this.decimalCharIndex++] = 45;
                                                this.isNegative = true;
                                            }
                                            var12_43 = var9_22 * 2 - 1;
                                            this.exp = var10_33 - var12_43 + 1;
                                            if (this.exp > 6) {
                                                this.useScientific = true;
                                                var10_33 = 1;
                                            }
                                            if (!this.useScientific) {
                                                if (var10_33 >= var12_43) {
                                                    this.decimalChars[this.decimalCharIndex++] = 48;
                                                    this.decimalChars[this.decimalCharIndex++] = 46;
                                                    while (var10_33 > var12_43) {
                                                        this.decimalChars[this.decimalCharIndex++] = 48;
                                                        --var10_33;
                                                    }
                                                    var10_33 = 0;
                                                } else {
                                                    var10_33 = var12_43 - var10_33;
                                                    if (this.isNegative) {
                                                        ++var10_33;
                                                    }
                                                }
                                            }
                                            var13_44 = var9_22 - 1;
                                            if (var10_33 != 0) {
                                                var14_45 = 1;
                                                var15_46 = 0;
                                                while (var15_46 < var13_44) {
                                                    this.decimalChars[this.decimalCharIndex++] = (char)((var11_40[var15_46] >>> 4 & 15) + 48);
                                                    if (this.decimalChars[this.decimalCharIndex - 1] == '0' && var10_33 != 0 && var10_33 != this.decimalCharIndex && var14_45 != 0) {
                                                        --this.decimalCharIndex;
                                                        --var10_33;
                                                    } else {
                                                        var14_45 = 0;
                                                    }
                                                    if (var10_33 == this.decimalCharIndex) {
                                                        this.decimalChars[this.decimalCharIndex++] = 46;
                                                        var10_33 = 0;
                                                    }
                                                    this.decimalChars[this.decimalCharIndex++] = (char)((var11_40[var15_46] & 15) + 48);
                                                    if (this.decimalChars[this.decimalCharIndex - 1] == '0' && var10_33 != 0 && var10_33 != this.decimalCharIndex && var14_45 != 0) {
                                                        --this.decimalCharIndex;
                                                        --var10_33;
                                                    } else {
                                                        var14_45 = 0;
                                                    }
                                                    if (var10_33 == this.decimalCharIndex) {
                                                        this.decimalChars[this.decimalCharIndex++] = 46;
                                                        var10_33 = 0;
                                                    }
                                                    ++var15_46;
                                                }
                                            } else {
                                                var14_45 = 0;
                                                while (var14_45 < var13_44) {
                                                    this.decimalChars[this.decimalCharIndex++] = (char)((var11_40[var14_45] >>> 4 & 15) + 48);
                                                    this.decimalChars[this.decimalCharIndex++] = (char)((var11_40[var14_45] & 15) + 48);
                                                    ++var14_45;
                                                }
                                            }
                                            this.decimalChars[this.decimalCharIndex++] = (char)((var11_40[var13_44] >>> 4 & 15) + 48);
                                            if (this.useScientific) {
                                                this.decimalChars[this.decimalCharIndex++] = 69;
                                                this.decimalChars[this.decimalCharIndex++] = 45;
                                                if (this.exp > 9) {
                                                    this.decimalChars[this.decimalCharIndex++] = (char)(this.exp / 10 + 48);
                                                    this.decimalChars[this.decimalCharIndex++] = (char)((this.exp >>> 16) + 48);
                                                } else {
                                                    this.decimalChars[this.decimalCharIndex++] = (char)(this.exp + 48);
                                                }
                                            }
                                            var7_11.baseDataObj.setString(new String(this.decimalChars, 0, this.decimalCharIndex));
                                            break block10;
                                        }
                                    }
                                    if (this.intBuffer == null) {
                                        this.intBuffer = new int[4];
                                    }
                                    this.intBuffer[0] = 0;
                                    this.intBuffer[1] = 0;
                                    this.intBuffer[2] = 0;
                                    this.intBuffer[3] = 0;
                                    var12_43 = 3;
                                    var13_44 = 0;
                                    var14_45 = 0;
                                    var15_46 = 0;
                                    var16_47 = var11_40.length;
                                    var17_48 = var11_40.length;
                                    var18_49 = 100;
                                    var15_46 = 0;
                                    while (var15_46 < var16_47) {
                                        if (var15_46 == var16_47 - 1) {
                                            var18_49 = 10;
                                            this.intBuffer[3] = this.intBuffer[3] * 10 + this.TheNibbleValue[var11_40[var15_46] & 255];
                                        } else {
                                            this.intBuffer[3] = this.intBuffer[3] * 100 + this.TheValue[var11_40[var15_46] & 255];
                                        }
                                        var13_44 = this.intBuffer[3] >> 24;
                                        this.intBuffer[3] = this.intBuffer[3] & 0xFFFFFF;
                                        if (var12_43 != 3) ** GOTO lbl266
                                        if (var13_44 == 0) ** GOTO lbl279
                                        var12_43 = 2;
lbl266:
                                        // 2 sources

                                        this.intBuffer[2] = this.intBuffer[2] * var18_49 + var13_44;
                                        var13_44 = this.intBuffer[2] >> 24;
                                        this.intBuffer[2] = this.intBuffer[2] & 0xFFFFFF;
                                        if (var12_43 != 2) ** GOTO lbl272
                                        if (var13_44 == 0) ** GOTO lbl279
                                        var12_43 = 1;
lbl272:
                                        // 2 sources

                                        this.intBuffer[1] = this.intBuffer[1] * var18_49 + var13_44;
                                        var13_44 = this.intBuffer[1] >> 24;
                                        this.intBuffer[1] = this.intBuffer[1] & 0xFFFFFF;
                                        if (var12_43 != 1) ** GOTO lbl278
                                        if (var13_44 == 0) ** GOTO lbl279
                                        var12_43 = 0;
lbl278:
                                        // 2 sources

                                        this.intBuffer[0] = this.intBuffer[0] * var18_49 + var13_44;
lbl279:
                                        // 4 sources

                                        ++var15_46;
                                    }
                                    var15_46 = var12_43;
                                    if (var15_46 == 0) {
                                        this.byteBuffer[0][0] = (byte)(this.intBuffer[0] >> 24);
                                        var14_45 = 1;
                                    } else {
                                        var14_45 = 0;
                                    }
                                    while (var15_46 < 4) {
                                        this.byteBuffer[var12_43][var14_45] = (byte)(this.intBuffer[var15_46] >> 16);
                                        this.byteBuffer[var12_43][var14_45 + 1] = (byte)(this.intBuffer[var15_46] >> 8);
                                        this.byteBuffer[var12_43][var14_45 + 2] = (byte)this.intBuffer[var15_46];
                                        ++var15_46;
                                        var14_45 += 3;
                                    }
                                    var19_50 = new BigInteger((var11_40[var17_48 - 1] & 15) == 13 ? -1 : 1, this.byteBuffer[var12_43]);
                                    var20_51 = new BigDecimal(var19_50, var7_11.scale);
                                    var7_11.baseDataObj.setData(8, var20_51);
                                    break;
                                }
                                case 2: {
                                    var9_23 = var7_11.fdocaLen;
                                    if (this.reader.length - this.reader.readPosition <= var9_23) {
                                        this.ensureBytes(var9_23, var4_4);
                                    }
                                    if (!this.comm.isServerBigEndianOS) {
                                        this.reader.interpretAsBigEndian = false;
                                    }
                                    var10_34 = new StringBuffer(this.reader.readEncodedString(var9_23 - 1, var7_11.transliterator));
                                    var11_41 = this.reader.readInt8();
                                    if ((var11_41 >>> 4 & 15) == 13) {
                                        var10_34.insert(0, '-');
                                    }
                                    var10_34.append(String.valueOf(var11_41 & 15));
                                    var7_11.baseDataObj.setData(8, new BigDecimal(new BigInteger(var10_34.toString()), var7_11.scale));
                                    break;
                                }
                                case 91: {
                                    if (this.reader.length - this.reader.readPosition <= var7_11.fdocaLen) {
                                        this.ensureBytes(var7_11.fdocaLen, var4_4);
                                    }
                                    var9_24 = null;
                                    if (!this.isStoredProcedureRS) ** GOTO lbl335
                                    var10_35 = this.reader.readEncodedString(var7_11.fdocaLen, this.comm.SingleByteServerTransliterator);
                                    if (var10_35.charAt(4) != '-' && var10_35.charAt(7) != '-') {
                                        var11_42 = new StringBuffer(10);
                                        var11_42.append(var10_35.substring(6));
                                        var11_42.append('-');
                                        var11_42.append(var10_35.substring(0, 2));
                                        var11_42.append('-');
                                        var11_42.append(var10_35.substring(3, 5));
                                        var9_24 = var11_42.toString();
                                    } else {
                                        var9_24 = var10_35;
                                    }
                                    ** GOTO lbl353
lbl335:
                                    // 1 sources

                                    if (var7_11.transliterator == null) ** GOTO lbl352
                                    if (this.dateBytes == null) {
                                        this.dateBytes = new byte[var7_11.fdocaLen];
                                    } else if (this.dateBytes.length != var7_11.fdocaLen) {
                                        this.dateBytes = new byte[var7_11.fdocaLen];
                                    }
                                    this.reader.readBytes(this.dateBytes, 0, var7_11.fdocaLen);
                                    try {
                                        var9_24 = var7_11.transliterator.decode(this.dateBytes, 0, var7_11.fdocaLen);
                                        if (var9_24.charAt(4) != '-') {
                                            var9_24 = this.comm.transliteratorPool.getTransliteratorForCodePage("500").decode(this.dateBytes, 0, var7_11.fdocaLen);
                                        }
                                        ** GOTO lbl353
                                    }
                                    catch (Exception var10_36) {
                                        var9_24 = this.comm.transliteratorPool.getTransliteratorForCodePage("500").decode(this.dateBytes, 0, var7_11.fdocaLen);
                                    }
                                    ** GOTO lbl353
lbl352:
                                    // 1 sources

                                    var9_24 = this.reader.readEncodedString(var7_11.fdocaLen, this.comm.SingleByteServerTransliterator);
lbl353:
                                    // 6 sources

                                    var7_11.baseDataObj.setNativeString(var9_24, 201);
                                    break;
                                }
                                case 92: {
                                    if (this.reader.length - this.reader.readPosition <= var7_11.fdocaLen) {
                                        this.ensureBytes(var7_11.fdocaLen, var4_4);
                                    }
                                    var9_25 = null;
                                    if (var7_11.transliterator != null) {
                                        if (this.dateBytes == null) {
                                            this.dateBytes = new byte[var7_11.fdocaLen];
                                        } else if (this.dateBytes.length != var7_11.fdocaLen) {
                                            this.dateBytes = new byte[var7_11.fdocaLen];
                                        }
                                        this.reader.readBytes(this.dateBytes, 0, var7_11.fdocaLen);
                                        try {
                                            var9_25 = new StringBuffer(var7_11.transliterator.decode(this.dateBytes, 0, var7_11.fdocaLen));
                                            if (var9_25.charAt(2) != '.' && var9_25.charAt(2) != ':') {
                                                var9_25 = new StringBuffer(this.comm.transliteratorPool.getTransliteratorForCodePage("500").decode(this.dateBytes, 0, var7_11.fdocaLen));
                                            }
                                            var9_25.setCharAt(2, ':');
                                            var9_25.setCharAt(5, ':');
                                            var7_11.baseDataObj.setNativeString(var9_25.toString(), 202);
                                        }
                                        catch (Exception var10_37) {
                                            var9_25 = new StringBuffer(this.comm.transliteratorPool.getTransliteratorForCodePage("500").decode(this.dateBytes, 0, var7_11.fdocaLen));
                                            var9_25.setCharAt(2, ':');
                                            var9_25.setCharAt(5, ':');
                                            var7_11.baseDataObj.setNativeString(var9_25.toString(), 202);
                                        }
                                        break;
                                    }
                                    var9_25 = new StringBuffer(this.reader.readEncodedString(var7_11.fdocaLen, this.comm.SingleByteServerTransliterator));
                                    var9_25.setCharAt(2, ':');
                                    var9_25.setCharAt(5, ':');
                                    var7_11.baseDataObj.setNativeString(var9_25.toString(), 202);
                                    break;
                                }
                                case 93: {
                                    if (this.reader.length - this.reader.readPosition <= var7_11.fdocaLen) {
                                        this.ensureBytes(var7_11.fdocaLen, var4_4);
                                    }
                                    var9_26 = null;
                                    if (var7_11.transliterator != null) {
                                        if (this.dateBytes == null) {
                                            this.dateBytes = new byte[var7_11.fdocaLen];
                                        } else if (this.dateBytes.length != var7_11.fdocaLen) {
                                            this.dateBytes = new byte[var7_11.fdocaLen];
                                        }
                                        this.reader.readBytes(this.dateBytes, 0, var7_11.fdocaLen);
                                        try {
                                            var9_26 = new StringBuffer(var7_11.transliterator.decode(this.dateBytes, 0, var7_11.fdocaLen));
                                            if (var9_26.charAt(13) != '.') {
                                                var9_26 = new StringBuffer(this.comm.transliteratorPool.getTransliteratorForCodePage("500").decode(this.dateBytes, 0, var7_11.fdocaLen));
                                            }
                                            var9_26.setCharAt(10, ' ');
                                            var9_26.setCharAt(13, ':');
                                            var9_26.setCharAt(16, ':');
                                            var7_11.baseDataObj.setNativeString(var9_26.toString(), 203);
                                        }
                                        catch (Exception var10_38) {
                                            var9_26 = new StringBuffer(this.comm.transliteratorPool.getTransliteratorForCodePage("500").decode(this.dateBytes, 0, var7_11.fdocaLen));
                                            var9_26.setCharAt(10, ' ');
                                            var9_26.setCharAt(13, ':');
                                            var9_26.setCharAt(16, ':');
                                            var7_11.baseDataObj.setNativeString(var9_26.toString(), 203);
                                        }
                                        break;
                                    }
                                    var9_26 = new StringBuffer(this.reader.readEncodedString(var7_11.fdocaLen, this.comm.SingleByteServerTransliterator));
                                    var9_26.setCharAt(10, ' ');
                                    var9_26.setCharAt(13, ':');
                                    var9_26.setCharAt(16, ':');
                                    var7_11.baseDataObj.setNativeString(var9_26.toString(), 203);
                                    break;
                                }
                                case -2: {
                                    if (this.reader.length - this.reader.readPosition <= var7_11.fdocaLen) {
                                        this.ensureBytes(var7_11.fdocaLen, var4_4);
                                    }
                                    var9_27 = new byte[var7_11.fdocaLen];
                                    this.reader.readBytes(var9_27, 0, var7_11.fdocaLen);
                                    if (this.implConn.charSetFor65535 != null && this.implConn.charSetFor65535 != "") {
                                        var7_11.baseDataObj.setString(var7_11.transliterator.decode(var9_27, 0, var9_27.length));
                                        break;
                                    }
                                    var7_11.baseDataObj.setData(2, var9_27);
                                    break;
                                }
                                case -4: 
                                case -3: {
                                    if (this.reader.length - this.reader.readPosition <= 2) {
                                        this.ensureBytes(2, var4_4);
                                    }
                                    if (this.reader.length - this.reader.readPosition <= (var9_28 = this.reader.readInt16())) {
                                        this.ensureBytes(var9_28, var4_4);
                                    }
                                    if (var7_11.longDataBuffer == null) {
                                        var7_11.setLongDataBuffer();
                                    }
                                    this.reader.readBytes(var7_11.longDataBuffer, 0, var9_28);
                                    var7_11.longDataBuffLen = var9_28;
                                    if (this.implConn.charSetFor65535 != null && this.implConn.charSetFor65535 != "") {
                                        var7_11.baseDataObj.setString(var7_11.transliterator.decode(var7_11.longDataBuffer, 0, var9_28));
                                    } else {
                                        var7_11.baseDataObj.setData(14, new ByteArrayInputStream(var7_11.longDataBuffer, 0, var9_28));
                                    }
                                    if (this.comm.serverOS != 3) break;
                                    var7_11.isKey = false;
                                    this.columnDescriptions.resetCount();
                                }
                            }
                            var7_11.baseDataType = var7_11.baseDataObj.type;
                            this.reader.interpretAsBigEndian = true;
                            break block142;
                        }
                        switch (var7_11.type) {
                            case 91: {
                                var7_11.baseDataObj.setData(201, null);
                                break;
                            }
                            case 92: {
                                var7_11.baseDataObj.setData(202, null);
                                break;
                            }
                            case 93: {
                                var7_11.baseDataObj.setData(203, null);
                                break;
                            }
                            default: {
                                var7_11.baseDataObj.setData(var7_11.baseDataType, null);
                            }
                        }
                    }
                    this.reader.readFromByteArray = false;
                    ++this.lastColumnProcessedForCurrentRow;
                    ++var6_10;
                }
            }
            catch (UtilException var5_9) {
                throw this.comm.exceptions.getException(var5_9);
            }
        }
        catch (Throwable var21_52) {
            var22_7 = null;
            this.reader.readFromByteArray = false;
            throw var21_52;
        }
        var22_6 = null;
        this.reader.readFromByteArray = false;
    }

    public void processEXTDTA(DRDAColumn dRDAColumn, boolean bl) throws SQLException {
        try {
            int n = dRDAColumn.lobLength;
            boolean bl2 = false;
            if (n != 0) {
                if (this.comm.allowsLobStreamingAtSQLAM6) {
                    if (this.SQLAM6LOBReader == null) {
                        this.SQLAM6LOBReader = this.comm.createReader();
                        this.SQLAM6LOBReader.interpretAsBigEndian = true;
                    }
                    this.originalReader = this.reader;
                    if (this.queryDataEndPosition == (long)this.reader.readPosition && this.reader.length - this.reader.readPosition > 4 && this.reader.peekByte(2) == 20 && this.reader.peekByte(3) == 108) {
                        this.originalReader = this.reader;
                    } else {
                        this.reader = this.SQLAM6LOBReader;
                    }
                }
                if (this.reader.length - this.reader.readPosition == 0) {
                    this.continueQuery(this.implConn.warnings);
                    this.submitRequest();
                }
                int n2 = 0;
                short s = this.reader.readInt16();
                if (s == -32760) {
                    this.reader.readAndDiscardBytes(2);
                    n2 = this.reader.readInt32();
                } else {
                    this.reader.readAndDiscardBytes(2);
                    n2 = s - 4;
                }
                if (dRDAColumn.isNullable == 1 && this.comm.SQLAMLevel >= 7) {
                    bl2 = this.reader.readUnsignedInt8() == 255;
                    --n2;
                }
                if (bl) {
                    this.reader.readAndDiscardBytes(n2);
                } else {
                    long l = 0L;
                    if (!bl2) {
                        if (dRDAColumn.type == 2005) {
                            int n3 = 0;
                            char[] cArray = new char[8192];
                            UtilTransliterator utilTransliterator = this.reader.transliterator;
                            this.reader.transliterator = dRDAColumn.transliterator;
                            Reader reader = this.reader.getReader(n2);
                            DB2ImplClob dB2ImplClob = new DB2ImplClob(this.implConn, new UtilPagedTempBuffer(), dRDAColumn.transliterator);
                            while (n3 != -1) {
                                n3 = reader.read(cArray, 0, 8192);
                                if (n3 == -1) continue;
                                l += (long)dB2ImplClob.clobData.write(l, this.drdaUtil.UCS2CharsToBytes(cArray, n3));
                            }
                            dRDAColumn.baseDataObj.setData(20, dB2ImplClob);
                            dRDAColumn.baseDataType = dRDAColumn.baseDataObj.type;
                            this.reader.transliterator = utilTransliterator;
                        } else {
                            int n4 = 0;
                            byte[] byArray = new byte[16384];
                            DB2ImplBlob dB2ImplBlob = new DB2ImplBlob(n, this.implConn, new UtilPagedTempBuffer());
                            while (n2 > 0) {
                                n4 = this.reader.readBytes(byArray, 0, Math.min(16384, n2));
                                l += (long)dB2ImplBlob.blobData.write(l, byArray, 0, n4);
                                n2 -= n4;
                            }
                            dRDAColumn.baseDataObj.setData(19, dB2ImplBlob);
                            dRDAColumn.baseDataType = dRDAColumn.baseDataObj.type;
                        }
                    } else if (dRDAColumn.type == 2005) {
                        dRDAColumn.baseDataObj.setData(20, new DB2ImplClob(this.implConn, new UtilPagedTempBuffer(), dRDAColumn.transliterator));
                    } else {
                        dRDAColumn.baseDataObj.setData(19, new DB2ImplBlob(0L, this.implConn, new UtilPagedTempBuffer()));
                    }
                }
            } else if (dRDAColumn.type == 2005) {
                dRDAColumn.baseDataObj.setData(20, new DB2ImplClob(this.implConn, new UtilPagedTempBuffer(), dRDAColumn.transliterator));
            } else {
                dRDAColumn.baseDataObj.setData(19, new DB2ImplBlob(0L, this.implConn, new UtilPagedTempBuffer()));
            }
            if (this.comm.allowsLobStreamingAtSQLAM6 && n != 0) {
                this.reader = this.originalReader;
            }
            dRDAColumn.readExtendedData = true;
        }
        catch (Exception exception) {
            throw this.comm.exceptions.getException(exception);
        }
    }

    public void continueQuery(BaseWarnings baseWarnings) throws SQLException {
        try {
            int n;
            int n2;
            if (!this.isCursorOpen) {
                return;
            }
            this.continuingQuery = true;
            int n3 = 1;
            if (this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                int n4 = n3;
                n3 = (short)(n3 + 1);
                n2 = this.writer.writePacketHeader((short)1, (short)64, n4);
                n = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(9);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6145);
                this.writer.writeInt32(-1);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6403);
                this.writer.writeInt32(0);
                this.writer.writeCodePointLength(n);
                this.writer.writePacketLength(n2);
            }
            n2 = 0;
            n2 = this.useOUTOVRlob && this.numRowsFetched == 0 ? this.writer.writePacketHeader((short)1, (short)80, n3) : this.writer.writePacketHeader((short)1, (short)0, n3);
            n = this.writer.writeCodePoint((short)8198);
            if (this.isStoredProcedure) {
                this.writer.writeSP_PKGNAMCSN(this.packageConsistencyToken);
            } else {
                this.writer.writePKGNAMCSN(this.packageConsistencyToken);
            }
            this.writer.writeInt16(8);
            this.writer.writeInt16(8468);
            if (this.comm.SQLAMLevel < 7) {
                this.writer.writeInt32(Short.MAX_VALUE);
            } else {
                this.writer.writeInt32(0x200000);
                this.writer.writeInt16(this.packageConsistencyToken.queryInstanceId.length + 4);
                this.writer.writeInt16(8539);
                this.writer.writeBytes(this.packageConsistencyToken.queryInstanceId);
            }
            this.writer.writeInt16(6);
            this.writer.writeInt16(8513);
            this.writer.writeInt16(0);
            this.writer.writeCodePointLength(n);
            this.writer.writePacketLength(n2);
            if (this.useOUTOVRlob && this.numRowsFetched == 0) {
                int n5 = this.writer.writePacketHeader((short)3, (short)0, n3);
                int n6 = this.writer.writeCodePoint((short)9237);
                this.writeOUTOVRdesc();
                this.writer.writeCodePointLength(n6);
                this.writer.writeCodePointLength(n5);
            }
        }
        catch (Exception exception) {
            try {
                this.writer.empty();
            }
            catch (UtilException utilException) {
                // empty catch block
            }
            if (exception instanceof UtilException) {
                throw this.comm.exceptions.getException(exception);
            }
            throw (SQLException)exception;
        }
    }

    public final void writeOUTOVRdesc() throws UtilException {
        int n = this.numCols;
        this.writer.writeInt8(n * 3 + 3);
        this.writer.writeInt8(118);
        this.writer.writeInt8(208);
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 1;
            DRDAColumn dRDAColumn = (DRDAColumn)this.columnDescriptions.get(n3);
            if (dRDAColumn.type == 2004) {
                if (dRDAColumn.isNullable == 1) {
                    this.writer.writeInt8(25);
                    this.writer.writeInt16(4);
                    dRDAColumn.fdocaType = 25;
                } else {
                    this.writer.writeInt8(24);
                    this.writer.writeInt16(4);
                    dRDAColumn.fdocaType = 24;
                }
            } else if (dRDAColumn.type == 2005) {
                if (dRDAColumn.isNullable == 1) {
                    this.writer.writeInt8(27);
                    this.writer.writeInt16(4);
                    dRDAColumn.fdocaType = 27;
                } else {
                    this.writer.writeInt8(26);
                    this.writer.writeInt16(4);
                    dRDAColumn.fdocaType = 26;
                }
            } else {
                this.writer.writeFillerBytes((byte)0, 3);
            }
            ++n2;
        }
        this.writer.writeInt8(9);
        this.writer.writeInt8(113);
        this.writer.writeInt8(224);
        this.writer.writeInt8(84);
        this.writer.writeInt8(0);
        this.writer.writeInt8(1);
        this.writer.writeInt8(208);
        this.writer.writeInt8(0);
        this.writer.writeInt8(1);
        this.writer.writeInt8(6);
        this.writer.writeInt8(113);
        this.writer.writeInt8(240);
        this.writer.writeInt8(224);
        this.writer.writeInt8(0);
        this.writer.writeInt8(0);
    }
}

