/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseEscape;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseSQLTreeNode;
import java.sql.SQLException;

public class BaseJoinEscape
extends BaseEscape {
    private BaseSQLTreeNode ojRoot;
    private BaseSQLTreeNode ojCursor;
    private BaseSQLTreeNode trCursor;
    private int joinOperator;
    public static final int NODE_RIGHT_OUTER_JOIN_OP = 1036;
    public static final int NODE_FULL_OUTER_JOIN_OP = 1037;
    public static final int NODE_LEFT_OUTER_JOIN_OP = 1035;
    private BaseSQLTreeNode currentSearchConditionNode = null;
    private BaseSQLTreeNode currentTableNameNode = null;
    private boolean firstOuterJoinRequest = true;
    private boolean firstTableReferenceRequest = true;

    public BaseJoinEscape(BaseSQLTreeNode baseSQLTreeNode, BaseExceptions baseExceptions) {
        super(baseSQLTreeNode, baseExceptions);
        this.ojRoot = baseSQLTreeNode.leftMostChild();
        this.ojRoot = this.ojRoot.getRightSibling();
        this.ojRoot = this.ojRoot.getRightSibling();
    }

    public boolean moveToNextOuterJoin() {
        boolean bl = true;
        if (this.firstOuterJoinRequest) {
            this.ojCursor = this.ojRoot;
            while (this.isJoinOperator(this.ojCursor.type)) {
                this.ojCursor = this.ojCursor.leftMostChild();
                this.ojCursor = this.ojCursor.getRightSibling();
                this.ojCursor = this.ojCursor.getRightSibling();
            }
            this.firstOuterJoinRequest = false;
        }
        this.ojCursor = this.ojCursor.getRightSibling();
        if (this.ojCursor.value.equals("}")) {
            bl = false;
        }
        if (bl) {
            this.currentSearchConditionNode = this.ojCursor.getRightSibling();
            this.ojCursor = this.ojCursor.getParent();
            this.joinOperator = this.ojCursor.type;
        } else {
            this.currentSearchConditionNode = null;
            this.joinOperator = 1016;
            bl = false;
        }
        return bl;
    }

    public boolean moveToNextTableReference() {
        boolean bl = true;
        if (this.firstTableReferenceRequest) {
            this.trCursor = this.ojRoot;
            this.joinOperator = this.trCursor.type;
            this.currentTableNameNode = this.trCursor = this.trCursor.leftMostChild();
            this.firstTableReferenceRequest = false;
        } else {
            this.trCursor = this.trCursor.getRightSibling();
            this.trCursor = this.trCursor.getRightSibling();
            if (this.trCursor.type == 1023) {
                this.currentTableNameNode = this.trCursor;
            } else if (this.isJoinOperator(this.trCursor.type)) {
                this.currentTableNameNode = this.trCursor = this.trCursor.leftMostChild();
            } else if (this.trCursor.type == 1038) {
                bl = false;
                this.currentTableNameNode = null;
            }
        }
        return bl;
    }

    private boolean isJoinOperator(int n) {
        return 1035 == n || 1036 == n || 1037 == n;
    }

    public String getCurrentSearchCondition() {
        if (this.currentSearchConditionNode == null) {
            return null;
        }
        try {
            return this.generator.generateSQL(this.currentSearchConditionNode, false, this.exceptions);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public int getCurrentJoinOperator() {
        return this.joinOperator;
    }

    public String getCurrentTableName() {
        BaseSQLTreeNode baseSQLTreeNode = this.currentTableNameNode.leftMostChild();
        try {
            return this.generator.generateSQL(baseSQLTreeNode, false, this.exceptions);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public String getCurrentCorrelationName() {
        BaseSQLTreeNode baseSQLTreeNode = this.currentTableNameNode.leftMostChild();
        if ((baseSQLTreeNode = baseSQLTreeNode.getRightSibling()) == null) {
            return null;
        }
        try {
            return this.generator.generateSQL(baseSQLTreeNode, false, this.exceptions);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }
}

