/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.metamatrix.jdbcspy.SpyLogger;
import java.io.IOException;
import java.io.Reader;

class SpyReader
extends Reader {
    private Reader realReader;
    private SpyLogger spyLogger;
    private int id;
    private static int Id = 0;

    SpyReader(Reader reader, SpyLogger spyLogger) {
        this.realReader = reader;
        this.spyLogger = spyLogger;
        this.id = ++Id;
    }

    public final void close() throws IOException {
        this.spyLogger.println("\n" + this + ".close()");
        this.spyLogger.enter();
        try {
            this.realReader.close();
        }
        catch (IOException iOException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + iOException.toString() + "***");
            iOException.fillInStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + runtimeException.toString() + "***");
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + error.toString() + "***");
            error.fillInStackTrace();
            throw error;
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            this.spyLogger.sqlException(throwable);
            throw new Error();
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final boolean ready() throws IOException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".ready()");
        this.spyLogger.enter();
        try {
            bl = this.realReader.ready();
        }
        catch (IOException iOException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + iOException.toString() + "***");
            iOException.fillInStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + runtimeException.toString() + "***");
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + error.toString() + "***");
            error.fillInStackTrace();
            throw error;
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            this.spyLogger.sqlException(throwable);
            throw new Error();
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final void mark(int n) throws IOException {
        this.spyLogger.println("\n" + this + ".mark(int readAheadLimit)");
        this.spyLogger.println("readAheadLimit = " + n);
        this.spyLogger.enter();
        try {
            this.realReader.mark(n);
        }
        catch (IOException iOException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + iOException.toString() + "***");
            iOException.fillInStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + runtimeException.toString() + "***");
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + error.toString() + "***");
            error.fillInStackTrace();
            throw error;
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            this.spyLogger.sqlException(throwable);
            throw new Error();
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final boolean markSupported() {
        this.spyLogger.println("\n" + this + ".markSupported()");
        this.spyLogger.enter();
        boolean bl = this.realReader.markSupported();
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final int read() throws IOException {
        int n;
        if (this.spyLogger.logSingleRead) {
            this.spyLogger.println("\n" + this + ".read()");
        }
        this.spyLogger.enter();
        try {
            n = this.realReader.read();
        }
        catch (IOException iOException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + iOException.toString() + "***");
            iOException.fillInStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + runtimeException.toString() + "***");
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + error.toString() + "***");
            error.fillInStackTrace();
            throw error;
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            this.spyLogger.sqlException(throwable);
            throw new Error();
        }
        this.spyLogger.leave();
        if (this.spyLogger.logSingleRead) {
            this.spyLogger.println("OK (" + n + ")");
        }
        return n;
    }

    public final int read(char[] cArray) throws IOException {
        int n;
        this.spyLogger.println("\n" + this + ".read(char[] cbuf)");
        if (cArray != null) {
            this.spyLogger.println("cbuf.length = " + cArray.length);
        } else {
            this.spyLogger.println("cbuf = null");
        }
        this.spyLogger.enter();
        try {
            n = this.realReader.read(cArray);
        }
        catch (IOException iOException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + iOException.toString() + "***");
            iOException.fillInStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + runtimeException.toString() + "***");
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + error.toString() + "***");
            error.fillInStackTrace();
            throw error;
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            this.spyLogger.sqlException(throwable);
            throw new Error();
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        this.spyLogger.println("\n" + this + ".read(char[] cbuf, int off, int len)");
        if (cArray != null) {
            this.spyLogger.println("cbuf.length = " + cArray.length);
        } else {
            this.spyLogger.println("cbuf = null");
        }
        this.spyLogger.println("off = " + n);
        this.spyLogger.println("len = " + n2);
        this.spyLogger.enter();
        try {
            n3 = this.realReader.read(cArray, n, n2);
        }
        catch (IOException iOException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + iOException.toString() + "***");
            iOException.fillInStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + runtimeException.toString() + "***");
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + error.toString() + "***");
            error.fillInStackTrace();
            throw error;
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            this.spyLogger.sqlException(throwable);
            throw new Error();
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n3 + ")");
        return n3;
    }

    public final void reset() throws IOException {
        this.spyLogger.println("\n" + this + ".reset()");
        this.spyLogger.enter();
        try {
            this.realReader.reset();
        }
        catch (IOException iOException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + iOException.toString() + "***");
            iOException.fillInStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + runtimeException.toString() + "***");
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + error.toString() + "***");
            error.fillInStackTrace();
            throw error;
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            this.spyLogger.sqlException(throwable);
            throw new Error();
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final long skip(long l) throws IOException {
        long l2;
        this.spyLogger.println("\n" + this + ".skip(long n)");
        this.spyLogger.println("n = " + l);
        this.spyLogger.enter();
        try {
            l2 = this.realReader.skip(l);
        }
        catch (IOException iOException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + iOException.toString() + "***");
            iOException.fillInStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + runtimeException.toString() + "***");
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + error.toString() + "***");
            error.fillInStackTrace();
            throw error;
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            this.spyLogger.sqlException(throwable);
            throw new Error();
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + l2 + ")");
        return l2;
    }

    public final String toString() {
        return "Reader[" + this.id + "]";
    }
}

