/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerInstance;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.core.log.FileLogWriter;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.log.Logger;
import com.metamatrix.jdbc.BaseDriver;
import com.metamatrix.jdbc.DriverManagerLogger;
import com.metamatrix.jdbc.JDBCLogger;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMCallableStatement;
import com.metamatrix.jdbc.MMDatabaseMetaData;
import com.metamatrix.jdbc.MMPreparedStatement;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.api.Connection;
import com.metamatrix.jdbc.api.DatabaseMetaData;
import com.metamatrix.jdbc.util.TransactionHelper;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionEventListener;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public abstract class MMConnection
implements Connection {
    private static final String DEFAULT_APP_NAME = "JDBC";
    private ServerConnection serverConn;
    private long requestIDGenerator;
    private String url;
    protected Properties propInfo;
    private int logLevel = 0;
    private FileLogWriter logWriter;
    private Logger logger;
    private String applicationName;
    private boolean closed = false;
    private boolean autoCommitFlag = true;
    private Collection statements = null;
    private UserTransaction transaction = null;
    private DatabaseMetaData dbmm = null;
    private ServerInstance serverInstance;
    private Xid transactionXid;
    private boolean readOnly = false;

    MMConnection(ServerConnection serverConn, Properties info, String url) {
        String defaultFetchSize;
        this.url = url;
        this.serverConn = serverConn;
        String overrideProp = info.getProperty("txnAutoWrap");
        if (overrideProp == null || overrideProp.trim().length() == 0) {
            info.put("txnAutoWrap", "OPTIMISTIC");
        }
        this.applicationName = info.getProperty("ApplicationName");
        if (this.applicationName == null) {
            this.applicationName = DEFAULT_APP_NAME;
        }
        if ((defaultFetchSize = info.getProperty("fetchSize")) != null) {
            info.put("fetchSize", defaultFetchSize);
        } else {
            info.put("fetchSize", "2000");
        }
        String partialResultsMode = info.getProperty("partialResultsMode");
        if (partialResultsMode != null) {
            info.put("partialResultsMode", partialResultsMode);
        } else {
            info.put("partialResultsMode", "FALSE");
        }
        String resultSetCacheMode = info.getProperty("resultSetCacheMode");
        if (resultSetCacheMode != null) {
            info.put("resultSetCacheMode", resultSetCacheMode);
        } else {
            info.put("resultSetCacheMode", "TRUE");
        }
        String allowDblQuotes = info.getProperty("allowDoubleQuotedVariable");
        if (allowDblQuotes != null) {
            info.put("allowDoubleQuotedVariable", allowDblQuotes);
        } else {
            info.put("allowDoubleQuotedVariable", Boolean.FALSE.toString());
        }
        String logFile = info.getProperty("logFile");
        this.logLevel = MMConnection.readLoggingLevel(info, this.logLevel);
        if (logFile != null && this.logLevel > 0) {
            this.logWriter = new FileLogWriter(new File(logFile));
            this.logger = new JDBCLogger(this.logLevel, (LogListener)this.logWriter, Integer.parseInt(info.getProperty("connectionID")));
        } else {
            this.logger = new DriverManagerLogger(this.logLevel, DriverManager.getLogWriter());
        }
        if (this.logLevel >= 3) {
            AOP.enableProxies();
            AOP.enableTracing();
        } else {
            AOP.disableTracing();
        }
        String logMsg = JDBCPlugin.Util.getString("MMConnection.Session_success");
        this.logger.log(4, logMsg);
        if (this.logLevel >= 1) {
            this.logConnectionProperties(url, info);
        }
        this.propInfo = info;
        this.statements = Collections.synchronizedList(new ArrayList());
    }

    private void logConnectionProperties(String connUrl, Properties info) {
        StringBuffer modifiedUrl = new StringBuffer();
        if (connUrl != null) {
            int startIndex = connUrl.indexOf("password=");
            if (startIndex != -1) {
                modifiedUrl.append(connUrl.substring(0, startIndex));
                modifiedUrl.append("password=***");
                int endIndex = connUrl.indexOf(";", startIndex + 9);
                if (endIndex != -1) {
                    modifiedUrl.append(";").append(connUrl.substring(endIndex));
                }
            }
            this.logger.log(4, "Connection Url=" + modifiedUrl);
        }
        if (info != null) {
            Enumeration<Object> enumeration = info.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Object anObj = info.get(key);
                if ("password".equalsIgnoreCase(key) || "clientToken".equalsIgnoreCase(key)) continue;
                this.logger.log(4, key + "=" + anObj);
            }
        }
    }

    public static int readLoggingLevel(Properties info, int defaultValue) {
        String loggingLevel = info.getProperty("logLevel");
        if (loggingLevel != null) {
            return Integer.parseInt(loggingLevel);
        }
        return defaultValue;
    }

    public static boolean isLoggingOn(Properties info) {
        int logLevel = MMConnection.readLoggingLevel(info, 0);
        return logLevel > 0;
    }

    String getUrl() {
        return this.url;
    }

    public Logger getLogger() {
        return this.logger;
    }

    String getConnectionId() {
        if (this.propInfo != null) {
            return this.propInfo.getProperty("connectionID");
        }
        return "0";
    }

    long currentRequestId() {
        return this.requestIDGenerator;
    }

    synchronized long nextRequestID() {
        return this.requestIDGenerator++;
    }

    public void clearWarnings() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() throws SQLException {
        SQLException firstException = null;
        if (this.closed) {
            return;
        }
        try {
            try {
                block15: {
                    block16: {
                        try {
                            try {
                                this.closeStatements();
                            }
                            catch (SQLException se) {
                                firstException = se;
                                Object var4_3 = null;
                                if (this.serverConn != null) {
                                    this.serverConn.shutdown();
                                }
                                if (firstException != null) {
                                    throw firstException;
                                }
                                break block15;
                            }
                            Object var4_2 = null;
                            if (this.serverConn == null) break block16;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            if (this.serverConn != null) {
                                this.serverConn.shutdown();
                            }
                            if (firstException == null) throw throwable;
                            throw firstException;
                        }
                        this.serverConn.shutdown();
                    }
                    if (firstException != null) {
                        throw firstException;
                    }
                }
                Object var6_12 = null;
                this.serverConn = null;
            }
            catch (SQLException se) {
                String logMsg2 = JDBCPlugin.Util.getString("MMConnection.Err_connection_close", (Object)se.getMessage());
                this.logger.log(2, (Throwable)se, logMsg2);
                throw MMSQLException.create(se, logMsg2);
            }
            catch (CommunicationException e2) {
                String logMsg3 = JDBCPlugin.Util.getString("MMConnection.Err_connection_close", (Object)e2.getMessage());
                this.logger.log(2, (Throwable)e2, logMsg3);
                String msg = JDBCPlugin.Util.getString("MMConnection.Err_closing_conn");
                throw MMSQLException.create(e2, msg);
            }
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            this.serverConn = null;
            String logMsg = JDBCPlugin.Util.getString("MMConnection.Connection_close_success");
            this.logger.log(4, logMsg);
            this.closed = true;
            if (this.logWriter == null) throw throwable;
            this.logWriter.shutdown();
            this.logWriter = null;
            throw throwable;
        }
        String logMsg = JDBCPlugin.Util.getString("MMConnection.Connection_close_success");
        this.logger.log(4, logMsg);
        this.closed = true;
        if (this.logWriter == null) return;
        this.logWriter.shutdown();
        this.logWriter = null;
    }

    private void closeStatements() throws SQLException {
        try {
            ArrayList statementsSafe = new ArrayList(this.statements);
            Iterator statementIter = statementsSafe.iterator();
            while (statementIter.hasNext()) {
                Statement statement = (Statement)statementIter.next();
                statement.close();
            }
        }
        catch (SQLException e2) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Err_closing_stmts");
            throw MMSQLException.create(e2, msg);
        }
        finally {
            this.statements = null;
        }
    }

    void closeStatement(Statement statement) {
        this.statements.remove(statement);
    }

    public void commit() throws SQLException {
        this.checkConnection();
        try {
            if (this.transaction != null) {
                this.transaction.commit();
                String logMsg = JDBCPlugin.Util.getString("MMConnection.Commit_success");
                this.logger.log(4, logMsg);
            }
        }
        catch (Exception e2) {
            String logMsg = JDBCPlugin.Util.getString("MMConnection.Commit_failed", (Object)e2.getMessage());
            this.logger.log(2, (Throwable)e2, logMsg);
            String msg = JDBCPlugin.Util.getString("MMConnection.Err_committing");
            throw MMSQLException.create(e2, msg);
        }
        finally {
            this.transaction = null;
            this.serverInstance = null;
        }
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        MMStatement newStatement = MMStatement.newInstance((MMConnection)this, (int)resultSetType, (int)resultSetConcurrency);
        this.statements.add(newStatement);
        return newStatement;
    }

    private void validateResultSetType(int resultSetType) throws MMSQLException {
        if (resultSetType == 1005) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Scrollable_type_not_supported", (Object)"ResultSet.TYPE_SCROLL_SENSITIVE");
            throw new MMSQLException(msg);
        }
    }

    private void validateResultSetConcurrency(int resultSetConcurrency) throws MMSQLException {
        if (resultSetConcurrency == 1008) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Concurrency_type_not_supported", (Object)"ResultSet.CONCUR_UPDATABLE");
            throw new MMSQLException(msg);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkConnection();
        return this.autoCommitFlag;
    }

    public String getCatalog() throws SQLException {
        this.checkConnection();
        return null;
    }

    ServerConnection getConnection() throws SQLException {
        this.checkConnection();
        return this.serverConn;
    }

    String getSchema() throws SQLException {
        this.checkConnection();
        return (String)this.propInfo.get("VirtualDatabaseName");
    }

    String getVDBVersion() throws SQLException {
        this.checkConnection();
        if (this.propInfo.get("VirtualDatabaseVersion") != null) {
            return (String)this.propInfo.get("VirtualDatabaseVersion");
        }
        return null;
    }

    String getUserName() throws SQLException {
        this.checkConnection();
        return (String)this.propInfo.get("user");
    }

    String getPassword() throws SQLException {
        this.checkConnection();
        return (String)this.propInfo.get("password");
    }

    protected java.sql.DatabaseMetaData getMetaData(BaseDriver driver) throws SQLException {
        this.checkConnection();
        if (this.dbmm == null) {
            this.dbmm = MMDatabaseMetaData.newInstance((BaseDriver)driver, (MMConnection)this);
        }
        return this.dbmm;
    }

    abstract String getDatabaseName();

    public int getHoldability() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    UserTransaction getTransaction(Statement statementObj) throws SQLException {
        this.checkConnection();
        return this.transaction;
    }

    public int getTransactionIsolation() throws SQLException {
        return 8;
    }

    public Map getTypeMap() throws SQLException {
        this.checkConnection();
        return new HashMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection();
        return null;
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.closed;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1004, 1007);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        this.validateSQL(sql);
        CallableStatement newStatement = (CallableStatement)((Object)MMCallableStatement.newInstance(this, sql, resultSetType, resultSetConcurrency));
        this.statements.add(newStatement);
        return newStatement;
    }

    private void validateSQL(String sql) throws MMSQLException {
        if (sql == null) {
            String msg = JDBCPlugin.Util.getString("MMConnection.SQL_cannot_be_null");
            throw new MMSQLException(msg);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndex) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        this.validateSQL(sql);
        MMPreparedStatement newStatement = MMPreparedStatement.newInstance(this, sql, resultSetType, resultSetConcurrency);
        this.statements.add(newStatement);
        return newStatement;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void rollback() throws SQLException {
        this.checkConnection();
        try {
            if (this.transaction != null) {
                this.transaction.rollback();
                String logMsg = JDBCPlugin.Util.getString("MMConnection.Rollback_success");
                this.logger.log(4, logMsg);
            }
        }
        catch (Exception e2) {
            String logMsg = JDBCPlugin.Util.getString("MMConnection.Rollback_failed", (Object)e2.getMessage());
            this.logger.log(2, (Throwable)e2, logMsg);
            String msg = JDBCPlugin.Util.getString("MMConnection.Err_rollingback", (Object)e2.getMessage());
            throw MMSQLException.create(e2, msg);
        }
        finally {
            this.transaction = null;
            this.serverInstance = null;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkConnection();
        if (autoCommit) {
            this.commit();
        }
        this.autoCommitFlag = autoCommit;
    }

    boolean allowExplicitTransactions() {
        String autoWrapMode = this.propInfo.getProperty("txnAutoWrap");
        return autoWrapMode == null || !autoWrapMode.equalsIgnoreCase("OFF");
    }

    public void setCatalog(String catalog) throws SQLException {
    }

    public void setHoldability(int holdability) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.readOnly == readOnly) {
            return;
        }
        if (!this.getAutoCommit() || this.transaction != null || this.getTransactionXid() != null) {
            String logMsg = JDBCPlugin.Util.getString("MMStatement.Invalid_During_Transaction", (Object)("setReadOnly(" + readOnly + ")"));
            MMSQLException e2 = new MMSQLException(logMsg);
            this.logger.log(2, (Throwable)e2, logMsg);
            throw e2;
        }
        this.readOnly = readOnly;
    }

    void setTransaction(UserTransaction tx) {
        this.transaction = tx;
        String logMsg = JDBCPlugin.Util.getString("MMStatement.Starting_transaction", (Object)tx);
        this.logger.log(4, logMsg);
    }

    void checkConnection() throws SQLException {
        if (this.closed) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Cant_use_closed_connection");
            MMSQLException e2 = new MMSQLException(msg);
            this.logger.log(2, (Throwable)e2, msg);
            throw e2;
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
    }

    public void setTypeMap(Map map) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void releaseSavepoint(Savepoint sp) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void rollback(Savepoint sp) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public XAResource getXAResource() throws SQLException {
        return null;
    }

    public void addConnectionEventListener(ConnectionEventListener arg0) {
    }

    public void removeConnectionEventListener(ConnectionEventListener arg0) {
    }

    protected ServerInstance getServerInstance() throws CommunicationException, SQLException {
        if (this.serverInstance != null) {
            return this.serverInstance;
        }
        return this.serverConn.selectServerInstance(null);
    }

    protected void setServerInstance(ServerInstance si) {
        this.serverInstance = si;
    }

    protected void commitTransaction(Xid arg0, boolean arg1) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        ServerInstance si = this.serverInstance;
        TransactionHelper.commitTransaction((ServerConnection)this.serverConn, (ServerInstance)si, (Xid)arg0, (boolean)arg1);
    }

    protected void endTransaction(Xid arg0, int arg1) throws SQLException {
        this.checkConnection();
        TransactionHelper.endTransaction((ServerConnection)this.serverConn, (ServerInstance)this.serverInstance, (Xid)arg0, (int)arg1);
    }

    protected void forgetTransaction(Xid arg0) throws SQLException {
        this.checkConnection();
        TransactionHelper.forgetTransaction((ServerConnection)this.serverConn, (ServerInstance)this.serverInstance, (Xid)arg0);
    }

    protected int prepareTransaction(Xid arg0) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        ServerInstance si = this.serverInstance;
        return TransactionHelper.prepareTransaction((ServerConnection)this.serverConn, (ServerInstance)si, (Xid)arg0);
    }

    protected Xid[] recoverTransaction(int arg0) throws SQLException {
        this.checkConnection();
        return TransactionHelper.recoverTransaction((ServerConnection)this.serverConn, (ServerInstance)this.serverInstance, (int)arg0);
    }

    protected void rollbackTransaction(Xid arg0) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        ServerInstance si = this.serverInstance;
        TransactionHelper.rollbackTransaction((ServerConnection)this.serverConn, (ServerInstance)si, (Xid)arg0);
    }

    protected void startTransaction(Xid arg0, int arg1) throws SQLException {
        this.checkConnection();
        TransactionHelper.startTransaction((ServerConnection)this.serverConn, (ServerInstance)this.serverInstance, (Xid)arg0, (int)arg1);
        this.transactionXid = arg0;
    }

    protected void setTransactionTimeout(int seconds) throws SQLException {
        this.checkConnection();
        TransactionHelper.setTransactionTimeout((ServerConnection)this.serverConn, (ServerInstance)this.serverInstance, (int)seconds);
    }

    protected void createServerInstance() {
        try {
            this.serverInstance = this.serverConn.selectServerInstance(null);
        }
        catch (CommunicationException e2) {
            MMSQLException.create(e2);
        }
    }

    protected Xid getTransactionXid() {
        return this.transactionXid;
    }
}

