/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net;

import com.metamatrix.sequelink.net.NetMessage;
import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.security.ByteSwapCipher;
import com.metamatrix.sequelink.security.ByteSwapKey;
import com.metamatrix.sequelink.security.SLCrypto;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class NetCrypto {
    private static final String PROVIDER = "IAIK";
    private static final String DES_ALG = "DES/CBC/PKCS5Padding";
    private static final String DES_KEYFAC = "DES";
    private static final String TRIPLEDES_ALG = "3DES/CBC/PKCS5Padding";
    private static final String TRIPLEDES_KEYFAC = "3DES";
    public static final int ALG_DES = 0;
    public static final int ALG_3DES = 1;
    public static final int ALG_BYTESWAP = 2;
    private static final byte[] DESKEY = new byte[]{71, 41, 61, 41, -65, -115, -55, -65};
    private static final byte[] TRIPLEDESKEY = new byte[]{-35, 71, -15, 109, 1, -85, 41, -41, -15, -115, -55, 97, 71, 41, -85, 41, 51, 71, 41, 23, 31, -55, 31, 41};
    private Cipher encryptionCipher;
    private Cipher decryptionCipher;
    private ByteSwapCipher byteSwapEncryptionCipher;
    private ByteSwapCipher byteSwapDecryptionCipher;
    int algorithm;

    NetCrypto(int n2, byte[] byArray) throws NetworkException {
        this.algorithm = n2;
        if (n2 != 2) {
            SLCrypto.init(false);
        }
        switch (n2) {
            case 0: {
                try {
                    DESKeySpec dESKeySpec = new DESKeySpec(DESKEY);
                    SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(DES_KEYFAC, PROVIDER);
                    SecretKey secretKey = secretKeyFactory.generateSecret(dESKeySpec);
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
                    this.encryptionCipher = Cipher.getInstance(DES_ALG, PROVIDER);
                    this.encryptionCipher.init(1, (Key)secretKey, ivParameterSpec);
                    this.decryptionCipher = Cipher.getInstance(DES_ALG, PROVIDER);
                    this.decryptionCipher.init(2, (Key)secretKey, ivParameterSpec);
                    break;
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    throw NetMessage.Message.getNetworkException(7876, PROVIDER);
                }
                catch (NoSuchPaddingException noSuchPaddingException) {
                    throw NetMessage.Message.getNetworkException(7878, noSuchPaddingException.getMessage());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw NetMessage.Message.getNetworkException(7877, noSuchAlgorithmException.getMessage());
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    throw NetMessage.Message.getNetworkException(7874, invalidKeySpecException.getMessage());
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw NetMessage.Message.getNetworkException(7874, invalidKeyException.getMessage());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw NetMessage.Message.getNetworkException(7879, invalidAlgorithmParameterException.getMessage());
                }
            }
            case 1: {
                try {
                    DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(TRIPLEDESKEY);
                    SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(TRIPLEDES_KEYFAC, PROVIDER);
                    SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
                    this.encryptionCipher = Cipher.getInstance(TRIPLEDES_ALG, PROVIDER);
                    this.encryptionCipher.init(1, (Key)secretKey, ivParameterSpec);
                    this.decryptionCipher = Cipher.getInstance(TRIPLEDES_ALG, PROVIDER);
                    this.decryptionCipher.init(2, (Key)secretKey, ivParameterSpec);
                    break;
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    throw NetMessage.Message.getNetworkException(7876, PROVIDER);
                }
                catch (NoSuchPaddingException noSuchPaddingException) {
                    throw NetMessage.Message.getNetworkException(7878, noSuchPaddingException.getMessage());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw NetMessage.Message.getNetworkException(7877, noSuchAlgorithmException.getMessage());
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    throw NetMessage.Message.getNetworkException(7875, invalidKeySpecException.getMessage());
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw NetMessage.Message.getNetworkException(7875, invalidKeyException.getMessage());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw NetMessage.Message.getNetworkException(7879, invalidAlgorithmParameterException.getMessage());
                }
            }
            case 2: {
                try {
                    ByteSwapKey byteSwapKey = new ByteSwapKey(byArray);
                    this.byteSwapEncryptionCipher = new ByteSwapCipher(1, byteSwapKey);
                    this.byteSwapDecryptionCipher = new ByteSwapCipher(2, byteSwapKey);
                    break;
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw NetMessage.Message.getNetworkException(7880, invalidKeyException.getMessage());
                }
            }
            default: {
                throw NetMessage.Message.getNetworkException(7871);
            }
        }
    }

    int getEncryptionOutputSize(int n2) throws NetworkException {
        try {
            if (this.algorithm == 2) {
                return this.byteSwapEncryptionCipher.getOutputSize(n2);
            }
            return this.encryptionCipher.getOutputSize(n2);
        }
        catch (IllegalStateException illegalStateException) {
            throw NetMessage.Message.getNetworkException(7872, illegalStateException.getMessage());
        }
    }

    int getDecryptionOutputSize(int n2) throws NetworkException {
        try {
            if (this.algorithm == 2) {
                return this.byteSwapDecryptionCipher.getOutputSize(n2);
            }
            return this.decryptionCipher.getOutputSize(n2);
        }
        catch (IllegalStateException illegalStateException) {
            throw NetMessage.Message.getNetworkException(7873, illegalStateException.getMessage());
        }
    }

    int encrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws NetworkException {
        try {
            if (this.algorithm == 2) {
                return this.byteSwapEncryptionCipher.doFinal(byArray, n2, n3, byArray2, n4);
            }
            return this.encryptionCipher.doFinal(byArray, n2, n3, byArray2, n4);
        }
        catch (Exception exception) {
            throw NetMessage.Message.getNetworkException(7872, exception.getMessage());
        }
    }

    int decrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws NetworkException {
        try {
            if (this.algorithm == 2) {
                return this.byteSwapDecryptionCipher.doFinal(byArray, n2, n3, byArray2, n4);
            }
            return this.decryptionCipher.doFinal(byArray, n2, n3, byArray2, n4);
        }
        catch (Exception exception) {
            throw NetMessage.Message.getNetworkException(7873, exception.getMessage());
        }
    }
}

