/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcsnoop;

import com.metamatrix.jdbcsnoop.SnoopSocket;
import java.io.IOException;
import java.io.InputStream;

class SnoopInputStream
extends InputStream {
    private static String footprint = "$Revision:   1.1.1.0  $";
    private SnoopSocket snoopSocket;
    private int lineBytesWritten = 0;
    private byte[] singleByte = new byte[1];

    SnoopInputStream(SnoopSocket snoopSocket) {
        this.snoopSocket = snoopSocket;
    }

    public int read() throws IOException {
        this.snoopSocket.attemptingRead();
        int n = this.snoopSocket.realInputStream.read();
        if (n == -1) {
            return -1;
        }
        this.snoopSocket.logBytes(2, this.singleByte, 0, 1);
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.snoopSocket.attemptingRead();
        int n3 = this.snoopSocket.realInputStream.read(byArray, n, n2);
        if (n3 == -1) {
            return -1;
        }
        this.snoopSocket.logBytes(2, byArray, n, n3);
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int available() throws IOException {
        return this.snoopSocket.realInputStream.available();
    }

    public void mark(int n) {
        this.snoopSocket.realInputStream.mark(n);
    }

    public boolean markSupported() {
        return this.snoopSocket.realInputStream.markSupported();
    }

    public long skip(long l) throws IOException {
        return this.snoopSocket.realInputStream.skip(l);
    }

    public void close() throws IOException {
        this.snoopSocket.realInputStream.close();
    }
}

