/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.tools;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class LogInputOutputStream
extends InputStream
implements DataOutput,
DataInput {
    DataOutputStream log;
    DataOutputStream dos;
    DataInputStream dis;
    boolean writing = false;
    int logPos = 0;
    String[] H = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public LogInputOutputStream(String string, DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
        this.dis = dataInputStream;
        this.dos = dataOutputStream;
        try {
            this.log = new DataOutputStream(new FileOutputStream(string));
            this.log.writeBytes("SLX Client Log");
            this.writeNewLine();
            this.writeNewLine();
            this.log.flush();
        }
        catch (IOException iOException) {
            System.out.println("Error opening log file");
        }
    }

    public int available() throws IOException {
        return this.dis.available();
    }

    public void close() throws IOException {
        this.dos.close();
        this.dis.close();
    }

    public void mark(int n) {
        throw new Error("Log does not implement this method");
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public int read(byte[] byArray) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void reset() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public long skip(long l) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkWriting();
        this.logBuffer(byArray, n, n2);
        this.dos.write(byArray, n, n2);
    }

    public byte readByte() throws IOException {
        this.checkReading();
        byte by = this.dis.readByte();
        byte[] byArray = new byte[]{by};
        this.logBuffer(byArray, 0, 1);
        return by;
    }

    public int readInt() throws IOException {
        this.checkReading();
        int n = this.dis.readInt();
        byte[] byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        this.logBuffer(byArray, 0, 4);
        return n;
    }

    public long readLong() throws IOException {
        this.checkReading();
        long l = this.dis.readLong();
        byte[] byArray = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48 & 0xFFL), (byte)(l >>> 40 & 0xFFL), (byte)(l >>> 32 & 0xFFL), (byte)(l >>> 24 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l & 0xFFL)};
        this.logBuffer(byArray, 0, 8);
        return l;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.checkReading();
        this.dis.readFully(byArray, n, n2);
        this.logBuffer(byArray, n, n2);
    }

    private void checkWriting() {
        if (!this.writing) {
            this.writing = true;
            this.logPos = 0;
            if (this.log == null) {
                return;
            }
            try {
                this.writeNewLine();
                this.writeNewLine();
                this.log.writeBytes("*** Write ***");
                this.writeNewLine();
                this.log.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void checkReading() {
        if (this.writing) {
            this.writing = false;
            this.logPos = 0;
            if (this.log == null) {
                return;
            }
            try {
                this.writeNewLine();
                this.writeNewLine();
                this.log.writeBytes("*** Read ***");
                this.writeNewLine();
                this.log.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void logBuffer(byte[] byArray, int n, int n2) {
        try {
            this.writeBuffer(byArray, n, n2);
            this.log.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeNewLine() throws IOException {
        this.log.writeBytes(System.getProperty("line.separator"));
        this.log.flush();
    }

    private void writeBuffer(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.writeByte(byArray[n + n3]);
            ++n3;
            ++this.logPos;
            if (this.logPos % 4 == 0) {
                this.log.writeBytes(" ");
            }
            if (this.logPos % 16 != 0) continue;
            this.writeNewLine();
        }
    }

    private void writeByte(byte by) throws IOException {
        this.writeTuple(by >>> 4);
        this.writeTuple(by);
    }

    private void writeTuple(int n) throws IOException {
        int n2 = n & 0xF;
        this.log.writeBytes(this.H[n2]);
    }

    public void write(int n) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void write(byte[] byArray) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeBoolean(boolean bl) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeByte(int n) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeShort(int n) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeChar(int n) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeInt(int n) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeLong(long l) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeFloat(float f) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeDouble(double d) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeBytes(String string) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeChars(String string) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeUTF(String string) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void readFully(byte[] byArray) throws IOException {
        this.checkReading();
        this.dis.readFully(byArray);
        this.logBuffer(byArray, 0, byArray.length);
    }

    public int skipBytes(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.readByte();
        }
        this.writeNewLine();
        this.log.writeBytes("*** last " + n + " bytes skipped ***");
        this.writeNewLine();
        return n;
    }

    public boolean readBoolean() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public int readUnsignedByte() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public short readShort() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public int readUnsignedShort() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public char readChar() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public float readFloat() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public double readDouble() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public String readLine() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public String readUTF() throws IOException {
        throw new IOException("Log does not implement this method");
    }
}

