/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseBlob;
import com.metamatrix.jdbc.slbase.BaseCharacterStreamWrapper;
import com.metamatrix.jdbc.slbase.BaseClob;
import com.metamatrix.jdbc.slbase.BaseConnection;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseImplBlob;
import com.metamatrix.jdbc.slbase.BaseImplBlobEmulated;
import com.metamatrix.jdbc.slbase.BaseImplClob;
import com.metamatrix.jdbc.slbase.BaseImplClobEmulated;
import com.metamatrix.jdbc.slbase.BaseInputStreamWrapper;
import com.metamatrix.slutil.UtilASCIIInputStreamToCharacterReader;
import com.metamatrix.slutil.UtilBinaryToASCIIInputStream;
import com.metamatrix.slutil.UtilCharacterReaderToASCIIInputStream;
import com.metamatrix.slutil.UtilCharacterReaderToUCS2InputStream;
import com.metamatrix.slutil.UtilDataConversions;
import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilJDKVersionChecker;
import com.metamatrix.slutil.UtilSmallDecimal;
import com.metamatrix.slutil.UtilStringFunctions;
import com.metamatrix.slutil.UtilTransliterator;
import com.metamatrix.slutil.UtilUCS2InputStreamToCharacterReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class BaseData {
    public static final int UNKNOWN_DATA_OBJECT = 0;
    public static final int BYTE = 1;
    public static final int BYTE_ARRAY = 2;
    public static final int SHORT = 3;
    public static final int INTEGER = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int BIGDECIMAL = 8;
    public static final int BOOLEAN = 9;
    public static final int STRING = 10;
    public static final int DATE = 11;
    public static final int TIME = 12;
    public static final int TIMESTAMP = 13;
    public static final int BINARYINPUTSTREAM = 14;
    public static final int ASCIIINPUTSTREAM = 15;
    public static final int UTF8INPUTSTREAM = 16;
    public static final int UCS2INPUTSTREAM = 17;
    public static final int CHARACTERSTREAMREADER = 18;
    public static final int BLOB = 19;
    public static final int CLOB = 20;
    public static final int SMALLDECIMAL = 21;
    public static final int NATIVE_TYPE_BASE = 100;
    public static final int SQLSERVER_UNIQUEIDENTIFIER = 101;
    public static final int SQLSERVER_DATETIME = 102;
    public static final int SQLSERVER_SMALLDATETIME = 103;
    private static final int DEFAULT_CHUNK_LEN = 10240;
    private static final int MAX_CHUNK_LEN = Integer.MAX_VALUE;
    private int type;
    private Object data;
    static final BigDecimal bdMaxInt = new BigDecimal(Integer.toString(Integer.MAX_VALUE));
    static final BigDecimal bdMinInt = new BigDecimal(Integer.toString(Integer.MIN_VALUE));
    static final BigDecimal bdMaxLong = new BigDecimal(Long.toString(Long.MAX_VALUE));
    static final BigDecimal bdMinLong = new BigDecimal(Long.toString(Long.MIN_VALUE));
    static final BigDecimal bdMaxShort = new BigDecimal(Long.toString(32767L));
    static final BigDecimal bdMinShort = new BigDecimal(Long.toString(-32768L));
    private boolean booleanValue;
    private byte byteValue;
    private short shortValue;
    private int intValue;
    private long longValue;
    private float floatValue;
    private double doubleValue;
    public boolean isNull;
    private boolean needWrapper = true;

    public BaseData() {
        this.setNull(0);
    }

    public BaseData(int n, Object object) {
        this.setData(n, object);
    }

    public BaseData(Object object) {
        this.setData(object);
    }

    public int getType() {
        return this.type;
    }

    public void populate(BaseData baseData) {
        if (baseData == null) {
            this.isNull = true;
            this.type = 0;
        } else if (baseData.isNull()) {
            this.setNull(baseData.type);
        } else {
            this.isNull = false;
            this.type = baseData.type;
            switch (this.type) {
                case 4: {
                    this.intValue = baseData.intValue;
                    break;
                }
                case 1: {
                    this.byteValue = baseData.byteValue;
                    break;
                }
                case 9: {
                    this.booleanValue = baseData.booleanValue;
                    break;
                }
                case 3: {
                    this.shortValue = baseData.shortValue;
                    break;
                }
                case 5: {
                    this.longValue = baseData.longValue;
                    break;
                }
                case 6: {
                    this.floatValue = baseData.floatValue;
                    break;
                }
                case 7: {
                    this.doubleValue = baseData.doubleValue;
                    break;
                }
                default: {
                    this.data = baseData.data;
                }
            }
        }
    }

    public boolean isNull() {
        return this.isNull;
    }

    public static boolean isVariableLengthType(int n) {
        switch (n) {
            case -9: 
            case -8: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 93: {
                return true;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 91: 
            case 92: {
                return false;
            }
        }
        return false;
    }

    public static int[] getInfoForSQLType(int n) {
        int[] nArray = new int[]{-1, -1, -1, -1};
        switch (n) {
            case -5: {
                nArray[0] = 20;
                nArray[1] = 19;
                nArray[2] = 0;
                nArray[3] = 5;
                break;
            }
            case -7: 
            case 16: {
                nArray[0] = 1;
                nArray[1] = 1;
                nArray[2] = -1;
                nArray[3] = 9;
                break;
            }
            case 91: {
                nArray[0] = 10;
                nArray[1] = 10;
                nArray[2] = 0;
                nArray[3] = 11;
                break;
            }
            case 2: 
            case 3: {
                nArray[3] = 8;
                break;
            }
            case 6: 
            case 8: {
                nArray[0] = 22;
                nArray[1] = 15;
                nArray[2] = 0;
                nArray[3] = 7;
                break;
            }
            case 4: {
                nArray[0] = 11;
                nArray[1] = 10;
                nArray[2] = 0;
                nArray[3] = 4;
                break;
            }
            case 5: {
                nArray[0] = 6;
                nArray[1] = 5;
                nArray[2] = 0;
                nArray[3] = 3;
                break;
            }
            case -6: {
                nArray[0] = 4;
                nArray[1] = 3;
                nArray[2] = 0;
                nArray[3] = 3;
                break;
            }
            case 7: {
                nArray[0] = 13;
                nArray[1] = 7;
                nArray[2] = 0;
                nArray[3] = 6;
                break;
            }
            case 92: {
                nArray[0] = 18;
                nArray[1] = 18;
                nArray[2] = 9;
                nArray[3] = 12;
                break;
            }
            case 93: {
                nArray[0] = 29;
                nArray[1] = 29;
                nArray[2] = 9;
                nArray[3] = 13;
                break;
            }
            case -2: {
                nArray[3] = 2;
                break;
            }
            case -8: 
            case 1: {
                nArray[3] = 10;
                break;
            }
            case -4: {
                nArray[3] = 14;
                break;
            }
            case -1: {
                nArray[3] = 15;
                break;
            }
            case -3: {
                nArray[3] = 2;
                break;
            }
            case -9: 
            case 12: {
                nArray[3] = 10;
                break;
            }
            case 2004: {
                nArray[3] = 19;
                break;
            }
            case -10: 
            case 2005: {
                nArray[3] = 20;
                break;
            }
        }
        return nArray;
    }

    static String mapJDBCTypeToJavaObjectTypeName(int n) {
        String string = null;
        switch (n) {
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                string = "java.lang.String";
                break;
            }
            case 2: 
            case 3: {
                string = "java.math.BigDecimal";
                break;
            }
            case -7: 
            case 16: {
                string = "java.lang.Boolean";
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                string = "java.lang.Integer";
                break;
            }
            case -5: {
                string = "java.lang.Long";
                break;
            }
            case 7: {
                string = "java.lang.Float";
                break;
            }
            case 6: 
            case 8: {
                string = "java.lang.Double";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                string = "byte[]";
                break;
            }
            case 91: {
                string = "java.sql.Date";
                break;
            }
            case 92: {
                string = "java.sql.Time";
                break;
            }
            case 93: {
                string = "java.sql.Timestamp";
                break;
            }
            case -10: 
            case 2005: {
                string = "java.sql.Clob";
                break;
            }
            case 2004: {
                string = "java.sql.Blob";
                break;
            }
            case 2003: {
                string = "java.sql.Array";
                break;
            }
            case 2006: {
                string = "java.sql.Ref";
                break;
            }
            case 2002: {
                string = "java.sql.Struct";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static int mapJDBCTypeToJavaObjectType(int n) {
        int n2 = 0;
        switch (n) {
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                n2 = 10;
                break;
            }
            case 2: 
            case 3: {
                n2 = 8;
                break;
            }
            case -7: 
            case 16: {
                n2 = 9;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                n2 = 4;
                break;
            }
            case -5: {
                n2 = 5;
                break;
            }
            case 7: {
                n2 = 6;
                break;
            }
            case 6: 
            case 8: {
                n2 = 7;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                n2 = 2;
                break;
            }
            case 91: {
                n2 = 11;
                break;
            }
            case 92: {
                n2 = 12;
                break;
            }
            case 93: {
                n2 = 13;
                break;
            }
            case 2004: {
                n2 = 19;
                break;
            }
            case -10: 
            case 2005: {
                n2 = 20;
                break;
            }
        }
        return n2;
    }

    public void setASCIIStream(InputStream inputStream) {
        this.type = 15;
        if (inputStream == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = inputStream;
        }
    }

    public void setBigDecimal(BigDecimal bigDecimal) {
        this.type = 8;
        if (bigDecimal == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = bigDecimal;
        }
    }

    public void setBinaryStream(InputStream inputStream) {
        this.type = 14;
        if (inputStream == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = inputStream;
        }
    }

    public void setBlob(BaseImplBlob baseImplBlob) {
        this.type = 19;
        if (baseImplBlob == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = baseImplBlob;
        }
    }

    public void setBoolean(boolean bl) {
        this.booleanValue = bl;
        this.type = 9;
        this.isNull = false;
        this.data = null;
    }

    public void setByte(byte by) {
        this.byteValue = by;
        this.type = 1;
        this.isNull = false;
        this.data = null;
    }

    public void setBytes(byte[] byArray) {
        this.type = 2;
        if (byArray == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = byArray;
        }
    }

    public void setNativeBytes(byte[] byArray, int n) {
        this.type = n;
        if (byArray == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = byArray;
        }
    }

    public void setCharacterStreamReader(Reader reader) {
        this.type = 18;
        if (reader == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = reader;
        }
    }

    public void setClob(BaseImplClob baseImplClob) {
        this.type = 20;
        if (baseImplClob == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = baseImplClob;
        }
    }

    public void setData(int n, Object object) {
        this.type = n;
        if (object == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            switch (this.type) {
                case 4: {
                    this.intValue = (Integer)object;
                    this.data = null;
                    break;
                }
                case 1: {
                    this.byteValue = (Byte)object;
                    this.data = null;
                    break;
                }
                case 9: {
                    this.booleanValue = (Boolean)object;
                    this.data = null;
                    break;
                }
                case 3: {
                    this.shortValue = (Short)object;
                    this.data = null;
                    break;
                }
                case 5: {
                    this.longValue = (Long)object;
                    this.data = null;
                    break;
                }
                case 6: {
                    this.floatValue = ((Float)object).floatValue();
                    this.data = null;
                    break;
                }
                case 7: {
                    this.doubleValue = (Double)object;
                    this.data = null;
                    break;
                }
                default: {
                    this.data = object;
                }
            }
        }
    }

    public void setData(Object object) {
        this.setData(BaseData.getJavaObjectType(object, 0), object);
    }

    public void setDate(Date date) {
        this.type = 11;
        if (date == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = date;
        }
    }

    public void setDouble(double d) {
        this.doubleValue = d;
        this.type = 7;
        this.isNull = false;
        this.data = null;
    }

    public void setFloat(float f) {
        this.floatValue = f;
        this.type = 6;
        this.isNull = false;
        this.data = null;
    }

    public void setInteger(int n) {
        this.intValue = n;
        this.type = 4;
        this.isNull = false;
        this.data = null;
    }

    public void setLong(long l) {
        this.longValue = l;
        this.type = 5;
        this.isNull = false;
        this.data = null;
    }

    public void setNull(int n) {
        this.isNull = true;
        this.type = n;
        this.data = null;
    }

    public void setShort(short s) {
        this.shortValue = s;
        this.type = 3;
        this.isNull = false;
        this.data = null;
    }

    public void setSmallDecimal(UtilSmallDecimal utilSmallDecimal) {
        this.type = 21;
        if (utilSmallDecimal == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = utilSmallDecimal;
        }
    }

    public void setString(String string) {
        this.type = 10;
        if (string == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = string;
        }
    }

    public void setTime(Time time) {
        this.type = 12;
        if (time == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = time;
        }
    }

    public void setTimestamp(Timestamp timestamp) {
        this.type = 13;
        if (timestamp == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = timestamp;
        }
    }

    public void setUCS2InputStream(InputStream inputStream) {
        this.type = 17;
        if (inputStream == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = inputStream;
        }
    }

    public void setUTF8InputStream(InputStream inputStream) {
        this.type = 16;
        if (inputStream == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = inputStream;
        }
    }

    public static int getJavaObjectType(Object object, int n) {
        int n2 = 0;
        if (object == null) {
            n2 = BaseData.mapJDBCTypeToJavaObjectType(n);
        } else if (object instanceof Integer) {
            n2 = 4;
        } else if (object instanceof Byte) {
            n2 = 1;
        } else if (object instanceof Short) {
            n2 = 3;
        } else if (object instanceof Long) {
            n2 = 5;
        } else if (object instanceof Float) {
            n2 = 6;
        } else if (object instanceof Double) {
            n2 = 7;
        } else if (object instanceof BigDecimal) {
            n2 = 8;
        } else if (object instanceof UtilSmallDecimal) {
            n2 = 21;
        } else if (object instanceof Boolean) {
            n2 = 9;
        } else if (object instanceof String) {
            n2 = 10;
        } else if (object instanceof Date) {
            n2 = 11;
        } else if (object instanceof Time) {
            n2 = 12;
        } else if (object instanceof Timestamp) {
            n2 = 13;
        } else if (object instanceof Blob || object instanceof BaseImplBlob) {
            n2 = 19;
        } else if (object instanceof Clob || object instanceof BaseImplClob) {
            n2 = 20;
        } else if (object instanceof Reader) {
            n2 = 18;
        } else if (object instanceof InputStream) {
            switch (n) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    n2 = 14;
                    break;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    n2 = 15;
                }
            }
        } else {
            String string = object.getClass().getName();
            if (string.equals("[B")) {
                n2 = 2;
            }
        }
        return n2;
    }

    static boolean isStreamed(int n) {
        switch (n) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public static byte[] stringToBytes(String string, UtilTransliterator utilTransliterator, BaseExceptions baseExceptions) throws SQLException {
        byte[] byArray = null;
        if (utilTransliterator != null) {
            try {
                byArray = utilTransliterator.encode(string);
            }
            catch (UtilException utilException) {
                throw baseExceptions.getException(6024);
            }
        } else {
            int n = string.length();
            if (n % 2 != 0) {
                throw baseExceptions.getException(6032, "22018");
            }
            byte[] byArray2 = new byte[n / 2];
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                byte by;
                char c = string.charAt(i);
                if (c >= '0' && c <= '9') {
                    by = (byte)(c - 48);
                } else if (c >= 'a' && c <= 'f') {
                    by = (byte)(c - 97 + 10);
                } else if (c >= 'A' && c <= 'F') {
                    by = (byte)(c - 65 + 10);
                } else {
                    throw baseExceptions.getException(6032, "22018");
                }
                if (bl) {
                    byArray2[i / 2] = (byte)(by << 4);
                    bl = false;
                    continue;
                }
                int n2 = i / 2;
                byArray2[n2] = (byte)(byArray2[n2] + by);
                bl = true;
            }
            byArray = byArray2;
        }
        return byArray;
    }

    public static int compare(BaseData baseData, BaseData baseData2, int n, BaseExceptions baseExceptions) throws SQLException {
        int n2 = 0;
        switch (n) {
            case 10: {
                String string = baseData.getString(-1, baseExceptions);
                String string2 = baseData2.getString(-1, baseExceptions);
                n2 = UtilStringFunctions.CompareStrings(string, string2);
                break;
            }
            case 4: {
                int n3 = baseData.getInteger(baseExceptions);
                int n4 = baseData2.getInteger(baseExceptions);
                if (n3 > n4) {
                    n2 = 1;
                    break;
                }
                if (n3 < n4) {
                    n2 = -1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 3: {
                short s = baseData.getShort(baseExceptions);
                short s2 = baseData2.getShort(baseExceptions);
                if (s > s2) {
                    n2 = 1;
                    break;
                }
                if (s < s2) {
                    n2 = -1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 9: {
                boolean bl = baseData.getBoolean(baseExceptions);
                boolean bl2 = baseData2.getBoolean(baseExceptions);
                n2 = bl && !bl2 ? 1 : (!bl && bl2 ? -1 : 0);
            }
        }
        return n2;
    }

    public Object getObject() {
        if (this.isNull) {
            return null;
        }
        switch (this.type) {
            case 4: {
                return new Integer(this.intValue);
            }
            case 1: {
                return new Byte(this.byteValue);
            }
            case 9: {
                return new Boolean(this.booleanValue);
            }
            case 3: {
                return new Short(this.shortValue);
            }
            case 5: {
                return new Long(this.longValue);
            }
            case 6: {
                return new Float(this.floatValue);
            }
            case 7: {
                return new Double(this.doubleValue);
            }
            case 101: {
                return this.sqlserverUniqueidentifierToString();
            }
            case 102: 
            case 103: {
                return this.sqlserverDateTimeToTimestamp();
            }
        }
        return this.data;
    }

    public Object getObject(int n, int n2, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        Object object = null;
        switch (n) {
            case 1: {
                object = new Byte(this.getByte(baseExceptions));
                break;
            }
            case 9: {
                object = new Boolean(this.getBoolean(baseExceptions));
                break;
            }
            case 4: {
                object = new Integer(this.getInteger(baseExceptions));
                break;
            }
            case 3: {
                object = new Short(this.getShort(baseExceptions));
                break;
            }
            case 5: {
                object = new Long(this.getLong(baseExceptions));
                break;
            }
            case 6: {
                object = new Float(this.getFloat(baseExceptions));
                break;
            }
            case 7: {
                object = new Double(this.getDouble(baseExceptions));
                break;
            }
            case 10: {
                object = this.getString(n2, baseExceptions);
                break;
            }
            case 2: {
                object = this.getBytes(n2, baseExceptions);
                break;
            }
            case 19: {
                object = this.getBlob(baseConnection, baseExceptions);
                break;
            }
            case 20: {
                object = this.getClob(baseConnection, baseExceptions);
                break;
            }
            case 8: 
            case 21: {
                object = this.getBigDecimal(baseExceptions);
                break;
            }
            case 11: {
                object = this.getDate(baseExceptions);
                break;
            }
            case 12: {
                object = this.getTime(baseExceptions);
                break;
            }
            case 13: {
                object = this.getTimestamp(baseExceptions);
                break;
            }
            case 101: {
                object = this.sqlserverUniqueidentifierToString();
                break;
            }
            case 102: 
            case 103: {
                object = this.sqlserverDateTimeToTimestamp();
                break;
            }
            default: {
                object = this.data;
            }
        }
        return object;
    }

    public InputStream getASCIIStreamNoConvert() {
        return (InputStream)this.data;
    }

    public InputStream getASCIIStream(int n, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 2: 
                case 10: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 101: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            int n2 = -1;
            switch (this.type) {
                case 15: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                case 14: {
                    inputStream = new UtilBinaryToASCIIInputStream((InputStream)this.data);
                    break;
                }
                case 2: {
                    inputStream = new UtilBinaryToASCIIInputStream(new ByteArrayInputStream((byte[])this.data));
                    n2 = ((byte[])this.data).length * 2;
                    break;
                }
                case 101: {
                    String string = this.sqlserverUniqueidentifierToString();
                    inputStream = UtilDataConversions.stringToASCIIInputStream(string);
                    n2 = string.length();
                    break;
                }
                case 10: {
                    inputStream = UtilDataConversions.stringToASCIIInputStream((String)this.data);
                    n2 = ((String)this.data).length();
                    break;
                }
                case 18: {
                    inputStream = new UtilCharacterReaderToASCIIInputStream((Reader)this.data);
                    break;
                }
                case 20: {
                    inputStream = this.getClob(baseConnection, baseExceptions).getAsciiStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, n2, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public InputStream getASCIIStream(int n, BaseConnection baseConnection, BaseExceptions baseExceptions, boolean bl) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 2: 
                case 10: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 101: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            int n2 = -1;
            switch (this.type) {
                case 15: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                case 14: {
                    inputStream = new UtilBinaryToASCIIInputStream((InputStream)this.data);
                    break;
                }
                case 2: {
                    inputStream = new UtilBinaryToASCIIInputStream(new ByteArrayInputStream((byte[])this.data));
                    n2 = ((byte[])this.data).length * 2;
                    break;
                }
                case 101: {
                    String string = this.sqlserverUniqueidentifierToString();
                    inputStream = UtilDataConversions.stringToASCIIInputStream(string);
                    n2 = string.length();
                    break;
                }
                case 10: {
                    inputStream = UtilDataConversions.stringToASCIIInputStream((String)this.data);
                    n2 = ((String)this.data).length();
                    break;
                }
                case 18: {
                    inputStream = new UtilCharacterReaderToASCIIInputStream((Reader)this.data);
                    break;
                }
                case 20: {
                    Clob clob = this.getClob(baseConnection, baseExceptions);
                    if (clob instanceof BaseClob) {
                        inputStream = ((BaseClob)clob).getAsciiStream(bl);
                        break;
                    }
                    inputStream = clob.getAsciiStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, n2, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public BigDecimal getBigDecimalNoConvert() {
        return (BigDecimal)this.data;
    }

    public BigDecimal getBigDecimal(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            BigDecimal bigDecimal = null;
            switch (this.type) {
                case 8: {
                    bigDecimal = (BigDecimal)this.data;
                    break;
                }
                case 21: {
                    BigInteger bigInteger = new BigInteger(((UtilSmallDecimal)this.data).toByteArray());
                    bigDecimal = new BigDecimal(bigInteger, ((UtilSmallDecimal)this.data).getScale());
                    break;
                }
                case 10: {
                    bigDecimal = new BigDecimal(((String)this.data).trim());
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    bigDecimal = new BigDecimal(string.trim());
                    break;
                }
                case 7: {
                    if (UtilJDKVersionChecker.getJVMVersion() >= 1.3f) {
                        bigDecimal = new BigDecimal(Double.toString(this.doubleValue));
                        break;
                    }
                    bigDecimal = new BigDecimal(this.doubleValue);
                    break;
                }
                case 6: {
                    if (UtilJDKVersionChecker.getJVMVersion() >= 1.3f) {
                        bigDecimal = new BigDecimal(Float.toString(this.floatValue));
                        break;
                    }
                    bigDecimal = new BigDecimal(this.floatValue);
                    break;
                }
                case 1: {
                    bigDecimal = new BigDecimal((double)this.byteValue);
                    break;
                }
                case 3: {
                    bigDecimal = new BigDecimal((double)this.shortValue);
                    break;
                }
                case 5: {
                    byte[] byArray = new byte[]{(byte)(this.longValue >>> 56), (byte)(this.longValue >>> 48), (byte)(this.longValue >>> 40), (byte)(this.longValue >>> 32), (byte)(this.longValue >>> 24), (byte)(this.longValue >>> 16), (byte)(this.longValue >>> 8), (byte)this.longValue};
                    bigDecimal = new BigDecimal(new BigInteger(byArray));
                    break;
                }
                case 4: {
                    bigDecimal = new BigDecimal((double)this.intValue);
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        bigDecimal = new BigDecimal(1.0);
                        break;
                    }
                    bigDecimal = new BigDecimal(0.0);
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return bigDecimal;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public BigDecimal getBigDecimal(int n, BaseExceptions baseExceptions) throws SQLException {
        try {
            BigDecimal bigDecimal = this.getBigDecimal(baseExceptions);
            if (bigDecimal != null) {
                try {
                    bigDecimal = bigDecimal.setScale(n, 7);
                }
                catch (ArithmeticException arithmeticException) {
                    bigDecimal = bigDecimal.setScale(n, 4);
                }
            }
            return bigDecimal;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Blob getBlobNoConvert() {
        return (Blob)this.data;
    }

    public Blob getBlob(BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.type == 19) {
                return null;
            }
            this.getBytes(0, baseExceptions);
            return null;
        }
        try {
            Blob blob = null;
            switch (this.type) {
                case 19: {
                    if (this.data instanceof BaseImplBlob) {
                        this.data = new BaseBlob((BaseImplBlob)this.data, baseConnection, baseExceptions);
                    }
                    blob = (Blob)this.data;
                    break;
                }
                default: {
                    this.needWrapper = false;
                    InputStream inputStream = this.getBinaryStream(-1, baseConnection, baseExceptions);
                    this.needWrapper = true;
                    BaseImplBlobEmulated baseImplBlobEmulated = new BaseImplBlobEmulated(baseExceptions, inputStream);
                    blob = new BaseBlob(baseImplBlobEmulated, baseConnection, baseExceptions);
                }
            }
            return blob;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public boolean getBooleanNoConvert() {
        return this.booleanValue;
    }

    public boolean getBoolean(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return false;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            boolean bl = false;
            switch (this.type) {
                case 9: {
                    bl = this.booleanValue;
                    break;
                }
                case 10: 
                case 15: 
                case 17: 
                case 18: {
                    String string;
                    if (this.type == 10) {
                        string = ((String)this.data).trim();
                    } else {
                        String string2 = this.getString(-1, baseExceptions);
                        string = string2.trim();
                    }
                    if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("1")) {
                        bl = true;
                        break;
                    }
                    if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("0")) {
                        bl = false;
                        break;
                    }
                    throw baseExceptions.getException(6024);
                }
                case 1: {
                    bl = this.byteValue != 0;
                    break;
                }
                case 3: {
                    bl = this.shortValue != 0;
                    break;
                }
                case 4: {
                    bl = this.intValue != 0;
                    break;
                }
                case 5: {
                    bl = this.longValue != 0L;
                    break;
                }
                case 6: {
                    bl = (double)this.floatValue != 0.0;
                    break;
                }
                case 7: {
                    bl = this.doubleValue != 0.0;
                    break;
                }
                case 8: {
                    bl = ((BigDecimal)this.data).doubleValue() != 0.0;
                    break;
                }
                case 21: {
                    bl = ((UtilSmallDecimal)this.data).doubleValue() != 0.0;
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return bl;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public byte getByteNoConvert() {
        return this.byteValue;
    }

    public byte getByte(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            byte by = 0;
            switch (this.type) {
                case 1: {
                    by = this.byteValue;
                    break;
                }
                case 10: {
                    by = Byte.parseByte(((String)this.data).trim());
                    break;
                }
                case 3: {
                    by = (byte)this.shortValue;
                    break;
                }
                case 4: {
                    by = (byte)this.intValue;
                    break;
                }
                case 5: {
                    by = (byte)this.longValue;
                    break;
                }
                case 6: {
                    by = (byte)this.floatValue;
                    break;
                }
                case 7: {
                    by = (byte)this.doubleValue;
                    break;
                }
                case 8: {
                    Integer n = new Integer(((BigDecimal)this.data).intValue());
                    by = n.byteValue();
                    break;
                }
                case 21: {
                    by = (byte)((UtilSmallDecimal)this.data).longValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        by = 1;
                        break;
                    }
                    by = 0;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    by = Byte.parseByte(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return by;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public byte[] getBytesNoConvert() {
        return (byte[])this.data;
    }

    public byte[] getBytes(int n, BaseExceptions baseExceptions) throws SQLException {
        return this.getBytes(n, null, baseExceptions);
    }

    public byte[] getBytes(int n, UtilTransliterator utilTransliterator, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 2: 
                case 10: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 101: 
                case 102: 
                case 103: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Object object;
            Object object2 = null;
            switch (this.type) {
                case 2: 
                case 101: 
                case 102: 
                case 103: {
                    object2 = (byte[])this.data;
                    break;
                }
                case 10: {
                    object2 = BaseData.stringToBytes((String)this.data, utilTransliterator, baseExceptions);
                    break;
                }
                case 14: {
                    object = new ByteArrayOutputStream();
                    byte[] byArray = new byte[1024];
                    boolean bl = false;
                    while (!bl) {
                        int n2;
                        try {
                            n2 = ((InputStream)this.data).read(byArray, 0, byArray.length);
                        }
                        catch (IOException iOException) {
                            throw baseExceptions.getException(iOException);
                        }
                        if (n2 == -1) {
                            bl = true;
                            try {
                                ((InputStream)this.data).close();
                                continue;
                            }
                            catch (IOException iOException) {
                                throw baseExceptions.getException(iOException);
                            }
                        }
                        ((ByteArrayOutputStream)object).write(byArray, 0, n2);
                    }
                    object2 = ((ByteArrayOutputStream)object).toByteArray();
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    object = this.getString(-1, baseExceptions);
                    object2 = BaseData.stringToBytes((String)object, utilTransliterator, baseExceptions);
                    break;
                }
                case 19: {
                    Blob blob = this.getBlob(null, baseExceptions);
                    int n3 = (int)blob.length();
                    if (n >= 0 && n3 > n) {
                        n3 = n;
                    }
                    object2 = blob.getBytes(1L, n3);
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (n != -1 && ((byte[])object2).length > n) {
                object = new byte[n];
                System.arraycopy(object2, 0, object, 0, n);
                object2 = object;
            }
            return object2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Reader getCharacterStreamReaderNoConvert() {
        return (Reader)this.data;
    }

    public Reader getCharacterStreamReader(int n, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 2: 
                case 10: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 20: 
                case 101: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Reader reader = null;
            int n2 = -1;
            switch (this.type) {
                case 18: {
                    reader = (Reader)this.data;
                    break;
                }
                case 10: {
                    reader = new StringReader((String)this.data);
                    n2 = ((String)this.data).length();
                    break;
                }
                case 15: {
                    reader = new UtilASCIIInputStreamToCharacterReader((InputStream)this.data);
                    if (!(this.data instanceof BaseInputStreamWrapper)) break;
                    n2 = (int)((BaseInputStreamWrapper)this.data).length();
                    break;
                }
                case 2: {
                    String string = UtilDataConversions.bytesToString((byte[])this.data, ((byte[])this.data).length);
                    reader = new StringReader(string);
                    n2 = ((byte[])this.data).length * 2;
                    break;
                }
                case 101: {
                    String string = this.sqlserverUniqueidentifierToString();
                    reader = new StringReader(string);
                    n2 = string.length();
                    break;
                }
                case 14: {
                    UtilBinaryToASCIIInputStream utilBinaryToASCIIInputStream = new UtilBinaryToASCIIInputStream((InputStream)this.data);
                    if (this.data instanceof BaseInputStreamWrapper) {
                        n2 = (int)((BaseInputStreamWrapper)this.data).length();
                    }
                    reader = new UtilASCIIInputStreamToCharacterReader(utilBinaryToASCIIInputStream);
                    break;
                }
                case 17: {
                    reader = new UtilUCS2InputStreamToCharacterReader((InputStream)this.data);
                    if (!(this.data instanceof BaseInputStreamWrapper)) break;
                    n2 = (int)((BaseInputStreamWrapper)this.data).length();
                    break;
                }
                case 20: {
                    reader = this.getClob(baseConnection, baseExceptions).getCharacterStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (reader != null && this.needWrapper) {
                if (!(reader instanceof BaseCharacterStreamWrapper)) {
                    reader = new BaseCharacterStreamWrapper(reader, n2, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseCharacterStreamWrapper)reader).maxCharsToReturn = n / 2;
                }
            }
            return reader;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Reader getCharacterStreamReader(int n, BaseConnection baseConnection, BaseExceptions baseExceptions, boolean bl) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 2: 
                case 10: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 20: 
                case 101: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Reader reader = null;
            int n2 = -1;
            switch (this.type) {
                case 18: {
                    reader = (Reader)this.data;
                    break;
                }
                case 10: {
                    reader = new StringReader((String)this.data);
                    n2 = ((String)this.data).length();
                    break;
                }
                case 15: {
                    reader = new UtilASCIIInputStreamToCharacterReader((InputStream)this.data);
                    if (!(this.data instanceof BaseInputStreamWrapper)) break;
                    n2 = (int)((BaseInputStreamWrapper)this.data).length();
                    break;
                }
                case 2: {
                    String string = UtilDataConversions.bytesToString((byte[])this.data, ((byte[])this.data).length);
                    reader = new StringReader(string);
                    n2 = ((byte[])this.data).length * 2;
                    break;
                }
                case 101: {
                    String string = this.sqlserverUniqueidentifierToString();
                    reader = new StringReader(string);
                    n2 = string.length();
                    break;
                }
                case 14: {
                    UtilBinaryToASCIIInputStream utilBinaryToASCIIInputStream = new UtilBinaryToASCIIInputStream((InputStream)this.data);
                    if (this.data instanceof BaseInputStreamWrapper) {
                        n2 = (int)((BaseInputStreamWrapper)this.data).length();
                    }
                    reader = new UtilASCIIInputStreamToCharacterReader(utilBinaryToASCIIInputStream);
                    break;
                }
                case 17: {
                    reader = new UtilUCS2InputStreamToCharacterReader((InputStream)this.data);
                    if (!(this.data instanceof BaseInputStreamWrapper)) break;
                    n2 = (int)((BaseInputStreamWrapper)this.data).length();
                    break;
                }
                case 20: {
                    Clob clob = this.getClob(baseConnection, baseExceptions);
                    if (clob instanceof BaseClob) {
                        reader = ((BaseClob)clob).getCharacterStream(bl);
                        break;
                    }
                    reader = clob.getCharacterStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (reader != null && this.needWrapper) {
                if (!(reader instanceof BaseCharacterStreamWrapper)) {
                    reader = new BaseCharacterStreamWrapper(reader, n2, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseCharacterStreamWrapper)reader).maxCharsToReturn = n / 2;
                }
            }
            return reader;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public short getShortNoConvert() {
        return this.shortValue;
    }

    public short getShort(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            short s = 0;
            switch (this.type) {
                case 3: {
                    s = this.shortValue;
                    break;
                }
                case 10: {
                    s = Short.parseShort(((String)this.data).trim());
                    break;
                }
                case 1: {
                    s = this.byteValue;
                    break;
                }
                case 4: {
                    if (this.intValue > Short.MAX_VALUE || this.intValue < Short.MIN_VALUE) {
                        throw baseExceptions.getException(6104);
                    }
                    s = (short)this.intValue;
                    break;
                }
                case 5: {
                    if (this.longValue > 32767L || this.longValue < -32768L) {
                        throw baseExceptions.getException(6104);
                    }
                    s = (short)this.longValue;
                    break;
                }
                case 6: {
                    if (this.floatValue > 32767.0f || this.floatValue < -32768.0f) {
                        throw baseExceptions.getException(6104);
                    }
                    s = (short)this.floatValue;
                    break;
                }
                case 7: {
                    if (this.doubleValue > 32767.0 || this.doubleValue < -32768.0) {
                        throw baseExceptions.getException(6104);
                    }
                    s = (short)this.doubleValue;
                    break;
                }
                case 8: {
                    BigDecimal bigDecimal = (BigDecimal)this.data;
                    if (bigDecimal.compareTo(bdMaxShort) > 0 || bigDecimal.compareTo(bdMinShort) < 0) {
                        throw baseExceptions.getException(6104);
                    }
                    s = (short)bigDecimal.intValue();
                    break;
                }
                case 21: {
                    s = (short)((UtilSmallDecimal)this.data).longValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        s = 1;
                        break;
                    }
                    s = 0;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    s = Short.parseShort(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return s;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public int getIntegerNoConvert() {
        return this.intValue;
    }

    public int getInteger(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            int n = 0;
            switch (this.type) {
                case 4: {
                    n = this.intValue;
                    break;
                }
                case 1: {
                    n = this.byteValue;
                    break;
                }
                case 3: {
                    n = this.shortValue;
                    break;
                }
                case 5: {
                    if (this.longValue > Integer.MAX_VALUE || this.longValue < Integer.MIN_VALUE) {
                        throw baseExceptions.getException(6104);
                    }
                    n = (int)this.longValue;
                    break;
                }
                case 6: {
                    if (this.floatValue > 2.1474836E9f || this.floatValue < -2.1474836E9f) {
                        throw baseExceptions.getException(6104);
                    }
                    n = (int)this.floatValue;
                    break;
                }
                case 7: {
                    if (this.doubleValue > 2.147483647E9 || this.doubleValue < -2.147483648E9) {
                        throw baseExceptions.getException(6104);
                    }
                    n = (int)this.doubleValue;
                    break;
                }
                case 8: {
                    BigDecimal bigDecimal = (BigDecimal)this.data;
                    if (bigDecimal.compareTo(bdMaxInt) > 0 || bigDecimal.compareTo(bdMinInt) < 0) {
                        throw baseExceptions.getException(6104);
                    }
                    n = bigDecimal.intValue();
                    break;
                }
                case 21: {
                    n = (int)((UtilSmallDecimal)this.data).longValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        n = 1;
                        break;
                    }
                    n = 0;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    n = Integer.parseInt(string.trim());
                    break;
                }
                case 10: {
                    n = Integer.parseInt(((String)this.data).trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return n;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public long getLongNoConvert() {
        return this.longValue;
    }

    public long getLong(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0L;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            long l = 0L;
            switch (this.type) {
                case 5: {
                    l = this.longValue;
                    break;
                }
                case 1: {
                    l = this.byteValue;
                    break;
                }
                case 3: {
                    l = this.shortValue;
                    break;
                }
                case 4: {
                    l = this.intValue;
                    break;
                }
                case 6: {
                    if (this.floatValue > 9.223372E18f || this.floatValue < -9.223372E18f) {
                        throw baseExceptions.getException(6104);
                    }
                    l = (long)this.floatValue;
                    break;
                }
                case 7: {
                    if (this.doubleValue > 9.223372036854776E18 || this.doubleValue < -9.223372036854776E18) {
                        throw baseExceptions.getException(6104);
                    }
                    l = (long)this.doubleValue;
                    break;
                }
                case 8: {
                    BigDecimal bigDecimal = (BigDecimal)this.data;
                    if (bigDecimal.compareTo(bdMaxLong) > 0 || bigDecimal.compareTo(bdMinLong) < 0) {
                        throw baseExceptions.getException(6104);
                    }
                    l = ((BigDecimal)this.data).longValue();
                    break;
                }
                case 21: {
                    l = ((UtilSmallDecimal)this.data).longValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        l = 1L;
                        break;
                    }
                    l = 0L;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    l = Long.parseLong(string.trim());
                    break;
                }
                case 10: {
                    l = Long.parseLong(((String)this.data).trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return l;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public float getFloatNoConvert() {
        return this.floatValue;
    }

    public float getFloat(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0.0f;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            float f = 0.0f;
            switch (this.type) {
                case 6: {
                    f = this.floatValue;
                    break;
                }
                case 10: {
                    f = Float.valueOf(((String)this.data).trim()).floatValue();
                    break;
                }
                case 1: {
                    f = this.byteValue;
                    break;
                }
                case 3: {
                    f = this.shortValue;
                    break;
                }
                case 4: {
                    f = this.intValue;
                    break;
                }
                case 5: {
                    f = this.longValue;
                    break;
                }
                case 7: {
                    f = ((Double)this.getObject()).floatValue();
                    break;
                }
                case 8: {
                    float f2 = ((BigDecimal)this.data).floatValue();
                    if (f2 == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
                        throw baseExceptions.getException(6104);
                    }
                    f = f2;
                    break;
                }
                case 21: {
                    f = (float)((UtilSmallDecimal)this.data).doubleValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        f = 1.0f;
                        break;
                    }
                    f = 0.0f;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    f = Float.valueOf(string.trim()).floatValue();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return f;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public double getDoubleNoConvert() {
        return this.doubleValue;
    }

    public double getDouble(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0.0;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            double d = 0.0;
            switch (this.type) {
                case 7: {
                    d = this.doubleValue;
                    break;
                }
                case 10: {
                    d = Double.valueOf(((String)this.data).trim());
                    break;
                }
                case 1: {
                    d = this.byteValue;
                    break;
                }
                case 3: {
                    d = this.shortValue;
                    break;
                }
                case 4: {
                    d = this.intValue;
                    break;
                }
                case 5: {
                    d = this.longValue;
                    break;
                }
                case 6: {
                    d = this.floatValue;
                    break;
                }
                case 8: {
                    double d2 = ((BigDecimal)this.data).doubleValue();
                    if (d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
                        throw baseExceptions.getException(6104);
                    }
                    d = d2;
                    break;
                }
                case 21: {
                    d = ((UtilSmallDecimal)this.data).doubleValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        d = 1.0;
                        break;
                    }
                    d = 0.0;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    d = Double.valueOf(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return d;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public String getStringNoConvert() {
        switch (this.type) {
            case 101: {
                return this.sqlserverUniqueidentifierToString();
            }
            case 102: 
            case 103: {
                return this.sqlserverDateTimeToTimestamp().toString();
            }
        }
        return (String)this.data;
    }

    public String getString(int n, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.type == 16) {
                this.unsupportedConversion(baseExceptions);
            }
            return null;
        }
        try {
            String string = null;
            switch (this.type) {
                case 10: {
                    string = (String)this.data;
                    break;
                }
                case 2: {
                    string = UtilDataConversions.bytesToString((byte[])this.data, ((byte[])this.data).length);
                    break;
                }
                case 101: {
                    string = this.sqlserverUniqueidentifierToString();
                    break;
                }
                case 102: 
                case 103: {
                    string = this.sqlserverDateTimeToTimestamp().toString();
                    break;
                }
                case 14: {
                    byte[] byArray = this.getBytes(n, baseExceptions);
                    string = UtilDataConversions.bytesToString(byArray, byArray.length);
                    break;
                }
                case 15: 
                case 17: {
                    long l;
                    int n2 = -1;
                    if (this.data instanceof BaseInputStreamWrapper && (l = ((BaseInputStreamWrapper)this.data).numTotalBytesInStream) > 0L && l <= Integer.MAX_VALUE) {
                        n2 = new Long(l).intValue();
                    }
                    if (n2 == -1) {
                        n2 = 10240;
                    }
                    StringBuffer stringBuffer = new StringBuffer(n2);
                    boolean bl = false;
                    byte[] byArray = new byte[n2];
                    boolean bl2 = false;
                    while (!bl2) {
                        int n3;
                        try {
                            n3 = ((InputStream)this.data).read(byArray, 0, byArray.length);
                        }
                        catch (IOException iOException) {
                            throw baseExceptions.getException(iOException);
                        }
                        if (n3 == -1) {
                            bl2 = true;
                            try {
                                ((InputStream)this.data).close();
                                continue;
                            }
                            catch (IOException iOException) {
                                throw baseExceptions.getException(iOException);
                            }
                        }
                        if (this.type == 15) {
                            stringBuffer.append(UtilDataConversions.ASCIIBytesToString(byArray, n3));
                            continue;
                        }
                        stringBuffer.append(UtilDataConversions.UCS2BytesToString(byArray, n3));
                    }
                    string = stringBuffer.toString();
                    break;
                }
                case 18: {
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean bl = false;
                    char[] cArray = new char[1024];
                    boolean bl3 = false;
                    while (!bl3) {
                        int n4;
                        try {
                            n4 = ((Reader)this.data).read(cArray, 0, cArray.length);
                        }
                        catch (IOException iOException) {
                            throw baseExceptions.getException(iOException);
                        }
                        if (n4 == -1) {
                            bl3 = true;
                            try {
                                ((Reader)this.data).close();
                                continue;
                            }
                            catch (IOException iOException) {
                                throw baseExceptions.getException(iOException);
                            }
                        }
                        stringBuffer.append(cArray, 0, n4);
                    }
                    string = stringBuffer.toString();
                    break;
                }
                case 20: {
                    Clob clob = this.getClob(null, baseExceptions);
                    int n5 = new Long(clob.length()).intValue();
                    if (n >= 0 && n5 > n) {
                        n5 = n;
                    }
                    string = clob.getSubString(1L, n5);
                    break;
                }
                case 19: {
                    Blob blob = this.getBlob(null, baseExceptions);
                    int n6 = new Long(blob.length()).intValue();
                    if (n >= 0 && n6 > n / 2) {
                        n6 = n / 2;
                    }
                    byte[] byArray = blob.getBytes(1L, n6);
                    string = UtilDataConversions.bytesToString(byArray, byArray.length);
                    break;
                }
                case 1: {
                    string = String.valueOf(this.byteValue);
                    break;
                }
                case 9: {
                    string = String.valueOf(this.booleanValue);
                    break;
                }
                case 4: {
                    string = String.valueOf(this.intValue);
                    break;
                }
                case 3: {
                    string = String.valueOf(this.shortValue);
                    break;
                }
                case 5: {
                    string = String.valueOf(this.longValue);
                    break;
                }
                case 7: {
                    string = String.valueOf(this.doubleValue);
                    break;
                }
                case 6: {
                    string = String.valueOf(this.floatValue);
                    break;
                }
                case 16: {
                    this.unsupportedConversion(baseExceptions);
                }
                default: {
                    string = this.data.toString();
                }
            }
            if (n != -1 && string.length() > n) {
                string = string.substring(0, n);
            }
            return string;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Date getDateNoConvert() {
        switch (this.type) {
            case 102: 
            case 103: {
                Timestamp timestamp = this.sqlserverDateTimeToTimestamp();
                return new Date(timestamp.getYear(), timestamp.getMonth(), timestamp.getDate());
            }
        }
        return (Date)this.data;
    }

    public Date getDate(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 10: 
                case 11: 
                case 13: 
                case 15: 
                case 17: 
                case 18: 
                case 102: 
                case 103: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Date date = null;
            switch (this.type) {
                case 11: {
                    date = (Date)this.data;
                    break;
                }
                case 10: {
                    date = Date.valueOf(((String)this.data).trim());
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    date = Date.valueOf(this.getString(-1, baseExceptions).trim());
                    break;
                }
                case 102: 
                case 103: {
                    Timestamp timestamp = this.sqlserverDateTimeToTimestamp();
                    date = new Date(timestamp.getYear(), timestamp.getMonth(), timestamp.getDate());
                    break;
                }
                case 13: {
                    Timestamp timestamp = (Timestamp)this.data;
                    date = new Date(timestamp.getYear(), timestamp.getMonth(), timestamp.getDate());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return date;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Date getDate(Calendar calendar, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 11: 
                case 13: 
                case 102: 
                case 103: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            switch (this.type) {
                case 102: 
                case 103: {
                    return this.applyCalendarToSqlServerDate(calendar);
                }
                case 11: {
                    return BaseData.applyCalender((Date)this.data, calendar, false);
                }
                case 13: {
                    Date date = this.getDate(baseExceptions);
                    return BaseData.applyCalender(date, calendar, false);
                }
            }
            this.unsupportedConversion(baseExceptions);
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Time getTimeNoConvert() {
        switch (this.type) {
            case 102: 
            case 103: {
                Timestamp timestamp = this.sqlserverDateTimeToTimestamp();
                return new Time(timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds());
            }
        }
        return (Time)this.data;
    }

    public Time getTime(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 18: 
                case 102: 
                case 103: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Time time = null;
            switch (this.type) {
                case 12: {
                    time = (Time)this.data;
                    break;
                }
                case 10: {
                    time = Time.valueOf(((String)this.data).trim());
                    break;
                }
                case 102: 
                case 103: {
                    Timestamp timestamp = this.sqlserverDateTimeToTimestamp();
                    time = new Time(timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds());
                    break;
                }
                case 13: {
                    Timestamp timestamp = (Timestamp)this.data;
                    time = new Time(timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds());
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    time = Time.valueOf(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return time;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Time getTime(Calendar calendar, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 12: 
                case 13: 
                case 102: 
                case 103: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            switch (this.type) {
                case 102: 
                case 103: {
                    return this.applyCalendarToSqlServerTime(calendar);
                }
                case 12: {
                    return BaseData.applyCalender((Time)this.data, calendar, false);
                }
                case 13: {
                    Time time = this.getTime(baseExceptions);
                    return BaseData.applyCalender(time, calendar, false);
                }
            }
            this.unsupportedConversion(baseExceptions);
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Timestamp getTimestampNoConvert() {
        switch (this.type) {
            case 102: 
            case 103: {
                return this.sqlserverDateTimeToTimestamp();
            }
        }
        return (Timestamp)this.data;
    }

    public Timestamp getTimestamp(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 18: 
                case 102: 
                case 103: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Timestamp timestamp = null;
            switch (this.type) {
                case 102: 
                case 103: {
                    timestamp = this.sqlserverDateTimeToTimestamp();
                    break;
                }
                case 13: {
                    timestamp = (Timestamp)this.data;
                    break;
                }
                case 10: {
                    timestamp = Timestamp.valueOf(((String)this.data).trim());
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    timestamp = Timestamp.valueOf(string.trim());
                    break;
                }
                case 11: 
                case 12: {
                    if (this.data == null) break;
                    Calendar calendar = Calendar.getInstance();
                    if (this.type == 12) {
                        calendar.setTime((Time)this.data);
                        calendar.set(1, 1970);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                    } else {
                        calendar.setTime((Date)this.data);
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    }
                    timestamp = new Timestamp(calendar.getTime().getTime());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return timestamp;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Timestamp getTimestamp(Calendar calendar, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 11: 
                case 12: 
                case 13: 
                case 102: 
                case 103: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            switch (this.type) {
                case 102: 
                case 103: {
                    return this.applyCalendarToSqlServerTimestamp(calendar);
                }
                case 13: {
                    return BaseData.applyCalender((Timestamp)this.data, calendar, false);
                }
                case 12: {
                    return new BaseData(12, BaseData.applyCalender((Time)this.data, calendar, false)).getTimestamp(baseExceptions);
                }
                case 11: {
                    return new BaseData(11, BaseData.applyCalender((Date)this.data, calendar, false)).getTimestamp(baseExceptions);
                }
            }
            this.unsupportedConversion(baseExceptions);
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public InputStream getBinaryStreamNoConvert() {
        return (InputStream)this.data;
    }

    public InputStream getBinaryStream(int n, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 2: 
                case 14: 
                case 19: 
                case 101: 
                case 102: 
                case 103: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            int n2 = -1;
            switch (this.type) {
                case 14: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                case 2: 
                case 101: 
                case 102: 
                case 103: {
                    inputStream = new ByteArrayInputStream((byte[])this.data);
                    n2 = ((byte[])this.data).length;
                    break;
                }
                case 19: {
                    inputStream = this.getBlob(baseConnection, baseExceptions).getBinaryStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (inputStream != null && this.needWrapper) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, n2, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public InputStream getBinaryStream(int n, BaseConnection baseConnection, BaseExceptions baseExceptions, boolean bl) throws SQLException {
        if (this.isNull) {
            switch (this.type) {
                case 2: 
                case 14: 
                case 19: 
                case 101: 
                case 102: 
                case 103: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            int n2 = -1;
            switch (this.type) {
                case 14: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                case 2: 
                case 101: 
                case 102: 
                case 103: {
                    inputStream = new ByteArrayInputStream((byte[])this.data);
                    n2 = ((byte[])this.data).length;
                    break;
                }
                case 19: {
                    Blob blob = this.getBlob(baseConnection, baseExceptions);
                    if (blob instanceof BaseBlob) {
                        inputStream = ((BaseBlob)blob).getBinaryStream(bl);
                        break;
                    }
                    inputStream = blob.getBinaryStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (inputStream != null && this.needWrapper) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, n2, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public InputStream getUTF8InputStream(int n, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.type == 16) {
                return null;
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            switch (this.type) {
                case 16: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, -1L, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public InputStream getUCS2InputStream(int n, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.type == 17) {
                return null;
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            switch (this.type) {
                case 17: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                default: {
                    Reader reader = this.getCharacterStreamReader(n, baseConnection, baseExceptions);
                    if (reader == null) break;
                    inputStream = new UtilCharacterReaderToUCS2InputStream(reader);
                }
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, -1L, baseConnection, baseExceptions);
                }
                if (n != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Clob getClobNoConvert() {
        return (Clob)this.data;
    }

    public Clob getClob(BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.type == 20) {
                return null;
            }
            this.getString(0, baseExceptions);
            return null;
        }
        try {
            Clob clob = null;
            switch (this.type) {
                case 20: {
                    if (this.data == null) break;
                    if (this.data instanceof BaseImplClob) {
                        this.data = new BaseClob((BaseImplClob)this.data, baseConnection, baseExceptions);
                    }
                    clob = (Clob)this.data;
                    break;
                }
                default: {
                    this.needWrapper = false;
                    Reader reader = this.getCharacterStreamReader(-1, baseConnection, baseExceptions);
                    this.needWrapper = true;
                    BaseImplClobEmulated baseImplClobEmulated = new BaseImplClobEmulated(baseExceptions, reader);
                    clob = new BaseClob(baseImplClobEmulated, baseConnection, baseExceptions);
                }
            }
            return clob;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    static Date applyCalender(Date date, Calendar calendar, boolean bl) {
        calendar = (Calendar)calendar.clone();
        if (bl) {
            calendar.setTime(date);
            int n = calendar.get(1) - 1900;
            int n2 = calendar.get(2);
            int n3 = calendar.get(5);
            return new Date(n, n2, n3);
        }
        calendar.clear();
        calendar.set(date.getYear() + 1900, date.getMonth(), date.getDate(), 0, 0, 0);
        return new Date(calendar.getTime().getTime());
    }

    static Time applyCalender(Time time, Calendar calendar, boolean bl) {
        calendar = (Calendar)calendar.clone();
        if (bl) {
            calendar.setTime(time);
            int n = calendar.get(11);
            int n2 = calendar.get(12);
            int n3 = calendar.get(13);
            return new Time(n, n2, n3);
        }
        calendar.clear();
        calendar.set(1970, 0, 1, time.getHours(), time.getMinutes(), time.getSeconds());
        return new Time(calendar.getTime().getTime());
    }

    static Timestamp applyCalender(Timestamp timestamp, Calendar calendar, boolean bl) {
        calendar = (Calendar)calendar.clone();
        if (bl) {
            calendar.setTime(timestamp);
            int n = calendar.get(1) - 1900;
            int n2 = calendar.get(2);
            int n3 = calendar.get(5);
            int n4 = calendar.get(11);
            int n5 = calendar.get(12);
            int n6 = calendar.get(13);
            int n7 = timestamp.getNanos();
            timestamp = new Timestamp(n, n2, n3, n4, n5, n6, n7);
        } else {
            int n = timestamp.getYear();
            int n8 = timestamp.getMonth();
            int n9 = timestamp.getDate();
            int n10 = timestamp.getHours();
            int n11 = timestamp.getMinutes();
            int n12 = timestamp.getSeconds();
            int n13 = timestamp.getNanos();
            calendar.clear();
            calendar.set(n + 1900, n8, n9, n10, n11, n12);
            timestamp = new Timestamp(calendar.getTime().getTime());
            timestamp.setNanos(n13);
        }
        return timestamp;
    }

    final void unsupportedConversion(BaseExceptions baseExceptions) throws SQLException {
        switch (this.type) {
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                try {
                    ((InputStream)this.data).close();
                }
                catch (Exception exception) {}
                break;
            }
            case 18: {
                try {
                    ((Reader)this.data).close();
                }
                catch (Exception exception) {}
                break;
            }
            case 19: {
                try {
                    ((BaseImplBlob)this.data).close();
                }
                catch (Exception exception) {}
                break;
            }
            case 20: {
                try {
                    ((BaseImplClob)this.data).close();
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw baseExceptions.getException(6008);
    }

    private String sqlserverUniqueidentifierToString() {
        byte[] byArray = (byte[])this.data;
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = new char[]{cArray[byArray[3] >> 4 & 0xF], cArray[byArray[3] & 0xF], cArray[byArray[2] >> 4 & 0xF], cArray[byArray[2] & 0xF], cArray[byArray[1] >> 4 & 0xF], cArray[byArray[1] & 0xF], cArray[byArray[0] >> 4 & 0xF], cArray[byArray[0] & 0xF], '-', cArray[byArray[5] >> 4 & 0xF], cArray[byArray[5] & 0xF], cArray[byArray[4] >> 4 & 0xF], cArray[byArray[4] & 0xF], '-', cArray[byArray[7] >> 4 & 0xF], cArray[byArray[7] & 0xF], cArray[byArray[6] >> 4 & 0xF], cArray[byArray[6] & 0xF], '-', cArray[byArray[8] >> 4 & 0xF], cArray[byArray[8] & 0xF], cArray[byArray[9] >> 4 & 0xF], cArray[byArray[9] & 0xF], '-', cArray[byArray[10] >> 4 & 0xF], cArray[byArray[10] & 0xF], cArray[byArray[11] >> 4 & 0xF], cArray[byArray[11] & 0xF], cArray[byArray[12] >> 4 & 0xF], cArray[byArray[12] & 0xF], cArray[byArray[13] >> 4 & 0xF], cArray[byArray[13] & 0xF], cArray[byArray[14] >> 4 & 0xF], cArray[byArray[14] & 0xF], cArray[byArray[15] >> 4 & 0xF], cArray[byArray[15] & 0xF]};
        return new String(cArray2);
    }

    private Time applyCalendarToSqlServerTime(Calendar calendar) {
        int[] nArray = new int[3];
        this.sqlserverDateTimeValues(nArray);
        calendar = (Calendar)calendar.clone();
        calendar.clear();
        calendar.set(1970, 0, 1, 0, 0, nArray[1]);
        return new Time(calendar.getTime().getTime());
    }

    private Date applyCalendarToSqlServerDate(Calendar calendar) {
        int[] nArray = new int[3];
        this.sqlserverDateTimeValues(nArray);
        calendar = (Calendar)calendar.clone();
        calendar.clear();
        calendar.set(1900, 0, nArray[0], 0, 0, nArray[1]);
        return new Date(calendar.getTime().getTime());
    }

    private Timestamp applyCalendarToSqlServerTimestamp(Calendar calendar) {
        int[] nArray = new int[3];
        this.sqlserverDateTimeValues(nArray);
        calendar = (Calendar)calendar.clone();
        calendar.clear();
        calendar.set(1900, 0, nArray[0], 0, 0, nArray[1]);
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        timestamp.setNanos(nArray[2]);
        return timestamp;
    }

    private Timestamp sqlserverDateTimeToTimestamp() {
        int[] nArray = new int[3];
        this.sqlserverDateTimeValues(nArray);
        return new Timestamp(0, 0, nArray[0], 0, 0, nArray[1], nArray[2]);
    }

    private void sqlserverDateTimeValues(int[] nArray) {
        int n;
        int n2;
        byte[] byArray = (byte[])this.data;
        if (this.type == 102) {
            int n3;
            n2 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | byArray[3] << 24;
            int n4 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | byArray[7] << 24;
            n = n4 / 300;
            int n5 = n4 - n * 300;
            nArray[2] = n3 = (n5 * 10 + 1) / 3 * 1000000;
        } else {
            n2 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
            n = (byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8) * 60;
            nArray[2] = 0;
        }
        nArray[0] = ++n2;
        nArray[1] = n;
    }
}

