/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseCharacterStreamWrapper;
import com.metamatrix.jdbc.slbase.BaseClobInputStream;
import com.metamatrix.jdbc.slbase.BaseClobOutputStream;
import com.metamatrix.jdbc.slbase.BaseConnection;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseImplClob;
import com.metamatrix.jdbc.slbase.BaseImplClobChunked;
import com.metamatrix.jdbc.slbase.BaseImplClobSearchable;
import com.metamatrix.jdbc.slbase.BaseImplClobService;
import com.metamatrix.jdbc.slbase.BaseInputStreamWrapper;
import com.metamatrix.slutil.UtilDataConversions;
import com.metamatrix.slutil.UtilDebug;
import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilTransliterator;
import com.metamatrix.slutil.UtilTransliteratorForASCII;
import com.metamatrix.slutil.UtilTransliteratorForUCS2;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class BaseClob
implements Clob {
    private BaseImplClob implClob;
    private Object lastInputStream;
    private Object lastOutputStream;
    private boolean deferSearchEmulation;
    private UtilTransliterator transliterator;
    BaseConnection connection;
    Object synchronizer;
    BaseExceptions exceptions;

    public BaseClob(BaseImplClob baseImplClob, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        this(baseImplClob, baseConnection, true, baseExceptions);
        this.connection = baseConnection;
        this.synchronizer = baseConnection != null ? baseConnection : this;
    }

    public BaseClob(BaseImplClob baseImplClob, BaseConnection baseConnection, boolean bl, BaseExceptions baseExceptions) throws SQLException {
        UtilDebug.assert("Must supply a native Clob implementation", baseImplClob != null);
        UtilDebug.assert("Must supply a BaseExceptions object", baseExceptions != null);
        this.implClob = baseImplClob;
        this.deferSearchEmulation = bl;
        this.exceptions = baseExceptions;
        this.connection = baseConnection;
        this.synchronizer = baseConnection != null ? baseConnection : this;
        this.lastInputStream = null;
        this.lastOutputStream = null;
        this.chainInClobServices();
    }

    public BaseImplClob getNativeImplClob() {
        BaseImplClob baseImplClob = this.implClob;
        while (baseImplClob instanceof BaseImplClobService) {
            baseImplClob = ((BaseImplClobService)baseImplClob).getChainedImplClob();
        }
        return baseImplClob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implClob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.implClob.getLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubString(long l, int n) throws SQLException {
        if (l <= 0L || n < 0) {
            String[] stringArray = new String[]{"Clob.getSubString"};
            throw this.exceptions.getException(6069, stringArray);
        }
        Object object = this.synchronizer;
        synchronized (object) {
            String string;
            if (this.implClob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            long l2 = this.length();
            if (l - 1L > l2) {
                throw this.exceptions.getException(6077);
            }
            if (l - 1L + (long)n > l2) {
                try {
                    n = new Long(l2 - (l - 1L)).intValue();
                }
                catch (Exception exception) {
                    throw this.exceptions.getException(6065);
                }
            }
            int n2 = this.implClob.getCharacterEncoding();
            switch (n2) {
                case 1: {
                    byte[] byArray = new byte[n];
                    int n3 = this.implClob.readData(byArray, 0, l, n);
                    string = UtilDataConversions.ASCIIBytesToString(byArray, n3);
                    break;
                }
                case 2: {
                    byte[] byArray = new byte[n * 2];
                    int n4 = this.implClob.readData(byArray, 0, l, n);
                    string = UtilDataConversions.UCS2BytesToString(byArray, n4);
                    break;
                }
                default: {
                    throw this.exceptions.getException(6024);
                }
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream() throws SQLException {
        Reader reader = null;
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implClob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseClobInputStream baseClobInputStream = new BaseClobInputStream(this, this.implClob, this.exceptions);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(baseClobInputStream);
            long l = this.implClob.getLength();
            try {
                reader = this.getTransliterator().decodeAsReader(bufferedInputStream);
            }
            catch (UtilException utilException) {
                throw this.exceptions.getException(utilException);
            }
            reader = new BaseCharacterStreamWrapper(reader, l, this.connection, this.exceptions);
            this.setLastInputStream(reader);
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(boolean bl) throws SQLException {
        Reader reader = null;
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implClob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseClobInputStream baseClobInputStream = new BaseClobInputStream(this, this.implClob, this.exceptions);
            baseClobInputStream.closeImplClobOnClose = bl;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(baseClobInputStream);
            long l = this.implClob.getLength();
            try {
                reader = this.getTransliterator().decodeAsReader(bufferedInputStream);
            }
            catch (UtilException utilException) {
                throw this.exceptions.getException(utilException);
            }
            reader = new BaseCharacterStreamWrapper(reader, l, this.connection, this.exceptions);
            this.setLastInputStream(reader);
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream() throws SQLException {
        InputStream inputStream = null;
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implClob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseClobInputStream baseClobInputStream = new BaseClobInputStream(this, this.implClob, this.exceptions);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(baseClobInputStream);
            long l = this.implClob.getLength();
            try {
                inputStream = this.getTransliterator().decodeAsAsciiStream(bufferedInputStream);
            }
            catch (UtilException utilException) {
                throw this.exceptions.getException(utilException);
            }
            inputStream = new BaseInputStreamWrapper(inputStream, l, this.connection, this.exceptions);
            this.setLastInputStream(inputStream);
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(boolean bl) throws SQLException {
        InputStream inputStream = null;
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implClob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseClobInputStream baseClobInputStream = new BaseClobInputStream(this, this.implClob, this.exceptions);
            baseClobInputStream.closeImplClobOnClose = bl;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(baseClobInputStream);
            long l = this.implClob.getLength();
            try {
                inputStream = this.getTransliterator().decodeAsAsciiStream(bufferedInputStream);
            }
            catch (UtilException utilException) {
                throw this.exceptions.getException(utilException);
            }
            inputStream = new BaseInputStreamWrapper(inputStream, l, this.connection, this.exceptions);
            this.setLastInputStream(inputStream);
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(String string, long l) throws SQLException {
        if (string == null || l <= 0L) {
            String[] stringArray = new String[]{"Clob.position"};
            throw this.exceptions.getException(6069, stringArray);
        }
        if (l >= this.length()) {
            throw this.exceptions.getException(6077);
        }
        if (this.deferSearchEmulation) {
            this.deferSearchEmulation = false;
            this.chainInClobServices();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implClob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.implClob.find(string, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(Clob clob, long l) throws SQLException {
        if (clob == null || l <= 0L) {
            String[] stringArray = new String[]{"Clob.position"};
            throw this.exceptions.getException(6069, stringArray);
        }
        if (l >= this.length()) {
            throw this.exceptions.getException(6077);
        }
        if (this.deferSearchEmulation) {
            this.deferSearchEmulation = false;
            this.chainInClobServices();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            int n;
            if (this.implClob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            try {
                n = new Long(clob.length()).intValue();
            }
            catch (Exception exception) {
                throw this.exceptions.getException(6064);
            }
            return this.implClob.find(clob.getSubString(1L, n), l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream setAsciiStream(long l) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implClob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (l <= 0L) {
                String[] stringArray = new String[]{"setAsciiStream"};
                throw this.exceptions.getException(6069, stringArray);
            }
            BaseClobOutputStream baseClobOutputStream = new BaseClobOutputStream(this, this.implClob, l, this.synchronizer, this.exceptions);
            baseClobOutputStream.setAsciiStream(true);
            this.setLastOutputStream(baseClobOutputStream);
            return baseClobOutputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer setCharacterStream(long l) throws SQLException {
        OutputStreamWriter outputStreamWriter = null;
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implClob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (l <= 0L) {
                String[] stringArray = new String[]{"setCharacterStream"};
                throw this.exceptions.getException(6069, stringArray);
            }
            BaseClobOutputStream baseClobOutputStream = new BaseClobOutputStream(this, this.implClob, l, this.synchronizer, this.exceptions);
            baseClobOutputStream.setAsciiStream(false);
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)baseClobOutputStream, "UTF-16BE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.exceptions.getException(6024);
            }
            this.setLastOutputStream(outputStreamWriter);
            return outputStreamWriter;
        }
    }

    public int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setString(long l, String string, int n, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implClob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 == 0) {
                return 0;
            }
            if (l <= 0L || n < 0 || n + n2 > string.length()) {
                String[] stringArray = new String[]{"setString"};
                throw this.exceptions.getException(6069, stringArray);
            }
            int n3 = this.implClob.getCharacterEncoding();
            byte[] byArray = null;
            int n4 = -1;
            try {
                byArray = string.getBytes(BaseImplClob.getEncodingName(n3));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw this.exceptions.getException(6024);
            }
            switch (n3) {
                case 1: {
                    n4 = this.implClob.writeData(l, byArray, n, n2);
                    break;
                }
                case 2: {
                    n4 = this.implClob.writeData(l, byArray, n * 2, n2);
                    break;
                }
                default: {
                    throw this.exceptions.getException(6024);
                }
            }
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long l) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implClob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (l < 0L || l > this.length()) {
                String[] stringArray = new String[]{"truncate"};
                throw this.exceptions.getException(6069, stringArray);
            }
            this.implClob.truncate(l);
        }
    }

    private void close() throws SQLException {
        this.closeLastInputStream();
        this.closeLastOutputStream();
        this.implClob.close();
    }

    private boolean verifyOpen() {
        return this.implClob != null;
    }

    private void chainInClobServices() throws SQLException {
        int n = new Long(this.implClob.getMaxChunkSize()).intValue();
        if (n > 0) {
            this.implClob = new BaseImplClobChunked(n, this.implClob, this.exceptions);
        }
        if (!this.deferSearchEmulation && !this.implClob.supportsSearch()) {
            this.implClob = new BaseImplClobSearchable(this.implClob, this.exceptions);
        }
    }

    private void setLastInputStream(Object object) {
        this.closeLastInputStream();
        this.lastInputStream = object;
    }

    private void closeLastInputStream() {
        if (this.lastInputStream != null) {
            try {
                if (this.lastInputStream instanceof InputStream) {
                    ((InputStream)this.lastInputStream).close();
                } else if (this.lastInputStream instanceof Reader) {
                    ((Reader)this.lastInputStream).close();
                } else {
                    UtilDebug.assert("Invalid lastInputStream object", false);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.lastInputStream = null;
        }
    }

    private void setLastOutputStream(Object object) {
        this.closeLastOutputStream();
        this.lastOutputStream = object;
    }

    private void closeLastOutputStream() {
        if (this.lastOutputStream != null) {
            try {
                if (this.lastOutputStream instanceof OutputStream) {
                    ((OutputStream)this.lastOutputStream).close();
                } else if (this.lastOutputStream instanceof Writer) {
                    ((Writer)this.lastOutputStream).close();
                } else {
                    UtilDebug.assert("Invalid lastOutputStream object", false);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.lastOutputStream = null;
        }
    }

    private UtilTransliterator getTransliterator() throws SQLException {
        if (this.transliterator == null) {
            switch (this.implClob.getCharacterEncoding()) {
                case 1: {
                    this.transliterator = new UtilTransliteratorForASCII();
                    break;
                }
                case 2: {
                    this.transliterator = new UtilTransliteratorForUCS2();
                    break;
                }
                default: {
                    throw this.exceptions.getException(6024);
                }
            }
        }
        return this.transliterator;
    }
}

