/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.RDN;
import iaik.utils.InternalErrorException;

public class DistributionPoint {
    private GeneralNames c;
    private int a = -1;
    private ASN1Type b;
    public static int certificateHold;
    public static int cessationOfOperation;
    public static int superseded;
    public static int affiliationChanged;
    public static int cACompromise;
    public static int keyCompromise;
    public static int unused;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.b != null) {
            stringBuffer.append("DistributionPoint: ");
            stringBuffer.append(String.valueOf(this.b.toString()) + "\n");
        }
        if (this.a > 0) {
            stringBuffer.append("reasonFlags: ");
            if ((this.a & unused) > 0) {
                stringBuffer.append("unused | ");
            }
            if ((this.a & keyCompromise) > 0) {
                stringBuffer.append("keyCompromise | ");
            }
            if ((this.a & cACompromise) > 0) {
                stringBuffer.append("cACompromise | ");
            }
            if ((this.a & affiliationChanged) > 0) {
                stringBuffer.append("affiliationChanged|");
            }
            if ((this.a & superseded) > 0) {
                stringBuffer.append("superseded | ");
            }
            if ((this.a & cessationOfOperation) > 0) {
                stringBuffer.append("cessationOfOperation | ");
            }
            if ((this.a & certificateHold) > 0) {
                stringBuffer.append("certificateHold | ");
            }
            stringBuffer.setLength(stringBuffer.length() - 3);
            stringBuffer.append("\n");
        }
        if (this.c != null) {
            stringBuffer.append("CRLIssuer:\n");
            stringBuffer.append(String.valueOf(this.c.toString()) + "\n");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        boolean bl = true;
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.b != null) {
            int n2 = -1;
            if (this.b instanceof GeneralNames) {
                n2 = 0;
            } else if (this.b instanceof RDN) {
                n2 = 1;
            } else {
                throw new InternalErrorException("DistributionPointName: Unknown type [create]!");
            }
            CON_SPEC cON_SPEC = new CON_SPEC(n2, this.b.toASN1Object(), bl);
            sEQUENCE.addComponent(new CON_SPEC(0, cON_SPEC));
        }
        if (this.a != -1) {
            StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(this.a));
            stringBuffer.reverse();
            sEQUENCE.addComponent(new CON_SPEC(1, new BIT_STRING(stringBuffer.toString()), bl));
        }
        if (this.c != null) {
            sEQUENCE.addComponent(new CON_SPEC(2, this.c.toASN1Object(), bl));
        }
        return sEQUENCE;
    }

    public void setReasonFlags(int n2) {
        this.a = n2;
    }

    public void setDistributionPointName(ASN1Type aSN1Type) throws IllegalArgumentException {
        if (!(aSN1Type instanceof GeneralNames) && !(aSN1Type instanceof RDN)) {
            throw new IllegalArgumentException("Only instances of GeneralNames or RDN are accepted!");
        }
        this.b = aSN1Type;
    }

    public void setCrlIssuer(GeneralNames generalNames) {
        this.c = generalNames;
    }

    public int getReasonFlags() {
        return this.a;
    }

    public ASN1Type getDistributionPointName() {
        return this.b;
    }

    public GeneralNames getCrlIssuer() {
        return this.c;
    }

    public DistributionPoint(ASN1Type aSN1Type) throws IllegalArgumentException {
        this.setDistributionPointName(aSN1Type);
    }

    public DistributionPoint(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("No DistributionPoint!");
        }
        int n2 = 0;
        while (n2 < aSN1Object.countComponents()) {
            CON_SPEC cON_SPEC = null;
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(n2);
            if (!aSN1Object2.isA(ASN.CON_SPEC)) {
                throw new CodingException("No DistributionPoint!");
            }
            switch (aSN1Object2.getAsnType().getTag()) {
                case 0: {
                    ASN1Object aSN1Object3;
                    ASN1Object aSN1Object4 = (ASN1Object)aSN1Object2.getValue();
                    if (!aSN1Object4.isA(ASN.CON_SPEC)) {
                        throw new CodingException("No DistributionPoint!");
                    }
                    cON_SPEC = (CON_SPEC)aSN1Object4;
                    int n3 = cON_SPEC.getAsnType().getTag();
                    if (n3 == 0) {
                        if (cON_SPEC.countComponents() > 1) {
                            cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                        }
                        this.b = new GeneralNames((ASN1Object)cON_SPEC.getValue());
                        break;
                    }
                    if (n3 == 1) {
                        if (cON_SPEC.countComponents() > 1) {
                            cON_SPEC.forceImplicitlyTagged(ASN.SET);
                        } else if (cON_SPEC.countComponents() == 1 && !(aSN1Object3 = cON_SPEC.getComponentAt(0)).isA(ASN.SET)) {
                            cON_SPEC.forceImplicitlyTagged(ASN.SET);
                        }
                        this.b = new RDN((ASN1Object)cON_SPEC.getValue());
                        break;
                    }
                    throw new InternalErrorException("DistributionPointName: Unknown type [parse]!");
                }
                case 1: {
                    cON_SPEC = (CON_SPEC)aSN1Object2;
                    if (cON_SPEC.isImplicitlyTagged()) {
                        cON_SPEC.forceImplicitlyTagged(ASN.BIT_STRING);
                    }
                    ASN1Object aSN1Object3 = (BIT_STRING)cON_SPEC.getValue();
                    StringBuffer stringBuffer = new StringBuffer(((BIT_STRING)aSN1Object3).getBinaryString()).reverse();
                    this.a = Integer.parseInt(stringBuffer.toString(), 2);
                    break;
                }
                case 2: {
                    cON_SPEC = (CON_SPEC)aSN1Object2;
                    if (cON_SPEC.countComponents() > 1) {
                        cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                    }
                    this.c = new GeneralNames((ASN1Object)aSN1Object2.getValue());
                    break;
                }
            }
            ++n2;
        }
    }

    public DistributionPoint() {
    }

    static {
        unused = 1;
        keyCompromise = 2;
        cACompromise = 4;
        affiliationChanged = 8;
        superseded = 16;
        cessationOfOperation = 32;
        certificateHold = 64;
    }
}

